/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EFX10;
import org.lwjgl.openal.OpenALException;

public final class EFXUtil {
    private static final int EFFECT = 1111;
    private static final int FILTER = 2222;

    private EFXUtil() {
    }

    public static boolean isEfxSupported() {
        if (!AL.isCreated()) {
            throw new OpenALException("OpenAL has not been created.");
        }
        return ALC10.alcIsExtensionPresent(AL.getDevice(), "ALC_EXT_EFX");
    }

    public static boolean isEffectSupported(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 32768: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or invalid effect type: " + n2);
            }
        }
        return EFXUtil.testSupportGeneric(1111, n2);
    }

    public static boolean isFilterSupported(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or invalid filter type: " + n2);
            }
        }
        return EFXUtil.testSupportGeneric(2222, n2);
    }

    private static boolean testSupportGeneric(int n2, int n3) {
        switch (n2) {
            case 1111: 
            case 2222: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid objectType: " + n2);
            }
        }
        boolean bl2 = false;
        if (EFXUtil.isEfxSupported()) {
            int n4;
            AL10.alGetError();
            int n5 = 0;
            try {
                switch (n2) {
                    case 1111: {
                        n5 = EFX10.alGenEffects();
                        break;
                    }
                    case 2222: {
                        n5 = EFX10.alGenFilters();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid objectType: " + n2);
                    }
                }
                n4 = AL10.alGetError();
            }
            catch (OpenALException openALException) {
                n4 = openALException.getMessage().contains("AL_OUT_OF_MEMORY") ? 40965 : 40964;
            }
            if (n4 == 0) {
                int n6;
                AL10.alGetError();
                try {
                    switch (n2) {
                        case 1111: {
                            EFX10.alEffecti(n5, 32769, n3);
                            break;
                        }
                        case 2222: {
                            EFX10.alFilteri(n5, 32769, n3);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid objectType: " + n2);
                        }
                    }
                    n6 = AL10.alGetError();
                }
                catch (OpenALException openALException) {
                    n6 = 40963;
                }
                if (n6 == 0) {
                    bl2 = true;
                }
                try {
                    switch (n2) {
                        case 1111: {
                            EFX10.alDeleteEffects(n5);
                            break;
                        }
                        case 2222: {
                            EFX10.alDeleteFilters(n5);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid objectType: " + n2);
                        }
                    }
                }
                catch (OpenALException openALException) {}
            } else if (n4 == 40965) {
                throw new OpenALException(n4);
            }
        }
        return bl2;
    }
}

