/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.Util;

public final class ALC10 {
    static final HashMap<Long, ALCcontext> contexts = new HashMap();
    static final HashMap<Long, ALCdevice> devices = new HashMap();
    public static final int ALC_INVALID = 0;
    public static final int ALC_FALSE = 0;
    public static final int ALC_TRUE = 1;
    public static final int ALC_NO_ERROR = 0;
    public static final int ALC_MAJOR_VERSION = 4096;
    public static final int ALC_MINOR_VERSION = 4097;
    public static final int ALC_ATTRIBUTES_SIZE = 4098;
    public static final int ALC_ALL_ATTRIBUTES = 4099;
    public static final int ALC_DEFAULT_DEVICE_SPECIFIER = 4100;
    public static final int ALC_DEVICE_SPECIFIER = 4101;
    public static final int ALC_EXTENSIONS = 4102;
    public static final int ALC_FREQUENCY = 4103;
    public static final int ALC_REFRESH = 4104;
    public static final int ALC_SYNC = 4105;
    public static final int ALC_INVALID_DEVICE = 40961;
    public static final int ALC_INVALID_CONTEXT = 40962;
    public static final int ALC_INVALID_ENUM = 40963;
    public static final int ALC_INVALID_VALUE = 40964;
    public static final int ALC_OUT_OF_MEMORY = 40965;

    static native void initNativeStubs();

    public static String alcGetString(ALCdevice aLCdevice, int n2) {
        ByteBuffer byteBuffer = ALC10.nalcGetString(ALC10.getDevice(aLCdevice), n2);
        Util.checkALCError(aLCdevice);
        return MemoryUtil.decodeUTF8(byteBuffer);
    }

    static native ByteBuffer nalcGetString(long var0, int var2);

    public static void alcGetInteger(ALCdevice aLCdevice, int n2, IntBuffer intBuffer) {
        BufferChecks.checkDirect(intBuffer);
        ALC10.nalcGetIntegerv(ALC10.getDevice(aLCdevice), n2, intBuffer.remaining(), MemoryUtil.getAddress(intBuffer));
        Util.checkALCError(aLCdevice);
    }

    static native void nalcGetIntegerv(long var0, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALCdevice alcOpenDevice(String string) {
        ByteBuffer byteBuffer = MemoryUtil.encodeUTF8(string);
        long l2 = ALC10.nalcOpenDevice(MemoryUtil.getAddressSafe(byteBuffer));
        if (l2 != 0L) {
            ALCdevice aLCdevice = new ALCdevice(l2);
            HashMap<Long, ALCdevice> hashMap = devices;
            synchronized (hashMap) {
                devices.put(l2, aLCdevice);
            }
            return aLCdevice;
        }
        return null;
    }

    static native long nalcOpenDevice(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean alcCloseDevice(ALCdevice aLCdevice) {
        boolean bl2 = ALC10.nalcCloseDevice(ALC10.getDevice(aLCdevice));
        HashMap<Long, ALCdevice> hashMap = devices;
        synchronized (hashMap) {
            aLCdevice.setInvalid();
            devices.remove(new Long(aLCdevice.device));
        }
        return bl2;
    }

    static native boolean nalcCloseDevice(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALCcontext alcCreateContext(ALCdevice aLCdevice, IntBuffer intBuffer) {
        long l2 = ALC10.nalcCreateContext(ALC10.getDevice(aLCdevice), MemoryUtil.getAddressSafe(intBuffer));
        Util.checkALCError(aLCdevice);
        if (l2 != 0L) {
            ALCcontext aLCcontext = new ALCcontext(l2);
            HashMap<Long, ALCcontext> hashMap = contexts;
            synchronized (hashMap) {
                contexts.put(l2, aLCcontext);
                aLCdevice.addContext(aLCcontext);
            }
            return aLCcontext;
        }
        return null;
    }

    static native long nalcCreateContext(long var0, long var2);

    public static int alcMakeContextCurrent(ALCcontext aLCcontext) {
        return ALC10.nalcMakeContextCurrent(ALC10.getContext(aLCcontext));
    }

    static native int nalcMakeContextCurrent(long var0);

    public static void alcProcessContext(ALCcontext aLCcontext) {
        ALC10.nalcProcessContext(ALC10.getContext(aLCcontext));
    }

    static native void nalcProcessContext(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALCcontext alcGetCurrentContext() {
        ALCcontext aLCcontext = null;
        long l2 = ALC10.nalcGetCurrentContext();
        if (l2 != 0L) {
            HashMap<Long, ALCcontext> hashMap = contexts;
            synchronized (hashMap) {
                aLCcontext = contexts.get(l2);
            }
        }
        return aLCcontext;
    }

    static native long nalcGetCurrentContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALCdevice alcGetContextsDevice(ALCcontext aLCcontext) {
        ALCdevice aLCdevice = null;
        long l2 = ALC10.nalcGetContextsDevice(ALC10.getContext(aLCcontext));
        if (l2 != 0L) {
            HashMap<Long, ALCdevice> hashMap = devices;
            synchronized (hashMap) {
                aLCdevice = devices.get(l2);
            }
        }
        return aLCdevice;
    }

    static native long nalcGetContextsDevice(long var0);

    public static void alcSuspendContext(ALCcontext aLCcontext) {
        ALC10.nalcSuspendContext(ALC10.getContext(aLCcontext));
    }

    static native void nalcSuspendContext(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void alcDestroyContext(ALCcontext aLCcontext) {
        HashMap<Long, ALCcontext> hashMap = contexts;
        synchronized (hashMap) {
            ALCdevice aLCdevice = ALC10.alcGetContextsDevice(aLCcontext);
            ALC10.nalcDestroyContext(ALC10.getContext(aLCcontext));
            aLCdevice.removeContext(aLCcontext);
            aLCcontext.setInvalid();
        }
    }

    static native void nalcDestroyContext(long var0);

    public static int alcGetError(ALCdevice aLCdevice) {
        return ALC10.nalcGetError(ALC10.getDevice(aLCdevice));
    }

    static native int nalcGetError(long var0);

    public static boolean alcIsExtensionPresent(ALCdevice aLCdevice, String string) {
        ByteBuffer byteBuffer = MemoryUtil.encodeASCII(string);
        boolean bl2 = ALC10.nalcIsExtensionPresent(ALC10.getDevice(aLCdevice), MemoryUtil.getAddress(byteBuffer));
        Util.checkALCError(aLCdevice);
        return bl2;
    }

    private static native boolean nalcIsExtensionPresent(long var0, long var2);

    public static int alcGetEnumValue(ALCdevice aLCdevice, String string) {
        ByteBuffer byteBuffer = MemoryUtil.encodeASCII(string);
        int n2 = ALC10.nalcGetEnumValue(ALC10.getDevice(aLCdevice), MemoryUtil.getAddress(byteBuffer));
        Util.checkALCError(aLCdevice);
        return n2;
    }

    private static native int nalcGetEnumValue(long var0, long var2);

    static long getDevice(ALCdevice aLCdevice) {
        if (aLCdevice != null) {
            Util.checkALCValidDevice(aLCdevice);
            return aLCdevice.device;
        }
        return 0L;
    }

    static long getContext(ALCcontext aLCcontext) {
        if (aLCcontext != null) {
            Util.checkALCValidContext(aLCcontext);
            return aLCcontext.context;
        }
        return 0L;
    }
}

