/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.EFX10;

public final class AL {
    static ALCdevice device;
    static ALCcontext context;
    private static boolean created;

    private AL() {
    }

    private static native void nCreate(String var0);

    private static native void nCreateDefault();

    private static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    public static void create(String string, int n2, int n3, boolean bl2) {
        AL.create(string, n2, n3, bl2, true);
    }

    public static void create(String string, int n2, int n3, boolean bl2, boolean bl3) {
        String[] stringArray;
        String string2;
        if (created) {
            throw new IllegalStateException("Only one OpenAL context may be instantiated at any one time.");
        }
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                if (Sys.is64Bit()) {
                    string2 = "OpenAL64";
                    stringArray = new String[]{"OpenAL64.dll"};
                    break;
                }
                string2 = "OpenAL32";
                stringArray = new String[]{"OpenAL32.dll"};
                break;
            }
            case 1: {
                string2 = "openal";
                stringArray = new String[]{"libopenal64.so", "libopenal.so", "libopenal.so.0"};
                break;
            }
            case 2: {
                string2 = "openal";
                stringArray = new String[]{"openal.dylib"};
                break;
            }
            default: {
                throw new LWJGLException("Unknown platform: " + LWJGLUtil.getPlatform());
            }
        }
        String[] stringArray2 = LWJGLUtil.getLibraryPaths(string2, stringArray, AL.class.getClassLoader());
        LWJGLUtil.log("Found " + stringArray2.length + " OpenAL paths");
        for (String string3 : stringArray2) {
            try {
                AL.nCreate(string3);
                created = true;
                AL.init(string, n2, n3, bl2, bl3);
                break;
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to load " + string3 + ": " + lWJGLException.getMessage());
            }
        }
        if (!created && LWJGLUtil.getPlatform() == 2) {
            AL.nCreateDefault();
            created = true;
            AL.init(string, n2, n3, bl2, bl3);
        }
        if (!created) {
            throw new LWJGLException("Could not locate OpenAL library.");
        }
    }

    private static void init(String string, int n2, int n3, boolean bl2, boolean bl3) {
        try {
            AL10.initNativeStubs();
            ALC10.initNativeStubs();
            if (bl3) {
                device = ALC10.alcOpenDevice(string);
                if (device == null) {
                    throw new LWJGLException("Could not open ALC device");
                }
                context = n2 == -1 ? ALC10.alcCreateContext(device, null) : ALC10.alcCreateContext(device, ALCcontext.createAttributeList(n2, n3, bl2 ? 1 : 0));
                ALC10.alcMakeContextCurrent(context);
            }
        }
        catch (LWJGLException lWJGLException) {
            AL.destroy();
            throw lWJGLException;
        }
        ALC11.initialize();
        if (ALC10.alcIsExtensionPresent(device, "ALC_EXT_EFX")) {
            EFX10.initNativeStubs();
        }
    }

    public static void create() {
        AL.create(null, 44100, 60, false);
    }

    public static void destroy() {
        if (context != null) {
            ALC10.alcMakeContextCurrent(null);
            ALC10.alcDestroyContext(context);
            context = null;
        }
        if (device != null) {
            boolean bl2 = ALC10.alcCloseDevice(device);
            device = null;
        }
        AL.resetNativeStubs(AL10.class);
        AL.resetNativeStubs(AL11.class);
        AL.resetNativeStubs(ALC10.class);
        AL.resetNativeStubs(ALC11.class);
        AL.resetNativeStubs(EFX10.class);
        if (created) {
            AL.nDestroy();
        }
        created = false;
    }

    private static native void resetNativeStubs(Class var0);

    public static ALCcontext getContext() {
        return context;
    }

    public static ALCdevice getDevice() {
        return device;
    }

    static {
        Sys.initialize();
    }
}

