/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import PRG.aaS;
import PRG.aaT;
import PRG.abb;
import PRG.abc;
import PRG.abf;
import java.util.ArrayList;
import org.lwjgl.input.Controller;
import org.lwjgl.input.ControllerEvent;
import org.lwjgl.input.Controllers;

class JInputController
implements Controller {
    private aaT target;
    private int index;
    private ArrayList<aaS> buttons = new ArrayList();
    private ArrayList<aaS> axes = new ArrayList();
    private ArrayList<aaS> pov = new ArrayList();
    private abf[] rumblers;
    private boolean[] buttonState;
    private float[] povValues;
    private float[] axesValue;
    private float[] axesMax;
    private float[] deadZones;
    private int xaxis = -1;
    private int yaxis = -1;
    private int zaxis = -1;
    private int rxaxis = -1;
    private int ryaxis = -1;
    private int rzaxis = -1;

    JInputController(int n2, aaT aaT2) {
        aaS[] aaSArray;
        this.target = aaT2;
        this.index = n2;
        for (aaS aaS2 : aaSArray = aaT2.getComponents()) {
            if (aaS2.getIdentifier() instanceof aaS.a.b) {
                this.buttons.add(aaS2);
                continue;
            }
            if (aaS2.getIdentifier().equals(aaS.a.a.C)) {
                this.pov.add(aaS2);
                continue;
            }
            this.axes.add(aaS2);
        }
        this.buttonState = new boolean[this.buttons.size()];
        this.povValues = new float[this.pov.size()];
        this.axesValue = new float[this.axes.size()];
        int n3 = 0;
        int n4 = 0;
        for (aaS aaS3 : aaSArray) {
            if (aaS3.getIdentifier() instanceof aaS.a.b) {
                this.buttonState[n3] = aaS3.getPollData() != 0.0f;
                ++n3;
                continue;
            }
            if (aaS3.getIdentifier().equals(aaS.a.a.C)) continue;
            this.axesValue[n4] = aaS3.getPollData();
            if (aaS3.getIdentifier().equals(aaS.a.a.a)) {
                this.xaxis = n4;
            }
            if (aaS3.getIdentifier().equals(aaS.a.a.b)) {
                this.yaxis = n4;
            }
            if (aaS3.getIdentifier().equals(aaS.a.a.c)) {
                this.zaxis = n4;
            }
            if (aaS3.getIdentifier().equals(aaS.a.a.d)) {
                this.rxaxis = n4;
            }
            if (aaS3.getIdentifier().equals(aaS.a.a.e)) {
                this.ryaxis = n4;
            }
            if (aaS3.getIdentifier().equals(aaS.a.a.f)) {
                this.rzaxis = n4;
            }
            ++n4;
        }
        this.axesMax = new float[this.axes.size()];
        this.deadZones = new float[this.axes.size()];
        for (int i2 = 0; i2 < this.axesMax.length; ++i2) {
            this.axesMax[i2] = 1.0f;
            this.deadZones[i2] = 0.05f;
        }
        this.rumblers = aaT2.getRumblers();
    }

    public String getName() {
        String string = this.target.getName();
        return string;
    }

    public int getIndex() {
        return this.index;
    }

    public int getButtonCount() {
        return this.buttons.size();
    }

    public String getButtonName(int n2) {
        return this.buttons.get(n2).getName();
    }

    public boolean isButtonPressed(int n2) {
        return this.buttonState[n2];
    }

    public void poll() {
        this.target.poll();
        abb abb2 = new abb();
        abc abc2 = this.target.getEventQueue();
        while (abc2.b(abb2)) {
            float f2;
            float f3;
            int n2;
            aaS aaS2;
            if (this.buttons.contains(abb2.a())) {
                aaS2 = abb2.a();
                n2 = this.buttons.indexOf(aaS2);
                this.buttonState[n2] = abb2.b() != 0.0f;
                Controllers.addEvent(new ControllerEvent(this, abb2.c(), 1, n2, this.buttonState[n2], false, false, 0.0f, 0.0f));
            }
            if (this.pov.contains(abb2.a())) {
                aaS2 = abb2.a();
                n2 = this.pov.indexOf(aaS2);
                f3 = this.getPovX();
                f2 = this.getPovY();
                this.povValues[n2] = abb2.b();
                if (f3 != this.getPovX()) {
                    Controllers.addEvent(new ControllerEvent(this, abb2.c(), 3, 0, false, false));
                }
                if (f2 != this.getPovY()) {
                    Controllers.addEvent(new ControllerEvent(this, abb2.c(), 4, 0, false, false));
                }
            }
            if (!this.axes.contains(abb2.a())) continue;
            aaS2 = abb2.a();
            n2 = this.axes.indexOf(aaS2);
            f3 = aaS2.getPollData();
            f2 = 0.0f;
            float f4 = 0.0f;
            if (Math.abs(f3) < this.deadZones[n2]) {
                f3 = 0.0f;
            }
            if (Math.abs(f3) < aaS2.getDeadZone()) {
                f3 = 0.0f;
            }
            if (Math.abs(f3) > this.axesMax[n2]) {
                this.axesMax[n2] = Math.abs(f3);
            }
            f3 /= this.axesMax[n2];
            if (n2 == this.xaxis) {
                f2 = f3;
            }
            if (n2 == this.yaxis) {
                f4 = f3;
            }
            Controllers.addEvent(new ControllerEvent(this, abb2.c(), 2, n2, false, n2 == this.xaxis, n2 == this.yaxis, f2, f4));
            this.axesValue[n2] = f3;
        }
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public String getAxisName(int n2) {
        return this.axes.get(n2).getName();
    }

    public float getAxisValue(int n2) {
        return this.axesValue[n2];
    }

    public float getXAxisValue() {
        if (this.xaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.xaxis);
    }

    public float getYAxisValue() {
        if (this.yaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.yaxis);
    }

    public float getXAxisDeadZone() {
        if (this.xaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.xaxis);
    }

    public float getYAxisDeadZone() {
        if (this.yaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.yaxis);
    }

    public void setXAxisDeadZone(float f2) {
        this.setDeadZone(this.xaxis, f2);
    }

    public void setYAxisDeadZone(float f2) {
        this.setDeadZone(this.yaxis, f2);
    }

    public float getDeadZone(int n2) {
        return this.deadZones[n2];
    }

    public void setDeadZone(int n2, float f2) {
        this.deadZones[n2] = f2;
    }

    public float getZAxisValue() {
        if (this.zaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.zaxis);
    }

    public float getZAxisDeadZone() {
        if (this.zaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.zaxis);
    }

    public void setZAxisDeadZone(float f2) {
        this.setDeadZone(this.zaxis, f2);
    }

    public float getRXAxisValue() {
        if (this.rxaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.rxaxis);
    }

    public float getRXAxisDeadZone() {
        if (this.rxaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.rxaxis);
    }

    public void setRXAxisDeadZone(float f2) {
        this.setDeadZone(this.rxaxis, f2);
    }

    public float getRYAxisValue() {
        if (this.ryaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.ryaxis);
    }

    public float getRYAxisDeadZone() {
        if (this.ryaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.ryaxis);
    }

    public void setRYAxisDeadZone(float f2) {
        this.setDeadZone(this.ryaxis, f2);
    }

    public float getRZAxisValue() {
        if (this.rzaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.rzaxis);
    }

    public float getRZAxisDeadZone() {
        if (this.rzaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.rzaxis);
    }

    public void setRZAxisDeadZone(float f2) {
        this.setDeadZone(this.rzaxis, f2);
    }

    public float getPovX() {
        if (this.pov.size() == 0) {
            return 0.0f;
        }
        float f2 = this.povValues[0];
        if (f2 == 0.875f || f2 == 0.125f || f2 == 1.0f) {
            return -1.0f;
        }
        if (f2 == 0.625f || f2 == 0.375f || f2 == 0.5f) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getPovY() {
        if (this.pov.size() == 0) {
            return 0.0f;
        }
        float f2 = this.povValues[0];
        if (f2 == 0.875f || f2 == 0.625f || f2 == 0.75f) {
            return 1.0f;
        }
        if (f2 == 0.125f || f2 == 0.375f || f2 == 0.25f) {
            return -1.0f;
        }
        return 0.0f;
    }

    public int getRumblerCount() {
        return this.rumblers.length;
    }

    public String getRumblerName(int n2) {
        return this.rumblers[n2].a();
    }

    public void setRumblerStrength(int n2, float f2) {
        this.rumblers[n2].a(f2);
    }
}

