/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;
import org.lwjgl.input.OpenGLPackageAccess;

public class Cursor {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private final CursorElement[] cursors;
    private int index;
    private boolean destroyed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if ((Cursor.getCapabilities() & 1) == 0) {
                throw new LWJGLException("Native cursors not supported");
            }
            BufferChecks.checkBufferSize(intBuffer, n2 * n3 * n6);
            if (intBuffer2 != null) {
                BufferChecks.checkBufferSize(intBuffer2, n6);
            }
            if (!Mouse.isCreated()) {
                throw new IllegalStateException("Mouse must be created before creating cursor objects");
            }
            if (n2 * n3 * n6 > intBuffer.remaining()) {
                throw new IllegalArgumentException("width*height*numImages > images.remaining()");
            }
            if (n4 >= n2 || n4 < 0) {
                throw new IllegalArgumentException("xHotspot > width || xHotspot < 0");
            }
            if (n5 >= n3 || n5 < 0) {
                throw new IllegalArgumentException("yHotspot > height || yHotspot < 0");
            }
            Sys.initialize();
            n5 = n3 - 1 - n5;
            this.cursors = Cursor.createCursors(n2, n3, n4, n5, n6, intBuffer, intBuffer2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinCursorSize() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!Mouse.isCreated()) {
                throw new IllegalStateException("Mouse must be created.");
            }
            return Mouse.getImplementation().getMinCursorSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxCursorSize() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!Mouse.isCreated()) {
                throw new IllegalStateException("Mouse must be created.");
            }
            return Mouse.getImplementation().getMaxCursorSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCapabilities() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (Mouse.getImplementation() != null) {
                return Mouse.getImplementation().getNativeCursorCapabilities();
            }
            return OpenGLPackageAccess.createImplementation().getNativeCursorCapabilities();
        }
    }

    private static CursorElement[] createCursors(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) {
        CursorElement[] cursorElementArray;
        IntBuffer intBuffer3 = BufferUtils.createIntBuffer(intBuffer.remaining());
        Cursor.flipImages(n2, n3, n6, intBuffer, intBuffer3);
        switch (LWJGLUtil.getPlatform()) {
            case 2: {
                Cursor.convertARGBtoABGR(intBuffer3);
                cursorElementArray = new CursorElement[n6];
                for (int i2 = 0; i2 < n6; ++i2) {
                    Object object = Mouse.getImplementation().createCursor(n2, n3, n4, n5, 1, intBuffer3, null);
                    long l2 = intBuffer2 != null ? (long)intBuffer2.get(i2) : 0L;
                    long l3 = System.currentTimeMillis();
                    cursorElementArray[i2] = new CursorElement(object, l2, l3);
                    intBuffer3.position(n2 * n3 * (i2 + 1));
                }
                break;
            }
            case 3: {
                cursorElementArray = new CursorElement[n6];
                for (int i3 = 0; i3 < n6; ++i3) {
                    int n7 = n2 * n3;
                    for (int i4 = 0; i4 < n7; ++i4) {
                        int n8 = i4 + i3 * n7;
                        int n9 = intBuffer3.get(n8) >> 24 & 0xFF;
                        if (n9 == 255) continue;
                        intBuffer3.put(n8, 0);
                    }
                    Object object = Mouse.getImplementation().createCursor(n2, n3, n4, n5, 1, intBuffer3, null);
                    long l4 = intBuffer2 != null ? (long)intBuffer2.get(i3) : 0L;
                    long l5 = System.currentTimeMillis();
                    cursorElementArray[i3] = new CursorElement(object, l4, l5);
                    intBuffer3.position(n2 * n3 * (i3 + 1));
                }
                break;
            }
            case 1: {
                Object object = Mouse.getImplementation().createCursor(n2, n3, n4, n5, n6, intBuffer3, intBuffer2);
                CursorElement cursorElement = new CursorElement(object, -1L, -1L);
                cursorElementArray = new CursorElement[]{cursorElement};
                break;
            }
            default: {
                throw new RuntimeException("Unknown OS");
            }
        }
        return cursorElementArray;
    }

    private static void convertARGBtoABGR(IntBuffer intBuffer) {
        for (int i2 = 0; i2 < intBuffer.limit(); ++i2) {
            int n2 = intBuffer.get(i2);
            byte by2 = (byte)(n2 >>> 24);
            byte by3 = (byte)(n2 >>> 16);
            byte by4 = (byte)(n2 >>> 8);
            byte by5 = (byte)n2;
            int n3 = ((by2 & 0xFF) << 24) + ((by5 & 0xFF) << 16) + ((by4 & 0xFF) << 8) + (by3 & 0xFF);
            intBuffer.put(i2, n3);
        }
    }

    private static void flipImages(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * n2 * n3;
            Cursor.flipImage(n2, n3, n5, intBuffer, intBuffer2);
        }
    }

    private static void flipImage(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2) {
        for (int i2 = 0; i2 < n3 >> 1; ++i2) {
            int n5 = i2 * n2 + n4;
            int n6 = (n3 - i2 - 1) * n2 + n4;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n7 = n5 + i3;
                int n8 = n6 + i3;
                int n9 = intBuffer.get(n7 + intBuffer.position());
                intBuffer2.put(n7, intBuffer.get(n8 + intBuffer.position()));
                intBuffer2.put(n8, n9);
            }
        }
    }

    Object getHandle() {
        this.checkValid();
        return this.cursors[this.index].cursorHandle;
    }

    private void checkValid() {
        if (this.destroyed) {
            throw new IllegalStateException("The cursor is destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (Mouse.getNativeCursor() == this) {
                try {
                    Mouse.setNativeCursor(null);
                }
                catch (LWJGLException lWJGLException) {
                    // empty catch block
                }
            }
            for (CursorElement cursorElement : this.cursors) {
                Mouse.getImplementation().destroyCursor(cursorElement.cursorHandle);
            }
            this.destroyed = true;
        }
    }

    protected void setTimeout() {
        this.checkValid();
        this.cursors[this.index].timeout = System.currentTimeMillis() + this.cursors[this.index].delay;
    }

    protected boolean hasTimedOut() {
        this.checkValid();
        return this.cursors.length > 1 && this.cursors[this.index].timeout < System.currentTimeMillis();
    }

    protected void nextCursor() {
        this.checkValid();
        ++this.index;
        this.index %= this.cursors.length;
    }

    static class CursorElement {
        final Object cursorHandle;
        final long delay;
        long timeout;

        CursorElement(Object object, long l2, long l3) {
            this.cursorHandle = object;
            this.delay = l2;
            this.timeout = l3;
        }
    }
}

