/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import PRG.aaT;
import PRG.aaU;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controller;
import org.lwjgl.input.ControllerEvent;
import org.lwjgl.input.JInputController;

public class Controllers {
    private static ArrayList<JInputController> controllers = new ArrayList();
    private static int controllerCount;
    private static ArrayList<ControllerEvent> events;
    private static ControllerEvent event;
    private static boolean created;

    public static void create() {
        if (created) {
            return;
        }
        try {
            aaU aaU2 = aaU.getDefaultEnvironment();
            aaT[] aaTArray = aaU2.getControllers();
            ArrayList<aaT> arrayList = new ArrayList<aaT>();
            for (aaT aaT2 : aaTArray) {
                if (aaT2.getType().equals(aaT.b.c) || aaT2.getType().equals(aaT.b.b)) continue;
                arrayList.add(aaT2);
            }
            for (aaT aaT3 : arrayList) {
                Controllers.createController(aaT3);
            }
            created = true;
        }
        catch (Throwable throwable) {
            throw new LWJGLException("Failed to initialise controllers", throwable);
        }
    }

    private static void createController(aaT aaT2) {
        aaT[] aaTArray = aaT2.getControllers();
        if (aaTArray.length == 0) {
            JInputController jInputController = new JInputController(controllerCount, aaT2);
            controllers.add(jInputController);
            ++controllerCount;
        } else {
            for (aaT aaT3 : aaTArray) {
                Controllers.createController(aaT3);
            }
        }
    }

    public static Controller getController(int n2) {
        return controllers.get(n2);
    }

    public static int getControllerCount() {
        return controllers.size();
    }

    public static void poll() {
        for (int i2 = 0; i2 < controllers.size(); ++i2) {
            Controllers.getController(i2).poll();
        }
    }

    public static void clearEvents() {
        events.clear();
    }

    public static boolean next() {
        if (events.size() == 0) {
            event = null;
            return false;
        }
        event = events.remove(0);
        return event != null;
    }

    public static boolean isCreated() {
        return created;
    }

    public static void destroy() {
    }

    public static Controller getEventSource() {
        return event.getSource();
    }

    public static int getEventControlIndex() {
        return event.getControlIndex();
    }

    public static boolean isEventButton() {
        return event.isButton();
    }

    public static boolean isEventAxis() {
        return event.isAxis();
    }

    public static boolean isEventXAxis() {
        return event.isXAxis();
    }

    public static boolean isEventYAxis() {
        return event.isYAxis();
    }

    public static boolean isEventPovX() {
        return event.isPovX();
    }

    public static boolean isEventPovY() {
        return event.isPovY();
    }

    public static long getEventNanoseconds() {
        return event.getTimeStamp();
    }

    public static boolean getEventButtonState() {
        return event.getButtonState();
    }

    public static float getEventXAxisValue() {
        return event.getXAxisValue();
    }

    public static float getEventYAxisValue() {
        return event.getYAxisValue();
    }

    static void addEvent(ControllerEvent controllerEvent) {
        if (controllerEvent != null) {
            events.add(controllerEvent);
        }
    }

    static {
        events = new ArrayList();
    }
}

