/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import org.lwjgl.input.Controller;

class ControllerEvent {
    public static final int BUTTON = 1;
    public static final int AXIS = 2;
    public static final int POVX = 3;
    public static final int POVY = 4;
    private Controller source;
    private int index;
    private int type;
    private boolean buttonState;
    private boolean xaxis;
    private boolean yaxis;
    private long timeStamp;
    private float xaxisValue;
    private float yaxisValue;

    ControllerEvent(Controller controller, long l2, int n2, int n3, boolean bl2, boolean bl3) {
        this(controller, l2, n2, n3, false, bl2, bl3, 0.0f, 0.0f);
    }

    ControllerEvent(Controller controller, long l2, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, float f2, float f3) {
        this.source = controller;
        this.timeStamp = l2;
        this.type = n2;
        this.index = n3;
        this.buttonState = bl2;
        this.xaxis = bl3;
        this.yaxis = bl4;
        this.xaxisValue = f2;
        this.yaxisValue = f3;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Controller getSource() {
        return this.source;
    }

    public int getControlIndex() {
        return this.index;
    }

    public boolean isButton() {
        return this.type == 1;
    }

    public boolean getButtonState() {
        return this.buttonState;
    }

    public boolean isAxis() {
        return this.type == 2;
    }

    public boolean isPovY() {
        return this.type == 4;
    }

    public boolean isPovX() {
        return this.type == 3;
    }

    public boolean isXAxis() {
        return this.xaxis;
    }

    public boolean isYAxis() {
        return this.yaxis;
    }

    public float getXAxisValue() {
        return this.xaxisValue;
    }

    public float getYAxisValue() {
        return this.yaxisValue;
    }

    public String toString() {
        return "[" + this.source + " type=" + this.type + " xaxis=" + this.xaxis + " yaxis=" + this.yaxis + "]";
    }
}

