/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.lwjgl.DefaultSysImplementation;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;

final class WindowsSysImplementation
extends DefaultSysImplementation {
    private static final int JNI_VERSION = 24;

    WindowsSysImplementation() {
    }

    public int getRequiredJNIVersion() {
        return 24;
    }

    public long getTimerResolution() {
        return 1000L;
    }

    public long getTime() {
        return WindowsSysImplementation.nGetTime();
    }

    private static native long nGetTime();

    public boolean has64Bit() {
        return true;
    }

    private static long getHwnd() {
        if (!Display.isCreated()) {
            return 0L;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() {
                    Method method = Display.class.getDeclaredMethod("getImplementation", new Class[0]);
                    method.setAccessible(true);
                    Object object = method.invoke(null, new Object[0]);
                    Class<?> clazz = Class.forName("org.lwjgl.opengl.WindowsDisplay");
                    Method method2 = clazz.getDeclaredMethod("getHwnd", new Class[0]);
                    method2.setAccessible(true);
                    return (Long)method2.invoke(object, new Object[0]);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new Error(privilegedActionException);
        }
    }

    public void alert(String string, String string2) {
        if (!Display.isCreated()) {
            WindowsSysImplementation.initCommonControls();
        }
        LWJGLUtil.log(String.format("*** Alert *** %s\n%s\n", string, string2));
        ByteBuffer byteBuffer = MemoryUtil.encodeUTF16(string);
        ByteBuffer byteBuffer2 = MemoryUtil.encodeUTF16(string2);
        WindowsSysImplementation.nAlert(WindowsSysImplementation.getHwnd(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2));
    }

    private static native void nAlert(long var0, long var2, long var4);

    private static native void initCommonControls();

    public boolean openURL(String string) {
        try {
            LWJGLUtil.execPrivileged(new String[]{"rundll32", "url.dll,FileProtocolHandler", string});
            return true;
        }
        catch (Exception exception) {
            LWJGLUtil.log("Failed to open url (" + string + "): " + exception.getMessage());
            return false;
        }
    }

    public String getClipboard() {
        return WindowsSysImplementation.nGetClipboard();
    }

    private static native String nGetClipboard();

    static {
        Sys.initialize();
    }
}

