/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.LinuxSysImplementation;
import org.lwjgl.MacOSXSysImplementation;
import org.lwjgl.SysImplementation;
import org.lwjgl.WindowsSysImplementation;
import org.lwjgl.input.Mouse;

public final class Sys {
    private static final String JNI_LIBRARY_NAME = "lwjgl";
    private static final String VERSION = "2.9.3";
    private static final String POSTFIX64BIT = "64";
    private static final SysImplementation implementation = Sys.createImplementation();
    private static final boolean is64Bit;

    private static void doLoadLibrary(final String string) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String string2 = System.getProperty("org.lwjgl.librarypath");
                if (string2 != null) {
                    System.load(string2 + File.separator + LWJGLUtil.mapLibraryName(string));
                } else {
                    System.loadLibrary(string);
                }
                return null;
            }
        });
    }

    private static void loadLibrary(String string) {
        String string2 = System.getProperty("os.arch");
        boolean bl2 = LWJGLUtil.getPlatform() != 2 && ("amd64".equals(string2) || "x86_64".equals(string2));
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        if (bl2) {
            try {
                Sys.doLoadLibrary(string + POSTFIX64BIT);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                unsatisfiedLinkError = unsatisfiedLinkError2;
            }
        }
        try {
            Sys.doLoadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
            if (bl2) {
                throw unsatisfiedLinkError;
            }
            if (implementation.has64Bit()) {
                try {
                    Sys.doLoadLibrary(string + POSTFIX64BIT);
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError4) {
                    LWJGLUtil.log("Failed to load 64 bit library: " + unsatisfiedLinkError4.getMessage());
                }
            }
            throw unsatisfiedLinkError3;
        }
    }

    private static SysImplementation createImplementation() {
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                return new LinuxSysImplementation();
            }
            case 3: {
                return new WindowsSysImplementation();
            }
            case 2: {
                return new MacOSXSysImplementation();
            }
        }
        throw new IllegalStateException("Unsupported platform");
    }

    private Sys() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void initialize() {
    }

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static long getTimerResolution() {
        return implementation.getTimerResolution();
    }

    public static long getTime() {
        return implementation.getTime() & Long.MAX_VALUE;
    }

    public static void alert(String string, String string2) {
        boolean bl2 = Mouse.isGrabbed();
        if (bl2) {
            Mouse.setGrabbed(false);
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        implementation.alert(string, string2);
        if (bl2) {
            Mouse.setGrabbed(true);
        }
    }

    public static boolean openURL(String string) {
        try {
            final Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
            Method method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() {
                    return clazz.getMethod("lookup", String.class);
                }
            });
            Object object = method.invoke(clazz, "javax.jnlp.BasicService");
            final Class<?> clazz2 = Class.forName("javax.jnlp.BasicService");
            Method method2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() {
                    return clazz2.getMethod("showDocument", URL.class);
                }
            });
            try {
                Boolean bl2 = (Boolean)method2.invoke(object, new URL(string));
                return bl2;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(System.err);
                return false;
            }
        }
        catch (Exception exception) {
            return implementation.openURL(string);
        }
    }

    public static String getClipboard() {
        return implementation.getClipboard();
    }

    static {
        Sys.loadLibrary(JNI_LIBRARY_NAME);
        is64Bit = implementation.getPointerSize() == 8;
        int n2 = implementation.getJNIVersion();
        int n3 = implementation.getRequiredJNIVersion();
        if (n2 != n3) {
            throw new LinkageError("Version mismatch: jar version is '" + n3 + "', native library version is '" + n2 + "'");
        }
        implementation.setDebug(LWJGLUtil.DEBUG);
    }
}

