/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerWrapper;

public class PointerBuffer
implements Comparable {
    private static final boolean is64Bit;
    protected final ByteBuffer pointers;
    protected final Buffer view;
    protected final IntBuffer view32;
    protected final LongBuffer view64;

    public PointerBuffer(int n2) {
        this(BufferUtils.createByteBuffer(n2 * PointerBuffer.getPointerSize()));
    }

    public PointerBuffer(ByteBuffer byteBuffer) {
        if (LWJGLUtil.CHECKS) {
            PointerBuffer.checkSource(byteBuffer);
        }
        this.pointers = byteBuffer.slice().order(byteBuffer.order());
        if (is64Bit) {
            this.view32 = null;
            this.view64 = this.pointers.asLongBuffer();
            this.view = this.view64;
        } else {
            this.view32 = this.pointers.asIntBuffer();
            this.view = this.view32;
            this.view64 = null;
        }
    }

    private static void checkSource(ByteBuffer byteBuffer) {
        int n2;
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("The source buffer is not direct.");
        }
        int n3 = n2 = is64Bit ? 8 : 4;
        if ((MemoryUtil.getAddress0(byteBuffer) + (long)byteBuffer.position()) % (long)n2 != 0L || byteBuffer.remaining() % n2 != 0) {
            throw new IllegalArgumentException("The source buffer is not aligned to " + n2 + " bytes.");
        }
    }

    public ByteBuffer getBuffer() {
        return this.pointers;
    }

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static int getPointerSize() {
        return is64Bit ? 8 : 4;
    }

    public final int capacity() {
        return this.view.capacity();
    }

    public final int position() {
        return this.view.position();
    }

    public final int positionByte() {
        return this.position() * PointerBuffer.getPointerSize();
    }

    public final PointerBuffer position(int n2) {
        this.view.position(n2);
        return this;
    }

    public final int limit() {
        return this.view.limit();
    }

    public final PointerBuffer limit(int n2) {
        this.view.limit(n2);
        return this;
    }

    public final PointerBuffer mark() {
        this.view.mark();
        return this;
    }

    public final PointerBuffer reset() {
        this.view.reset();
        return this;
    }

    public final PointerBuffer clear() {
        this.view.clear();
        return this;
    }

    public final PointerBuffer flip() {
        this.view.flip();
        return this;
    }

    public final PointerBuffer rewind() {
        this.view.rewind();
        return this;
    }

    public final int remaining() {
        return this.view.remaining();
    }

    public final int remainingByte() {
        return this.remaining() * PointerBuffer.getPointerSize();
    }

    public final boolean hasRemaining() {
        return this.view.hasRemaining();
    }

    public static PointerBuffer allocateDirect(int n2) {
        return new PointerBuffer(n2);
    }

    protected PointerBuffer newInstance(ByteBuffer byteBuffer) {
        return new PointerBuffer(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointerBuffer slice() {
        int n2 = PointerBuffer.getPointerSize();
        this.pointers.position(this.view.position() * n2);
        this.pointers.limit(this.view.limit() * n2);
        try {
            PointerBuffer pointerBuffer = this.newInstance(this.pointers);
            return pointerBuffer;
        }
        finally {
            this.pointers.clear();
        }
    }

    public PointerBuffer duplicate() {
        PointerBuffer pointerBuffer = this.newInstance(this.pointers);
        pointerBuffer.position(this.view.position());
        pointerBuffer.limit(this.view.limit());
        return pointerBuffer;
    }

    public PointerBuffer asReadOnlyBuffer() {
        PointerBufferR pointerBufferR = new PointerBufferR(this.pointers);
        pointerBufferR.position(this.view.position());
        pointerBufferR.limit(this.view.limit());
        return pointerBufferR;
    }

    public boolean isReadOnly() {
        return false;
    }

    public long get() {
        if (is64Bit) {
            return this.view64.get();
        }
        return (long)this.view32.get() & 0xFFFFFFFFL;
    }

    public PointerBuffer put(long l2) {
        if (is64Bit) {
            this.view64.put(l2);
        } else {
            this.view32.put((int)l2);
        }
        return this;
    }

    public PointerBuffer put(PointerWrapper pointerWrapper) {
        return this.put(pointerWrapper.getPointer());
    }

    public static void put(ByteBuffer byteBuffer, long l2) {
        if (is64Bit) {
            byteBuffer.putLong(l2);
        } else {
            byteBuffer.putInt((int)l2);
        }
    }

    public long get(int n2) {
        if (is64Bit) {
            return this.view64.get(n2);
        }
        return (long)this.view32.get(n2) & 0xFFFFFFFFL;
    }

    public PointerBuffer put(int n2, long l2) {
        if (is64Bit) {
            this.view64.put(n2, l2);
        } else {
            this.view32.put(n2, (int)l2);
        }
        return this;
    }

    public PointerBuffer put(int n2, PointerWrapper pointerWrapper) {
        return this.put(n2, pointerWrapper.getPointer());
    }

    public static void put(ByteBuffer byteBuffer, int n2, long l2) {
        if (is64Bit) {
            byteBuffer.putLong(n2, l2);
        } else {
            byteBuffer.putInt(n2, (int)l2);
        }
    }

    public PointerBuffer get(long[] lArray, int n2, int n3) {
        if (is64Bit) {
            this.view64.get(lArray, n2, n3);
        } else {
            PointerBuffer.checkBounds(n2, n3, lArray.length);
            if (n3 > this.view32.remaining()) {
                throw new BufferUnderflowException();
            }
            int n4 = n2 + n3;
            for (int i2 = n2; i2 < n4; ++i2) {
                lArray[i2] = (long)this.view32.get() & 0xFFFFFFFFL;
            }
        }
        return this;
    }

    public PointerBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public PointerBuffer put(PointerBuffer pointerBuffer) {
        if (is64Bit) {
            this.view64.put(pointerBuffer.view64);
        } else {
            this.view32.put(pointerBuffer.view32);
        }
        return this;
    }

    public PointerBuffer put(long[] lArray, int n2, int n3) {
        if (is64Bit) {
            this.view64.put(lArray, n2, n3);
        } else {
            PointerBuffer.checkBounds(n2, n3, lArray.length);
            if (n3 > this.view32.remaining()) {
                throw new BufferOverflowException();
            }
            int n4 = n2 + n3;
            for (int i2 = n2; i2 < n4; ++i2) {
                this.view32.put((int)lArray[i2]);
            }
        }
        return this;
    }

    public final PointerBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public PointerBuffer compact() {
        if (is64Bit) {
            this.view64.compact();
        } else {
            this.view32.compact();
        }
        return this;
    }

    public ByteOrder order() {
        if (is64Bit) {
            return this.view64.order();
        }
        return this.view32.order();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(48);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[pos=");
        stringBuilder.append(this.position());
        stringBuilder.append(" lim=");
        stringBuilder.append(this.limit());
        stringBuilder.append(" cap=");
        stringBuilder.append(this.capacity());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        for (int i2 = this.limit() - 1; i2 >= n3; --i2) {
            n2 = 31 * n2 + (int)this.get(i2);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer pointerBuffer = (PointerBuffer)object;
        if (this.remaining() != pointerBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = pointerBuffer.limit() - 1;
        while (n3 >= n2) {
            long l2;
            long l3 = this.get(n3);
            if (l3 != (l2 = pointerBuffer.get(n4))) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    public int compareTo(Object object) {
        PointerBuffer pointerBuffer = (PointerBuffer)object;
        int n2 = this.position() + Math.min(this.remaining(), pointerBuffer.remaining());
        int n3 = this.position();
        int n4 = pointerBuffer.position();
        while (n3 < n2) {
            long l2;
            long l3 = this.get(n3);
            if (l3 != (l2 = pointerBuffer.get(n4))) {
                if (l3 < l2) {
                    return -1;
                }
                return 1;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - pointerBuffer.remaining();
    }

    private static void checkBounds(int n2, int n3, int n4) {
        if ((n2 | n3 | n2 + n3 | n4 - (n2 + n3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl2 = false;
        try {
            Method method = Class.forName("org.lwjgl.Sys").getDeclaredMethod("is64Bit", null);
            bl2 = (Boolean)method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
        }
        finally {
            is64Bit = bl2;
        }
    }

    static final class PointerBufferR
    extends PointerBuffer {
        PointerBufferR(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        protected PointerBuffer newInstance(ByteBuffer byteBuffer) {
            return new PointerBufferR(byteBuffer);
        }

        @Override
        public PointerBuffer asReadOnlyBuffer() {
            return this.duplicate();
        }

        @Override
        public PointerBuffer put(long l2) {
            throw new ReadOnlyBufferException();
        }

        @Override
        public PointerBuffer put(int n2, long l2) {
            throw new ReadOnlyBufferException();
        }

        @Override
        public PointerBuffer put(PointerBuffer pointerBuffer) {
            throw new ReadOnlyBufferException();
        }

        @Override
        public PointerBuffer put(long[] lArray, int n2, int n3) {
            throw new ReadOnlyBufferException();
        }

        @Override
        public PointerBuffer compact() {
            throw new ReadOnlyBufferException();
        }
    }
}

