/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import org.lwjgl.MemoryUtil;
import sun.misc.Unsafe;
import sun.reflect.FieldAccessor;

final class MemoryUtilSun {
    private MemoryUtilSun() {
    }

    static class AccessorReflectFast
    implements MemoryUtil.Accessor {
        private final FieldAccessor addressAccessor;

        AccessorReflectFast() {
            Field field;
            try {
                field = MemoryUtil.getAddressField();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new UnsupportedOperationException(noSuchFieldException);
            }
            field.setAccessible(true);
            try {
                Method method = Field.class.getDeclaredMethod("acquireFieldAccessor", Boolean.TYPE);
                method.setAccessible(true);
                this.addressAccessor = (FieldAccessor)method.invoke((Object)field, true);
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException(exception);
            }
        }

        public long getAddress(Buffer buffer) {
            return this.addressAccessor.getLong((Object)buffer);
        }
    }

    static class AccessorUnsafe
    implements MemoryUtil.Accessor {
        private final Unsafe unsafe;
        private final long address;

        AccessorUnsafe() {
            try {
                this.unsafe = AccessorUnsafe.getUnsafeInstance();
                this.address = this.unsafe.objectFieldOffset(MemoryUtil.getAddressField());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException(exception);
            }
        }

        public long getAddress(Buffer buffer) {
            return this.unsafe.getLong(buffer, this.address);
        }

        private static Unsafe getUnsafeInstance() {
            Field[] fieldArray;
            for (Field field : fieldArray = Unsafe.class.getDeclaredFields()) {
                int n2;
                if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(n2 = field.getModifiers()) || !Modifier.isFinal(n2)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

