/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;

public final class MemoryUtil {
    private static final Charset ascii;
    private static final Charset utf8;
    private static final Charset utf16;
    private static final Accessor memUtil;

    private MemoryUtil() {
    }

    public static long getAddress0(Buffer buffer) {
        return memUtil.getAddress(buffer);
    }

    public static long getAddress0Safe(Buffer buffer) {
        return buffer == null ? 0L : memUtil.getAddress(buffer);
    }

    public static long getAddress0(PointerBuffer pointerBuffer) {
        return memUtil.getAddress(pointerBuffer.getBuffer());
    }

    public static long getAddress0Safe(PointerBuffer pointerBuffer) {
        return pointerBuffer == null ? 0L : memUtil.getAddress(pointerBuffer.getBuffer());
    }

    public static long getAddress(ByteBuffer byteBuffer) {
        return MemoryUtil.getAddress(byteBuffer, byteBuffer.position());
    }

    public static long getAddress(ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.getAddress0(byteBuffer) + (long)n2;
    }

    public static long getAddress(ShortBuffer shortBuffer) {
        return MemoryUtil.getAddress(shortBuffer, shortBuffer.position());
    }

    public static long getAddress(ShortBuffer shortBuffer, int n2) {
        return MemoryUtil.getAddress0(shortBuffer) + (long)(n2 << 1);
    }

    public static long getAddress(CharBuffer charBuffer) {
        return MemoryUtil.getAddress(charBuffer, charBuffer.position());
    }

    public static long getAddress(CharBuffer charBuffer, int n2) {
        return MemoryUtil.getAddress0(charBuffer) + (long)(n2 << 1);
    }

    public static long getAddress(IntBuffer intBuffer) {
        return MemoryUtil.getAddress(intBuffer, intBuffer.position());
    }

    public static long getAddress(IntBuffer intBuffer, int n2) {
        return MemoryUtil.getAddress0(intBuffer) + (long)(n2 << 2);
    }

    public static long getAddress(FloatBuffer floatBuffer) {
        return MemoryUtil.getAddress(floatBuffer, floatBuffer.position());
    }

    public static long getAddress(FloatBuffer floatBuffer, int n2) {
        return MemoryUtil.getAddress0(floatBuffer) + (long)(n2 << 2);
    }

    public static long getAddress(LongBuffer longBuffer) {
        return MemoryUtil.getAddress(longBuffer, longBuffer.position());
    }

    public static long getAddress(LongBuffer longBuffer, int n2) {
        return MemoryUtil.getAddress0(longBuffer) + (long)(n2 << 3);
    }

    public static long getAddress(DoubleBuffer doubleBuffer) {
        return MemoryUtil.getAddress(doubleBuffer, doubleBuffer.position());
    }

    public static long getAddress(DoubleBuffer doubleBuffer, int n2) {
        return MemoryUtil.getAddress0(doubleBuffer) + (long)(n2 << 3);
    }

    public static long getAddress(PointerBuffer pointerBuffer) {
        return MemoryUtil.getAddress(pointerBuffer, pointerBuffer.position());
    }

    public static long getAddress(PointerBuffer pointerBuffer, int n2) {
        return MemoryUtil.getAddress0(pointerBuffer) + (long)(n2 * PointerBuffer.getPointerSize());
    }

    public static long getAddressSafe(ByteBuffer byteBuffer) {
        return byteBuffer == null ? 0L : MemoryUtil.getAddress(byteBuffer);
    }

    public static long getAddressSafe(ByteBuffer byteBuffer, int n2) {
        return byteBuffer == null ? 0L : MemoryUtil.getAddress(byteBuffer, n2);
    }

    public static long getAddressSafe(ShortBuffer shortBuffer) {
        return shortBuffer == null ? 0L : MemoryUtil.getAddress(shortBuffer);
    }

    public static long getAddressSafe(ShortBuffer shortBuffer, int n2) {
        return shortBuffer == null ? 0L : MemoryUtil.getAddress(shortBuffer, n2);
    }

    public static long getAddressSafe(CharBuffer charBuffer) {
        return charBuffer == null ? 0L : MemoryUtil.getAddress(charBuffer);
    }

    public static long getAddressSafe(CharBuffer charBuffer, int n2) {
        return charBuffer == null ? 0L : MemoryUtil.getAddress(charBuffer, n2);
    }

    public static long getAddressSafe(IntBuffer intBuffer) {
        return intBuffer == null ? 0L : MemoryUtil.getAddress(intBuffer);
    }

    public static long getAddressSafe(IntBuffer intBuffer, int n2) {
        return intBuffer == null ? 0L : MemoryUtil.getAddress(intBuffer, n2);
    }

    public static long getAddressSafe(FloatBuffer floatBuffer) {
        return floatBuffer == null ? 0L : MemoryUtil.getAddress(floatBuffer);
    }

    public static long getAddressSafe(FloatBuffer floatBuffer, int n2) {
        return floatBuffer == null ? 0L : MemoryUtil.getAddress(floatBuffer, n2);
    }

    public static long getAddressSafe(LongBuffer longBuffer) {
        return longBuffer == null ? 0L : MemoryUtil.getAddress(longBuffer);
    }

    public static long getAddressSafe(LongBuffer longBuffer, int n2) {
        return longBuffer == null ? 0L : MemoryUtil.getAddress(longBuffer, n2);
    }

    public static long getAddressSafe(DoubleBuffer doubleBuffer) {
        return doubleBuffer == null ? 0L : MemoryUtil.getAddress(doubleBuffer);
    }

    public static long getAddressSafe(DoubleBuffer doubleBuffer, int n2) {
        return doubleBuffer == null ? 0L : MemoryUtil.getAddress(doubleBuffer, n2);
    }

    public static long getAddressSafe(PointerBuffer pointerBuffer) {
        return pointerBuffer == null ? 0L : MemoryUtil.getAddress(pointerBuffer);
    }

    public static long getAddressSafe(PointerBuffer pointerBuffer, int n2) {
        return pointerBuffer == null ? 0L : MemoryUtil.getAddress(pointerBuffer, n2);
    }

    public static ByteBuffer encodeASCII(CharSequence charSequence) {
        return MemoryUtil.encode(charSequence, ascii);
    }

    public static ByteBuffer encodeUTF8(CharSequence charSequence) {
        return MemoryUtil.encode(charSequence, utf8);
    }

    public static ByteBuffer encodeUTF16(CharSequence charSequence) {
        return MemoryUtil.encode(charSequence, utf16);
    }

    private static ByteBuffer encode(CharSequence charSequence, Charset charset) {
        if (charSequence == null) {
            return null;
        }
        return MemoryUtil.encode(CharBuffer.wrap(new CharSequenceNT(charSequence)), charset);
    }

    private static ByteBuffer encode(CharBuffer charBuffer, Charset charset) {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        int n2 = (int)((float)charBuffer.remaining() * charsetEncoder.averageBytesPerChar());
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n2);
        if (n2 == 0 && charBuffer.remaining() == 0) {
            return byteBuffer;
        }
        charsetEncoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = charBuffer.hasRemaining() ? charsetEncoder.encode(charBuffer, byteBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = charsetEncoder.flush(byteBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                n2 = 2 * n2 + 1;
                ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(n2);
                byteBuffer.flip();
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
                continue;
            }
            try {
                coderResult.throwException();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new RuntimeException(characterCodingException);
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String decodeASCII(ByteBuffer byteBuffer) {
        return MemoryUtil.decode(byteBuffer, ascii);
    }

    public static String decodeUTF8(ByteBuffer byteBuffer) {
        return MemoryUtil.decode(byteBuffer, utf8);
    }

    public static String decodeUTF16(ByteBuffer byteBuffer) {
        return MemoryUtil.decode(byteBuffer, utf16);
    }

    private static String decode(ByteBuffer byteBuffer, Charset charset) {
        if (byteBuffer == null) {
            return null;
        }
        return MemoryUtil.decodeImpl(byteBuffer, charset);
    }

    private static String decodeImpl(ByteBuffer byteBuffer, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        int n2 = (int)((float)byteBuffer.remaining() * charsetDecoder.averageCharsPerByte());
        CharBuffer charBuffer = BufferUtils.createCharBuffer(n2);
        if (n2 == 0 && byteBuffer.remaining() == 0) {
            return "";
        }
        charsetDecoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = byteBuffer.hasRemaining() ? charsetDecoder.decode(byteBuffer, charBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = charsetDecoder.flush(charBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                n2 = 2 * n2 + 1;
                CharBuffer charBuffer2 = BufferUtils.createCharBuffer(n2);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            try {
                coderResult.throwException();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new RuntimeException(characterCodingException);
            }
        }
        charBuffer.flip();
        return charBuffer.toString();
    }

    private static Accessor loadAccessor(String string) {
        return (Accessor)Class.forName(string).newInstance();
    }

    static Field getAddressField() {
        return MemoryUtil.getDeclaredFieldRecursive(ByteBuffer.class, "address");
    }

    private static Field getDeclaredFieldRecursive(Class<?> clazz, String string) {
        Class<?> clazz2 = clazz;
        while (true) {
            try {
                return clazz2.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((clazz2 = clazz2.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(string + " does not exist in " + clazz.getSimpleName() + " or any of its superclasses.");
            }
            break;
        }
    }

    static {
        Accessor accessor;
        ascii = Charset.forName("ISO-8859-1");
        utf8 = Charset.forName("UTF-8");
        utf16 = Charset.forName("UTF-16LE");
        try {
            accessor = MemoryUtil.loadAccessor("org.lwjgl.MemoryUtilSun$AccessorUnsafe");
        }
        catch (Exception exception) {
            try {
                accessor = MemoryUtil.loadAccessor("org.lwjgl.MemoryUtilSun$AccessorReflectFast");
            }
            catch (Exception exception2) {
                try {
                    accessor = new AccessorReflect();
                }
                catch (Exception exception3) {
                    LWJGLUtil.log("Unsupported JVM detected, this will likely result in low performance. Please inform LWJGL developers.");
                    accessor = new AccessorJNI();
                }
            }
        }
        LWJGLUtil.log("MemoryUtil Accessor: " + accessor.getClass().getSimpleName());
        memUtil = accessor;
    }

    static class AccessorReflect
    implements Accessor {
        private final Field address;

        AccessorReflect() {
            try {
                this.address = MemoryUtil.getAddressField();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new UnsupportedOperationException(noSuchFieldException);
            }
            this.address.setAccessible(true);
        }

        @Override
        public long getAddress(Buffer buffer) {
            try {
                return this.address.getLong(buffer);
            }
            catch (IllegalAccessException illegalAccessException) {
                return 0L;
            }
        }
    }

    static class AccessorJNI
    implements Accessor {
        private AccessorJNI() {
        }

        @Override
        public long getAddress(Buffer buffer) {
            return BufferUtils.getBufferAddress(buffer);
        }
    }

    static interface Accessor {
        public long getAddress(Buffer var1);
    }

    static class CharSequenceNT
    implements CharSequence {
        final CharSequence source;

        CharSequenceNT(CharSequence charSequence) {
            this.source = charSequence;
        }

        @Override
        public int length() {
            return this.source.length() + 1;
        }

        @Override
        public char charAt(int n2) {
            return n2 == this.source.length() ? (char)'\u0000' : this.source.charAt(n2);
        }

        @Override
        public CharSequence subSequence(int n2, int n3) {
            return new CharSequenceNT(this.source.subSequence(n2, Math.min(n3, this.source.length())));
        }
    }
}

