/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;

public class BufferChecks {
    private BufferChecks() {
    }

    public static void checkFunctionAddress(long l2) {
        if (LWJGLUtil.CHECKS && l2 == 0L) {
            throw new IllegalStateException("Function is not supported");
        }
    }

    public static void checkNullTerminated(ByteBuffer byteBuffer) {
        if (LWJGLUtil.CHECKS && byteBuffer.get(byteBuffer.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNullTerminated(ByteBuffer byteBuffer, int n2) {
        if (LWJGLUtil.CHECKS) {
            int n3 = 0;
            for (int i2 = byteBuffer.position(); i2 < byteBuffer.limit(); ++i2) {
                if (byteBuffer.get(i2) != 0) continue;
                ++n3;
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("Missing null termination");
            }
        }
    }

    public static void checkNullTerminated(IntBuffer intBuffer) {
        if (LWJGLUtil.CHECKS && intBuffer.get(intBuffer.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNullTerminated(LongBuffer longBuffer) {
        if (LWJGLUtil.CHECKS && longBuffer.get(longBuffer.limit() - 1) != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNullTerminated(PointerBuffer pointerBuffer) {
        if (LWJGLUtil.CHECKS && pointerBuffer.get(pointerBuffer.limit() - 1) != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNotNull(Object object) {
        if (LWJGLUtil.CHECKS && object == null) {
            throw new IllegalArgumentException("Null argument");
        }
    }

    public static void checkDirect(ByteBuffer byteBuffer) {
        if (LWJGLUtil.CHECKS && !byteBuffer.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer is not direct");
        }
    }

    public static void checkDirect(ShortBuffer shortBuffer) {
        if (LWJGLUtil.CHECKS && !shortBuffer.isDirect()) {
            throw new IllegalArgumentException("ShortBuffer is not direct");
        }
    }

    public static void checkDirect(IntBuffer intBuffer) {
        if (LWJGLUtil.CHECKS && !intBuffer.isDirect()) {
            throw new IllegalArgumentException("IntBuffer is not direct");
        }
    }

    public static void checkDirect(LongBuffer longBuffer) {
        if (LWJGLUtil.CHECKS && !longBuffer.isDirect()) {
            throw new IllegalArgumentException("LongBuffer is not direct");
        }
    }

    public static void checkDirect(FloatBuffer floatBuffer) {
        if (LWJGLUtil.CHECKS && !floatBuffer.isDirect()) {
            throw new IllegalArgumentException("FloatBuffer is not direct");
        }
    }

    public static void checkDirect(DoubleBuffer doubleBuffer) {
        if (LWJGLUtil.CHECKS && !doubleBuffer.isDirect()) {
            throw new IllegalArgumentException("DoubleBuffer is not direct");
        }
    }

    public static void checkDirect(PointerBuffer pointerBuffer) {
    }

    public static void checkArray(Object[] objectArray) {
        if (LWJGLUtil.CHECKS && (objectArray == null || objectArray.length == 0)) {
            throw new IllegalArgumentException("Invalid array");
        }
    }

    private static void throwBufferSizeException(Buffer buffer, int n2) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buffer.remaining() + ", must be at least " + n2 + ". Because at most " + n2 + " elements can be returned, a buffer with at least " + n2 + " elements is required, regardless of actual returned element count");
    }

    private static void throwBufferSizeException(PointerBuffer pointerBuffer, int n2) {
        throw new IllegalArgumentException("Number of remaining pointer buffer elements is " + pointerBuffer.remaining() + ", must be at least " + n2);
    }

    private static void throwArraySizeException(Object[] objectArray, int n2) {
        throw new IllegalArgumentException("Number of array elements is " + objectArray.length + ", must be at least " + n2);
    }

    private static void throwArraySizeException(long[] lArray, int n2) {
        throw new IllegalArgumentException("Number of array elements is " + lArray.length + ", must be at least " + n2);
    }

    public static void checkBufferSize(Buffer buffer, int n2) {
        if (LWJGLUtil.CHECKS && buffer.remaining() < n2) {
            BufferChecks.throwBufferSizeException(buffer, n2);
        }
    }

    public static int checkBuffer(Buffer buffer, int n2) {
        int n3;
        if (buffer instanceof ByteBuffer) {
            BufferChecks.checkBuffer((ByteBuffer)buffer, n2);
            n3 = 0;
        } else if (buffer instanceof ShortBuffer) {
            BufferChecks.checkBuffer((ShortBuffer)buffer, n2);
            n3 = 1;
        } else if (buffer instanceof IntBuffer) {
            BufferChecks.checkBuffer((IntBuffer)buffer, n2);
            n3 = 2;
        } else if (buffer instanceof LongBuffer) {
            BufferChecks.checkBuffer((LongBuffer)buffer, n2);
            n3 = 4;
        } else if (buffer instanceof FloatBuffer) {
            BufferChecks.checkBuffer((FloatBuffer)buffer, n2);
            n3 = 2;
        } else if (buffer instanceof DoubleBuffer) {
            BufferChecks.checkBuffer((DoubleBuffer)buffer, n2);
            n3 = 4;
        } else {
            throw new IllegalArgumentException("Unsupported Buffer type specified: " + buffer.getClass());
        }
        return buffer.position() << n3;
    }

    public static void checkBuffer(ByteBuffer byteBuffer, int n2) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(byteBuffer, n2);
            BufferChecks.checkDirect(byteBuffer);
        }
    }

    public static void checkBuffer(ShortBuffer shortBuffer, int n2) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(shortBuffer, n2);
            BufferChecks.checkDirect(shortBuffer);
        }
    }

    public static void checkBuffer(IntBuffer intBuffer, int n2) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(intBuffer, n2);
            BufferChecks.checkDirect(intBuffer);
        }
    }

    public static void checkBuffer(LongBuffer longBuffer, int n2) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(longBuffer, n2);
            BufferChecks.checkDirect(longBuffer);
        }
    }

    public static void checkBuffer(FloatBuffer floatBuffer, int n2) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(floatBuffer, n2);
            BufferChecks.checkDirect(floatBuffer);
        }
    }

    public static void checkBuffer(DoubleBuffer doubleBuffer, int n2) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(doubleBuffer, n2);
            BufferChecks.checkDirect(doubleBuffer);
        }
    }

    public static void checkBuffer(PointerBuffer pointerBuffer, int n2) {
        if (LWJGLUtil.CHECKS && pointerBuffer.remaining() < n2) {
            BufferChecks.throwBufferSizeException(pointerBuffer, n2);
        }
    }

    public static void checkArray(Object[] objectArray, int n2) {
        if (LWJGLUtil.CHECKS && objectArray.length < n2) {
            BufferChecks.throwArraySizeException(objectArray, n2);
        }
    }

    public static void checkArray(long[] lArray, int n2) {
        if (LWJGLUtil.CHECKS && lArray.length < n2) {
            BufferChecks.throwArraySizeException(lArray, n2);
        }
    }
}

