/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamAPICall;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamInterface;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamPublishedFileUpdateHandle;
import com.codedisaster.steamworks.SteamRemoteStorageCallback;
import com.codedisaster.steamworks.SteamRemoteStorageCallbackAdapter;
import com.codedisaster.steamworks.SteamUGCFileWriteStreamHandle;
import com.codedisaster.steamworks.SteamUGCHandle;
import java.nio.ByteBuffer;

public class SteamRemoteStorage
extends SteamInterface {
    public SteamRemoteStorage(SteamRemoteStorageCallback steamRemoteStorageCallback) {
        super(SteamAPI.getSteamRemoteStoragePointer(), SteamRemoteStorage.createCallback(new SteamRemoteStorageCallbackAdapter(steamRemoteStorageCallback)));
    }

    public boolean fileWrite(String string, ByteBuffer byteBuffer, int n2) {
        if (!byteBuffer.isDirect()) {
            throw new SteamException("Direct buffer required!");
        }
        return SteamRemoteStorage.fileWrite(this.pointer, string, byteBuffer, n2);
    }

    public boolean fileRead(String string, ByteBuffer byteBuffer, int n2) {
        if (!byteBuffer.isDirect()) {
            throw new SteamException("Direct buffer required!");
        }
        return SteamRemoteStorage.fileRead(this.pointer, string, byteBuffer, n2);
    }

    public boolean fileDelete(String string) {
        return SteamRemoteStorage.fileDelete(this.pointer, string);
    }

    public SteamAPICall fileShare(String string) {
        return new SteamAPICall(SteamRemoteStorage.fileShare(this.pointer, this.callback, string));
    }

    public SteamUGCFileWriteStreamHandle fileWriteStreamOpen(String string) {
        return new SteamUGCFileWriteStreamHandle(SteamRemoteStorage.fileWriteStreamOpen(this.pointer, string));
    }

    public boolean fileWriteStreamWriteChunk(SteamUGCFileWriteStreamHandle steamUGCFileWriteStreamHandle, ByteBuffer byteBuffer, int n2) {
        return SteamRemoteStorage.fileWriteStreamWriteChunk(this.pointer, steamUGCFileWriteStreamHandle.handle, byteBuffer, n2);
    }

    public boolean fileWriteStreamClose(SteamUGCFileWriteStreamHandle steamUGCFileWriteStreamHandle) {
        return SteamRemoteStorage.fileWriteStreamClose(this.pointer, steamUGCFileWriteStreamHandle.handle);
    }

    public boolean fileWriteStreamCancel(SteamUGCFileWriteStreamHandle steamUGCFileWriteStreamHandle) {
        return SteamRemoteStorage.fileWriteStreamCancel(this.pointer, steamUGCFileWriteStreamHandle.handle);
    }

    public boolean fileExists(String string) {
        return SteamRemoteStorage.fileExists(this.pointer, string);
    }

    public int getFileSize(String string) {
        return SteamRemoteStorage.getFileSize(this.pointer, string);
    }

    public int getFileCount() {
        return SteamRemoteStorage.getFileCount(this.pointer);
    }

    public String getFileNameAndSize(int n2, int[] nArray) {
        return SteamRemoteStorage.getFileNameAndSize(this.pointer, n2, nArray);
    }

    public SteamAPICall ugcDownload(SteamUGCHandle steamUGCHandle, int n2) {
        return new SteamAPICall(SteamRemoteStorage.ugcDownload(this.pointer, this.callback, steamUGCHandle.handle, n2));
    }

    public int ugcRead(SteamUGCHandle steamUGCHandle, ByteBuffer byteBuffer, int n2, int n3, UGCReadAction uGCReadAction) {
        return SteamRemoteStorage.ugcRead(this.pointer, steamUGCHandle.handle, byteBuffer, n2, n3, uGCReadAction.ordinal());
    }

    public SteamAPICall publishWorkshopFile(String string, String string2, int n2, String string3, String string4, PublishedFileVisibility publishedFileVisibility, String[] stringArray, WorkshopFileType workshopFileType) {
        return new SteamAPICall(SteamRemoteStorage.publishWorkshopFile(this.pointer, this.callback, string, string2, n2, string3, string4, publishedFileVisibility.ordinal(), stringArray, stringArray != null ? stringArray.length : 0, workshopFileType.ordinal()));
    }

    public SteamPublishedFileUpdateHandle createPublishedFileUpdateRequest(SteamPublishedFileID steamPublishedFileID) {
        return new SteamPublishedFileUpdateHandle(SteamRemoteStorage.createPublishedFileUpdateRequest(this.pointer, steamPublishedFileID.handle));
    }

    public boolean updatePublishedFileFile(SteamPublishedFileUpdateHandle steamPublishedFileUpdateHandle, String string) {
        return SteamRemoteStorage.updatePublishedFileFile(this.pointer, steamPublishedFileUpdateHandle.handle, string);
    }

    public boolean updatePublishedFilePreviewFile(SteamPublishedFileUpdateHandle steamPublishedFileUpdateHandle, String string) {
        return SteamRemoteStorage.updatePublishedFilePreviewFile(this.pointer, steamPublishedFileUpdateHandle.handle, string);
    }

    public boolean updatePublishedFileTitle(SteamPublishedFileUpdateHandle steamPublishedFileUpdateHandle, String string) {
        return SteamRemoteStorage.updatePublishedFileTitle(this.pointer, steamPublishedFileUpdateHandle.handle, string);
    }

    public boolean updatePublishedFileDescription(SteamPublishedFileUpdateHandle steamPublishedFileUpdateHandle, String string) {
        return SteamRemoteStorage.updatePublishedFileDescription(this.pointer, steamPublishedFileUpdateHandle.handle, string);
    }

    public boolean updatePublishedFileVisibility(SteamPublishedFileUpdateHandle steamPublishedFileUpdateHandle, PublishedFileVisibility publishedFileVisibility) {
        return SteamRemoteStorage.updatePublishedFileVisibility(this.pointer, steamPublishedFileUpdateHandle.handle, publishedFileVisibility.ordinal());
    }

    public boolean updatePublishedFileTags(SteamPublishedFileUpdateHandle steamPublishedFileUpdateHandle, String[] stringArray) {
        return SteamRemoteStorage.updatePublishedFileTags(this.pointer, steamPublishedFileUpdateHandle.handle, stringArray, stringArray != null ? stringArray.length : 0);
    }

    public SteamAPICall commitPublishedFileUpdate(SteamPublishedFileUpdateHandle steamPublishedFileUpdateHandle) {
        return new SteamAPICall(SteamRemoteStorage.commitPublishedFileUpdate(this.pointer, this.callback, steamPublishedFileUpdateHandle.handle));
    }

    private static native long createCallback(SteamRemoteStorageCallbackAdapter var0);

    private static native boolean fileWrite(long var0, String var2, ByteBuffer var3, int var4);

    private static native boolean fileRead(long var0, String var2, ByteBuffer var3, int var4);

    private static native boolean fileDelete(long var0, String var2);

    private static native long fileShare(long var0, long var2, String var4);

    private static native long fileWriteStreamOpen(long var0, String var2);

    private static native boolean fileWriteStreamWriteChunk(long var0, long var2, ByteBuffer var4, int var5);

    private static native boolean fileWriteStreamClose(long var0, long var2);

    private static native boolean fileWriteStreamCancel(long var0, long var2);

    private static native boolean fileExists(long var0, String var2);

    private static native int getFileSize(long var0, String var2);

    private static native int getFileCount(long var0);

    private static native String getFileNameAndSize(long var0, int var2, int[] var3);

    private static native long ugcDownload(long var0, long var2, long var4, int var6);

    private static native int ugcRead(long var0, long var2, ByteBuffer var4, int var5, int var6, int var7);

    private static native long publishWorkshopFile(long var0, long var2, String var4, String var5, int var6, String var7, String var8, int var9, String[] var10, int var11, int var12);

    private static native long createPublishedFileUpdateRequest(long var0, long var2);

    private static native boolean updatePublishedFileFile(long var0, long var2, String var4);

    private static native boolean updatePublishedFilePreviewFile(long var0, long var2, String var4);

    private static native boolean updatePublishedFileTitle(long var0, long var2, String var4);

    private static native boolean updatePublishedFileDescription(long var0, long var2, String var4);

    private static native boolean updatePublishedFileVisibility(long var0, long var2, int var4);

    private static native boolean updatePublishedFileTags(long var0, long var2, String[] var4, int var5);

    private static native long commitPublishedFileUpdate(long var0, long var2, long var4);

    public static enum WorkshopFileType {
        Community,
        Microtransaction,
        Collection,
        Art,
        Video,
        Screenshot,
        Game,
        Software,
        Concept,
        WebGuide,
        IntegratedGuide,
        Merch,
        ControllerBinding,
        SteamworksAccessInvite,
        SteamVideo,
        GameManagedItem;

        private static final WorkshopFileType[] values;

        static WorkshopFileType byOrdinal(int n2) {
            return values[n2];
        }

        static {
            values = WorkshopFileType.values();
        }
    }

    public static enum PublishedFileVisibility {
        Public,
        FriendsOnly,
        Private;

    }

    public static enum UGCReadAction {
        ContinueReadingUntilFinished,
        ContinueReading,
        Close;

    }
}

