/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.desktop.support;

import PRG.VW;
import PRG.YZ;
import PRG.Za;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.desktop.support.JamepadController;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerManager;

public class JamepadControllerMonitor
implements Runnable {
    private final ControllerManager controllerManager;
    private final ControllerListener listener;
    private final Za<Tuple> indexToController = new Za();

    public JamepadControllerMonitor(ControllerManager controllerManager, ControllerListener controllerListener) {
        this.controllerManager = controllerManager;
        this.listener = controllerListener;
    }

    @Override
    public void run() {
        this.controllerManager.d();
        this.checkForNewControllers();
        this.update();
        VW.a.a(this);
    }

    private void checkForNewControllers() {
        int n2 = this.controllerManager.c();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                ControllerIndex controllerIndex = this.controllerManager.a(i2);
                if (this.indexToController.d(controllerIndex.d()) || !controllerIndex.c()) continue;
                Tuple tuple = new Tuple(controllerIndex);
                tuple.controller.addListener(this.listener);
                this.indexToController.a(controllerIndex.d(), tuple);
                this.listener.connected(tuple.controller);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void update() {
        YZ yZ2 = new YZ(this.indexToController.a);
        for (Tuple tuple : this.indexToController.c()) {
            JamepadController jamepadController = tuple.controller;
            boolean bl2 = jamepadController.update();
            if (bl2) continue;
            yZ2.a(tuple.index.d());
        }
        for (int i2 = 0; i2 < yZ2.b; ++i2) {
            this.indexToController.c(yZ2.b(i2));
        }
    }

    class Tuple {
        public final ControllerIndex index;
        public final JamepadController controller;

        public Tuple(ControllerIndex controllerIndex) {
            this.index = controllerIndex;
            this.controller = new JamepadController(controllerIndex);
        }
    }
}

