/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.desktop.support;

import PRG.Za;
import PRG.Zc;
import PRG.Zr;
import PRG.aac;
import PRG.aad;
import PRG.aaf;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.ControllerPowerLevel;
import com.badlogic.gdx.controllers.desktop.support.CompositeControllerListener;
import com.badlogic.gdx.controllers.desktop.support.JamepadMapping;
import com.studiohartman.jamepad.ControllerIndex;
import java.util.UUID;

public class JamepadController
implements Controller {
    private static final Za<aad> CODE_TO_BUTTON = new Za(aad.values().length);
    private static final Za<aac> CODE_TO_AXIS = new Za(aac.values().length);
    private static final Zc logger = new Zc(JamepadController.class.getSimpleName());
    private final CompositeControllerListener compositeControllerListener = new CompositeControllerListener();
    private final ControllerIndex controllerIndex;
    private final Za<Boolean> buttonState = new Za();
    private final Za<Float> axisState = new Za();
    private final String uuid;
    private boolean connected = true;
    private boolean canVibrate = true;
    private long vibrationEndMs;
    private int axisCount = -1;
    private int maxButtonIndex = -1;

    public JamepadController(ControllerIndex controllerIndex) {
        this.controllerIndex = controllerIndex;
        this.uuid = UUID.randomUUID().toString();
        this.initializeState();
    }

    @Override
    public boolean getButton(int n2) {
        try {
            aad aad2 = this.toButton(n2);
            return aad2 != null && this.controllerIndex.a(aad2);
        }
        catch (aaf aaf2) {
            this.setDisconnected();
            return false;
        }
    }

    @Override
    public float getAxis(int n2) {
        try {
            aac aac2 = this.toAxis(n2);
            if (aac2 == null) {
                return 0.0f;
            }
            return this.controllerIndex.a(aac2);
        }
        catch (aaf aaf2) {
            this.setDisconnected();
            return 0.0f;
        }
    }

    @Override
    public String getName() {
        try {
            return this.controllerIndex.e();
        }
        catch (aaf aaf2) {
            this.setDisconnected();
            return "Unknown";
        }
    }

    private void setDisconnected() {
        if (this.connected) {
            this.connected = false;
            logger.b("Failed querying controller at index: " + this.controllerIndex.d());
            this.compositeControllerListener.disconnected(this);
        }
    }

    @Override
    public void addListener(ControllerListener controllerListener) {
        this.compositeControllerListener.addListener(controllerListener);
    }

    @Override
    public void removeListener(ControllerListener controllerListener) {
        this.compositeControllerListener.removeListener(controllerListener);
    }

    public boolean update() {
        this.updateButtonsState();
        this.updateAxisState();
        return this.connected;
    }

    private aad toButton(int n2) {
        return CODE_TO_BUTTON.b(n2);
    }

    private aac toAxis(int n2) {
        return CODE_TO_AXIS.b(n2);
    }

    private void updateAxisState() {
        for (aac aac2 : aac.values()) {
            int n2 = aac2.ordinal();
            float f2 = this.getAxis(n2);
            if (f2 != this.axisState.b(n2).floatValue()) {
                if (logger.a() == 3) {
                    logger.a("Axis [" + n2 + " - " + (Object)((Object)this.toAxis(n2)) + "] moved [" + f2 + "]");
                }
                this.compositeControllerListener.axisMoved(this, n2, f2);
            }
            this.axisState.a(n2, Float.valueOf(f2));
        }
    }

    private void updateButtonsState() {
        for (aad aad2 : aad.values()) {
            int n2 = aad2.ordinal();
            boolean bl2 = this.getButton(n2);
            if (bl2 != this.buttonState.b(n2)) {
                if (bl2) {
                    this.compositeControllerListener.buttonDown(this, n2);
                } else {
                    this.compositeControllerListener.buttonUp(this, n2);
                }
                if (logger.a() == 3) {
                    logger.a("Button [" + n2 + " - " + (Object)((Object)this.toButton(n2)) + "] is " + (bl2 ? "pressed" : "released"));
                }
            }
            this.buttonState.a(n2, bl2);
        }
    }

    private void initializeState() {
        for (aac enum_ : aac.values()) {
            this.axisState.a(enum_.ordinal(), Float.valueOf(0.0f));
        }
        for (Enum enum_ : aad.values()) {
            this.buttonState.a(enum_.ordinal(), false);
        }
    }

    @Override
    public boolean canVibrate() {
        return this.canVibrate;
    }

    @Override
    public boolean isVibrating() {
        return this.canVibrate() && Zr.a() < this.vibrationEndMs;
    }

    @Override
    public void startVibration(int n2, float f2) {
        try {
            if (this.controllerIndex.a(f2, f2, n2)) {
                this.vibrationEndMs = Zr.a() + (long)n2;
                this.canVibrate = true;
            } else {
                this.canVibrate = false;
            }
        }
        catch (aaf aaf2) {
            this.setDisconnected();
        }
    }

    @Override
    public void cancelVibration() {
        if (this.isVibrating()) {
            this.startVibration(0, 0.0f);
        }
    }

    @Override
    public String getUniqueId() {
        return this.uuid;
    }

    @Override
    public boolean supportsPlayerIndex() {
        return true;
    }

    @Override
    public int getPlayerIndex() {
        try {
            return this.controllerIndex.f();
        }
        catch (aaf aaf2) {
            this.setDisconnected();
            return -1;
        }
    }

    @Override
    public void setPlayerIndex(int n2) {
        try {
            this.controllerIndex.a(n2);
        }
        catch (aaf aaf2) {
            this.setDisconnected();
        }
    }

    @Override
    public int getMinButtonIndex() {
        return 0;
    }

    @Override
    public int getMaxButtonIndex() {
        if (this.maxButtonIndex >= 0) {
            return this.maxButtonIndex;
        }
        this.maxButtonIndex = JamepadController.CODE_TO_BUTTON.a - 1;
        try {
            while (this.maxButtonIndex > 0 && !this.controllerIndex.b(CODE_TO_BUTTON.b(this.maxButtonIndex))) {
                --this.maxButtonIndex;
            }
        }
        catch (aaf aaf2) {
            this.setDisconnected();
        }
        return this.maxButtonIndex;
    }

    @Override
    public int getAxisCount() {
        if (this.axisCount >= 0) {
            return this.axisCount;
        }
        this.axisCount = JamepadController.CODE_TO_AXIS.a;
        try {
            while (this.axisCount > 0 && !this.controllerIndex.b(CODE_TO_AXIS.b(this.axisCount - 1))) {
                --this.axisCount;
            }
        }
        catch (aaf aaf2) {
            this.setDisconnected();
        }
        return this.axisCount;
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.controllerIndex.c();
    }

    @Override
    public ControllerMapping getMapping() {
        return JamepadMapping.getInstance();
    }

    @Override
    public ControllerPowerLevel getPowerLevel() {
        try {
            switch (this.controllerIndex.g()) {
                case g: 
                case e: {
                    return ControllerPowerLevel.POWER_FULL;
                }
                case d: {
                    return ControllerPowerLevel.POWER_MEDIUM;
                }
                case c: {
                    return ControllerPowerLevel.POWER_LOW;
                }
                case b: {
                    return ControllerPowerLevel.POWER_EMPTY;
                }
                case f: {
                    return ControllerPowerLevel.POWER_WIRED;
                }
            }
            return ControllerPowerLevel.POWER_UNKNOWN;
        }
        catch (Throwable throwable) {
            return ControllerPowerLevel.POWER_UNKNOWN;
        }
    }

    static {
        for (aad enum_ : aad.values()) {
            CODE_TO_BUTTON.a(enum_.ordinal(), enum_);
        }
        for (Enum enum_ : aac.values()) {
            CODE_TO_AXIS.a(enum_.ordinal(), (aac)enum_);
        }
    }
}

