/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.desktop.support;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import java.util.LinkedList;

public class CompositeControllerListener
implements ControllerListener {
    private final LinkedList<ControllerListener> listeners = new LinkedList();

    @Override
    public void connected(Controller controller) {
        for (ControllerListener controllerListener : this.listeners) {
            controllerListener.connected(controller);
        }
    }

    @Override
    public void disconnected(Controller controller) {
        for (ControllerListener controllerListener : this.listeners) {
            controllerListener.disconnected(controller);
        }
    }

    @Override
    public boolean buttonDown(Controller controller, int n2) {
        for (ControllerListener controllerListener : this.listeners) {
            if (!controllerListener.buttonDown(controller, n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean buttonUp(Controller controller, int n2) {
        for (ControllerListener controllerListener : this.listeners) {
            if (!controllerListener.buttonUp(controller, n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean axisMoved(Controller controller, int n2, float f2) {
        for (ControllerListener controllerListener : this.listeners) {
            if (!controllerListener.axisMoved(controller, n2, f2)) continue;
            return true;
        }
        return false;
    }

    public void addListener(ControllerListener controllerListener) {
        this.listeners.add(controllerListener);
    }

    public void removeListener(ControllerListener controllerListener) {
        this.listeners.remove(controllerListener);
    }

    public void clear() {
        this.listeners.clear();
    }
}

