
uniform mat4 g_ModelViewProjectionMatrix;
uniform float g_Time;

uniform float g_Speed; // {"material":"speed","label":"ui_editor_properties_speed","default":1,"range":[0.01, 10]}
uniform float g_Strength; // {"material":"strength","label":"ui_editor_properties_strength","default":100,"range":[0.01, 500]}
uniform float g_Phase; // {"material":"phase","label":"ui_editor_properties_phase","default":0,"range":[0, 6.28]}
uniform float g_Power; // {"material":"power","label":"ui_editor_properties_power","default":1,"range":[0.01, 2]}
uniform vec2 g_DirectionWeights; // {"material":"directionweights","label":"ui_editor_properties_direction_weights","default":"1 0.2"}
uniform vec4 g_CornerWeights; // {"material":"cornerweights","label":"ui_editor_properties_corner_weights","default":"1 1 0 0"}

attribute vec3 a_Position;
attribute vec2 a_TexCoord;

varying vec2 v_TexCoord;

void main() {
	vec3 position = a_Position;
	
	vec4 sines = g_Phase + g_Speed * g_Time * vec4(1, -0.16161616, 0.0083333, -0.00019841);
	sines = sin(sines);
	vec4 csines = 0.4 + g_Phase + g_Speed * g_Time * vec4(-0.5, 0.041666666, -0.0013888889, 0.000024801587);
	csines = sin(csines);
	
	sines = pow(abs(sines), CAST4(g_Power)) * sign(sines);
	csines = pow(abs(csines), CAST4(g_Power)) * sign(csines);
	
	float weight = saturate(g_CornerWeights.x * (1.0 - a_TexCoord.x) * (1.0 - a_TexCoord.y) +
					g_CornerWeights.y * (a_TexCoord.x) * (1.0 - a_TexCoord.y) +
					g_CornerWeights.z * (a_TexCoord.x) * (a_TexCoord.y) +
					g_CornerWeights.w * (1.0 - a_TexCoord.x) * (a_TexCoord.y));
	
	position.x += dot(sines, CAST4(1.0)) * g_Strength * weight * g_DirectionWeights.x;
	position.y += dot(csines, CAST4(1.0)) * g_Strength * weight * g_DirectionWeights.y;
	
	
	gl_Position = mul(vec4(position, 1.0), g_ModelViewProjectionMatrix);
	v_TexCoord = a_TexCoord;
}
