﻿# The script of the game goes in this file.

# Declare characters used by this game. The color argument colorizes the
# name of the character.

# Define is a constant
# Default sets on new game or if the variable isn't already defined

# define e = Character("Eileen")

init offset = 1

define _history = False

hide quick_menu()

# Calender keeps track of the current date
# Stored as Year, Month, Day, Hour, Minute
default calendar = [952,1,1,18,00]
# Seminandum, Crescente, Messis, Levisomnus

# Weather contains a string and is set at the dawn of each day
default weather = 1

# Defense Dice
define whiteDice = d6("gui/dice/white_dice.png","Whi",0,False,0,False,0,False,1,False,1,False,1,False)
define grayDice = d6("gui/dice/gray_dice.png","Gra",0,False,1,False,1,False,1,False,2,False,2,False)
define blackDice = d6("gui/dice/black_dice.png","Bla",1,False,1,False,2,False,2,False,3,False,4,False)
# Attack Dice
define greenDice = d6("gui/dice/green_dice.png","Gre",1,False,1,False,1,False,1,True,2,False,2,False)
define blueDice = d6("gui/dice/blue_dice.png","Blu",1,False,2,True,2,False,2,False,3,False,3,False)
define purpleDice = d6("gui/dice/purple_dice.png","Pur",1,False,1,True,1,True,2,False,2,False,2,True)
define redDice = d6("gui/dice/red_dice.png","Pur",1,True,1,True,2,True,2,True,2,False,2,False)
define goldDice = d6("gui/dice/gold_dice.png","Gol",2,False,2,False,2,False,3,False,3,False,4,False)
# Standard Dice
define standd6 = d6(None,"d6",1,False,2,False,3,False,4,False,5,False,6,False)

default inventory = []
default sellInventory = []
default buyInventory = []
default accessInventory = True
default accessMap = False
# Enemy inventory holds 5 slots for items equipped to the enemy
# 0 Acc, 1 Chest, 2 Legs, 3 Right Hand, 4 Left Hand
default enemyInventory = []
default selected_item = None
default remove_item = 0
default selected_amount = 1
default pc = Mob(25,25,4,10,10,10,10,"Player","Human","Male")
default player_appearance = {
"Height" : 69,
"Overheight" : 0,
"Weight" : 170,
"Overweight" : 0,
"Chest" : 0,
"Cock" : False,
"Cock Type" : "Human", # "Human", "Canine", "Equine"
"Cock Length" : 0,
"Sheath" : "None", # "None", "Sheath", "Slit"
"Balls" : False,
"Ballsize" : 0,
"Vagina" : False,
"Legs" : "Human", # "Human", "Furred Plantigrade", "Reptile Plantigrade", "Furred Digitigrade", "Reptile Digitigrade" "Equine"
"Arms" : "Human", # "Human", "Furred", "Reptile"
"Torso" : "Human", # "Human", "Furred", "Reptile"
"Face" : "Human", # "Human", "Orc, "Kobold, "Goblin", "Canine", "Feline", "Reptile", "Equine", "Bovine", "Rodent"
"Tail" : "None", # "None", "Canine", "Feline", "Reptile", "Equine", "Bovine"
"Skin Color" : "Beige",
"Fur Color" : "Black",
"Scale Color" : "Red",
"Ears" : "Human", # "Human", "Rodent", "Canine", "Feline", "Bovine", "Equine", "Reptile"
"Tusks" : False,
"Claws" : False,
"Fangs" : False
}
default pc_level = 1
# 0 = Falsely Accused, 1 = Resistance Fighter, 2 = Thief
default pc_crime = 0
define player = Character("[pc.profile[Name]]", dynamic = True)
default enemy = None

default last_scene = None
default last_checkpoint = "scene_vacdes.introduction"

# General Items
# id_key 0xxxxx
# Item(self,id_key,img,val,name,desc,amount,1,99)
default item_trash = InventoryItem(000001,"gui/items/default.jpg",1,"Trash","Description",16)
default item_vial = InventoryItem(000002,"gui/items/default.jpg",1,"Vial","Description",16)
default item_gold = InventoryItem(000003,"gui/items/default.jpg",0,"Gold","Gold coins from the elven empire, they have little value on Alcatraz except to unique individuals",64)
default item_squeeb_mead = InventoryItem(000004,"gui/items/default.jpg",0,"Special Mead","A barrel of mead for Lucia of Vergesseneburg",1,vii = True)
default item_squeeb_letter = InventoryItem(000005,"gui/items/default.jpg",0,"Letter of Recommendation","A letter of introduction for Lucia of Vergesseneburg",1,vii = True)
default item_squeeb_supplies = InventoryItem(000006,"gui/items/default.jpg",0,"Supplies for Squeeb","A package of supplies for Squeeb at the Last Drop. The package is quite heavy and has a lipstick mark on the exterior",1,vii = True)
# Armors and Equipment
# id_key 1xxxxx
# Armor(self,id_key,img,val,name,desc,locked,amount,slot,combat_att,survival_att,acumen_att,glamour_att,combat_def,survival_def,acumen_def,glamour_def,boon,tier)
default item_headband = Armor(100001,"gui/items/default.jpg",0,"Headband","A tattered old headband",False,"Head",0,0,0,0,0,1,0,0,[],0)
default item_torn_shirt = Armor(100002,"gui/items/tattered_shirt.jpg",0,"Torn Shirt","A heavily tattered shirt that barely holds together.",False,"Chest",0,0,0,0,1,1,0,0,[],0)
default item_torn_shorts = Armor(100003,"gui/items/tattered_pants.jpg",0,"Torn Shorts","A pair of ripped and tattered pants.",False,"Legs",0,0,0,0,0,1,0,1,[],0)
default item_magic_collar = Armor(100004,"gui/items/magic_collar.jpg",0,"Chastity Collar","A heavy metal collar the bites into your neck. You can't seem to remove it.",True,"Acc",0,0,0,0,0,0,0,4,["Curse"],0)
default item_scrap_shirt = Armor(100005,"gui/items/tattered_shirt.jpg",0,"Scrap Shirt","A simple shirt made of scrap cloth and leather.",False,"Chest",0,0,0,0,2,0,0,0,[],0)
default item_scrap_pants = Armor(100006,"gui/items/tattered_pants.jpg",0,"Scrap Pants","A pair of pants made of scrap cloth stitched together.",False,"Legs",0,0,0,0,0,0,0,2,[],0)
# Weapons and Shields
# id_key 2xxxxx
# Weapon(self,id_key,img,val,name,desc,locked,slot,combat_att,survival_att,acumen_att,glamour_att,combat_def,survival_def,acumen_def,glamour_def,type,tier,heavy,pierce,reach)
default item_stick = Weapon(200001,"gui/items/stick.jpg",0,"Stick","A small stick that should function as a club in a pinch.",False,'Right',1,0,0,0,0,0,0,0,Weapon_Type.MISC,0)
default item_plank_shield = Weapon(200002,"gui/items/default.jpg",0,"Plank Shield","A few scrap boards tied together with rope and simple nails.",False,'Left',0,0,0,0,1,1,0,0,Weapon_Type.SHIELD,0)
default item_big_stick = Weapon(200003,"gui/items/big_stick.jpg",0,"Big Stick","A large branch that should function as a heavy club in a pinch.",False,'Both',2,0,0,0,0,0,0,0,Weapon_Type.STAFF,0,heavy = True)
default item_basic_spear = Weapon(200004,"gui/items/big_stick.jpg",0,"Primitive Spear","A simple spear made with a sharp stone tip.",False,'Right',0,2,0,0,0,0,0,0,Weapon_Type.STAFF,0,pierce = True)
default item_basic_dagger = Weapon(200005,"gui/items/big_stick.jpg",0,"Simple Dagger","A well worn dagger with signs of use but the blade is still sharp.",False,'Right',1,1,0,0,0,0,0,0,Weapon_Type.STAFF,0,pierce = True)
default item_squeebs_knife = Weapon(200006,"gui/items/default.jpg",0,"Squeeb's Knife","An old blade with a sharp edge. It was given to you by Squeeb.",False,'Right',5,3,0,0,1,0,0,0,Weapon_Type.MISC,0)
# Ingredients
# id_key 3xxxxx
# Ingredient(self,id_key,img,val,name,desc,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,buff_2)
default item_wildberry = Ingredient(300001,"gui/items/wildberry.jpg",0,"Wildberry","Description",16,None,None,None,None,None,None)
default item_redroot = Ingredient(300002,"gui/items/redroot.jpg",0,"Red Root","Description",16,None,[whiteDice],None,None,None,None)
default item_honey = Ingredient(300003,"gui/items/default.jpg",2,"Honey","Description",16,[whiteDice,whiteDice],None,None,None,None,None)
default item_black_powder = Ingredient(300004,"gui/items/gunpowder.jpg",1,"Black Powder","A small brown pouch containing a blackish powder that smells strongly.",16,None,None,None,None,None,None)
default item_green_ivy = Ingredient(300005,"gui/items/default.jpg",2,"Green Ivy","A cluster of strong smelling leaves that could be brewed into a tea or potion.",16,None,None,None,None,None,None)
default item_shell = Ingredient(300006,"gui/items/shells.jpg",1,"Sea Shell","The small chipped shell of an aquatic creature.",16,None,None,None,None,None,None)
default item_scale = Ingredient(300007,"gui/items/default.jpg",2,"Scale","A few scales from some reptilian or aquatic creature.",16,None,None,None,None,None,None)
default item_red_flower = Ingredient(300008,"gui/items/default.jpg",2,"Poppy","A small red flower.",16,None,None,None,None,None,None)
default item_rock_salt = Ingredient(300009,"gui/items/default.jpg",1,"Rock Salt","A small pouch of salt chunks and particles.",16,None,None,None,None,None,None)
# Consumables
# id_key 4xxxxx
# Consumable(self,id_key,img,val,name,desc,amount,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,tier_1,dur_1,buff_2,tier_2,dur_2,buff_3,tier_3,dur_3)
default item_apple = Consumable(400001,"gui/items/default.jpg",0,"Apple","Description",16,[whiteDice],None,None,None,None,1,0,None,1,0,None,1,0)
default item_ale = Consumable(400002,"gui/items/default.jpg",0,"Ale","Description",16,None,[whiteDice],None,None,None,1,0,None,1,0,None,1,0)
default item_venison = Consumable(400003,"gui/items/default.jpg",0,"Raw Venison","Raw deer meat, edible in a pinch but not recommended",16,None,[grayDice],None,None,None,1,0,None,1,0,None,1,0)
default item_cooked_venison = Consumable(400004,"gui/items/default.jpg",0,"Grilled Venison","Deer meat grilled over a fire.",16,None,[blackDice,blackDice,blackDice],None,None,None,1,0,None,1,0,None,1,0)

# Define Skills (self,img,name,description,funct,stam,type,accuracy):
define skill_struggle = Skill("gui/button/strike","Struggle",
"Unable to act",struggle,0,"Physical",95)
define skill_rest = Skill("gui/button/strike",
"Rest","Resting recovers 1 or 2 stamina.",rest,0,"Other",0)
define skill_strike = Skill("gui/button/strike","Strike",
"You make a straight strike at your opponent with a weapon or your fists.",strike,0,"Physical",95)
define skill_flirt = Skill("gui/button/flirt","Flirt",
"Attempt to pacify the enemy with your charm or whatever items you're holding.",flirt,0,"Lust",95)
define skill_pierce = Skill("gui/button/thrust","Pierce",
"You make a swift strike forward, this attack bypasses some of the enemy's armor when wielding a piercing weapon.",pierce,1,"Physical",95)
define skill_flurry = Skill("gui/button/thrust","Flurry",
"A savage attack that can hit up to 5 times.",flurry,1,"Physical",85)
define skill_siren_song = Skill("gui/button/rose","Siren Song",
"You sing a beautiful and baffling melody that charms the enemy.",siren_song,1,"Lust",85)

# power word skills are used for narrative moments only and should not be accessable to the player or regular creatures
define skill_pw_kill = Skill("gui/button/strike","Power Word Kill",
"Instantly defeats the target",pw_kill,0,"Physical")

# Hostile(self, sprite, hp, libido, morale, stamina, combat, survival, acumen, glamour, name, race, gender,sk_1,sk_2,sk_3,sk_4,sk_5,sk_6,condition,ending)
##  GOBLINS
default mob_goblin_male_01 = Hostile("Male Goblin Collared",20,30,10,2,7,12,6,6,"Goblin","Goblin","Male",store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
default mob_goblin_female_01 = Hostile("Female Goblin Collared",20,30,10,2,7,12,6,6,"Goblin","Goblin","Female",store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
default mob_goblin_male_02 = Hostile("Male Goblin",20,30,10,2,7,12,6,6,"Goblin","Goblin","Male",store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
default mob_goblin_female_02 = Hostile("Female Goblin",20,30,10,2,7,12,6,6,"Goblin","Goblin","Female",store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
## SIREN
default mob_siren_male_01 = Hostile("Male Siren",30,45,20,2,10,7,8,12,"Siren","Siren","Male",store.skill_strike,store.skill_flirt,store.skill_siren_song,None,None,None,"","siren_battle")
default mob_siren_female_01 = Hostile("Female Siren",30,45,20,2,10,7,8,12,"Siren","Siren","Female",store.skill_strike,store.skill_flirt,store.skill_siren_song,None,None,None,"","siren_battle")
## SIREN
default mob_werewolf_male_01 = Hostile("Male Werewolf",45,50,40,2,16,15,12,14,"Werewolf","Werewolf","Male",store.skill_strike,store.skill_flirt,store.skill_flurry,None,None,None,"","werewolf_battle")
default mob_werewolf_female_01 = Hostile("Female Werewolf",45,50,40,2,16,15,12,14,"Werewolf","Werewolf","Female",store.skill_strike,store.skill_flirt,store.skill_flurry,None,None,None,"","werewolf_battle")
##  SLIME
default mob_slime_male_01 = Hostile("Male Slime",35,25,10,2,4,5,4,4,"Blue Slime","Slime","Male",store.skill_strike,store.skill_flirt,None,None,None,None,"","slime_battle")
default mob_slime_female_01 = Hostile("Female Slime",35,25,10,2,4,5,4,4,"Red Slime","Slime","Female",store.skill_strike,store.skill_flirt,None,None,None,None,"","slime_battle")
##  HARPY
default mob_harpy_male_01 = Hostile("Harpy",50,40,10,2,3,5,3,4,"Harpy","Harpy","Male",store.skill_strike,store.skill_flirt,None,None,None,None,"","harpy_battle")
default mob_harpy_female_01 = Hostile("Harpy",50,40,10,2,3,5,3,4,"Harpy","Harpy","Female",store.skill_strike,store.skill_flirt,None,None,None,None,"","harpy_battle")
## WOLVES
default mob_wolf_pack_01 =  Hostile("Wolf Pack",60,50,10,2,6,6,2,2,"Wolves","Wolf","--",store.skill_strike,None,None,None,None,None,"","wolves_battle")

define nar = Character("")
define unknown_person = Character("?")
define squeeb = Character("Squeeb")
define fenna = Character("Fenna")

# Combat Variables
default player_turn = True
default turn_start = True
default player_action_menu = True # False if inventory is active
default selected_skill = None
default hit = 0
default crit = 0
default miss = 0
default spr = []
default combat_history = []
default turn_count = 1
default flee_succeed = False
default mob_flee = False
default mob_submit = False

image enemy_healthy_chaste = "goblin nude.png"
image enemy_healthy_lusty = "goblin nude.png"
image enemy_hurt_chaste = "goblin nude.png"
image enemy_hurt_lusty = "goblin nude.png"

default battle_end = ""

# Define Backgrounds
image bg basic = "gui/rooms/bg room.jpg"
image bg worldmap = "gui/rooms/worldmap.jpg"
image bg forest_day = "gui/rooms/forest day.jpg"
image bg forest_night = "gui/rooms/forest night.jpg"

# Define Location
default map_point = 0
default selected_locale = None

default locations = []
default roads = []

default set_ui = "map"

default pref_gender = "both"

# NPC Images
image squeeb collared_idle = "Squeeb idle.png"
image fenna collared_idle = "Fenna idle.png"

# NPC POINTS
default relationship_squeeb = {
"met_squeeb" : False,
"was_honest" : False,
"thanked_for_saving" : False
}
default squeeb_quest = {
"quest" : 0,   # 0 = Not started, 1 = Started, 2 = Complete
"quest_phase" : 0
}

default relationship_fenna = {
"met_fenna" : False
}
default fenna_quest = {
"quest" : 0,   # 0 = Not started, 1 = Started, 2 = Complete
"quest_phase" : 0
}

default relationship_vacdes = {
"met_vacdes" : False,
"what_is" : False,
"get_here" : False,
"leave" : False,
"trinket" : False,
"dreaming" : False,
"first_meeting" : False
}

default relationship_lucia = {
"met_lucia" : False
}

# FACTION POINTS
default faction_score = {
"goblins" : 0,
"sirens" : 0,
"orcs" : 0,
"slimes" : 0,
"harpies" : 0,
"wolves" : 0
}
default input_string = ""

# POSITIONS
define midleft = Position(xpos = 0.35)
define midright = Position(xpos = 0.65)

# The game starts here.

label splashscreen:
    scene black
    show text "The following game contains adult content not intended for minors."
    menu:
        "I am 18+":
            return
        "I am not 18+":
            $ renpy.quit()

label start:
    $ _game_menu_screen = None
    # SET LOCATIONS LIST
    # Forest Locations
    $ locations.append(south_forest_01)
    $ locations.append(south_forest_02)
    $ locations.append(south_forest_03)
    # Coastal Locations
    $ locations.append(south_coast_01)
    $ locations.append(south_coast_02)
    # Unique Locations
    $ locations.append(fort_chastity)
    $ locations.append(the_last_drop)
    $ locations.append(vergesseneburg)
    $ locations.append(goblin_outpost_01)
    # for i in locations:
    #     i.discovered = True
    # SET ROADS LIST
    $ roads.append(forest_to_fort_chastity)
    $ roads.append(forest_path_01)
    # roads.append(forest_path_02)
    $ roads.append(forest_path_03)
    $ roads.append(forest_path_04)
    $ roads.append(forest_path_05)
    $ roads.append(last_drop_path_01)
    $ roads.append(last_drop_path_02)
    $ roads.append(beach_path_01)
    $ roads.append(path_vergesseneburg_to_beach)
    # for i in roads:
    #     i.discovered = True

    $ addToInventory(item_torn_shirt,1)
    $ addToInventory(item_torn_shorts,1)
    $ addToInventory(item_magic_collar,1)

    $ inventory[len(inventory)-3][0].equip(pc)
    $ inventory[len(inventory)-2][0].equip(pc)
    $ inventory[len(inventory)-1][0].equip(pc)

    # $ i = 0
    # while i < 50:
    #     $ i += 1
    #     $ addToInventory(item_magic_collar,1)

    $ sortInventory(1)

    # Show a background. This uses a placeholder by default, but you can
    # add a file (named either "bg room.png" or "bg room.jpg") to the
    # images directory to show it.

    scene bg basic

    jump scene_introduction_01 # scene_goblin_outpost.exterior # scene_forest.south_02 # scene_level_up # scene_map

label scene_introduction_01:
    show bg basic
    $ map_point = fort_chastity

    # show screen inventory_screen()
    # hide menubar()

    "The nauseating sensation of rocking wakes you unpleasantly from your sleep. With each sharp jerk it feels as if the ship would tear itself apart, yet the cursed vessel remains intact. You sit up with a wince as pain and discomfort shoot through your neck a shoulders. The wooden cot provided little in the way of comfort. Your poor condition is emphasized by a pop and crack in your shoulders as you move."

    "The sound of waves crashing against the ships hull ring loudly in your ears. It's almost enough to drown out the sounds of stomping feet above and the sharp sound of sobbing beneath. The smell of salt water in the air stings your nose and eyes."

    "As your eyes adjust you find yourself locked in a cell. Rusted iron bars allow you to see your fellow prisoners while preventing any escape. You'd been on this ship for a little over a week. Just another prisoner of the Legion, heading towards your prison. The Legion had recently expanded it's territory vastly. Rolling over the lands with large armies. The invasions were immense and with each conquest their numbers grew as they assimilated the populace."

    "You were among many who's homes had been conquered and like so many others you had broken the Legion's laws. Though the term law is used quite loosely within the Legion's borders. For monsters simply speaking to the wrong person could be spun as an attempted assault. No matter how small the crime, monsters are given no second chances. It's either Alcatraz or execution, though the outcome is nearly indistinguishable."

    menu:
        "Falsely accused":
            $ pc_crime = 0
        "Fought against the Legion":
            $ pc_crime = 1
        "Petty thief":
            $ pc_crime = 2

    "Though your crimes make little difference now as the ship is soon to arrive at your new home and prison. The ship rocks harshly to one side sending several prisoners sprawling across the floor. The forward motion of the ship begins to slow and it's clear you're all moments away from your destination."

    "This realization seems to spark some panic in one of your fellow prisoners. He begins clawing frantically at a metal collar around his neck, reminding you of the weight around your own. Each of you had been collared, the heavy rings of metal had no clear method to open or close them. How they were attached is a mystery but was likely done magically. The purpose of these collars wasn't ever explained to you after your arrest."

    "The grunting grows louder and more frustrated as the man tugs fruitlessly at the metal. He seemed to be attempting to break it with brute force alone. As you got a better look at him, it wasn't surprising given his build. He has an incredibly broad chest and heavy tree trunk like arms. Even in the dark his dark rust colored skin and thick lower tusks informed you that he was an orc. Most likely from the south."

    "An exasperated sigh cuts through the sound of growling and grunting. The sound wasn't insensitive but the disappointment in it's tone was visceral. This caught the orc's attention. He shot a glance at the cell across from his own, towards the perpetrator of the noise."

    "Orc Man" "\"What? Is there a problem?\""

    "Wererat Woman" "\"You should already know by now that that won't work. It didn't work the first day, didn't work the second day and it won't work a hundred days from now.\" The words were harsh but her tone was dry, melancholic, almost as if she was talking more to herself then the orc."

    "Orc Man" "\"Well you can give up and die a withered old spinster on this island but I don't intend to.\" The frustration in his voice was clear, he seemed to understand his actions were futile. Still acted as if locked in a loop of failure, unable to look or think beyond it."

    "It was a generally accepted rumor among the prisoners that the collars prevent anyone from leaving the island. In addition if they are kept on for too long your libido will disappear, a cruel way for the Legion to control the population of monsters. Many of whom reproduce rather rapidly. The less restrained of prisoners had suggested that the collars would cause your balls and cock to fall off. Though no one has yet to experience such a thing."

    "Wererat Woman" "\"Do as you will then. I wish you luck in your futile efforts.\""

    "The orc grumbled and grunted a few more times as he made a few more vanity attempts to snap the metal collar. Eventually he slumped back in his cell only for a few moments before the trap door to the hull opened. Sunlight poured into the hull forcing you to close your eyes for a few moments. Silhouettes of several tall thin figures wielding spears descend the stairs into the brig."

    "As your eyes adjust to the sudden change of light you see the armor clad guards of the Legion. They were adorned with silver armor and blue tabard with the symbol of the legion embroidered upon it. They move towards the first of the cells, they take one of the prisoners out of their cell before leading them to the upper deck. The process repeats several times before they reach your cell."

    $ add_time(3,30)

    "You're quickly pulled from your cell, the guards prod you with spears giving you little choice in the matter. You follow them to the deck of the ship. It's mid afternoon, the sun is high and bits down mercilessly. A sharp contrast from the dark confines of the ship but no less oppressive."

    "One of the guards steps forward carrying a thick ledger and a quill. They has a small inkwell at their side which they dip their quill inside. They begin to drag the dark ink across the paper in broad overly dramatic flourishes for several moments. It takes several long moments before they ask the most important question they'll ever ask you."

    "Legion Guard" "\"Who are you?\""

    jump player_creation

label player_creation:
    # player_appearance = {
        # "Height" : 69,
        # "Overheight" : 0,
        # "Weight" : 170,
        # "Overweight" : 0,
        # "Chest" : 0,
        # "Cock" : False,
        # "Cock Type" : "Human", # "Human", "Canine", "Equine"
        # "Cock Length" : 0,
        # "Sheath" : "None", # "None", "Sheath", "Slit"
        # "Balls" : False,
        # "Ballsize" : 0,
        # "Vagina" : False,
        # "Legs" : "Human", # "Human", "Furred Plantigrade", "Reptile Plantigrade", "Furred Digitigrade", "Reptile Digitigrade" "Equine"
        # "Arms" : "Human", # "Human", "Furred", "Reptile"
        # "Torso" : "Human", # "Human", "Furred", "Reptile"
        # "Face" : "Human", # "Human", "Orc, "Kobold, "Goblin", "Canine", "Feline", "Reptile", "Equine", "Bovine", "Rodent"
        # "Tail" : "None", # "None", "Canine", "Feline", "Reptile", "Equine", "Bovine"
        # "Skin Color" : "Beige",
        # "Fur Color" : "Black",
        # "Scale Color" : "Red",
        # "Ears" : "Human", # "Human", "Rodent", "Canine", "Feline", "Bovine", "Equine", "Reptile"
        # "Tusks" : False,
        # "Claws" : False,
        # "Fangs" : False
    menu:
        "You're a..."
        "Male":
            $ pc.profile['Gender'] = "Male"
            $ player_appearance['Cock'] = True
        "Female":
            $ pc.profile['Gender'] = "Female"
            $ player_appearance['Vagina'] = True
            $ player_appearance['Chest'] = 3

    menu:
        "You're a [pc.profile[Gender]]..."
        "Goblin":
            $ pc.profile['Race'] = "Goblin"
            $ player_appearance['Height'] = 41
            $ player_appearance['Overheight'] = renpy.random.randint(1,4) + renpy.random.randint(1,4)
            $ player_appearance['Weight'] = 35
            $ player_appearance['Overweight'] = renpy.random.choice([0.5,1,1.5])
            $ player_appearance['Skin Color'] = renpy.random.choice(["Green","Rust"])
            $ player_appearance['Face'] = "Goblin"
            $ player_appearance['Legs'] = "Human"
            $ player_appearance['Arms'] = "Human"
            $ player_appearance['Torso'] = "Human"
            $ player_appearance['Ears'] = "Human"
            $ player_appearance['Tail'] = "None"
            if pc.profile['Gender'] == "Male":
                $ player_appearance['Balls'] = True
                $ player_appearance['Ballsize'] = 1
                $ player_appearance['Cock Type'] = "Human"
            else:
                $ player_appearance['Balls'] = False

            # Increase and Decrease Stats
            $ pc.combat = 8
            $ pc.survival = 12
        "Orc":
            $ pc.profile['Race'] = "Orc"
            $ player_appearance['Height'] = 64
            $ player_appearance['Overheight'] = renpy.random.randint(1,8) + renpy.random.randint(1,8)
            $ player_appearance['Weight'] = 175
            $ player_appearance['Overweight'] = renpy.random.randint(1,6) + renpy.random.randint(1,6)
            $ player_appearance['Skin Color'] = renpy.random.choice(["Green","Rust"])
            $ player_appearance['Face'] = "Orc"
            $ player_appearance['Legs'] = "Human"
            $ player_appearance['Arms'] = "Human"
            $ player_appearance['Torso'] = "Human"
            $ player_appearance['Ears'] = "Human"
            $ player_appearance['Tail'] = "None"
            if pc.profile['Gender'] == "Male":
                $ player_appearance['Balls'] = True
                $ player_appearance['Ballsize'] = 3
                $ player_appearance['Cock Type'] = "Human"
            else:
                $ player_appearance['Balls'] = False

            $ player_appearance['Tusks'] = True

            # Increase and Decrease Stats
            $ pc.combat = 12
            $ pc.glamour = 8
        "Kobold":
            $ pc.profile['Race'] = "Kobold"
            $ player_appearance['Height'] = 25
            $ player_appearance['Overheight'] = renpy.random.randint(1,4) + renpy.random.randint(1,4)
            $ player_appearance['Weight'] = 25
            $ player_appearance['Overweight'] = renpy.random.choice([0.5,1,1.5])
            $ player_appearance['Skin Color'] = "Pink"
            $ player_appearance['Scale Color'] = renpy.random.choice(["Red","Orange","Yellow","Black","Blue","Green"])
            $ player_appearance['Face'] = "Kobold"
            $ player_appearance['Legs'] = "Reptile Digitigrade"
            $ player_appearance['Arms'] = "Reptile"
            $ player_appearance['Torso'] = "Reptile"
            $ player_appearance['Ears'] = "Reptile"
            $ player_appearance['Tail'] = "Reptile"
            if pc.profile['Gender'] == "Male":
                $ player_appearance['Balls'] = False
                $ player_appearance['Sheath'] = "Slit"
                $ player_appearance['Cock Type'] = "Human"
            else:
                $ player_appearance['Balls'] = False

            # Increase and Decrease Stats
            $ pc.acumen = 12
            $ pc.combat = 8
        "Minotaur":
            $ pc.profile['Race'] = "Minotaur"
            $ player_appearance['Height'] = 72
            $ player_appearance['Overheight'] = renpy.random.randint(1,12) + renpy.random.randint(1,12)
            $ player_appearance['Weight'] = 200
            $ player_appearance['Overweight'] = renpy.random.randint(1,6) + renpy.random.randint(1,6)
            $ player_appearance['Skin Color'] = "Pink"
            $ player_appearance['Fur Color'] = renpy.random.choice(["Brown","Black","White"])
            $ player_appearance['Face'] = "Bovine"
            $ player_appearance['Legs'] = "Equine"
            $ player_appearance['Arms'] = "Human"
            $ player_appearance['Torso'] = "Human"
            $ player_appearance['Ears'] = "Bovine"
            $ player_appearance['Tail'] = "Bovine"
            if pc.profile['Gender'] == "Male":
                $ player_appearance['Balls'] = True
                $ player_appearance['Ballsize'] = 4
                $ player_appearance['Sheath'] = "Sheath"
                $ player_appearance['Cock Type'] = "Equine"
            else:
                $ player_appearance['Balls'] = False

            # Increase and Decrease Stats
            $ pc.combat = 12
            $ pc.survival = 8
        "Werewolf":
            $ pc.profile['Race'] = "Werewolf"
            $ player_appearance['Height'] = 66
            $ player_appearance['Overheight'] = renpy.random.randint(1,8) + renpy.random.randint(1,8)
            $ player_appearance['Weight'] = 180
            $ player_appearance['Overweight'] = renpy.random.randint(1,6) + renpy.random.randint(1,6)
            $ player_appearance['Skin Color'] = "Pink"
            $ player_appearance['Fur Color'] = renpy.random.choice(["Brown","Black","White","Gray"])
            $ player_appearance['Face'] = "Canine"
            $ player_appearance['Legs'] = "Furred Digitigrade"
            $ player_appearance['Arms'] = "Furred"
            $ player_appearance['Torso'] = "Furred"
            $ player_appearance['Ears'] = "Canine"
            $ player_appearance['Tail'] = "Canine"
            if pc.profile['Gender'] == "Male":
                $ player_appearance['Balls'] = True
                $ player_appearance['Ballsize'] = 3
                $ player_appearance['Sheath'] = "Sheath"
                $ player_appearance['Cock Type'] = "Canine"
            else:
                $ player_appearance['Balls'] = False

            $ player_appearance['Fangs'] = True
            $ player_appearance['Claws'] = True

            # Increase and Decrease Stats
            $ pc.combat = 11
            $ pc.acumen = 9
        "Wererat":
            $ pc.profile['Race'] = "Wererat"
            $ player_appearance['Height'] = 52
            $ player_appearance['Overheight'] = renpy.random.randint(1,6) + renpy.random.randint(1,6)
            $ player_appearance['Weight'] = 85
            $ player_appearance['Overweight'] = renpy.random.randint(1,4) + renpy.random.randint(1,4)
            $ player_appearance['Skin Color'] = "Pink"
            $ player_appearance['Fur Color'] = renpy.random.choice(["Brown","Black","White","Gray"])
            $ player_appearance['Face'] = "Rodent"
            $ player_appearance['Legs'] = "Furred Digitigrade"
            $ player_appearance['Arms'] = "Furred"
            $ player_appearance['Torso'] = "Furred"
            $ player_appearance['Ears'] = "Rodent"
            $ player_appearance['Tail'] = "Rodent"
            if pc.profile['Gender'] == "Male":
                $ player_appearance['Balls'] = True
                $ player_appearance['Ballsize'] = 2
                $ player_appearance['Sheath'] = "Sheath"
                $ player_appearance['Cock Type'] = "Human"
            else:
                $ player_appearance['Balls'] = False

            $ player_appearance['Fangs'] = True
            $ player_appearance['Claws'] = True

            # Increase and Decrease Stats
            $ pc.glamour = 8
            $ pc.survival = 12

    python:
        pc.profile['Name'] = renpy.input("You're a [pc.profile[Gender]] [pc.profile[Race]], named...",length = 12)
        pc.profile['Name'] = pc.profile['Name'].strip()

        if not pc.profile['Name']:
            pc.profile['Name'] = "Player"

    menu:
        "You're a [pc.profile[Gender]] [pc.profile[Race]], named [pc.profile[Name]]. Does that sound right?"
        "Yes":
            jump scene_introduction_02
        "No":
            jump player_creation

label scene_introduction_02:
    "The guard continues to scrawl information into their ledger. You're forced to wait uncomfortably while the guard lets the ink dry. Some cruel last minute attempt at torture as they stare at their pretentious scrawlings. Your eyes can't help but wander over the long wooden docks. Several large ships with elegant bows flying the Legion's colors of blue and silver sit unpleasantly in the bay. Like hungry watch dogs, calm in the moment but ready to pounce at their masters slightest whim."

    "The port has several stone buildings surrounded by a semi-circular stone wall that cuts off the Legion's stronghold from the rest of the island. Several tall stone towers with wooden tops line the wall. You can just barely make out the shapes of guards poised with bows at their sides. A tall lighthouse stands on a cluster of rocks in the ocean. Stoic and defiant against the harsh crashing waves that turn this island into a prison."

    "A sharp clap startles you as the ledger is abruptly slammed shut. The guard waves a hand frivolously causing the rest of the guards to stand up straight. A spear pokes you roughly in the backside and you're urged forward. They don't speak to you as you're forcefully lead down the dock towards the fortress walls. You're treated more like meat with legs then a person."

    $ add_time(0,10)

    "The tall walls quickly come into view, standing tall and opposing. Two tall towers flank a closed gate like prison wardens. They stare down at you as if you were an ant, making you feel small and meek in their presence. The gate creaks and groans as from some unseen location a winch is turned pulling the portcullis free."

    $ add_time(0,10)

    scene bg forest_day with fade
    $ map_point = south_forest_01
    "Beyond is a dark pine forest, several path beaten into the dirt by your fellow prisoners who now try to survive on this cursed island. The sight looms and stretches out before you. The collar around your neck feels heavy and the weight of your situation begins to overwhelm you. There's almost something comforting about the oppressive walls of the Legion's fortress. It's cruel and oppressive but it's a known evil."

    "The guard don't give you a choice in the matter however. A sharp prod in the back forces you forward lest you end up run through. You stumble forward barely breaking beyond the threshold before the gate closes behind you. The guards don't leave you any parting words but the dark glare from the archers high above are enough to make you press forward. They certainly wouldn't hesitate to fire upon you should you stay in the area."

    "There's a strange sense of unease and anxiety that fills you as you press forward, delving into the darkness of the pine forest. The trees are tall and scattered which provides some room to move. However the tall branches overhead knit together forming a sharp needle filled canopy that blocks much of the sky from view. Only allowing small beams to pierce the forest floor."

    "You walk for several minutes, not having any aim or purpose beyond getting away from the fort. You can see many tracks that seem to have a similar aimlessness. Fresh and old tracks mingle here in a tapestry of anxiety and hopelessness."
    $ add_time(0,10)

    menu:
        "Scavenge":
            $ add_time(0,5)
            jump scene_introduction_03

label scene_introduction_03:
    "Fearing you may be attacked you find a low hanging branch, an uncommon thing among the tall pines. You grip it tightly, twisting and bending it unceremoniously for a moment until it breaks free with a dull snap. It maybe a good idea to arm yourself before proceeding any further."
    $ addToInventory(item_stick,1)
    $ accessInventory = True
    $ last_scene = "scene_introduction_03"
    show screen menubar(False,True,False,False)

    while pc.hands['Right'] == None:
        pause

    $ add_time(0,5)

    jump scene_introduction_04

label scene_introduction_04:
    show bg forest_day with dissolve
    $ accessInventory = True
    $ last_scene = "scene_introduction_04"

    menu:
        "The anxiety still present in your mind is lessened by the comforting feel of having a weapon in hand. Though not a good one, it still provides some relief. Taking a deep breath you prepare to head forward in search of some kind of shelter and a source of food. Without either you won't survive long here."
        "Explore":
            "You head deeper into the forest, searching the cavernous forest for a place to make your camp. You do your best to maintain a single direction, weaving your way around the thick trees. The smell of sap and pine grows stronger as you progress deeper."
            "Suddenly a dark shape leaps from a low branch landing in front of you. The small green skinned goblin has a wild look in their eye. They prepare to fight brandishing a small stick in your face."
            $ add_time(0,5)
            $ last_scene = "scene_introduction_05"
            if renpy.random.randint(0,1) == 1:
                $ _enemy = Hostile("Female Goblin Collared",10,4,10,2,4,4,4,4,"Goblin","Goblin","Female",store.skill_strike,None,None,None,None,None,"Weak","tutorial_battle")
            else:
                $ _enemy = Hostile("Male Goblin Collared",10,4,10,2,4,4,4,4,"Goblin","Goblin","Male",store.skill_strike,None,None,None,None,None,"Weak","tutorial_battle")
            call scene_battle_setup pass (_en = _enemy) from _call_scene_battle_setup

label scene_introduction_05:
    $ last_scene = "scene_introduction_05"
    menu:
        "Having sent the crazed goblin on it's way, you prepare to move again. As dangerous as it might be to venture further you can't stay here either. The dense canopy of needles above may provide some cover from the elements but "
        "Explore":
            $ south_forest_02.discovered = True
            $ map_point = south_forest_02
            "The sparse trees the fill the forest all begin to blur together the more you walk. As much as you walk the forest all looks the same. You breath begins to catch in your lungs as feelings of isolation and panic creep into your mind. Like a twisted parasite clawing at the back of your brain. The collar suddenly feels suffocating and heavy dragging you down like an anchor."

            "Just as the weight of hopelessness begins to take hold and you feel you're about to collapse something catches your eye. A small copse, pine branches parted just enough to allow a faint beam of fading light into it's center. Like a beacon of hope there's a cluster of rocks, carefully arranged. Stepping into the sunlight you can see the rocks are clearly forming several arrows. You don't know what they point towards but you're sure they point to something important."

            scene bg forest_night with fade
            "The realization is comforting though the fading light urges you to continue moving. You at least have a few clear destination and a clear landmark. Looking towards the largest arrow you prepare to push further into the woods."

            jump scene_introduction_06

label scene_introduction_06:
    $ last_scene = "scene_introduction_06"
    "You start moving steadily forward, following the guidance of the mysterious stone arrangement. Making some progress and feeling confident in your navigation for a time, but the shadows grow longer. Darkness and night is descending quickly and you aren't sure how much longer you can keep going in the dark."

    menu:
        "Dusk fades and you're quickly left in darkness, what little starlight there is can barely piece the thick canopy above. You see a small flicker of light in the distance between the veil of tree trunks and low branches. You rush towards it hoping for sanctuary, but a sharp sound draws your attention just in time to feel a sharp impact at your side. Something large and growling sends you sprawling across the ground."
        "Explore":
            jump battle_forest.nightstalker

# Battle set up
# Set default variables and reset anything that needs to be reset at the beginning of a battle
label scene_battle_setup(_en = None,_eq_acc = None,_eq_torso = None,_eq_legs = None,_eq_left = None,_eq_right = None,_con = "",_ambush = False,_pc_ambush = False):
    show screen clock
    hide screen menubar

    if isinstance(_en,Hostile):
        python:
            # player_turn = True
            turn_start = True
            hit = 0
            crit = 0
            miss = 0
            selected_skill = None
            flee_succeed = False
            mob_flee = False
            mob_submit = False
            combat_history = []

            # SET ENEMY
            enemy = _en

            # EQUIP ENEMY ARMORS
            if isinstance(_eq_acc,Armor):
                enemy.equip_armor(_eq_acc,_eq_acc.slot)
            else:
                enemy.equipment["Acc"] = None

            if isinstance(_eq_torso,Armor):
                enemy.equip_armor(_eq_torso,_eq_torso.slot)
            else:
                enemy.equipment["Chest"] = None
            if isinstance(_eq_legs,Armor):
                enemy.equip_armor(_eq_legs,_eq_legs.slot)
            else:
                enemy.equipment["Legs"] = None
            # EQUIP ENEMY WEAPONS
            if isinstance(_eq_left,Weapon):
                enemy.equip_weapon(_eq_left)
            else:
                enemy.hands["Left"] = None
            if isinstance(_eq_right,Weapon):
                enemy.equip_weapon(_eq_right)
            else:
                enemy.hands["Right"] = None

            # enemy.update_all()

            enemy.condition = _con
            enemy.updateBuffs()

            spr = []
            spr += get_sprite_list(enemy.sprite)
            enemy.hp = enemy.max_hp
            if enemy.condition == "Aroused":
                enemy.libido = int(enemy.max_libido/2)
            else:
                enemy.libido = 0

            turn_count = 1

            # Check if the encounter is an Ambush. If it is the enemy goes first by default. Otherwise test awareness
            if _ambush:
                player_turn = False
                combat_history.append(str(enemy.profile['Name']) + " bursts from the shadows. You have been ambushed.")
            elif _pc_ambush:
                player_turn = True
                combat_history.append("You take advantage of the situation and bursts from the shadows."  + str(enemy.profile['Name']) + " has been ambushed.")
            else:
                # Determine if player or enemy starts first
                # Enemy and Player roll a gray dice per 4 points in Survival
                # Player wins ties
                _pc_s = 0
                for _i in range(int(pc.survival/4)):
                    _pc_s += grayDice.roll()[0]
                _en_s = 0
                for _i in range(int(enemy.survival/4)):
                    _en_s += grayDice.roll()[0]

                player_turn = True
                if _en_s > _pc_s:
                    player_turn = False

                combat_history.append("Player rolled : " + str(_pc_s))
                combat_history.append("Enemy rolled : " + str(_en_s))


        image enemy_healthy_chaste = "[spr[0]]"
        image enemy_hurt_chaste = "[spr[1]]"
        image enemy_healthy_lusty = "[spr[2]]"
        image enemy_hurt_lusty = "[spr[3]]"

    else:
        jump expression map_point._scene

    if 8 < calendar[3] < 20:
        show expression map_point.bg_day with Fade(0.2,0.2,0.5)
    else:
        show expression map_point.bg_night with Fade(0.2,0.2,0.5)

    show screen action_history(combat_history) with None
    show screen action_menu(pc,False) with None
    show screen enemy_status(enemy) with None

    jump scene_battle_loop

label scene_battle_loop:
    while flee_succeed == False and mob_flee == False and mob_submit == False and enemy.hp > 0 and pc.hp > 0:
        hide enemy_healthy_chaste
        hide enemy_hurt_chaste
        hide enemy_healthy_lusty
        hide enemy_hurt_lusty

        # Show enemy sprites
        if enemy.hp >= enemy.max_hp/2:
            if enemy.buff["Lusty"][0]:
                show enemy_healthy_chaste:
                    yalign 0.5
                    xalign 0.5
            else:
                show enemy_healthy_lusty:
                    yalign 0.5
                    xalign 0.5
        else:
            if enemy.buff["Lusty"][0]:
                show enemy_hurt_chaste:
                    yalign 0.5
                    xalign 0.5
            else:
                show enemy_hurt_lusty:
                    yalign 0.5
                    xalign 0.5

        $ selected_skill = None

        if player_turn:
            # If turn_start apply buffs and bonuses
            if turn_start:
                $ combat_history.insert(0,pc.turn_begin_update())
                $ turn_start = False
                pause 0.5
            # Player Actions Here
            # While player_action_menu is True player can select from skills
            # If false check for inventory interaction instead
            if player_action_menu:
                call screen action_menu(pc,True)
                show screen action_menu(pc,False)
                $ player_action = _return

                if player_action in range(0,5):
                    $ _tsk = use_skill(pc.skills[selected_skill],pc,enemy)
                    $ combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk[0]))

                    $ player_turn = False
                    $ turn_start = True
                    $ combat_history.insert(0,pc.turn_end_update())

                    pause 0.75
                elif player_action == 6:
                    $ _tsk = rest(pc,enemy,0)
                    $ combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk[0]))

                    $ player_turn = False
                    $ turn_start = True
                    $ combat_history.insert(0,pc.turn_end_update())

                    pause 0.75
                elif player_action == 7:
                    if standd6.roll()[0] + standd6.roll()[0] >= 7:
                        $ flee_succeed = True
                    else:
                        $ combat_history.insert(0,"Turn " + str(turn_count) + " - attempted to flee but failed")

                    $ player_turn = False
                    $ turn_start = True
                    $ combat_history.insert(0,pc.turn_end_update())

                    pause 0.75

            # INVENTORY ACTIONS HERE
            else:
                $ turn_start = True
                $ player_turn = False

        else:
            # Enemy Actions Here
            # Pre Turn Buffs and Debuffs
            if turn_start:
                $ combat_history.insert(0,enemy.turn_begin_update())
                $ turn_start = False
                pause 0.75
            # Determine Enemy Actions
            # First check if enemy flees
            # Set DC based on enemy HP
            # At full health the enemy won't flee
            # At half health there is 1/36 chance of fleeing
            # At quarter health 3/36 chance of fleeing
            # Melancholy or Cowardly trait increase the DC by 2
            if not turn_start:
                # If mob isn't Aggro it has a chance to flee
                if not enemy.buff["Aggro"][0]:
                    $ _dc = 1
                    $ _dc2 = 1
                    if enemy.hp <= enemy.max_hp/2:
                        $ _dc += 1
                    if enemy.hp <= enemy.max_hp/4:
                        $ _dc += 1
                    if enemy.condition == "Melancholy" or enemy.condition == "Cowardly":
                        $ _dc += 2
                        $ _dc2 += 2
                    # Check 2d6 vs DC
                    if standd6.roll()[0] + standd6.roll()[0] <= _dc:
                        # On a fail roll a d6
                        # If the enemy is Melancholy or Cowardly the enemy flees on a 3 or less
                        # Otherwise the enemy flees on a 1
                        if standd6.roll()[0] <= _dc2:
                            # ADD FLEE ATTEMPT LATER
                            $ mob_flee = True

                # If mob isn't Continue it has a chance to submit
                if not enemy.buff["Continue"][0]:
                    $ _dc = 1
                    $ _dc2 = 1
                    if enemy.libido >= enemy.max_libido/2:
                        $ _dc += 1
                    if enemy.libido <= enemy.max_libido/4:
                        $ _dc += 1
                    if enemy.condition == "Submissive":
                        $ _dc += 2
                        $ _dc2 += 2
                    # Check for submission
                    if standd6.roll()[0] + standd6.roll()[0] <= _dc:
                        # On a fail roll a d6
                        # If the enemy is Melancholy or Cowardly the enemy flees on a 3 or less
                        # Otherwise the enemy flees on a 1
                        if standd6.roll()[0] <= _dc2:
                            # ADD FLEE ATTEMPT LATER
                            $ mob_submit = True

                # If mob isn't fleeing or submitting determine their attack action
                if not mob_flee and not mob_submit:
                    python:
                        _list = []
                        _i = 0
                        for _i in range(6):
                            if enemy.skills[_i] != None:
                                if enemy.skills[_i].stam <= enemy.stamina:
                                    _o = 0
                                    for _o in range(enemy.skills[_i].skill_priority(enemy,pc)):
                                        _list.append(enemy.skills[_i])
                        if len(_list) > 0:
                            _tsk = use_skill(_list[renpy.random.randint(0,len(_list)-1)],enemy,pc)
                        else:
                            _tsk = use_skill(skill_struggle,enemy,pc)

                        # Show weighted attack list
                        # for _i in _list:
                        #     combat_history.insert(0,str(_i.name))

                        combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk[0]))


                $ turn_start = True
                $ player_turn = True
                $ combat_history.insert(0,pc.turn_end_update())

        $ turn_count += 1

    pause
    # Combat ended
    # Add victory thing here

    python:
        _e = "martial_victory"
        if flee_succeed:
            _e = "player_flee"
        elif mob_flee:
            _e = "mob_flee"
        elif mob_submit:
            _e = "mob_submit"
        elif pc.hp <= 0:
            if pc.buff["Lusty"][0] or pc.libido >= pc.max_libido:
                _e = "lust_defeat"
            else:
                _e = "martial_defeat"
        else: # enemy.hp <= 0:
            if enemy.buff["Lusty"][0] or enemy.libido >= enemy.max_libido:
                _e = "lust_victory"
            else:
                _e = "martial_victory"

    # DETERMINE ENDING TO JUMP TO
    call scene_battle_end pass (_e) from _call_scene_battle_end # from _call_scene_battle_end

label scene_battle_end(_end = "martial_victory"):
    hide screen enemy_status
    hide screen action_menu
    hide screen action_history
    $ add_time(0,10)

    # if isinstance(enemy,Hostile):
    jump expression enemy.ending + "." + _end
    # else:
    #     jump scene_last

label battle_clean_up:
    hide enemy_healthy_chaste
    hide enemy_healthy_lusty
    hide enemy_hurt_chaste
    hide enemy_hurt_lusty

    if pc.hp <= 0:
        $ pc.hp = pc.max_hp
        $ pc.libido = 0
        $ _s = str(last_checkpoint)
        jump expression _s
    else:
        jump scene_last

label scene_last:
    # Jumps the player to the last scene
    # Use after battles, inventory access, or map access
    # ""
    $ _s = map_point._scene
    if last_scene == None:
        if 8 < calendar[3] < 20:
            show expression map_point.bg_day with dissolve
        else:
            show expression map_point.bg_night with dissolve
    else:
        $ _s = str(last_scene)
        $ last_scene = None

    # show screen clock()
    # with moveinleft
    # $ accessInventory = True
    # $ accessMap = True
    # show screen menubar(False,accessInventory,accessMap,False)
    # with moveinright

    jump expression _s

label scene_scavenge_begin:
    if 8 < calendar[3] < 20:
        show expression map_point.bg_day# with dissolve
    else:
        show expression map_point.bg_night# with dissolve

    # show screen clock with None
    # hide screen menubar with moveoutright

    # Determine Scavenge Event
    # First check hostility and see if there is a combat encounter
    # If not compile a list of scavenge events and pick one at random based on weight
    # To check for hostility roll 2d6 any roll equal to or less then the locations hostility results in a hostile encounter
    # Hostile Encounter
    python:
        global map_point
        __temp = map_point._scene
        if standd6.roll()[0] + standd6.roll()[0] <= map_point.hostility:
            _temp_list = []
            _i = 0
            # Loop through encounter list
            for _i in map_point.encounter:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = map_point._scene
        # Scavange Encounter
        else:
            _temp_list = []
            _i = 0
            # Loop through scavenge list
            for _i in map_point.scavenge:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = "scene_last"


    jump expression __temp

label scene_explore_begin:
    if 8 < calendar[3] < 20:
        show expression map_point.bg_day# with dissolve
    else:
        show expression map_point.bg_night# with dissolve

    # show screen clock with None
    # hide screen menubar with moveoutright

    # Determine Scavenge Event
    # First check hostility and see if there is a combat encounter
    # If not compile a list of scavenge events and pick one at random based on weight
    # To check for hostility roll 2d6 any roll equal to or less then the locations hostility results in a hostile encounter
    # Hostile Encounter
    python:
        global map_point
        __temp = map_point._scene
        if standd6.roll()[0] + standd6.roll()[0] <= map_point.hostility:
            _temp_list = []
            _i = 0
            # Loop through encounter list
            for _i in map_point.encounter:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = map_point._scene
        # Scavange Encounter
        else:
            _temp_list = []
            _i = 0
            # Loop through scavenge list
            for _i in map_point.explore:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = "scene_last"

    jump expression __temp


#
