# Last Drop Encounters

label scene_last_drop:
    label .exterior:
        $ outdoor()
        $ map_point = the_last_drop

        if 8 < calendar[3] < 20:
            show bg forest_day with dissolve
        else:
            show bg forest_night with dissolve

        $ _t = ""
        # Day
        if calendar[3] > 6 and calendar[3] < 20:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    $ _t = "The exterior of the Last Drop is a strange sight. A stone base with several glasses windows support a sagging wooden second floor. Several crudely constructed wooden shutters have been added to the window frames. They sit open allowing a full view of the quaint tavern interior. Moss cling to the building and creep up it's sides. Several bushes grow under the windows. It's impossible to tell if they are there for decoration or because their roots have grown to deep to be removed."
                # Rain
                elif weather == 2:
                    $ _t = "It's dark and cold outside. Rain beats downs furiously around you, the clearing offering no protection against the storm. The sagging wood of the second floor creaks as water rushes off the thatch rooftop in buckets. Wooden window shutters are closed and locked against the rain. Small fragments of candlelight flicker between cracks in the shutters, a small sign of the respite that lies inside. Wind rushes through the clearing sending an icy chill through you in the unforgiving space."
                # Storm
                else:
                    $ _t = "The Last Drop stands against the storm as a small sign of respite against nature's wrath. The building creaks and groans in protest as the icy rain and wind assault it from all sides. The powerful crack of thunder is the only sound the penetrates the drumming of the rain and howling of the wind. The window shutters rattle and shake violently in the wind. Each shake parting them enough to allow a sliver of fire light to pierce the darkness outside."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Last Drop Exterior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Last Drop Exterior. Day"
                # Storm
                else:
                    $ _t = "Crescente Storm Last Drop Exterior. Day"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Last Drop Exterior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Last Drop Exterior. Day"
                # Storm
                else:
                    $ _t = "Messis Storm Last Drop Exterior. Day"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Last Drop Exterior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Last Drop Exterior. Day"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Last Drop Exterior. Day"
        # Night
        else:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    $ _t = "The tall two storey exterior of the Last Drop sag in the darkness. It's thatch roof hangs limply across it's top while the stone foundation quiver to keep the structure aloft. Window shutters sit partially ajar allowing the firelight inside to spill out, cutting through the darkness outside like a small beacon. The fresh smell of alcohol and cooked meats creep out with the light. You can hear the bustle of people inside as they move about the tavern."
                # Rain
                elif weather == 2:
                    $ _t = "Dark clouds hang overhead obscuring the moon and stars. Heavy rain pours down in sheets across the clearing sending a damp chill through the area. The creaking structure of the Last Drop stand silhouetted in the darkness. Small beams of firelight flicker from between the rattling wood shutters. The wind cuts through the clearing, battering the ancient structure which stands defiantly against the onslaught. Any sound from the tavern is obscured by the harsh whistling of the wind and the ferocious drumming of rain against the rooftop."
                # Storm
                else:
                    $ _t = "The sky is pitch black with storm clouds, choking out the moonlight. Flashes of lightning illuminate the area in harsh bursts revealing the haggard tavern. The Last Drop trembles under the ferocity of the storm, shutters rattling loudly against their hinges. Small beams of light peak out from behind the shutters as they tremble. They act as a small beacon of respite and security against the wrathful storm that brews overhead. The surrounding clearing provides no cover from the icy winds and rain which cut like a knives."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Last Drop Exterior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Last Drop Exterior. Night"
                # Storm
                else:
                    $ _t = "Crescente Storm Last Drop Exterior. Night"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Last Drop Exterior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Last Drop Exterior. Night"
                # Storm
                else:
                    $ _t = "Messis Storm Last Drop Exterior. Night"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Last Drop Exterior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Last Drop Exterior. Night"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Last Drop Exterior. Night"

        menu:
            "[_t]"

            "Enter":
                jump .tavern
            "Search the back":
                jump .beehives
            "Scavenge":
                jump scene_scavenge_begin
            "Explore":
                jump scene_explore_begin

    label .tavern:
        $ indoor()
        $ map_point = the_last_drop

        if 8 < calendar[3] < 16:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    "The tavern interior is comforting and cozy in the summer months. The window covers are open wide allowing sunlight to stream in freely. Light dances across the man mismatched tables, chairs and broken bits of pottery. Spring flowers add a splash of color to the otherwise brown and gray interior. The smell of fresh flowers, honey mead and dried meats fill the space. A large fireplace sits as an unlit center piece for the room."
                    "Squeeb, the short wererat bartender obsessively cleans dishes, tankards and tabletops. Carefully hoping between each job like a carefully mastered dance."
                # Rain
                elif weather == 2:
                    "The tavern interior feels damp and cool from the rain. The windows have been closed and locked with wooden shutters to prevent the rain from streaming into the building. The place is dimly lit by candles which gives it a cozy feel. You can hear the rapid tapping of rain against the roof and the splash of water running down the building in small rivers."
                    "The spring rain chills the tavern, which has prompted the early use of a small fire in the hearth. Small red embers illuminate the dining area. The occasional pop and crackle of burning wood pierces through the din of the rain outside."
                    "Squeeb hurriedly moves about the tavern, refilling drinks, replacing candles and firewood before rushing back to cook a meal or two. He dances between each job rapidly and with an intense precision and drive that is inspiring."
                # Storm
                else:
                    "The tavern interior is locked tight against the loud storm that brews outside. The window shutters rattle against the locks that hold them in place. The impossible din of rain pummeling the ancient building fills the interior, only broken by the loud crack of thunder. Light peaks through the shutters with each flash of lightning, causing ominous shadows to dance across the walls like ghosts."
                    "A small fire flickers desperately in the hearth as it fights against the storm. The fire illuminates the tavern interior with the aid of a few carefully placed candles. The warm firelight is a small comfort against the storm that rages outside."
                    "Squeeb hurriedly moves about the tavern, refilling drinks, replacing candles and firewood before rushing back to cook a meal or two. He dances between each job rapidly and with an intense precision and drive that is inspiring."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Last Drop Interior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Last Drop Interior. Day"
                # Storm
                else:
                    $ _t = "Crescente Storm Last Drop Interior. Day"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Last Drop Interior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Last Drop Interior. Day"
                # Storm
                else:
                    $ _t = "Messis Storm Last Drop Interior. Day"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Last Drop Interior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Last Drop Interior. Day"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Last Drop Interior. Day"
        else:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    "The tavern interior is dimly lit by candles and a low fire that crackles in the hearth. The windows are partially closed allowing a comfortable breeze to pass through. The light flickers in the breeze. Small flowers sit in broken pots that dot the mismatched tables. The tavern is warm and comforting in spite of it's cobbled together interior. The smell of freshly cooked meats wafts in from the kitchen. The scent mingles with the sharp tangy smell of alcohol and dried berries."
                    "Squeeb, the short wererat bartender meticulously dances between the bar and kitchen. Fetching meals and drink for his patrons while still maintain time to mingle. He's a sight to behold, his commitment to this place is inspiring."
                # Rain
                elif weather == 2:
                    "The tavern is cold and damp as the heavy rain beats against the building outside. The heavy splashing of water against the roof echoes throughout the interior. The window shutters tremble against the wind adding a rattle sounds to the din of noise the storm is causing. Soft candle light flicker weakly against the encroaching darkness, while the small embers of a lingering fire add a small bit of respite to the chill of the storm."
                    "Squeeb hurriedly rushes between his many jobs, tending to the tables, cooking meals, and serving drinks. He does so with a shocking precision and speed like an expertly honed craft. Fenna has made one of her rare appearances, emptying clay buckets of water which have been used to catch any leaks. She moves about cautiously, tossing full buckets and replacing them with empty ones."
                # Storm
                else:
                    "The interior of the last drop is filled with a cacophony of noises. The torrential downpour outside beats against the walls of the tavern like a thousand drums. Lightning flashes and thunder cracks loudly. The entire building creaks and groans against the onslaught of the storm. The candle light that fights against the darkness flickers and sputters against the heavy draft. A fire burns strongly in the fireplace, burning brightly against the biting cold outside."
                    "The little tavern has made itself a small site of respite against the encroaching storm, and it's owners work hard to maintain it. Fenna repairs shutters and empties large buckets of water that has leaked through the building's many cracks. Squeeb hastily dances between the bar and kitchen. Bringing food and drink to the cowering patrons. Their commitment is an inspiring sight in the face of such a horrible storm."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Last Drop Interior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Last Drop Interior. Night"
                # Storm
                else:
                    $ _t = "Crescente Storm Last Drop Interior. Night"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Last Drop Interior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Last Drop Interior. Night"
                # Storm
                else:
                    $ _t = "Messis Storm Last Drop Interior. Night"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Last Drop Interior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Last Drop Interior. Night"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Last Drop Interior. Night"


        menu:
            "Talk to Squeeb":
                jump talk_squeeb
            "Go to your room":
                "Slipping quietly up the stairs you head towards the guest rooms. The stairs creak slightly as you ascend before pushing your way into the small room."
                jump scene_last_drop.safe_room
            "Leave":
                jump scene_last_drop.exterior

    label .safe_room_defeat:
        scene bg basic with fade
        $ indoor()
        $ map_point = the_last_drop
        menu:
            "You were defeated. That sucks"
            "Rest":
                $ last_checkpoint = "scene_last_drop.safe_room_defeat"
                jump scene_last_drop.safe_room
            "Leave":
                jump scene_last_drop.tavern

    label .safe_room:
        show bg basic with dissolve
        $ indoor()
        $ map_point = the_last_drop

        if pc.hp <= 0:
            $ pc.hp = 0
            $ pc.addHP(pc.hp_max/8)
            "You wake up in your room feeling groggy and beaten up. Looks like you had a rough go of it."

        menu:
            "This is the safe room. You can rest here."
            "Rest":
                $ last_checkpoint = "scene_last_drop.safe_room"
                $ add_time(8,0)
                $ pc.hp = pc.max_hp
                $ pc.libido = 0
                jump scene_last_drop.safe_room
            "Level up":
                $ last_checkpoint = "scene_last_drop.safe_room"
                $ add_time(1,0)
                jump scene_vacdes.talk_vacdes
            "Rest and Level up":
                $ last_checkpoint = "scene_last_drop.safe_room"
                $ add_time(8,0)
                $ pc.hp = pc.max_hp
                $ pc.libido = 0
                jump scene_vacdes.talk_vacdes
            "Save":
                hide screen menubar
                hide screen clock
                call screen save
                # jump scene_last_drop.safe_room
            "Leave":
                jump scene_last_drop.tavern

        jump scene_last_drop.safe_room

    label .meet_squeeb_first_death_01:
        scene bg basic with fade
        $ indoor()

        $ map_point = the_last_drop
        $ last_checkpoint = "scene_last_drop.safe_room_defeat"
        $ last_scene = None
        $ pc.hp = pc.max_hp

        "Your eyelids feel heavy and your chest stings as sensations return to you. Reaching to your side you feel a straw mattress under you. You feel a warm but scratchy blanket on top of you. Shifting slightly you force open your eyes to find yourself in a fairly modest, somewhat rundown room."
        "The room is mostly bare of furnishings, just a simple bed that you find yourself laying on. A small worn chair sits next to it as a makeshift bedside table. A cracked vase sits on the chair with a few blue flowers adding a splash of color to the otherwise brown and grey room. Tattered curtains do their best to block the morning light from peaking through."
        "You sit up from the bed and find a fresh set of bandages wrapped around your arm and forehead. The smell of herbs and poultices is strong. Pulling the bandages away slightly you find your injuries mostly healed, leaving only some slight bruising. You remove the bandages completely before gathering your clothes."
        "You step towards the door giving the dingy door handle a pull. It takes some extra force to open, the hinges are old and creak loudly. You try your best to remain somewhat quiet but the old building groans with each step. The floorboards creaking under your weight in protest."
        "The door opens up to a narrow hallway with several doors. The hall ends in a staircase that curves gently downwards. You shuffle towards it stepping gingerly down the stairs, which in spite of your effort to remain quiet still give a loud unpleasant creak every few steps. The stairway leads to a small hall which abruptly opens up to a small tavern."
        "The tavern has a modest bar that faces away from the staircase and looks out over an open room. Several small tables and mismatched chairs fill the space with a large currently empty fireplace along the far wall. Several windows look out over the surrounding forest, though they lack glass which allows a strong breeze to rush through the building. A few beams sag under the buildings weight which makes the room feel cave like."
        "Similar to the bedroom upstairs, several broken vases and pots sit on tables or under windows filled with brightly colored flowers. In spite of the age and damages the place is clearly being maintained to the best of the owner's ability. It's an oddly comforting space as the morning sun peaks through the open windows."
        "A figure catches your eyes behind the bar. A short humanoid man with the face of a rat. He's currently washing down the bar top with a damp rag. His sharp chipped teeth curl into a small smile as your eyes meet. He puts the rag down with a damp splat and extends a hand in greeting."

        show squeeb collared_idle with dissolve
        "???" "\"Good to see you awake. Had us worried there for a bit, but it seems you heal quickly. You must be hungry, let me get you something to eat. Have a seat.\" He gestures to the bar stools before heading to a door behind the bar that you imagine leads to a kitchen."

        hide squeeb with dissolve
        "Your stomach growls greedily at the mention of food, pushing away any inclination to leave. You step up to the bar taking a seat on one of the roughly constructed stools. The thin leather lining does little to for your comfort, but succeeds in function. You wait for several minutes alone. Silence filling the room, broken only occasionally by a chirp of a bird, or the creak of the stool beneath you."

        show squeeb collared_idle with dissolve
        "After a short wait the back door opens, allowing you a brief glimpse at the kitchen beyond. Your vision is quickly blocked by the rat man who pushes his way back into the room, a small clay plate in hand. He sets the plate down on the bar in front of you revealing it's contents. Shredded potatoes have been fried into small hash brown patties, while two lightly scrambles eggs steam next to it. A slice of toasted bread has been smeared with some kind of red jam. The food smells incredible, though that could be your hunger talking."
        "The wererat hands you a wooden fork from under the bar. It barely reaches your hand before you begin to devour the food without restraint. The eggs are light and flavorful, while have a pleasant saltiness to them. The lightly toasted bread crumbles in your mouth, the sweet flavor of the jam rounds out the meal. You've already finished half the meal before you notice a glass of water has been placed in front of you."
        "The water is warm, it was likely boiled to keep it clean. A few dried berries have been added giving it a slightly tangy flavor. The meal only lasts you a few moments before it's been completely consumed down to the last crumb. Your stomach gurgles slightly as you feel truly full for the first time in weeks. You had mostly survived on bread and water during your time on the ship, which hardly succeeded in fulfilling your appetite."

        "???" "\"Well seems I was right about you being hungry.\" he laughs. \"I suppose I can start with the pleasantries now. You can call me Squeeb. This is my tavern. I take in any of the new folks that need to get back on their feet. Folks like you I imagine based on your dress.\""
        if pc.equipment['Legs'] != None:
            "You glance down at yourself suddenly feeling a little self conscious. The holes and tatters of your attire don't inspire any confidence however and you're forced to resign yourself to his comments."
        else:
            "You glance down at your clothing or lack of suddenly a little embarrassed."

        "Squeeb" "\"I don't mean you no offense. It's how most folk start out around here, no shame in it. There's a town a little ways west of here, there should be a tailor that can get you set up if you're inclined. Not that many folk will judge you for walking around in rags or nothing at all for that matter.\" he says, casually refilling your glass with water from a nearby pitcher."
        # 0 = Falsely Accused, 1 = Resistance Fighter, 2 = Thief
        menu:
            # STOPPED WORKING HERE. PICK UP HERE NEXT TIME
            "Squeeb" "\"So what's your name and what brings you here?\" he asks taking your plate which he begins casually wiping clean with a rag."

            "Answer Honestly":
                jump .an_truth
            "Lie":
                jump .an_lie

        label .an_truth:
            if pc_crime == 0:
                "[pc.profile[Name]]" "\"You can call me [pc.profile[Name]]. It's not an exciting story, I was simply in the wrong place at the wrong time. I was accused of murder and that was enough for the Legion. Within moments of the accusation I was put in chains. A sham of a trial the day after and now I'm here.\""
                "Squeeb" "\"You have my condolences, you'll find many in similar situations here. I hope you can find some peace here in spite of the events that lead you here.\" He says sympathetically. \"You're welcome to stay here for as long and whenever you wish.\""
            elif pc_crime == 1:
                "[pc.profile[Name]]" "\"My name is [pc.profile[Name]], I was a part of a resistance movement after the legion invaded. During one of the struggles I was captured and brought here as an example.\""
                "Squeeb" "\"A resistance fighter, that's a brave career choice. You have my respect [pc.profile[Name]].\" He says a small look of surprise on his face. \"I could hardly turn away someone so noble. Please stay here whenever you wish and for as long as you need. The door is always open to you.\""
            elif pc_crime == 2:
                "[pc.profile[Name]]" "\"I'm [pc.profile[Name]]. I got caught picking the pocket of a local lord. They didn't take to kindly to it and once the Legion caught wind I was put on the next ship to Alcatraz.\""
                "Squeeb" "\"A thief, hm? I appreciate the honesty. Few people here are in a position to judge you for such things. Myself least of all.\" He says with a sad nostalgia in his eyes. \"I certainly can't turn down someone so willing to expose their secrets. Feel free to stay here whenever you wish.\""

            $ relationship_squeeb["was_honest"] = True
            jump scene_last_drop.meet_squeeb_first_death_02
        label .an_lie:
            "[pc.profile[Name]]" "\"I'm [pc.profile[Name]], I'm nothing special really. The Legion arrested me for whatever crimes they felt I committed and now I'm here. I'm actually surprised we're just allowed to roam the island and that they allow you to run this... business?\""
            "Squeeb" "\"The Legion doesn't care about much that goes on beyond their walls. So long as you don't attempt to enter or get too close to their forts we're free to act as we wish. As long as I don't bother the Legion or their guards I'm allowed to conduct my business.\""
            "Squeeb" "\"As a fellow prisoner you're welcome to stay here whenever you wish. I'm simply running this place to help people get on their feet again. I simply ask you be honest with me in the future.\" He says somewhat skeptically, though he doesn't press the issue any further."

            $ relationship_squeeb["was_honest"] = False
            jump scene_last_drop.meet_squeeb_first_death_02

    label .meet_squeeb_first_death_02:
        $ indoor()
        $ map_point = the_last_drop

        "[pc.profile[Name]]" "\"Thanks, uh. Earlier, you said \'you had {i}us{/i} worried\', but I haven't seen anyone else.\""
        "Squeeb" "\"Fenna and Lyra. Fenna's out back, she was the one that found you and got you back here in one piece. Fenna's a good lass, quiet but we go way back. If you want to say hi she's usually out back during the day. Sometimes comes by the tavern at night too.\""
        show squeeb at midleft with move
        "As if on queue the creak of a door and jingle of a small metal bell signal someone entering the establishment. A large shadow fills the door as a massive woman enters. A cow like head, with small horns that poke out of her brow. She has long stringy hair that obscures her eyes slightly. She squints at you with an unreadable expression."

        show fenna collared_idle at midright with moveinright

        "Squeeb" "\"Wonderful timing as always. Fenna this is [pc.profile[Name]], it seems they've made a full recovery.\""
        $ _t = ""
        if player_appearance["Height"] < 60:
            $ _t = "She looms over you, menacingly. A great and powerful shadow that blots out everything else from your vision. Her incredible size and presence make you feel like an ant as you stare up at her immense form."
        elif player_appearance["Height"] < 72:
            $ _t = "She towers over you like a giant. Her broad form makes you feel small my comparison as she steps towards you. The light is blotted out by her presence and you can't help but marvel at her form. She locks eyes with you as she takes notice of your leering. You glance away quickly, slightly embarrassed."
        else:
            $ _t = "She steps towards you, one of the rare few who can match your own size. She stares at you, your eyes locked in a silent battle for a few moment. Her presence is intense and you can't help but swallow hard as she looms next to you."

        "The minotaur grunts what sounded like 'good' but was said so halfheartedly that you can't tell for sure. She gives you a small nod but her expression is nearly unreadable. She steps into the tavern, hunching over low to fit through the doorway before heading in your direction. [_t]"

        "With a large hand she reaches behind the bar slowly. Each move she makes is slow, powerful and deliberate. As she pulls her hand back you find her holding a large old axe. She holds it close to the blade and sets it at her side. She locks eyes with you again, giving a nod. Her expression as inscrutable as ever, before giving Squeeb a similar nod."
        "The floorboards creak and groan as she turns and walks towards the door. Hunching low she squeezes through the door and returns to the outside world. A breeze rushes through the tavern interior reminding you to breathe. The exchange couldn't have lasted more then 30 seconds but it felt like 30 minutes."

        hide fenna with moveoutright
        show squeeb at center with move

        "Squeeb" "\"Not one for conversation is she?\" he says with a wheezy laugh. \"She's usually around back during the day. She's a quiet sort but I'm sure she won't mind the company should you feel inclined.\""
        "Squeeb" "\"Right, where were we?\" Squeeb thinks for a few moments, scratching at the underside of his chin with a long clawed finger. His eyes flash as he remembers his place"
        "Squeeb" "\"Right! Lyra as well. I'd never met her before, I think she came on the same ship as you. Lovely lass, wererat like myself. She arrived a few hours before dark and spent the night. When Fenna brought you in she helped treat your wounds.\""
        "Squeeb" "\"I can't say I know much about her beyond that but she left earlier this morning. I imagine she's heading to Vergesseneburg. If you want to thank her I'd start looking there.\" The wererat gives you a kind, if crooked, smile."
        "Squeeb" "\"I'd suggest you head out and familiarize yourself with the area. I left you a map with your things so that should help you find your ways back here if you ever get lost. If you need any clothing or supplies you'll want to head West towards Vergesseneburg. It's a little ways off but you should be able to find it.\""
        "Squeeb" "\"Gold doesn't have much value here but you can barter with almost anything else of use. If you find any strange items and can't find a use you can almost certainly trade them to someone who can.\""
        "Squeeb" "\"If you need anything else don't hesitate to ask.\""
        "With that Squeeb returns to his work, he gathers up your dishes and takes them away to be cleaned. Taking the queue you sit up from the stool. You wince as a small shock of discomfort shoots through your butt. These seats have clearly seen better days."

        $ accessMap = False

        hide squeeb collared_idle with dissolve
        jump scene_last_drop.tavern

    label .beehives:
        $ outdoor()
        $ map_point = the_last_drop

        if 8 < calendar[3] < 20:
            show bg forest_day with dissolve
        else:
            show bg forest_night with dissolve

        $ _t = ""
        # Day
        if calendar[3] > 6 and calendar[3] < 20:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    "A bright garden lined by a rough stick fence sits behind the tavern. Bright flowers bloom on small bushes while long vines creep up small wooden posts. You recognize several vegetable plants in the early stages of growth. Nestled along the edge of the forest line sit a dozen large apiary boxes. The harsh sound of buzzing bees reverberates through the air around them. The bees flit between the area pollinating the numerous flowers in the garden."
                    $ _t = "A small wooden structure has been set up to support a small rough. The structure lacks walls seems to be used to store tools, firewood and other supplies. A simple work bench has been set up next to a log for chopping wood."
                # Rain
                elif weather == 2:
                    $ _t = "A heavy rain pours down across the garden behind the Last Drop. The plants sag low under the weight of the water that batters the ground like a thousand drums. A small wooden overhang protects several bundles of firewood from the rain. A dozen apiaries sit silently along the forest's edge, the inhabitants not daring leave the nest in this weather."
                # Storm
                else:
                    $ _t = "The heavy downpour beat the garden relentlessly. The plants bow under the assault of the wind and rain. Dark clouds brew overhead, crackling with thunder and lightning which illuminate the area briefly. The small firewood shelter does little to protect the wooden piles beneath it. Wind blows the rain into every nook and cranny leaving everything drenched. The few apiaries tremble at the forest edge, their inhabitants silently waiting out the storm."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Last Drop Garden. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Last Drop Garden. Day"
                # Storm
                else:
                    $ _t = "Crescente Storm Last Drop Garden. Day"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Last Drop Garden. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Last Drop Garden. Day"
                # Storm
                else:
                    $ _t = "Messis Storm Last Drop Garden. Day"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Last Drop Garden. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Last Drop Garden. Day"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Last Drop Garden. Day"
        # Night
        else:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    $ _t = "Shadows hang across the back garden of the Last Drop. The flowers that look bright during the day appear drab and colorless in the shadows of the night. Fence posts look like more like grave markers in the gloom. It's a strangely sad and lonesome place at night. A dozen apiaries sit silently at the forest line. Not even the bees buzz at this hour, leaving the place eerily quiet."
                # Rain
                elif weather == 2:
                    $ _t = "The garden is a gloomy place at night, even more so in the rain. Water pours down in sheets forcing the flowers and plants to bow before it's weight. The strange shapes of the fence and apiaries appear more like graves in the gloomy darkness. The din of icy rain striking the ground masks any other sounds, leaving only a monotonous drumming."
                # Storm
                else:
                    $ _t = "An icy chill from the storm cuts through the garden like a hundred knives. The apiaries at the forest edge and the numerous tools that lean against the firewood shack cast bizarre unsettling shadows in the dark. The rain doesn't help, only blurring and distorting these shapes further, making them appear as large beasts. Brief flashes of lightning expose these shapes for what they truly are, before shrouding them in darkness once again."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Last Drop Garden. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Last Drop Garden. Night"
                # Storm
                else:
                    $ _t = "Crescente Storm Last Drop Garden. Night"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Last Drop Garden. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Last Drop Garden. Night"
                # Storm
                else:
                    $ _t = "Messis Storm Last Drop Garden. Night"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Last Drop Garden. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Last Drop Garden. Night"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Last Drop Garden. Night"

        menu:
            "[_t]"
            "Talk to Fenna" if 8 < calendar[3] < 20 and weather == 1:
                jump talk_fenna_outdoor
            "Go to the Last Drop":
                jump scene_last_drop.exterior

label talk_squeeb:
    show bg basic with dissolve
    $ indoor()
    show squeeb collared_idle with dissolve

    "Squeeb" "You approach the wererat bartender who gives you a crooked toothy smile. His red eyes are warm but unsettling as they stare at you."
    $ que = "Do you have any jobs I can do?"
    # Sort out quest dialogue
    if squeeb_quest['quest'] == 0:
        if squeeb_quest['quest_phase'] == 1:
            "What did you need me to do again?"
        elif squeeb_quest['quest_phase'] == 2:
            "I have the supplies for you."
    menu .conversation:
        "Squeeb" "\"How can I help you, [pc.profile[Name]]?\""
        "What can you tell me about...?":
            jump .squeeb_information
        "[que]":
            jump .squeeb_quests
        "How did you get here?":
            jump .squeeb_story
        "Have you heard any rumors?":
            jump .squeeb_rumors
        "Nevermind":
            hide squeeb collared_idle with dissolve
            jump scene_last_drop.tavern

    label .squeeb_information:
        $ input_string = renpy.input("What can you tell me about...",length = 12,exclude = ".?!")
        # $ input_string = pc.profile['Name'].strip()

        if not input_string:
            $ input_string = ""

        if input_string.lower() == "collar" or input_string.lower() == "collars":
            "Squeeb" "\"I don't know much about them I'm afraid. I know they don't come off easily and they affect people's mood somehow. I do know that some folk have removed them somehow but I don't know the specifics of how. You'd probably want to talk to someone more versed in magic to learn more.\""
        elif input_string.lower() == "wererat" or input_string.lower() == "wererats":
            "Squeeb" "\"Wererats are like most lycanthropes, we're created through magical mutation and sorcery. We've got a keen sense of smell and we've got enhanced reflexes. If you're looking for more folk like me I'd suggest looking somewhere dark and enclosed. We tend to like small spaces.\""
        elif input_string.lower() == "werewolf" or input_string.lower() == "werewolves" or input_string.lower() == "werewolfs":
            "Squeeb" "\"Werewolves are the more common lycanthrope, they were used by witches as ways to enhance their familiars. They're very strong, intelligent and loyal. If you run into one there are probably more in the area. They tend to form packs like most dogs from what I hear. They also see well in the dark, so they tend to hunt at night. If you're looking for them you'd probably be best to stick to the forests at night.\""
        elif input_string.lower() == "lycanthrope" or input_string.lower() == "lycanthropy":
            "Squeeb" "\"Lycanthropy is a curse used by witches and warlocks. It started as a way for them to enhance their familiars by fusing them with a humanoid. It's rather dark stuff I'd rather not get into the details of that process.\""
            "Squeeb" "\"A lycanthrope who was cursed by this method will gain enhanced sense and physical abilities depending on the animal that was used for the ritual. Typically rats, ravens or wolves but there are rare cases of other creatures like bears and tigers being used. We also typically have the power to shapeshift when not in the light of a full moon. However the collars the Legion use prevent us lycanthrope's from shapeshifting into our original forms.\""
            "Squeeb" "\"The curse can be spread in a couple of different ways. It can be spread through the bite of a lycanthrope but it rarely transfers even in extreme cases. The offspring of a lycanthrope will always develop the curse but it's typically dormant and doesn't manifest. When the curse does manifest in a lycanthrope's offspring they typically have little control over it and will shapeshift under the light of a full moon and go feral. That's where most of the ghost stories about lycanthropes come from.\""
        elif input_string.lower() == "fenna":
            "Squeeb" "\"I don't really feel comfortable telling you her story, you'll have to ask her yourself. I can say that we've worked together for a number of years now, even before we got to Alcatraz. Still waters run deep with that one.\""
        elif input_string.lower() == "minotaur" or input_string.lower() == "minotaurs":
            "Squeeb" "\"Minotaurs are a mountain people from what I know. Solitary hermits usually, tend to keep to themselves. From my time with Fenna I know that in spite of appearances they're obligate carnivores. Fenna would know more but that could pose a different challenge.\""
        elif input_string.lower() == "alcatraz" or input_string.lower() == "alkatraz" or input_string.lower() == "island":
            "Squeeb" "\"Alcatraz is a large island with a high mountain at it's center. I don't know the full history but from my time here I know it was inhabited at one point though whoever used to live here is long gone by now. There are a good amount of ruins scatter throughout the island though if you're feeling adventurous.\""
            "Squeeb" "\"The Legion controls the island now, though they don't venture to far beyond the shores and their forts. It's currently just used as a dumping ground for anyone the Legion deems unsavory. The surrounding ocean is pretty treacherous, lots of strange currents and jagged rock formations make sailing off the island near impossible without a proper ship and navigator.\""
        elif input_string.lower() == "vergesseneburg":
            "Squeeb" "\"It's a town to the west of here. Apparently it was an abandoned town that some folks found and have been repairing. It's sort of become the hub for a lot of the prisoners on the island. Some folk have even set up shops there, it's about the closest thing to a town you'll find here.\""
        elif input_string.lower() == "sunken maiden" or input_string.lower() == "the sunken maiden":
            "Squeeb" "\"The Sunken Maiden was a trade ship I worked on with Fenna. I was the navigator but we got hit by a bad storm one night and got blown off course a little too close to Alcatraz. The Legion didn't take too kindly to that and attacked us. The ship was sunk off the northern coast somewhere.\""
        elif input_string.lower() == "legion" or input_string.lower() == "the legion" or input_string.lower() == "the elven legion":
            "Squeeb" "\"The Legion are a collective of some elven territories. Then banded together about two decades ago and have been using their combined forces to take over and expand their territory. I'm not really one for political gossip so I don't know much more then that.\""
        elif input_string.lower() == "dick" or input_string.lower() == "cock" or input_string.lower() == "penis":
            "Squeeb" "\"That's a rather cheeky question.\""
        elif input_string.lower() == "vag" or input_string.lower() == "vagina" or input_string.lower() == "pussy":
            "Squeeb" "\"You're rather cheeky aren't you.\""
        elif input_string.lower() == "ass" or input_string.lower() == "butt" or input_string.lower() == "sex":
            "Squeeb" "\"I don't think we're close enough to talk about that.\""
        else:
            "Squeeb" "Sorry I don't know anything about that"

        $ input_string = ""
        jump talk_squeeb.conversation
    label .squeeb_quests:
        # First delivery quest start
        if squeeb_quest["quest"] == 0:
            if squeeb_quest["quest_phase"] == 0:
                menu:
                    "Squeeb" "\"Now that you mention it I did need to make a run to Vergesseneburg for some supplies. If you could bring me those supplies it'd be a tremendous help. If you take this barrel of mead and letter to Lucia she'll give you the supplies I need. What do you say?\""
                    "I'd be happy to":
                        $ squeeb_quest["quest_phase"] = 1
                        "Squeeb" "\"Fantastic! Here's the mead and a letter explaining who you are. Take this to Lucia at the Bloody Lip in Vergesseneburg. Just come back here when you're done.\""
                        $ addToInventory(item_squeeb_mead,1)
                        $ addToInventory(item_squeeb_letter,1)
                        # Add Items
                        pass
                    "Not right now":
                        "Squeeb" "\"Fair enough. It is a bit of a journey but if you find yourself heading that direction and want to earn some favor just say the word.\""
                        pass
                jump talk_squeeb.conversation
            # First delivery quest reminder
            elif squeeb_quest["quest_phase"] == 1:
                "Squeeb" "I need you to take that payment to Lucia at the Bloody Lip in Vergesseneburg. The Bloody Lip is the tavern there. She should be there at night."
                jump talk_squeeb.conversation
            # First delivery quest completion
            elif squeeb_quest["quest_phase"] == 2:
                "Squeeb" "You got everything, this is great help [pc.profile[Name]]. I do hope Lucia didn't give you too much trouble."
                "[pc.profile[Name]]" "She wants you to come personally next time. She says she misses your company."
                "Squeeb" "Ah, well I suppose I can't deny her such a request. I'm sure you're well aware of her... influences at this point. Sorry for not warning you ahead of time. She's mostly benign I assure you, she just doesn't really understand personal space. You did a great job getting me these supplies, it's not much but here's a token of my appreciation."
                "Squeeb hands you an old knife. The binding is worn but the blade is still sharp."
                $ squeeb_quest["quest"] = 1
                $ squeeb_quest["quest_phase"] = 0
                $ removeQuestItem(item_squeeb_supplies,1)
                $ addToInventory(item_squeebs_knife,1)
                # Add Knife
                jump talk_squeeb.conversation
        else:
            "Squeeb" "I don't have any jobs available right now."
            jump talk_squeeb.conversation

    label .squeeb_story:
        "Squeeb" "\"I was working as a navigator on the Sunken Maiden when a storm blew us off course. We got a little too close to Alcatraz and Legion didn't take too kindly to that. There was a fire fight and the ship was lost. Fenna and I managed to swim to shore but the Legion arrested us when we did.\" He looks away with a crooked frown."
        jump talk_squeeb.conversation

    label .squeeb_rumors:
        "Squeeb" "\"I've heard there's a ghost that appears in the church at Vergesseneburg at night. They only appear between midnight and 1 o'clock. I haven't seen it myself so I can't confirm anything but it's a popular story with the locals.\""
        jump talk_squeeb.conversation

label talk_fenna_outdoor:
    $ outdoor()
    show fenna collared_idle with dissolve

    "You step towards the large minotauress cautiously, raising a hand in greeting. She glances your direction for a moment. She nods to acknowledge your presence before returning her attention to her work."
    $ que = "Do you have any jobs I can do?"
    # Sort out quest dialogue
    if fenna_quest['quest'] == 0:
        if fenna_quest['quest_phase'] == 1:
            "What did you need me to do again?"
        elif fenna_quest['quest_phase'] == 2:
            "I have the supplies for you."
    menu .conversation:
        "Fenna works quietly barely making any indication that she even knows you're there."
        # "What can you tell me about...?":
        #    jump .fenna_information
        # "[que]":
        #     jump .fenna_quests
        "How did you get here?":
            jump .fenna_story
        "Have you heard any rumors?":
            jump .fenna_rumors
        "Nevermind":
            hide fenna collared_idle with dissolve
            jump scene_last_drop.beehives

    label .fenna_story:
        "Fenna" "She stares at you for far longer then is comfortable before saying \"I was arrested with Squeeb.\" She doesn't provide any further detail and returns her attention to your work."
        jump talk_fenna_outdoor.conversation

    label .fenna_rumors:
        "Fenna" "She gives you an inscrutable plain look. \"No.\" You get the feeling she's not one for gossip."
        jump talk_fenna_outdoor.conversation

label talk_fenna_indoor:
    $ indoor()
    menu:
        fenna "Can I help you with something?"
        "Thanks for helping me." if relationship_squeeb["thanked_for_saving"]:
            jump talk_fenna.thank_for_saving
        "What brought you here?":
            jump talk_fenna.why_here
        "Nevermind.":
            hide fenna collared_idle with dissolve
            jump scene_last_drop.beehives

    label .thank_for_saving:
        "You're welcome. I try and keep an eye out for newcomers whenever the ships come in, it gets pretty dangerous at night if you're not prepared."
        jump scene_last_drop.fenna_outside

    label .meet_fenna:
        $ relationship_fenna['met_fenna'] = True
        fenna "You can call me Fenna. I tend the apiaries and do the heavy lifting around here. If you need something built I can do it."
        jump scene_last_drop.fenna_outside

    label .why_here:
        fenna "Like most folk I got caught up during the rebellion. Fought for my home and it didn't end well. When I got here it wasn't quite as dangerous as it is now, found Squeeb holed up in this place, we've been together since. Fixing things up when we can."
        jump scene_last_drop.fenna_outside
