init python:
    import math

    class Buff:
        APHRO = 0;  ## Increase lust slowly
        REGEN = 1;  ## Increase health slowly
        HEALT = 2;  ## Buff max HP
        SILVE = 3;  ##
        STURD = 4;  ## Buff defense
        POISO = 5;  ## Decrease health slowly
        CURSE = 6;  ## Decrease lust slowly
        AGGRO = 7;  ## Won't flee
        CONTI = 8;  ## Won't submit

    class Mob:
        def __init__(self, hp, libido, stamina, combat, survival, acumen, glamour,name,race,gender):
            self.hp = hp
            self.max_hp = hp
            self.libido = libido
            self.max_libido = libido
            self.stamina = stamina
            self.max_stamina = stamina
            self.survival = survival
            self.combat = combat
            self.acumen = acumen
            self.glamour = glamour
            self.level = int((combat + survival + acumen + glamour - 32) / 8)
            if self.level < 1:
                self.level = 1

            ## Elemental damage resistance lists take dmg_type objects
            self.dmg_resist = []
            self.dmg_immune = []
            self.dmg_vulnerability = []

            self.buff = {
            # [Active,Minutes,Perma,Sprite]
            "Aphrodisiac" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Regenerate" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Healthy" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Sturdy" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Poison" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Curse" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Charmed" : [False,0,False,"gui/dice/red_dice.jpg"],
            "Aggro" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Continue" : [False,0,False,"gui/dice/white_dice.jpg"],
            "Melancholy" : [False,0,False,"gui/dice/olive_dice.jpg"], # If lust is pushed below 0. All stat take a 20% reduction, they deal 20% less damage.
            "Lusty" : [False,0,False,"gui/dice/purple_dice.jpg"], # If lust is pushed above max. All stats take a 20% reduction, they take 20% more damage.
            "--" : [False,0,False,"gui/dice/white_dice.jpg"]
            }
            ## General purpose information with little or no mechanical influence
            self.profile = {'Name' : name, 'Race' : race, 'Gender' : gender}
            ## Weapons
            self.hands = {'Right' : None, 'Left' : None}
            ## Equipment
            self.equipment = {'Chest' : None, 'Legs' : None, 'Acc' : None}
            ## Skills
            self.skills = [skill_strike, skill_flirt, None, None, None,None]

        def addHP(self,amount):
            self.hp += math.floor(amount)
            if self.hp > self.max_hp:
                self.hp = self.max_hp
            elif self.hp < 0:
                self.hp = 0

        def addLibido(self,amount):
            self.libido += amount
            if self.libido >= self.max_libido:
                # If lusty, libido damage is taken as HP
                if self.buff["Lusty"][1]:
                    self.addHP(self.max_libido - self.libido)
                    self.libido = self.max_libido
                else:
                    self.libido = self.max_libido
                    # When libido is at max or pushed above add Lusty debuff
                    self.addBuff("Lusty",2,False)
            elif self.libido < 0:
                self.libido = 0
                # When libido is pushed below 0 add Melancholy debuff
                self.addBuff("Melancholy",2,False)

        ## Add a buff to the mob
        ## Refresh existing buff durations
        ## Add new buffs
        def addBuff(self,b,duration,perma):
            self.buff[b][0] = True
            if self.buff[b][1] < duration:
                self.buff[b][1] = duration
            self.buff[b][2] = perma

        ## Add 999 duration buffs to mob for equipment
        ## with boons
        def updateBuffs(self):
            if self.equipment['Chest'] != None:
                for _i in self.equipment['Chest'].boon:
                    self.addBuff(_i,999,True)
            if self.equipment['Legs'] != None:
                for _i in self.equipment['Legs'].boon:
                    self.addBuff(_i,999,True)
            if self.equipment['Acc'] != None:
                for _i in self.equipment['Acc'].boon:
                    self.addBuff(_i,999,True)

        def clearBuffs(self,b):
            for _i in b:
                self.buff[_i][0] = False
                self.buff[_i][1] = 0
                self.buff[_i][2] = False

        def equip_weapon(self,weapon):
            ## Does the weapon require 2 slots
            if weapon.slot == 'Both':
                if self.hands['Right'] != None:
                    self.hands['Right'].unequip()
                if self.hands['Left'] != None:
                    self.hands['Left'].unequip()
                self.hands['Right'] = weapon
                self.hands['Left'] = None
            # Check if wielding a 2 handed weapon
            elif self.hands['Right'] != None and self.hands['Right'].slot == 'Both':
                self.hands['Right'].unequip()
                self.hands[weapon.slot] = weapon
            # The weapon requires 1 slot
            else:
                if self.hands[weapon.slot] != None:
                    self.hands[weapon.slot].unequip()
                self.hands[weapon.slot] = weapon

        def unequip_weapon(self,slot):
            if slot == 'Both':
                self.hands['Right'] = None
                self.hands['Left'] = None
            else:
                self.hands[slot] = None

        def equip_armor(self,equipment,slot):
            if self.equipment[slot] != None:
                self.unequip_armor(slot)
            self.equipment[slot] = equipment
            self.updateBuffs()

        def unequip_armor(self,slot):
            if self.equipment[slot] != None:
                self.clearBuffs(self.equipment[slot].boon)
                self.equipment[slot] = None
                self.updateBuffs()

        def get_combat_defense(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].combat_def
            if self.hands['Left'] != None:
                _var += self.hands['Left'].combat_def

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].combat_def
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].combat_def
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].combat_def

            return _var

        def get_combat_attack(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].combat_att
            if self.hands['Left'] != None:
                _var += self.hands['Left'].combat_att

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].combat_att
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].combat_att
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].combat_att

            return _var

        def get_survival_defense(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].survival_def
            if self.hands['Left'] != None:
                _var += self.hands['Left'].survival_def

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].survival_def
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].survival_def
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].survival_def

            return _var

        def get_survival_attack(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].survival_att
            if self.hands['Left'] != None:
                _var += self.hands['Left'].survival_att

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].survival_att
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].survival_att
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].survival_att

            return _var

        def get_acumen_defense(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].acumen_def
            if self.hands['Left'] != None:
                _var += self.hands['Left'].acumen_def

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].acumen_def
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].acumen_def
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].acumen_def

            return _var

        def get_acumen_attack(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].acumen_att
            if self.hands['Left'] != None:
                _var += self.hands['Left'].acumen_att

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].acumen_att
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].acumen_att
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].acumen_att

            return _var

        def get_glamour_defense(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].glamour_def
            if self.hands['Left'] != None:
                _var += self.hands['Left'].glamour_def

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].glamour_def
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].glamour_def
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].glamour_def

            return _var

        def get_glamour_attack(self):
            _var = 0
            if self.hands['Right'] != None:
                _var += self.hands['Right'].glamour_att
            if self.hands['Left'] != None:
                _var += self.hands['Left'].glamour_att

            if self.equipment['Chest'] != None:
                _var += self.equipment['Chest'].glamour_att
            if self.equipment['Legs'] != None:
                _var += self.equipment['Legs'].glamour_att
            if self.equipment['Acc'] != None:
                _var += self.equipment['Acc'].glamour_att

            return _var

        ## Get Combat with buffs and equipment
        ## Returns a list
        ## [0] Attack
        ## [1] Defend
        def get_combat(self):
            _r = [0,0]
            _r[0] = self.combat + self.get_combat_attack() + (self.level * 2)
            _r[1] = self.combat + self.get_combat_defense() + (self.level * 2)

            if self.buff["Lusty"][0] or self.buff["Melancholy"][0]:
                _r[0] = int(_r[0]*0.8)
                _r[1] = int(_r[1]*0.8)

            return _r

        ## Get Survival with buffs and equipment
        ## Returns a list
        ## [0] Attack
        ## [1] Defend
        def get_survival(self):
            _r = [0,0]
            _r[0] = self.survival + self.get_survival_attack() + (self.level * 2)
            _r[1] = self.survival + self.get_survival_defense() + (self.level * 2)

            if self.buff["Lusty"][0] or self.buff["Melancholy"][0]:
                _r[0] = int(_r[0]*0.8)
                _r[1] = int(_r[1]*0.8)

            return _r

        ## Get Acumen with buffs and equipment
        ## Returns a list
        ## [0] Attack
        ## [1] Defend
        def get_acumen(self):
            _r = [0,0]
            _r[0] = self.acumen + self.get_acumen_attack() + (self.level * 2)
            _r[1] = self.acumen + self.get_acumen_defense() + (self.level * 2)

            if self.buff["Lusty"][0] or self.buff["Melancholy"][0]:
                _r[0] = int(_r[0]*0.8)
                _r[1] = int(_r[1]*0.8)

            return _r

        ## Get Glamour with buffs and equipment
        ## Returns a list
        ## [0] Attack
        ## [1] Defend
        def get_glamour(self):
            _r = [0,0]
            _r[0] = self.glamour + self.get_glamour_attack() + (self.level * 2)
            _r[1] = self.glamour + self.get_glamour_defense() + (self.level * 2)

            if self.buff["Lusty"][0] or self.buff["Melancholy"][0]:
                _r[0] = int(_r[0]*0.8)
                _r[1] = int(_r[1]*0.8)

            return _r

        def add_dmg_resist(self,_dmg_type):
            self.dmg_resist.append(_dmg_type)

        def add_dmg_immune(self,_dmg_type):
            self.dmg_immune.append(_dmg_type)

        def add_dmg_vulnerability(self,_dmg_type):
            self.dmg_vulnerability.append(_dmg_type)

        def is_resist(self,_dmg_type):
            for _i in self.dmg_resist:
                if _i == _dmg_type:
                    return True
            return False

        def is_immune(self,_dmg_type):
            for _i in self.dmg_immune:
                if _i == _dmg_type:
                    return True
            return False

        def is_vulnerable(self,_dmg_type):
            for _i in self.dmg_vulnerability:
                if _i == _dmg_type:
                    return True
            return False

        ## Turn begin buffs and debuffs
        def turn_begin_update(self):
            _r = []
            if self.buff["Curse"][1]:
                self.addLibido(int(self.max_libido/8) * -1)
                _r.append("Libido lowered")
            else:
                _r.append("Turn Begin")

            if self.libido >= self.max_libido:
                self.libido = self.max_libido
                # When libido is at max or pushed above add Lusty debuff
                self.addBuff("Lusty",2,False)
                _r.append("Gained Lusty")
            elif self.libido < 0:
                self.libido = 0
                # When libido is pushed below 0 add Melancholy debuff
                self.addBuff("Melancholy",2,False)
                _r.append("Gained Melancholy")

        def turn_end_update(self):
            for i in self.buff:
                if not self.buff[i][2]:
                    self.buff[i][1] -= 1
                    if self.buff[i][1] <= 0:
                        self.buff[i][0] = False
                        self.buff[i][1] = 0

        def skill_points(self):
            _r = self.level * 4 # self.combat + self.survival + self.acumen + self.glamour
            return _r

    class Hostile(Mob):
        def __init__(self, sprite, hp, libido, morale, stamina, combat, survival, acumen, glamour, name, race, gender,sk_1,sk_2,sk_3,sk_4,sk_5,sk_6,condition,ending):
            Mob.__init__(self,hp,libido,stamina,combat,survival,acumen,glamour,name,race,gender)
            self.morale = morale
            self.sprite = sprite
            self.libido = 0
            self.condition = condition # Condition is the emotional state of the monster, modifies how they act in combat. Condition is a string
            # "Angry" - Increased chance of aggressive action. Less likely to submit or flee
            # "Melancholy" - Decreased chance of aggressive action. More likely to submit or flee
            # "Cowardly" - Greatly increased chance of fleeing or submitting
            # "Bold" - Greatly decreased chance of fleeing or submitting
            # "Aroused" - Starts with increased libido and is more likely to flirt
            # "Submissive" - More likely to submit in combat
            # "" - No modifier, standard enemy

            self.ending = ending

            ## Weapons
            self.hands = {'Right' : None, 'Left' : None}
            ## Equipment
            self.equipment = {'Chest' : None, 'Legs' : None, 'Acc' : None}
            ## Skills
            self.skills = [sk_1, sk_2, sk_3, sk_4, sk_5, sk_6]

    # skill_contest takes the int value of the user skill and the targets skill
    # Tests the opposing skills and returns True if the user skill beats the target skill
    def skill_contest(user_skill,target_skill):
        _list = []
        _tar = standd6.roll()[0]

        if user_skill > target_skill*2:
            _list.append(standd6.roll()[0])
            _list.append(standd6.roll()[0])
            _list.append(standd6.roll()[0])
            _list.sort(reverse=True)
        elif user_skill < target_skill/2:
            _list.append(standd6.roll()[0])
            _list.append(standd6.roll()[0])
            _list.append(standd6.roll()[0])
            _list.sort()
        elif user_skill > target_skill + 2:
            _list.append(standd6.roll()[0])
            _list.append(standd6.roll()[0])
            _list.sort(reverse=True)
        elif user_skill < target_skill - 2:
            _list.append(standd6.roll()[0])
            _list.append(standd6.roll()[0])
            _list.sort()
        else:
            _list.append(standd6.roll()[0])

        if _list[0] >= _tar:
            return True
        else:
            return False

    # rollAttack returns a list of die faces and surges
    def calculateDamage(_base_attack,_att_stat,_def_stat,_type = 1.0,_crit = 1.0,_weather = 1.0,_other = 1.0):
        return math.floor(((float(_base_attack) * (float(_att_stat)/float(_def_stat))) + 1.0) * (renpy.random.uniform(0.75,1.0) * _type * _crit * _weather * _other))

    def chooseCondition():
        # "Angry" - Increased chance of aggressive action. Less likely to submit or flee
        # "Melancholy" - Decreased chance of aggressive action. More likely to submit or flee
        # "Cowardly" - Greatly increased chance of fleeing or submitting
        # "Bold" - Greatly decreased chance of fleeing or submitting
        # "Aroused" - Starts with increased libido and is more likely to flirt
        # "Submissive" - More likely to submit in combat
        _i = standd6.roll()[0] + standd6.roll()[0]
        _c = ""
        if _i == 12:
            _c = "Aroused"
        elif _i == 11 or _i == 10:
            _c = "Submissive"
        elif _i == 9:
            _c = "Bold"
        elif _i == 5:
            _c = "Angry"
        elif _i == 3 or _i == 4:
            _c = "Cowardly"
        elif _i == 2:
            _c = "Melancholy"

        return _c
