screen enemy_status(_enemy):
    fixed:
        add "gui/frames/enemybar_base.png" xpos 0.5 ypos 32 anchor(0.5,0.5)
        bar:
            value _enemy.max_hp - _enemy.hp
            range _enemy.max_hp
            xysize (205,12)
            left_bar None
            right_bar "gui/frames/enemybar_health_left.png" xpos 0.5 ypos 26 anchor(1.0,0.5)
        bar:
            value _enemy.hp
            range _enemy.max_hp
            xysize (209,12)
            left_bar "gui/frames/enemybar_health_right.png" xpos 0.5 ypos 26 anchor(0.0,0.5)
            right_bar None

        bar:
            value _enemy.max_libido - _enemy.libido
            range _enemy.max_libido
            xysize (164,8)
            left_bar None
            right_bar "gui/frames/enemybar_libido_left.png" xpos 0.5 ypos 39 anchor(1.0,0.5)
        bar:
            value _enemy.libido
            range _enemy.max_libido
            xysize (164,8)
            left_bar "gui/frames/enemybar_libido_right.png" xpos 0.5 ypos 39 anchor(0.0,0.5)
            right_bar None

        if _enemy.condition != "":
            text _enemy.condition + " " + _enemy.profile['Name'] xalign 0.5 yalign 0.0 xpos 0.5 ypos 48 yanchor 0.0 color "#707070" font "gui/fonts/Bradley Gratis.ttf" size 20
        else:
            text _enemy.profile['Name'] xalign 0.5 yalign 0.0 xpos 0.5 ypos 48 yanchor 0.0 color "#707070" font "gui/fonts/Bradley Gratis.ttf" size 20
        text "LVL [_enemy.level]" xalign 0.5 yalign 0.0 size 12 xpos 0.5 ypos 72 yanchor 0.0

        text "Combat [_enemy.combat]" xalign 1.0 yalign 0.0 size 14 xpos 0.85 ypos 0.1
        text "Survival [_enemy.survival]" xalign 1.0 yalign 0.0 size 14 xpos 0.85 ypos 0.12
        text "Acumen [_enemy.acumen]" xalign 1.0 yalign 0.0 size 14 xpos 0.85 ypos 0.14
        text "Glamour [_enemy.glamour]" xalign 1.0 yalign 0.0 size 14 xpos 0.85 ypos 0.16

screen bookend():
    zorder 50
    fixed:
        pos (0,510)
        minimum (1280,208)
        maximum (1280,208)
        add "#000"
        add "gui/frames/gui_bookend.png"

screen action_history(_history):
    zorder 10
    fixed:
        pos (722,534)
        xysize (378,152)
        # fixed:
        #     pos (-662,-24)
        #     add "gui/frames/combat_history.png"
        side "l":
            # area (672,24,1040,160)
            area (29,4,400,161)
            viewport id "combat_history_scroller":
                draggable True
                mousewheel True
                child_size (301,157)
                # yinitial 0.0 - 1.0 determines if the scroll bar is at the top or bottom of the list
                vbox:
                    spacing 4
                    xfill True
                    # box_wrap True
                    # box_wrap_spacing 2
                    xsize 251
                    for h in _history:
                        if h != None:
                            text h size 14 color "#707070"
        vbar value YScrollValue ("combat_history_scroller")

screen action_menu(_player,_active = False):
    fixed:
        pos (0,510)
        minimum (1280,208)
        maximum (1280,208)
        add "gui/frames/gui_background.jpg"
        add "gui/frames/combat_actions.png"

        bar:
            value _player.hp
            range _player.max_hp
            xysize (400,10)
            left_bar "gui/frames/playerbar_health.png" xpos 264 ypos 20 anchor(0.0,0.5)
            right_bar None
        bar:
            value _player.libido
            range _player.max_libido
            xysize (288,6)
            left_bar "gui/frames/playerbar_libido.png" xpos 270 ypos 32 anchor(0.0,0.5)
            right_bar None

        hbox:
            xpos 254
            ypos 42
            $ _i = 0
            for _i in range(_player.max_stamina):
                hbox:
                    minimum (34,7)
                    if _i <= _player.stamina:
                        add "gui/frames/stam_frame_full.png"
                    else:
                        add "gui/frames/stam_frame_empty.png"

        $ i = 0
        for i in range(2):
            $ o = 0
            for o in range(3):
                fixed:
                    pos (252 + (o * 64),48 + (i * 72))
                    minimum (62,72)
                    maximum (62,72)
                    if _active:
                        if _player.skills[o + (i * 3)] != None:
                            # Draw skill icons
                            # ADD STAMINA CHECK
                            if selected_skill == o + (i * 3):
                                add _player.skills[o + (i * 3)].img + "_color.jpg" pos (7,16)
                            else:
                                add _player.skills[o + (i * 3)].img + "_white.jpg" pos (7,16)

                            button:
                                if selected_skill == o + (i * 3):
                                    action Return(selected_skill)
                                else:
                                    action SetVariable("selected_skill",o + (i * 3))
                        if selected_skill != o + (i * 3):
                            add "gui/frames/action_border_idle.png"
                        else:
                            add "gui/frames/action_border_selected.png"
                    else:
                        if _player.skills[o + (i * 3)] != None:
                            add _player.skills[o + (i * 3)].img + "_gray.jpg" pos (7,16)
                        if selected_skill != o + (i * 3):
                            add "gui/frames/action_border_idle.png"
            # $ i += 1
        # Draw Skill Text
        fixed:
            pos (508,42)
            xysize (170,104)
            # yfill True
            xfill True
            box_wrap True
            if selected_skill != None:
                if selected_skill < 6:
                    text _player.skills[selected_skill].name size 17 color "#707070"
                    text _player.skills[selected_skill].type size 10 color "#707070" ypos 19
                    text _player.skills[selected_skill].description size 15 color "#707070" ypos 31
                elif selected_skill == 6:
                    text "Rest" size 17 color "#707070"
                    text "Other" size 10 color "#707070" ypos 19
                    text "Rest to recover some stamina" size 15 color "#707070" ypos 31
                elif selected_skill == 7:
                    text "Flee" size 17 color "#707070"
                    text "Other" size 10 color "#707070" ypos 19
                    text "Attempt to flee from combat" size 15 color "#707070" ypos 31
        # Draw Rest
        fixed:
            pos (442,53)
            minimum (38,62)
            maximum (38,62)
            button:
                if selected_skill == 6:
                    action Return(6)
                    add "gui/button/rest_white.jpg" pos (7,6)
                    add "gui/frames/narrow_border_selected.png"
                else:
                    action SetVariable("selected_skill",6)
                    add "gui/button/rest_gray.jpg" pos (7,6)
                    add "gui/frames/narrow_border.png"
        # Draw Flee
        fixed:
            pos (442,125)
            minimum (38,62)
            maximum (38,62)
            button:
                if selected_skill == 7:
                    action Return(7)
                    add "gui/button/flee_white.jpg" pos (7,6)
                    add "gui/frames/narrow_border_selected.png"
                else:
                    action SetVariable("selected_skill",7)
                    add "gui/button/flee_gray.jpg" pos (7,6)
                    add "gui/frames/narrow_border.png"

screen battle_confirmation(_text = "",_active = False):
    frame:
        background None
        pos (448,544)
        minimum (384,88)
        maximum (384,88)
        padding (8,8)
        text _text size 24 xalign 0.5 yalign 1.0

    frame:
        style "inventory_frame"
        minimum (96,32)
        maximum (96,32)
        pos (512,640)
        text "Yes" size 16 xalign 0.5 yalign 0.5
        button:
            if _active:
                action Return(True)

    frame:
        style "inventory_frame"
        minimum (96,32)
        maximum (96,32)
        pos (672,640)
        text "No" size 16 xalign 0.5 yalign 0.5
        button:
            if _active:
                action Return(False)
