label scene_vergesseneburg:

    label .exterior:
        $ outdoor()
        $ _t = ""
        # Day
        if calendar[3] > 6 and calendar[3] < 20:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    "Vergesseneburg is a tight collection of buildings and ruins all forming slowly expanding rings. The center of the town has been heavily repaired, while the exterior is simply the remains of stone foundations. A tall two and a half storey building sits at the very center. Small light gray plumes of smoke drift up from it's chimney lazily. Candlelight flickers in it's windows obscured occasionally by the shadows of people inside."
                    $ _t = "Many people of various races mingle and wander between the streets. A strange collection of the obscure and bizarre all working together to survive. Minotaur, trolls and gargoyles work to repair and reconstruct buildings. Lycanthropes, goblins and kobolds hunt carve fresh game. Orcs construct tools while dryads weave cloth for tailors."
                # Rain
                elif weather == 2:
                    $ _t = "The town is quieter then usual due to the rain which drums across the rooftops rhythmically. Icy wind blows through the wide streets, rattling shutters and shaking signs. In spite of the weather several people still roam the dark streets. They hastily move between buildings conducting their business before quickly seeking shelter. Candlelight flickers in windows and behind doors. Shopkeepers keep their doors open to any who need their surfaces or respite from the rain."
                # Storm
                else:
                    $ _t = "Vergesseneburg's stone streets are left barren and empty in the wake of the storm. The squat buildings are lifeless silhouettes in the gloom. Small cracks of light peak through shutters and under door frames. The only signs of life to be seen as icy wind and rain beat down the streets and rooftops. The usual din of people working and bartering has been replaced by the torrential banging of rain across stone and wood. Thunder crackles ferociously overhead while lightning casts brief flashes of dull color across the gray town."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Vergesseneburg Inner Town. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Vergesseneburg Inner Town. Day"
                # Storm
                else:
                    $ _t = "Crescente Storm Vergesseneburg Inner Town. Day"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Vergesseneburg Inner Town. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Vergesseneburg Inner Town. Day"
                # Storm
                else:
                    $ _t = "Messis Storm Vergesseneburg Inner Town. Day"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Vergesseneburg Inner Town. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Vergesseneburg Inner Town. Day"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Vergesseneburg Inner Town. Day"
        # Night
        else:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    if calendar[3] <= 1:
                        "Vergesseneburg's stone streets are left barren and empty in the wake of the storm. The squat buildings are lifeless silhouettes in the gloom. Small cracks of light peak through shutters and under door frames. The only signs of life to be seen as icy wind and rain beat down the streets and rooftops. The usual din of people working and bartering has been replaced by the torrential banging of rain across stone and wood. Thunder crackles ferociously overhead while lightning casts brief flashes of dull color across the gray town."
                        $ _t = "The dark stone remains of a church casts long shadows across the streets. It's broken stained glass windows lie empty and dark, except for one. A single candle flickers casting an unnatural beam of light from behind the broken glass. A gaunt silhouette looms, staring from the window. Face obscured heavily in shadow. They stare at you for only a moment before vanishing behind the stone walls. The experience is so sudden you hardly belief you'd seen it before it was gone."
                    else:
                        $ _t = "Dark shadows drag in long tendrils across the streets and up the sides of squat buildings. Small metal cages have been filled with firewood which crackles softly to illuminate the town. Most buildings lay closed and dark in the night hours. Only a few buildings remain open. Inviting candlelight spills out of their windows welcoming you to come inside. The tall two and half storey building that formed the town's meet hall and tavern was one such building."
                # Rain
                elif weather == 2:
                    $ _t = "Rain batters the darkened streets of Vergesseneburg. The cold damp air chills you to the bone. The storm has caused all but the bravest few inhabitants to seek shelter in their homes or the tavern. The metal cages that are used to light the streets and night lay dark in the storm. Only a few embers remain defiantly against the rain but do little to illuminate the shadowy streets. The large tavern near the center of the town is one of the few beacons that remain. Small beams of candlelight flicker out of the window shutters, while the raucous noise of patrons breaks through the din of the rain."
                # Storm
                else:
                    $ _t = "Dark clouds swirl overhead, lightning crackling dangerously within before striking like a spear towards the earth. Flash of light illuminate the town's wide empty streets, followed by deafening rolls of thunder echo between the buildings. The small building of Vergesseneburg tremble under the ferocity of the storm. Shutters rattling in the window. Everyone but you has sought shelter from the violent storm the brews overhead. A few beams of light peak through window shutters and under door frames, guiding you to some safety in the dark."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Vergesseneburg Inner Town. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Vergesseneburg Inner Town. Night"
                # Storm
                else:
                    $ _t = "Crescente Storm Vergesseneburg Inner Town. Night"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Vergesseneburg Inner Town. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Vergesseneburg Inner Town. Night"
                # Storm
                else:
                    $ _t = "Messis Storm Vergesseneburg Inner Town. Night"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Vergesseneburg Inner Town. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Vergesseneburg Inner Town. Night"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Vergesseneburg Inner Town. Night"

        menu:
            "[_t]"
            # "Go to the Inn":
            #     pass
            # "Go to the black smith":
            #     pass
            # "Go to the general store":
            #     pass
            # "Go to the apothecary":
            #     pass
            "Go to the Bloody Lip":
                jump scene_bloody_lip.interior
            "Return to the Beach":
                $ map_point = south_coast_02
                jump scene_coast.south_02

label scene_bloody_lip:
    label .interior:
        $ indoor()
        $ _n = False
        # Day
        if calendar[3] > 6 and calendar[3] < 20:
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    "The Bloody Lip is a quiet place during the day, a large fireplace sits as a center piece of the lower tavern. A tall arched ceiling supports several damaged chandeliers. Candles burn softly in their spokes casting a warm light across the many long tables that fill the space. Vases with bright red flowers sit as center pieces. A few old portraits line the halls depicting gaunt and sinister looking creatures. A large ornate bar sits near to the fireplace. Behind it is a large rack filled with bottles, barrels and flagons."
                    "A tall staircase winds up towards a second storey balcony which lines part of the tavern. You can see several doors which lead to rooms for rent. The balcony is lined with a beautiful banister. The detailing and construction of this building seems to be a cut above anything else you've seen on the island."
                    $ _t = "A dusty and pale elf hovers between tables cleaning and preparing for the evening crowd. He wears little more then rags and an apron as he works. They seem to be in a haze and barely notice your presence. Other patrons seem to pay the elf no mind as he works, barely sparing him a glance."
                # Rain
                elif weather == 2:
                    "The Bloody Lip is busier then usual. Many tables are filled with patrons of various races all seeking shelter from the rain. Main people sit huddled next to the fireplace which crackles and burns. Many of the long tables are filled by people who mingle and drink casually. Several gaunt and pale creatures float between the tables handing out drinks while collecting baubles in trade."
                    $ _t = "The firelight in the storm cast strange shadows across the portraits in the tavern. The already macabre paintings look even more unsettling, as if their hunting you. Their look is like a predator stalking it's pray but you can't help but look at them."
                # Storm
                else:
                    "The Bloody Lip is bustling in spite of the hour. Many patrons huddle near the fire for warmth, and those that can't fit fight for space at the numerous tables that line the tavern interior. Several patrons squabble angrily with one another. Several dark portraits of bizarre individuals loom over the crowd. The din of the crowd almost drowns out the whistling of wind and rain outside, but the deafening crack of thunder is a firm reminder of the powerful storm the brews behind the tavern walls."
                    $ _t = "Several bony and pale elves move between the tables mechanically. They take orders, return with drinks, take payment and repeat or a seemingly endless loop. Their rhythm and pacing is bizarre and unsettling to watch, which is likely why most patrons seem to ignore them except when they require food or drink."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Bloody Lip Interior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Bloody Lip Interior. Day"
                # Storm
                else:
                    $ _t = "Crescente Storm Bloody Lip Interior. Day"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Bloody Lip Interior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Bloody Lip Interior. Day"
                # Storm
                else:
                    $ _t = "Messis Storm Bloody Lip Interior. Day"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Bloody Lip Interior. Day"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Bloody Lip Interior. Day"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Bloody Lip Interior. Day"
        # Night
        else:
            $ _n = True
            # Seminandum
            if calendar[1] == 1:
                # Clear
                if weather == 1:
                    "The tavern interior is busy at night. The many citizens of Vergesseneburg and beyond come here to mingle and relax after a day of work. A small fire crackles low in the fireplace, burning just enough to cast some light on the interior. Several chandeliers with candles help light the space. Long tables with red flower center pieces fill the room, providing a space for the many patrons."
                    "Bizarre portraits of gaunt skeletal creatures loom down with a predatory gaze. It's rather unsettling but the rest of the patrons seems to have grown accustomed to the strange décor and ignore it. Among the other things being ignored are the strange waitstaff who glide between tables mechanically. Their pale elven visages look at people blankly and barely utter a word."
                    $ _t = "Behind the bar sit Lucia, chin held high as she looks down across the crowd like a queen. Her sharp, pale features are accented by the reddish candlelight and her dark black hair. She speaks with her patrons confidently but with an air of superiority."
                # Rain
                elif weather == 2:
                    "The tavern is usually busy at night but with the rain it's become even busier as people seek shelter. A small fire crackles hotly in the fireplace which is obscured by a crowd that surrounds it. Candlelight dances down across the tavern from a set of broken chandeliers. The crowd of people mingle and banter among themselves. The smell of alcohol is strong in the tavern as people drink casually."
                    "Bizarre portraits of gaunt skeletal creatures loom down with a predatory gaze. It's rather unsettling but the rest of the patrons seems to have grown accustomed to the strange décor and ignore it. Among the other things being ignored are the strange waitstaff who glide between tables mechanically. Their pale elven visages look at people blankly and barely utter a word."
                    $ _t = "Behind the bar sit Lucia, chin held high as she looks down across the crowd like a queen. Her sharp, pale features are accented by the reddish candlelight and her dark black hair. She speaks with her patrons confidently but with an air of superiority."
                # Storm
                else:
                    "The tavern is packed with patrons in the wake of the storm. People bicker and shove as they push closer to the fireplace to dry off and stay warm. In spite of this no fights break out although the temptation is apparent on several patron's faces. The benches and tables are packed with people of various races, shapes and sizes all here for the same respite from the storm. The smell of alcohol, sweat and wet fur mingle unpleasantly in the crowd."
                    "The unsettling portraits of gaunt creatures that line the hall are made even more unsettling in the storm. Flashes of lightning that break through the windows illuminate the paintings strangely. They appear to shift and move at a moments notice. Their crooked smiles leer down at you with a predatory hunger. You shutter and it's clear you're no the only one who notices this as several patrons jump and shy away with each crack of thunder."
                    $ _t = "Behind the bar sit Lucia, chin held high as she looks down across the crowd like a queen. Her sharp, pale features are accented by the reddish candlelight and her dark black hair. She coughs firmly and glares down at anyone who begins to bicker. This seems to immediately end any argument, at least as long as they remain in the tavern walls. Her word is law here, a law that's quickly and readily accepted without question."
            # Crescente
            elif calendar[1] == 2:
                # Clear
                if weather == 1:
                    $ _t = "Crescente Clear Bloody Lip Interior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Crescente Rain Bloody Lip Interior. Night"
                # Storm
                else:
                    $ _t = "Crescente Storm Bloody Lip Interior. Night"
            # Messis
            elif calendar[1] == 3:
                # Clear
                if weather == 1:
                    $ _t = "Messis Clear Bloody Lip Interior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Messis Rain Bloody Lip Interior. Night"
                # Storm
                else:
                    $ _t = "Messis Storm Bloody Lip Interior. Night"
            # Levisomnus
            else: # calendar[1] == 4:
                # Clear
                if weather == 1:
                    $ _t = "Levisomnus Clear Bloody Lip Interior. Night"
                # Rain
                elif weather == 2:
                    $ _t = "Levisomnus Rain Bloody Lip Interior. Night"
                # Storm
                else:
                    $ _t = "Levisomnus Storm Bloody Lip Interior. Night"

        menu:
            "[_t]"
            "Approach Lucia" if not relationship_lucia["met_lucia"] and _n:
                jump talk_lucia.first_meeting
            "Talk to Lucia" if relationship_lucia["met_lucia"] and _n:
                jump talk_lucia.approach
            "Rest":
                $ add_time(1,0)
                $ pc.addHP(pc.max_hp/8)
                "You take a few moment to rest among the crowd."
                jump scene_bloody_lip.interior
            "Leave":
                jump scene_vergesseneburg.exterior

label talk_lucia:
    $ indoor()
    label .first_meeting:
        $ relationship_lucia["met_lucia"] = True
        "You approach the bartender carefully. She smiles at you revealing a predatory set of fangs behind her thin lips. She places her elbow on the bar, resting her chin in her hand coyly. Her sharp cat like eyes cut through you, dissecting you down to your core. Her expression is blatantly apparent, confident, predatory and playful. Like a cat toying with her food."
        "Lucia" "Seems a new face has graced my humble home. To whom do I owe the pleasure?"
        if pc_crime == 0:
            "[pc.profile[Name]]" "\"I'm [pc.profile[Name]], I was found guilty of a crime I didn't commit and sent here to live out my sentence.\""
        elif pc_crime == 1:
            "[pc.profile[Name]]" "\"I'm [pc.profile[Name]], I fought against the Legion when they took over my homeland.\""
        else:
            "[pc.profile[Name]]" "\"I'm [pc.profile[Name]], a thief who was arrested by the Legion.\""

        "The words are pulled from your mouth without thought. You're immediately aware of how thoughtlessly you just spoke. It was as if you had no control of not just your tongue but your mind itself. It's a strange and somewhat unsettling feeling that makes your mouth feel dry."
        "Lucia" "It's a pleasure to meet you, [pc.profile[Name]]. My name is Lucia Alexandreina Albescu the Third. This is my home and my town, which I welcome you to. So long as you cause me no trouble you are welcome to live and do as you please."
        jump talk_lucia.conversation

    label .approach:
        "You approach the Lucia with some hesitation, her commanding presence it's almost tangible. You feel a little anxious as you approach but that anxiety is quickly wiped away as she smiles."
        "Lucia" "\"How might I help you?\" Her voice is firm but calming, her gaze predatory but comforting. A strange juxtaposition that you can't quite explain."
        jump talk_lucia.conversation

    menu .conversation:
        # "What can you tell me about...?"
            # jump talk_lucia.lucia_information
        "Do you have any jobs I can do?":
            jump talk_lucia.quests
        "I have supplies for you" if squeeb_quest["quest"] == 0 and squeeb_quest["quest_phase"] == 1:
            jump talk_lucia.squeeb_quest_01
        "How did you get here?":
            jump talk_lucia.get_here
        "Nevermind":
            jump scene_bloody_lip.interior

    label .quests:
        "Lucia" "None at the moment, but check back again later. I'm sure I'll have work for you soon enough. I always like a -- with initiative."
        jump talk_lucia.conversation

    label .squeeb_quest_01:
        "Lucia" "\"Oh how unfortunate. I was hoping to see that delightful little rodent again.\" She pouts childishly for a moment before recomposing herself. \"No matter. I appreciate your assistance, here are the supplies he requested as per our usual arrangement. Please give him my fond regards and tell him to come in person next time. I do miss his company.\""
        $ squeeb_quest["quest_phase"] = 2
        $ removeQuestItem(item_squeeb_mead,1)
        $ removeQuestItem(item_squeeb_letter,1)
        $ addToInventory(item_squeeb_supplies,1)
        jump talk_lucia.conversation

    label .get_here:
        "Lucia" "\"Oh that's a rather long story depending on what you mean specifically. At present let's just say that I've lived here my whole life but only recently came to own this humble town and tavern.\""
        jump talk_lucia.conversation
