init python:
    import copy
    class dmg_type:
        physical = 0
        lust = 1
        magic = 2
        fire = 3
        radiant = 4
        poison = 5
        cold = 6
        lightning = 7
        weapon = 8
        humor = 9
        crude = 10
        lewd = 11
        passion = 12
        calm = 13
        intimidation = 14

    class InventoryItem:
        def __init__(self,id_key,img,val,name,desc,max_amount,vii = False):
            self.id_key = id_key
            self.img = img
            self.val = val
            self.name = name
            self.max_amount = max_amount
            self.description = desc
            self.vii = vii # Very Important Item cannot be discarded

    def getName(it):
        return it[0].name
    def getIdKey(it):
        return it[0].id_key

    def getEquipInInventory(it):
        for _i in range(len(store.inventory)):
            if store.inventory[_i][0] == it:
                return _i

    def sortInventory(how):
        # How determines what way the inventory should be sorted.
        # 1 Alphabetically
        # 2 id_key
        # 3 Amount
        if how == 1:
            store.inventory.sort(key=getName)
        if how == 2:
            store.inventory.sort(key=getIdKey)

    def addToInventory(item,amo):
        i = 0
        _a = amo
        added = False
        while i in range(len(store.inventory)) and _a > 0: # not added and
            # If it's the same item being added, see if that item already exists in the inventory
            # If the item exists increase the amount
            # Else add a new slot for the item
            if item.id_key == store.inventory[i][0].id_key:
                # Check if there is available space in this inventory slot
                if store.inventory[i][1] < item.max_amount:
                    store.inventory[i][1] += _a
                    if store.inventory[i][1] >= item.max_amount:
                        _a = store.inventory[i][1] - item.max_amount
                        store.inventory[i][1] = item.max_amount
                    else:
                        _a -= _a
                    #     inventory.append([copy.copy(item),amo])

            if _a <= 0:
                added = True

            i += 1
        while _a > 0:
            if _a > item.max_amount:
                store.inventory.append([copy.copy(item),item.max_amount])
                _a -= item.max_amount
            else:
                store.inventory.append([copy.copy(item),_a])
                _a -= _a

    def addToSell(item,amo):
        i = 0
        added = False
        while i in range(len(store.sellInventory)) and not added:
            # If it's the same item being added, see if that item already exists in the inventory
            # If the item exists increase the amount
            # Else add a new slot for the item
            if item.id_key == store.sellInventory[i][0].id_key:
                # Check if there is available space in this inventory slot
                if store.sellInventory[i][1] < item.max_amount:
                    store.sellInventory[i][1] += amo
                    if store.sellInventory[i][1] > item.max_amount:
                        a = store.sellInventory[i][1] - item.max_amount
                        store.sellInventory[i][1] = item.max_amount
                        store.sellInventory.append([copy.copy(item),a])

                    added = True
            i += 1
        if not added:
            i = amo
            while i > 0:
                if i > item.max_amount:
                    store.sellInventory.append([copy.copy(item),item.max_amount])
                    i -= item.max_amount
                else:
                    store.sellInventory.append([copy.copy(item),i])
                    i -= i

    def addToBuy(item,amo):
        i = 0
        added = False
        while i in range(len(store.buyInventory)) and not added:
            # If it's the same item being added, see if that item already exists in the inventory
            # If the item exists increase the amount
            # Else add a new slot for the item
            if item.id_key == store.buyInventory[i][0].id_key:
                # Check if there is available space in this inventory slot
                if store.buyInventory[i][1] < item.max_amount:
                    store.buyInventory[i][1] += amo
                    if store.buyInventory[i][1] > item.max_amount:
                        a = store.buyInventory[i][1] - item.max_amount
                        store.buyInventory[i][1] = item.max_amount
                        store.buyInventory.append([copy.copy(item),a])

                    added = True
            i += 1
        if not added:
            i = amo
            while i > 0:
                if i > item.max_amount:
                    store.buyInventory.append([copy.copy(item),item.max_amount])
                    i -= item.max_amount
                else:
                    store.buyInventory.append([copy.copy(item),i])
                    i -= i

    # Removes items from an inventory position
    def removeFromInventory(p,amo):
        # First make sure the item is not equipped
        if isinstance(store.inventory[p][0],Equipable):
            if store.inventory[p][0].is_equipped:
                return None
        _r = []
        _r.append(copy.copy(store.inventory[p][0]))
        _a = store.inventory[p][1]
        if _a >= amo:
            _a = amo
        _r.append(_a)
        store.inventory[p][1] -= amo
        if store.inventory[p][1] <= 0:
            store.inventory.pop(p)
        # _r[0] = copy of the item removed
        # _r[1] = amount removed from the item
        # return _r

    def removeQuestItem(it,amo):
        i = 0
        _a = amo
        removed = False
        while i in range(len(store.inventory)) and _a > 0:
            # Loop until the correct amount of an itme has been removed
            if it.id_key == store.inventory[i][0].id_key:
                # If the amount to be removed is less then or equal to the amount in this slot
                _a = _a - store.inventory[i][1]
                removeFromInventory(i,amo)
            i += 1

    def removeFromSell(p):
        if p < len(store.sellInventory):
            store.sellInventory.pop(p)

    def emptySell():
        while store.sellInventory != []:
            addToInventory(store.sellInventory[0][0],store.sellInventory[0][1])
            removeFromSell(0)

    class Consumable(InventoryItem):
        def __init__(self,id_key,img,val,name,desc,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,tier_1,dur_1,buff_2,tier_2,dur_2,buff_3,tier_3,dur_3,vii = False):
            InventoryItem.__init__(self,id_key,img,val,name,desc,max_amount,vii)
            self.hp_gain = hp_gain
            self.hp_damage = hp_damage
            self.libido_gain = libido_gain
            self.libido_damage = libido_damage
            self.buff_1 = buff_1
            self.buff_2 = buff_2
            self.buff_3 = buff_3
            self.tier_1 = tier_1
            self.tier_2 = tier_2
            self.tier_3 = tier_3
            self.dur_1 = dur_1
            self.dur_2 = dur_2
            self.dur_3 = dur_3

        def useItem(self,target):
            # inventory.remove(self)
            # ADD WAY TO REMOVE ITEMS FROM INVENTORY
            target.addHP(self.hp_gain)
            target.addLibido(self.libido_gain)
            target.addBuff(self.buff_1,self.tier_1,self.dur_1)
            target.addBuff(self.buff_2,self.tier_2,self.dur_2)
            target.addBuff(self.buff_3,self.tier_3,self.dur_3)

    class Ingredient(InventoryItem):
        def __init__(self,id_key,img,val,name,desc,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,buff_2,vii = False):
            InventoryItem.__init__(self,id_key,img,val,name,desc,max_amount,vii)
            self.hp_gain = hp_gain
            self.hp_damage = hp_damage
            self.libido_gain = libido_gain
            self.libido_damage = libido_damage
            self.buff_1 = buff_1
            self.buff_2 = buff_2

    class Equipable(InventoryItem):
        def __init__(self,id_key,img,val,name,desc,locked,vii = False):
            InventoryItem.__init__(self,id_key,img,val,name,desc,1,vii)
            # Locked is used to determine if the item cannot be unequipped
            self.locked = locked
            self.is_equipped = False
            self.equipped_to = None

        def equip(self,target):
            self.is_equipped = True
            self.equipped_to = target

        def unequip(self):
            self.is_equipped = False
            self.equipped_to = None

    class Weapon_Type():
        MISC = 0
        SWORD = 1
        SHIELD = 2
        STAFF = 3
        AXE = 4
        BOOK = 5
        BOW = 6

    class Weapon(Equipable):
        ## Slot = Number of hands it takes to wield 1-2
        ## Damage = Physical damage dice, kept in an array
        ## Lust = Lust damage dice, kept in an array
        ## Defense = Defense dice bonus, kept in an array
        ## Res = Resist libido drain dice bonus, kept in an array
        ## Attacks = number of attacks
        ## Type = Physical, Flirt, Spell
        ## Tier = What tier is this weapon
        def __init__(self,id_key,img,val,name,desc,locked,slot,combat_att,survival_att,acumen_att,glamour_att,combat_def,survival_def,acumen_def,glamour_def,type,tier,heavy=False,pierce=False,reach=False,d_type = dmg_type.weapon,l_type = dmg_type.passion,vii = False):
            Equipable.__init__(self,id_key,img,val,name,desc,locked,vii)
            self.slot = slot
            self.combat_att = combat_att
            self.survival_att = survival_att
            self.acumen_att = acumen_att
            self.glamour_att = glamour_att
            self.combat_def = combat_def
            self.survival_def = survival_def
            self.acumen_def = acumen_def
            self.glamour_def = glamour_def
            self.type = type
            self.tier = tier
            self.heavy = heavy
            self.pierce = pierce
            self.reach = reach
            self.d_type = d_type
            self.l_type = l_type

        def equip(self,target):
            if isinstance(target,Mob):
                Equipable.equip(self,target)
                target.equip_weapon(self)

        def unequip(self):
            if isinstance(self.equipped_to,Mob):
                self.equipped_to.unequip_weapon(self.slot)
                Equipable.unequip(self)

    class Armor(Equipable):

        def __init__(self,id_key,img,val,name,desc,locked,slot,combat_att,survival_att,acumen_att,glamour_att,combat_def,survival_def,acumen_def,glamour_def,boon,tier,vii = False):
            Equipable.__init__(self,id_key,img,val,name,desc,locked,vii)
            self.slot = slot
            self.combat_att = combat_att
            self.survival_att = survival_att
            self.acumen_att = acumen_att
            self.glamour_att = glamour_att
            self.combat_def = combat_def
            self.survival_def = survival_def
            self.acumen_def = acumen_def
            self.glamour_def = glamour_def
            self.boon = []
            self.boon += boon
            self.tier = tier

        def equip(self,target):
            Equipable.equip(self,target)
            target.equip_armor(self,self.slot)

        def unequip(self):
            self.equipped_to.unequip_armor(self.slot)
            Equipable.unequip(self)

    # def callInventory():
    #     renpy.call("scene_inventory")
    #     return

    def indoor():
        renpy.show_screen("clock")
        accessInventory = True
        accessMap = False
        renpy.show_screen("menubar",_op2 = True,_op3 = False)

    def outdoor():
        renpy.show_screen("clock")
        accessInventory = True
        accessMap = True
        renpy.show_screen("menubar",_op2 = True,_op3 = True)
