﻿# Goblin Outpost Encounters

label scene_goblin_outpost:
    label .exterior:
        $ outdoor()
        if 8 < calendar[3] < 20:
            scene expression goblin_outpost_01.bg_day with dissolve
        else:
            scene expression goblin_outpost_01.bg_night with dissolve

        if 19 > calendar[3] > 7:
            "Ahead of you is a large gnarled tree made of bare curled branches. The tree appears long dead and has several wooden platforms, ladders and ramps grafted to it's sides. Small buildings and homes litter the sides of the tree, while the surrounding forest floor is covered in small tents made of hides and cloth."
        else:
            "Ahead of you is a large tree with bare branches that curl up towards the night sky. Wooden structures with connecting ramps and ladders have been grafted to the trunk. Small tents surround the base of the tree, illuminated by small campfires and torches. You can make out the silhouettes of several small creatures keeping guard."

        menu:
            "Sneak Inside" if faction_score["goblins"] < 60:
                if renpy.random.randint(1,10) < 5:
                    # Success
                    if 19 > calendar[3] > 7:
                        "You carefully watch the goblins as they patrol their camp, it takes several minutes before the guards stop looking in your direction. Moving quickly you sneak into the camp without raising any alarm. Taking cover you hide behind one of the tents. You can hear the voices of goblins chattering to one another. The camp seems fairly active this time of day."
                    else:
                        "...Night description"
                    jump scene_goblin_outpost.sneak_in_successful
                else:
                    # Fail
                    if 19 > calendar[3] > 7:
                        "..."
                    else:
                        "..."
                    python:
                        import copy

                    if renpy.random.randint(1,2) == 1:
                        $ _enemy = copy.copy(mob_goblin_male_01)
                        $ _i = standd6.roll()[0] + standd6.roll()[0]
                        if _i == 12:
                            $ _eq_right = copy.copy(item_big_stick)
                            $ _eq_acc = None
                        else:
                            $ _eq_right = copy.copy(item_stick)
                            $ _eq_acc = copy.copy(item_magic_collar)
                            $ _enemy.sprite = "Male Goblin Collared"
                    else:
                        $ _enemy = copy.copy(mob_goblin_female_01)
                        if _i == 12:
                            $ _eq_right = copy.copy(item_big_stick)
                            $ _eq_acc = None
                        else:
                            $ _eq_right = copy.copy(item_stick)
                            $ _eq_acc = copy.copy(item_magic_collar)
                            $ _enemy.sprite = "Female Goblin Collared"

                    $ store.battle_end = "goblin_battle"
                    $ store.last_scene = "scene_goblin_outpost.exterior"
                    call scene_battle_setup pass (_en = _enemy,_con = chooseCondition(),_ambush = False,_eq_right = _eq_right,_eq_acc = _eq_acc) from _call_scene_battle_setup_8
            "Enter the camp" if faction_score["goblins"] >= 60:
                pass
            "Scavenge":
                jump scene_scavenge_begin
            "Explore":
                jump scene_explore_begin

    label .sneak_in_successful:
        $ indoor()
        menu:
            "You find a cluster of boxes against a tent that proves to be an effective hiding place. You should be safe here while you decide your next move."
            "Steal Supplies":
                $ _i = renpy.random.randint(1,3)
                if _i == 1:
                    jump scene_goblin_outpost.steal_gunpowder
                elif _i == 2:
                    jump scene_goblin_outpost.food_tent
                else:
                    jump scene_goblin_outpost.caught_stealing
            "Leave":
                jump scene_goblin_outpost.exterior

    label .steal_gunpowder:
        if 19 > calendar[3] > 7:
            "Slipping into a nearby tent, you're relieved to find it unoccupied. A sets of crude alchemical tools sit on a wooden table in the center of the tent. Several barrels with powders and thick liquids are lined up neatly against on side of the tent. Among the vials and flasks you find a small hollowed out horn containing a mix of black powder."
        else:
            "...Night description"
        $ addToInventory(item_black_powder,1)
        $ add_time(0,10)
        jump scene_goblin_outpost.sneak_in_successful

    label .food_tent:
        menu:
            "Crawling under the flap of a nearby tent you find it filled with dried meats which hang from the support beams. A few haphazardly stacked crates are filled with rock salt. The tent fills your nose with delicious scents, causing your mouth to water."
            "Steal meat":
                jump scene_goblin_outpost.steal_meat
            "Steal salt":
                jump scene_goblin_outpost.steal_salt
            "Steal both":
                if renpy.random.randint(1,10) < 4:
                    jump scene_goblin_outpost.steal_food
                else:
                    jump scene_goblin_outpost.caught_stealing_food

    label .steal_meat:
        "You peel off a section of the salted meat, wrapping it up carefully. As you finish you can hear the sound of nearby voices approaching, not wanting to risk getting caught you slip back out the way you came."
        $ addToInventory(item_cooked_venison,1)
        $ add_time(0,10)
        jump scene_goblin_outpost.sneak_in_successful

    label .steal_salt:
        "Grabbing a nearby square of parchment you bundle up a pile of salt from one of the crates. You reach for another pile but notice the flicker of approaching light. Not wanting to risking being caught you duck under the tent flap and return to your previous hiding spot."
        $ addToInventory(item_rock_salt,1)
        $ add_time(0,10)
        jump scene_goblin_outpost.sneak_in_successful

    label .steal_food:
        "You grab a small sheet of nearby parchment and fold it carefully around a pile of salt which you pocket quickly. You decide to push your good fortune and peel off a slab of meat as well. You tear a sizable chunk from the drying flank and pocket it. Having gathered more then you came for you slip back the way you came."
        $ addToInventory(item_rock_salt,1)
        $ addToInventory(item_cooked_venison,1)
        $ add_time(0,20)
        jump scene_goblin_outpost.sneak_in_successful

    label .caught_stealing:
        "Stepping out of your hiding place you big to search the area, finding a few boxes and crates you begin digging through them. Suddenly you here a russle behind you as a goblin rushes towards you!"
        if renpy.random.randint(1,2) == 1:
            $ _enemy = copy.copy(mob_goblin_male_01)
            $ _i = standd6.roll()[0] + standd6.roll()[0]
            if _i == 12:
                $ _eq_right = copy.copy(item_big_stick)
                $ _eq_acc = None
            else:
                $ _eq_right = copy.copy(item_stick)
                $ _eq_acc = copy.copy(item_magic_collar)
                $ _enemy.sprite = "Male Goblin Collared"
        else:
            $ _enemy = copy.copy(mob_goblin_female_01)
            if _i == 12:
                $ _eq_right = copy.copy(item_big_stick)
                $ _eq_acc = None
            else:
                $ _eq_right = copy.copy(item_stick)
                $ _eq_acc = copy.copy(item_magic_collar)
                $ _enemy.sprite = "Female Goblin Collared"

        $ store.battle_end = "goblin_battle"
        $ store.last_scene = "scene_goblin_outpost.exterior"

        call scene_battle_setup pass (_en = _enemy,_con = chooseCondition(),_ambush = False,_eq_right = _eq_right,_eq_acc = _eq_acc) from _call_scene_battle_setup_9

    label .caught_stealing_food:
        "You begin cutting a piece of meat from one of the drying flanks when suddenly a goblin walks in holding up a lantern in your direction. He shouts loudly."
        "Goblin" "\"Intruder! Intruder!\""
        "Cornered you drop the meat and turn to fight. You won't be getting out of here peacefully now."
        if renpy.random.randint(1,2) == 1:
            $ _enemy = copy.copy(mob_goblin_male_01)
            $ _i = standd6.roll()[0] + standd6.roll()[0]
            if _i == 12:
                $ _eq_right = copy.copy(item_big_stick)
                $ _eq_acc = None
            else:
                $ _eq_right = copy.copy(item_stick)
                $ _eq_acc = copy.copy(item_magic_collar)
                $ _enemy.sprite = "Male Goblin Collared"
        else:
            $ _enemy = copy.copy(mob_goblin_female_01)
            if _i == 12:
                $ _eq_right = copy.copy(item_big_stick)
                $ _eq_acc = None
            else:
                $ _eq_right = copy.copy(item_stick)
                $ _eq_acc = copy.copy(item_magic_collar)
                $ _enemy.sprite = "Female Goblin Collared"

        $ store.battle_end = "goblin_battle"
        $ store.last_scene = "scene_goblin_outpost.exterior"

        call scene_battle_setup pass (_en = _enemy,_con = chooseCondition(),_ambush = False,_eq_right = _eq_right,_eq_acc = _eq_acc) from _call_scene_battle_setup_10
