# Last Drop Encounters

label scene_last_drop:
    label .exterior:
        $ outdoor()
        if 8 < calendar[3] < 20:
            show bg forest_day with dissolve
        else:
            show bg forest_night with dissolve

        "A lone building of stone construction sits buried nustled under looming trees and tangled undergrowth. Broken windows and rotten beams lean percariously under the weight of the surrounding forest. The dim flicker of fire light shines out of the window and gaps in the foundation, welcoming you inside. A crude wooden sign, depicting a tilted tankard with a single drop falling from the rim, hangs limply off a single chain."

        menu:
            "The decrepit shell of The Last Drop looms before you, dense forest surrounds it on all sides."

            "Enter":
                jump .tavern
            "Search the back":
                jump .beehives
            "Scavenge":
                jump scene_scavenge_begin
            "Explore":
                jump scene_explore_begin

    label .tavern:
        $ indoor()

        if 8 < calendar[3] < 16:
            # Day time description
            show bg basic with dissolve
            "A dark tavern interior opens up before you, the space is wide but the sagging ceiling and low support beams make the place feel dark and suffocating. Several stocky wooden tables and chairs have been placed carefully around the interior. Branches and foliage crawl through gaps and broken windows."

            $ _i = renpy.random.randint(1,2)
            if _i == 1:
                "A shady looking man covered in fur with rat like features quietly wipes a tankard behind the wooden bar. He gives you a smile, revealing his jagged teeth and welcomes you inside."
            elif _i == 2:
                "A wererat with dark fur and purplish skin quietly rearranges some of the furniture. He casts you a glance and welcomes you inside."

            menu:
                "Approach the bartender":
                    "You approach the bartender who flashes a toothy smile."
                    jump scene_last_drop.talk_to_squeeb
                "Go to your room":
                    "Slipping quietly up the stairs you head towards the guest rooms. The stairs creak slightly as you ascend before pushing your way into the small room."
                    jump scene_last_drop.safe_room
                "Leave":
                    jump scene_last_drop.exterior


        else:
            # Night time description
            show bg basic with dissolve
            "The stone walls glint with yellow light, a small fire flickers comfortingly in the squat, sunken hearth. A wooden bar sits ahead of you, a display of freshly cleaned tankards sit across it's surface."
            "Squeeb stands quietly behind the bar, flashing you a small toothy smile."

            menu:
                "Approach the bartender":
                    jump scene_last_drop.talk_to_squeeb
                "Go to your room":
                    "Slipping quietly up the stairs you head towards the guest rooms. The stairs creak slightly as you ascend before pushing your way into the small room."
                    jump scene_last_drop.safe_room
                "Leave":
                    jump scene_last_drop.exterior

    label .safe_room_defeat:
        scene bg basic with fade
        $ indoor()
        $ store.map_point = the_last_drop
        menu:
            "You were defeated. That sucks"
            "Rest":
                $ store.last_checkpoint = "scene_last_drop.safe_room_defeat"
                jump scene_last_drop.safe_room
            "Leave":
                jump scene_last_drop.tavern

    label .safe_room:
        show bg basic with dissolve
        $ indoor()
        menu:
            "This is the safe room. You can rest here."
            "Rest":
                $ store.last_checkpoint = "scene_last_drop.safe_room_defeat"
                $ add_time(8,0)
                $ store.pc.hp = store.pc.max_hp
                $ store.pc.libido = 0
                jump scene_last_drop.safe_room
            "Save":
                hide screen menubar
                hide screen clock
                call screen save
                # jump scene_last_drop.safe_room
            "Leave":
                jump scene_last_drop.tavern

        jump scene_last_drop.safe_room

    label .meet_squeeb_first_death:
        scene bg basic with fade
        $ indoor()

        $ store.map_point = the_last_drop
        $ store.last_checkpoint = "scene_last_drop.safe_room_defeat"
        $ store.last_scene = None
        $ store.pc.hp = store.pc.max_hp

        "The dizzying sensation of consciousness comes to you slowly, darkness slowly fades to light as you return to your sense. You oddly find yourself laying on a straw mattress with a shaggy worn blanket covering you. Blinking slowly your vision begins to focus, you find yourself in a small wooden room with modest furnishings."

        "The room has a broken window, covered with a simple set of ragged drapes. A simple oak door with iron banding stands opposite the window. A plain bed frame supports the somewhat uncomfortable straw matress you find yourself on. A satchel with your belongs rests on a chunky wooden stool."

        "You pull back the blanket revealing your wounds which have all been bandaged and cleaned. As you gather up your belongings you find an extra sheet of parchment with a large ink map of the local area on it."

        "Cracking the door open and peering in reveals a hallway with a sagging roof, several doors run down the right side of the hall as you peer right. While to your left you find a staircase that descends downards. The sound of creaking floorboards can be heard from the lower level."

        "You descend cautiously down the stairs, which lead to what appears to be a tavern. Sagging ceiling and low support beams give it a decrepit appearance. A hunched over humanoid busily wipes down a few tables, he has a pair of larger ears that swivel in your direction as you reach the bottom of the stairs."

        show squeeb collared_idle with dissolve

        "The dark furred humanoid turns, revealing his rat like appearance. He gives you a small smile, revealing a mouth full of jagged teeth. His narrow red eyes seem cunning and dark, but soften at the sight of you."

        unknown_person "\"Oh good you're awake. Was worried there, you got hit pretty hard there. How're you feeling?\""

        menu:
            unknown_person "\"Oh good you're awake. Was worried there, you got hit pretty hard there. How're you feeling?\""

            "Feeling much better. Thank you.":
                pass

        unknown_person "\"I'm glad to hear it. You can call me Squeeb, this is my establishment the Last Drop. I take it you were with the latest shipment of prisoners, what's your name?\""

        menu:
            squeeb "\"I'm glad to hear it. You can call me Squeeb, this is my establishment the Last Drop. I take it you were with the latest shipment of prisoners, what's your name?\""

            "I'm [pc.profile[Name]]":
                $ relationship_squeeb["gave_name"] = True
                jump .an_1
            "Stay silent":
                jump .an_2

        label .an_2:
            squeeb "\"Keep your secrets I suppose, I get it, can't go trusting any were that picks you up in a forest. I keep this place open to anyone needing a place to rest, so if you need a place to stay feel free to go grab one of the rooms if they're open. Best of luck out there.\""

            "Squeeb gives you a judgemental look and sends you on your way."

            hide squeeb collared_idle with dissolve

            jump scene_last_drop.exterior

        label .an_1:
            squeeb "\"Good to meet you [pc.profile[Name]]. If you find yourself needing a place to rest at night you're welcome to stay in the tavern, or use one of the rooms upstairs if they're free. If they're unlocked, they're free. If you go exploring, make sure you get indoors at night, not everyone on this island is as nice as I am.\""

    label .talk_to_squeeb:
        show bg basic with dissolve
        $ indoor()
        show squeeb collared_idle with dissolve

        if relationship_squeeb["gave_name"]:
            $ _t = "Hey there " + pc.profile['Name'] + ". What can I do for you?"
        else:
            $ _t = "\"What can I do for you stranger?\""

        menu:
            squeeb "[_t]"
            "Thanks for saving me" if not relationship_squeeb["thanked_for_saving"] and relationship_squeeb["gave_name"]:
                jump .thanks_for_saving
            "I'm [pc.profile[Name]]." if not relationship_squeeb["gave_name"]:
                jump .give_name
            "What can you tell me about the area?":
                jump .info
            "Nothing.":
                hide squeeb collared_idle with dissolve
                jump scene_last_drop.tavern

        label .thanks_for_saving:
            $ relationship_squeeb["thanked_for_saving"] = True
            squeeb "\"You're welcome, I just treated your wounds and it's hardly a professional job. You should be thanking Fenna, lucky she happened by you and brought you here. If you want to meet her she's usually around back during the day. Though watch out for the bees.\""
            jump scene_last_drop.talk_to_squeeb

        label .give_name:
            $ store.relationship_squeeb["gave_name"] = True
            squeeb "\"Pleasure to meet you [pc.profile[Name]].\""
            jump scene_last_drop.talk_to_squeeb

        label .info:
            squeeb "\"The forst is mostly dangerous at night, so you want to avoid it when you can, or if you can't I'd recommend getting a lantern or setting up a campfire.\""
            squeeb "\"To the north there are some ruins that some folks have taken up residence in. You might be able to get more information there but it's a few hours from here.\""
            jump scene_last_drop.talk_to_squeeb

    label .beehives:
        $ outdoor()
        if 8 < calendar[3] < 20:
            show bg forest_day with dissolve
        else:
            show bg forest_night with dissolve

        "Walking around the back of the Last Drop you find a large flower garden surrounding several apiaries. Small shrubs and beatiful well tended flowers grow in wooden planting beds. Dozens of brightly colored butterflies flutter around the area, while bees buzz between flowers and apiaries."

        # Day
        if 8 < calendar[3] < 20:
            "A large female minotaur is laboring in the garden, currently carrying large logs which she chops into fireword with a large axe. She seems to pay you little mind as you walk out from around the corner."

        menu:
            "Bees buzz around you, dancing between you and the flowers."
            "Go to the Last Drop":
                jump scene_last_drop.exterior
            "Talk to Fenna" if 8 < calendar[3] < 20:
                jump scene_last_drop.fenna_outside

    label .fenna_outside:
        $ outdoor()
        if 8 < calendar[3] < 20:
            show bg forest_day with dissolve
        else:
            show bg forest_night with dissolve

        show fenna collared_idle with dissolve

        if not store.relationship_fenna['met_fenna']:
            "You approach the minotaur who strikes a log in two with her axe before glancing in your direction."

            fenna "Oh you're up, glad to see it."

            menu:
                fenna "Can I help you with something?"
                "Who are you?":
                    jump talk_fenna.meet_fenna
                "No that's alright.":
                    hide fenna collared_idle with dissolve
                    jump scene_last_drop.beehives
        else:
            "You approach Fenna, finding a moment between her work to speak. She wipes her brow and turns to you with a soft blank expression."

label talk_fenna:
    $ indoor()
    menu:
        fenna "Can I help you with something?"
        "Thanks for helping me." if store.relationship_squeeb["thanked_for_saving"]:
            jump talk_fenna.thank_for_saving
        "What brought you here?":
            jump talk_fenna.why_here
        "Nevermind.":
            hide fenna collared_idle with dissolve
            jump scene_last_drop.beehives

    label .thank_for_saving:
        "You're welcome. I try and keep an eye out for newcomers whenever the ships come in, it gets pretty dangerous at night if you're not prepared."
        jump scene_last_drop.fenna_outside

    label .meet_fenna:
        $ store.relationship_fenna['met_fenna'] = True
        fenna "You can call me Fenna. I tend the apiaries and do the heavy lifting around here. If you need something built I can do it."
        jump scene_last_drop.fenna_outside

    label .why_here:
        fenna "Like most folk I got caught up during the rebellion. Fought for my home and it didn't end well. When I got here it wasn't quite as dangerous as it is now, found Squeeb holed up in this place, we've been together since. Fixing things up when we can."
        jump scene_last_drop.fenna_outside
