﻿## scavenge_forest contains all general events that can be found in forests regions.

label scav_forest:
    label .stick:
        "While rummaging through the forest floor you discover a small knotted stick, it's not much but might be serviceable as a weapon."
        menu:
            "Take the stick":
                $ addToInventory(item_stick,1)
                $ add_time(0,30)
            "Leave it":
                $ add_time(0,10)
                pass

        jump scene_last

    label .big_stick:
        "The trees in the area appear snapped and mangled as if some great beast tore through the area. In the chaos a large branch was broken free, it would make a very versatile club."
        menu:
            "Take the large stick":
                $ addToInventory(item_big_stick,1)
                $ add_time(0,30)
            "Leave it":
                $ add_time(0,10)
                pass

        jump scene_last

    label .scuffle:
        "As you search through the forest, you notice a set of trees that part unnaturally, branches broken and twisted at odd angles, there are clear signs of a conflict. Flecks of blood are splattered across the trees and grass confirming a violent encounter. You can make out a set of tracks that leed away from the scene trailing some blood."
        $ add_time(0,10)
        menu:
            "Do you want to follow the tracks?"
            "Follow the tracks":
                jump .follow
            "Go back.":
                jump scene_last

        label .follow:
            if standd6.roll()[0] + 1 > pc.survival:
                "You attempt to follow the tracks but quickly lose sight of them in the dense brush. Perhaps you'll have better luck some other time."
            else:
                $ add_time(0,20)
                "Following the tracks and disturbed plant life you are able to follow whatever beast had left the scene. You're able to follow the trail for quite some time before discovering a small den formed of earth and the roots of a thick tree. You can hear the sounds of growling coming from inside the den and spot a pair of wolves devouring a recently caught meal."
                if standd6.roll()[0] + standd6.roll()[0] < 7:
                    "The wolves stop eating suddenly, looking out of the den, ears perked and fur raised. They sniff for a moment, you back away slowly but they've already gotten your scent. It only takes a few moments before they're upon you."
                    # self, sprite, hp, libido, stamina, survival, combat, acumen, glamour, name, race, gender, hei, wei, base_attack, base_flirt, base_defense, base_resistance,
                    # sk_1,sk_2,sk_3,sk_4,sk_5,sk_6,condition
                    $ _enemy = copy.copy(mob_wolf_pack_01)
                    $ _enemy.add_dmg_immune(dmg_type.lust)
                    $ store.battle_end = "wolves_battle"
                    call scene_battle_setup pass (_en = _enemy) from _call_scene_battle_setup_1
                else:
                    menu:
                        "The wolves don't appear to have noticed you. If you're going to leave, now is your chance."
                        "Back away":
                            jump scene_last
                        "Ambush the wolves":
                            $ _enemy = copy.copy(mob_wolf_pack_01)
                            $ _enemy.add_dmg_immune(dmg_type.lust)
                            $ store.battle_end = "wolves_battle"
                            call scene_battle_setup pass (_en = _enemy,_pc_ambush = True) from _call_scene_battle_setup_2

    label .flowers:
        "While scavenging the area for useful materials you stumble upon a small cluster of flowering plants. You recall they can be used in potions and if not maybe they'll be good for trade"
        menu:
            "Pick the flowers?"
            "Pick flowers":
                $ addToInventory(item_red_flower,1)
                $ add_time(0,15)
            "Leave them":
                $ add_time(0,5)
                pass

        jump scene_last

    label .berries:
        $ _i = standd6.roll()[0]
        if _i > 2:
            "Digging through the brush and trees of the forest floor, you catch sight of a small cluster of bushes with jagged leaves and dark berries. The berries appear fresh and ready for picking."
            menu:
                "Do you pick black berries?"
                "Pick black berries":
                    $ addToInventory(item_wildberry,1)
                    $ add_time(0,20)
                "Leave them":
                    $ add_time(0,5)
                    pass

            jump scene_last
        elif _i == 2:
            "Digging through the brush and trees of the forest floor, you catch sight of a small cluster of bushes with jagged leaves. Freshly broken branches stick out at odd angles, clear signs that an animal has recently eaten whatever berries may have grown here."
            jump scene_last
        else:
            "Digging through the brush and trees of the forest floor, you catch sight of a small cluster of bushes with jagged leaves that hide clusters of dark berries. Looking down at the berries you notice flecks of white mold forming on the now rotten berries. They wouldn't be safe for consumption so you leave them where they are."
            jump scene_last

    label .old_camp:
        "Heavy trees break away revealing a small area that has been cleared away. An old tattered cloth is strung up between several branches forming a makeshift tent. Stones have been arranged into a crude fire pit and dark long cooled ashes remain inside."
        "The camp seems old and long since abandoned as bits of moss have begun to crawl up the firepit, while clumps of dried leaves have settled on top of the tattered tent."
        $ add_time(0,30)
        if standd6.roll()[0] > 4:
            if standd6.roll()[0] > 3:
                "Though almost anything of value has already long since been taken or looted you do spot a small cloth wrapped stick leaning agaisnt the trunk of a nearby tree. Picking it up you find it's been fashioned with a stone tip, making a simple but effective spear."
                menu:
                    "Take the spear.":
                        $ addToInventory(item_basic_spear,1)
                    "Leave it.":
                        pass
            else:
                "Searching through the camp you find that almost everything has been stripped away or looted, but fortunately you do discover a simple knife wedged between the stones of the campfire. Though it's clearly worn and well used it's still somewhat sharp and functional."
                menu:
                    "Take the knife.":
                        $ addToInventory(item_basic_dagger,1)
                    "Leave it.":
                        pass
        else:
            "You search the camp for several minutes but find it's been entirely looted leaving nothing of value for your own adventure. The tattered cloth of the former tent is far too damaged to be useful and nothing else beyond the ashse of the fire remain. Taking one last glance around the sad state of this place you turn and make your leave."

        jump scene_last

    label .nothing:
        "You spend thirty minutes searching the nearby areas but the forest provides nothing of use this time."

        jump scene_last

    # label .wildberries:
    #     "Digging through the brush and trees of the forest you catch sight of a small cluster of bushes. The bushes have several small clusters of berries hanging from it."
    #     $ _t = False
    #     if standd6.roll()[0] == 1:
    #         $ _t = True
    #         $ _s = False
    #         if pc.acumen > standd6.roll()[0] + standd6.roll()[0]:
    #             $ _s = True
    #         $ _i = renpy.random.choice(["Female","Male"])
    #         $ _enemy = Hostile(_i + " Goblin",4,6,2,6,4,3,3,"Goblin","Goblin",_i,36,40,[whiteDice],[whiteDice],[whiteDice],[whiteDice],store.skill_strike,store.skill_flirt,skill_pierce,None,None,None,_c)
    #         $ _eq_right = Weapon(200004,"gui/items/big_stick.jpg",0,"Primitive Spear","Description",False,'Right',[redDice,blueDice],None,None,None,Weapon_Type.STAFF,0,pierce = True)
    #     if
    #     menu:
    #         "You find a small cluster of red berries."
    #         "Gather berries" if not _t:
    #             jump .
