init python:
    import math

    # Rename months into Time of Harvet, Time of Frost, Time of Planting, Time of Growth
    # Each Time is a 90 day period

    def month_switch(arg):
        calDictionary = {
            1: "January",
            2: "February",
            3: "March",
            4: "April",
            5: "May",
            6: "June",
            7: "July",
            8: "August",
            9: "September",
            10: "October",
            11: "Novemeber",
            12: "December",
        }
        return calDictionary.get(arg,"Invalid Month")

    def days_per_month(arg):
        dayPerMonthDict = {
            1: 31,
            2: 28,
            3: 31,
            4: 30,
            5: 31,
            6: 30,
            7: 31,
            8: 31,
            9: 30,
            10: 31,
            11: 30,
            12: 31
        }
        return dayPerMonthDict.get(arg,0)

    def get_day_text(arg_year,arg_month,arg_day):
        dayDict = {
            0: "Mon",
            1: "Tue",
            2: "Wed",
            3: "Thu",
            4: "Fri",
            5: "Sat",
            6: "Sun",
            7: "Day Unavailable"
        }

        _m = arg_month - 2
        if _m <= 0:
         _m += 12
        _r = arg_year % 100
        _c = (arg_year - _r) / 100
        _f = arg_day + math.floor((13*_m-1)/5) + _r + math.floor(_r/4) + math.floor(_c/4) - 2*_c
        _ret = 7
        if _f < 0:
            _i = math.ceil(_f / 7) * 7
            _ret = _f - _i
        else:
            _ret = _f % 7

        return dayDict.get(_ret,7)

    def add_time(_ho,_mi):
        store.calendar[4] += _mi
        while store.calendar[4] >= 60:
            store.calendar[4] -= 60
            store.calendar[3] += 1

        store.calendar[3] += _ho
        while store.calendar[3] >= 24:
            store.calendar[3] -= 24
            store.calendar[2] += 1
            # SET WEATHER
            if renpy.random.randint(1,6) == 1:
                _weatherDict = {1:"thunderstorm", 2:"rain", 3:"overcast", 4:"windy", 5:"hot", 6:"cold"}
                store.weather = _weatherDict.get(renpy.random.randint(1,6))
            else:
                store.weather = "clear"

        while store.calendar[2] > 30:
            store.calendar[2] -= 30
            store.calendar[1] += 1

        while store.calendar[1] > 12:
            store.calendar[1] -= 12
            store.calendar[0] += 1
