﻿init python:
    offset = 50
    import math
    class Skill:
        def __init__(self,img,name,description,funct,stam,type,acc = 0):
            self.img = img
            self.name = name
            self.description = description
            self.funct = funct  # The function to trigger when the skill is used
            self.stam = stam    # How much Stamina the skill requires
            self.type = type    # Type is a string containing the type of attack. Used to determine physical, lust, both, special, buff, debuff
            self.acc = acc      # The accuracy out of 100. A 0 automatically hits

        def skill_priority(self,user,target):
            # Skill Priority checks the current state of the user and target and provides a priority for the use of that skill
            # Skill priority is a value between 0 and 10
            # Set Strike Priority
            _check_condition = False
            if isinstance(user,Hostile):
                _check_condition = True

            # STRIKE --------------------------------------------------------------------------------------------
            if self.name == "Strike":
                if _check_condition:
                    if user.condition == "Bold":
                        return 4
                    elif user.condition == "Angry":
                        return 5
                    else:
                        return 3
                else:
                    return 3
            # FLIRT ---------------------------------------------------------------------------------------------
            elif self.name == "Flirt":
                # If collared
                if user.equipment['Acc'] != None and user.equipment['Acc'].id_key == item_magic_collar.id_key:
                    return renpy.random.choice([0,0,0,1])
                else:
                    _bonus = 0
                    if user.libido > user.max_libido/2:
                        _bonus = 1
                    if _check_condition:
                        if user.condition == "Aroused" or user.condition == "Submissive":
                            return 2 + _bonus
                    return 1 + _bonus
            # SIREN SONG ----------------------------------------------------------------------------------------
            elif self.name == "Siren Song":
                if target.buff["Charmed"][0]:
                    return 0
                else:
                    return 5
            # REST ----------------------------------------------------------------------------------------------
            elif self.name == "Rest":
                if user.condition == "Melancholy":
                    return 10 - (2 * user.stamina)
                else:
                    return 8 - (2 * user.stamina)
            # POWER WORD KILL -----------------------------------------------------------------------------------
            elif self.name == "Power Word Kill":
                return 10
            else:
                return 0

    def use_skill(act,user,target):
        # Check is user is attempting to use a Physical skill while Charmed.
        # If they are, test charmed
        if act.type == "Physical" and user.buff["Charmed"][0]:
            if renpy.random.randint(1,100) < 51:
                return user.profile['Name'] + " tried to fight back but was charmed."
        # Finds the function and triggers it
        user.stamina -= act.stam
        func = act.funct
        _a = act.acc
        return func(user,target,_a)

    # These function are skills, they are called upon use
    # skills take the user and target as parameters

    # strike is a basic attack that deals damage to the target based on the user's attack dice
    # strike returns the total damage dealt
    def strike(user,target,acc):
        # Check to hit
        if renpy.random.randint(1,100) <= acc:
            _hit = True
        else:
            _hit = False

        if _hit:
            if user.hands['Right'] != None:
                _d = user.hands['Right'].d_type
            else:
                _d = dmg_type.weapon

            # Check for damage immunity
            if target.is_immune(_d) or target.is_immune(dmg_type.physical):
                _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " but it had no effect.",0]
            else:
                if target.is_resist(_d) or target.is_resist(dmg_type.physical):
                    _v = 0.5
                elif target.is_vulnerable(_d) or target.is_vulnerable(dmg_type.physical):
                    _v = 2
                else:
                    _v = 1

                _dmg = calculateDamage(8,int(user.skill_points()/2) + user.combat + user.get_combat_attack(),int(target.skill_points()/2) + target.combat + target.get_combat_defense(),_type = _v)

                if _dmg > 0:
                    target.addHP(_dmg * -1)
                else:
                    _dmg = 1
                    target.addHP(-1)

                _wea = "fists"
                if user.hands['Right'] != None:
                    _wea = user.hands['Right'].name
                _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " with their " + str(_wea) + " dealing " + str(_dmg) + " damage.",_dmg]
        else:
            _ret = [str(user.profile["Name"]) + " missed " + str(target.profile['Name']) + " dealing no damage.",0]

        return _ret

    # Flirt rolls the players base flirt damage based on equipment and weapons.
    # Flirt also increases the user's libido by one gray dice
    # Add one Green dice per 4 points in Glamour
    def flirt(user,target,acc):
        # Roll libido damage
        _dmg = 0
        _hit = False
        if user.glamour > target.acumen*2:
            if standd6.roll()[0] > 1 or standd6.roll()[0] > 1 or standd6.roll()[0] > 1:
                _hit = True
        elif user.glamour > target.acumen + 2:
            if standd6.roll()[0] > 1 or standd6.roll()[0] > 1:
                _hit = True
        elif user.glamour < target.acumen - 2:
            if standd6.roll()[0] > 1 and standd6.roll()[0] > 1:
                _hit = True
        else:
            if standd6.roll()[0] > 1:
                _hit = True

        if _hit:
            if user.hands['Right'] != None:
                _d = user.hands['Right'].l_type
            else:
                _d = dmg_type.passion
            # Check for damage immunity
            if target.is_immune(_d) or target.is_immune(dmg_type.lust):
                _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " but it had no effect.",0]
            else:
                if target.is_resist(_d) or target.is_resist(dmg_type.lust):
                    _v = 0.5
                elif target.is_vulnerable(_d) or target.is_vulnerable(dmg_type.lust):
                    _v = 2
                else:
                    _v = 1

                _dmg = math.floor(calculateDamage(10,user.glamour + user.get_glamour_attack(),target.glamour + target.get_glamour_defense(),_type = _v))

                if _dmg > 0:
                    target.addLibido(_dmg)
                else:
                    _dmg = 0

                # Increase user libido
                user.addLibido(grayDice.roll()[0])

                _ret = [str(user.profile["Name"]) + " winked seductively at " + str(target.profile['Name']) + ". " + str(target.profile['Name']) + "'s libido increased by " + str(_dmg) + ".",0]
        else:
            _ret = [str(user.profile["Name"]) + " attempted to flirt but failed.",0]

        return _ret

    def rest(user,target,acc):
        _dmg = purpleDice.roll()[0]
        user.stamina += _dmg
        if user.stamina > user.max_stamina:
            user.stamina = user.max_stamina

        _ret = [str(user.profile["Name"]) + " rested for a moment, recovering " + str(_dmg) + " stamina.",0]

        return _ret

    def struggle(user,target,acc):
        if renpy.random.randint(1,100) <= acc:
            _hit = True
        else:
            _hit = False

        if _hit:
            # Check for damage immunity
            if target.is_immune(dmg_type.physical):
                _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " but it had no effect.",0]
            else:
                if target.is_resist(_d) or target.is_resist(dmg_type.lust):
                    _v = 0.5
                elif target.is_vulnerable(_d) or target.is_vulnerable(dmg_type.physical):
                    _v = 2
                else:
                    _v = 1

                _dmg = calculateDamage(10,user.combat + user.get_combat_attack(),target.combat + target.get_combat_defense(),_type = _v)

                if _dmg > 0:
                    target.addHP(_dmg * -1)
                else:
                    _dmg = 1
                    target.addHP(-1)

            _recoil = renpy.random.randint(5,10)
            user.addHP(_recoil*-1)

            _ret = [str(user.profile["Name"]) + " struggled desperately dealing " + str(_dmg) + " to " + str(target.profile["Name"]) + " and took " + str(_recoil) + " of damage as recoil.",_dmg]
        else:
            _recoil = renpy.random.randint(5,10)
            user.addHP(_recoil*-1)
            _ret = [str(user.profile["Name"]) + " struggled desperately but missed." + str(user.profile["Name"]) + " took " + str(_recoil) + " damage from recoil.",0]

        return _ret

    def pierce(user,target,acc):
            # Check to hit
            if renpy.random.randint(1,100) <= acc:
                _hit = True
            else:
                _hit = False

            if _hit:
                _p = False
                if user.hands['Right'] != None:
                    _d = user.hands['Right'].d_type
                    if user.hands['Right'].pierce:
                        _p = True
                else:
                    _d = dmg_type.weapon

                # Check for damage immunity
                if target.is_immune(_d) or target.is_immune(dmg_type.physical):
                    _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " but it had no effect.",0]
                else:
                    if target.is_resist(_d) or target.is_resist(dmg_type.physical):
                        _v = 0.5
                    elif target.is_vulnerable(_d) or target.is_vulnerable(dmg_type.physical):
                        _v = 2
                    else:
                        _v = 1

                    if _p:
                        _dmg = calculateDamage(10,user.survival + user.get_survival_attack(),target.combat + math.floor(target.get_combat_defense()/2),_type = _v)
                    else:
                        _dmg = calculateDamage(10,user.survival + user.get_survival_attack(),target.combat + target.get_combat_defense(),_type = _v)

                    if _dmg > 0:
                        target.addHP(_dmg * -1)
                    else:
                        _dmg = 1
                        target.addHP(-1)

                    _wea = "fists"
                    if user.hands['Right'] != None:
                        _wea = user.hands['Right'].name
                    _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " with their " + str(_wea) + " dealing " + str(_dmg) + " damage.",_dmg]
            else:
                _ret = [str(user.profile["Name"]) + " missed " + str(target.profile['Name']) + " dealing no damage.",0]

            return _ret

    def flurry(user,target,acc):
            # Check to hit
            _i = 0
            _hit = 0
            while _i < 5:
                if renpy.random.randint(1,100) <= acc - (_hit * 5):
                    _hit += 1
                else:
                    _hit = False
                _i += 1

            if _hit:
                _p = False
                if user.hands['Right'] != None:
                    _d = user.hands['Right'].d_type
                    if user.hands['Right'].pierce:
                        _p = True
                else:
                    _d = dmg_type.weapon

                # Check for damage immunity
                if target.is_immune(_d) or target.is_immune(dmg_type.physical):
                    _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " but it had no effect.",0]
                else:
                    if target.is_resist(_d) or target.is_resist(dmg_type.physical):
                        _v = 0.5
                    elif target.is_vulnerable(_d) or target.is_vulnerable(dmg_type.physical):
                        _v = 2
                    else:
                        _v = 1

                    if _p:
                        _dmg = calculateDamage(10,user.survival + user.get_survival_attack(),target.combat + math.floor(target.get_combat_defense()/2),_type = _v)
                    else:
                        _dmg = calculateDamage(10,user.survival + user.get_survival_attack(),target.combat + target.get_combat_defense(),_type = _v)

                    if _dmg > 0:
                        target.addHP(_dmg * -1)
                    else:
                        _dmg = 1
                        target.addHP(-1)

                    _wea = "fists"
                    if user.hands['Right'] != None:
                        _wea = user.hands['Right'].name
                    _ret = [str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " with their " + str(_wea) + " dealing " + str(_dmg) + " damage.",_dmg]
            else:
                _ret = [str(user.profile["Name"]) + " missed " + str(target.profile['Name']) + " dealing no damage.",0]

            return _ret

    def siren_song(user,target,acc):
        if renpy.random.randint(1,100) <= acc:
            _hit = True
        else:
            _hit = False

        if _hit:
            if target.buff["Charmed"][0]:
                _ret = user.profile["Name"] + " sang beautifully but " + target.profile["Name"] + " was already charmed."
            else:
                target.addBuff("Charmed",1+renpy.random.randint(1,4),False)
                _ret = user.profile["Name"] + " sang a hauntingly beautiful song placing " + target.profile["Name"] + " under their spell. " + target.profile["Name"] +  " is charmed."
        else:
            _ret = user.profile["Name"] + " sang beautifully but fell on deaf ears."

        return _ret

    # Power Word Skills used for narrative purposes
    def pw_kill(user,target,acc):
        target.addHP(target.max_hp * -2)
        _ret = [str(user.profile["Name"]) + " completely overwhelms " + str(target.profile['Name']) + " with vicious assault.",99]

        return _ret
