init python:
    class Location:
        def __init__(self,img,bg_day,bg_night,x,y,name,_scene,scav,explore,encounter,hostility,discovered):
            # Image is the map icon used
            # bg is the background image to use while in this location
            # Name is a string containing the location name
            # scene is a string containing the default scene label for this location
            # Scav is a list of lists containing potential encounters and the chance of that encounter that can be discovered while scavanging
            # Explore is a list of potential lists containing encounters found while exploring as well as a list of potential connections that can be discovered, each with a weight associated with them
                ## Each Scavenge or Explore is made of a list (Encounter_scene, Encounter_chance, Weather, Season, Hour_begin, Hour_end)
            # Encounter contains a list of hostile encounters that can be encountered
                # Each encounter contains the Mob,
            # Connections is a list of tuples containing other locations that directly connect to this location and the time required to travel
                ## Connections (location,hours,minutes)
            # Discovered is a boolean that determines if the location has been discovered or not
            self.img = img
            self.bg_day = bg_day
            self.bg_night = bg_night
            self.x = x
            self.y = y
            self.name = name
            self._scene = _scene
            self.scavenge = scav
            self.explore = explore
            self.encounter = encounter
            self.hostility = hostility
            self.discovered = discovered

        def trigger_scav(self,enc):
            # Finds the scavenge encounter and triggers it
            func = self.scavenge[enc][0]
            return func()

        def trigger_explore(self,enc):
            # Finds the scavenge encounter and triggers it
            func = self.explore[enc][0]
            return func()

        def ev_scavenge(self):
            # Finds and returns a random scavenge event based on the chance of encounter
            _t = 0
            _list = []
            for i in self.scavenge:
                _o = 0
                while _o < i[1]:
                    _o += 1
                    _t += 1
                    _list.append(i[0])

            func = self._list[renpy.random.randint(1,_t)]

            return func()

        def ev_explore(self):
            # Finds and returns a random scavenge event based on the chance of encounter
            _t = 0
            _list = []
            for i in self.explore:
                _o = 0
                while _o < i[1]:
                    _o += 1
                    _t += 1
                    _list.append(i[0])

            func = self._list[renpy.random.randint(1,_t)]

            return func()

        def ev_encounter(self):
            # Finds and returns a random scavenge event based on the chance of encounter
            _t = 0
            _list = []
            for i in self.encounter:
                _o = 0
                while _o < i[1]:
                    _o += 1
                    _t += 1
                    _list.append(i[0])

            func = self._list[renpy.random.randint(1,_t)]

            return func()

        def is_connected(self,target):
            _ret = False
            for i in roads:
                if i.discovered and (i.locale_1 == self or i.locale_2 == self):
                    if i.locale_1 == target or i.locale_2 == target:
                        _ret = True
            return _ret

    class Path:
        def __init__(self,locale_1,locale_2,distance,tt_minutes,tt_var,hostility,discovered):
            # locale_01 is the first Location
            # locale_02 is the second Location
            self.locale_1 = locale_1
            self.locale_2 = locale_2
            # Distance is the distance of the path in kilometers
            self.distance = distance
            # tt_hours is the hours of travel time
            self.tt_minutes = tt_minutes
            # tt_var is the variable number of minutes travel can take. tt_var is a positive integer added to the number of minutes taken
            self.tt_var = tt_var
            # hostility is the chance of hostile encounters while traveling this path
            self.hostility = hostility
            self.discovered = discovered

    def travel(_start,_destination):
        _path = None
        for _r in roads:
            if (_r.locale_1 == _start or _r.locale_2 == _start) and (_r.locale_1 == _destination or _r.locale_2 == _destination):
                _path = _r

        store.map_point = _destination
        store.selected_locale = None

        # Check for encounters
        # Update time
        _t = renpy.random.randint(_path.tt_minutes - _path.tt_var,_path.tt_minutes + _path.tt_var)
        store.add_time(0,_t)

        renpy.jump(map_point._scene)
        # Reset Variables



# self,img,bg_day,bg_night,x,y,name,_scene,scav,explore,encounter,hostility,discovered
define south_forest_01 = Location("gui/button/map_locale_generic_","bg forest_day","bg forest_night",978,544,"Southern Forest 01","scene_forest.south_01",
# (Scavenge_scene, Scavenge_chance, Weather, Season, Hour_begin, Hour_end)
[["scav_forest.stick",1,"any","any",0,24],["scav_forest.big_stick",1,"any","any",0,24],["scav_forest.flowers",3,"any","any",0,24],["scav_forest.scuffle",1,"any","any",0,24],["scav_forest.berries",2,"any","any",0,24]],
# (Explore_scene, Explore_chance, Weather, Season, Hour_begin, Hour_end)
[["scene_dp.forest_path_03",1,"any","any",0,24]],
# (Encounter_scene, Encounter_chance, Weather, Season, Hour_begin, Hour_end)
[["battle_forest.goblin_basic",2,"any","any",0,24],["battle_forest.slime_basic",2,"any","any",0,24],["battle_forest.harpy_basic",1,"any","any",8,20]],
8,True)
define south_forest_02 = Location("gui/button/map_locale_generic_","bg forest_day","bg forest_night",924,532,"Southern Forest 02","scene_forest.south_02",
[["scav_forest.big_stick",1,"any","any",0,24],["scav_forest.flowers",3,"any","any",0,24],["scav_forest.scuffle",1,"any","any",0,24],["scav_forest.berries",2,"any","any",0,24],["scav_forest.old_camp",1,"any","any",0,24]],
[],
[["battle_forest.goblin_basic",5,"any","any",0,24],["battle_forest.slime_basic",1,"any","any",0,24],["battle_forest.harpy_basic",1,"any","any",8,20]],
6,True)
define south_forest_03 = Location("gui/button/map_locale_generic_","bg forest_day","bg forest_night",952,482,"Southern Forest 03","scene_forest.south_03",
[["scav_forest.flowers",3,"any","any",0,24],["scav_forest.scuffle",1,"any","any",0,24],["scav_forest.berries",3,"any","any",0,24],["scav_forest.old_camp",1,"any","any",0,24]],
[["scene_dp.forest_path_04",1,"any","any",0,24],["scene_dp.forest_path_03",1,"any","any",0,24],["scene_dp.goblin_outpost_to_forest",1,"any","any",0,24]],
[["battle_forest.goblin_basic",5,"any","any",0,24],["battle_forest.slime_basic",1,"any","any",0,24],["battle_forest.harpy_basic",1,"any","any",8,20]],
6,False)
define south_coast_01 = Location("gui/button/map_locale_generic_","bg basic","bg basic",844,498,"Southern Coast 01","scene_coast.south_01",
[["scav_beach.shell",1,"any","any",0,24]],
[["scene_dp.last_drop_path_02",1,"any","any",0,24],["scene_dp.beach_path_01",1,"any","any",0,24]],
[["battle_beach.siren_basic",5,"any","any",0,24]],
6,False)
define south_coast_02 = Location("gui/button/map_locale_generic_","bg basic","bg basic",774,508,"Southern Coast 02","scene_coast.south_02",
[["scav_beach.shell",1,"any","any",0,24]],
[["scene_dp.beach_path_01",1,"any","any",0,24],["scene_dp.vergesseneburg_to_beach",1,"any","any",0,24]],
[["battle_beach.siren_basic",5,"any","any",0,24]],
6,False)
define goblin_outpost_01 = Location("gui/button/map_locale_ruined_inn_","bg basic","bg basic",962,442,"Goblin Outpost","scene_coast.south_03",
[["scav_forest.stick",1,"any","any",0,24]],
[["scene_dp.goblin_outpost_to_forest",1,"any","any",0,24]],
[["battle_forest.goblin_basic",5,"any","any",0,24]],
6,False)
define the_last_drop = Location("gui/button/map_locale_ruined_inn_","bg forest_day","bg forest_night",892,484,"The Last Drop","scene_last_drop.exterior",
[["scav_forest.stick",1,"any","any",0,24],["scav_forest.flowers",3,"any","any",0,24],["scav_forest.scuffle",1,"any","any",0,24],["scav_forest.berries",1,"any","any",0,24]],
[["scene_dp.last_drop_path_02",1,"any","any",0,24],["scene_dp.forest_path_04",1,"any","any",0,24]],
[["battle_forest.goblin_basic",5,"any","any",0,24]],
4,True)
define fort_chastity = Location("gui/button/map_locale_port_","bg basic","bg basic",986,610,"Fort Chastity","scene_introduction_01",
[],
[],
[],
10,True)
define vergesseneburg = Location("gui/button/map_locale_town_","bg basic","bg basic",712,482,"Vergesseneburg","scene_vergesseneburg.exterior",
[],
[["scene_dp.vergesseneburg_to_beach",1,"any","any",0,24]],
[],
4,False)

# Location 1, Location 2, Distance km, Minutes, Time Variation, Hostility, Discovered
define forest_to_fort_chastity = Path(fort_chastity,south_forest_01,0.25,5,0,0,False)
define forest_path_01 = Path(south_forest_01,south_forest_02,1,30,5,10,True)
# define forest_path_02 = Path(south_forest_02,south_forest_03,0.5,4000,2,10,False)
define forest_path_03 = Path(south_forest_01,south_forest_03,0.5,15,2,10,False)
define forest_path_04 = Path(south_forest_03,the_last_drop,0.5,15,2,10,False)
define forest_path_05 = Path(goblin_outpost_01,south_forest_03,0.5,15,2,10,False)
define last_drop_path_01 = Path(the_last_drop,south_forest_02,0.5,20,5,0,True)
define last_drop_path_02 = Path(the_last_drop,south_coast_01,0.25,10,2,10,False)
define beach_path_01 = Path(south_coast_01,south_coast_02,0.25,10,2,10,False)
define path_vergesseneburg_to_beach = Path(south_coast_02,vergesseneburg,0.25,10,2,10,False)
