﻿# The script of the game goes in this file.

# Declare characters used by this game. The color argument colorizes the
# name of the character.

# Define is a constant
# Default sets on new game or if the variable isn't already defined

# define e = Character("Eileen")

init offset = 1

define _history = False

hide quick_menu()

# Calender keeps track of the current date
# Stored as Year, Month, Day, Hour, Minute
default calendar = [0001,01,1,18,00]
# Weather contains a string and is set at the dawn of each day
# "clear" "rain" "downpour" "thunderstorm" "overcast" "snowing" "mist" "hot"
default weather = "clear"

# Defense Dice
define whiteDice = d6("gui/dice/white_dice.png","Whi",0,False,0,False,0,False,1,False,1,False,1,False)
define grayDice = d6("gui/dice/gray_dice.png","Gra",0,False,1,False,1,False,1,False,2,False,2,False)
define blackDice = d6("gui/dice/black_dice.png","Bla",1,False,1,False,2,False,2,False,3,False,4,False)
# Attack Dice
define greenDice = d6("gui/dice/green_dice.png","Gre",1,False,1,False,1,False,1,True,2,False,2,False)
define blueDice = d6("gui/dice/blue_dice.png","Blu",1,False,2,True,2,False,2,False,3,False,3,False)
define purpleDice = d6("gui/dice/purple_dice.png","Pur",1,False,1,True,1,True,2,False,2,False,2,True)
define redDice = d6("gui/dice/red_dice.png","Pur",1,True,1,True,2,True,2,True,2,False,2,False)
define goldDice = d6("gui/dice/gold_dice.png","Gol",2,False,2,False,2,False,3,False,3,False,4,False)
# Standard Dice
define standd6 = d6(None,"d6",1,False,2,False,3,False,4,False,5,False,6,False)

default inventory = []
default sellInventory = []
default buyInventory = []
default accessInventory = False
default accessMap = False
# Enemy inventory holds 5 slots for items equipped to the enemy
# 0 Acc, 1 Chest, 2 Legs, 3 Right Hand, 4 Left Hand
default enemyInventory = []
default selected_item = None
default remove_item = 0
default selected_amount = 1
default pc = Mob(25,25,4,10,10,10,10,"Player","Human","Male",69,170)
default pc_level = 1
define player = Character("[pc.profile[Name]]", dynamic = True)
default enemy = None

default last_scene = None
default last_checkpoint = "scene_last_drop.meet_squeeb_first_death"

# General Items
# id_key 0xxxxx
# Item(self,id_key,img,val,name,desc,amount,1,99)
default item_trash = InventoryItem(000001,"gui/items/default.jpg",1,"Trash","Description",16)
default item_vial = InventoryItem(000002,"gui/items/default.jpg",1,"Vial","Description",16)
default item_gold = InventoryItem(000003,"gui/items/default.jpg",0,"Gold","Gold coins from the elven empire, they have little value on Alcatraz except to unique individuals",64)
# Armors and Equipment
# id_key 1xxxxx
# Armor(self,id_key,img,val,name,desc,locked,amount,slot,combat_att,survival_att,acumen_att,glamour_att,combat_def,survival_def,acumen_def,glamour_def,boon,tier)
default item_headband = Armor(100001,"gui/items/default.jpg",0,"Headband","A tattered old headband",False,"Head",0,0,0,0,0,1,0,0,[],0)
default item_torn_shirt = Armor(100002,"gui/items/tattered_shirt.jpg",0,"Torn Shirt","A heavily tattered shirt that barely holds together.",False,"Chest",0,0,0,0,1,1,0,0,[],0)
default item_torn_shorts = Armor(100003,"gui/items/tattered_pants.jpg",0,"Torn Shorts","A pair of ripped and tattered pants.",False,"Legs",0,0,0,0,0,1,0,1,[],0)
default item_magic_collar = Armor(100004,"gui/items/magic_collar.jpg",0,"Chastity Collar","A heavy metal collar the bites into your neck. You can't seem to remove it.",True,"Acc",0,0,0,0,0,0,0,4,["Curse"],0)
default item_scrap_shirt = Armor(100005,"gui/items/tattered_shirt.jpg",0,"Scrap Shirt","A simple shirt made of scrap cloth and leather.",False,"Chest",0,0,0,0,2,0,0,0,[],0)
default item_scrap_pants = Armor(100006,"gui/items/tattered_pants.jpg",0,"Scrap Pants","A pair of pants made of scrap cloth stitched together.",False,"Legs",0,0,0,0,0,0,0,2,[],0)
# Weapons and Shields
# id_key 2xxxxx
# Weapon(self,id_key,img,val,name,desc,locked,slot,combat_att,survival_att,acumen_att,glamour_att,combat_def,survival_def,acumen_def,glamour_def,type,tier,heavy,pierce,reach)
default item_stick = Weapon(200001,"gui/items/stick.jpg",0,"Stick","A small stick that should function as a club in a pinch.",False,'Right',1,0,0,0,0,0,0,0,Weapon_Type.MISC,0)
default item_plank_shield = Weapon(200002,"gui/items/default.jpg",0,"Plank Shield","A few scrap boards tied together with rope and simple nails.",False,'Left',0,0,0,0,1,1,0,0,Weapon_Type.SHIELD,0)
default item_big_stick = Weapon(200003,"gui/items/big_stick.jpg",0,"Big Stick","A large branch that should function as a heavy club in a pinch.",False,'Both',2,0,0,0,0,0,0,0,Weapon_Type.STAFF,0,heavy = True)
default item_basic_spear = Weapon(200004,"gui/items/big_stick.jpg",0,"Primitive Spear","A simple spear made with a sharp stone tip.",False,'Right',0,2,0,0,0,0,0,0,Weapon_Type.STAFF,0,pierce = True)
default item_basic_dagger = Weapon(200005,"gui/items/big_stick.jpg",0,"Simple Dagger","A well worn dagger with signs of use but the blade is still sharp.",False,'Right',1,1,0,0,0,0,0,0,Weapon_Type.STAFF,0,pierce = True)
# Ingredients
# id_key 3xxxxx
# Ingredient(self,id_key,img,val,name,desc,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,buff_2)
default item_wildberry = Ingredient(300001,"gui/items/default.jpg",0,"Wildberry","Description",16,None,None,None,None,None,None)
default item_redroot = Ingredient(300002,"gui/items/default.jpg",0,"Red Root","Description",16,None,[whiteDice],None,None,None,None)
default item_honey = Ingredient(300003,"gui/items/default.jpg",2,"Honey","Description",16,[whiteDice,whiteDice],None,None,None,None,None)
default item_black_powder = Ingredient(300004,"gui/items/default.jpg",1,"Black Powder","A small brown pouch containing a blackish powder that smells strongly.",16,None,None,None,None,None,None)
default item_green_ivy = Ingredient(300005,"gui/items/default.jpg",2,"Green Ivy","A cluster of strong smelling leaves that could be brewed into a tea or potion.",16,None,None,None,None,None,None)
default item_shell = Ingredient(300006,"gui/items/default.jpg",1,"Sea Shell","The small chipped shell of an aquatic creature.",16,None,None,None,None,None,None)
default item_scale = Ingredient(300007,"gui/items/default.jpg",2,"Scale","A few scales from some reptilian or aquatic creature.",16,None,None,None,None,None,None)
default item_red_flower = Ingredient(300008,"gui/items/default.jpg",2,"Poppy","A small red flower.",16,None,None,None,None,None,None)
default item_rock_salt = Ingredient(300009,"gui/items/default.jpg",1,"Rock Salt","A small pouch of salt chunks and particles.",16,None,None,None,None,None,None)
# Consumables
# id_key 4xxxxx
# Consumable(self,id_key,img,val,name,desc,amount,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,tier_1,dur_1,buff_2,tier_2,dur_2,buff_3,tier_3,dur_3)
default item_apple = Consumable(400001,"gui/items/default.jpg",0,"Apple","Description",16,[whiteDice],None,None,None,None,1,0,None,1,0,None,1,0)
default item_ale = Consumable(400002,"gui/items/default.jpg",0,"Ale","Description",16,None,[whiteDice],None,None,None,1,0,None,1,0,None,1,0)
default item_venison = Consumable(400003,"gui/items/default.jpg",0,"Raw Venison","Raw deer meat, edible in a pinch but not recommended",16,None,[grayDice],None,None,None,1,0,None,1,0,None,1,0)
default item_cooked_venison = Consumable(400004,"gui/items/default.jpg",0,"Grilled Venison","Deer meat grilled over a fire.",16,None,[blackDice,blackDice,blackDice],None,None,None,1,0,None,1,0,None,1,0)

# Define Skills (self,img,name,description,funct,stam,type,accuracy):
define skill_struggle = Skill("gui/button/strike","Struggle",
"Unable to act",struggle,0,"Physical",95)
define skill_rest = Skill("gui/button/strike",
"Rest","Resting recovers 1 or 2 stamina.",rest,0,"Other",0)
define skill_strike = Skill("gui/button/strike","Strike",
"You make a straight strike at your opponent with a weapon or your fists.",strike,0,"Physical",95)
define skill_flirt = Skill("gui/button/flirt","Flirt",
"Attempt to pacify the enemy with your charm or whatever items you're holding.",flirt,0,"Lust",95)
define skill_pierce = Skill("gui/button/thrust","Pierce",
"You make a swift strike forward, this attack bypasses some of the enemy's armor when wielding a piercing weapon.",pierce,1,"Physical",95)
define skill_siren_song = Skill("gui/button/rose","Siren Song",
"You sing a beautiful and baffling melody that charms the enemy.",siren_song,1,"Lust",85)

# power word skills are used for narrative moments only and should not be accessable to the player or regular creatures
define skill_pw_kill = Skill("gui/button/strike","Power Word Kill",
"Instantly defeats the target",pw_kill,0,"Physical")


# Hostile(self, sprite, hp, libido, morale, stamina, combat, survival, acumen, glamour, name, race, gender, hei, wei,sk_1,sk_2,sk_3,sk_4,sk_5,sk_6,condition)
##  GOBLINS
default mob_goblin_male_01 = Hostile("Male Goblin Collared",20,30,10,2,7,12,6,6,"Goblin","Goblin","Male",36,40,store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
default mob_goblin_female_01 = Hostile("Female Goblin Collared",20,30,10,2,7,12,6,6,"Goblin","Goblin","Female",36,40,store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
default mob_goblin_male_02 = Hostile("Male Goblin",20,30,10,2,7,12,6,6,"Goblin","Goblin","Male",36,40,store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
default mob_goblin_female_02 = Hostile("Female Goblin",20,30,10,2,7,12,6,6,"Goblin","Goblin","Female",36,40,store.skill_strike,store.skill_flirt,None,None,None,None,"","goblin_battle")
## SIREN
default mob_siren_male_01 = Hostile("Male Siren",30,45,20,2,10,7,8,12,"Siren","Siren","Male",63,162,store.skill_strike,store.skill_flirt,store.skill_siren_song,None,None,None,"","siren_battle")
default mob_siren_female_01 = Hostile("Female Siren",30,45,20,2,10,7,8,12,"Siren","Siren","Female",62,155,store.skill_strike,store.skill_flirt,store.skill_siren_song,None,None,None,"","siren_battle")
##  SLIME
default mob_slime_male_01 = Hostile("Male Slime",35,25,10,2,4,5,4,4,"Blue Slime","Slime","Male",60,190,store.skill_strike,store.skill_flirt,None,None,None,None,"","slime_battle")
default mob_slime_female_01 = Hostile("Female Slime",35,25,10,2,4,5,4,4,"Red Slime","Slime","Female",60,190,store.skill_strike,store.skill_flirt,None,None,None,None,"","slime_battle")
##  HARPY
default mob_harpy_male_01 = Hostile("Harpy",50,40,10,2,3,5,3,4,"Harpy","Harpy","Male",62,130,store.skill_strike,store.skill_flirt,None,None,None,None,"","harpy_battle")
default mob_harpy_female_01 = Hostile("Harpy",50,40,10,2,3,5,3,4,"Harpy","Harpy","Female",66,135,store.skill_strike,store.skill_flirt,None,None,None,None,"","harpy_battle")
## WOLVES
default mob_wolf_pack_01 =  Hostile("Wolf Pack",60,50,10,2,6,6,2,2,"Wolves","Wolf","--",36,40,store.skill_strike,None,None,None,None,None,"","wolves_battle")

define nar = Character("")
define unknown_person = Character("?")
define squeeb = Character("Squeeb")
define fenna = Character("Fenna")

# Combat Variables
default player_turn = True
default turn_start = True
default player_action_menu = True # False if inventory is active
default selected_skill = None
default hit = 0
default crit = 0
default miss = 0
default spr = []
default combat_history = []
default turn_count = 1
default flee_succeed = False
default mob_flee = False
default mob_submit = False

image enemy_healthy_chaste = "goblin nude.png"
image enemy_healthy_lusty = "goblin nude.png"
image enemy_hurt_chaste = "goblin nude.png"
image enemy_hurt_lusty = "goblin nude.png"

default battle_end = ""

# Define Backgrounds
image bg basic = "gui/rooms/bg room.jpg"
image bg worldmap = "gui/rooms/worldmap.jpg"
image bg forest_day = "gui/rooms/forest day.jpg"
image bg forest_night = "gui/rooms/forest night.jpg"

# Define Location
default map_point = fort_chastity
default selected_locale = None

default locations = []
default roads = []

default set_ui = "map"

# NPC Images
image squeeb collared_idle = "Squeeb idle.png"
image fenna collared_idle = "Fenna idle.png"

# NPC POINTS
default relationship_squeeb = {
"met_squeeb" : False,
"gave_name" : False,
"thanked_for_saving" : False
}
default relationship_fenna = {
"met_fenna" : False
}

# FACTION POINTS
default faction_score = {
"goblins" : 0,
"sirens" : 0,
"orcs" : 0,
"slimes" : 0,
"harpies" : 0,
"wolves" : 0
}

# The game starts here.

label start:
    $ _game_menu_screen = None
    # SET LOCATIONS LIST
    python:
        # Forest Locations
        locations.append(south_forest_01)
        locations.append(south_forest_02)
        locations.append(south_forest_03)
        # Coastal Locations
        locations.append(south_coast_01)
        locations.append(south_coast_02)
        # Unique Locations
        locations.append(fort_chastity)
        locations.append(the_last_drop)
        locations.append(vergesseneburg)
        locations.append(goblin_outpost_01)
        # for i in locations:
        #     i.discovered = True
    # SET ROADS LIST
    python:
        roads.append(forest_to_fort_chastity)
        roads.append(forest_path_01)
        # roads.append(forest_path_02)
        roads.append(forest_path_03)
        roads.append(forest_path_04)
        roads.append(forest_path_05)
        roads.append(last_drop_path_01)
        roads.append(last_drop_path_02)
        roads.append(beach_path_01)
        #roads.append(beach_path_02)
        #roads.append(beach_path_03)
        roads.append(path_vergesseneburg_to_beach)
        # for i in roads:
        #     i.discovered = True
    python:
        # Mob.update_all(pc)

        # addToInventory(item_stick,1)
        addToInventory(item_torn_shirt,1)
        addToInventory(item_torn_shorts,1)
        addToInventory(item_magic_collar,1)

        inventory[len(inventory)-3][0].equip(pc)
        inventory[len(inventory)-2][0].equip(pc)
        inventory[len(inventory)-1][0].equip(pc)

        # for _i in range(6):
        #     addToInventory(item_trash,16)

        sortInventory(1)

    # Show a background. This uses a placeholder by default, but you can
    # add a file (named either "bg room.png" or "bg room.jpg") to the
    # images directory to show it.

    scene bg basic
    # show screen bookend()

    jump scene_introduction_01 # scene_goblin_outpost.exterior # scene_forest.south_02 # scene_level_up # scene_map

label scene_introduction_01:
    show bg basic
    "The darkness of your cell was pierced by a thin shaft of light that managed to crack through the grim covered porthole. The sounds of shouting above deck was muffled by the sounds of crashing waves against the ship; which rocked heavily from side to side against the tide."

    "It'd been almost three years since the end of the Monster Wars. The Elven Legion had succeeded in conquering most of the continent and now it was just a matter of cleaning up the few futile rebellions that cropped up. The heavy metal collar around your neck was a harsh reminder of what side you had been on."

    "Some half dozen other monsters sat chained in dank cells similar to your own, all bound with a heavy metal collar. You can hear one of your fellow prisoners, a humanoid of some kind, covered in fur, with a rat like face and tail. He's scratching desperately at the collar, causing horrible sounds to echo throughout the hull."

    $ add_time(0,15)

    "Orc" "\"You're wasting your time and making my ears bleed with that racket.\" A dark skinned orc at the other side of the ship barked. \"Damned things are enchanted, it ain't coming off without your head coming with it.\""

    "Wererat" "\"If you want your balls to shrivel up that's your business but I'm not going quietly.\""

    "Wood creaks as a guard steps out from the shadows and into the low light. Silver and blue armor contrasting with the grimy hull of the ship."

    "Guard" "\"If you'd like I could hasten the process for you.\" The guard snarls while gripping the hilt of his blade. Although his helmet covered his face you could sense the sick smile beneath."

    "Luckily before the rat person could respond the ship jerked suddenly and the ringing of a bell echoed through the ship. Stomping of feet above deck was swiftly followed by a ray of light filling the hull as the doors to the deck were pulled open."

    "Guard" "\" Seems we've arrived. Welcome to your new home beasts.\""

    "A dozen other guards all dressed in similar silver and blue regalia descend into the ship pulling open the cages you'd been kept in. One by one you're all dragged up to the deck of the ship, sharp blades pressing against your back urge you forward. Descending the plank to a long wooden dock which winds up the rocky shore to a walled port town."

    $ add_time(0,5)

    "Armed soldiers of the Elven Legion patrol constantly along the walled settlement, tall towers with archers stare down at you like prison wardens. Though the noon day sun bares down on you, the port feels oppressive and dark."

    $ add_time(0,5)

    "Paladin" "\"Move it!\" A paladin of the legion jabs you roughly with the butt of his spear, forcing you onward."

    "You're quickly ushered towards a large set of wooden gates which open with a low groan. Another rough jab forces you beyond the walls."

    "Paladin" "\"Welcome to Alcatraz.\""

    $ map_point = south_forest_01

    show bg forest_day with dissolve

    "Those were the last words spoken to you before the gate was shut, locking you outside. A dense forest sprawls out ahead of you, near impassible except for a narrow crude path beaten in by the many other monsters banished here before you. The ground is damp from a morning rain, and you see yourself reflected in a small puddle."

    jump player_creation

label player_creation:
    menu:
        "You're a..."
        "Male":
            $ pc.profile['Gender'] = "Male"
        "Female":
            $ pc.profile['Gender'] = "Female"

    menu:
        "You're a [pc.profile[Gender]]..."
        "Goblin":
            $ pc.profile['Race'] = "Goblin"
        "Orc":
            $ pc.profile['Race'] = "Orc"
        "Lizardfolk":
            $ pc.profile['Race'] = "Lizardfolk"
        "Kobold":
            $ pc.profile['Race'] = "Kobold"
        "Minotaur":
            $ pc.profile['Race'] = "Minotaur"

    python:
        pc.profile['Name'] = renpy.input("You're a [pc.profile[Gender]] [pc.profile[Race]], named...")
        pc.profile['Name'] = pc.profile['Name'].strip()

        if not pc.profile['Name']:
            pc.profile['Name'] = "Player"

    menu:
        "You're a [pc.profile[Gender]] [pc.profile[Race]], named [pc.profile[Name]]. Does that sound right?"
        "Yes":
            jump scene_introduction_02
        "No":
            jump player_creation

label scene_introduction_02:
    "You turn away from the small puddle, tugging at the collar that dug into your neck. Here wasn' the place to remove the collar and now wasn't the time for regrets. You needed to survive, find some shelter and get somewhere safe for the night."

    $ add_time(0,5)

    menu:
        "You decide it'd be best to search the area for something to defend yourself. Even just a stick would be better then nothing."

        "Scavenge":
            # $ accessInventory = True
            jump scene_introduction_03

label scene_introduction_03:
    "You dig through the nearby brush, pushing through the dense shrubs and clinging vines, you manage to find a short but sturdy branch. Pulling it free from some a tangle of other plants you give it a swift practice swing. It's not much, but it's probably better then your fists."
    $ addToInventory(item_stick,1)
    "You can equip the branch in the inventory menu."

    $ add_time(0,5)

    show screen menubar(False,True,False,False)

    pause

label scene_introduction_04:
    show bg forest_day with dissolve
    $ accessInventory = True
    $ last_scene = "scene_introduction_04"

    if pc.hands['Right'] != None:
        $ _t = "With a weapon in hand you feel a bit more confident venturing further into the forest, but without a map or any idea where to go you'll just have to explore."
    else:
        $ _t = "Deciding to take your chances with your fists rather then a weapon may not have been wise but you decide to risk it anyways."

    menu:
        "[_t]"
        "Explore":
            "Without any other direction to go you press forward into the forest, but before you can find anything a green shape leaps at you from the woods."
            $ add_time(0,5)
            $ last_scene = "scene_introduction_05"
            if renpy.random.randint(0,1) == 1:
                $ _enemy = Hostile("Female Goblin Collared",10,4,10,2,2,2,2,2,"Goblin","Goblin","Female",36,40,store.skill_strike,None,None,None,None,None,"Weak","tutorial_battle")
            else:
                $ _enemy = Hostile("Male Goblin Collared",10,4,10,2,2,2,2,2,"Goblin","Goblin","Male",36,40,store.skill_strike,None,None,None,None,None,"Weak","tutorial_battle")
            call scene_battle_setup pass (_en = _enemy) from _call_scene_battle_setup

label scene_introduction_05:
    $ last_scene = "scene_introduction_05"
    menu:
        "The forest is filled with dark trees that curl across the sky in a thick knotted canopy."
        "Explore":
            $ south_forest_02.discovered = True
            $ map_point = south_forest_02
            "You discover a small path that leads through some of the underbrush. It's a tough walk but you find yourself deeper in the forest surrounded by dense trees."
            jump scene_introduction_06

label scene_introduction_06:
    $ last_scene = "scene_introduction_06"
    menu:
        "The forest is filled with dark trees that curl across the sky in a thick knotted canopy."
        "Explore":
            jump battle_forest.nightstalker

label scene_level_up:
    hide screen clock
    hide screen menubar

    # show bg basic

    call screen level_up_screen(inventory) with dissolve

    if _return == True:
        menu:
            "Combat":
                python:
                    pc.hp += 10
                    pc.max_hp += 10
                    pc.libido += 5
                    pc.max_libido += 5
                    pc.combat += 5
                    pc.survival += 1
                    pc.acumen += 1
                    pc.glamour += 1
                    pc.level += 1
            "Survival":
                python:
                    pc.hp += 10
                    pc.max_hp += 10
                    pc.libido += 5
                    pc.max_libido += 5
                    pc.combat += 1
                    pc.survival += 5
                    pc.acumen += 1
                    pc.glamour += 1
                    pc.level += 1
            "Acumen":
                python:
                    pc.hp += 5
                    pc.max_hp += 5
                    pc.libido += 10
                    pc.max_libido += 10
                    pc.combat += 1
                    pc.survival += 1
                    pc.acumen += 5
                    pc.glamour += 1
                    pc.level += 1
            "Glamour":
                python:
                    pc.hp += 5
                    pc.max_hp += 5
                    pc.libido += 10
                    pc.max_libido += 10
                    pc.combat += 1
                    pc.survival += 1
                    pc.acumen += 1
                    pc.glamour += 5
                    pc.level += 1

        jump scene_vergesseneburg.level_up
    else:
        jump scene_vergesseneburg.level_up

# Battle set up
# Set default variables and reset anything that needs to be reset at the beginning of a battle
label scene_battle_setup(_en = None,_eq_acc = None,_eq_torso = None,_eq_legs = None,_eq_left = None,_eq_right = None,_con = "",_ambush = False,_pc_ambush = False):
    show screen clock
    hide screen menubar

    if isinstance(_en,Hostile):
        python:
            # player_turn = True
            turn_start = True
            hit = 0
            crit = 0
            miss = 0
            selected_skill = None
            flee_succeed = False
            mob_flee = False
            mob_submit = False
            combat_history = []

            # SET ENEMY
            enemy = _en

            # EQUIP ENEMY ARMORS
            if isinstance(_eq_acc,Armor):
                enemy.equip_armor(_eq_acc,_eq_acc.slot)
            else:
                enemy.equipment["Acc"] = None

            if isinstance(_eq_torso,Armor):
                enemy.equip_armor(_eq_torso,_eq_torso.slot)
            else:
                enemy.equipment["Chest"] = None
            if isinstance(_eq_legs,Armor):
                enemy.equip_armor(_eq_legs,_eq_legs.slot)
            else:
                enemy.equipment["Legs"] = None
            # EQUIP ENEMY WEAPONS
            if isinstance(_eq_left,Weapon):
                enemy.equip_weapon(_eq_left)
            else:
                enemy.hands["Left"] = None
            if isinstance(_eq_right,Weapon):
                enemy.equip_weapon(_eq_right)
            else:
                enemy.hands["Right"] = None

            # enemy.update_all()

            enemy.condition = _con
            enemy.updateBuffs()

            spr = []
            spr += get_sprite_list(enemy.sprite)
            enemy.hp = enemy.max_hp
            if enemy.condition == "Aroused":
                enemy.libido = int(enemy.max_libido/2)
            else:
                enemy.libido = 0

            turn_count = 1

            # Check if the encounter is an Ambush. If it is the enemy goes first by default. Otherwise test awareness
            if _ambush:
                player_turn = False
                combat_history.append(str(enemy.profile['Name']) + " bursts from the shadows. You have been ambushed.")
            elif _pc_ambush:
                player_turn = True
                combat_history.append("You take advantage of the situation and bursts from the shadows."  + str(enemy.profile['Name']) + " has been ambushed.")
            else:
                # Determine if player or enemy starts first
                # Enemy and Player roll a gray dice per 4 points in Survival
                # Player wins ties
                _pc_s = 0
                for _i in range(int(pc.survival/4)):
                    _pc_s += grayDice.roll()[0]
                _en_s = 0
                for _i in range(int(enemy.survival/4)):
                    _en_s += grayDice.roll()[0]

                player_turn = True
                if _en_s > _pc_s:
                    player_turn = False

                combat_history.append("Player rolled : " + str(_pc_s))
                combat_history.append("Enemy rolled : " + str(_en_s))


        image enemy_healthy_chaste = "[spr[0]]"
        image enemy_hurt_chaste = "[spr[1]]"
        image enemy_healthy_lusty = "[spr[2]]"
        image enemy_hurt_lusty = "[spr[3]]"

    else:
        jump expression map_point._scene

    if 8 < calendar[3] < 20:
        show expression map_point.bg_day with Fade(0.2,0.2,0.5)
    else:
        show expression map_point.bg_night with Fade(0.2,0.2,0.5)

    show screen action_history(combat_history) with None
    show screen action_menu(pc,False) with None
    show screen enemy_status(enemy) with None

    jump scene_battle_loop

label scene_battle_loop:
    while flee_succeed == False and mob_flee == False and mob_submit == False and enemy.hp > 0 and enemy.libido < enemy.max_libido and pc.hp > 0:
        hide enemy_healthy_chaste
        hide enemy_hurt_chaste
        hide enemy_healthy_lusty
        hide enemy_hurt_lusty

        # Show enemy sprites
        if enemy.hp >= enemy.max_hp/2:
            if enemy.libido < enemy.max_libido/2:
                show enemy_healthy_chaste:
                    yalign 0.5
                    xalign 0.5
            else:
                show enemy_healthy_lusty:
                    yalign 0.5
                    xalign 0.5
        else:
            if enemy.libido < enemy.max_libido/2:
                show enemy_hurt_chaste:
                    yalign 0.5
                    xalign 0.5
            else:
                show enemy_hurt_lusty:
                    yalign 0.5
                    xalign 0.5

        $ selected_skill = None

        if player_turn:
            # If turn_start apply buffs and bonuses
            if turn_start:
                $ combat_history.insert(0,pc.turn_begin_update())
                $ turn_start = False
                pause 0.5
            # Player Actions Here
            # While player_action_menu is True player can select from skills
            # If false check for inventory interaction instead
            if player_action_menu:
                call screen action_menu(pc,True)
                show screen action_menu(pc,False)
                $ player_action = _return

                if player_action in range(0,5):
                    $ _tsk = use_skill(pc.skills[selected_skill],pc,enemy)
                    $ combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk[0]))

                    $ player_turn = False
                    $ turn_start = True
                    $ combat_history.insert(0,pc.turn_end_update())

                    pause 0.75
                elif player_action == 6:
                    $ _tsk = rest(pc,enemy,0)
                    $ combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk[0]))

                    $ player_turn = False
                    $ turn_start = True
                    $ combat_history.insert(0,pc.turn_end_update())

                    pause 0.75
                elif player_action == 7:
                    if standd6.roll()[0] + standd6.roll()[0] >= 7:
                        $ flee_succeed = True
                    else:
                        $ combat_history.insert(0,"Turn " + str(turn_count) + " - attempted to flee but failed")

                    $ player_turn = False
                    $ turn_start = True
                    $ combat_history.insert(0,pc.turn_end_update())

                    pause 0.75

            # INVENTORY ACTIONS HERE
            else:
                $ turn_start = True
                $ player_turn = False

        else:
            # Enemy Actions Here
            # Pre Turn Buffs and Debuffs
            if turn_start:
                $ combat_history.insert(0,enemy.turn_begin_update())
                $ turn_start = False
                pause 0.5
            # Determine Enemy Actions
            # First check if enemy flees
            # Set DC based on enemy HP
            # At full health the enemy won't flee
            # At half health there is 1/36 chance of fleeing
            # At quarter health 3/36 chance of fleeing
            # Melancholy or Cowardly trait increase the DC by 2
            if not turn_start:
                # If mob isn't Aggro it has a chance to flee
                if not enemy.buff["Aggro"][0]:
                    $ _dc = 1
                    $ _dc2 = 1
                    if enemy.hp <= enemy.max_hp/2:
                        $ _dc += 1
                    if enemy.hp <= enemy.max_hp/4:
                        $ _dc += 1
                    if enemy.condition == "Melancholy" or enemy.condition == "Cowardly":
                        $ _dc += 2
                        $ _dc2 += 2
                    # Check 2d6 vs DC
                    if standd6.roll()[0] + standd6.roll()[0] <= _dc:
                        # On a fail roll a d6
                        # If the enemy is Melancholy or Cowardly the enemy flees on a 3 or less
                        # Otherwise the enemy flees on a 1
                        if standd6.roll()[0] <= _dc2:
                            # ADD FLEE ATTEMPT LATER
                            $ mob_flee = True

                # If mob isn't Continue it has a chance to submit
                if not enemy.buff["Continue"][0]:
                    $ _dc = 1
                    $ _dc2 = 1
                    if enemy.libido >= enemy.max_libido/2:
                        $ _dc += 1
                    if enemy.libido <= enemy.max_libido/4:
                        $ _dc += 1
                    if enemy.condition == "Submissive":
                        $ _dc += 2
                        $ _dc2 += 2
                    # Check for submission
                    if standd6.roll()[0] + standd6.roll()[0] <= _dc:
                        # On a fail roll a d6
                        # If the enemy is Melancholy or Cowardly the enemy flees on a 3 or less
                        # Otherwise the enemy flees on a 1
                        if standd6.roll()[0] <= _dc2:
                            # ADD FLEE ATTEMPT LATER
                            $ mob_submit = True

                # If mob isn't fleeing or submitting determine their attack action
                if not mob_flee and not mob_submit:
                    python:
                        _list = []
                        _i = 0
                        for _i in range(6):
                            if enemy.skills[_i] != None:
                                if enemy.skills[_i].stam <= enemy.stamina:
                                    _o = 0
                                    for _o in range(enemy.skills[_i].skill_priority(enemy,pc)):
                                        _list.append(enemy.skills[_i])
                        if len(_list) > 0:
                            _tsk = use_skill(_list[renpy.random.randint(0,len(_list)-1)],enemy,pc)
                        else:
                            _tsk = use_skill(skill_struggle,enemy,pc)

                        # Show weighted attack list
                        # for _i in _list:
                        #     combat_history.insert(0,str(_i.name))

                        combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk[0]))


                $ turn_start = True
                $ player_turn = True
                $ combat_history.insert(0,pc.turn_end_update())

        $ turn_count += 1

    pause

    python:
        _e = "martial_victory"
        if flee_succeed:
            _e = "player_flee"
        elif mob_flee:
            _e = "mob_flee"
        elif mob_submit:
            _e = "mob_submit"
        elif pc.hp <= 0:
            if pc.libido > pc.max_libido:
                _e = "lust_defeat"
            else:
                _e = "martial_defeat"
        elif enemy.hp <= 0:
            _e = "martial_victory"
        elif enemy.libido >= enemy.max_libido:
            _e = "lust_victory"

    # DETERMINE ENDING TO JUMP TO
    call scene_battle_end pass (_e) from _call_scene_battle_end # from _call_scene_battle_end

label scene_battle_end(_end = "martial_victory"):
    hide screen enemy_status
    hide screen action_menu
    hide screen action_history
    $ add_time(0,10)

    # if isinstance(enemy,Hostile):
    jump expression enemy.ending + "." + _end
    # else:
    #     jump scene_last

label battle_clean_up:
    hide enemy_healthy_chaste
    hide enemy_healthy_lusty
    hide enemy_hurt_chaste
    hide enemy_hurt_lusty

    if pc.hp <= 0 or pc.libido >= pc.max_libido:
        $ pc.hp = pc.max_hp
        $ pc.libido = 0
        $ _s = str(last_checkpoint)
        jump expression _s
    else:
        jump scene_last

label scene_last:
    # Jumps the player to the last scene
    # Use after battles, inventory access, or map access
    # ""
    $ _s = map_point._scene
    if last_scene == None:
        if 8 < calendar[3] < 20:
            show expression map_point.bg_day with dissolve
        else:
            show expression map_point.bg_night with dissolve
    else:
        $ _s = str(last_scene)
        $ last_scene = None

    # show screen clock()
    # with moveinleft
    # $ accessInventory = True
    # $ accessMap = True
    # show screen menubar(False,accessInventory,accessMap,False)
    # with moveinright

    jump expression _s

label scene_scavenge_begin:
    if 8 < calendar[3] < 20:
        show expression map_point.bg_day# with dissolve
    else:
        show expression map_point.bg_night# with dissolve

    # show screen clock with None
    # hide screen menubar with moveoutright

    # Determine Scavenge Event
    # First check hostility and see if there is a combat encounter
    # If not compile a list of scavenge events and pick one at random based on weight
    # To check for hostility roll 2d6 any roll equal to or less then the locations hostility results in a hostile encounter
    # Hostile Encounter
    python:
        __temp = map_point._scene
        if standd6.roll()[0] + standd6.roll()[0] <= map_point.hostility:
            _temp_list = []
            _i = 0
            # Loop through encounter list
            for _i in map_point.encounter:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = map_point._scene
        # Scavange Encounter
        else:
            _temp_list = []
            _i = 0
            # Loop through scavenge list
            for _i in map_point.scavenge:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = "scene_last"


    jump expression __temp

label scene_explore_begin:
    if 8 < calendar[3] < 20:
        show expression map_point.bg_day# with dissolve
    else:
        show expression map_point.bg_night# with dissolve

    # show screen clock with None
    # hide screen menubar with moveoutright

    # Determine Scavenge Event
    # First check hostility and see if there is a combat encounter
    # If not compile a list of scavenge events and pick one at random based on weight
    # To check for hostility roll 2d6 any roll equal to or less then the locations hostility results in a hostile encounter
    # Hostile Encounter
    python:
        __temp = map_point._scene
        if standd6.roll()[0] + standd6.roll()[0] <= map_point.hostility:
            _temp_list = []
            _i = 0
            # Loop through encounter list
            for _i in map_point.encounter:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = map_point._scene
        # Scavange Encounter
        else:
            _temp_list = []
            _i = 0
            # Loop through scavenge list
            for _i in map_point.explore:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = "scene_last"

    jump expression __temp


#
