﻿# The script of the game goes in this file.

# Declare characters used by this game. The color argument colorizes the
# name of the character.

# Define is a constant
# Default sets on new game or if the variable isn't already defined

# define e = Character("Eileen")

define _history = False

hide quick_menu()

# Calender keeps track of the current date
# Stored as Year, Month, Day, Hour, Minute
default calendar = [0001,01,1,18,00]
# Weather contains a string and is set at the dawn of each day
# "clear" "rain" "downpour" "thunderstorm" "overcast" "snowing" "mist" "hot"
default weather = "clear"

# Defense Dice
define whiteDice = d6("gui/dice/white_dice.png","Whi",0,False,0,False,0,False,1,False,1,False,1,False)
define grayDice = d6("gui/dice/gray_dice.png","Gra",0,False,0,False,1,False,1,False,2,False,2,False)
define blackDice = d6("gui/dice/black_dice.png","Bla",0,False,1,False,2,False,2,False,3,False,4,False)
# Attack Dice
define greenDice = d6("gui/dice/green_dice.png","Gre",1,False,1,False,1,False,1,True,2,False,2,False)
define blueDice = d6("gui/dice/blue_dice.png","Blu",1,False,1,True,2,False,2,False,2,False,3,False)
define purpleDice = d6("gui/dice/purple_dice.png","Pur",1,False,1,True,1,True,2,False,2,False,2,True)
define redDice = d6("gui/dice/red_dice.png","Pur",1,True,1,True,2,True,2,True,1,False,1,False)
define goldDice = d6("gui/dice/gold_dice.png","Gol",1,False,1,False,2,False,2,False,3,False,4,False)
# Standard Dice
define standd6 = d6(None,"d6",1,False,2,False,3,False,4,False,5,False,6,False)

default inventory = []
default accessInventory = False
default accessMap = False
# Enemy inventory holds 5 slots for items equipped to the enemy
# 0 Acc, 1 Chest, 2 Legs, 3 Right Hand, 4 Left Hand
default enemyInventory = []
default selected_item = None
default pc = Mob(8,8,4,4,4,4,4,"Player","Human","Male",69,170)
define player = Character("[pc.profile[Name]]", dynamic = True)
default enemy = None

default last_scene = None
default last_checkpoint = "scene_last_drop.meet_squeeb_first_death"

# General Items
# id_key 0xxxxx
# Item(self,id_key,img,val,name,desc,amount,1,99)
default item_trash = InventoryItem(000001,"gui/items/default.jpg",0,"Trash","Description",99)
default item_vial = InventoryItem(000002,"gui/items/default.jpg",1,"Vial","Description",99)
# Armors and Equipment
# id_key 1xxxxx
# Armor(self,id_key,img,val,name,desc,locked,amount,slot,damage,lust,defense,res,boon,tier)
default item_headband = Armor(100001,"gui/items/default.jpg",0,"Headband","Description",False,"Head",None,None,None,None,[],0)
default item_torn_shirt = Armor(100002,"gui/items/tattered_shirt.jpg",0,"Torn Shirt","Description",False,"Chest",None,None,[whiteDice],None,[],0)
default item_torn_shorts = Armor(100003,"gui/items/tattered_pants.jpg",0,"Torn Shorts","Description",False,"Legs",None,None,None,[grayDice],[],0)
default item_magic_collar = Armor(100004,"gui/items/magic_collar.jpg",0,"Chastity Collar","Description",True,"Acc",None,None,None,[blackDice],[Buff.CURSE],0)
# Weapons and Shields
# id_key 2xxxxx
# Weapon(self,id_key,img,val,name,desc,locked,slot,damage,lust,defense,res,type,tier,heavy,pierce,reach)
default item_stick = Weapon(200001,"gui/items/stick.jpg",0,"Stick","Description",False,'Right',[greenDice,blueDice],None,None,None,Weapon_Type.MISC,0)
default item_plank_shield = Weapon(200002,"gui/items/default.jpg",0,"Plank Shield","Description",False,'Left',None,None,[whiteDice],None,Weapon_Type.SHIELD,0)
default item_big_stick = Weapon(200003,"gui/items/big_stick.jpg",0,"Big Stick","Description",False,'Both',[blueDice,blueDice,blueDice],None,None,None,Weapon_Type.STAFF,0,heavy = True)
default item_basic_spear = Weapon(200004,"gui/items/big_stick.jpg",0,"Primitive Spear","Description",False,'Right',[redDice,blueDice],None,None,None,Weapon_Type.STAFF,0,pierce = True)
# Ingredients
# id_key 3xxxxx
# Ingredient(self,id_key,img,val,name,desc,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,buff_2)
default item_wildberry = Ingredient(300001,"gui/items/default.jpg",0,"Wildberry","Description",99,None,None,None,None,None,None)
default item_redroot = Ingredient(300002,"gui/items/default.jpg",0,"Red Root","Description",99,None,[whiteDice],None,None,None,None)
default item_honey = Ingredient(300003,"gui/items/default.jpg",2,"Honey","Description",99,[whiteDice,whiteDice],None,None,None,None,None)
# Consumables
# id_key 4xxxxx
# Consumable(self,id_key,img,val,name,desc,amount,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,tier_1,dur_1,buff_2,tier_2,dur_2,buff_3,tier_3,dur_3)
default item_apple = Consumable(400001,"gui/items/default.jpg",0,"Apple","Description",99,[whiteDice],None,None,None,None,1,0,None,1,0,None,1,0)
default item_ale = Consumable(400002,"gui/items/default.jpg",0,"Ale","Description",99,None,[whiteDice],None,None,None,1,0,None,1,0,None,1,0)

# Define Skills (self,img,name,description,funct,stam,type):
define skill_struggle = Skill("gui/button/strike","Struggle",
"Unable to act",struggle,0,"Physical")
define skill_rest = Skill("gui/button/strike",
"Rest","Resting recovers 1 or 2 stamina.",rest,0,"Other")
define skill_strike = Skill("gui/button/strike","Strike",
"Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque sollicitudin dui sit amet elit hendrerit, pellentesque volutpat ex venenatis.",strike,0,"Physical")
define skill_flirt = Skill("gui/button/flirt","Flirt",
"Attempt to pacify the enemy with your charm",flirt,0,"Lust")
define skill_pierce = Skill("gui/button/thrust","Pierce",
"You make a swift strike forward, this attack bypasses armor when wielding a piercing weapon.",pierce,1,"Physical")

# power word skills are used for narrative moments only and should not be accessable to the player or regular creatures
define skill_pw_kill = Skill("gui/button/strike","Power Word Kill",
"Instantly defeats the target",pw_kill,0,"Physical")


# Mob(self, sprite, hp, libido, stamina, survival, combat, acumen, glamour,name,race,gender,hei,wei,base_attack,base_flirt,base_defense,base_resistance,
# skill_1,skill_2,skill_3,skill_4,skill_5):
# default goblin_male_1 = Hostile("Male Goblin",4,6,2,6,4,3,3,"Goblin","Goblin","Male",36,40,[whiteDice],[whiteDice],[whiteDice],[whiteDice],skill_strike,None,None,None,None,None,"")
define nar = Character("")
define unknown_person = Character("?")
define squeeb = Character("Squeeb")
define fenna = Character("Fenna")

# Combat Variables
default player_turn = True
default turn_start = True
default player_action_menu = True # False if inventory is active
default selected_skill = None
default hit = 0
default crit = 0
default miss = 0
default spr = []
default combat_history = []
default turn_count = 1
default flee_succeed = False
default mob_flee = False
default mob_submit = False

image enemy_healthy_chaste = "goblin nude.png"
image enemy_healthy_lusty = "goblin nude.png"
image enemy_hurt_chaste = "goblin nude.png"
image enemy_hurt_lusty = "goblin nude.png"

default battle_end = ""

# Define Backgrounds
image bg basic = "gui/rooms/bg room.jpg"
image bg worldmap = "gui/rooms/worldmap.jpg"
image bg forest_day = "gui/rooms/forest day.jpg"
image bg forest_night = "gui/rooms/forest night.jpg"

# Define Location
default map_point = fort_chastity
default selected_locale = None

default locations = []
default roads = []

default set_ui = "map"

# NPC Images
image squeeb collared_idle = "Squeeb idle.png"
image fenna collared_idle = "Fenna idle.png"

# NPC POINTS
default relationship_squeeb = {
"met_squeeb" : False,
"gave_name" : False,
"thanked_for_saving" : False
}
default relationship_fenna = {
"met_fenna" : False
}

# The game starts here.

label start:
    $ _game_menu_screen = None
    # SET LOCATIONS LIST
    python:
        # Forest Locations
        locations.append(south_forest_01)
        locations.append(south_forest_02)
        locations.append(south_forest_03)
        # Coastal Locations
        locations.append(south_coast_01)
        locations.append(south_coast_02)
        locations.append(south_coast_03)
        locations.append(south_coast_04)
        # Unique Locations
        locations.append(fort_chastity)
        locations.append(the_last_drop)
        locations.append(vergesseneburg)
    # SET ROADS LIST
    python:
        roads.append(forest_to_fort_chastity)
        roads.append(forest_path_01)
        roads.append(forest_path_02)
        roads.append(forest_path_03)
        roads.append(last_drop_path_01)
        roads.append(last_drop_path_02)
        roads.append(beach_path_01)
        roads.append(beach_path_02)
        roads.append(beach_path_03)
        roads.append(path_vergesseneburg_to_beach)
    python:
        Mob.update_all(pc)

        addToInventory(item_stick,1)
        i = 0
        while i < 10:
            addToInventory(item_trash,15)
            i += 1
        addToInventory(item_torn_shirt,1)
        addToInventory(item_torn_shorts,1)
        addToInventory(item_magic_collar,1)

        inventory[len(inventory)-3][0].equip(pc)
        inventory[len(inventory)-2][0].equip(pc)
        inventory[len(inventory)-1][0].equip(pc)

        sortInventory(1)

    # Show a background. This uses a placeholder by default, but you can
    # add a file (named either "bg room.png" or "bg room.jpg") to the
    # images directory to show it.

    scene bg basic
    # show screen bookend()

    jump scene_introduction_01 # scene_map

label scene_introduction_01:
    show bg basic

    "The darkness of your cell was pierced by a thin shaft of light that managed to crack through the grim covered porthole. The sounds of shouting above deck was muffled by the sounds of crashing waves against the ship; which rocked heavily from side to side against the tide."

    "It'd been almost three years since the end of the Monster Wars. The Elven Legion had succeeded in concurring most of the continent and now it was just a matter of cleaning up the few futile rebellions that cropped up. The heavy metal collar around your neck was a harsh reminder of what side you had been on."

    "Some half dozen other monsters sat chained in dank cells similar to your own, all bound with a heavy metal collar. You can hear one of your fellow prisoners, a humanoid of some kind, covered in fur, with a rat like face and tail. He's scratching desperately at the collar, causing horrible sounds to echo throughout the hull."

    $ add_time(0,15)

    "Orc" "\"You're wasting your time and making my ears bleed with that racket.\" A dark skinned orc at the other side of the ship barked. \"Damned things are enchanted, it ain't coming off without your head coming with it.\""

    "Wererat" "\"If you want your balls to shrivel up that's your business but I'm not going quietly.\""

    "Wood creaks as a guard steps out from the shadows and into the low light. Silver and blue armor contrasting with the grimy hull of the ship."

    "Guard" "\"If you'd like I could hasten the process for you.\" The guard snarls while gripping the hilt of his blade. Although his helmet covered his face you could sense the sick smile beneath."

    "Luckily before the rat person could respond the ship jerked suddenly and the ringing of a bell echoed through the ship. Stomping of feet above deck was swiftly followed by a ray of light filling the hull as the doors to the deck were pulled open."

    "Guard" "\" Seems we've arrived. Welcome to your new home beasts.\""

    "A dozen other guards all dressed in similar silver and blue regalia descend into the ship pulling open the cages you'd been kept in. One by one you're all dragged up to the deck of the ship, sharp blades pressing against your back urge you forward. Descending the plank to a long wooden dock which winds up the rocky shore to a walled port town."

    $ add_time(0,5)

    "Armed soldiers of the Elven Legion patrol constantly along the walled settlement, tall towers with archers stare down at you like prison wardens. Though the noon day sun bares down on you, the port feels oppressive and dark."

    $ add_time(0,5)

    "Paladin" "\"Move it!\" A paladin of the legion jabs you roughly with the butt of his spear, forcing you onward."

    "You're quickly ushered towards a large set of wooden gates which open with a low groan. Another rough jab forces you beyond the walls."

    "Paladin" "\"Welcome to Alcatraz.\""

    show bg forest_day with dissolve

    "Those were the last words spoken to you before the gate was shut, locking you outside. A dense forest sprawls out ahead of you, near impassible except for a narrow crude path beaten in by the many other monsters banished here before you. The ground is damp from a morning rain, and you see yourself reflected in a small puddle."

    jump player_creation

label player_creation:
    menu:
        "You're a..."
        "Male":
            $ pc.profile['Gender'] = "Male"
        "Female":
            $ pc.profile['Gender'] = "Female"

    menu:
        "You're a [pc.profile[Gender]]..."
        "Goblin":
            $ pc.profile['Race'] = "Goblin"
        "Orc":
            $ pc.profile['Race'] = "Orc"
        "Lizardfolk":
            $ pc.profile['Race'] = "Lizardfolk"
        "Kobold":
            $ pc.profile['Race'] = "Kobold"
        "Minotaur":
            $ pc.profile['Race'] = "Minotaur"

    python:
        pc.profile['Name'] = renpy.input("You're a [pc.profile[Gender]] [pc.profile[Race]], named...")
        pc.profile['Name'] = pc.profile['Name'].strip()

        if not pc.profile['Name']:
            pc.profile['Name'] = "Player"

    menu:
        "You're a [pc.profile[Gender]] [pc.profile[Race]], named [pc.profile[Name]]. Does that sound right?"
        "Yes":
            jump scene_introduction_02
        "No":
            jump player_creation

label scene_introduction_02:
    "You turn away from the small puddle, tugging at the collar that dug into your neck. Here wasn' the place to remove the collar and now wasn't the time for regrets. You needed to survive, find some shelter and get somewhere safe for the night."

    $ add_time(0,5)

    menu:
        "You decide it'd be best to search the area for something to defend yourself. Even just a stick would be better then nothing."

        "Scavenge":
            $ accessInventory = True
            jump scene_introduction_03

label scene_introduction_03:
    "You dig through the nearby brush, pushing through the dense shrubs and clinging vines, you manage to find a short but sturdy branch. Pulling it free from some a tangle of other plants you give it a swift practice swing. It's not much, but it's probably better then your fists."

    "You can equip the branch in the inventory menu."

    $ add_time(0,5)
    $ last_scene = "scene_introduction_04"
    $ accessInventory = True
    call screen menubar(False,accessInventory,accessMap,False)

label scene_introduction_04:
    show bg forest_day with dissolve

    if pc.hands['Right'] != None:
        $ _t = "With a weapon in hand you feel a bit more confident venturing further into the forest, but without a map or any idea where to go you'll just have to explore."
    else:
        $ _t = "Deciding to take your chances with your fists rather then a weapon may not have been wise but you decide to risk it anyways."

    menu:
        "[_t]"
        "Explore":
            "Without any other direction to go you press forward into the forest, but before you can find anything a green shape leaps at you from the woods."
            $ add_time(0,5)
            $ last_scene = "scene_introduction_05"
            $ _enemy = Hostile("Female Goblin",2,4,2,2,2,2,2,"Goblin","Goblin","Female",36,40,[whiteDice],[whiteDice],[whiteDice],[whiteDice],store.skill_strike,None,None,None,None,None,"Weak")
            $ battle_end = "tutorial_battle"
            call scene_battle_setup pass (_en = _enemy) from _call_scene_battle_setup # from _call_scene_battle_setup

label scene_introduction_05:
    menu:
        "The forest is filled with dark trees that curl across the sky in a thick knotted canopy."
        "Explore":
            $ south_forest_02.discovered = True
            "You discover a small path that leads through some of the underbrush. It's a tough walk but you find yourself deeper in the forest surrounded by dense trees."
            jump scene_introduction_06

label scene_introduction_06:
    menu:
        "The forest is filled with dark trees that curl across the sky in a thick knotted canopy."
        "Explore":
            jump battle_forest.nightstalker

label scene_inventory:
    hide screen clock
    hide screen menubar

    # show bg basic

    call screen inventory_screen(inventory) with dissolve

    jump scene_last


# Battle set up
# Set default variables and reset anything that needs to be reset at the beginning of a battle
label scene_battle_setup(_en = None,_eq_acc = None,_eq_torso = None,_eq_legs = None,_eq_left = None,_eq_right = None,_con = "",_ambush = False):
    show screen clock
    hide screen menubar

    if _en == None:
        jump expression map_point._scene
    else:
        python:
            # player_turn = True
            turn_start = True
            hit = 0
            crit = 0
            miss = 0
            selected_skill = None
            flee_succeed = False
            mob_flee = False
            mob_submit = False
            combat_history = []

            # SET ENEMY
            enemy = _en

            # EQUIP ENEMY ARMORS
            if isinstance(_eq_acc,Armor):
                enemy.equip_armor(_eq_acc,_eq_acc.slot)
            else:
                enemy.equipment["Acc"] = None
            if isinstance(_eq_torso,Armor):
                enemy.equip_armor(_eq_torso,_eq_torso.slot)
            else:
                enemy.equipment["Chest"] = None
            if isinstance(_eq_legs,Armor):
                enemy.equip_armor(_eq_legs,_eq_legs.slot)
            else:
                enemy.equipment["Legs"] = None
            # EQUIP ENEMY WEAPONS
            if isinstance(_eq_left,Weapon):
                enemy.equip_weapon(_eq_left)
            else:
                enemy.hands["Left"] = None
            if isinstance(_eq_right,Weapon):
                enemy.equip_weapon(_eq_right)
            else:
                enemy.hands["Right"] = None

            enemy.update_all()

            enemy.condition = _con

            spr = []
            spr += get_sprite_list(enemy.sprite)
            enemy.hp = enemy.max_hp
            if enemy.condition == "Aroused":
                enemy.libido = int(enemy.max_libido/2)
            else:
                enemy.libido = 0

            turn_count = 1

            # Check if the encounter is an Ambush. If it is the enemy goes first by default. Otherwise test awareness
            if _ambush:
                player_turn = False
                combat_history.append(str(enemy.profile['Name']) + " bursts from the shadows. You have been ambushed.")
            else:
                # Determine if player or enemy starts first
                # Enemy and Player roll a gray dice per 4 points in Survival
                # Player wins ties
                _pc_s = 0
                for _i in range(int(pc.survival/4)):
                    _pc_s += grayDice.roll()[0]
                _en_s = 0
                for _i in range(int(enemy.survival/4)):
                    _en_s += grayDice.roll()[0]

                player_turn = True
                if _en_s > _pc_s:
                    player_turn = False

                combat_history.append("Player rolled : " + str(_pc_s))
                combat_history.append("Enemy rolled : " + str(_en_s))


        image enemy_healthy_chaste = "[spr[0]]"
        image enemy_hurt_chaste = "[spr[1]]"
        image enemy_healthy_lusty = "[spr[2]]"
        image enemy_hurt_lusty = "[spr[3]]"

        jump scene_battle_loop

label scene_battle_loop:

    # if 8 < calendar[3] < 20:
    #     show map_point.bg_day with dissolve
    # else:
    #     show image map_point.bg_night with dissolve

    show screen enemy_status(enemy)
    show screen action_history(combat_history)
    show screen action_menu(pc,False)

    # Determine if mob or player goes first

    while flee_succeed == False and mob_flee == False and mob_submit == False and enemy.hp > 0 and enemy.libido < enemy.max_libido and pc.hp > 0:
        hide enemy_healthy_chaste
        hide enemy_hurt_chaste
        hide enemy_healthy_lusty
        hide enemy_hurt_lusty

        # Show enemy sprites
        if enemy.hp >= enemy.max_hp/2:
            if enemy.libido < enemy.max_libido/2:
                show enemy_healthy_chaste:
                    yalign 0.5
                    xalign 0.6
            else:
                show enemy_healthy_lusty:
                    yalign 0.5
                    xalign 0.6
        else:
            if enemy.libido < enemy.max_libido/2:
                show enemy_hurt_chaste:
                    yalign 0.5
                    xalign 0.6
            else:
                show enemy_hurt_lusty:
                    yalign 0.5
                    xalign 0.6

        $ selected_skill = None

        if player_turn:
            # If turn_start apply buffs and bonuses
            if turn_start:
                $ pc.turn_begin_update()
                $ turn_start = False
                pause 0.5
            # Player Actions Here
            # While player_action_menu is True player can select from skills
            # If false check for inventory interaction instead
            if player_action_menu:
                call screen action_menu(pc,True)
                show screen action_menu(pc,False)
                $ player_action = _return

                if player_action in range(0,5):
                    $ _tsk = use_skill(pc.skills[selected_skill],pc,enemy)
                    $ combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk))

                    $ player_turn = False

                    pause 0.75
                elif player_action == 6:
                    $ _tsk = rest(pc,enemy)
                    $ combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk))
                    $ player_turn = False

                    pause 0.75
                elif player_action == 7:
                    if standd6.roll()[0] + standd6.roll()[0] >= 7:
                        $ flee_succeed = True
                    else:
                        $ combat_history.insert(0,"Turn " + str(turn_count) + " - attempted to flee but failed")
                    $ player_turn = False

                    pause 0.75

            # INVENTORY ACTIONS HERE
            else:
                $ turn_start = True
                $ player_turn = False

        else:
            # Enemy Actions Here
            # Pre Turn Buffs and Debuffs
            if turn_start:
                $ enemy.turn_begin_update()
                $ turn_start = False
                pause 0.5
            # Determine Enemy Actions
            # First check if enemy flees
            # Set DC based on enemy HP
            # At full health the enemy won't flee
            # At half health there is 1/36 chance of fleeing
            # At quarter health 3/36 chance of fleeing
            # Melancholy or Cowardly trait increase the DC by 2
            if not turn_start:
                $ _dc = 1
                $ _dc2 = 1
                if enemy.hp <= enemy.max_hp/2:
                    $ _dc += 1
                if enemy.hp <= enemy.max_hp/4:
                    $ _dc += 1
                if enemy.condition == "Melancholy" or enemy.condition == "Cowardly":
                    $ _dc += 2
                    $ _dc2 += 2
                # Check 2d6 vs DC
                if standd6.roll()[0] + standd6.roll()[0] <= _dc:
                    # On a fail roll a d6
                    # If the enemy is Melancholy or Cowardly the enemy flees on a 3 or less
                    # Otherwise the enemy flees on a 1
                    if standd6.roll()[0] <= _dc2:
                        # ADD FLEE ATTEMPT LATER
                        $ mob_flee = True

                $ _dc = 1
                $ _dc2 = 1
                if enemy.libido >= enemy.max_libido/2:
                    $ _dc += 1
                if enemy.libido <= enemy.max_libido/4:
                    $ _dc += 1
                if enemy.condition == "Submissive":
                    $ _dc += 2
                    $ _dc2 += 2
                # Check for submission
                if standd6.roll()[0] + standd6.roll()[0] <= _dc:
                    # On a fail roll a d6
                    # If the enemy is Melancholy or Cowardly the enemy flees on a 3 or less
                    # Otherwise the enemy flees on a 1
                    if standd6.roll()[0] <= _dc2:
                        # ADD FLEE ATTEMPT LATER
                        $ mob_submit = True

                # If mob isn't fleeing or submitting determine their attack action
                if not mob_flee and not mob_submit:
                    python:
                        _list = []
                        _i = 0
                        for _i in range(6):
                            if enemy.skills[_i] != None:
                                if enemy.skills[_i].stam <= enemy.stamina:
                                    _o = 0
                                    for _o in range(enemy.skills[_i].skill_priority(enemy,pc)):
                                        _list.append(enemy.skills[_i])
                        if len(_list) > 0:
                            _tsk = use_skill(_list[renpy.random.randint(0,len(_list)-1)],enemy,pc)
                        else:
                            _tsk = use_skill(skill_struggle,enemy,pc)

                        # Show weighted attack list
                        # for _i in _list:
                        #     combat_history.insert(0,str(_i.name))

                        combat_history.insert(0,"Turn " + str(turn_count) + " - " + str(_tsk))


                $ turn_start = True
                $ player_turn = True
        $ turn_count += 1

    pause

    python:
        _e = "martial_victory"
        if flee_succeed:
            _e = "player_flee"
        elif mob_flee:
            _e = "mob_flee"
        elif mob_submit:
            _e = "mob_submit"
        elif pc.hp <= 0:
            if pc.libido > pc.max_libido:
                _e = "lust_defeat"
            else:
                _e = "martial_defeat"
        elif enemy.hp <= 0:
            _e = "martial_victory"
        elif enemy.libido >= enemy.max_libido:
            _e = "lust_victory"

    # DETERMINE ENDING TO JUMP TO
    call scene_battle_end pass (_e) from _call_scene_battle_end # from _call_scene_battle_end

label scene_battle_end(_end = "martial_victory"):
    hide screen enemy_status
    hide screen action_menu
    hide screen action_history
    $ add_time(0,10)

    if battle_end != "":
        jump expression battle_end + "." + _end
    else:
        jump scene_last

label battle_clean_up:
    hide enemy_healthy_chaste
    hide enemy_healthy_lusty
    hide enemy_hurt_chaste
    hide enemy_hurt_lusty

    if pc.hp <= 0:
        $ pc.hp = pc.max_hp
        $ pc.libido = 0
        $ _s = str(last_checkpoint)
        jump expression _s
    else:
        jump scene_last

# Map
label scene_map:
    show screen clock()
    with moveinleft
    hide screen menubar
    with moveoutright

    show bg basic with dissolve

    while set_ui == "map":
        call screen map()
        if _return == True:
            $ travel(map_point,selected_locale)
            # map_point = selected_locale
            # selected_locale = None
            # add_time(0,30)

    pause

label scene_last:
    # Jumps the player to the last scene
    # Use after battles, inventory access, or map access
    ""
    $ _s = map_point._scene
    if last_scene == None:
        if 8 < calendar[3] < 20:
            show expression map_point.bg_day with dissolve
        else:
            show expression map_point.bg_night with dissolve
    else:
        $ _s = str(last_scene)
        $ last_scene = None

    show screen clock()
    with moveinleft
    show screen menubar # (False,accessInventory,accessMap,False)
    with moveinright

    jump expression _s

label scene_scavenge_begin:
    if 8 < calendar[3] < 20:
        show expression map_point.bg_day with dissolve
    else:
        show expression map_point.bg_night with dissolve

    show screen clock with None
    hide screen menubar with moveoutright

    # Determine Scavenge Event
    # First check hostility and see if there is a combat encounter
    # If not compile a list of scavenge events and pick one at random based on weight
    # To check for hostility roll 2d6 any roll equal to or less then the locations hostility results in a hostile encounter
    # Hostile Encounter
    python:
        __temp = map_point._scene
        if standd6.roll()[0] + standd6.roll()[0] <= map_point.hostility:
            _temp_list = []
            _i = 0
            # Loop through encounter list
            for _i in map_point.encounter:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = map_point._scene
        # Scavange Encounter
        else:
            _temp_list = []
            _i = 0
            # Loop through scavenge list
            for _i in map_point.scavenge:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = "scene_last"


    jump expression __temp

label scene_explore_begin:
    if 8 < calendar[3] < 20:
        show expression map_point.bg_day with dissolve
    else:
        show expression map_point.bg_night with dissolve

    show screen clock with None
    hide screen menubar with moveoutright

    # Determine Scavenge Event
    # First check hostility and see if there is a combat encounter
    # If not compile a list of scavenge events and pick one at random based on weight
    # To check for hostility roll 2d6 any roll equal to or less then the locations hostility results in a hostile encounter
    # Hostile Encounter
    python:
        __temp = map_point._scene
        if standd6.roll()[0] + standd6.roll()[0] <= map_point.hostility:
            _temp_list = []
            _i = 0
            # Loop through encounter list
            for _i in map_point.encounter:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = map_point._scene
        # Scavange Encounter
        else:
            _temp_list = []
            _i = 0
            # Loop through scavenge list
            for _i in map_point.explore:
                # Check if scavenge event matches current requirements
                if True: # (_i[2] == "any" or _i[2] == store.weather) and _i[4] < store.calendar[3] < _i[5]:
                    _o = 0
                    # Add scavenge event a number of times equal to it's weight
                    for _o in range(0,_i[1]):
                        _temp_list.append(_i[0])

            if len(_temp_list) > 0:
                _i = renpy.random.randint(0,len(_temp_list)-1)
                __temp = _temp_list[_i]
            else:
                __temp = "scene_last"

    jump expression __temp


#
