init python:
    import math

screen map():
    zorder 50
    add "gui/rooms/worldmap.jpg"

    # Menubar
    fixed:
        pos (909,8)
        xysize (355,80)
        imagebutton auto "gui/button/exitbutton_%s.png" action Return() and Jump("scene_last") area (279,0,80,80) anchor (0.5,0.5) focus_mask "gui/button/button_mask.png"

    # Map Details
    for _i in range(len(roads)):
        if roads[_i].discovered and roads[_i].locale_1.discovered and roads[_i].locale_2.discovered:
            $ _dis_a = roads[_i].locale_1.x - roads[_i].locale_2.x
            if _dis_a < 0:
                $ _dis_a *= -1
            $ _dis_b = roads[_i].locale_1.y - roads[_i].locale_2.y
            if _dis_b < 0:
                $ _dis_b *= -1

            $ _points = int(math.sqrt((_dis_a * _dis_a) + (_dis_b * _dis_b))/12)

            # Draw Paths from current location
            for _o in range(_points):
                if (roads[_i].locale_1 == map_point or roads[_i].locale_2 == map_point) and (roads[_i].locale_1 == selected_locale or roads[_i].locale_2 == selected_locale):
                    add "gui/misc/path_highlight.png":
                        xpos roads[_i].locale_1.x + (((roads[_i].locale_2.x - roads[_i].locale_1.x)/_points) * _o)
                        ypos roads[_i].locale_1.y + (((roads[_i].locale_2.y - roads[_i].locale_1.y)/_points) * _o)
                        anchor (0.5,0.5)
                elif roads[_i].locale_1 == map_point or roads[_i].locale_2 == map_point:
                    add "gui/misc/path_visible.png":
                        xpos roads[_i].locale_1.x + (((roads[_i].locale_2.x - roads[_i].locale_1.x)/_points) * _o)
                        ypos roads[_i].locale_1.y + (((roads[_i].locale_2.y - roads[_i].locale_1.y)/_points) * _o)
                        anchor (0.5,0.5)
                else:
                    add "gui/misc/path_hidden.png":
                        xpos roads[_i].locale_1.x + (((roads[_i].locale_2.x - roads[_i].locale_1.x)/_points) * _o)
                        ypos roads[_i].locale_1.y + (((roads[_i].locale_2.y - roads[_i].locale_1.y)/_points) * _o)
                        anchor (0.5,0.5)

    for _i in range(len(locations)):
        # Draw map icons that are not the current position of the player
        if locations[_i].discovered:
            if map_point != locations[_i]:
                # Draw map icons outside movement range
                $ _loc = locations[_i]
                if not map_point.is_connected(_loc):
                    add _loc.img + "grey.png" pos (_loc.x,_loc.y) anchor (0.5,0.5)
                else:
                    if selected_locale == _loc:
                        imagebutton idle _loc.img + "color.png" pos (_loc.x,_loc.y) anchor (0.5,0.5) action Return(True) focus_mask "gui/button/map_mask.png" # Function(travel,map_point,_loc,calendar)
                    else:
                        imagebutton idle _loc.img + "white.png" hover _loc.img + "color.png" pos (_loc.x,_loc.y) anchor (0.5,0.5) action SetVariable("selected_locale",_loc) focus_mask "gui/button/map_mask.png"
            else:
                    add map_point.img + "color.png" pos (map_point.x,map_point.y) anchor (0.5,0.5)

    if selected_locale != None:
        for _i in range(len(roads)):
            if roads[_i].discovered and (roads[_i].locale_1 == map_point or roads[_i].locale_2 == map_point) and (roads[_i].locale_1 == selected_locale or roads[_i].locale_2 == selected_locale):
                $ _mrk_x = (map_point.x + selected_locale.x) / 2
                $ _mrk_y = (map_point.y + selected_locale.y) / 2
                add "gui/button/map_marker.png" pos (_mrk_x,_mrk_y) anchor (0.5,1.0)
                text str(roads[_i].tt_minutes) + " minutes" pos (_mrk_x,_mrk_y - 40) size 14 color "#000" anchor (0.5,1.0)
    else:
        add "gui/button/map_marker.png" pos (map_point.x,map_point.y) anchor (0.5,1.0)
