style inventory_frame:
    background Frame("gui/frames/test_frame.png",16,16)
    xmargin 0
    ymargin 0
    xpadding 0
    ypadding 0

style inven_item:
    background Frame("gui/frames/test_frame.png",16,16)
    xmargin 0
    ymargin 0
    xpadding 0
    ypadding 8

screen inventory_screen(inven):
    default tip = Tooltip("")
    add "#000"
    add "gui/frames/inventory_frame.png" pos(0.0,0.0) anchor(0.0,0.0)
    fixed:
        pos (909,8)
        xysize (355,80)
        imagebutton auto "gui/button/exitbutton_%s.png" action Return() and Jump("scene_last") area (279,0,80,80) anchor (0.5,0.5) focus_mask "gui/button/button_mask.png"
    #  Basic Info *************
    vbox:
        pos (230,72)
        text "Name-" color "#707070" align(0.0,0.0) size 16
        text "Level-" color "#707070" align(0.0,0.0) size 16
        text "Health-" color "#707070" align(0.0,0.0) size 16
        text "Libido-" color "#707070" align(0.0,0.0) size 16
    vbox:
        pos (330,72)
        text pc.profile['Name'] color "#707070" align(1.0,0.0) size 16
        text "[pc.level]" color "#707070" align(1.0,0.0) size 16
        text "[pc.hp]/[pc.max_hp]" color "#707070" align(1.0,0.0) size 16
        text "[pc.libido]/[pc.max_libido]" color "#707070" align(1.0,0.0) size 16
    #  Profile Info ************
    vbox:
        pos (405,72)
        text "Race-" color "#707070" align(0.0,0.0) size 16
        text "Gender-" color "#707070" align(0.0,0.0) size 16
        text "Height-" color "#707070" align(0.0,0.0) size 16
        text "Weight-" color "#707070" align(0.0,0.0) size 16
    vbox:
        pos (500,72)
        text pc.profile['Race'] color "#707070" align(1.0,0.0) size 16
        text pc.profile['Gender'] color "#707070" align(1.0,0.0) size 16
        text "[pc.profile[Height]] Inches" color "#707070" align(1.0,0.0) size 16
        text "[pc.profile[Weight]] Lbs" color "#707070" align(1.0,0.0) size 16
    #  Statistics **************
    vbox:
        pos (230,240)
        text "Survival-" color "#707070" align(0.0,0.0) size 16
        text "Combat-" color "#707070" align(0.0,0.0) size 16
    vbox:
        pos (330,240)
        text "[pc.survival]" color "#707070" align(1.0,0.0) size 16
        text "[pc.combat]" color "#707070" align(1.0,0.0) size 16
    vbox:
        pos (405,240)
        text "Acumen-" color "#707070" align(0.0,0.0) size 16
        text "Glamour-" color "#707070" align(0.0,0.0) size 16
    vbox:
        pos (500,240)
        text "[pc.acumen]" color "#707070" align(1.0,0.0) size 16
        text "[pc.glamour]" color "#707070" align(1.0,0.0) size 16
    #  Damage and Armor *********
    vbox:
        pos (230,300)
        spacing 8
        text "Attack" color "#707070" yanchor 0.6 align(0.0,0.0) size 16
        text "Charm" color "#707070" yanchor 0.6 align(0.0,0.0) size 16
        text "Defense" color "#707070" yanchor 0.6 align(0.0,0.0) size 16
        text "Resistance" color "#707070" yanchor 0.6 align(0.0,0.0) size 16
    vbox:
        pos (364,300)
        hbox:
            for _i in pc.attack:
                imagebutton idle _i.img action NullAction() anchor (0.5,0.5) hovered Notify(_i.tt)
        hbox:
            for _i in pc.flirt:
                imagebutton idle _i.img action NullAction() anchor (0.5,0.5) hovered Notify(_i.tt)
        hbox:
            for _i in pc.defense:
                imagebutton idle _i.img action NullAction() anchor (0.5,0.5) hovered Notify(_i.tt)
        hbox:
            for _i in pc.resistance:
                imagebutton idle _i.img action NullAction() anchor (0.5,0.5) hovered Notify(_i.tt)
    #  Equipment ****************
    # hbox:
        # pos (230,448)
        # xysize (344,160)
    fixed:
        pos (230,464)
        if pc.equipment['Acc'] != None:
            imagebutton:
                idle pc.equipment['Acc'].img
                pos (6,6)
                if pc.equipment['Acc'] != None:
                    action SetVariable("selected_item",getEquipInInventory(pc.equipment['Acc']))
                else:
                    action NullAction()
        add "gui/frames/item_frame.png"
    fixed:
        pos (299,464)
        if pc.equipment['Chest'] != None:
            imagebutton:
                idle pc.equipment['Chest'].img
                pos (6,6)
                if pc.equipment['Chest'] != None:
                    action SetVariable("selected_item",getEquipInInventory(pc.equipment['Chest']))
                else:
                    action NullAction()
        add "gui/frames/item_frame.png"
    fixed:
        pos (368,464)
        if pc.equipment['Legs'] != None:
            imagebutton:
                idle pc.equipment['Legs'].img
                pos (6,6)
                if pc.equipment['Legs'] != None:
                    action SetVariable("selected_item",getEquipInInventory(pc.equipment['Legs']))
                else:
                    action NullAction()
        add "gui/frames/item_frame.png"
    fixed:
        pos (437,464)
        if pc.hands['Right'] != None:
            imagebutton:
                idle pc.hands['Right'].img
                pos (6,6)
                if pc.hands['Right'] != None:
                    action SetVariable("selected_item",getEquipInInventory(pc.hands['Right']))
                else:
                    action NullAction()
        add "gui/frames/item_frame.png"
    fixed:
        pos (506,464)
        if pc.hands['Left'] != None:
            imagebutton:
                idle pc.hands['Left'].img
                pos (6,6)
                if pc.hands['Left'] != None:
                    action SetVariable("selected_item",getEquipInInventory(pc.hands['Left']))
                else:
                    action NullAction()
        add "gui/frames/item_frame.png"

    text "Accessory" anchor (0.5,0.0) pos (262,448) size 13
    text "Chest" anchor (0.5,0.0) pos (330,448) size 13
    text "Legs" anchor (0.5,0.0) pos (398,448) size 13
    text "Right Hand" anchor (0.5,0.0) pos (466,448) size 13
    text "Left Hand" anchor (0.5,0.0) pos (534,448) size 13
    #  Item Description *********
    frame:
        pos (596,44)
        xysize (416,128)
        xpadding 8
        background None
        if selected_item != None:
            add inventory[selected_item][0].img pos (6,6)
            vbox:
                pos (72,8)
                text inventory[selected_item][0].name color "#707070" align(0.0,0.0) size 17 font "gui/fonts/Bradley Gratis.ttf"
                text inventory[selected_item][0].description color "#707070" align(0.0,0.0) size 15

        add "gui/frames/item_frame.png"
    #  Item Actions *************
    if selected_item != None:
        if isinstance(inventory[selected_item][0], Consumable):
            imagebutton:
                pos (669,204)
                anchor (0.5,0.5)
                idle "gui/frames/generic_button_idle.png"
                hover "gui/frames/generic_button_hover.png"
                action Function(inventory[selected_item][0].useItem, pc)
            text "Consume" size 16 color "#000" anchor (0.5,0.5) pos (669,204)

            imagebutton:
                pos (799,204)
                anchor (0.5,0.5)
                idle "gui/frames/generic_button_idle.png"
                hover "gui/frames/generic_button_hover.png"
                action NullAction() # Function(inventory[selected_item][0].useItem, pc)
            text "Discard" size 16 color "#000" anchor (0.5,0.5) pos (799,204)

        elif isinstance(inventory[selected_item][0], Weapon):
            if not inventory[selected_item][0].locked:
                imagebutton:
                    pos (669,204)
                    anchor (0.5,0.5)
                    idle "gui/frames/generic_button_idle.png"
                    hover "gui/frames/generic_button_hover.png"
                    if inventory[selected_item][0].is_equipped:
                        action Function(inventory[selected_item][0].unequip)
                    else:
                        action Function(inventory[selected_item][0].equip, pc)
                if inventory[selected_item][0].is_equipped:
                    text "Unequip" size 16 color "#000" anchor (0.5,0.5) pos (669,204)
                else:
                    text "Equip" size 16 color "#000" anchor (0.5,0.5) pos (669,204)

                imagebutton:
                    pos (799,204)
                    anchor (0.5,0.5)
                    idle "gui/frames/generic_button_idle.png"
                    hover "gui/frames/generic_button_hover.png"
                    action NullAction() # Function(inventory[selected_item][0].useItem, pc)
                text "Discard" size 16 color "#000" anchor (0.5,0.5) pos (799,204)

        elif isinstance(inventory[selected_item][0], Armor):
            if not inventory[selected_item][0].locked:
                imagebutton:
                    pos (669,204)
                    anchor (0.5,0.5)
                    idle "gui/frames/generic_button_idle.png"
                    hover "gui/frames/generic_button_hover.png"
                    if inventory[selected_item][0].is_equipped:
                        action Function(inventory[selected_item][0].unequip)
                    else:
                        action Function(inventory[selected_item][0].equip, pc)
                if inventory[selected_item][0].is_equipped:
                    text "Unequip" size 16 color "#000" anchor (0.5,0.5) pos (669,204)
                else:
                    text "Equip" size 16 color "#000" anchor (0.5,0.5) pos (669,204)

                imagebutton:
                    pos (799,204)
                    anchor (0.5,0.5)
                    idle "gui/frames/generic_button_idle.png"
                    hover "gui/frames/generic_button_hover.png"
                    action NullAction() # Function(inventory[selected_item][0].useItem, pc)
                text "Discard" size 16 color "#000" anchor (0.5,0.5) pos (799,204)
        else:
            imagebutton:
                pos (669,204)
                anchor (0.5,0.5)
                idle "gui/frames/generic_button_idle.png"
                hover "gui/frames/generic_button_hover.png"
                action NullAction() # Function(inventory[selected_item][0].useItem, pc)
            text "Discard" size 16 color "#000" anchor (0.5,0.5) pos (669,204)

    #  Inventory List ***********
    frame:
        xpos 600
        ypos 256
        minimum (400,432)
        maximum (400,432)
        background None
        side "l":
            area (16,0,400,416)
            viewport id "inventory_scroller":
                draggable True
                mousewheel True

                vbox:
                    $ i = 0
                    for i in range(len(inventory)):
                        $ item = inventory[i][0]
                        $ amo = inventory[i][1]
                        button:
                            action SetVariable("selected_item",i)
                            hbox:
                                xminimum 380
                                yminimum 32
                                # box_wrap True
                                frame:
                                    style "inventory_frame"
                                    minimum (32,32)
                                    maximum (32,32)
                                hbox:
                                    xminimum 150
                                    if isinstance(item,Equipable):
                                        if item.is_equipped:
                                            $ c = "#606060"
                                        else:
                                            $ c = "#999999"
                                    else:
                                        $ c = "#999999"
                                    text item.name size 16 yalign 0.5 xalign 0.0 color c xpos 0.0

                                hbox:
                                    xminimum 75
                                    if isinstance(item, Weapon):
                                        text "Weapon" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
                                    elif isinstance(item, Consumable):
                                        text "Consumable" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
                                    elif isinstance(item, Ingredient):
                                        text "Ingredient" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
                                    elif isinstance(item, Armor):
                                        text "Equipment" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
                                    else:
                                        text "--------" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
                                hbox:
                                    xminimum 50
                                    text "[amo]/[item.max_amount]" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
                            # style "inventory_frame"
                            # text item.name
        vbar value YScrollValue ("inventory_scroller")

# screen inventory_screen_base(inven):
#     frame:
#         background "#000"
#         pos (0,0)
#         xysize (1280,720)
#     # RETURN BUTTON
#     # Menubar
#     fixed:
#         pos (909,8)
#         xysize (355,80)
#         add "gui/frames/hotbar.png" anchor (0,0.5) pos (0,0.5)
#         # hbox:
#         #     xysize (355,46)
#         #     xfill True
#         imagebutton auto "gui/button/exitbutton_%s.png" action Return() area (279,0,80,80) anchor (0.5,0.5) focus_mask "gui/button/button_mask.png" # and Jump("last_scene")
#         imagebutton auto "gui/button/mapbutton_%s.png" action Jump("scene_map") area (201,0,80,80) anchor (0.5,0.5) focus_mask "gui/button/button_mask.png"
#         add "gui/button/invenbutton_hover.png" pos (124,0) anchor (0.5,0.5)
#         # imagebutton auto "gui/button/mapbutton_%s.png" action NullAction() area (15,0,80,80) anchor (0.5,0.5)
#
#     # PLAYER INFORMATION
#     frame:
#         style "inventory_frame"
#         xpos 288
#         ypos 32
#         minimum (352,160)
#         maximum (352,160)
#         hbox:
#             frame:
#                 style "inventory_frame"
#                 margin (32,32)
#                 minimum (160,160)
#                 maximum (160,160)
#                 text "IMAGE" size 15 xalign 0.5 yalign 0.5
#             vbox:
#                 yalign 0.5
#                 text pc.profile['Name'] color "#707070"
#                 text "[pc.level]" color "#707070"
#                 text "[pc.hp]/[pc.max_hp]" color "#707070"
#                 text "[pc.libido]/[pc.max_libido]" color "#707070"
#     # PLAYER GENERIC INFO
#     frame:
#         style "inventory_frame"
#         style_prefix "basic"
#         xpos 288
#         ypos 192
#         minimum (352,48)
#         maximum (352,48)
#         padding (32,16)
#         $ _h = pc.profile['Height']
#         $ _w = pc.profile['Weight']
#         text pc.profile['Race'] + " / "  + pc.profile['Gender'] + " /  [_h] inches / [_w] lbs" size 16 xalign 0.5 color "#707070"
#     # PLAYER STATS
#     frame:
#         style "inventory_frame"
#         style_prefix "basic"
#         xpos 288
#         ypos 240
#         minimum (352,160)
#         maximum (352,160)
#         padding (32,32)
#
#         hbox:
#             spacing 16
#             yalign 0.5
#             xalign 0.5
#             vbox:
#                 style "basic_text"
#                 spacing 3
#                 text "Survival" xalign 0 color "#707070"
#                 text "Combat" xalign 0 color "#707070"
#                 text "Acumen" xalign 0 color "#707070"
#                 text "Glamour" xalign 0 color "#707070"
#             vbox:
#                 spacing 3
#                 text "[pc.survival]" xalign 1 color "#707070"
#                 text "[pc.combat]" xalign 1 color "#707070"
#                 text "[pc.acumen]" xalign 1 color "#707070"
#                 text "[pc.glamour]" xalign 1 color "#707070"
#             vbox:
#                 spacing 3
#                 text "Attack" xalign 0 color "#707070"
#                 text "Flirt" xalign 0 color "#707070"
#                 text "Defense" xalign 0 color "#707070"
#                 text "Resistance" xalign 0 color "#707070"
#             vbox:
#                 spacing 3
#                 $ c = ""
#                 for i in pc.attack:
#                     if isinstance(i,d6):
#                         $ c = c + i.name
#                 text c xalign 0 color "#707070"
#                 $ c = ""
#                 for i in pc.flirt:
#                     if isinstance(i,d6):
#                         $ c = c + i.name
#                 text c xalign 0 color "#707070"
#                 $ c = ""
#                 for i in pc.defense:
#                     if isinstance(i,d6):
#                         $ c = c + i.name
#                 text c xalign 0 color "#707070"
#                 $ c = ""
#                 for i in pc.resistance:
#                     if isinstance(i,d6):
#                         $ c = c + i.name
#                 text c xalign 0 color "#707070"
#     # PLAYER EQUIPMENT
#     frame:
#         style "inventory_frame"
#         xpos 288
#         ypos 400
#         minimum (352,288)
#         maximum (352,288)
#         hbox:
#             vbox:
#                 xpos 64
#                 ypos 0
#                     # button:
#                     # if pc.hands['Right'] != None:
#                     #     action Function(pc.hands['Right'].unequip)
#                 frame:
#                     style "inventory_frame"
#                     # xpos 64
#                     ypos 80
#                     minimum (64,64)
#                     maximum (64,64)
#                     button:
#                         if pc.hands['Right'] != None:
#                             action SetVariable("selected_item",pc.hands['Right'])
#                     if pc.hands['Right'] != None:
#                         text pc.hands['Right'].name size 12 xalign 0.5 yalign 0.5
#                     else:
#                         text "WEAPON" size 12 xalign 0.5 yalign 0.5 color "#707070"
#
#                 frame:
#                     style "inventory_frame"
#                     # xpos 64
#                     ypos 128
#                     minimum (64,64)
#                     maximum (64,64)
#                     button:
#                         if pc.equipment['Acc'] != None:
#                             action SetVariable("selected_item",pc.equipment['Acc'])
#                     if pc.equipment['Acc'] != None:
#                         text pc.equipment['Acc'].name size 12 xalign 0.5 yalign 0.5
#                     else:
#                         text "RING" size 12 xalign 0.5 yalign 0.5 color "#707070"
#             vbox:
#                 xpos 80
#                 ypos 0
#                 frame:
#                     style "inventory_frame"
#                     # xpos 144
#                     ypos 32
#                     minimum (64,64)
#                     maximum (64,64)
#                     button:
#                         if pc.equipment['Head'] != None:
#                             action SetVariable("selected_item",pc.equipment['Head'])
#                     if pc.equipment['Head'] != None:
#                         text pc.equipment['Head'].name size 12 xalign 0.5 yalign 0.5
#                     else:
#                         text "HEAD" size 12 xalign 0.5 yalign 0.5 color "#707070"
#                 frame:
#                     style "inventory_frame"
#                     # xpos 144
#                     ypos 48
#                     minimum (64,64)
#                     maximum (64,64)
#                     button:
#                         if pc.equipment['Chest'] != None:
#                             action SetVariable("selected_item",pc.equipment['Chest'])
#                     if pc.equipment['Chest'] != None:
#                         text pc.equipment['Chest'].name size 12 xalign 0.5 yalign 0.5
#                     else:
#                         text "TORSO" size 12 xalign 0.5 yalign 0.5 color "#707070"
#                 frame:
#                     style "inventory_frame"
#                     # xpos 144
#                     ypos 64
#                     minimum (64,64)
#                     maximum (64,64)
#                     button:
#                         if pc.equipment['Legs'] != None:
#                             action SetVariable("selected_item",pc.equipment['Legs'])
#                     if pc.equipment['Legs'] != None:
#                         text pc.equipment['Legs'].name size 12 xalign 0.5 yalign 0.5
#                     else:
#                         text "LEGS" size 12 xalign 0.5 yalign 0.5 color "#707070"
#             vbox:
#                 xpos 96
#                 ypos 0
#                 frame:
#                     style "inventory_frame"
#                     # xpos 228
#                     ypos 80
#                     minimum (64,64)
#                     maximum (64,64)
#                     button:
#                         if pc.hands['Left'] != None:
#                             action SetVariable("selected_item",pc.hands['Left'])
#                     if pc.hands['Left'] != None:
#                         text pc.hands['Left'].name size 12 xalign 0.5 yalign 0.5
#                     else:
#                         text "SHIELD" size 12 xalign 0.5 yalign 0.5 color "#707070"
#                 frame:
#                     style "inventory_frame"
#                     # xpos 228
#                     ypos 128
#                     minimum (64,64)
#                     maximum (64,64)
#                     button:
#                         if pc.equipment['Boots'] != None:
#                             action SetVariable("selected_item",pc.equipment['Boots'])
#                     if pc.equipment['Boots'] != None:
#                         text pc.equipment['Boots'].name size 12 xalign 0.5 yalign 0.5
#                     else:
#                         text "BOOTS" size 12 xalign 0.5 yalign 0.5 color "#707070"
#     # INVENTORY LABEL
#     frame:
#         style "inventory_frame"
#         xpos 640
#         ypos 32
#         minimum (128,80)
#         maximum (128,80)
#
#         text "ITEMS" yalign 0.5 xalign 0.5 size 32 color "#707070"
#     # INVENTORY ACTION BUTTONS
#     frame:
#         style "inventory_frame"
#         xpos 768
#         ypos 32
#         minimum (352,80)
#         maximum (352,80)
#         xpadding 16
#         hbox:
#             yalign 0.5
#             spacing 8
#             if selected_item != None:
#                 if isinstance(inventory[selected_item][0], Consumable):
#                     button:
#                         action Function(inventory[selected_item][0].useItem, pc)
#                         frame:
#                             padding (16,16)
#                             style "inventory_frame"
#                             minimum (32,32)
#                             text "Consume" size 16 color "#707070"
#                     button:
#                         frame:
#                             padding (16,16)
#                             style "inventory_frame"
#                             minimum (32,32)
#                             text "Discard" size 16 color "#707070"
#                 elif isinstance(inventory[selected_item][0], Weapon):
#                     button:
#                         if inventory[selected_item][0].is_equipped:
#                             action Function(inventory[selected_item][0].unequip)
#                         else:
#                             action Function(inventory[selected_item][0].equip, pc)
#                         frame:
#                             padding (16,16)
#                             style "inventory_frame"
#                             minimum (32,32)
#                             if inventory[selected_item][0].is_equipped:
#                                 text "Unequip" size 16 color "#707070"
#                             else:
#                                 text "Equip" size 16 color "#707070"
#                     button:
#                         frame:
#                             padding (16,16)
#                             style "inventory_frame"
#                             minimum (32,32)
#                             text "Discard" size 16 color "#707070"
#                 elif isinstance(inventory[selected_item][0], Armor):
#                     button:
#                         if inventory[selected_item][0].is_equipped:
#                             action Function(inventory[selected_item][0].unequip)
#                         else:
#                             action Function(inventory[selected_item][0].equip, pc)
#
#                         frame:
#                             padding (16,16)
#                             style "inventory_frame"
#                             minimum (32,32)
#                             if inventory[selected_item][0].is_equipped:
#                                 text "Unequip" size 16 color "#707070"
#                             else:
#                                 text "Equip" size 16 color "#707070"
#                     button:
#                         frame:
#                             padding (16,16)
#                             style "inventory_frame"
#                             minimum (32,32)
#                             text "Discard" size 16 color "#707070"
#                 else:
#                     button:
#                         frame:
#                             padding (16,16)
#                             style "inventory_frame"
#                             minimum (32,32)
#                             text "Discard" size 16 color "#707070"
#     # DESCRIPTION
#     frame:
#         style "inventory_frame"
#         xpos 640
#         ypos 112
#         minimum (480,128)
#         maximum (480,128)
#         padding (32,32)
#         hbox:
#             if selected_item != None:
#                 if isinstance(inventory[selected_item][0], Consumable):
#                     text "Consumable" size 16 color "#707070"
#                 elif isinstance(inventory[selected_item][0], Weapon):
#                     text "Weapon" size 16 color "#707070"
#                 elif isinstance(inventory[selected_item][0], Armor):
#                     text "Armor" size 16 color "#707070"
#                 else:
#                     text "Other" size 16 color "#707070"
#     # INVENTORY LIST
#     frame:
#         style "inventory_frame"
#         xpos 640
#         ypos 240
#         minimum (480,448)
#         maximum (480,448)
#         padding (32,32)
#         side "l":
#             area (16,16,480,448)
#             viewport id "inventory_scroller":
#                 draggable True
#                 mousewheel True
#                 # yinitial 0.0 - 1.0 determines if the scroll bar is at the top or bottom of the list
#
#                 vbox:
#                     $ i = 0
#                     for i in range(len(inventory)):
#                         $ item = inventory[i][0]
#                         $ amo = inventory[i][1]
#                         button:
#                             action SetVariable("selected_item",i)
#                             hbox:
#                                 xminimum 400
#                                 yminimum 32
#                                 # box_wrap True
#                                 frame:
#                                     style "inventory_frame"
#                                     minimum (32,32)
#                                     maximum (32,32)
#                                 hbox:
#                                     xminimum 150
#                                     if isinstance(item,Equipable):
#                                         if item.is_equipped:
#                                             $ c = "#606060"
#                                         else:
#                                             $ c = "#999999"
#                                     else:
#                                         $ c = "#999999"
#                                     text item.name size 16 yalign 0.5 xalign 0.0 color c xpos 0.0
#
#                                 hbox:
#                                     xminimum 75
#                                     if isinstance(item, Weapon):
#                                         text "Weapon" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
#                                     elif isinstance(item, Consumable):
#                                         text "Consumable" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
#                                     elif isinstance(item, Ingredient):
#                                         text "Ingredient" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
#                                     elif isinstance(item, Armor):
#                                         text "Equipment" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
#                                     else:
#                                         text "--------" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
#                                 hbox:
#                                     xminimum 50
#                                     text "[amo]/[item.max_amount]" size 16 yalign 0.5 xalign 1.0 color c xpos 1.0
#                             # style "inventory_frame"
#                             # text item.name
#         vbar value YScrollValue ("inventory_scroller")
