﻿init python:
    class Skill:
        def __init__(self,img,name,description,funct,stam,type):
            self.img = img
            self.name = name
            self.description = description
            self.funct = funct  # The function to trigger when the skill is used
            self.stam = stam    # How much Stamina the skill requires
            self.type = type    # Type is a string containing the type of attack. Used to determine physical, lust, both, special, buff, debuff

        def skill_priority(self,user,target):
            # Skill Priority checks the current state of the user and target and provides a priority for the use of that skill
            # Skill priority is a value between 0 and 10
            # Set Strike Priority
            _check_condition = False
            if isinstance(user,Hostile):
                _check_condition = True

            # STRIKE --------------------------------------------------------------------------------------------
            if self.name == "Strike":
                if _check_condition:
                    if user.condition == "Bold":
                        return 4
                    elif user.condition == "Angry":
                        return 5
                    else:
                        return 3
                else:
                    return 3
            # FLIRT ---------------------------------------------------------------------------------------------
            elif self.name == "Flirt":
                # If collared
                if user.equipment['Acc'] != None and user.equipment['Acc'].id_key == item_magic_collar.id_key:
                    return renpy.random.choice(0,0,0,1)
                else:
                    _bonus = 0
                    if user.libido > user.max_libido/2:
                        _bonus = 1
                    if _check_condition:
                        if user.condition == "Aroused" or user.condition == "Submissive":
                            return 2 + _bonus
                    return 1 + _bonus
            # REST ----------------------------------------------------------------------------------------------
            elif self.name == "Rest":
                if user.condition == "Melancholy":
                    return 10 - (2 * user.stamina)
                else:
                    return 8 - (2 * user.stamina)
            # POWER WORD KILL -----------------------------------------------------------------------------------
            elif self.name == "Power Word Kill":
                return 10
            else:
                return 0

    def use_skill(act,user,target):
        # Finds the function and triggers it
        user.stamina -= act.stam
        func = act.funct
        return func(user,target)

    # These function are skills, they are called upon use
    # skills take the user and target as parameters

    # strike is a basic attack that deals damage to the target based on the user's attack dice
    # strike returns the total damage dealt
    def strike(user,target):
        # Check to hit
        # Compare User Combat skill to the target's Survival skill.
        # If the Combat skill is within 2 points of the Survival skill roll 1d6. Missing on a 1
        # If the Combat skill is less than Survival - 2 roll 2d6 taking the lowest
        # If the Combat skill is higher than Survival + 2 roll 2d6 taking the highest
        # If the Combat skills is twice or more then the Survival skill roll 3d6 taking the highest
        _hit = False
        if user.combat > target.survival*2:
            if standd6.roll()[0] > 1 or standd6.roll()[0] > 1 or standd6.roll()[0] > 1:
                _hit = True
        elif user.combat > target.survival + 2:
            if standd6.roll()[0] > 1 or standd6.roll()[0] > 1:
                _hit = True
        elif user.combat < target.survival - 2:
            if standd6.roll()[0] > 1 and standd6.roll()[0] > 1:
                _hit = True
        else:
            if standd6.roll()[0] > 1:
                _hit = True

        if _hit:
            _dmg = 0
            for _i in user.attack:
                _dmg += _i.roll()[0]
            # for i in range(int(user.combat/4)):
            #     _dmg += greenDice.roll()[0]

            _res = target.rollDefense()

            _dmg -= _res
            if _dmg > 0:
                target.addHP(_dmg * -1)
            else:
                _dmg = 0

            _wea = "fists"
            if user.hands['Right'] != None:
                _wea = user.hands['Right'].name
            _ret = str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " with their " + str(_wea) + " dealing " + str(_dmg) + " damage."
        else:
            _ret = str(user.profile["Name"]) + " missed " + str(target.profile['Name']) + " dealing no damage."

        return _ret

    # Flirt rolls the players base flirt damage based on equipment and weapons.
    # Flirt also increases the user's libido by one gray dice
    # Add one Green dice per 4 points in Glamour
    def flirt(user,target):
        # Roll libido damage
        _dmg = 0
        # for i in user.flirt:
        #     _dmg += i.roll()[0]
        for i in range(int(user.glamour/4)):
            _dmg += greenDice.roll()[0]

        # Roll enemy resistance
        _res = target.rollResist()

        _dmg -= _res
        if _dmg > 0:
            target.addLibido(_dmg)
        else:
            _dmg = 0

        # Increase user libido
        user.addLibido(grayDice.roll()[0])

        _ret = str(user.profile["Name"]) + " winked seductively at " + str(target.profile['Name']) + ". " + str(target.profile['Name']) + "'s libido increased by " + str(_dmg) + "."

        return _ret

    def rest(user,target):
        _dmg = purpleDice.roll()[0]
        user.stamina += _dmg
        if user.stamina > user.max_stamina:
            user.stamina = user.max_stamina

        _ret = str(user.profile["Name"]) + " rested for a moment, recovering " + str(_dmg) + " stamina."

        return _ret

    def struggle(user,target):
        _def = target.rollDefense()
        if user.combat < 8:
            _dmg = purpleDice.roll()[0]
        elif user.combat < 12:
            _dmg = blueDice.roll()[0]
        else:
            _dmg = goldDice.roll()[0]

        _dmg -= _def
        if _dmg < 0:
            _dmg = 0

        target.hp -= _dmg
        if target.hp < 0:
            target.hp = 0

        user.hp -= grayDice.roll()[0]

        _ret = str(user.profile["Name"]) + " struggled desperately."

        return _ret

    def pierce(user,target):
        # Requires 1 stamina
        # Add a red dice to damage

        # Check to hit
        # Compare User Combat skill to the target's Survival skill.
        # If the Combat skill is within 2 points of the Survival skill roll 1d6. Missing on a 1
        # If the Combat skill is less than Survival - 2 roll 2d6 taking the lowest
        # If the Combat skill is higher than Survival + 2 roll 2d6 taking the highest
        # If the Combat skills is twice or more then the Survival skill roll 3d6 taking the highest

        # If the attacker is wielding a pierce weapon reduce target defense by the number of surges on the dice.
        _hit = False
        if user.combat > target.survival*2:
            if standd6.roll()[0] > 1 or standd6.roll()[0] > 1 or standd6.roll()[0] > 1:
                _hit = True
        elif user.combat > target.survival + 2:
            if standd6.roll()[0] > 1 or standd6.roll()[0] > 1:
                _hit = True
        elif user.combat < target.survival - 2:
            if standd6.roll()[0] > 1 and standd6.roll()[0] > 1:
                _hit = True
        else:
            if standd6.roll()[0] > 1:
                _hit = True

        if _hit:
            _sur = 0
            _dmg = 0
            for _i in user.attack:
                _x = _i.roll()
                _dmg += _x[0]
                if _x[1]:
                    _sur += 1

            _x = redDice.roll()
            _dmg += _x[0]
            if _x[1]:
                _sur += 1

            _res = target.rollDefense()
            # Check if wielding a pierce weapon
            if user.hands['Right'] != None:
                if user.hands['Right'].pierce:
                    _res -= _sur

            if _res < 0:
                _res = 0

            _dmg -= _res
            if _dmg > 0:
                target.addHP(_dmg * -1)
            else:
                _dmg = 0

            _wea = "fists"
            if user.hands['Right'] != None:
                _wea = user.hands['Right'].name
            _ret = str(user.profile["Name"]) + " struck " + str(target.profile['Name']) + " with their " + str(_wea) + " dealing " + str(_dmg) + " damage."
        else:
            _ret = str(user.profile["Name"]) + " missed " + str(target.profile['Name']) + " dealing no damage."

        return _ret

    # Power Word Skills used for narrative purposes
    def pw_kill(user,target):
        target.addHP(target.max_hp * -99)
        _ret = str(user.profile["Name"]) + " completely overwhelms " + str(target.profile['Name']) + " with vicious assault."

        return _ret
