init python:
    class Buff:
        APHRO = 0;
        REGEN = 1;
        HEALT = 2;
        SILVE = 3;
        STURD = 4;
        POISO = 5;
        CURSE = 6;

    class Mob:
        def __init__(self, hp, libido, stamina, survival, combat, acumen, glamour,name,race,gender,hei,wei):
            self.hp = hp
            self.max_hp = hp
            self.libido = libido
            self.max_libido = libido
            self.stamina = stamina
            self.max_stamina = stamina
            self.survival = survival
            self.combat = combat
            self.acumen = acumen
            self.glamour = glamour
            self.level = survival + combat + acumen + glamour - 15
            self.base_attack = [greenDice]
            self.base_flirt = [greenDice]
            self.base_defense = [whiteDice]
            self.base_resistance = [whiteDice]
            self.attack = []
            self.flirt = []
            self.defense = []
            self.resistance = []
            ## Buff Name, Is Tier 2, Duration
            ## Name Accessor buff[x][0]
            ## Tier Accessor buff[x][1]
            ## Dura Accessor buff[x][2]
            ## When duration hits 0, set Tier to false
            self.buff = [[Buff.APHRO,False,0],[Buff.REGEN,False,0],[Buff.HEALT,False,0],[Buff.SILVE,False,0],[Buff.STURD,False,0],[Buff.POISO,False,0],[Buff.CURSE,False,0]]
            ## General purpose information with little or no mechanical influence
            self.profile = {'Name' : name, 'Race' : race, 'Gender' : gender, 'Height' : hei, 'Weight' : wei}
            ## Weapons
            self.hands = {'Right' : None, 'Left' : None}
            ## Equipment
            self.equipment = {'Chest' : None, 'Legs' : None, 'Boots' : None, 'Head' : None, 'Acc' : None}
            ## Skills
            self.skills = [skill_strike, skill_flirt, None, None, None,None]

        def addHP(self,amount):
            self.hp += amount
            if self.hp > self.max_hp:
                self.hp = self.max_hp
            elif self.hp < 0:
                self.hp = 0

        def addLibido(self,amount):
            self.libido += amount
            if self.libido > self.max_libido:
                self.libido = self.max_libido
            elif self.libido < 0:
                self.libido = 0

        # rollAttack returns a list of die faces and surges
        def rollAttack(self,_h):
            _dice = []
            o = 0
            for o in range(_h):
                for i in self.attack:
                    _dice.append(d6.roll(i))
            return _dice

        # Returns total damage
        def rollDamage(self,_hit,_crit):
            _dmg = 0
            _d = self.rollAttack(_hit)
            o = 0
            for o in _d:
                _dmg += o[0]
            _d = self.rollAttack(_crit)
            o = 0
            for o in _d:
                _dmg += o[0]
            return _dmg

        # Returns total damage
        def rollDefense(self):
            _defense = 0
            for o in self.defense:
                _d = d6.roll(o)
                _defense += _d[0] * 2
            return _defense

        # rollAttack returns a list of die faces and surges
        def rollFlirt(self,_h):
            _dice = []
            o = 0
            for o in range(_h):
                for i in self.flirt:
                    _dice.append(d6.roll(i))
            return _dice

        # Returns total lust increase
        def rollLust(self,_hit,_crit):
            _dmg = 0
            _d = self.rollFlirt(_hit)
            o = 0
            for o in _d:
                _dmg += o[0]
            _d = self.rollFlirt(_crit)
            o = 0
            for o in _d:
                _dmg += o[0]
            return _dmg

        # Returns total damage
        def rollResist(self):
            _resist = 0
            for o in self.resistance:
                _d = d6.roll(o)
                _resist += _d[0] * 2
            return _resist

        ## Add a buff to the player
        ## Tier 2 buffs override existing buffs of lower tier
        ## Refresh existing buff durations
        ## Add new buffs
        def addBuff(self,buff,tier,duration):
            ## Search for target buff
            for ind in range(len(self.buff)):
                if self.buff[ind][0] == buff:
                    self.buff[ind][1] = tier
                    self.buff[ind][2] = duration
                    ind = len(self.buff)

        def equip_weapon(self,weapon):
            ## Does the weapon require 2 slots
            if weapon.slot == 'Both':
                if self.hands['Right'] != None:
                    self.hands['Right'].unequip()
                if self.hands['Left'] != None:
                    self.hands['Left'].unequip()
                self.hands['Right'] = weapon
                self.hands['Left'] = None
            # Check if wielding a 2 handed weapon
            elif self.hands['Right'] != None and self.hands['Right'].slot == 'Both':
                self.hands['Right'].unequip()
                self.hands[weapon.slot] = weapon
            # The weapon requires 1 slot
            else:
                if self.hands[weapon.slot] != None:
                    self.hands[weapon.slot].unequip()
                self.hands[weapon.slot] = weapon

            self.update_all()

        def unequip_weapon(self,slot):
            if slot == 'Both':
                self.hands['Right'] = None
                self.hands['Left'] = None
            else:
                self.hands[slot] = None

            self.update_all()

        def equip_armor(self,equipment,slot):
            if self.equipment[slot] != None:
                self.unequip_armor(slot)
            self.equipment[slot] = equipment

            self.update_all()

        def unequip_armor(self,slot):
            if self.equipment[slot] != None:
                self.equipment[slot] = None

            self.update_all()

        def update_attack(self):
            self.attack = []
            if self.hands['Right'] != None:
                if self.hands['Right'].damage != None:
                    self.attack += self.hands['Right'].damage
            if self.hands['Left'] != None:
                if self.hands['Left'].damage != None:
                    self.attack += self.hands['Left'].damage

            if self.equipment['Chest'] != None:
                if self.equipment['Chest'].damage != None:
                    self.damage += self.equipment['Chest'].damage
            if self.equipment['Legs'] != None:
                if self.equipment['Legs'].damage != None:
                    self.damage += self.equipment['Legs'].damage
            if self.equipment['Acc'] != None:
                if self.equipment['Acc'].damage != None:
                    self.damage += self.equipment['Acc'].damage

            if self.hands['Right'] == self.hands['Left'] == None:
                self.attack += self.base_attack
            elif self.attack == []:
                self.attack += self.base_attack

        def update_flirt(self):
            self.flirt = []
            if self.hands['Right'] != None:
                if self.hands['Right'].lust != None:
                    self.flirt += self.hands['Right'].lust
            if self.hands['Left'] != None:
                if self.hands['Left'].lust != None:
                    self.flirt += self.hands['Left'].lust

            if self.equipment['Chest'] != None:
                if self.equipment['Chest'].lust != None:
                    self.lust += self.equipment['Chest'].lust
            if self.equipment['Legs'] != None:
                if self.equipment['Legs'].lust != None:
                    self.lust += self.equipment['Legs'].lust
            if self.equipment['Acc'] != None:
                if self.equipment['Acc'].lust != None:
                    self.lust += self.equipment['Acc'].lust

            if self.hands['Right'] == self.hands['Left'] == None:
                self.flirt += self.base_flirt
            elif self.flirt == []:
                self.flirt += self.base_flirt

        def update_defense(self):
            self.defense = []
            self.defense += self.base_defense
            if self.equipment['Chest'] != None:
                if self.equipment['Chest'].defense != None:
                    self.defense += self.equipment['Chest'].defense
            if self.equipment['Legs'] != None:
                if self.equipment['Legs'].defense != None:
                    self.defense += self.equipment['Legs'].defense
            if self.equipment['Acc'] != None:
                if self.equipment['Acc'].defense != None:
                    self.defense += self.equipment['Acc'].defense
            if self.hands['Right'] != None:
                if self.hands['Right'].defense != None:
                    self.defense += self.hands['Right'].defense
            if self.hands['Left'] != None:
                if self.hands['Left'].defense != None:
                    self.defense += self.hands['Left'].defense

        def update_resistance(self):
            self.resistance = []
            self.resistance += self.base_resistance
            if self.equipment['Chest'] != None:
                if self.equipment['Chest'].res != None:
                    self.resistance += self.equipment['Chest'].res
            if self.equipment['Legs'] != None:
                if self.equipment['Legs'].res != None:
                    self.resistance += self.equipment['Legs'].res
            if self.equipment['Acc'] != None:
                if self.equipment['Acc'].res != None:
                    self.resistance += self.equipment['Acc'].res
            if self.hands['Right'] != None:
                if self.hands['Right'].res != None:
                    self.resistance += self.hands['Right'].res
            if self.hands['Left'] != None:
                if self.hands['Left'].res != None:
                    self.resistance += self.hands['Left'].res

        def update_all(self):
            self.update_attack()
            self.update_defense()
            self.update_flirt()
            self.update_resistance()

        ## Turn begin buffs and debuffs
        def turn_begin_update(self):
            # Check Accessories for buffs
            if isinstance(self.equipment['Acc'],Armor):
                for _i in self.equipment['Acc'].boon:
                    # Curse reduces libido by 1
                    # If Libido is at 0 do something
                    if _i == Buff.CURSE:
                        self.addLibido(-1)
            return None

    class Hostile(Mob):
        def __init__(self, sprite, hp, libido, stamina, survival, combat, acumen, glamour, name, race, gender, hei, wei, base_attack, base_flirt, base_defense, base_resistance,
        sk_1,sk_2,sk_3,sk_4,sk_5,sk_6,condition):
            Mob.__init__(self,hp,libido,stamina,survival,combat,acumen,glamour,name,race,gender,hei,wei)
            self.sprite = sprite
            self.libido = 0
            self.attack = []
            self.base_attack = base_attack
            self.attack += base_attack
            self.flirt = []
            self.base_flirt = base_flirt
            self.flirt += base_flirt
            self.defense = []
            self.base_defense = base_defense
            self.defense += base_defense
            self.resistance = []
            self.base_resistance = base_resistance
            self.resistance += base_resistance
            self.condition = condition # Condition is the emotional state of the monster, modifies how they act in combat. Condition is a string
            # "Angry" - Increased chance of aggressive action. Less likely to submit or flee
            # "Melancholy" - Decreased chance of aggressive action. More likely to submit or flee
            # "Cowardly" - Greatly increased chance of fleeing or submitting
            # "Bold" - Greatly decreased chance of fleeing or submitting
            # "Aroused" - Starts with increased libido and is more likely to flirt
            # "Submissive" - More likely to submit in combat
            # "" - No modifier, standard enemy

            ## Weapons
            self.hands = {'Right' : None, 'Left' : None}
            ## Equipment
            self.equipment = {'Chest' : None, 'Legs' : None, 'Acc' : None}
            ## Skills
            self.skills = [sk_1, sk_2, sk_3, sk_4, sk_5, sk_6]
