init python:
    class InventoryItem:
        def __init__(self,id_key,img,val,name,desc,max_amount):
            self.id_key = id_key
            self.img = img
            self.val = val
            self.name = name
            self.max_amount = max_amount
            self.description = desc

    def getName(it):
        return it[0].name
    def getIdKey(it):
        return it[0].id_key

    def getEquipInInventory(it):
        for _i in range(len(store.inventory)-1):
            if store.inventory[_i][0] == it:
                return _i

    def sortInventory(how):
        # How determines what way the inventory should be sorted.
        # 1 Alphabetically
        # 2 id_key
        # 3 Amount
        if how == 1:
            store.inventory.sort(key=getName)
        if how == 2:
            store.inventory.sort(key=getIdKey)

    def addToInventory(item,amo):
        i = 0
        added = False
        while i in range(len(store.inventory)) and not added:
            # If it's the same item being added, see if that item already exists in the inventory
            # If the item exists increase the amount
            # Else add a new slot for the item
            if item.id_key == store.inventory[i][0].id_key:
                # Check if there is available space in this inventory slot
                if store.inventory[i][1] < item.max_amount:
                    store.inventory[i][1] += amo
                    if store.inventory[i][1] > item.max_amount:
                        a = store.inventory[i][1] - item.max_amount
                        store.inventory[i][1] = item.max_amount
                        if isinstance(item, Weapon):
                            store.inventory.append([Weapon(item.id_key,item.img,item.val,item.name,item.description,item.locked,item.slot,item.damage,item.lust,
                            item.defense,item.res,item.type,item.tier),a])
                        elif isinstance(item, Armor):
                            store.inventory.append([Armor(item.id_key,item.img,item.val,item.name,item.description,item.locked,item.slot,item.damage,item.lust,
                            item.defense,item.res,item.boon,item.tier),a])
                        elif isinstance(item, Consumable):
                            store.inventory.append([Consumable(item.id_key,item.img,item.val,item.name,item.description,item.max_amount,item.hp_gain,item.hp_damage,item.libido_gain,item.libido_damage,item.buff_1,
                            item.tier_1,item.dur_1,item.buff_2,item.tier_2,item.dur_2,item.buff_3,item.tier_3,item.dur_3),a])
                        elif isinstance(item, Ingredient):
                            store.inventory.append([Ingredient(item.id_key,item.img,item.val,item.name,item.description,item.max_amount,item.hp_gain,item.hp_damage,item.libido_gain,item.libido_damage,
                            item.buff_1,item.buff_2),a])
                        else:
                            store.inventory.append([InventoryItem(item.id_key,item.img,item.val,item.name,item.description,item.max_amount),a])

                    added = True
            i += 1
        if not added:
            i = amo
            while i > 0:
                if i > item.max_amount:
                    if isinstance(item, Weapon):
                        store.inventory.append([Weapon(item.id_key,item.img,item.val,item.name,item.description,item.locked,item.slot,item.damage,item.lust,
                        item.defense,item.res,item.type,item.tier),item.max_amount])
                    elif isinstance(item, Armor):
                        store.inventory.append([Armor(item.id_key,item.img,item.val,item.name,item.description,item.locked,item.slot,item.damage,item.lust,
                        item.defense,item.res,item.boon,item.tier),item.max_amount])
                    elif isinstance(item, Consumable):
                        store.inventory.append([Consumable(item.id_key,item.img,item.val,item.name,item.description,item.max_amount,item.hp_gain,item.hp_damage,item.libido_gain,item.libido_damage,item.buff_1,
                        item.tier_1,item.dur_1,item.buff_2,item.tier_2,item.dur_2,item.buff_3,item.tier_3,item.dur_3),item.max_amount])
                    elif isinstance(item, Ingredient):
                        store.inventory.append([Ingredient(item.id_key,item.img,item.val,item.name,item.description,item.max_amount,item.hp_gain,item.hp_damage,item.libido_gain,item.libido_damage,
                        item.buff_1,item.buff_2),item.max_amount])
                    else:
                        store.inventory.append([InventoryItem(item.id_key,item.img,item.val,item.name,item.description,item.max_amount),item.max_amount])
                    i -= item.max_amount
                else:
                    if isinstance(item, Weapon):
                        store.inventory.append([Weapon(item.id_key,item.img,item.val,item.name,item.description,item.locked,item.slot,item.damage,item.lust,
                        item.defense,item.res,item.type,item.tier),i])
                    elif isinstance(item, Armor):
                        store.inventory.append([Armor(item.id_key,item.img,item.val,item.name,item.description,item.locked,item.slot,item.damage,item.lust,
                        item.defense,item.res,item.boon,item.tier),i])
                    elif isinstance(item, Consumable):
                        store.inventory.append([Consumable(item.id_key,item.img,item.val,item.name,item.description,item.max_amount,item.hp_gain,item.hp_damage,item.libido_gain,item.libido_damage,item.buff_1,
                        item.tier_1,item.dur_1,item.buff_2,item.tier_2,item.dur_2,item.buff_3,item.tier_3,item.dur_3),i])
                    elif isinstance(item, Ingredient):
                        store.inventory.append([Ingredient(item.id_key,item.img,item.val,item.name,item.description,item.max_amount,item.hp_gain,item.hp_damage,item.libido_gain,item.libido_damage,
                        item.buff_1,item.buff_2),i])
                    else:
                        store.inventory.append([InventoryItem(item.id_key,item.img,item.val,item.name,item.description,item.max_amount),i])
                    # inven.append([item,i])
                    i -= i


    class Consumable(InventoryItem):
        def __init__(self,id_key,img,val,name,desc,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,tier_1,dur_1,buff_2,tier_2,dur_2,buff_3,tier_3,dur_3):
            InventoryItem.__init__(self,id_key,img,val,name,desc,max_amount)
            self.hp_gain = hp_gain
            self.hp_damage = hp_damage
            self.libido_gain = libido_gain
            self.libido_damage = libido_damage
            self.buff_1 = buff_1
            self.buff_2 = buff_2
            self.buff_3 = buff_3
            self.tier_1 = tier_1
            self.tier_2 = tier_2
            self.tier_3 = tier_3
            self.dur_1 = dur_1
            self.dur_2 = dur_2
            self.dur_3 = dur_3

        def useItem(self,target):
            # inventory.remove(self)
            # ADD WAY TO REMOVE ITEMS FROM INVENTORY
            target.addHP(self.hp_gain)
            target.addLibido(self.libido_gain)
            target.addBuff(self.buff_1,self.tier_1,self.dur_1)
            target.addBuff(self.buff_2,self.tier_2,self.dur_2)
            target.addBuff(self.buff_3,self.tier_3,self.dur_3)

    class Ingredient(InventoryItem):
        def __init__(self,id_key,img,val,name,desc,max_amount,hp_gain,hp_damage,libido_gain,libido_damage,buff_1,buff_2):
            InventoryItem.__init__(self,id_key,img,val,name,desc,max_amount)
            self.hp_gain = hp_gain
            self.hp_damage = hp_damage
            self.libido_gain = libido_gain
            self.libido_damage = libido_damage
            self.buff_1 = buff_1
            self.buff_2 = buff_2

    class Equipable(InventoryItem):
        def __init__(self,id_key,img,val,name,desc,locked):
            InventoryItem.__init__(self,id_key,img,val,name,desc,1)
            # Locked is used to determine if the item cannot be unequipped
            self.locked = locked
            self.is_equipped = False
            self.equipped_to = None

        def equip(self,target):
            self.is_equipped = True
            self.equipped_to = target

        def unequip(self):
            self.is_equipped = False
            self.equipped_to = None

    class Weapon_Type():
        MISC = 0
        SWORD = 1
        SHIELD = 2
        STAFF = 3
        AXE = 4
        BOOK = 5
        BOW = 6

    class Weapon(Equipable):
        ## Slot = Number of hands it takes to wield 1-2
        ## Damage = Physical damage dice, kept in an array
        ## Lust = Lust damage dice, kept in an array
        ## Defense = Defense dice bonus, kept in an array
        ## Res = Resist libido drain dice bonus, kept in an array
        ## Attacks = number of attacks
        ## Type = Physical, Flirt, Spell
        ## Tier = What tier is this weapon
        def __init__(self,id_key,img,val,name,desc,locked,slot,damage,lust,defense,res,type,tier,heavy=False,pierce=False,reach=False):
            Equipable.__init__(self,id_key,img,val,name,desc,locked)
            self.slot = slot
            self.damage = damage
            self.lust = lust
            self.defense = defense
            self.res = res
            self.type = type
            self.tier = tier
            self.heavy = heavy
            self.pierce = pierce
            self.reach = reach

        def equip(self,target):
            Equipable.equip(self,target)
            target.equip_weapon(self)

        def unequip(self):
            self.equipped_to.unequip_weapon(self.slot)
            Equipable.unequip(self)

    class Armor(Equipable):

        def __init__(self,id_key,img,val,name,desc,locked,slot,damage,lust,defense,res,boon,tier):
            Equipable.__init__(self,id_key,img,val,name,desc,locked)
            self.slot = slot
            self.defense = defense
            self.damage = damage
            self.lust = lust
            self.res = res
            self.tier = tier
            self.boon = []
            self.boon += boon

        def equip(self,target):
            Equipable.equip(self,target)
            target.equip_armor(self,self.slot)

        def unequip(self):
            self.equipped_to.unequip_armor(self.slot)
            Equipable.unequip(self)
