if (!window.$PARAMS) { window.$PARAMS = {} };Object.mixin(window.$PARAMS, {
    "platform": {
        "usePlayStoreExpansionFile": false,
        "gameIdentifier": "com.didiesmeralda.butterflyeffectgames.valentinex3",
        "isSteamOS": false
    },
    "test": false,
    "isOffline": true,
    "uid": "47DE7AB989785840794AB121655EF036B95A",
    "resolution": {
        "width": 1280,
        "height": 720
    },
    "fontFamilies": [
        "Rubik-Regular",
        "Tallys"
    ],
    "needsPreparation": true
});



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=Constants_9.js
// Generated by CoffeeScript 1.12.7
(function() {
  window.$.noConflict();

  window.$ = function(f, data, event) {
    return new ui.Formula(f, data || null, event || null);
  };


  /**
  * Namespace for Visual Novel specific elements.
  * @namespace vn
   */

  window.vn = {};


  /**
  * Namespace for user interface elements.
  * @namespace ui
   */

  window.ui = {};


  /**
  * Namespace for universal elements.
  * @namespace gs
   */

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* Enumeration containing default colors.
*
* @module gs
* @class Colors
* @memberof gs
* @static
* @final
 */

(function() {
  var Colors;

  Colors = (function() {
    function Colors() {}

    Colors.initialize = function() {

      /**
      * Transparent color.
      * @property TRANSPARENT
      * @type gs.Color
      * @static
      * @final
       */
      this.TRANSPARENT = new Color(0, 0, 0, 0);

      /**
      * White color.
      * @property WHITE
      * @type gs.Color
      * @static
      * @final
       */
      this.WHITE = new Color(255, 255, 255);

      /**
      * Black color.
      * @property BLACK
      * @type gs.Color
      * @static
      * @final
       */
      this.BLACK = new Color(0, 0, 0);

      /**
      * Color used for rain-particles (Weather-Effect).
      * @property RAIN_PARTICLE
      * @type gs.Color
      * @static
      * @final
       */
      this.RAIN_PARTICLE = new Color(245, 245, 255);

      /**
      * Color used for storm-particles (Weather-Effect).
      * @property STORM_PARTICLE
      * @type gs.Color
      * @static
      * @final
       */
      this.STORM_PARTICLE = this.RAIN_PARTICLE;

      /**
      * Color used for the face of snow-particles (Weather-Effect).
      * @property SNOW_PARTICLE_FACE
      * @type gs.Color
      * @static
      * @final
       */
      this.SNOW_PARTICLE_FACE = new Color(255, 255, 255);

      /**
      * Color used for the edges of snow-particles (Weather-Effect).
      * @property SNOW_PARTICLE_EDGE
      * @type gs.Color
      * @static
      * @final
       */
      return this.SNOW_PARTICLE_EDGE = new Color(255, 255, 255, 0.5);
    };

    return Colors;

  })();

  Colors.initialize();

  window.Colors = Colors;

  gs.Colors = Colors;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* Enumeration containing default fonts.
*
* @module gs
* @class Fonts
* @memberof gs
* @static
* @final
 */

(function() {
  var Fonts;

  Fonts = (function() {
    function Fonts() {}

    Fonts.initialize = function() {
      var size;
      size = Math.round(9 / 240 * Graphics.height);

      /**
      * Used as default font for text if no font is specified.
      *
      * @property TEXT
      * @type gs.Font
      * @static
      * @final
       */
      this.TEXT = ResourceManager.getFont("Verdana", size);
      this.TRANSPARENT = new Font("Verdana", size);
      return this.TRANSPARENT.color.alpha = 0;
    };

    return Fonts;

  })();

  gs.Fonts = Fonts;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* Enumeration describing the different types of image-handling.
*
* @module gs
* @class ImageHandling
* @extends gs.Component
* @memberof gs
* @static
 */

(function() {
  var ImageHandling;

  ImageHandling = (function() {
    function ImageHandling() {}

    ImageHandling.initialize = function() {

      /**
      * Uses full image-size.
      * @property IMAGE_SIZE
      * @type number
      * @static
      * @final
       */
      this.IMAGE_SIZE = 0;

      /**
      * Uses only half image-height.
      * @property HALF_IMAGE_HEIGHT
      * @type number
      * @static
      * @final
       */
      this.HALF_IMAGE_HEIGHT = 1;

      /**
      * Uses a custom defined source-rectangle.
      * @property CUSTOM_SIZE
      * @type number
      * @static
      * @final
       */
      return this.CUSTOM_SIZE = 2;
    };

    return ImageHandling;

  })();

  ImageHandling.initialize();

  gs.ImageHandling = ImageHandling;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* An enumeration of easing types.
*
* @module gs
* @class EasingTypes
* @memberof gs
* @constructor
* @static
* @final
 */

(function() {
  var EasingTypes;

  EasingTypes = (function() {
    function EasingTypes() {}

    EasingTypes.initialize = function() {

      /**
      * @property EASE_IN
      * @type number
      * @static
      * @final
       */
      this.EASE_IN = 1;

      /**
      * @property EASE_OUT
      * @type number
      * @static
      * @final
       */
      this.EASE_OUT = 0;

      /**
      * @property EASE_IN_OUT
      * @type number
      * @static
      * @final
       */
      this.EASE_IN_OUT = 2;

      /**
      * @property EASE_LINEAR
      * @type number
      * @static
      * @final
       */
      this.EASE_LINEAR = 0;

      /**
      * @property EASE_QUADRATIC
      * @type number
      * @static
      * @final
       */
      this.EASE_QUADRATIC = 1;

      /**
      * @property EASE_CUBIC
      * @type number
      * @static
      * @final
       */
      this.EASE_CUBIC = 2;

      /**
      * @property EASE_QUARTIC
      * @type number
      * @static
      * @final
       */
      this.EASE_QUARTIC = 3;

      /**
      * @property EASE_QUINTIC
      * @type number
      * @static
      * @final
       */
      this.EASE_QUINTIC = 4;

      /**
      * @property EASE_SINUSOIDAL
      * @type number
      * @static
      * @final
       */
      this.EASE_SINUSOIDAL = 5;

      /**
      * @property EASE_EXPONENTIAL
      * @type number
      * @static
      * @final
       */
      this.EASE_EXPONENTIAL = 6;

      /**
      * @property EASE_CIRCULAR
      * @type number
      * @static
      * @final
       */
      this.EASE_CIRCULAR = 7;

      /**
      * @property EASE_ELASTIC
      * @type number
      * @static
      * @final
       */
      this.EASE_ELASTIC = 8;

      /**
      * @property EASE_BOUNCE
      * @type number
      * @static
      * @final
       */
      this.EASE_BOUNCE = 9;

      /**
      * @property EASE_BACK
      * @type number
      * @static
      * @final
       */
      return this.EASE_BACK = 10;
    };

    return EasingTypes;

  })();

  EasingTypes.initialize();

  gs.EasingTypes = EasingTypes;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* Holds different easing types and helper methods.
*
* @module gs
* @class Easings
* @memberof gs
* @constructor
 */

(function() {
  var Easings;

  Easings = (function() {
    function Easings() {}

    Easings.initialize = function() {

      /**
      * Contains all easing functions by type and in/out.
      * @property EASE_FUNCTIONS
      * @type Function[][]
      * @static
      * @final
       */
      this.EASE_FUNCTIONS = [[Math.linearTween, Math.linearTween, Math.linearTween], [Math.easeOutQuad, Math.easeInQuad, Math.easeInOutQuad], [Math.easeOutCubic, Math.easeInCubic, Math.easeInOutCubic], [Math.easeOutQuart, Math.easeInQuart, Math.easeInOutQuart], [Math.easeOutQuint, Math.easeInQuint, Math.easeInOutQuint], [Math.easeOutSine, Math.easeInSine, Math.easeInOutSine], [Math.easeOutExpo, Math.easeInExpo, Math.easeInOutExpo], [Math.easeOutCirc, Math.easeInCirc, Math.easeInOutCirc], [Math.easeOutElastic, Math.easeInElastic, Math.easeInOutElastic], [Math.easeOutBounce, Math.easeInBounce, Math.easeInOutBounce], [Math.easeOutBack, Math.easeInBack, Math.easeInOutBack]];

      /**
      * @property BY_INDEX
      * @type number[][]
      * @static
      * @final
       */
      this.BY_INDEX = [[[0, 0], [0, 0], [0, 0]], [[1, 0], [1, 1], [1, 2]], [[2, 0], [2, 1], [2, 2]], [[3, 0], [3, 1], [3, 2]], [[4, 0], [4, 1], [4, 2]], [[5, 0], [5, 1], [5, 2]], [[6, 0], [6, 1], [6, 2]], [[7, 0], [7, 1], [7, 2]], [[8, 0], [8, 1], [8, 2]], [[9, 0], [9, 1], [9, 2]], [[10, 0], [10, 1], [10, 2]]];

      /**
      * @property BY_STRING
      * @type Object
      * @static
      * @final
       */
      this.BY_STRING = {
        "linear_in": [0, 0],
        "linear_out": [0, 0],
        "linear_inout": [0, 0],
        "quad_out": [1, 0],
        "quad_in": [1, 1],
        "quad_inout": [1, 2],
        "cubic_out": [2, 0],
        "cubic_in": [2, 1],
        "cubic_inout": [2, 2],
        "quart_out": [3, 0],
        "quart_in": [3, 1],
        "quart_inout": [3, 2],
        "quint_out": [4, 0],
        "quint_in": [4, 1],
        "quint_inout": [4, 2],
        "sine_out": [5, 0],
        "sine_in": [5, 1],
        "sine_inout": [5, 2],
        "expo_out": [6, 0],
        "expo_in": [6, 1],
        "expo_inout": [6, 2],
        "circ_out": [7, 0],
        "circ_in": [7, 1],
        "circ_inout": [7, 2],
        "elastic_out": [8, 0],
        "elastic_in": [8, 1],
        "elastic_inout": [8, 2],
        "bounce_out": [9, 0],
        "bounce_in": [9, 1],
        "bounce_inout": [9, 2],
        "back_out": [10, 0],
        "back_in": [10, 1],
        "back_inout": [10, 2]
      };

      /**
      * @property EASE_LINEAR
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_LINEAR = this.BY_INDEX[gs.EasingTypes.EASE_LINEAR];

      /**
      * @property EASE_QUADRATIC
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_QUADRATIC = this.BY_INDEX[gs.EasingTypes.EASE_QUADRATIC];

      /**
      * @property EASE_CUBIC
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_CUBIC = this.BY_INDEX[gs.EasingTypes.EASE_CUBIC];

      /**
      * @property EASE_QUARTIC
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_QUARTIC = this.BY_INDEX[gs.EasingTypes.EASE_QUARTIC];

      /**
      * @property EASE_QUINTIC
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_QUINTIC = this.BY_INDEX[gs.EasingTypes.EASE_QUINTIC];

      /**
      * @property EASE_SINUSOIDAL
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_SINUSOIDAL = this.BY_INDEX[gs.EasingTypes.EASE_SINUSOIDAL];

      /**
      * @property EASE_EXPONENTIAL
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_EXPONENTIAL = this.BY_INDEX[gs.EasingTypes.EASE_EXPONENTIAL];

      /**
      * @property EASE_CIRCULAR
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_CIRCULAR = this.BY_INDEX[gs.EasingTypes.EASE_CIRCULAR];

      /**
      * @property EASE_ELASTIC
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_ELASTIC = this.BY_INDEX[gs.EasingTypes.EASE_ELASTIC];

      /**
      * @property EASE_BOUNCE
      * @type number[][]
      * @static
      * @final
       */
      this.EASE_BOUNCE = this.BY_INDEX[gs.EasingTypes.EASE_BOUNCE];

      /**
      * @property EASE_BACK
      * @type number[][]
      * @static
      * @final
       */
      return this.EASE_BACK = this.BY_INDEX[gs.EasingTypes.EASE_BACK];
    };


    /**
    * @method fromValues
    * @param {number} index - The index.
    * @param {number} inOut - The in-out value.
     */

    Easings.fromValues = function(index, inOut) {
      return gs.Easings.BY_INDEX[index][inOut];
    };


    /**
    * @method fromObject
    * @param {Object} obj - The easing data-object.
     */

    Easings.fromObject = function(obj, flags, defaults) {
      return gs.Easings.BY_INDEX[obj.type][obj.inOut];
    };


    /**
    * @method fromString
    * @param {String} s - The easing string like "quad_in" for example.
     */

    Easings.fromString = function(s) {
      return gs.Easings.BY_STRING[s || "linear_inout"];
    };

    return Easings;

  })();

  Easings.initialize();

  gs.Easings = Easings;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* An enumeration of different dispose behaviors for containers. A dispose
* behavior describes what should happen with objects in a container after
* they got disposed.
*
* @module gs
* @class ContainerDisposeBehavior
* @memberof gs
* @constructor
* @static
* @final
 */

(function() {
  var ContainerDisposeBehavior;

  ContainerDisposeBehavior = (function() {
    function ContainerDisposeBehavior() {}

    ContainerDisposeBehavior.initialize = function() {

      /**
      * Removes the disposed object from the container.
      * @property REMOVE
      * @type number
      * @static
      * @final
       */
      this.REMOVE = 0;

      /**
      * Sets the object reference to <b>null</b> but doesn't removing it from the container so the
      * indices are not changed.
      * @property NULL
      * @type number
      * @static
      * @final
       */
      return this.NULL = 1;
    };

    return ContainerDisposeBehavior;

  })();

  ContainerDisposeBehavior.initialize();

  gs.ContainerDisposeBehavior = ContainerDisposeBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* An enumeration of command field flags.
*
* @module gs
* @class CommandFieldFlags
* @memberof gs
* @constructor
* @static
* @final
 */

(function() {
  var CommandFieldFlags;

  CommandFieldFlags = (function() {
    function CommandFieldFlags() {}

    CommandFieldFlags.initialize = function() {

      /**
      * Indicates if the field is locked and should not be changed.
      * @property LOCKED
      * @type number
      * @static
      * @final
       */
      return this.LOCKED = 1;
    };


    /**
    * Checks if a command field is locked.
    * @method isLocked
    * @static
    * @param {number} flags - Field flags to check.
     */

    CommandFieldFlags.isLocked = function(flags) {
      return flags & CommandFieldFlags.LOCKED;
    };

    return CommandFieldFlags;

  })();

  CommandFieldFlags.initialize();

  gs.CommandFieldFlags = CommandFieldFlags;

}).call(this);



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=UI_99.js
// Generated by CoffeeScript 1.12.7

/**
* An enumeration of different UI object update behaviors.
*
* @module ui
* @class UpdateBehavior
* @memberof ui
* @constructor
* @static
* @final
 */

(function() {
  var UpdateBehavior;

  UpdateBehavior = (function() {
    function UpdateBehavior() {}

    UpdateBehavior.initialize = function() {

      /**
      * The UI object is only updated if necessary. However, there are cases where
      * a necessary update is not detected.
      * @property NORMAL
      * @type number
      * @static
      * @final
       */
      this.NORMAL = 0;

      /**
      * The UI object is updated on every frame.
      * @property CONTINUOUS
      * @type number
      * @static
      * @final
       */
      return this.CONTINUOUS = 1;
    };

    return UpdateBehavior;

  })();

  UpdateBehavior.initialize();

  ui.UpdateBehavior = UpdateBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* An enumeration of different management modes describing how a layout should
* handle its sub-objects coming from a data-source.
*
* @module ui
* @class LayoutManagementMode
* @memberof ui
* @constructor
* @static
* @final
 */

(function() {
  var LayoutManagementMode;

  LayoutManagementMode = (function() {
    function LayoutManagementMode() {}

    LayoutManagementMode.initialize = function() {

      /**
      * All sub-objects are created at setup time.
      * @property NORMAL
      * @type number
      * @static
      * @final
       */
      this.NORMAL = 0;

      /**
      * The sub-objects are created at update time and only those which are currently visible.
      * @property JUST_IN_TIME
      * @type number
      * @static
      * @final
       */
      return this.JUST_IN_TIME = 1;
    };


    /**
    * Gets the constant number value from a specified human-readable string.
    * @method fromString
    * @param {string} s - The management mode as string. Can be "normal" or "just_in_time".
    * @return {number} The constant number value.
    * @static
    * @final
     */

    LayoutManagementMode.fromString = function(s) {
      switch (s) {
        case "normal":
          return 0;
        case "just_in_time":
          return 1;
        default:
          return 0;
      }
    };

    return LayoutManagementMode;

  })();

  LayoutManagementMode.initialize();

  ui.LayoutManagementMode = LayoutManagementMode;

}).call(this);



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=Sprites_16.js
// Generated by CoffeeScript 1.12.7
(function() {
  var Sprite_Debug,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Sprite_Debug = (function(superClass) {
    extend(Sprite_Debug, superClass);


    /**
    * Sprite to display debug information on screen. <b>HINT:</b> Will be probably removed
    * before release.
    *
    * @module gs
    * @class Sprite_Debug
    * @extends gs.Sprite
    * @memberof gs
    * @static
     */

    function Sprite_Debug(viewport) {
      var size;
      Sprite_Debug.__super__.constructor.call(this, viewport);

      /**
      * @property frameTime
      * @type number|string
      * The time / time-text to display.
       */
      this.frameTime = 0;
      size = Math.round(8 / 240 * Graphics.height);
      this.bitmap = new Bitmap(180 * Graphics.scale, 28 * Graphics.scale);
      this.bitmap.font = new Font("Verdana", size);
      this.bitmap.font.color = Color.WHITE;
      this.srcRect = new Rect(0, 0, this.bitmap.width, this.bitmap.height);
      this.z = 15000;
      this.opacity = 255;
      this.visible = true;
      this.x = 0;
      this.y = 0;
    }

    Sprite_Debug.prototype.redraw = function() {
      this.bitmap.clear();
      return this.bitmap.drawText(0, 0, this.bitmap.width, this.bitmap.height, this.frameTime.toString(), 0, 0);
    };

    return Sprite_Debug;

  })(Sprite);

  window.Sprite_Debug = Sprite_Debug;

}).call(this);



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=Managers_40.js
// Generated by CoffeeScript 1.12.7
(function() {
  var ObjectManager;

  ObjectManager = (function() {

    /**
    * Stores the current default ObjectManager.
    * @property current
    * @type gs.ObjectManager
    * @static
     */
    ObjectManager.current = null;


    /**
    * Manages game objects by updating if necessary and offering
    * methods to add or remove game objects. All game objects are sorted by
    * the order-property to give control over the update-order.
    *
    * A game object can registered under a unique ID and then easily accessed using
    * that ID. If an object gets registered, a global variable $<ID> is created
    * as well. However, that global variable is only for the use in property-bindings
    * used for In-Game UI. See ui.Component_BindingHandler.
    *
    * In addition, a game object can be assigned to a group like for example
    * a set of UI toggle-buttons can be assigned to the same group and then
    * easily accessed later using gs.ObjectManager.objectsByGroup method.
    *
    * @module gs
    * @class ObjectManager
    * @memberof gs
    * @constructor
    * @see ui.Component_BindingHandler
     */

    function ObjectManager() {

      /**
      * All game objects to manage.
      * @property objects
      * @type gs.Object_Base[]
       */
      this.objects = [];

      /**
      * All game objects by ID.
      * @property objectsById
      * @type Object
       */
      this.objectsById = {};

      /**
      * All game objects by group.
      * @property objectsByGroup_
      * @type Object
       */
      this.objectsByGroup_ = {};

      /**
      * Indicates if the ObjectManager is active. If <b>false</b> the game objects are not updated.
      * @property active
      * @type boolean
       */
      this.active = true;

      /**
      * Indicates if the ObjectManager needs to sort the game objects.
      * @property active
      * @type boolean
       */
      this.needsSort = true;
    }


    /**
    * Disposes the manager and all assigned game objects.
    *
    * @method dispose
     */

    ObjectManager.prototype.dispose = function() {
      var j, len, object, ref, results;
      ref = this.objects;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        object = ref[j];
        if (!object.disposed) {
          results.push(object.dispose());
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Disposes all assigned game objects.
    *
    * @method disposeObjects
     */

    ObjectManager.prototype.disposeObjects = function() {
      var j, k, keys, len, object, results;
      keys = Object.keys(this.objectsById);
      results = [];
      for (j = 0, len = keys.length; j < len; j++) {
        k = keys[j];
        object = this.objectsById[k];
        if (object && !object.disposed) {
          results.push(object.dispose());
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Registers an object.
    *
    * @method registerObject
     */

    ObjectManager.prototype.registerObject = function(object) {
      if (object.id != null) {
        if (!this.objectsById[object.id]) {
          this.objectsById[object.id] = [];
        }
        this.objectsById[object.id].push(object);
        return window["$" + object.id] = object;
      }
    };


    /**
    * Unregisters an object.
    *
    * @method unregisterObject
     */

    ObjectManager.prototype.unregisterObject = function(object) {
      var objects;
      if ((object != null ? object.id : void 0) != null) {
        objects = this.objectsById[object.id];
        if (objects) {
          objects.remove(object);
          if (objects.length > 0) {
            window["$" + object.id] = objects.last();
          } else {
            delete window["$" + object.id];
          }
        }
      }
      return null;
    };


    /**
    * Adds a game object to the manager. The game object is then automatically updated by the manager.
    *
    * @method addObject
    * @param {gs.Object_Base} object - The game object to add.
     */

    ObjectManager.prototype.addObject = function(object) {
      return this.add(object);
    };


    /**
    * Removes a game object to the manager. The game object is then no longer automatically updated or disposed by the manager.
    *
    * @method removeObject
    * @param {gs.Object_Base} object - The game object to remove.
     */

    ObjectManager.prototype.removeObject = function(object) {
      return this.remove(object);
    };


    /**
    * Adds a game object to the manager. The game object is then automatically updated by the manager.
    *
    * @method add
    * @param {gs.Object_Base} object - The game object to add.
     */

    ObjectManager.prototype.add = function(object) {
      this.objects.push(object);
      this.needsSort = true;
      this.registerObject(object);
      return this.addToGroup(object, object.group);
    };


    /**
    * Removes a game object to the manager. The game object is then no longer automatically updated or disposed by the manager.
    *
    * @method remove
    * @param {gs.Object_Base} object - The game object to remove.
     */

    ObjectManager.prototype.remove = function(object) {
      var ref;
      if (object) {
        this.objects.remove(object);
        this.unregisterObject(object);
        if (object.group != null) {
          return (ref = this.objectsByGroup[object.group]) != null ? ref.remove(object) : void 0;
        }
      }
    };


    /**
    * Gets an object by ID.
    *
    * @method objectById
    * @param {String} id - The ID of the game object to get. 
    * @return {gs.Object_Base} The game object or <b>null</b> if no game object is registered for the specified ID.
     */

    ObjectManager.prototype.objectById = function(id) {
      var ref;
      return (ref = this.objectsById[id]) != null ? ref.last() : void 0;
    };


    /**
    * Gets an object by ID.
    *
    * @method byId
    * @param {String} id - The ID of the game object to get. 
    * @return {gs.Object_Base} The game object or <b>null</b> if no game object is registered for the specified ID.
     */

    ObjectManager.prototype.byId = function(id) {
      var ref;
      return (ref = this.objectsById[id]) != null ? ref.last() : void 0;
    };


    /**
    * Sets the object for an ID.
    *
    * @method setObjectById
    * @param {gs.Object_Base} object - The game object to set.
    * @param {String} id - The ID for the game object.
     */

    ObjectManager.prototype.setObjectById = function(object, id) {
      if (!id) {
        return;
      }
      object.id = id;
      if (!this.objectsById[id]) {
        this.objectsById[id] = [object];
      } else {
        this.objectsById[id].push(object);
      }
      return window["$" + id] = object;
    };


    /**
    * Adds an object to a specified object-group.
    *
    * @method addToGroup
    * @param {gs.Object_Base} object - The game object to add.
    * @param {String} group - The group to assign game object to.
     */

    ObjectManager.prototype.addToGroup = function(object, group) {
      var ref;
      if (group != null) {
        if ((ref = this.objectsByGroup_[object.group]) != null) {
          ref.remove(object);
        }
        if (!this.objectsByGroup_[group]) {
          this.objectsByGroup_[group] = [];
        }
        return this.objectsByGroup_[group].push(object);
      }
    };


    /**
    * Gets all object of a specified object-group.
    *
    * @method objectsByGroup
    * @param {String} group - The object-group.
    * @return {gs.Object_Base[]} The game objects belonging to the specified group.
     */

    ObjectManager.prototype.objectsByGroup = function(group) {
      return this.objectsByGroup_[group] || [];
    };


    /**
    * Updates the manager and all assigned game objects in the right order.
    *
    * @method update
     */

    ObjectManager.prototype.update = function() {
      var i, object;
      i = 0;
      if (this.needsSort) {
        this.objects.sort(function(a, b) {
          if (a.order < b.order) {
            return 1;
          } else if (a.order > b.order) {
            return -1;
          } else {
            return 0;
          }
        });
        this.needsSort = false;
      }
      while (i < this.objects.length) {
        object = this.objects[i];
        if (object.disposed) {
          this.removeObject(object);
        } else {
          if (object.active) {
            object.update();
          }
          i++;
        }
      }
      return null;
    };

    return ObjectManager;

  })();

  gs.ObjectManager = ObjectManager;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var GameManager;

  GameManager = (function() {

    /**
    * Manages all general things around the game like holding the game settings,
    * manages the save/load of a game, etc.
    *
    * @module gs
    * @class GameManager
    * @memberof gs
    * @constructor
     */
    function GameManager() {

      /**
      * The current scene data.
      * @property sceneData
      * @type Object
       */
      this.sceneData = {};

      /**
      * The scene viewport containing all visual objects which are part of the scene and influenced
      * by the in-game camera.
      * @property sceneViewport
      * @type gs.Object_Viewport
       */
      this.sceneViewport = null;

      /**
      * The list of common events.
      * @property commonEvents
      * @type gs.Object_CommonEvent[]
       */
      this.commonEvents = [];

      /**
      * Indicates if the GameManager is initialized.
      * @property commonEvents
      * @type gs.Object_CommonEvent[]
       */
      this.initialized = false;

      /**
      * Temporary game settings.
      * @property tempSettings
      * @type Object
       */
      this.tempSettings = {
        skip: false,
        skipTime: 5,
        loadMenuAccess: true,
        menuAccess: true,
        backlogAccess: true,
        saveMenuAccess: true,
        messageFading: {
          animation: {
            type: 1
          },
          duration: 15,
          easing: null
        }

        /**
        * Temporary game fields.
        * @property tempFields
        * @type Object
         */
      };
      this.tempFields = null;

      /**
      * Stores default values for backgrounds, pictures, etc.
      * @property defaults
      * @type Object
       */
      this.defaults = {
        background: {
          "duration": 30,
          "origin": 0,
          "zOrder": 0,
          "loopVertical": 0,
          "loopHorizontal": 0,
          "easing": {
            "type": 0,
            "inOut": 1
          },
          "animation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "motionBlur": {
            "enabled": 0,
            "delay": 2,
            "opacity": 100,
            "dissolveSpeed": 3
          }
        },
        picture: {
          "appearDuration": 30,
          "disappearDuration": 30,
          "origin": 1,
          "zOrder": 0,
          "appearEasing": {
            "type": 0,
            "inOut": 1
          },
          "disappearEasing": {
            "type": 0,
            "inOut": 1
          },
          "appearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "disappearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "motionBlur": {
            "enabled": 0,
            "delay": 2,
            "opacity": 100,
            "dissolveSpeed": 3
          }
        },
        character: {
          "expressionDuration": 0,
          "appearDuration": 40,
          "disappearDuration": 40,
          "origin": 1,
          "zOrder": 0,
          "appearEasing": {
            "type": 2,
            "inOut": 2
          },
          "disappearEasing": {
            "type": 1,
            "inOut": 1
          },
          "appearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "disappearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "motionBlur": {
            "enabled": 0,
            "delay": 2,
            "opacity": 100,
            "dissolveSpeed": 3
          },
          "changeAnimation": {
            "type": 1,
            "movement": 0,
            "fading": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "changeEasing": {
            "type": 2,
            "inOut": 2
          }
        },
        text: {
          "appearDuration": 30,
          "disappearDuration": 30,
          "positionOrigin": 0,
          "origin": 0,
          "zOrder": 0,
          "appearEasing": {
            "type": 0,
            "inOut": 1
          },
          "disappearEasing": {
            "type": 0,
            "inOut": 1
          },
          "appearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "disappearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "motionBlur": {
            "enabled": 0,
            "delay": 2,
            "opacity": 100,
            "dissolveSpeed": 3
          }
        },
        video: {
          "appearDuration": 30,
          "disappearDuration": 30,
          "origin": 0,
          "zOrder": 0,
          "appearEasing": {
            "type": 0,
            "inOut": 1
          },
          "disappearEasing": {
            "type": 0,
            "inOut": 1
          },
          "appearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "disappearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "motionBlur": {
            "enabled": 0,
            "delay": 2,
            "opacity": 100,
            "dissolveSpeed": 3
          }
        },
        live2d: {
          "motionFadeInTime": 1000,
          "appearDuration": 30,
          "disappearDuration": 30,
          "zOrder": 0,
          "appearEasing": {
            "type": 0,
            "inOut": 1
          },
          "disappearEasing": {
            "type": 0,
            "inOut": 1
          },
          "appearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "disappearAnimation": {
            "type": 1,
            "movement": 0,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          }
        },
        messageBox: {
          "appearDuration": 30,
          "disappearDuration": 30,
          "zOrder": 0,
          "appearEasing": {
            "type": 0,
            "inOut": 1
          },
          "disappearEasing": {
            "type": 0,
            "inOut": 1
          },
          "appearAnimation": {
            "type": 0,
            "movement": 3,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          },
          "disappearAnimation": {
            "type": 0,
            "movement": 3,
            "mask": {
              "graphic": null,
              "vague": 30
            }
          }
        },
        audio: {
          "musicFadeInDuration": 0,
          "musicFadeOutDuration": 0,
          "musicVolume": 100,
          "musicPlaybackRate": 100,
          "soundVolume": 100,
          "soundPlaybackRate": 100,
          "voiceVolume": 100,
          "voicePlaybackRate": 100
        }
      };

      /**
      * The game's backlog.
      * @property backlog
      * @type Object[]
       */
      this.backlog = [];

      /**
      * Character parameters by character ID.
      * @property characterParams
      * @type Object[]
       */
      this.characterParams = [];

      /**
      * The game's chapter
      * @property chapters
      * @type gs.Document[]
       */
      this.chapters = [];

      /**
      * The game's current displayed messages. Especially in NVL mode the messages
      * of the current page are stored here.
      * @property messages
      * @type Object[]
       */
      this.messages = [];

      /**
      * Count of save slots. Default is 100.
      * @property saveSlotCount
      * @type number
       */
      this.saveSlotCount = 100;

      /**
      * The index of save games. Contains the header-info for each save game slot.
      * @property saveGameSlots
      * @type Object[]
       */
      this.saveGameSlots = [];

      /**
      * Stores global data like the state of persistent game variables.
      * @property globalData
      * @type Object
       */
      this.globalData = null;

      /**
      * Indicates if the game runs in editor's live-preview.
      * @property inLivePreview
      * @type Object
       */
      this.inLivePreview = false;
    }


    /**
    * Initializes the GameManager, should be called before the actual game starts.
    *
    * @method initialize
     */

    GameManager.prototype.initialize = function() {
      var character, i, j, k, l, len, len1, param, ref, ref1, ref2, ref3, ref4, ref5, ref6;
      this.initialized = true;
      this.inLivePreview = $PARAMS.preview != null;
      this.saveSlotCount = RecordManager.system.saveSlotCount || 100;
      this.tempFields = new gs.GameTemp();
      window.$tempFields = this.tempFields;
      this.createSaveGameIndex();
      this.variableStore = new gs.VariableStore();
      DataManager.getDocumentsByType("persistent_variables");
      this.variableStore.setupDomains(DataManager.getDocumentsByType("global_variables").select(function(v) {
        return v.items.domain || "";
      }));
      this.variableStore.persistentNumbersByDomain = (ref = this.globalData.persistentNumbers) != null ? ref : this.variableStore.persistentNumbersByDomain;
      this.variableStore.persistentBooleansByDomain = (ref1 = this.globalData.persistentBooleans) != null ? ref1 : this.variableStore.persistentBooleansByDomain;
      this.variableStore.persistentStringsByDomain = (ref2 = this.globalData.persistentStrings) != null ? ref2 : this.variableStore.persistentStringsByDomain;
      this.variableStore.persistentListsByDomain = (ref3 = this.globalData.persistentLists) != null ? ref3 : this.variableStore.persistentListsByDomain;
      this.sceneViewport = new gs.Object_Viewport(new Viewport(0, 0, Graphics.width, Graphics.height, Graphics.viewport));
      ref4 = RecordManager.charactersArray;
      for (j = 0, len = ref4.length; j < len; j++) {
        character = ref4[j];
        if (character != null) {
          this.characterParams[character.index] = {};
          if (character.params != null) {
            ref5 = character.params;
            for (k = 0, len1 = ref5.length; k < len1; k++) {
              param = ref5[k];
              this.characterParams[character.index][param.name] = param.value;
            }
          }
        }
      }
      this.setupCommonEvents();
      for (i = l = 0, ref6 = RecordManager.characters; 0 <= ref6 ? l < ref6 : l > ref6; i = 0 <= ref6 ? ++l : --l) {
        this.settings.voicesPerCharacter[i] = 100;
      }
      this.chapters = DataManager.getDocumentsByType("vn.chapter");
      return this.chapters.sort(function(a, b) {
        if (a.items.order > b.items.order) {
          return 1;
        } else if (a.items.order < b.items.order) {
          return -1;
        } else {
          return 0;
        }
      });
    };


    /**
    * Sets up common events.
    *
    * @method setupCommonEvents
     */

    GameManager.prototype.setupCommonEvents = function() {
      var event, j, k, len, len1, object, ref, ref1, results;
      ref = this.commonEvents;
      for (j = 0, len = ref.length; j < len; j++) {
        event = ref[j];
        if (event != null) {
          event.dispose();
        }
      }
      this.commonEvents = [];
      ref1 = RecordManager.commonEvents;
      results = [];
      for (k = 0, len1 = ref1.length; k < len1; k++) {
        event = ref1[k];
        object = new gs.Object_CommonEvent();
        object.record = event;
        object.rid = event.index;
        this.commonEvents[event.index] = object;
        results.push(this.commonEvents.push(object));
      }
      return results;
    };


    /**
    * Preloads resources for common events with auto-preload option enabled.
    *
    * @method preloadCommonEvents
     */

    GameManager.prototype.preloadCommonEvents = function() {
      var event, j, len, ref, results;
      ref = RecordManager.commonEvents;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        event = ref[j];
        if (!event) {
          continue;
        }
        if (event.startCondition === 1 && event.autoPreload) {
          results.push(gs.ResourceLoader.loadEventCommandsGraphics(event.commands));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Sets up cursor depending on system settings.
    *
    * @method setupCursor
     */

    GameManager.prototype.setupCursor = function() {
      var bitmap, ref;
      if ((ref = RecordManager.system.cursor) != null ? ref.name : void 0) {
        bitmap = ResourceManager.getBitmap("Graphics/Pictures/" + RecordManager.system.cursor.name);
        return Graphics.setCursorBitmap(bitmap, RecordManager.system.cursor.hx, RecordManager.system.cursor.hy);
      } else {
        return Graphics.setCursorBitmap(null);
      }
    };


    /**
    * Disposes the GameManager. Should be called before quit the game.
    *
    * @method dispose
     */

    GameManager.prototype.dispose = function() {};


    /**
    * Quits the game. The implementation depends on the platform. So for example on mobile
    * devices this method has no effect.
    *
    * @method exit
     */

    GameManager.prototype.exit = function() {
      return Application.exit();
    };


    /**
    * Resets the GameManager by disposing and re-initializing it.
    *
    * @method reset
     */

    GameManager.prototype.reset = function() {
      this.initialized = false;
      this.interpreter = null;
      this.dispose();
      return this.initialize();
    };


    /**
    * Starts a new game.
    *
    * @method newGame
     */

    GameManager.prototype.newGame = function() {
      this.messages = [];
      this.variableStore.clearAllGlobalVariables();
      this.variableStore.clearAllLocalVariables();
      this.tempSettings.skip = false;
      this.tempFields.clear();
      this.tempFields.inGame = true;
      this.setupCommonEvents();
      this.tempSettings.menuAccess = true;
      this.tempSettings.saveMenuAccess = true;
      this.tempSettings.loadMenuAccess = true;
      return this.tempSettings.backlogAccess = true;
    };


    /**
    * Exists the game and resets the GameManager which is important before going back to
    * the main menu or title screen.
    *
    * @method exitGame
     */

    GameManager.prototype.exitGame = function() {
      this.tempFields.inGame = false;
      return this.tempFields.isExitingGame = true;
    };


    /**
    * Updates the GameManager. Should be called once per frame.
    *
    * @method update
     */

    GameManager.prototype.update = function() {};


    /**
    * Creates the index of all save-games. Should be called whenever a new save game
    * is created.
    *
    * @method createSaveGameIndex
    * @protected
     */

    GameManager.prototype.createSaveGameIndex = function() {
      var chaper, chapter, header, i, image, j, ref, scene;
      this.saveGameSlots = [];
      for (i = j = 0, ref = this.saveSlotCount; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        if (GameStorage.exists("SaveGame_" + i + "_Header")) {
          header = GameStorage.getObject("SaveGame_" + i + "_Header");
          chapter = DataManager.getDocument(header.chapterUid);
          scene = DataManager.getDocumentSummary(header.sceneUid);
          image = header.image;
        } else {
          header = null;
          chaper = null;
          scene = null;
        }
        if ((chapter != null) && (scene != null) && !this.inLivePreview) {
          this.saveGameSlots.push({
            date: header.date,
            chapter: chapter.items.name || "DELETED",
            scene: scene.items.name || "DELETED",
            image: image
          });
        } else {
          this.saveGameSlots.push({
            "date": "",
            "chapter": "",
            "scene": "",
            "image": null
          });
        }
      }
      return this.saveGameSlots;
    };


    /**
    * Resets the game's settings to its default values.
    *
    * @method resetSettings
     */

    GameManager.prototype.resetSettings = function() {
      var i, j, ref;
      this.settings = {
        version: 342,
        renderer: 0,
        filter: 1,
        confirmation: true,
        adjustAspectRatio: false,
        allowSkip: true,
        allowSkipUnreadMessages: true,
        allowVideoSkip: true,
        skipVoiceOnAction: true,
        allowChoiceSkip: false,
        voicesByCharacter: [],
        timeMessageToVoice: true,
        "autoMessage": {
          enabled: false,
          time: 0,
          waitForVoice: true,
          stopOnAction: false
        },
        "voiceEnabled": true,
        "bgmEnabled": true,
        "soundEnabled": true,
        "voiceVolume": 100,
        "bgmVolume": 100,
        "seVolume": 100,
        "messageSpeed": 4,
        "fullScreen": false,
        "aspectRatio": 0
      };
      this.saveGameSlots = [];
      for (i = j = 0, ref = this.saveSlotCount; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        GameStorage.remove("SaveGame_" + i + "_Header");
        GameStorage.remove("SaveGame_" + i);
        this.saveGameSlots.push({
          "date": "",
          "chapter": "",
          "scene": "",
          "thumb": ""
        });
      }
      return GameStorage.setObject("settings", this.settings);
    };


    /**
    * Saves current game settings.
    *
    * @method saveSettings
     */

    GameManager.prototype.saveSettings = function() {
      return GameStorage.setObject("settings", this.settings);
    };


    /**
    * Saves current global data.
    *
    * @method saveGlobalData
     */

    GameManager.prototype.saveGlobalData = function() {
      this.globalData.persistentNumbers = this.variableStore.persistentNumbersByDomain;
      this.globalData.persistentLists = this.variableStore.persistentListsByDomain;
      this.globalData.persistentBooleans = this.variableStore.persistentBooleansByDomain;
      this.globalData.persistentStrings = this.variableStore.persistentStringsByDomain;
      return GameStorage.setObject("globalData", this.globalData);
    };


    /**
    * Resets current global data. All stored data about read messages, persistent variables and
    * CG gallery will be deleted.
    *
    * @method resetGlobalData
     */

    GameManager.prototype.resetGlobalData = function() {
      var cg, data, i, j, len, ref, ref1, version;
      version = (ref = this.globalData) != null ? ref.version : void 0;
      data = this.globalData;
      this.globalData = {
        messages: {},
        cgGallery: {},
        version: 342,
        persistentNumbers: {
          "0": [],
          "com.degica.vnm.default": []
        },
        persistentStrings: {
          "0": [],
          "com.degica.vnm.default": []
        },
        persistentBooleans: {
          "0": [],
          "com.degica.vnm.default": []
        },
        persistentLists: {
          "0": [],
          "com.degica.vnm.default": []
        }
      };
      ref1 = RecordManager.cgGalleryArray;
      for (i = j = 0, len = ref1.length; j < len; i = ++j) {
        cg = ref1[i];
        if (cg != null) {
          this.globalData.cgGallery[cg.index] = {
            unlocked: false
          };
        }
      }
      GameStorage.setObject("globalData", this.globalData);
      return this.migrateGlobalData(data, version + 1, this.globalData.version);
    };

    GameManager.prototype.migrateGlobalData = function(data, from, to) {
      var i, j, ref, ref1, results;
      results = [];
      for (i = j = ref = from, ref1 = to; ref <= ref1 ? j <= ref1 : j >= ref1; i = ref <= ref1 ? ++j : --j) {
        if (this["migrateGlobalData" + i] != null) {
          results.push(this["migrateGlobalData" + i](data));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };

    GameManager.prototype.migrateGlobalData342 = function(data) {
      if (data != null) {
        this.globalData.persistentNumbers[0] = data.persistentNumbers[0] || [];
        this.globalData.persistentStrings[0] = data.persistentStrings[0] || [];
        this.globalData.persistentBooleans[0] = data.persistentBooleans[0] || [];
        this.globalData.persistentLists[0] = data.persistentLists[0] || [];
        this.globalData.persistentNumbers["com.degica.vnm.default"] = data.persistentNumbers[0] || [];
        this.globalData.persistentStrings["com.degica.vnm.default"] = data.persistentStrings[0] || [];
        this.globalData.persistentBooleans["com.degica.vnm.default"] = data.persistentBooleans[0] || [];
        return this.globalData.persistentLists["com.degica.vnm.default"] = data.persistentLists[0] || [];
      }
    };

    GameManager.prototype.readSaveGame = function(saveGame) {};

    GameManager.prototype.writeSaveGame = function(saveGame) {};

    GameManager.prototype.prepareSaveGame = function(snapshot) {
      var context, messageBoxIds, messageBoxes, messageIds, messages, saveGame, sceneData;
      if (snapshot) {
        snapshot = ResourceManager.getCustomBitmap("$snapshot");
        if (snapshot != null) {
          snapshot.dispose();
        }
        ResourceManager.setCustomBitmap("$snapshot", Graphics.snapshot());
      }
      context = new gs.ObjectCodecContext();
      context.decodedObjectStore.push(Graphics.viewport);
      context.decodedObjectStore.push(this.scene);
      context.decodedObjectStore.push(this.scene.behavior);
      messageBoxIds = ["messageBox", "nvlMessageBox", "messageMenu"];
      messageIds = ["gameMessage_message", "nvlGameMessage_message"];
      messageBoxes = messageBoxIds.select((function(_this) {
        return function(id) {
          return _this.scene.behavior.objectManager.objectById(id);
        };
      })(this));
      messages = messageIds.select((function(_this) {
        return function(id) {
          return _this.scene.behavior.objectManager.objectById(id);
        };
      })(this));
      sceneData = {};
      saveGame = {};
      saveGame.encodedObjectStore = null;
      saveGame.sceneUid = this.scene.sceneDocument.uid;
      saveGame.data = {
        resourceContext: this.scene.behavior.resourceContext.toDataBundle(),
        currentCharacter: this.scene.currentCharacter,
        characterParams: this.characterParams,
        frameCount: Graphics.frameCount,
        tempFields: this.tempFields,
        viewport: this.scene.viewport,
        characters: this.scene.characters,
        characterNames: RecordManager.charactersArray.select(function(c) {
          return {
            name: c.name,
            index: c.index
          };
        }),
        backgrounds: this.scene.backgrounds,
        pictures: this.scene.pictureContainer.subObjectsByDomain,
        texts: this.scene.textContainer.subObjectsByDomain,
        videos: this.scene.videoContainer.subObjectsByDomain,
        viewports: this.scene.viewportContainer.subObjects,
        commonEvents: this.scene.commonEventContainer.subObjects,
        hotspots: this.scene.hotspotContainer.subObjectsByDomain,
        interpreter: this.scene.interpreter,
        choices: this.scene.choices,
        messageBoxes: messageBoxes.select((function(_this) {
          return function(mb, i) {
            return {
              visible: mb.visible,
              id: mb.id,
              message: messages[i]
            };
          };
        })(this)),
        backlog: this.backlog,
        variableStore: this.variableStore,
        defaults: this.defaults,
        transitionData: SceneManager.transitionData,
        audio: {
          audioBuffers: AudioManager.audioBuffers,
          audioBuffersByLayer: AudioManager.audioBuffersByLayer,
          audioLayers: AudioManager.audioLayers,
          soundReferences: AudioManager.soundReferences
        },
        messageAreas: this.scene.messageAreaContainer.subObjectsByDomain
      };
      saveGame.data = gs.ObjectCodec.encode(saveGame.data, context);
      saveGame.encodedObjectStore = context.encodedObjectStore;
      return this.saveGame = saveGame;
    };

    GameManager.prototype.createSaveGameSlot = function(header) {
      var slot;
      slot = {
        "date": new Date().toDateString(),
        "chapter": this.scene.chapter.items.name,
        "scene": this.scene.sceneDocument.items.name,
        "image": header.image
      };
      return slot;
    };

    GameManager.prototype.createSaveGameHeader = function(thumbWidth, thumbHeight) {
      var header, thumbImage;
      thumbImage = this.createSaveGameThumbImage(thumbWidth, thumbHeight);
      header = {
        "date": new Date().toDateString(),
        "chapterUid": this.scene.chapter.uid,
        "sceneUid": this.scene.sceneDocument.uid,
        "image": thumbImage != null ? thumbImage.image.toDataURL() : void 0
      };
      if (thumbImage != null) {
        thumbImage.dispose();
      }
      return header;
    };

    GameManager.prototype.createSaveGameThumbImage = function(width, height) {
      var snapshot, thumbImage;
      snapshot = ResourceManager.getBitmap("$snapshot");
      thumbImage = null;
      if (snapshot && snapshot.loaded) {
        if (width && height) {
          thumbImage = new Bitmap(width, height);
        } else {
          thumbImage = new Bitmap(Graphics.width / 8, Graphics.height / 8);
        }
        thumbImage.stretchBlt(new Rect(0, 0, thumbImage.width, thumbImage.height), snapshot, new Rect(0, 0, snapshot.width, snapshot.height));
      }
      return thumbImage;
    };

    GameManager.prototype.storeSaveGame = function(name, saveGame, header) {
      if (header) {
        GameStorage.setData(name + "_Header", JSON.stringify(header));
      }
      return GameStorage.setData(name, JSON.stringify(saveGame));
    };


    /**
    * Saves the current game at the specified slot.
    *
    * @method save
    * @param {number} slot - The slot where the game should be saved at.
    * @param {number} thumbWidth - The width for the snapshot-thumb. You can specify <b>null</b> or 0 to use an auto calculated width.
    * @param {number} thumbHeight - The height for the snapshot-thumb. You can specify <b>null</b> or 0 to use an auto calculated height.
     */

    GameManager.prototype.save = function(slot, thumbWidth, thumbHeight) {
      var header;
      if (this.saveGame) {
        header = this.createSaveGameHeader(thumbWidth, thumbHeight);
        this.saveGameSlots[slot] = this.createSaveGameSlot(header);
        this.storeSaveGame("SaveGame_" + slot, this.saveGame, header);
        this.sceneData = {};
        return this.saveGame;
      }
    };

    GameManager.prototype.restore = function(saveGame) {
      this.backlog = saveGame.data.backlog;
      this.defaults = saveGame.data.defaults;
      this.variableStore.restore(saveGame.data.variableStore);
      this.sceneData = saveGame.data;
      this.saveGame = null;
      this.loadedSaveGame = null;
      this.tempFields = saveGame.data.tempFields;
      this.characterParams = saveGame.data.characterParams;
      window.$tempFields = this.tempFields;
      return window.$dataFields.backlog = this.backlog;
    };

    GameManager.prototype.prepareLoadGame = function() {
      return AudioManager.stopAllMusic(30);
    };


    /**
    * Loads the game from the specified save game slot. This method triggers
    * a automatic scene change.
    *
    * @method load
    * @param {number} slot - The slot where the game should be loaded from.
     */

    GameManager.prototype.load = function(slot) {
      if (!this.saveGameSlots[slot] || this.saveGameSlots[slot].date.trim().length === 0) {
        return;
      }
      this.prepareLoadGame();
      this.loadedSaveGame = this.loadSaveGame("SaveGame_" + slot);
      gs.Audio.reset();
      gs.GlobalEventManager.clear();
      SceneManager.switchTo(new vn.Object_Scene());
      return SceneManager.clear();
    };

    GameManager.prototype.loadSaveGame = function(name) {
      return JSON.parse(GameStorage.getData(name));
    };


    /**
    * Gets the save game data for a specified slot.
    *
    * @method getSaveGame
    * @param {number} slot - The slot to get the save data from.
    * @return {Object} The save game data.
     */

    GameManager.prototype.getSaveGame = function(slot) {
      return JSON.parse(GameStorage.getData("SaveGame_" + slot));
    };

    return GameManager;

  })();

  window.GameManager = new GameManager();

  gs.GameManager = window.GameManager;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var SceneManager,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  SceneManager = (function(superClass) {
    extend(SceneManager, superClass);


    /**
    * Manages the scenes of the game.
    *
    * @module gs
    * @class SceneManager
    * @memberof gs
    * @constructor
     */

    function SceneManager() {
      SceneManager.__super__.constructor.apply(this, arguments);

      /**
      * The current scene.
      * @property scene
      * @type gs.Object_Base
       */
      this.scene = null;

      /**
      * An array of previous scenes. Used to jump back to last scene from a menu for example.
      * @property previousScenes
      * @type gs.Object_Base
       */
      this.previousScenes = [];

      /**
      * The next scene. If set, this scene will become the current scene after next update.
      * @property nextScene
      * @type gs.Object_Base
       */
      this.nextScene = null;

      /**
      * The transition-data like the graphic, vague, etc. used for a transition from one scene to another.
      * @property transitionData
      * @type Object
       */
      this.transitionData = {
        graphic: null,
        duration: 20,
        vague: 30
      };
      this.input = true;

      /**
      * Called if a scene-change has been done.
      * @property callback
      * @type Function
       */
      this.callback = null;
      this.paused = false;
    }

    SceneManager.prototype.initialize = function() {};


    /**
    * Switches from the current scene to the specified one.
    *
    * @method switchTo
    * @param {gs.Object_Base} scene - The new scene.
    * @param {boolean} savePrevious - Indicates if the current scene should be pushed to previous-scene stack instead
    * of getting disposed. It is possible to switch back to that scene then using gs.SceneManager.returnToPrevious method.
    * @param {Function} callback - Called after the scene has been changed.
     */

    SceneManager.prototype.switchTo = function(scene, savePrevious, callback) {
      this.callback = callback;
      if (savePrevious) {
        this.previousScenes.push(this.scene);
      } else if (this.previousScenes.length === 0) {
        gs.Audio.reset();
      }
      if (this.scene != null) {
        this.removeObject(this.scene);
      }
      this.nextScene = scene;
      return Graphics.freeze();
    };


    /**
    * Clears the stack of previous-scenes and disposes all previous-scenes. After that it is not
    * possible to go back to a previous scene using gs.SceneManager.returnToPrevious().
    *
    * @method clear
     */

    SceneManager.prototype.clear = function() {
      var i, len, ref, scene;
      ref = this.previousScenes;
      for (i = 0, len = ref.length; i < len; i++) {
        scene = ref[i];
        scene.dispose();
      }
      return this.previousScenes = [];
    };


    /**
    * Returns to the previous scene if that scene was saved before.
    *
    * @method returnToPrevious
    * @param {Function} callback - Called after the scene has been changed.
     */

    SceneManager.prototype.returnToPrevious = function(callback) {
      var scene;
      this.callback = callback;
      if (this.previousScenes.length > 0) {
        scene = this.previousScenes.pop();
        if (this.scene != null) {
          this.removeObject(this.scene);
        }
        if (scene != null) {
          this.nextScene = scene;
          return Graphics.freeze();
        }
      }
    };


    /**
    * Updates the current scene and the scene-handling. Needs to be called once
    * per frame.
    *
    * @method update
     */

    SceneManager.prototype.update = function() {
      var ref;
      if (this.nextScene !== this.scene) {
        Input.clear();
        if (this.scene != null) {
          if (this.previousScenes.indexOf(this.scene) === -1) {
            this.scene.dispose();
          } else {
            this.scene.behavior.show(false);
          }
        }
        this.scene = this.nextScene;
        if (typeof this.callback === "function") {
          this.callback();
        }
        if (this.scene) {
          this.addObject(this.scene);
          this.scene.loading = true;
          this.scene.loadingData = true;
          this.scene.loadingResources = true;
          if ((this.scene != null) && !this.scene.initialized) {
            this.scene.behavior.initialize();
            this.scene.behavior.prepareLoadingScreen();
            this.isFadeOut = true;
          } else if ((ref = this.scene) != null ? ref.initialized : void 0) {
            this.scene.behavior.show(true);
            this.scene.update();
          }
          Graphics.update();
          this.scene.behavior.transition();
        } else {
          Graphics.freeze();
          Graphics.update();
          Graphics.transition(30);
          this.isFadeOut = true;
        }
      }
      if (this.isFadeOut && Graphics.frozen) {
        Graphics.update();
        return Input.update();
      } else {
        if (this.isFadeOut) {
          AudioManager.stopAllSounds();
          this.isFadeOut = false;
          if (this.scene) {
            Graphics.freeze();
          } else {
            gs.Application.exit();
          }
        }
        DataManager.update();
        ResourceManager.update();
        if (RecordManager.initialized) {
          AudioManager.update();
        }
        if (Graphics.frozen) {
          Input.update();
        }
        return SceneManager.__super__.update.call(this);
      }
    };

    return SceneManager;

  })(gs.ObjectManager);

  window.SceneManager = new SceneManager();

  gs.SceneManager = window.SceneManager;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var LanguageManager;

  LanguageManager = (function() {

    /**
    * Manages the different languages of the game.  
    *
    * @module gs
    * @class LanguageManager
    * @memberof gs
    * @constructor
     */
    function LanguageManager() {

      /**
      * The default language profile.
      * @property defaultProfile
      * @type gs.LanguageProfile
       */
      this.defaultProfile = null;

      /**
      * The current language profile.
      * @property profile
      * @type gs.LanguageProfile
       */
      this.profile = null;

      /**
      * The current strings bundle.
      * @property bundle
      * @type gs.LanguageStringsBundle
       */
      this.bundle = null;

      /**
      * The default strings bundle.
      * @property defaultBundle
      * @type gs.LanguageStringsBundle
       */
      this.defaultBundle = null;
    }


    /**
    * Initializes the language system by loading the necessary language profiles
    * and strings bundles.
    *
    * @method initialize
     */

    LanguageManager.prototype.initialize = function() {
      var document, documents, i, len, ref;
      this.languages = [];
      DataManager.getDocumentByType("custom_strings_bundle");
      documents = DataManager.getDocumentsByType("language_profile");
      for (i = 0, len = documents.length; i < len; i++) {
        document = documents[i];
        this.languages.push({
          name: document.items.name,
          code: document.items.code,
          uid: document.uid,
          icon: document.items.icon,
          bundleUid: document.items.bundleUid,
          wordWrap: (ref = document.items.wordWrap) != null ? ref : "spaceBased"
        });
        if (document.uid === "07DDA0716161F104") {
          this.language = this.languages[this.languages.length - 1];
          this.defaultLanguage = this.language;
        }
      }
      this.selectLanguage(this.language);
      if (this.language.uid !== this.defaultLanguage.uid) {
        return this.defaultProfile = DataManager.getDocument(this.defaultLanguage.uid);
      } else {
        return this.defaultProfile = this.profile;
      }
    };


    /**
    * Loads the necessary strings bundles for the current language. 
    *
    * @method loadBundles
     */

    LanguageManager.prototype.loadBundles = function() {
      var customStrings;
      customStrings = DataManager.getDocumentByType("custom_strings_bundle");
      if (this.language.uid !== this.defaultLanguage.uid) {
        this.bundle = DataManager.getDocument(this.language.bundleUid);
      }
      this.defaultBundle = {
        items: {
          localizableStrings: RecordManager.localizableStrings
        }
      };
      Object.mixin(this.defaultBundle.items.localizableStrings, customStrings.items.localizableStrings);
      return this.language.uid !== this.defaultLanguage.uid;
    };


    /**
    * Sets the specified language as current language.
    *
    * @method selectLanguage
    * @param {Object} language - The language to set.
     */

    LanguageManager.prototype.selectLanguage = function(language) {
      this.language = language;
      return this.profile = DataManager.getDocument(this.language.uid);
    };


    /**
    * Gets the string for the specified id. If the string doesn't exist for current
    * language, its taken from the default language.
    *
    * @method string
    * @param {String} id - The ID of the string to get.
    * @return {String} The string for the specified ID. If the string could not be found the result
    * is an empty string.
     */

    LanguageManager.prototype.string = function(id) {
      var result;
      result = null;
      if ((this.bundle != null) && (this.bundle.items != null)) {
        result = this.bundle.items.localizableStrings[id];
        if ((result != null ? result.t : void 0) != null) {
          result = result.t;
        }
      }
      if ((result == null) || result.length === 0) {
        result = this.stringFromDefault(id);
      }
      return result;
    };


    /**
    * Gets the string for the specified id in default language.
    *
    * @method stringFromDefault
    * @param {String} id - The ID of the string to get.
    * @return {String} The string for the specified ID. If the string could not be found the result
    * is an empty string.
     */

    LanguageManager.prototype.stringFromDefault = function(id) {
      var ref, result;
      result = null;
      if ((this.defaultBundle != null) && (this.defaultBundle.items != null)) {
        result = (ref = this.defaultBundle.items.localizableStrings[id]) != null ? ref.t : void 0;
      }
      return result;
    };

    return LanguageManager;

  })();

  window.LanguageManager = new LanguageManager();

  gs.LanguageManager = LanguageManager;

  window.lcsi = function(id) {
    if (id != null) {
      return window.LanguageManager.string(id) || "";
    } else {
      return "";
    }
  };

  window.lcs = function(value) {
    var ref;
    if ((value != null) && ((value.lcId != null) || (value.defaultText != null))) {
      return window.LanguageManager.string(value.lcId) || (value != null ? (ref = value.defaultText) != null ? ref.t : void 0 : void 0) || (value != null ? value.defaultText : void 0);
    } else {
      return value;
    }
  };

  window.lcsm = function(value) {
    return lcs(value);
  };

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var ResourceManager, ResourceManagerContext;

  ResourceManagerContext = (function() {

    /**
    * If associated to a gs.ResourceManager, a resource context registers all loaded resources
    * resources. If gs.ResourceManager needs to dispose resources, it will only dispose
    * resource associated if the current context.
    *
    * By default, each game scene creates it's own resource context to only dispose resources
    * created by itself.
    *
    * @module gs
    * @class ResourceManager
    * @memberof gs
    * @constructor
     */
    function ResourceManagerContext() {

      /**
      * All resources associated with this context.
      * @property resources
      * @type Object[]
      * @readOnly
       */
      this.resources = [];
    }


    /**
    * Converts the resource context into a data-bundle for serialization. The data-bundle will only contain
    * the names of the resources associated with this context but not the resource-data itself.
    * @method toDataBundle
    * @return {string[]} An array of resource names associated with this context.
     */

    ResourceManagerContext.prototype.toDataBundle = function() {
      return this.resources.select(function(r) {
        return r.name;
      });
    };


    /**
    * Initializes the resource context from a data-bundle. Any already existing resource associations
    * with this context will be deleted.
    * @method fromDataBundle
     */

    ResourceManagerContext.prototype.fromDataBundle = function(data, resourcesByPath) {
      return this.resources = data.select(function(n) {
        return {
          name: n,
          data: resourcesByPath[n]
        };
      });
    };


    /**
    * Adds the specified resource to the context.
    * @method add
    * @param {string} name - A unique name for the resource like the file-path for example.
    * @param {gs.Bitmap|gs.AudioBuffer|gs.Video|gs.Live2DModel} data - The resource data like a gs.Bitmap object for example.
     */

    ResourceManagerContext.prototype.add = function(name, resource) {
      return this.resources.push({
        name: name,
        data: resource
      });
    };


    /**
    * Removes the resource with the specified name from the context.
    * @method remove
    * @param {string} name - The name of the resource to remove. For Example: The file name.
     */

    ResourceManagerContext.prototype.remove = function(name) {
      return this.resources.remove(this.resources.first(function(r) {
        return r.name === name;
      }));
    };

    return ResourceManagerContext;

  })();

  gs.ResourceManagerContext = ResourceManagerContext;

  ResourceManager = (function() {

    /**
    * Manages the resources of the game like graphics, audio, fonts, etc. It
    * offers a lot of methods to easily access game resources and automatically
    * caches them. So if an image is requested a second time it will be taken
    * from the cache instead of loading it again.
    *
    * @module gs
    * @class ResourceManager
    * @memberof gs
    * @constructor
     */
    function ResourceManager() {

      /**
      * Current resource context. All loaded resources will be associated with it. If current context
      * is set to <b>null</b>, the <b>systemContext</b> is used instead.
      * @property context
      * @type gs.ResourceManagerContext
      * @protected
       */
      this.context_ = null;

      /**
      * System resource context. All loaded system resources are associated with this context. Resources
      * which are associated with the system context are not disposed until the game ends.
      * @property context
      * @type gs.ResourceManagerContext
       */
      this.systemContext = this.createContext();

      /**
      * Holds in-memory created bitmaps.
      * @property customBitmapsByKey
      * @type Object
      * @protected
       */
      this.customBitmapsByKey = {};

      /**
      * Caches resources by file path.
      * @property resourcesByPath
      * @type Object
      * @protected
       */
      this.resourcesByPath = {};

      /**
      * Caches resources by file path and HUE.
      * @property resourcesByPath
      * @type Object
      * @protected
       */
      this.resourcesByPathHue = {};

      /**
      * Stores all loaded resources.
      * @property resources
      * @type Object[]
       */
      this.resources = [];

      /**
      * Indicates if all requested resources are loaded.
      * @property resourcesLoaded
      * @type boolean
       */
      this.resourcesLoaded = true;

      /**
      * @property events
      * @type gs.EventEmitter
       */
      this.events = new gs.EventEmitter();
    }


    /**
    * Current resource context. All loaded resources will be associated with it. If current context
    * is set to <b>null</b>, the <b>systemContext</b> is used instead.
    * @property context
    * @type gs.ResourceManagerContext
     */

    ResourceManager.accessors("context", {
      set: function(v) {
        return this.context_ = v;
      },
      get: function() {
        var ref;
        return (ref = this.context_) != null ? ref : this.systemContext;
      }
    });


    /**
    * Creates a new resource context. Use <b>context</b> to set the new created context
    * as current context.
    *
    * @method createContext
     */

    ResourceManager.prototype.createContext = function() {
      return new gs.ResourceManagerContext();
    };


    /**
    * Disposes all bitmap resources associated with the current context.
    *
    * @method disposeBitmaps
     */

    ResourceManager.prototype.disposeBitmaps = function() {
      var j, len, ref, resource, results;
      ref = this.context.resources;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        resource = ref[j];
        if (resource.data instanceof gs.Bitmap) {
          resource.data.dispose();
          this.resources.remove(this.resources.first((function(r) {
            var result;
            result = r.filePath === resource.data.filePath;
            if (result) {
              r.dispose();
            }
            return result;
          })));
          this.resources.remove(resource.data);
          if (resource.name) {
            this.resourcesByPath[resource.name] = null;
            results.push(delete this.resourcesByPath[resource.name]);
          } else {
            results.push(void 0);
          }
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Disposes all video resources associated with the current context.
    *
    * @method disposeVideos
     */

    ResourceManager.prototype.disposeVideos = function() {
      var j, len, ref, resource, results;
      ref = this.context.resources;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        resource = ref[j];
        if (resource.data instanceof gs.Video) {
          resource.data.dispose();
          this.resources.remove(resource.data);
          this.resourcesByPath[resource.name] = null;
          results.push(delete this.resourcesByPath[resource.name]);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Disposes all audio resources associated with the current context.
    *
    * @method disposeAudio
     */

    ResourceManager.prototype.disposeAudio = function() {
      var j, len, ref, resource, results;
      AudioManager.dispose(this.context);
      ref = this.context.resources;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        resource = ref[j];
        if (resource.data instanceof GS.AudioBuffer || resource instanceof GS.AudioBufferStream) {
          resource.data.dispose();
          this.resources.remove(resource.data);
          this.resourcesByPath[resource.name] = null;
          results.push(delete this.resourcesByPath[resource.name]);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Disposes all Live2D resources associated with the current context.
    *
    * @method disposeLive2D
     */

    ResourceManager.prototype.disposeLive2D = function() {
      var j, len, ref, resource, results;
      ref = this.context.resources;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        resource = ref[j];
        if (resource.data instanceof gs.Live2DModel) {
          resource.data.dispose();
          this.resources.remove(resource.data);
          this.resourcesByPath[resource.name] = null;
          results.push(delete this.resourcesByPath[resource.name]);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Disposes all resources.
    *
    * @method dispose
     */

    ResourceManager.prototype.dispose = function() {
      this.disposeBitmaps();
      this.disposeVideos();
      this.disposeAudio();
      this.disposeLive2D();
      return this.context = this.systemContext;
    };


    /**
    * Loads all custom fonts in Graphics/Fonts folder.
    *
    * @method loadFonts
     */

    ResourceManager.prototype.loadFonts = function() {
      var resource;
      resource = {
        loaded: false
      };
      this.resources.push(resource);
      this.resourcesByPath["Graphics/Fonts"] = resource;
      return gs.Font.loadCustomFonts((function(_this) {
        return function(error) {
          _this.resourcesByPath["Graphics/Fonts"].loaded = true;
          if (error) {
            return _this.resourcesByPath["Graphics/Fonts"].error = true;
          }
        };
      })(this));
    };


    /**
    * Gets a custom created bitmap by key.
    *
    * @method getCustomBitmap
    * @param {String} key - The key for the bitmap to get.
    * @return {gs.Bitmap} The bitmap or <b>null</b> if no bitmap exists for the specified key.
     */

    ResourceManager.prototype.getCustomBitmap = function(key) {
      return this.customBitmapsByKey[key];
    };


    /**
    * Sets a custom created bitmap for a specified key.
    *
    * @method setCustomBitmap
    * @param {String} key - The key for the bitmap to set.
    * @param {gs.Bitmap} bitmap - The bitmap to set.
     */

    ResourceManager.prototype.setCustomBitmap = function(key, bitmap) {
      this.customBitmapsByKey[key] = bitmap;
      if (bitmap.loaded == null) {
        this.resources.push(bitmap);
        return this.resourcesLoaded = false;
      }
    };


    /**
    * Adds a custom created bitmap to the resource manager.
    *
    * @method addCustomBitmap
    * @param {gs.Bitmap} bitmap - The bitmap to add.
     */

    ResourceManager.prototype.addCustomBitmap = function(bitmap) {
      return this.context.resources.push({
        name: "",
        data: bitmap
      });
    };


    /**
    * Gets a Live2D model.
    *
    * @method getLive2DModel
    * @param {String} filePath - Path to the Live2D model file.
    * @return {gs.Live2DModel} The Live2D model or <b>null</b> if no model exists at the specified file path.
     */

    ResourceManager.prototype.getLive2DModel = function(filePath) {
      var profile, result;
      result = this.resourcesByPath[filePath];
      if ((result == null) || result.disposed) {
        profile = LanguageManager.profile;
        result = new gs.Live2DModel(filePath, ((profile != null) && (profile.items != null) ? profile.items.code : null));
        this.resourcesByPath[filePath] = result;
        this.resources.push(result);
        this.resourcesLoaded = false;
        this.context.resources.push({
          name: filePath,
          data: result
        });
      }
      return result;
    };


    /**
    * Gets a font.
    *
    * @method getFont
    * @param {String} name - The name of the font to get.
    * @param {number} size - The size of the font to get.
    * @return {gs.Font} The font or <b>null</b> if no font with the specified name exists.
     */

    ResourceManager.prototype.getFont = function(name, size) {
      var result;
      result = new Font(name, size);
      this.resources.push(result);
      this.resourcesLoaded = false;
      return result;
    };


    /**
    * Gets a video.
    *
    * @method getVideo
    * @param {String} filePath - Path to the video file.
    * @return {gs.Video} The video or <b>null</b> if no video exists at the specified file path.
     */

    ResourceManager.prototype.getVideo = function(filePath) {
      var profile, result;
      if (filePath.endsWith("/")) {
        return null;
      }
      result = this.resourcesByPath[filePath];
      if ((result == null) || result.disposed) {
        profile = LanguageManager.profile;
        result = new gs.Video(filePath, ((profile != null) && (profile.items != null) ? profile.items.code : null));
        this.resourcesByPath[filePath] = result;
        this.resources.push(result);
        this.resourcesLoaded = false;
        this.context.resources.push({
          name: filePath,
          data: result
        });
      }
      return result;
    };


    /**
    * Gets a bitmap.
    *
    * @method getBitmap
    * @param {String} filePath - Path to the bitmap file.
    * @param {number} hue - The bitmap's hue. The bitmap will be loaded and then recolored.
    * @return {gs.Bitmap} The bitmap or <b>null</b> if no bitmap exists at the specified file path.
     */

    ResourceManager.prototype.getBitmap = function(filePath, hue) {
      var hueBitmap, profile, result;
      if (filePath.endsWith("/")) {
        return null;
      }
      hue = hue || 0;
      result = this.resourcesByPath[filePath] || this.customBitmapsByKey[filePath];
      if (result == null) {
        profile = LanguageManager.profile;
        result = new Bitmap(filePath, ((profile != null) && (profile.items != null) ? profile.items.code : null), false);
        result.hue = hue;
        result.filePath = filePath;
        this.resourcesByPath[filePath] = result;
        this.resources.push(result);
        this.resourcesLoaded = false;
        this.context.resources.push({
          name: filePath,
          data: result
        });
      } else if (!result.loaded && result.hue !== hue) {
        profile = LanguageManager.profile;
        result = new Bitmap(filePath, ((profile != null) && (profile.items != null) ? profile.items.code : null));
        result.hue = hue;
        result.filePath = filePath;
        this.resources.push(result);
        this.resourcesLoaded = false;
      } else if (hue > 0) {
        hueBitmap = this.resourcesByPathHue[filePath + "@" + hue];
        if ((hueBitmap == null) && result.loaded) {
          hueBitmap = new Bitmap(result.image);
          hueBitmap.changeHue(hue);
          this.resourcesByPathHue[filePath + "@" + hue] = hueBitmap;
        }
        if (hueBitmap != null) {
          result = hueBitmap;
        }
      }
      return result;
    };


    /**
    * Gets an HTML image.
    *
    * @method getImage
    * @param {String} filePath - Path to the image file.
    * @return {HTMLImageElement} The image or <b>null</b> if no image exists at the specified file path.
     */

    ResourceManager.prototype.getImage = function(filePath) {
      var result;
      result = this.resourcesByPath[filePath];
      if (result == null) {
        result = new Bitmap("resources/" + filePath + ".png");
        this.resourcesByPath[filePath] = result;
        this.resources.push(result);
        this.resourcesLoaded = false;
      }
      return result;
    };


    /**
    * Gets an audio stream.
    *
    * @method getAudioStream
    * @param {String} filePath - Path to the audio file.
    * @return {gs.AudioBuffer} The audio buffer or <b>null</b> if no audio file exists at the specified file path.
     */

    ResourceManager.prototype.getAudioStream = function(filePath) {
      var languageCode, profile, result;
      result = this.resourcesByPath[filePath];
      profile = LanguageManager.profile;
      languageCode = (profile != null) && (profile.items != null) ? profile.items.code : null;
      if (result == null) {
        result = new GS.AudioBuffer(filePath);
        this.resourcesByPath[filePath] = result;
        this.resources.push(result);
        this.resourcesLoaded = false;
        this.context.resources.push({
          name: filePath,
          data: result
        });
      }
      return result;
    };


    /**
    * Gets an audio buffer. The audio data is fully loaded and decoded in memory. It is recommeneded
    * for sound effects but for a long background music, <b>getAudioStream</b> should be used instead. That is especially
    * the case on mobile devices.
    *
    * @method getAudioBuffer
    * @param {String} filePath - Path to the audio file.
    * @return {gs.AudioBuffer} The audio buffer or <b>null</b> if no audio file exists at the specified file path.
     */

    ResourceManager.prototype.getAudioBuffer = function(filePath) {
      var languageCode, profile, result;
      result = this.resourcesByPath[filePath];
      profile = LanguageManager.profile;
      languageCode = (profile != null) && (profile.items != null) ? profile.items.code : null;
      if (result == null) {
        result = new GS.AudioBuffer(filePath);
        this.resourcesByPath[filePath] = result;
        this.resources.push(result);
        this.resourcesLoaded = false;
        this.context.resources.push({
          name: filePath,
          data: result
        });
      }
      return result;
    };


    /**
    * Updates the loading process. Needs to be called once per frame to keep
    * the ResourceManager up to date.
    *
    * @method update
     */

    ResourceManager.prototype.update = function() {
      var bitmap, i, j, ref;
      if (this.events == null) {
        this.events = new gs.EventEmitter();
      }
      if (!this.resourcesLoaded) {
        this.resourcesLoaded = true;
        for (i = j = 0, ref = this.resources.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
          if (!this.resources[i].loaded) {
            this.resourcesLoaded = false;
            break;
          } else if ((this.resources[i].hue != null) && this.resources[i].hue > 0) {
            bitmap = new Bitmap(this.resources[i].image);
            this.resourcesByPath[this.resources[i].filePath] = bitmap;
            this.resources[i].changeHue(this.resources[i].hue);
            this.resourcesByPathHue[this.resources[i].filePath + "@" + this.resources[i].hue] = this.resources[i];
            delete this.resources[i].filePath;
            delete this.resources[i].hue;
          }
        }
        if (this.resourcesLoaded) {
          this.events.emit("loaded", this);
        }
      }
      return null;
    };

    return ResourceManager;

  })();

  window.ResourceManager = ResourceManager;

  gs.ResourceManager = ResourceManager;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var AudioManager;

  AudioManager = (function() {

    /**
    * Manages the audio playback of the game. 
    *
    * @module gs
    * @class AudioManager
    * @memberof gs
    * @constructor
     */
    function AudioManager() {

      /**
      * Stores all audio buffers.
      * @property buffers
      * @type gs.AudioBuffer[]
      * @protected
       */
      this.audioBuffers = [];

      /**
      * Stores all audio buffers by layer.
      * @property buffers
      * @type gs.AudioBuffer[]
      * @protected
       */
      this.audioBuffersByLayer = [];

      /**
      * Stores all audio buffer references for sounds.
      * @property soundReferences
      * @type gs.AudioBufferReference[]
      * @protected
       */
      this.soundReferences = {};

      /**
      * Current Music (Layer 0)
      * @property music
      * @type Object
      * @protected
       */
      this.music = null;

      /**
      * Current music volume.
      * @property musicVolume
      * @type number
      * @protected
       */
      this.musicVolume = 100;

      /**
      * Current sound volume.
      * @property soundVolume
      * @type number
      * @protected
       */
      this.soundVolume = 100;

      /**
      * Current voice volume.
      * @property voiceVolume
      * @type number
      * @protected
       */
      this.voiceVolume = 100;

      /**
      * General music volume
      * @property generalMusicVolume
      * @type number
      * @protected
       */
      this.generalMusicVolume = 100;

      /**
      * General sound volume
      * @property generalSoundVolume
      * @type number
      * @protected
       */
      this.generalSoundVolume = 100;

      /**
      * General voice volume
      * @property generalVoiceVolume
      * @type number
      * @protected
       */
      this.generalVoiceVolume = 100;

      /**
      * Stores audio layer info-data for each layer.
      * @property audioLayers
      * @type gs.AudioLayerInfo[]
      * @protected
       */
      this.audioLayers = [];
    }


    /**
    * Restores audio-playback from a specified array of audio layers.
    *
    * @method restore
    * @param {gs.AudioLayerInfo[]} layers - An array of audio layer info objects.
     */

    AudioManager.prototype.restore = function(layers) {
      var i, j, layer, len, results;
      this.audioLayers = layers;
      results = [];
      for (i = j = 0, len = layers.length; j < len; i = ++j) {
        layer = layers[i];
        if (layer && layer.playing) {
          if (layer.customData) {
            results.push(this.playMusicRandom(layer, layer.customData.fadeTime, i, layer.customData.playTime, layer.customData.playRange));
          } else {
            results.push(this.playMusic(layer, layer.fadeInTime, i));
          }
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Loads the specified music.
    *
    * @method loadMusic
    * @param {String} name - The name of the music to load.
     */

    AudioManager.prototype.loadMusic = function(name) {
      name = name != null ? name.name || name : name;
      if (name && name.length > 0) {
        return ResourceManager.getAudioStream("Audio/Music/" + name);
      }
    };


    /**
    * Loads the specified sound.
    *
    * @method loadSound
    * @param {String} name - The name of the sound to load.
     */

    AudioManager.prototype.loadSound = function(name) {
      name = name != null ? name.name || name : name;
      if (name && name.length > 0) {
        return ResourceManager.getAudioBuffer("Audio/Sounds/" + name);
      }
    };


    /**
    * Updates a randomly played audio buffer.
    *
    * @method updateRandomAudio
    * @param {gs.AudioBuffer} buffer - The audio buffer to update.
    * @protected
     */

    AudioManager.prototype.updateRandomAudio = function(buffer) {
      var currentTime, timeLeft;
      if (buffer.customData.startTimer > 0) {
        buffer.customData.startTimer--;
        if (buffer.customData.startTimer <= 0) {
          buffer.fadeInVolume = 1.0 / (buffer.customData.fadeTime || 1);
          buffer.fadeInTime = buffer.customData.fadeTime || 1;
          buffer.fadeOutTime = buffer.customData.fadeTime || 1;
          buffer.playTime = buffer.customData.playTime.min + Math.random() * (buffer.customData.playTime.max - buffer.customData.playTime.min);
          currentTime = buffer.currentTime;
          timeLeft = buffer.duration - currentTime;
          buffer.playTime = Math.min(timeLeft * 1000 / 16.6, buffer.playTime);
          return buffer.customData.startTimer = buffer.playTime + buffer.customData.playRange.start + Math.random() * (buffer.customData.playRange.end - buffer.customData.playRange.start);
        }
      }
    };


    /**
    * Updates all audio-buffers depending on the play-type.
    *
    * @method updateAudioBuffers
    * @protected
     */

    AudioManager.prototype.updateAudioBuffers = function() {
      var buffer, j, len, ref;
      ref = this.audioBuffers;
      for (j = 0, len = ref.length; j < len; j++) {
        buffer = ref[j];
        if (buffer != null) {
          if (buffer.customData.playType === 1) {
            this.updateRandomAudio(buffer);
          }
          if (GameManager.settings.bgmVolume !== this.generalMusicVolume) {
            buffer.volume = (this.musicVolume * GameManager.settings.bgmVolume / 100) / 100;
          }
          buffer.update();
        }
      }
      if (GameManager.settings.bgmVolume !== this.generalMusicVolume) {
        return this.generalMusicVolume = GameManager.settings.bgmVolume;
      }
    };


    /**
    * Updates all audio-buffers depending on the play-type.
    *
    * @method updateAudioBuffers
    * @protected
     */

    AudioManager.prototype.updateGeneralVolume = function() {
      var k, reference, results;
      if (GameManager.settings.seVolume !== this.generalSoundVolume || GameManager.settings.voiceVolume !== this.generalVoiceVolume) {
        this.generalSoundVolume = GameManager.settings.seVolume;
        this.generalVoiceVolume = GameManager.settings.voiceVolume;
        results = [];
        for (k in this.soundReferences) {
          results.push((function() {
            var j, len, ref, results1;
            ref = this.soundReferences[k];
            results1 = [];
            for (j = 0, len = ref.length; j < len; j++) {
              reference = ref[j];
              if (reference.voice) {
                results1.push(reference.volume = (this.voiceVolume * GameManager.settings.voiceVolume / 100) / 100);
              } else {
                results1.push(reference.volume = (this.soundVolume * GameManager.settings.seVolume / 100) / 100);
              }
            }
            return results1;
          }).call(this));
        }
        return results;
      }
    };


    /**
    * Updates the audio-playback.
    *
    * @method update
     */

    AudioManager.prototype.update = function() {
      this.updateAudioBuffers();
      return this.updateGeneralVolume();
    };


    /**
    * Changes the current music to the specified one.
    *
    * @method changeMusic
    * @param {Object} music - The music to play. If <b>null</b> the current music will stop playing.
     */

    AudioManager.prototype.changeMusic = function(music) {
      if ((music != null) && (music.name != null)) {
        if ((this.music != null) && this.music.name !== music.name) {
          return this.playMusic(music);
        } else if (this.music == null) {
          return this.playMusic(music);
        }
      } else {
        return this.stopMusic();
      }
    };


    /**
    * Prepares. 
    *
    * @method prepare
    * @param {Object} music - The music to play. If <b>null</b> the current music will stop playing.
     */

    AudioManager.prototype.prepare = function(path, volume, rate) {
      var buffer;
      buffer = ResourceManager.getAudioBuffer(path);
      if (buffer.decoded) {
        buffer.volume = volume != null ? volume / 100 : 1.0;
        buffer.playbackRate = rate != null ? rate / 100 : 1.0;
      } else {
        buffer.onFinishDecode = (function(_this) {
          return function(source) {
            source.volume = volume != null ? volume / 100 : 1.0;
            return source.playbackRate = rate != null ? rate / 100 : 1.0;
          };
        })(this);
        buffer.decode();
      }
      return buffer;
    };


    /**
    * Plays an audio resource.
    *
    * @method play
    * @param {String} path - The path to the audio resource.
    * @param {number} volume - The volume.
    * @param {number} rate - The playback rate.
    * @param {number} fadeInTime - The fade-in time in frames.
     */

    AudioManager.prototype.play = function(path, volume, rate, fadeInTime) {
      var buffer;
      buffer = ResourceManager.getAudioStream(path);
      if (buffer.decoded) {
        buffer.volume = volume != null ? volume / 100 : 1.0;
        buffer.playbackRate = rate != null ? rate / 100 : 1.0;
        if (GameManager.settings.bgmEnabled) {
          buffer.play(fadeInTime);
        }
      } else {
        buffer.onFinishDecode = (function(_this) {
          return function(source) {
            source.volume = volume != null ? volume / 100 : 1.0;
            source.playbackRate = rate != null ? rate / 100 : 1.0;
            if (GameManager.settings.bgmEnabled) {
              return source.play(fadeInTime);
            }
          };
        })(this);
        buffer.decode();
      }
      return buffer;
    };


    /**
    * Stops all sounds.
    *
    * @method stopAllSounds
     */

    AudioManager.prototype.stopAllSounds = function() {
      var k, reference, results;
      results = [];
      for (k in this.soundReferences) {
        results.push((function() {
          var j, len, ref, results1;
          ref = this.soundReferences[k];
          results1 = [];
          for (j = 0, len = ref.length; j < len; j++) {
            reference = ref[j];
            results1.push(reference != null ? reference.stop() : void 0);
          }
          return results1;
        }).call(this));
      }
      return results;
    };


    /**
    * Stops a sound and all references of it.
    *
    * @method stopSound
    * @param {String} name - The name of the sound to stop.
     */

    AudioManager.prototype.stopSound = function(name) {
      var j, len, ref, reference, results;
      if (this.soundReferences[name] != null) {
        ref = this.soundReferences[name];
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          reference = ref[j];
          results.push(reference.stop());
        }
        return results;
      }
    };


    /**
    * Stops a voice.
    *
    * @method stopVoice
    * @param {String} name - The name of the voice to stop.
     */

    AudioManager.prototype.stopVoice = function(name) {
      return this.stopSound(name);
    };


    /**
    * Stops all voices.
    *
    * @method stopAllVoices
     */

    AudioManager.prototype.stopAllVoices = function() {
      var k, reference, results;
      results = [];
      for (k in this.soundReferences) {
        results.push((function() {
          var j, len, ref, results1;
          ref = this.soundReferences[k];
          results1 = [];
          for (j = 0, len = ref.length; j < len; j++) {
            reference = ref[j];
            if (reference.voice) {
              results1.push(reference.stop());
            } else {
              results1.push(void 0);
            }
          }
          return results1;
        }).call(this));
      }
      return results;
    };


    /**
    * Plays a voice.
    *
    * @method playVoice
    * @param {String} name - The name of the voice to play.
    * @param {number} volume - The voice volume.
    * @param {number} rate - The voice playback rate.
     */

    AudioManager.prototype.playVoice = function(name, volume, rate) {
      var ref, voice;
      voice = null;
      if (GameManager.settings.voiceEnabled && !((ref = $PARAMS.preview) != null ? ref.settings.voiceDisabled : void 0)) {
        voice = this.playSound(name != null ? name.name : void 0, volume || GameManager.defaults.audio.voiceVolume, rate || GameManager.defaults.audio.voicePlaybackRate, false, true);
      }
      return voice;
    };


    /**
    * Plays a sound.
    *
    * @method playSound
    * @param {String} name - The name of the sound to play.
    * @param {number} volume - The sound's volume.
    * @param {number} rate - The sound's playback rate.
    * @param {boolean} musicEffect - Indicates if the sound should be played as a music effect. In that case, the current music
    * at audio-layer will be paused until the sound finishes playing.
    * @param {boolean} voice - Indicates if the sound should be handled as a voice.
     */

    AudioManager.prototype.playSound = function(name, volume, rate, musicEffect, voice, loopSound) {
      var buffer, j, len, r, ref, ref1, reference;
      if ((ref = $PARAMS.preview) != null ? ref.settings.soundDisabled : void 0) {
        return;
      }
      if ((name == null) || (!voice && !GameManager.settings.soundEnabled)) {
        return;
      }
      if (name.name != null) {
        volume = name.volume;
        rate = name.playbackRate;
        name = name.name;
      }
      if (name.length === 0) {
        return;
      }
      if (musicEffect) {
        this.stopMusic();
      }
      if (this.soundReferences[name] == null) {
        this.soundReferences[name] = [];
      }
      volume = volume != null ? volume : 100;
      volume *= voice ? this.generalVoiceVolume / 100 : this.generalSoundVolume / 100;
      reference = null;
      ref1 = this.soundReferences[name];
      for (j = 0, len = ref1.length; j < len; j++) {
        r = ref1[j];
        if (!r.isPlaying) {
          reference = r;
          if (musicEffect) {
            reference.onEnd = (function(_this) {
              return function() {
                return _this.resumeMusic(40);
              };
            })(this);
          }
          reference.voice = voice;
          reference.volume = volume / 100;
          reference.playbackRate = rate / 100;
          reference.loop = loopSound;
          if (voice) {
            this.voice = reference;
          }
          reference.play();
          break;
        }
      }
      if (reference == null) {
        buffer = ResourceManager.getAudioBuffer("Audio/Sounds/" + name);
        if (buffer && buffer.loaded) {
          if (buffer.decoded) {
            reference = new GS.AudioBufferReference(buffer, voice);
            if (musicEffect) {
              reference.onEnd = (function(_this) {
                return function() {
                  return _this.resumeMusic(40);
                };
              })(this);
            }
            reference.volume = volume / 100;
            reference.playbackRate = rate / 100;
            reference.voice = voice;
            reference.loop = loopSound;
            reference.play();
            if (voice) {
              this.voice = reference;
            }
            this.soundReferences[name].push(reference);
          } else {
            buffer.name = name;
            buffer.onDecodeFinish = (function(_this) {
              return function(source) {
                reference = new GS.AudioBufferReference(source, voice);
                if (musicEffect) {
                  reference.onEnd = function() {
                    return _this.resumeMusic(40);
                  };
                }
                reference.voice = voice;
                reference.volume = volume / 100;
                reference.playbackRate = rate / 100;
                reference.loop = loopSound;
                if (voice) {
                  _this.voice = reference;
                }
                reference.play();
                return _this.soundReferences[source.name].push(reference);
              };
            })(this);
            buffer.decode();
          }
        }
      }
      return reference;
    };


    /**
    * Plays a music as a random music. A random music will fade-in and fade-out
    * at random times. That can be combined with other audio-layers to create a
    * much better looping of an audio track.
    *
    * @method playMusicRandom
    * @param {Object} music - The music to play.
    * @param {number} fadeTime - The time for a single fade-in/out in frames.
    * @param {number} layer - The audio layer to use.
    * @param {gs.Range} playTime - Play-Time range like 10s to 30s.
    * @param {gs.Range} playRange - Play-Range.
     */

    AudioManager.prototype.playMusicRandom = function(music, fadeTime, layer, playTime, playRange) {
      var musicBuffer, ref, volume;
      if ((ref = $PARAMS.preview) != null ? ref.settings.musicDisabled : void 0) {
        return;
      }
      layer = layer != null ? layer : 0;
      volume = music.volume != null ? music.volume : 100;
      volume = volume * (this.generalMusicVolume / 100);
      this.musicVolume = volume;
      this.disposeMusic(layer);
      if ((music.name != null) && music.name.length > 0) {
        musicBuffer = this.play("Audio/Music/" + music.name, volume, music.rate);
        musicBuffer.loop = true;
        musicBuffer.volume = 0;
        musicBuffer.duration = Math.round(musicBuffer.duration * 1000 / 16.6);
        musicBuffer.customData.playType = 1;
        musicBuffer.customData.playTime = playTime;
        if (playRange.end === 0) {
          musicBuffer.customData.playRange = {
            start: playRange.start,
            end: musicBuffer.duration
          };
        } else {
          musicBuffer.customData.playRange = playRange;
        }
        musicBuffer.customData.fadeTime = fadeTime;
        musicBuffer.customData.startTimer = Math.round(musicBuffer.customData.playRange.start + Math.random() * (musicBuffer.customData.playRange.end - musicBuffer.customData.playRange.start));
        if (!this.audioBuffers.contains(musicBuffer)) {
          this.audioBuffers.push(musicBuffer);
        }
        this.audioBuffersByLayer[layer] = musicBuffer;
        return this.audioLayers[layer] = {
          name: music.name,
          time: music.currentTime,
          volume: music.volume,
          rate: music.playbackRate,
          fadeInTime: fadeTime,
          customData: musicBuffer.customData
        };
      }
    };


    /**
    * Plays a music.
    *
    * @method playMusic
    * @param {string|Object} name - The music to play. Can be just a name or a music data-object.
    * @param {number} volume - The music's volume in percent.
    * @param {number} rate - The music's playback rate in percent.
    * @param {number} fadeInTime - The fade-in time.
    * @param {number} layer - The layer to play the music on.
    * @param {boolean} loop - Indicates if the music should be looped
     */

    AudioManager.prototype.playMusic = function(name, volume, rate, fadeInTime, layer, loopMusic) {
      var musicBuffer, ref;
      if ((ref = $PARAMS.preview) != null ? ref.settings.musicDisabled : void 0) {
        return;
      }
      if (loopMusic == null) {
        loopMusic = true;
      }
      if ((name != null) && (name.name != null)) {
        layer = layer != null ? layer : rate || 0;
        fadeInTime = volume;
        volume = name.volume;
        rate = name.playbackRate;
        name = name.name;
      } else {
        layer = layer != null ? layer : 0;
      }
      this.disposeMusic(layer);
      this.audioLayers[layer] = {
        name: name,
        volume: volume,
        rate: rate,
        fadeInTime: fadeInTime,
        playing: true
      };
      volume = volume != null ? volume : 100;
      volume = volume * (this.generalMusicVolume / 100);
      this.musicVolume = volume;
      if ((name != null) && name.length > 0) {
        this.music = {
          name: name
        };
        musicBuffer = this.play("Audio/Music/" + name, volume, rate, fadeInTime);
        musicBuffer.loop = loopMusic;
        if (!this.audioBuffers.contains(musicBuffer)) {
          this.audioBuffers.push(musicBuffer);
        }
        this.audioBuffersByLayer[layer] = musicBuffer;
      }
      return musicBuffer;
    };


    /**
    * Resumes a paused music.
    *
    * @method resumeMusic
    * @param {number} fadeInTime - The fade-in time in frames.
    * @param {number} layer - The audio layer to resume.
     */

    AudioManager.prototype.resumeMusic = function(fadeInTime, layer) {
      var ref;
      layer = layer != null ? layer : 0;
      if ((this.audioBuffersByLayer[layer] != null) && !this.audioBuffersByLayer[layer].isPlaying) {
        this.audioBuffersByLayer[layer].resume(fadeInTime);
        return (ref = this.audioLayers[layer]) != null ? ref.playing = true : void 0;
      }
    };


    /**
    * Stops a music.
    *
    * @method stopMusic
    * @param {number} fadeOutTime - The fade-out time in frames.
    * @param {number} layer - The audio layer to stop.
     */

    AudioManager.prototype.stopMusic = function(fadeOutTime, layer) {
      var ref, ref1, ref2;
      layer = layer != null ? layer : 0;
      if ((ref = this.audioBuffersByLayer[layer]) != null) {
        ref.stop(fadeOutTime);
      }
      if ((ref1 = this.audioBuffersByLayer[layer]) != null) {
        ref1.customData = {};
      }
      if ((ref2 = this.audioLayers[layer]) != null) {
        ref2.playing = false;
      }
      return this.music = null;
    };


    /**
    * Stops all music/audio layers.
    *
    * @method stopAllMusic
    * @param {number} fadeOutTime - The fade-out time in frames.
     */

    AudioManager.prototype.stopAllMusic = function(fadeOutTime) {
      var buffer, j, len, ref;
      ref = this.audioBuffers;
      for (j = 0, len = ref.length; j < len; j++) {
        buffer = ref[j];
        if (buffer != null) {
          buffer.stop(fadeOutTime);
          buffer.customData = {};
        }
      }
      return this.music = null;
    };

    AudioManager.prototype.dispose = function(context) {
      var buffer, data, j, layer, len, ref, results;
      data = context.resources.select(function(r) {
        return r.data;
      });
      ref = this.audioBuffersByLayer;
      results = [];
      for (layer = j = 0, len = ref.length; j < len; layer = ++j) {
        buffer = ref[layer];
        if (buffer && data.indexOf(buffer) !== -1) {
          buffer.dispose();
          this.audioBuffers.remove(buffer);
          this.audioBuffersByLayer[layer] = null;
          results.push(this.audioLayers[layer] = null);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Disposes a music.
    *
    * @method disposeMusic
    * @param {number} layer - The audio layer of the music to dispose.
     */

    AudioManager.prototype.disposeMusic = function(layer) {
      layer = layer != null ? layer : 0;
      this.stopMusic(0, layer);
      this.audioBuffers.remove(this.audioBuffersByLayer[layer]);
      this.audioBuffersByLayer[layer] = null;
      return this.audioLayers[layer] = null;
    };

    return AudioManager;

  })();

  window.AudioManager = new AudioManager();

  gs.AudioManager = AudioManager;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var DataManager;

  DataManager = (function() {

    /**
    * Manages the game's data like loading documents. Documents are stored
    * in the data folder of the game in JSON format. The UID is used as the file-name.
    * A document has the following structure:<br>
    * <br>
    * UID - Unique Identifier<br>
    * Items -> An object containing all the items/fields of the document.<br>
    * Items.Type -> The type of the document<br>
    * Items.Name -> The name of the document<br>
    * <br>
    * @module gs
    * @class DataManager
    * @memberof gs
    * @constructor
     */
    function DataManager() {

      /**
      * Stores all documents by UID.
      * @property documentsByUid
      * @type gs.Document[]
       */
      this.documentsByUid = {};

      /**
      * Stores all documents.
      * @property documents
      * @type gs.Document[]
       */
      this.documents = [];

      /**
      * Indiciates if all requested documents are loaded.
      * @property documentsLoaded
      * @type boolean
       */
      this.documentsLoaded = true;

      /**
      * @property events
      * @type gs.EventEmitter
       */
      this.events = new gs.EventEmitter();
    }


    /**
    * Unloads all documents with a specified type.
    *
    * @method disposeDocumentsByType
    * @param {String} type - The document type.
     */

    DataManager.prototype.disposeDocumentsByType = function(type) {
      var d, i;
      i = 0;
      while (i < this.documents.length) {
        d = this.documents[i];
        if (d && d.items && d.items.type === type) {
          this.documents.remove(d);
          this.documentsByUid[d.uid] = null;
          GS.dataCache[d.uid] = null;
          delete this.documentsByUid[d.uid];
          delete GS.dataCache[d.uid];
          i--;
        }
        i++;
      }
      return null;
    };


    /**
    * Gets all documents with a specified type.
    *
    * @method getDocumentsByType
    * @param {String} type - The document type.
    * @return {gs.Document[]} The documents.
     */

    DataManager.prototype.getDocumentsByType = function(type) {
      var result, summary, uid;
      result = [];
      for (uid in this.summaries.items) {
        summary = this.summaries.items[uid];
        if ((summary.items != null) && summary.items.type === type) {
          result.push(this.getDocument(uid));
        }
      }
      return result;
    };


    /**
    * Gets the first document with the specified type.
    *
    * @method getDocumentByType
    * @param {String} type - The document type.
    * @return {gs.Document} The document or <b>null</b> if a document with the specified type doesn't exist.
     */

    DataManager.prototype.getDocumentByType = function(type) {
      var result, summary, uid;
      result = null;
      for (uid in this.summaries.items) {
        summary = this.summaries.items[uid];
        if ((summary.items != null) && summary.items.type === type) {
          result = this.getDocument(uid);
          break;
        }
      }
      return result;
    };


    /**
    * Gets a document by its UID.
    *
    * @method getDocument
    * @param {String} uid - The UID of the document to get.
    * @return {gs.Document} The document or <b>null</b> if a document with the specified UID doesn't exist.
     */

    DataManager.prototype.getDocument = function(uid) {
      var result, summary;
      result = this.documentsByUid[uid];
      if (!uid) {
        return null;
      }
      if (result == null) {
        gs.Data.load(uid, (function(_this) {
          return function(dataObject, error) {
            var r;
            if (!error) {
              r = _this.documentsByUid[dataObject.uid];
              r.items = dataObject.items;
              return r.loaded = true;
            }
          };
        })(this));
        if (this.summaries && this.summaries.items) {
          summary = this.summaries.items[uid];
          if (summary) {
            result = {
              uid: uid,
              items: summary.items,
              loaded: false
            };
          }
        } else {
          result = {
            uid: uid,
            loaded: false
          };
        }
        if (result) {
          this.documentsByUid[uid] = result;
          this.documents.push(result);
          this.documentsLoaded = false;
        }
        if (uid === "SUMMARIES") {
          this.summaries = result;
        }
      }
      return result;
    };


    /**
    * Gets a document by its UID. If the document isn't already loaded this method
    * only returned document only contains summary data.
    *
    * @method getDocumentSummary
    * @param {String} uid - The UID of the document to get.
    * @return {gs.Document} The document or <b>null</b> if a document with the specified UID doesn't exist.
     */

    DataManager.prototype.getDocumentSummary = function(uid) {
      return this.summaries.items[uid];
    };


    /**
    * Updates the loading process of documents.
    *
    * @method update
     */

    DataManager.prototype.update = function() {
      var i, j, ref;
      if (!this.documentsLoaded) {
        this.documentsLoaded = true;
        for (i = j = 0, ref = this.documents.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
          if (!this.documents[i].loaded) {
            this.documentsLoaded = false;
            break;
          }
        }
        if (this.documentsLoaded) {
          this.events.emit("loaded", this);
        }
      }
      return null;
    };

    return DataManager;

  })();

  window.DataManager = DataManager;

  gs.DataManager = DataManager;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var RecordManager;

  RecordManager = (function() {

    /**
    * Manages the game's database and gives access to all data-records.
    *
    * @module gs
    * @class RecordManager
    * @memberof gs
    * @constructor
     */
    function RecordManager() {

      /**
      * Stores all data-record documents
      * @property documents
      * @type gs.Document[]
       */
      this.documents = null;

      /**
      * Stores all data-record documents by category > id.
      * @property collectionDocuments
      * @type gs.Document[][]
       */
      this.collectionDocuments = [];

      /**
      * Localizable strings of all data-record documents.
      * @property localizableStrings
      * @type Object
       */
      this.localizableStrings = {};

      /**
      * Indicates if all data-records are already translated.
      * @property translated
      * @type boolean
       */
      this.translated = false;

      /**
      * Indicates if all data-records are loaded and initialized.
      * @property initialized
      * @type boolean
       */
      this.initialized = false;
    }


    /**
    * Loads all data-record documents.
    *
    * @method load
     */

    RecordManager.prototype.load = function() {
      return this.documents = DataManager.getDocumentsByType("data_record");
    };


    /**
    * Initializes RecordManager and all loaded data-record documents for use. Needs to be
    * called before RecordManager can be used.
    *
    * @method initialize
     */

    RecordManager.prototype.initialize = function() {
      var color, document, i, iconSets, j, k, l, len, len1, len2, objectPosition, ref, ref1, ref2;
      iconSets = [];
      ref = this.documents;
      for (j = 0, len = ref.length; j < len; j++) {
        document = ref[j];
        if (this[document.items.category] == null) {
          this[document.items.category] = [];
          this[document.items.category + "Collection"] = [];
          this[document.items.category + "Array"] = [];
          this.collectionDocuments.push(this[document.items.category + "Collection"]);
        }
        if (document.items.id != null) {
          this[document.items.category][document.items.id] = document.items.data;
          this[document.items.category].push(document.items.data);
          this[document.items.category + "Collection"][document.items.id] = document;
          this[document.items.category + "Collection"].push(document);
          this[document.items.category + "Array"].push(document.items.data);
          document.items.data.index = document.items.id;
        }
        if ((document.items.data != null) && (document.items.data.icon != null)) {
          if (iconSets.indexOf(document.items.data.icon.name) === -1) {
            iconSets.push(document.items.data.icon.name);
          }
        }
        if (document.items.localizableStrings != null) {
          Object.mixin(this.localizableStrings, document.items.localizableStrings);
        }
      }
      this.system = this.system[0];
      this.system.iconSets = iconSets;
      if (this.system.colors) {
        ref1 = this.system.colors;
        for (i = k = 0, len1 = ref1.length; k < len1; i = ++k) {
          color = ref1[i];
          this.system.colors[i] = new Color(color);
        }
      }
      ref2 = this.system.objectPositions;
      for (l = 0, len2 = ref2.length; l < len2; l++) {
        objectPosition = ref2[l];
        if (!objectPosition) {
          continue;
        }
        objectPosition.func = eval("(function(object, params){" + objectPosition.script + "})");
      }
      return this.initialized = true;
    };


    /**
    * Translates all localizable fields for each data-record.
    *
    * @method translate
     */

    RecordManager.prototype.translate = function() {
      var document, j, len, ref, results;
      if (!this.translated) {
        this.translated = true;
        ref = this.documents;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          document = ref[j];
          if ((document.items.data.name != null) && (document.items.data.name.lcId != null)) {
            document.items.data.name = lcs(document.items.data.name);
          }
          if ((document.items.data.description != null) && (document.items.data.description.lcId != null)) {
            document.items.data.description = lcs(document.items.data.description);
          }
          if ((document.items.data.removeMessage != null) && (document.items.data.removeMessage.lcId != null)) {
            document.items.data.removeMessage = lcs(document.items.data.removeMessage);
          }
          if ((document.items.data.usingMessage != null) && (document.items.data.usingMessage.lcId != null)) {
            results.push(document.items.data.usingMessage = lcs(document.items.data.usingMessage));
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };

    return RecordManager;

  })();

  window.RecordManager = new RecordManager();

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Formula, Space, Style, UIManager;

  Formula = (function() {

    /**
    * Encapsulates a UI formula. A formula can be used in UI layouts to define
    * property-bindings or to implement a specific behavior.
    *
    * @module ui
    * @class Formula
    * @memberof ui
    * @constructor
    * @param {Function} f - The formula-function. Defines the logic of the formula.
    * @param {Object} data - An optional data-object which can be accessed inside the formula-function.
    * @param {string} event - An optional event-name to define when the formula should be executed.
     */
    function Formula(f, data, event) {

      /**
      * Indicates if its the first time the formula is called.
      * @property onInitialize
      * @type boolean
       */
      var i, j, l, ref, ref1;
      this.onInitialize = true;

      /**
      * The formula-function.
      * @property exec_
      * @type Function
       */
      this.exec_ = f;

      /**
      * An optional data-object which can bes accessed inside the formula-function.
      * @property data
      * @type Object
       */
      this.data = data;

      /**
      * An optional event-name to define when the formula should be executed.
      * @property event
      * @type string
       */
      this.event = event;

      /**
      * An array of custom number-data which can be used for different purposes. The first element
      * is also used in onChange method to store the old value and check against the new one to detect a change.
      * @property numbers
      * @type number[]
       */
      this.numbers = new Array(10);
      for (i = j = 0, ref = this.numbers.length; 0 <= ref ? j <= ref : j >= ref; i = 0 <= ref ? ++j : --j) {
        this.numbers[i] = 0;
      }

      /**
      * An array of custom string-data which can be used for different purposes. The first element
      * is also used in onTextChange method to store the old value and check against the new one to detect a change.
      * @property strings
      * @type string[]
       */
      this.strings = new Array(10);
      for (i = l = 0, ref1 = this.strings.length; 0 <= ref1 ? l <= ref1 : l >= ref1; i = 0 <= ref1 ? ++l : --l) {
        this.strings[i] = "";
      }
    }


    /**
    * The formula-function. Its a wrapper-function before the first-time call was made.
    * @method exec
     */

    Formula.prototype.exec = function() {
      var r;
      this.exec = this.exec_;
      r = this.exec_.apply(this, arguments);
      this.onInitialize = false;
      return r;
    };


    /**
    * Checks if the specified number-value has changed since the last check. It uses
    * the first entry of the numbers-array to store the value and check against the new one.
    *
    * @method onChange
    * @param {number} numberValue - Number value to check.
     */

    Formula.prototype.onChange = function(numberValue) {
      var result;
      result = this.numbers[0] !== numberValue;
      this.numbers[0] = numberValue;
      return result;
    };


    /**
    * Checks if the specified text-value has changed since the last check. It uses
    * the first entry of the strings-array to store the value and check against the new one.
    *
    * @method onTextChange
    * @param {string} textValue - Text value to check.
     */

    Formula.prototype.onTextChange = function(textValue) {
      var result;
      result = this.strings[0] !== textValue;
      this.strings[0] = textValue;
      return result;
    };

    return Formula;

  })();

  ui.Formula = Formula;

  Space = (function() {

    /**
    * Describes a space inside or around something like a margin or padding.
    *
    * @module ui
    * @class Space
    * @memberof ui
    * @constructor
    * @param {number} left - Space at the left in pixels.
    * @param {number} top - Space at the top in pixels.
    * @param {number} right - Space at the right in pixels.
    * @param {number} bottom - Space at the bottom in pixels.
     */
    function Space(left, top, right, bottom) {

      /**
      * Space at the left in pixels.
      * @property left
      * @type number
       */
      this.left = left;

      /**
      * Space at the top in pixels.
      * @property top
      * @type number
       */
      this.top = top;

      /**
      * Space at the right in pixels.
      * @property right
      * @type number
       */
      this.right = right;

      /**
      * Space at the bottom in pixels.
      * @property bottom
      * @type number
       */
      this.bottom = bottom;
    }


    /**
    * Sets the coordinates of the space by copying them from a specified space.
    *
    * @method setFromObject
    * @param {Object} space - A space to copy.
     */

    Space.prototype.setFromObject = function(space) {
      this.left = space.left;
      this.top = space.top;
      this.right = space.right;
      return this.bottom = space.bottom;
    };


    /**
    * Sets the coordinates of the space.
    *
    * @method set
    * @param {number} left - Space at the left in pixels.
    * @param {number} top - Space at the top in pixels.
    * @param {number} right - Space at the right in pixels.
    * @param {number} bottom - Space at the bottom in pixels.
     */

    Space.prototype.set = function(left, top, right, bottom) {
      this.left = left;
      this.top = top;
      this.right = right;
      return this.bottom = bottom;
    };


    /**
    * Creates a new space object from an array of coordinates.
    *
    * @method fromArray
    * @static
    * @param {number[]} array - An array of coordinates (left, top right, bottom).
     */

    Space.fromArray = function(array) {
      return new ui.Space(array[0], array[1], array[2], array[3]);
    };

    return Space;

  })();

  ui.Space = Space;

  Style = (function() {

    /**
    * A UI style can applied to a UI object to modify it properties like color, image, etc. to give a certain "style" to it.
    *
    * @module ui
    * @class Style
    * @memberof ui
    * @constructor
    * @param {Object} descriptor - A style-descriptor to initialize the style from.
    * @param {number} id - A unique numeric ID to access the style through UIManager.stylesById collection.
    * @param {number} selector - A selector ID which controls under which conditions the styles will be applied.
     */
    function Style(descriptor, id, selector) {

      /**
      * ID number to quickly access this style and link to this style.
      * @property id
      * @type number
       */
      this.id = id;

      /**
      * Style-ID of target object. This style will only be applied on UI objects with that style ID which are
      * children of UI objects where this style is applied.
      * @property target
      * @type number
       */
      this.target = -1;

      /**
      * Selector-ID which controls under which conditions the style becomes active.
      * @property selector
      * @type number
       */
      this.selector = selector;

      /**
      * The font used for the text-display.
      * @default null
      * @property font
      * @type gs.Font
       */
      this.font = null;

      /**
      * The UI object's image used for visual presentation.
      * @property image
      * @type string
       */
      this.image = null;

      /**
      * The UI object's animations used for visual presentation.
      * @default null
      * @property animations
      * @type Object[]
       */
      this.animations = null;

      /**
      * The UI object's color.
      * @property color
      * @type gs.Color
       */
      this.color = null;

      /**
      * The UI object's tone.
      * @property tone
      * @type gs.Tone
       */
      this.tone = null;

      /**
      * The UI object's anchor-point. For example: An anchor-point with 0,0 places the object with its top-left corner
      * at its position but with an 0.5, 0.5 anchor-point the object is placed with its center. An anchor-point of 1,1
      * places the object with its lower-right corner.
      * @property anchor
      * @type gs.Point
       */
      this.anchor = null;

      /**
      * The UI object's zoom-setting for x and y axis.
      * @default new gs.Point(1.0, 1.0)
      * @property zoom
      * @type gs.Point
       */
      this.zoom = null;

      /**
      * The UI object's margin. The margin defines an extra space around the UI object. 
      * The default is { left: 0, top: 0, right: 0, bottom: 0 }.
      * @property margin
      * @type Object
       */
      this.margin = null;

      /**
      * The UI object's padding. The default is { left: 0, top: 0, right: 0, bottom: 0 }.
      * @property padding
      * @type Object
       */
      this.padding = null;

      /**
      * The UI object's mask for masking-effects.
      * @property mask
      * @type gs.Mask
       */
      this.mask = null;

      /**
      * The UI object's alignment.
      * @property alignment
      * @type ui.Alignment
       */
      this.alignment = -1;

      /**
      * The UI object's opacity to control transparency. For example: 0 = Transparent, 255 = Opaque, 128 = Semi-Transparent.
      * @property opacity
      * @type number
       */
      this.opacity = -1;

      /**
      * The object's clip-rect for visual presentation.
      * @default null
      * @property clipRect
      * @type gs.Rect
      * @protected
       */
      this.clipRect = null;

      /**
      * The corner-size of the frame.
      * @property frameCornerSize
      * @type number
       */
      this.frameCornerSize = -1;

      /**
      * The thickness of the frame.
      * @property frameThickness
      * @type number
       */
      this.frameThickness = -1;

      /**
      * The looping of the image.
      * @property looping
      * @type ui.Orientation
       */
      this.looping = null;

      /**
      * The object's z-index controls rendering-order/image-overlapping. An object with a smaller z-index is rendered
      * before an object with a larger index. For example: To make sure a game object is always on top of the screen, it
      * should have the largest z-index of all game objects.
      * @property zIndex
      * @type number
       */
      this.zIndex = -1;

      /**
      * The object's alignment on x-axis. Needs to be supported by layout.
      * @property alignmentX
      * @type number
       */
      this.alignmentX = -1;

      /**
      * The object's alignment on y-axis. Needs to be supported by layout.
      * @property alignmentY
      * @type number
       */
      this.alignmentY = -1;

      /**
      * The object's resize behavior.
      * @property resizable
      * @type boolean
       */
      this.resizable = null;

      /**
      * The original style descriptor.
      * @property descriptor
      * @type Object
       */
      this.descriptor = descriptor;
      if (descriptor) {
        this.setFromDescriptor(descriptor);
      }
    }


    /**
    * Initializes the style from a style-descriptor.
    *
    * @method setFromDescriptor
    * @param {Object} descriptor - The style-descriptor.
     */

    Style.prototype.setFromDescriptor = function(descriptor) {
      this.descriptor = descriptor;
      this.image = descriptor.image;
      if (descriptor.color) {
        this.color = gs.Color.fromArray(descriptor.color);
      }
      if (descriptor.tone) {
        this.tone = gs.Tone.fromArray(descriptor.tone);
      }
      if (descriptor.anchor) {
        this.anchor = new gs.Point(descriptor.anchor[0], descriptor.anchor[1]);
      }
      if (descriptor.zoom) {
        this.zoom = new gs.Point(descriptor.zoom[0], descriptor.zoom[1]);
      }
      if (descriptor.font) {
        this.setupFont(descriptor);
      }
      if (descriptor.clipRect) {
        this.clipRect = gs.Rect.fromArray(descriptor.clipRect);
      }
      if (descriptor.opacity >= 0) {
        this.opacity = descriptor.opacity;
      }
      if (descriptor.alignment >= 0) {
        this.alignment = descriptor.alignment;
      }
      if (descriptor.margin) {
        this.margin = ui.Space.fromArray(descriptor.margin);
      }
      if (descriptor.padding) {
        this.padding = ui.Space.fromArray(descriptor.padding);
      }
      this.animations = descriptor.animations;
      if (descriptor.frameCornerSize) {
        this.frameCornerSize = descriptor.frameCornerSize;
      }
      if (descriptor.frameThickness) {
        this.frameThickness = descriptor.frameThickness;
      }
      if (descriptor.frame) {
        this.frame = descriptor.frame;
      }
      if (descriptor.looping) {
        this.looping = descriptor.looping;
      }
      if (descriptor.resizable != null) {
        this.resizable = descriptor.resizable;
      }
      if (descriptor.zIndex) {
        this.zIndex = descriptor.zIndex;
      }
      if (descriptor.alignmentX) {
        this.alignmentX = ui.UIManager.alignments[descriptor.alignmentX];
      }
      if (descriptor.alignmentY) {
        return this.alignmentY = ui.UIManager.alignments[descriptor.alignmentY];
      }
    };

    Style.prototype.set = function(style) {
      this.image = style.image;
      this.color.setFromObject(style.color);
      this.tone.setFromObject(style.tone);
      this.anchor.set(style.anchor.x, style.anchor.y);
      this.zoom.set(style.zoom.x, style.zoom.y);
      if (style.font) {
        if (!this.font) {
          this.font = new gs.Font(style.font.name, style.font.size);
        }
        this.font.set(style.font);
      }
      if (style.clipRect) {
        if (!this.clipRect) {
          this.clipRect = new gs.Rect();
        }
        this.clipRect.setFromObject(style.clipRect);
      }
      this.opacity = style.opacitz;
      this.alignment = style.alignment;
      this.margin.setFromObject(style.margin);
      return this.padding.setFromObject(style.padding);
    };


    /**
    * Initializes font-data from a style-descriptor.
    *
    * @method setupFont
    * @param {Object} descriptor - The style-descriptor.
    * @protected
     */

    Style.prototype.setupFont = function(descriptor) {
      var ref, ref1, ref10, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9;
      if (descriptor.font) {
        if (!this.font) {
          this.font = new Font(descriptor.font.name, (ref = descriptor.font.size) != null ? ref : 0);
        } else {
          this.font.name = descriptor.font.name;
          this.font.size = (ref1 = descriptor.font.size) != null ? ref1 : 0;
        }
        this.font.bold = (ref2 = descriptor.font.bold) != null ? ref2 : this.font.bold;
        this.font.italic = (ref3 = descriptor.font.italic) != null ? ref3 : this.font.italic;
        this.font.smallCaps = (ref4 = descriptor.font.smallCaps) != null ? ref4 : this.font.smallCaps;
        this.font.underline = (ref5 = descriptor.font.underline) != null ? ref5 : this.font.underline;
        this.font.strikeThrough = (ref6 = descriptor.font.strikeThrough) != null ? ref6 : this.font.strikeThrough;
        if (descriptor.font.color != null) {
          this.font.color.setFromArray(descriptor.font.color);
        }
        if (descriptor.font.border != null) {
          this.font.border = (ref7 = descriptor.font.border) != null ? ref7 : false;
          this.font.borderSize = (ref8 = descriptor.font.borderSize) != null ? ref8 : 4;
          this.font.borderColor.set(0, 0, 0, 255);
        }
        if (descriptor.font.outline != null) {
          this.font.border = (ref9 = descriptor.font.outline) != null ? ref9 : false;
          this.font.borderSize = (ref10 = descriptor.font.outline.size) != null ? ref10 : 4;
          if (descriptor.font.outline.color != null) {
            return this.font.borderColor.setFromArray(descriptor.font.outline.color);
          } else {
            return this.font.borderColor.set(0, 0, 0, 255);
          }
        }
      }
    };


    /**
    * Applies the style to a UI object.
    *
    * @method apply
    * @param {ui.Object_UIElement} object - The UI object where the style should be applied to.
     */

    Style.prototype.apply = function(object) {
      var ref, ref1;
      if (!object.activeStyles.contains(this)) {
        object.activeStyles.push(this);
        if (this.font) {
          if ((ref = object.font) != null) {
            ref.set(this.font);
          }
        }
        if (this.color) {
          object.color.set(this.color);
        }
        if (this.tone) {
          if ((ref1 = object.tone) != null) {
            ref1.set(this.tone);
          }
        }
        if (this.image) {
          object.image = this.image;
        }
        if (this.anchor) {
          object.anchor.set(this.anchor.x, this.anchor.y);
        }
        if (this.zoom) {
          object.zoom.set(this.zoom.x, this.zoom.y);
        }
        if (this.padding) {
          object.padding.setFromObject(this.padding);
        }
        if (this.margin) {
          object.margin.setFromObject(this.margin);
        }
        if (this.opacity >= 0) {
          object.opacity = this.opacity;
        }
        if (this.alignment >= 0) {
          object.alignment = this.alignment;
        }
        if (this.frameThickness >= 0) {
          object.frameThickness = this.frameThickness;
        }
        if (this.frameCornerSize >= 0) {
          object.frameCornerSize = this.frameCornerSize;
        }
        if (this.mask) {
          object.mask.set(this.mask);
        }
        if (this.zIndex >= 0) {
          object.zIndex = this.zIndex;
        }
        if (this.alignmentX >= 0) {
          object.alignmentX = this.alignmentX;
        }
        if (this.alignmentY >= 0) {
          object.alignmentY = this.alignmentY;
        }
        if (this.resizable != null) {
          object.resizable = this.resizable;
        }
        this.applyLooping(object);
        return this.applyAnimations(object);
      }
    };


    /**
    * Applies the looping-data of the style to a UI object.
    *
    * @method applyLooping
    * @param {ui.Object_UIElement} object - The UI object where the looping-data should be applied to.
    * @protected
     */

    Style.prototype.applyLooping = function(object) {
      if (this.looping) {
        if (!object.visual.looping) {
          object.visual.dispose();
          object.removeComponent(object.visual);
          object.visual = new gs.Component_TilingSprite();
          object.addComponent(object.visual);
        }
        object.visual.looping.vertical = this.looping.vertical;
        return object.visual.looping.horizontal = this.looping.horizontal;
      }
    };


    /**
    * Applies the animation-data of the style to a UI object. This automatically adds an animation-handler
    * component(ui.Component_AnimationHandler) with the id "animationHandler" to the UI object if not already exists.
    *
    * @method applyAnimations
    * @param {ui.Object_UIElement} object - The UI object where the animation-data should be applied to.
    * @protected
     */

    Style.prototype.applyAnimations = function(object) {
      if (this.animations) {
        object.animations = Object.deepCopy(this.animations);
        if (!object.findComponentById("animationHandler")) {
          object.animationExecutor = new ui.Component_AnimationExecutor();
          object.addComponent(new ui.Component_AnimationHandler(), "animationHandler");
          return object.addComponent(object.animationExecutor, "animationExecutor");
        }
      }
    };


    /**
    * Reverts the changes from a UI object made by this style. However, this resets all styleable properties
    * were set by this style. So it is necessary to apply all other styles again, but that is already handles in
    * ui.Component_UIBehavior.
    *
    * @method revert
    * @param {ui.Object_UIElement} object - The UI object where the style should be reverted.
     */

    Style.prototype.revert = function(object) {
      var activeStyles, i1, j, j1, k1, l, l1, m1, n, o, p, q, ref, ref1, s, t, u, w, x, y, z;
      activeStyles = object.activeStyles;
      if (object.activeStyles.contains(this)) {
        object.activeStyles.remove(this);
        if (this.font) {
          object.font.set(gs.Fonts.TEXT);
          for (j = activeStyles.length - 1; j >= 0; j += -1) {
            s = activeStyles[j];
            if (s.font) {
              object.font.set(s.font);
              break;
            }
          }
        }
        if (this.color) {
          object.color.set(Color.WHITE);
          for (l = activeStyles.length - 1; l >= 0; l += -1) {
            s = activeStyles[l];
            if (s.color) {
              object.color.set(s.color);
              break;
            }
          }
        }
        if (this.tone) {
          if ((ref = object.tone) != null) {
            ref.set(0, 0, 0, 0);
          }
          for (n = activeStyles.length - 1; n >= 0; n += -1) {
            s = activeStyles[n];
            if (s.tone) {
              if ((ref1 = object.tone) != null) {
                ref1.set(s.tone);
              }
              break;
            }
          }
        }
        if (this.image) {
          object.image = null;
          for (o = activeStyles.length - 1; o >= 0; o += -1) {
            s = activeStyles[o];
            if (s.image) {
              object.image = s.image;
              break;
            }
          }
        }
        if (this.anchor) {
          object.anchor.set(0, 0);
          for (p = activeStyles.length - 1; p >= 0; p += -1) {
            s = activeStyles[p];
            if (s.anchor) {
              object.anchor.setFromObject(s.anchor);
              break;
            }
          }
        }
        if (this.zoom) {
          object.zoom.set(1.0, 1.0);
          for (q = activeStyles.length - 1; q >= 0; q += -1) {
            s = activeStyles[q];
            if (s.zoom) {
              object.zoom.setFromObject(s.zoom);
              break;
            }
          }
        }
        if (this.padding) {
          object.padding.set(0, 0, 0, 0);
          for (t = activeStyles.length - 1; t >= 0; t += -1) {
            s = activeStyles[t];
            if (s.padding) {
              object.padding.setFromObject(s.padding);
              break;
            }
          }
        }
        if (this.margin) {
          object.margin.set(0, 0, 0, 0);
          for (u = activeStyles.length - 1; u >= 0; u += -1) {
            s = activeStyles[u];
            if (s.margin) {
              object.margin.setFromObject(s.margin);
              break;
            }
          }
        }
        if (this.opacity >= 0) {
          object.opacity = 255;
          for (w = activeStyles.length - 1; w >= 0; w += -1) {
            s = activeStyles[w];
            if (s.opacity >= 0) {
              object.opacity = s.opacity;
              break;
            }
          }
        }
        if (this.alignment >= 0) {
          object.alignment = 0;
          for (x = activeStyles.length - 1; x >= 0; x += -1) {
            s = activeStyles[x];
            if (s.alignment >= 0) {
              object.alignment = s.alignment;
              break;
            }
          }
        }
        if (this.frameCornerSize >= 0) {
          object.frameCornerSize = 16;
          for (y = activeStyles.length - 1; y >= 0; y += -1) {
            s = activeStyles[y];
            if (s.frameCornerSize >= 0) {
              object.frameCornerSize = s.frameCornerSize;
              break;
            }
          }
        }
        if (this.frameThickness >= 0) {
          object.frameThickness = 16;
          for (z = activeStyles.length - 1; z >= 0; z += -1) {
            s = activeStyles[z];
            if (s.frameThickness >= 0) {
              object.frameThickness = s.frameThickness;
              break;
            }
          }
        }
        if (this.mask) {
          object.mask.set(null);
          for (i1 = activeStyles.length - 1; i1 >= 0; i1 += -1) {
            s = activeStyles[i1];
            if (s.mask) {
              object.mask.set(s.font);
              break;
            }
          }
        }
        if (this.zIndex >= 0) {
          object.zIndex = 0;
          for (j1 = activeStyles.length - 1; j1 >= 0; j1 += -1) {
            s = activeStyles[j1];
            if (s.zIndex >= 0) {
              object.zIndex = s.zIndex;
              break;
            }
          }
        }
        if (this.alignmentX >= 0) {
          object.alignmentX = 0;
          for (k1 = activeStyles.length - 1; k1 >= 0; k1 += -1) {
            s = activeStyles[k1];
            if (s.alignmentX >= 0) {
              object.alignmentX = s.alignmentX;
              break;
            }
          }
        }
        if (this.alignmentY >= 0) {
          object.alignmentY = 0;
          for (l1 = activeStyles.length - 1; l1 >= 0; l1 += -1) {
            s = activeStyles[l1];
            if (s.alignmentY >= 0) {
              object.alignmentY = s.alignmentY;
              break;
            }
          }
        }
        if (this.resizable != null) {
          object.resizable = false;
          for (m1 = activeStyles.length - 1; m1 >= 0; m1 += -1) {
            s = activeStyles[m1];
            if (s.resizable != null) {
              object.resizable = s.resizable;
              break;
            }
          }
        }
        this.revertAnimations(object);
        return this.revertLooping(object);
      }
    };


    /**
    * Reverts the animation-data changes applied to a UI object by this style.
    *
    * @method revertAnimations
    * @param {ui.Object_UIElement} object - The UI object where the animation-data changes should be reverted.
     */

    Style.prototype.revertAnimations = function(object) {
      var activeStyles, j, results, s;
      activeStyles = object.activeStyles;
      if (this.animations) {
        object.animations = null;
        results = [];
        for (j = activeStyles.length - 1; j >= 0; j += -1) {
          s = activeStyles[j];
          if (s.animations) {
            object.animations = Object.deepCopy(s.animations);
            if (!object.findComponentById("animationHandler")) {
              results.push(object.addComponent(new ui.Component_AnimationHandler(), "animationHandler"));
            } else {
              results.push(void 0);
            }
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };


    /**
    * Reverts the looping-data changes applied to a UI object by this style.
    *
    * @method revertLooping
    * @param {ui.Object_UIElement} object - The UI object where the looping-data changes should be reverted.
     */

    Style.prototype.revertLooping = function(object) {
      var activeStyles, j, results, s;
      activeStyles = object.activeStyles;
      if (this.looping) {
        object.visual.looping.vertical = false;
        object.visual.looping.horizontal = false;
        results = [];
        for (j = activeStyles.length - 1; j >= 0; j += -1) {
          s = activeStyles[j];
          if (s.looping) {
            if (!object.visual.looping) {
              object.visual.dispose();
              object.removeComponent(object.visual);
              object.visual = new gs.Component_TilingSprite();
              object.addComponent(object.visual);
            }
            object.visual.looping.vertical = s.looping.vertical;
            results.push(object.visual.looping.horizontal = s.looping.horizontal);
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };

    return Style;

  })();

  ui.Style = Style;

  UIManager = (function() {

    /**
    * Handles the creation of In Game UI elements. For more information about
    * In-Game UI see help file.
    *
    * @module ui
    * @class UIManager
    * @memberof ui
    * @constructor
     */
    function UIManager() {

      /**
      * Stores all registered UI layouts by name/id.
      * @property layouts
      * @type Object
       */
      this.layouts = {};

      /**
      * Stores all registered UI styles by name/id.
      * @property styles
      * @type Object
       */
      this.styles = {};

      /**
      * Stores all UI styles by number id.
      * @property stylesById
      * @type ui.Style[]
       */
      this.stylesById = new Array();

      /**
      * Stores all UI styles by style-name.
      * @property stylesByName
      * @type Object
       */
      this.stylesByName = {};

      /**
      * Stores all registered custom UI types/templates by name/id.
      * @property customTypes
      * @type Object
       */
      this.customTypes = {};

      /**
      * Stores all registered UI controllers by name/id.
      * @property customTypes
      * @type Object
       */
      this.controllers = {};

      /**
      * Stores all registered UI data sources by name/id.
      * @property customTypes
      * @type Object
       */
      this.dataSources = {};

      /**
      * Mapping to table to map alignment names to number values.
      * @property alignments
      * @type Object
      * @protected
       */
      this.alignments = {
        "left": 0,
        "top": 0,
        "center": 1,
        "bottom": 2,
        "right": 2,
        "0": 0,
        "1": 1,
        "2": 2
      };

      /**
      * Mapping to table to map blend-mode names to number values.
      * @property blendModes
      * @type Object
      * @protected
       */
      this.blendModes = {
        "normal": 0,
        "add": 1,
        "sub": 2
      };

      /**
      * Mapping to table to map selector names to number values.
      * @property selectors
      * @type Object
       */
      this.selectors = {
        normal: 0,
        hover: 1,
        selected: 2,
        enabled: 3,
        focused: 4
      };
      this.defaultPlaceholderParams = {};
    }


    /**
    * Sets up UI Manager, optimizes styles, etc.
    *
    * @method setup
     */

    UIManager.prototype.setup = function() {
      return this.setupStyles();
    };


    /**
    * Sets up the UI styles by wrapping them into ui.Style objects and optimizing the access.
    *
    * @method setupStyles
    * @protected
     */

    UIManager.prototype.setupStyles = function() {
      var id, k, ref, selector, selectorMap, subs;
      id = 0;
      selectorMap = this.selectors;
      for (k in this.styles) {
        subs = k.split(" ");
        selector = subs[0].split(":");
        if (selectorMap[selector[1]]) {
          this.stylesById[id] = new ui.Style(this.styles[k], id, selectorMap[selector[1]]);
        } else {
          this.stylesById[id] = new ui.Style(this.styles[k], id, 0);
        }
        if (!this.stylesByName[selector[0]]) {
          this.stylesByName[selector[0]] = [];
        }
        this.stylesByName[selector[0]].push(this.stylesById[id]);
        this.styles[k] = this.stylesById[id];
        id++;
      }
      for (k in this.styles) {
        subs = k.split(" ");
        if (subs.length > 1) {
          this.stylesByName[subs[1]].push(this.styles[k]);
          this.styles[k].target = (ref = this.styles[k.split(":")[0]]) != null ? ref.id : void 0;
        }
      }
      return null;
    };


    /**
    * Executes all placeholder formulas in the specified descriptor. The descriptor will be changed
    * and placeholder formulas are replaced with their evaluated result value.
    *
    * @method executePlaceholderFormulas
    * @param {Object} descriptor - The descriptor.
    * @param {Object} params - Object containing the placeholder params.
    * @protected
     */

    UIManager.prototype.executePlaceholderFormulas = function(descriptor, id, params) {
      var c, i, j, k, keys, l, len, len1, v;
      if (descriptor == null) {
        return;
      }
      keys = Object.keys(descriptor);
      for (j = 0, len = keys.length; j < len; j++) {
        k = keys[j];
        v = descriptor[k];
        if (v != null) {
          if (v instanceof Array) {
            for (c = l = 0, len1 = v.length; l < len1; c = ++l) {
              i = v[c];
              if (i != null) {
                if (typeof i === "object") {
                  this.executePlaceholderFormulas(i, id, params);
                } else if (c !== "exec" && typeof i === "function") {
                  window.p = params || this.defaultPlaceholderParams;
                  window.d = descriptor;
                  v[c] = i();
                }
              }
            }
          } else if (typeof v === "object") {
            this.executePlaceholderFormulas(v, id, params);
          } else if (k !== "exec_" && typeof v === "function") {
            window.p = params || this.defaultPlaceholderParams;
            window.d = descriptor;
            descriptor[k] = v();
          }
        }
      }
      return null;
    };


    /**
    * Creates a calculation for a specified expression.
    *
    * @method createCalcFunction
    * @param {String} expression - The expression to create a calculation function for.
    * @return {Function} The calculation function.
    * @protected
     */

    UIManager.prototype.createCalcFunction = function(expression) {
      expression = expression.replace(/([0-9]+)%/gm, "($1 / 100 * v)");
      return eval("(function(v){ return " + expression + "})");
    };


    /**
    * Creates an object from the specified object type. The type has the format
    * <namespace>.<typename> like vn.Component_Hotspot.
    *
    * @method createObject
    * @param {String} type - The type name.
    * @return {Object} The created object.
    * @protected
     */

    UIManager.prototype.createObject = function(type) {
      var subs;
      subs = type.split(".");
      return new window[subs[0]][subs[1]]();
    };


    /**
    * Creates an UI object from a specified UI descriptor.
    *
    * @method createFromDescriptor
    * @param {Object} descriptor - The UI object descriptor.
    * @param {gs.Object_UIElement} parent - The UI parent object. (A layout for example).
    * @return {gs.Object_UIElement} The created UI object.
     */

    UIManager.prototype.createFromDescriptor = function(descriptor, parent) {
      var control, k;
      control = null;
      for (k in this.controllers) {
        if (this.controllers[k].type != null) {
          this.controllers[k] = this.createObject(this.controllers[k].type);
        }
      }
      return this._createFromDescriptor(descriptor, parent);
    };


    /**
    * Creates an image button UI object.
    *
    * @method createImageButton
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createImageButton = function(descriptor) {
      var control;
      control = new ui.Object_Hotspot(descriptor.image, descriptor.imageHandling);
      control.behavior.sound = descriptor.sound;
      control.behavior.sounds = descriptor.sounds;
      control.image = descriptor.image;
      control.images = descriptor.images;
      if (descriptor.imageFolder != null) {
        control.imageFolder = descriptor.imageFolder;
      }
      if (descriptor.looping != null) {
        control.visual.dispose();
        control.removeComponent(control.visual);
        control.visual = new gs.Component_TilingSprite();
        control.addComponent(control.visual);
        control.visual.looping.vertical = descriptor.looping.vertical;
        control.visual.looping.horizontal = descriptor.looping.horizontal;
      }
      if (descriptor.color != null) {
        control.color = Color.fromArray(descriptor.color);
      }
      return control;
    };


    /**
    * Creates an image UI object.
    *
    * @method createImage
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createImage = function(descriptor) {
      var control;
      control = new ui.Object_Image(descriptor.image, descriptor.imageHandling);
      if (descriptor.imageFolder != null) {
        control.imageFolder = descriptor.imageFolder;
      }
      if (descriptor.looping != null) {
        control.visual.dispose();
        control.removeComponent(control.visual);
        control.visual = new gs.Component_TilingSprite();
        control.addComponent(control.visual);
        control.visual.looping.vertical = descriptor.looping.vertical;
        control.visual.looping.horizontal = descriptor.looping.horizontal;
      }
      if (descriptor.color != null) {
        control.color = Color.fromArray(descriptor.color);
      }
      return control;
    };


    /**
    * Creates an image map UI object.
    *
    * @method createImageMap
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createImageMap = function(descriptor) {
      var control;
      control = new ui.Object_ImageMap();
      control.hotspots = (descriptor.hotspots || []).select(function(h) {
        return {
          x: h.rect[0],
          y: h.rect[1],
          size: {
            width: h.rect[2],
            height: h.rect[3]
          },
          data: {
            action: 3,
            actions: h.actions
          }
        };
      });
      control.images = descriptor.images;
      control.insertComponent(new ui.Component_ActionHandler(), 1, "actionHandler");
      control.target = SceneManager.scene.behavior;
      control.visual.variableContext = new gs.InterpreterContext(SceneManager.scene.layoutName, SceneManager.scene);
      return control;
    };


    /**
    * Creates a video UI object.
    *
    * @method createVideo
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createVideo = function(descriptor) {
      var control, ref;
      control = new ui.Object_Video();
      control.video = descriptor.video;
      control.loop = (ref = descriptor.loop) != null ? ref : true;
      return control;
    };


    /**
    * Creates a panel UI object.
    *
    * @method createPanel
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createPanel = function(descriptor) {
      var control, ref;
      control = new ui.Object_Panel();
      control.modal = (ref = descriptor.modal) != null ? ref : false;
      if (descriptor.color != null) {
        control.color = Color.fromArray(descriptor.color);
      }
      return control;
    };


    /**
    * Creates a frame UI object.
    *
    * @method createFrame
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createFrame = function(descriptor) {
      var control;
      control = new ui.Object_Frame(descriptor.frameSkin);
      control.frameThickness = descriptor.frameThickness || 16;
      control.frameCornerSize = descriptor.frameCornerSize || 16;
      control.image = descriptor.image;
      control.images = descriptor.images;
      return control;
    };


    /**
    * Creates a three-part image UI object.
    *
    * @method createThreePartImage
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createThreePartImage = function(descriptor) {
      var control;
      control = new ui.Object_ThreePartImage(descriptor.frameSkin);
      control.firstPartSize = descriptor.firstPartSize || 16;
      control.middlePartSize = descriptor.middlePartSize || 1;
      control.lastPartSize = descriptor.lastPartSize || 16;
      control.image = descriptor.image;
      control.images = descriptor.images;
      return control;
    };


    /**
    * Creates a text UI object.
    *
    * @method createText
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createText = function(descriptor) {
      var control, ref;
      control = new ui.Object_Text();
      control.text = lcs(descriptor.text);
      control.sizeToFit = descriptor.sizeToFit;
      control.formatting = descriptor.formatting;
      control.wordWrap = (ref = descriptor.wordWrap) != null ? ref : false;
      control.behavior.format = descriptor.format;
      if (descriptor.textPadding) {
        control.behavior.padding = ui.Space.fromArray(descriptor.textPadding);
      }
      if (descriptor.resolvePlaceholders != null) {
        control.resolvePlaceholders = descriptor.resolvePlaceholders;
      }
      if (descriptor.color != null) {
        control.color = Color.fromArray(descriptor.color);
      }
      return control;
    };


    /**
    * Creates a free-layout UI object.
    *
    * @method createFreeLayout
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createFreeLayout = function(descriptor) {
      var control;
      if (descriptor.frame != null) {
        control = new ui.Object_FreeLayout(descriptor.frame[0] || 0, descriptor.frame[1] || 0, descriptor.frame[2] || 1, descriptor.frame[3] || 1);
      } else {
        control = new ui.Object_FreeLayout(0, 0, 1, 1);
      }
      control.sizeToFit = descriptor.sizeToFit;
      return control;
    };


    /**
    * Creates a stack-layout UI object.
    *
    * @method createStackLayout
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createStackLayout = function(descriptor) {
      var control;
      if (descriptor.frame != null) {
        control = new ui.Object_StackLayout(descriptor.frame[0] || 0, descriptor.frame[1] || 0, descriptor.frame[2] || 1, descriptor.frame[3] || 1, descriptor.orientation);
      } else {
        control = new ui.Object_StackLayout(0, 0, 1, 1, descriptor.orientation);
      }
      control.sizeToFit = descriptor.sizeToFit;
      return control;
    };


    /**
    * Creates a spread-layout UI object.
    *
    * @method createSpreadLayout
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createSpreadLayout = function(descriptor) {
      var control;
      if (descriptor.frame != null) {
        control = new ui.Object_SpreadLayout(descriptor.frame[0] || 0, descriptor.frame[1] || 0, descriptor.frame[2] || 1, descriptor.frame[3] || 1, descriptor.orientation);
      } else {
        control = new ui.Object_SpreadLayout(0, 0, 1, 1, descriptor.orientation);
      }
      return control;
    };


    /**
    * Creates a grid-layout UI object.
    *
    * @method createGridLayout
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createGridLayout = function(descriptor) {
      var control;
      if (descriptor.frame != null) {
        control = new ui.Object_GridLayout(descriptor.frame[0], descriptor.frame[1], descriptor.frame[2], descriptor.frame[3], descriptor.rows, descriptor.columns, descriptor.template);
      } else {
        control = new ui.Object_GridLayout(0, 0, 1, 1, descriptor.rows, descriptor.columns, descriptor.template);
      }
      control.cellSpacing = descriptor.cellSpacing || [0, 0, 0, 0];
      control.sizeToFit = descriptor.sizeToFit;
      return control;
    };


    /**
    * Creates a message UI object.
    *
    * @method createMessage
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createMessage = function(descriptor) {
      var control;
      control = new ui.Object_Message();
      return control;
    };


    /**
    * Creates a data-grid UI object.
    *
    * @method createDataGrid
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created image button UI object.
     */

    UIManager.prototype.createDataGrid = function(descriptor) {
      var control;
      control = new ui.Object_DataGrid(descriptor);
      return control;
    };


    /**
    * Creates an UI object depending on the object-type of the specified UI descriptor.
    *
    * @method createControl
    * @param {Object} descriptor - The UI object descriptor.
    * @return {gs.Object_UIElement} The created UI object.
    * @protected
     */

    UIManager.prototype.createControl = function(descriptor) {
      var control;
      control = null;
      switch (descriptor.type) {
        case "ui.ImageButton":
          control = this.createImageButton(descriptor);
          break;
        case "ui.Image":
          control = this.createImage(descriptor);
          break;
        case "ui.ImageMap":
          control = this.createImageMap(descriptor);
          break;
        case "ui.Video":
          control = this.createVideo(descriptor);
          break;
        case "ui.Panel":
          control = this.createPanel(descriptor);
          break;
        case "ui.Frame":
          control = this.createFrame(descriptor);
          break;
        case "ui.ThreePartImage":
          control = this.createThreePartImage(descriptor);
          break;
        case "ui.Text":
          control = this.createText(descriptor);
          break;
        case "ui.Message":
          control = this.createMessage(descriptor);
          break;
        case "ui.DataGrid":
          control = this.createDataGrid(descriptor);
          break;
        case "ui.FreeLayout":
          control = this.createFreeLayout(descriptor);
          break;
        case "ui.StackLayout":
          control = this.createStackLayout(descriptor);
          break;
        case "ui.SpreadLayout":
          control = this.createSpreadLayout(descriptor);
          break;
        case "ui.GridLayout":
          control = this.createGridLayout(descriptor);
      }
      return control;
    };

    UIManager.prototype.createLayoutRect = function(frame, control) {
      var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7;
      if (!control.layoutRect) {
        control.layoutRect = new ui.LayoutRect();
      }
      control.layoutRect.set(0, 0, 0, 0);
      if (frame != null) {
        if (((ref = frame[0]) != null ? ref.length : void 0) != null) {
          control.layoutRect.x = this.createCalcFunction(frame[0]);
          control.dstRect.x = 0;
        } else {
          control.dstRect.x = (ref1 = descriptor.frame[0]) != null ? ref1 : control.dstRect.x;
        }
        if (((ref2 = frame[1]) != null ? ref2.length : void 0) != null) {
          control.layoutRect.y = this.createCalcFunction(frame[1]);
          control.dstRect.y = 0;
        } else {
          control.dstRect.y = (ref3 = frame[1]) != null ? ref3 : control.dstRect.y;
        }
        if (((ref4 = frame[2]) != null ? ref4.length : void 0) != null) {
          control.layoutRect.width = this.createCalcFunction(frame[2]);
          control.dstRect.width = 1;
        } else {
          control.dstRect.width = (ref5 = frame[2]) != null ? ref5 : control.dstRect.width;
        }
        if (((ref6 = frame[3]) != null ? ref6.length : void 0) != null) {
          control.layoutRect.height = this.createCalcFunction(frame[3]);
          return control.dstRect.height = 1;
        } else {
          return control.dstRect.height = (ref7 = frame[3]) != null ? ref7 : control.dstRect.height;
        }
      }
    };


    /**
    * Adds the styles defined in an array of style-names to the specified control.
    *
    * @method addControlStyles
    * @param {Object} control - The control to add the styles to.
    * @param {string[]} styles - Array of style-names to add.
     */

    UIManager.prototype.addControlStyles = function(control, styles) {
      var j, len, results, style, styleName;
      results = [];
      for (j = 0, len = styles.length; j < len; j++) {
        styleName = styles[j];
        if (this.stylesByName[styleName] != null) {
          results.push((function() {
            var l, len1, ref, results1;
            ref = this.stylesByName[styleName];
            results1 = [];
            for (l = 0, len1 = ref.length; l < len1; l++) {
              style = ref[l];
              control.styles.push(style);
              if (style.target === -1 && style.selector === 0) {
                results1.push(style.apply(control));
              } else {
                results1.push(void 0);
              }
            }
            return results1;
          }).call(this));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Creates an UI object from a specified UI descriptor. This method is called
    * recursively for all child-descriptors.
    *
    * @method createControlFromDescriptor
    * @param {Object} descriptor - The UI object descriptor.
    * @param {gs.Object_UIElement} parent - The UI parent object. (A layout for example).
    * @param {number} index - The index.
    * @return {gs.Object_UIElement} The created UI object.
    * @protected
     */

    UIManager.prototype.createControlFromDescriptor = function(descriptor, parent, index) {
      var action, actions, bindings, c, child, childControl, component, control, controls, customFields, data, formulas, i, isNumber, item, j, l, len, len1, len2, len3, m, n, o, p, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17, ref18, ref19, ref2, ref20, ref21, ref22, ref23, ref24, ref25, ref26, ref27, ref3, ref4, ref5, ref6, ref7, ref8, ref9, style, target, type, typeName, valid;
      control = null;
      if (descriptor.style != null) {
        descriptor.styles = [descriptor.style];
        delete descriptor.style;
      }
      descriptor = Object.deepCopy(descriptor);
      this.executePlaceholderFormulas(descriptor, descriptor.id, descriptor.params);
      control = this.createControl(descriptor);
      if (control == null) {
        type = Object.deepCopy(this.customTypes[descriptor.type]);
        this.executePlaceholderFormulas(type, descriptor.id, descriptor.params);
        typeName = type.type;
        customFields = type.customFields;
        bindings = type.bindings;
        formulas = type.formulas;
        actions = type.actions;
        if (type.style != null) {
          type.styles = [type.style];
          type.style = null;
        }
        Object.mixin(type, descriptor);
        if (customFields != null) {
          Object.mixin(type.customFields, customFields);
        }
        if ((bindings != null) && bindings !== type.bindings) {
          type.bindings = type.bindings.concat(bindings);
        }
        if ((formulas != null) && formulas !== type.formulas) {
          type.formulas = type.formulas.concat(formulas);
        }
        if ((actions != null) && actions !== type.actions) {
          type.actions = actions.concat(type.actions);
        }
        type.type = typeName;
        return this.createControlFromDescriptor(type, parent);
      } else if (parent != null) {
        parent.addObject(control);
        control.index = index;
      } else {
        gs.ObjectManager.current.addObject(control);
      }
      control.ui = new ui.Component_UIBehavior();
      control.addComponent(control.ui);
      control.params = descriptor.params;
      if (descriptor.updateBehavior === "continuous") {
        control.updateBehavior = ui.UpdateBehavior.CONTINUOUS;
      }
      if (descriptor.inheritProperties) {
        control.inheritProperties = true;
      }
      if (descriptor.font != null) {
        control.font = new Font(descriptor.font.name, descriptor.font.size);
        control.font.bold = (ref = descriptor.font.bold) != null ? ref : control.font.bold;
        control.font.italic = (ref1 = descriptor.font.italic) != null ? ref1 : control.font.italic;
        control.font.smallCaps = (ref2 = descriptor.font.smallCaps) != null ? ref2 : control.font.smallCaps;
        control.font.underline = (ref3 = descriptor.font.underline) != null ? ref3 : control.font.underline;
        control.font.strikeThrough = (ref4 = descriptor.font.strikeThrough) != null ? ref4 : control.font.strikeThrough;
        if (descriptor.font.color != null) {
          control.font.color = Color.fromArray(descriptor.font.color);
        }
        if (descriptor.font.border != null) {
          control.font.border = (ref5 = descriptor.font.border) != null ? ref5 : false;
          control.font.borderSize = (ref6 = descriptor.font.borderSize) != null ? ref6 : 4;
          control.font.borderColor = new Color(0, 0, 0);
        }
        if (descriptor.font.outline != null) {
          control.font.border = (ref7 = descriptor.font.outline) != null ? ref7 : false;
          control.font.borderSize = (ref8 = descriptor.font.outline.size) != null ? ref8 : 4;
          if (descriptor.font.outline.color != null) {
            control.font.borderColor = Color.fromArray(descriptor.font.outline.color);
          } else {
            control.font.borderColor = new Color(0, 0, 0);
          }
        }
      }
      if (descriptor.components != null) {
        ref9 = descriptor.components;
        for (j = 0, len = ref9.length; j < len; j++) {
          c = ref9[j];
          m = c.module || "gs";
          component = new window[m][c.type](c.params);
          control.addComponent(component, c.id);
          control[c.id] = component;
        }
      }
      control.focusable = (ref10 = descriptor.focusable) != null ? ref10 : control.focusable;
      if (descriptor.nextKeyObject) {
        control.ui.nextKeyObjectId = descriptor.nextKeyObject;
      }
      if (descriptor.initialFocus) {
        control.ui.focus();
      }
      actions = Object.deepCopy(descriptor.action != null ? [descriptor.action] : descriptor.actions);
      if (actions != null) {
        for (l = 0, len1 = actions.length; l < len1; l++) {
          action = actions[l];
          if (action != null) {
            action.event = (ref11 = action.event) != null ? ref11 : "onAccept";
            if (action.target == null) {
              target = this.controllers != null ? this.controllers[descriptor.target] : controller;
              action.target = target || SceneManager.scene.behavior;
            }
          }
        }
        control.actions = actions;
        if (!control.findComponentById("actionHandler")) {
          control.insertComponent(new ui.Component_ActionHandler(), 1, "actionHandler");
        }
      }
      if (descriptor.id != null) {
        control.id = descriptor.id;
        gs.ObjectManager.current.setObjectById(control, control.id);
      }
      control.descriptor = descriptor;
      control.layoutRect = new Rect();
      control.layoutRect.set(0, 0, 0, 0);
      if (descriptor.frame != null) {
        if (((ref12 = descriptor.frame[0]) != null ? ref12.length : void 0) != null) {
          control.layoutRect.x = this.createCalcFunction(descriptor.frame[0]);
          control.dstRect.x = 0;
        } else {
          control.dstRect.x = (ref13 = descriptor.frame[0]) != null ? ref13 : control.dstRect.x;
        }
        if (((ref14 = descriptor.frame[1]) != null ? ref14.length : void 0) != null) {
          control.layoutRect.y = this.createCalcFunction(descriptor.frame[1]);
          control.dstRect.y = 0;
        } else {
          control.dstRect.y = (ref15 = descriptor.frame[1]) != null ? ref15 : control.dstRect.y;
        }
        if (((ref16 = descriptor.frame[2]) != null ? ref16.length : void 0) != null) {
          control.layoutRect.width = this.createCalcFunction(descriptor.frame[2]);
          control.dstRect.width = 1;
        } else {
          control.dstRect.width = (ref17 = descriptor.frame[2]) != null ? ref17 : control.dstRect.width;
        }
        if (((ref18 = descriptor.frame[3]) != null ? ref18.length : void 0) != null) {
          control.layoutRect.height = this.createCalcFunction(descriptor.frame[3]);
          control.dstRect.height = 1;
        } else {
          control.dstRect.height = (ref19 = descriptor.frame[3]) != null ? ref19 : control.dstRect.height;
        }
      }
      if (descriptor.sizeToParent != null) {
        control.sizeToParent = descriptor.sizeToParent;
      }
      if (descriptor.blendMode != null) {
        control.blendMode = this.blendModes[descriptor.blendMode];
      }
      if (descriptor.anchor != null) {
        control.anchor.set(descriptor.anchor[0], descriptor.anchor[1]);
      }
      control.opacity = (ref20 = descriptor.opacity) != null ? ref20 : 255;
      if (descriptor.minimumSize != null) {
        control.minimumSize = {
          width: descriptor.minimumSize[0],
          height: descriptor.minimumSize[1]
        };
      }
      if (descriptor.resizable != null) {
        control.resizable = descriptor.resizable;
      }
      if (descriptor.scrollable != null) {
        control.scrollable = descriptor.scrollable;
      }
      if (descriptor.fixedSize != null) {
        control.fixedSize = descriptor.fixedSize;
      }
      if (descriptor.draggable != null) {
        control.draggable = descriptor.draggable;
        control.draggable.step = 0;
        if (control.draggable.rect != null) {
          control.draggable.rect = Rect.fromArray(control.draggable.rect);
        }
        control.addComponent(new ui.Component_Draggable());
      }
      if (descriptor.bindings != null) {
        control.bindings = descriptor.bindings;
        control.insertComponent(new ui.Component_BindingHandler(), 0);
      }
      if (descriptor.formulas != null) {
        control.formulas = descriptor.formulas;
        control.insertComponent(new ui.Component_FormulaHandler(), 0);
      }
      control.dataField = descriptor.dataField;
      control.enabled = (ref21 = descriptor.enabled) != null ? ref21 : true;
      if (descriptor.selectable != null) {
        control.selectable = descriptor.selectable;
      }
      if (descriptor.group != null) {
        control.group = descriptor.group;
        gs.ObjectManager.current.addToGroup(control, control.group);
      }
      if (descriptor.customFields != null) {
        control.customFields = Object.deepCopy(descriptor.customFields);
      }
      if (descriptor.margin != null) {
        control.margin.left = descriptor.margin[0];
        control.margin.top = descriptor.margin[1];
        control.margin.right = descriptor.margin[2];
        control.margin.bottom = descriptor.margin[3];
      }
      if (descriptor.padding != null) {
        control.padding.left = descriptor.padding[0];
        control.padding.top = descriptor.padding[1];
        control.padding.right = descriptor.padding[2];
        control.padding.bottom = descriptor.padding[3];
      }
      if (descriptor.alignment != null) {
        control.alignment = this.alignments[descriptor.alignment];
      }
      control.alignmentY = this.alignments[descriptor.alignmentY || 0];
      control.alignmentX = this.alignments[descriptor.alignmentX || 0];
      control.zIndex = descriptor.zIndex || 0;
      control.order = descriptor.order || 0;
      control.chainOrder = ((ref22 = descriptor.chainOrder) != null ? ref22 : descriptor.zOrder) + ((parent != null ? parent.chainOrder : void 0) || 0);
      if (descriptor.zoom != null) {
        control.zoom = {
          x: descriptor.zoom[0] / 100,
          y: descriptor.zoom[1] / 100
        };
      }
      if (descriptor.visible != null) {
        control.visible = descriptor.visible;
      }
      if (descriptor.clipRect) {
        control.clipRect = new Rect(control.dstRect.x, control.dstRect.y, control.dstRect.width, control.dstRect.height);
      }
      if (descriptor.styles != null) {
        this.addControlStyles(control, descriptor.styles);
      }
      if (descriptor.template != null) {
        control.behavior.managementMode = ui.LayoutManagementMode.fromString(descriptor.managementMode);
        data = ui.Component_FormulaHandler.fieldValue(control, control.dataField);
        isNumber = typeof data === "number";
        if (data != null) {
          for (i = n = 0, ref23 = (ref24 = data.length) != null ? ref24 : data; 0 <= ref23 ? n < ref23 : n > ref23; i = 0 <= ref23 ? ++n : --n) {
            if ((data[i] != null) || isNumber) {
              valid = true;
              if ((descriptor.dataFilter != null) && !isNumber) {
                valid = ui.Component_Handler.checkCondition(data[i], descriptor.dataFilter);
              }
              if (valid || isNumber) {
                child = this.createControlFromDescriptor(descriptor.template, control, i);
                if ((ref25 = data[i]) != null ? ref25.dstRect : void 0) {
                  child.dstRect = ui.UIElementRectangle.fromRect(child, data[i].dstRect);
                }
                if ((child.clipRect == null) && (control.clipRect != null)) {
                  child.clipRect = control.clipRect;
                }
                control.addObject(child);
                child.index = i;
                child.order = ((ref26 = data.length) != null ? ref26 : data) - i;
                control.controls.push(child);
              }
            }
          }
        }
      }
      if (descriptor.controls && descriptor.controls.exec) {
        controls = ui.Component_FormulaHandler.fieldValue(descriptor, descriptor.controls);
      } else {
        controls = descriptor.controls;
      }
      if (controls != null) {
        for (i = o = 0, len2 = controls.length; o < len2; i = ++o) {
          item = controls[i];
          childControl = this._createFromDescriptor(item, control, i);
          if ((childControl.clipRect == null) && (control.clipRect != null)) {
            childControl.clipRect = control.clipRect;
          }
          childControl.index = i;
          childControl.origin.x = control.origin.x + control.dstRect.x;
          childControl.origin.y = control.origin.y + control.dstRect.y;
          control.addObject(childControl);
          control.controls.push(childControl);
        }
      }
      if (control.styles && control.parentsByStyle) {
        parent = control.parent;
        while (parent) {
          if (parent.styles) {
            ref27 = parent.styles;
            for (p = 0, len3 = ref27.length; p < len3; p++) {
              style = ref27[p];
              if (!control.parentsByStyle[style.id]) {
                control.parentsByStyle[style.id] = [];
              }
              control.parentsByStyle[style.id].push(parent);
            }
          }
          parent = parent.parent;
        }
      }
      if (descriptor.animations != null) {
        control.animations = Object.deepCopy(descriptor.animations);
        control.animationExecutor = new ui.Component_AnimationExecutor();
        control.addComponent(control.animationExecutor);
        control.addComponent(new ui.Component_AnimationHandler());
      }
      control.ui.updateStyle();
      control.setup();
      return control;
    };


    /**
    * Creates an UI object from a specified UI descriptor.
    *
    * @method _createFromDescriptor
    * @param {Object} descriptor - The UI object descriptor.
    * @param {gs.Object_UIElement} parent - The UI parent object. (A layout for example).
    * @return {gs.Object_UIElement} The created UI object.
    * @protected
     */

    UIManager.prototype._createFromDescriptor = function(descriptor, parent, index) {
      var control, controller;
      control = this.createControlFromDescriptor(descriptor, parent, index);
      if (descriptor.controller != null) {
        controller = this.controllers[descriptor.controller];
        control.controller = controller;
        control.addComponent(controller);
      }
      return control;
    };

    UIManager.prototype.createLayoutFromDescriptor = function(descriptor, parent, index) {
      return this._createFromDescriptor(descriptor, parent, index);
    };

    return UIManager;

  })();

  Graphics.width = $PARAMS.resolution.width;

  Graphics.height = $PARAMS.resolution.height;

  ui.UiFactory = new UIManager();

  ui.UIManager = ui.UiFactory;

}).call(this);



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=Components_47.js
// Generated by CoffeeScript 1.12.7
(function() {
  var Component;

  Component = (function() {

    /**
    * The base class of all components. A component defines a certain piece of
    * game logic. 
    *
    * @module gs
    * @class Component
    * @memberof gs
    * @constructor
     */
    function Component() {

      /**
      * The associated game object. A component only be part of one game object at the same time.
      * @property object
      * @type gs.Object_Base
      * @default null
       */
      this.object = null;

      /**
      * Indicates if the component is disposed. A disposed component cannot be used anymore.
      * @property disposed
      * @type boolean
      * @default false
       */
      this.disposed = false;

      /**
      * An optional unique id. The component can be accessed through this ID using the gs.Object_Base.findComponentById method.
      * @property id
      * @type string
      * @default null
       */
      this.id = null;

      /**
      * An optional name. The component can be found through its name using the gs.Object_Base.findComponentsByName method. Multiple
      * components can have the same name. So the name can also be used to categorize components.
      * @property name
      * @type string
      * @default ""
       */
      this.name = "";

      /**
      * Indicates if the component is setup.
      * @property isSetup
      * @type boolean
      * @default no
       */
      this.isSetup = false;
    }


    /**
    * Called when the component is added to a new object.
    * @method setup
     */

    Component.prototype.setup = function() {
      return this.isSetup = true;
    };


    /**
    * Disposes the component. The component will be removed from the game object
    * automatically.
    * @method dispose
     */

    Component.prototype.dispose = function() {
      return this.disposed = true;
    };


    /**
    * Updates the component. Needs to be implemented in derived class.
    * @method update
     */

    Component.prototype.update = function() {};

    return Component;

  })();

  gs.Component = Component;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Container,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Container = (function(superClass) {
    extend(Component_Container, superClass);


    /**
    * A container component allows an object to have sub-objects.
    * @module gs
    * @class Component_Container
    * @memberof gs
    * @constructor
     */

    function Component_Container(disposeBehavior) {
      Component_Container.__super__.constructor.apply(this, arguments);

      /**
      * The behavior how the container deals with disposed game objects.
      * @property disposeBehavior
      * @default gs.ContainerDisposeBehavior.REMOVE
       */
      this.disposeBehavior = disposeBehavior != null ? disposeBehavior : gs.ContainerDisposeBehavior.REMOVE;
    }


    /**
    * Sorts the sub-objects by order-index.
    * @method sort_
    * @param {gs.Object_Base} a Object A
    * @param {gs.Object_Base} b Object B
     */

    Component_Container.prototype.sort_ = function(a, b) {
      if (a.order > b.order) {
        return -1;
      } else if (a.order < b.order) {
        return 1;
      } else {
        return 0;
      }
    };


    /**
    * Sets the visibility of all sub objects.
    * @method setVisible
    * @param {boolean} visible - The new visibility.
     */

    Component_Container.prototype.setVisible = function(visible) {
      var j, len, ref, results, subObject;
      ref = this.object.subObjects;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        subObject = ref[j];
        if (subObject) {
          subObject.visible = visible;
          results.push(subObject.update());
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Updates all sub-objects and sorts them if necessary. It also removes
    * disposed objects from the list of sub-objects.
    * @method update
     */

    Component_Container.prototype.update = function() {
      var i, results, subObject, subObjects;
      Component_Container.__super__.update.apply(this, arguments);
      subObjects = this.object.subObjects;
      if (this.object.needsSort) {
        subObjects.sort(this.sort_);
        this.object.needsSort = false;
      }
      i = 0;
      results = [];
      while (i < subObjects.length) {
        subObject = subObjects[i];
        if (subObject != null ? subObject.active : void 0) {
          if (subObject.disposed) {
            if (this.disposeBehavior === gs.ContainerDisposeBehavior.REMOVE) {
              subObjects.remove(subObject);
              i--;
            } else {
              subObjects[i] = null;
            }
          } else {
            subObject.update();
          }
        }
        results.push(i++);
      }
      return results;
    };

    return Component_Container;

  })(gs.Component);

  gs.Component_Container = Component_Container;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_DomainContainer,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_DomainContainer = (function(superClass) {
    extend(Component_DomainContainer, superClass);


    /**
    * A container component allows an object to have sub-objects.
    * @module gs
    * @class Component_DomainContainer
    * @memberof gs
    * @constructor
     */

    function Component_DomainContainer(disposeBehavior) {
      Component_DomainContainer.__super__.constructor.call(this, disposeBehavior);

      /**
      * The current domain. The default domain is an empty string. Please use
      * <b>changeDomain</b> to change the current domain.
      * @property domain
      * @readOnly
       */
      this.domain = "com.degica.vnm.default";
      this.domains = ["com.degica.vnm.default"];
    }


    /**
    * Changes the component and all sub-objects.
    * @method changeDomain
    * @param {string} domain - The domain to change to.
     */

    Component_DomainContainer.prototype.dispose = function() {
      var domain, j, len, ref;
      Component_DomainContainer.__super__.dispose.apply(this, arguments);
      ref = this.domains;
      for (j = 0, len = ref.length; j < len; j++) {
        domain = ref[j];
        if (domain !== this.domain) {
          this.object.subObjects = this.object.subObjectsByDomain[domain];
          this.object.disposeObjects();
        }
      }
      return this.object.subObjects = this.object.subObjectsByDomain[this.domain];
    };


    /**
    * Changes the current domain.
    * @method changeDomain
    * @param {string} domain - The domain to change to.
     */

    Component_DomainContainer.prototype.changeDomain = function(domain) {
      var objects;
      this.domain = domain;
      objects = this.object.subObjectsByDomain[domain];
      if (!objects) {
        objects = this.object.subObjectsByDomain[domain] = [];
        this.domains = Object.keys(this.object.subObjectsByDomain);
      }
      return this.object.subObjects = objects;
    };


    /**
    * Sets the visibility of all sub objects of all domains.
    * @method setVisible
    * @param {boolean} visible - The new visibility.
     */

    Component_DomainContainer.prototype.setVisible = function(visible) {
      var domain, j, len, ref, results, subObject, subObjects;
      ref = this.domains;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        domain = ref[j];
        subObjects = this.object.subObjectsByDomain[domain];
        if (subObjects) {
          results.push((function() {
            var k, len1, results1;
            results1 = [];
            for (k = 0, len1 = subObjects.length; k < len1; k++) {
              subObject = subObjects[k];
              if (subObject) {
                subObject.visible = visible;
                results1.push(subObject.update());
              } else {
                results1.push(void 0);
              }
            }
            return results1;
          })());
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Updates all sub-objects and sorts them if necessary. It also removes
    * disposed objects from the list of sub-objects.
    * @method update
     */

    Component_DomainContainer.prototype.update = function() {
      var domain, i, j, len, ref, subObject, subObjects;
      ref = this.domains;
      for (j = 0, len = ref.length; j < len; j++) {
        domain = ref[j];
        subObjects = this.object.subObjectsByDomain[domain];
        i = 0;
        while (i < subObjects.length) {
          subObject = subObjects[i];
          if (subObject != null ? subObject.active : void 0) {
            if (subObject.disposed) {
              subObjects[i] = null;
            } else {
              subObject.update();
            }
          }
          i++;
        }
      }
      return null;
    };

    return Component_DomainContainer;

  })(gs.Component_Container);

  gs.Component_DomainContainer = Component_DomainContainer;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Visual,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Visual = (function(superClass) {
    extend(Component_Visual, superClass);


    /**
    * The base class for all components displaying an object on screen.
    * @module gs
    * @class Component_Visual
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_Visual() {
      Component_Visual.__super__.constructor.apply(this, arguments);
    }


    /**
    * Updates the origin-point of the game object.
    * @method updateOrigin
     */

    Component_Visual.prototype.updateOrigin = function() {
      var ox, oy, p;
      ox = 0;
      oy = 0;
      if (this.object.parent != null) {
        p = this.object.parent;
        while ((p != null) && (p.dstRect != null)) {
          ox += p.dstRect.x + p.offset.x;
          oy += p.dstRect.y + p.offset.y;
          p = p.parent;
        }
      }
      ox += this.object.offset.x;
      oy += this.object.offset.y;
      this.object.origin.x = ox;
      return this.object.origin.y = oy;
    };


    /**
    * Updates the origin and the destination-rectangle from a layout-rectangle if present.
    * @method update
     */

    Component_Visual.prototype.update = function() {
      var ref;
      Component_Visual.__super__.update.apply(this, arguments);
      this.updateOrigin();
      if ((this.object.layoutRect != null) && (((ref = this.object.parent) != null ? ref.dstRect : void 0) != null)) {
        if (this.object.layoutRect.x) {
          this.object.dstRect.x = this.object.layoutRect.x(this.object.parent.dstRect.width);
        }
        if (this.object.layoutRect.y) {
          this.object.dstRect.y = this.object.layoutRect.y(this.object.parent.dstRect.height);
        }
        if (this.object.layoutRect.width) {
          this.object.dstRect.width = this.object.layoutRect.width(this.object.parent.dstRect.width);
        }
        if (this.object.layoutRect.height) {
          return this.object.dstRect.height = this.object.layoutRect.height(this.object.parent.dstRect.height);
        }
      }
    };

    return Component_Visual;

  })(gs.Component);

  gs.Component_Visual = Component_Visual;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var AnimationTypes, Component_Sprite,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Sprite = (function(superClass) {
    extend(Component_Sprite, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_Sprite.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * A sprite component to display an object on screen. It can be managed or
    * unmanaged. A managed sprite is automatically added to the graphics-system
    * and rendered every frame until it gets disposed. An unmanaged sprite needs
    * to be added and removed manually.
    *
    * @module gs
    * @class Component_Sprite
    * @extends gs.Component_Visual
    * @memberof gs
    * @constructor
    * @param {boolean} managed - Indicates if the sprite is managed by the graphics system.
     */

    function Component_Sprite(managed) {
      Component_Sprite.__super__.constructor.call(this);

      /**
      * The native sprite object to display the game object on screen.
      *
      * @property sprite
      * @type Sprite
      * @protected
       */
      this.sprite = null;

      /**
      * The name of the image to display.
      *
      * @property image
      * @type string
      * @protected
       */
      this.image = null;

      /**
      * The name of the video to display.
      *
      * @property video
      * @type string
      * @protected
       */
      this.video = null;

      /**
      * The name of the folder from where the image should be loaded.
      *
      * @property image
      * @type string
      * @protected
       */
      this.imageFolder = "Graphics/Pictures";

      /**
      * The visibility. If <b>false</b>, the sprite is not rendered.
      *
      * @property visible
      * @type boolean
      * @protected
       */
      this.visible = false;

      /**
      * Indicates if the image is loaded.
      *
      * @property imageLoaded
      * @type boolean
      * @protected
       */
      this.imageLoaded = false;
    }


    /**
    * Disposes the sprite. If the sprite is managed, it will be automatically
    * removed from the graphics system and viewport.
    * @method dispose
     */

    Component_Sprite.prototype.dispose = function() {
      var ref, ref1;
      Component_Sprite.__super__.dispose.apply(this, arguments);
      if (this.sprite) {
        this.sprite.dispose();
        if (this.sprite.video) {
          this.sprite.video.stop();
        }
        if (!this.sprite.managed) {
          if ((ref = this.sprite.viewport) != null) {
            ref.removeGraphicObject(this.sprite);
          }
          return (ref1 = Graphics.viewport) != null ? ref1.removeGraphicObject(this.sprite) : void 0;
        }
      }
    };


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_Sprite.prototype.setupEventHandlers = function() {
      return this.sprite.onIndexChange = (function(_this) {
        return function() {
          _this.object.rIndex = _this.sprite.index;
          return _this.object.needsUpdate = true;
        };
      })(this);
    };


    /**
    * Setup the sprite. 
    * @method setupSprite
     */

    Component_Sprite.prototype.setupSprite = function() {
      if (!this.sprite) {
        return this.sprite = new gs.Sprite(Graphics.viewport, typeof managed !== "undefined" && managed !== null ? managed : true);
      }
    };


    /**
    * Setup the sprite component. This method is automatically called by the
    * system.
    * @method setup
     */

    Component_Sprite.prototype.setup = function() {
      this.isSetup = true;
      this.setupSprite();
      this.setupEventHandlers();
      return this.update();
    };


    /**
    * Updates the source- and destination-rectangle of the game object so that
    * the associated bitmap fits in. The imageHandling property controls how
    * the rectangles are resized.
    * @method updateRect
     */

    Component_Sprite.prototype.updateRect = function() {
      if (this.sprite.bitmap != null) {
        if (!this.object.imageHandling) {
          this.object.srcRect = new Rect(0, 0, this.sprite.bitmap.width, this.sprite.bitmap.height);
          if (!this.object.fixedSize) {
            this.object.dstRect.width = this.object.srcRect.width;
            return this.object.dstRect.height = this.object.srcRect.height;
          }
        } else if (this.object.imageHandling === 1) {
          this.object.srcRect = new Rect(0, 0, this.sprite.bitmap.width, this.sprite.bitmap.height / 2);
          if (!this.object.fixedSize) {
            this.object.dstRect.width = this.object.srcRect.width;
            return this.object.dstRect.height = this.object.srcRect.height;
          }
        } else if (this.object.imageHandling === 2) {
          if (!this.object.fixedSize) {
            this.object.dstRect.width = this.object.srcRect.width;
            return this.object.dstRect.height = this.object.srcRect.height;
          }
        }
      }
    };


    /**
    * Updates the bitmap object from the associated image name. The imageFolder
    * property controls from which resource-folder the image will be loaded.
    * @method updateBitmap
     */

    Component_Sprite.prototype.updateBitmap = function() {
      this.imageLoaded = false;
      this.image = this.object.image;
      if (this.object.image.startsWith("data:") || this.object.image.startsWith("$")) {
        this.sprite.bitmap = ResourceManager.getBitmap(this.object.image);
      } else {
        this.sprite.bitmap = ResourceManager.getBitmap((this.object.imageFolder || this.imageFolder) + "/" + this.object.image);
      }
      if (this.sprite.bitmap != null) {
        if (!this.imageLoaded) {
          this.imageLoaded = this.sprite.bitmap.loaded;
        } else {
          delete this.sprite.bitmap.loaded_;
        }
      }
      return this.object.bitmap = this.sprite.bitmap;
    };


    /**
    * Updates the video object from the associated video name. It also updates
    * the video-rendering process.
    * @method updateVideo
     */

    Component_Sprite.prototype.updateVideo = function() {
      var ref, ref1;
      if (this.object.video !== this.videoName) {
        this.videoName = this.object.video;
        this.sprite.video = ResourceManager.getVideo("Movies/" + this.object.video);
        if (this.sprite.video != null) {
          if ((ref = $PARAMS.preview) != null ? ref.settings.musicDisabled : void 0) {
            this.sprite.video.volume = 0;
          }
          this.sprite.video.loop = this.object.loop;
          this.sprite.video.play();
          this.object.srcRect = new Rect(0, 0, this.sprite.video.width, this.sprite.video.height);
          if (!this.object.fixedSize) {
            this.object.dstRect = new Rect(this.object.dstRect.x, this.object.dstRect.y, this.sprite.video.width, this.sprite.video.height);
          }
        }
      }
      return (ref1 = this.sprite.video) != null ? ref1.update() : void 0;
    };


    /**
    * Updates the image if the game object has the image-property set.
    * @method updateImage
     */

    Component_Sprite.prototype.updateImage = function() {
      var ref;
      if (this.object.image != null) {
        if (this.object.image !== this.image || (!this.imageLoaded && ((ref = this.sprite.bitmap) != null ? ref.loaded : void 0))) {
          this.updateBitmap();
          return this.updateRect();
        }
      } else if (this.object.bitmap != null) {
        return this.sprite.bitmap = this.object.bitmap;
      } else if ((this.object.video != null) || this.videoName !== this.object.video) {
        return this.updateVideo();
      } else {
        this.image = null;
        this.object.bitmap = null;
        return this.sprite.bitmap = null;
      }
    };


    /**
    * If the sprite is unmanaged, this method will update the visibility of the
    * sprite. If the sprite leaves the viewport, it will be removed to save 
    * performance and automatically added back to the viewport if it enters
    * the viewport.
    * @method updateVisibility
     */

    Component_Sprite.prototype.updateVisibility = function() {
      var visible;
      if (!this.sprite.managed) {
        visible = Rect.intersect(this.object.dstRect.x + this.object.origin.x, this.object.dstRect.y + this.object.origin.y, this.object.dstRect.width, this.object.dstRect.height, 0, 0, Graphics.width, Graphics.height);
        if (visible && !this.visible) {
          (this.object.viewport || Graphics.viewport).addGraphicObject(this.sprite);
          this.visible = true;
        }
        if (!visible && this.visible) {
          (this.object.viewport || Graphics.viewport).removeGraphicObject(this.sprite);
          return this.visible = false;
        }
      }
    };


    /**
    * Updates the padding.
    * @method updatePadding
     */

    Component_Sprite.prototype.updatePadding = function() {
      if (this.object.padding != null) {
        this.sprite.x += this.object.padding.left;
        this.sprite.y += this.object.padding.top;
        this.sprite.zoomX -= (this.object.padding.left + this.object.padding.right) / this.object.srcRect.width;
        return this.sprite.zoomY -= (this.object.padding.bottom + this.object.padding.bottom) / this.object.srcRect.height;
      }
    };


    /**
    * Updates the sprite properties from the game object properties.
    * @method updateProperties
     */

    Component_Sprite.prototype.updateProperties = function() {
      var ref, ref1;
      this.sprite.width = this.object.dstRect.width;
      this.sprite.height = this.object.dstRect.height;
      this.sprite.x = this.object.dstRect.x;
      this.sprite.y = this.object.dstRect.y;
      this.sprite.mask = (ref = this.object.mask) != null ? ref : this.mask;
      this.sprite.angle = this.object.angle || 0;
      this.sprite.opacity = (ref1 = this.object.opacity) != null ? ref1 : 255;
      this.sprite.clipRect = this.object.clipRect;
      this.sprite.srcRect = this.object.srcRect;
      this.sprite.blendingMode = this.object.blendMode || 0;
      this.sprite.mirror = this.object.mirror;
      this.sprite.visible = this.object.visible && (!this.object.parent || (this.object.parent.visible == null) || this.object.parent.visible);
      this.sprite.ox = -this.object.origin.x;
      this.sprite.oy = -this.object.origin.y;
      return this.sprite.z = (this.object.zIndex || 0) + (!this.object.parent ? 0 : this.object.parent.zIndex || 0);
    };


    /**
    * Updates the optional sprite properties from the game object properties.
    * @method updateOptionalProperties
     */

    Component_Sprite.prototype.updateOptionalProperties = function() {
      if (this.object.tone != null) {
        this.sprite.tone = this.object.tone;
      }
      if (this.object.color != null) {
        this.sprite.color = this.object.color;
      }
      if (this.object.viewport != null) {
        this.sprite.viewport = this.object.viewport;
      }
      if (this.object.effects != null) {
        this.sprite.effects = this.object.effects;
      }
      if (this.object.anchor != null) {
        this.sprite.anchor.x = this.object.anchor.x;
        this.sprite.anchor.y = this.object.anchor.y;
      }
      if (this.object.positionAnchor != null) {
        this.sprite.positionAnchor = this.object.positionAnchor;
      }
      if (this.object.zoom != null) {
        this.sprite.zoomX = this.object.zoom.x;
        this.sprite.zoomY = this.object.zoom.y;
      }
      if (this.object.motionBlur != null) {
        return this.sprite.motionBlur = this.object.motionBlur;
      }
    };


    /**
    * Updates the sprite component by updating its visibility, image, padding and
    * properties.
    * @method update
     */

    Component_Sprite.prototype.update = function() {
      Component_Sprite.__super__.update.apply(this, arguments);
      if (!this.isSetup) {
        this.setup();
      }
      this.updateVisibility();
      this.updateImage();
      this.updateProperties();
      this.updateOptionalProperties();
      this.updatePadding();
      this.object.rIndex = this.sprite.index;
      return this.sprite.update();
    };

    return Component_Sprite;

  })(gs.Component_Visual);


  /**
  * Enumeration of appearance animations. 
  *
  * @module gs
  * @class AnimationTypes
  * @static
  * @memberof gs
   */

  AnimationTypes = (function() {
    function AnimationTypes() {}

    AnimationTypes.initialize = function() {

      /**
      * An object appears or disappears by moving into or out of the screen.
      * @property MOVEMENT
      * @type number
      * @static
      * @final
       */
      this.MOVEMENT = 0;

      /**
      * An object appears or disappears using alpha-blending.
      * @property BLENDING
      * @type number
      * @static
      * @final
       */
      this.BLENDING = 1;

      /**
      * An object appears or disappears using a mask-image.
      * @property MASKING
      * @type number
      * @static
      * @final
       */
      return this.MASKING = 2;
    };

    return AnimationTypes;

  })();

  AnimationTypes.initialize();

  gs.AnimationTypes = AnimationTypes;

  gs.Component_Sprite = Component_Sprite;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Quad,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Quad = (function(superClass) {
    extend(Component_Quad, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_Quad.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * A quad component displays rectangle on the screen using the color
    * of the game object.
    *
    * @module gs
    * @class Component_Quad
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_Quad() {
      Component_Quad.__super__.constructor.apply(this, arguments);

      /**
      * The native quad-object to display a colored rectangle on screen.
      * @property quad
      * @type gs.Quad
      * @protected
       */
      this.quad = null;
    }


    /**
    * Disposes the quad.
    * @method dispose
     */

    Component_Quad.prototype.dispose = function() {
      return this.quad.dispose();
    };


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_Quad.prototype.setupEventHandlers = function() {
      return this.quad.onIndexChange = (function(_this) {
        return function() {
          return _this.object.rIndex = _this.quad.index;
        };
      })(this);
    };


    /**
    * Sets up the quad.
    * @method setup
     */

    Component_Quad.prototype.setup = function() {
      this.isSetup = true;
      this.quad = new gs.Quad(Graphics.viewport);
      this.setupEventHandlers();
      return this.update();
    };


    /**
    * Updates the quad and its properties.
    * @method update
     */

    Component_Quad.prototype.update = function() {
      var ref;
      Component_Quad.__super__.update.apply(this, arguments);
      if (!this.isSetup) {
        this.setup();
      }
      this.object.rIndex = this.quad.index;
      this.quad.rect.set(this.object.dstRect.x, this.object.dstRect.y, this.object.dstRect.width, this.object.dstRect.height);
      this.quad.visible = this.object.visible;
      this.quad.ox = -this.object.origin.x;
      this.quad.oy = -this.object.origin.y;
      this.quad.z = (this.object.zIndex || 0) + (!this.object.parent ? 0 : this.object.parent.zIndex || 0);
      this.quad.color = this.object.color || Colors.TRANSPARENT;
      this.quad.opacity = (ref = this.object.opacity) != null ? ref : 255;
      return this.quad.clipRect = this.object.clipRect;
    };

    return Component_Quad;

  })(gs.Component_Visual);

  gs.Component_Quad = Component_Quad;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_TilingSprite,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_TilingSprite = (function(superClass) {
    extend(Component_TilingSprite, superClass);


    /**
    * A tiling sprite component tiles the image of the game object on screen. The
    * tiling can be vertical, horizontal or both. The sprite can be managed or
    * unmanaged. A managed sprite is automatically added to the graphics-system
    * and processed every frame until it gets disposed. An unmanaged sprite needs
    * to be added and removed manually.
    *
    * @module gs
    * @class Component_TilingSprite
    * @extends gs.Component_Sprite
    * @memberof gs
    * @constructor
    * @param {boolean} managed - Indicates if the sprite is managed by the graphics system.
     */

    function Component_TilingSprite(managed) {
      this.sprite = null;
      this.image = null;
      this.video = null;
      this.imageFolder = "Graphics/Pictures";
      this.visible = true;
      this.looping = {
        vertical: true,
        horizontal: true
      };
      this.scroll = {
        x: 0,
        y: 0
      };
    }


    /**
    * Creates sprite object.
    *
    * @method setupSprite
     */

    Component_TilingSprite.prototype.setupSprite = function() {
      if (!this.sprite) {
        return this.sprite = new gs.TilingSprite(Graphics.viewport, typeof managed !== "undefined" && managed !== null ? managed : true);
      }
    };


    /**
    * Updates the padding.
    *
    * @method updatePadding
     */

    Component_TilingSprite.prototype.updatePadding = function() {
      if (this.object.padding != null) {
        this.sprite.rect.x += this.object.padding.left;
        this.sprite.rect.y += this.object.padding.top;
        this.sprite.rect.width -= this.object.padding.left + this.object.padding.right;
        return this.sprite.rect.height -= this.object.padding.bottom + this.object.padding.bottom;
      }
    };


    /**
    * Updates the source- and destination-rectangle of the game object so that
    * the associated bitmap fits in. 
    *
    * @method updateRect
     */

    Component_TilingSprite.prototype.updateRect = function() {
      if (this.sprite.bitmap != null) {
        return this.object.srcRect = new Rect(0, 0, this.sprite.bitmap.width, this.sprite.bitmap.height);
      }
    };


    /**
    * Updates the sprite properties from the game object properties.
    *
    * @method updateProperties
     */

    Component_TilingSprite.prototype.updateProperties = function() {
      Component_TilingSprite.__super__.updateProperties.call(this);
      this.sprite.zoomX = this.object.zoom.x;
      this.sprite.zoomY = this.object.zoom.y;
      this.sprite.vertical = this.looping.vertical;
      this.sprite.horizontal = this.looping.horizontal;
      this.sprite.x = this.scroll.x;
      this.sprite.y = this.scroll.y;
      this.sprite.angle = this.object.angle;
      this.sprite.rect.x = this.object.dstRect.x;
      this.sprite.rect.y = this.object.dstRect.y;
      this.sprite.rect.width = this.object.dstRect.width;
      return this.sprite.rect.height = this.object.dstRect.height;
    };


    /**
    * Updates the optional sprite properties from the game object properties.
    * @method updateOptionalProperties
     */

    Component_TilingSprite.prototype.updateOptionalProperties = function() {
      Component_TilingSprite.__super__.updateOptionalProperties.apply(this, arguments);
      if (this.object.zoom != null) {
        this.sprite.zoomX = this.object.zoom.x;
        return this.sprite.zoomY = this.object.zoom.y;
      }
    };

    return Component_TilingSprite;

  })(gs.Component_Sprite);

  gs.Component_TilingSprite = Component_TilingSprite;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_TilingPlane,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_TilingPlane = (function(superClass) {
    extend(Component_TilingPlane, superClass);


    /**
    * A tiling plane component tiles the image of the game object endless over the screen. The
    * tiling can be vertical, horizontal or both. The sprite can be managed or
    * unmanaged. A managed sprite is automatically added to the graphics-system
    * and processed every frame until it gets disposed. An unmanaged sprite needs
    * to be added and removed manually.
    *
    * @module gs
    * @class Component_TilingPlane
    * @extends gs.Component_Sprite
    * @memberof gs
    * @constructor
    * @param {boolean} managed - Indicates if the sprite is managed by the graphics system.
     */

    function Component_TilingPlane(managed) {
      this.sprite = null;
      this.tilingPlane = null;
      this.tilingSprite = this.sprite;
      this.image = null;
      this.video = null;
      this.imageFolder = "Graphics/Pictures";
      this.visible = true;
      this.looping = {
        vertical: false,
        horizontal: false
      };
    }


    /**
    * Creates sprite object.
    *
    * @method setupSprite
     */

    Component_TilingPlane.prototype.setupSprite = function() {
      if (!this.sprite) {
        this.sprite = new gs.Sprite(Graphics.viewport, typeof managed !== "undefined" && managed !== null ? managed : true);
        return this.tilingSprite = this.sprite;
      }
    };


    /**
    * Updates the padding.
    *
    * @method updatePadding
     */

    Component_TilingPlane.prototype.updatePadding = function() {
      if (this.object.padding != null) {
        this.sprite.rect.x += this.object.padding.left;
        this.sprite.rect.y += this.object.padding.top;
        this.sprite.rect.width -= this.object.padding.left + this.object.padding.right;
        return this.sprite.rect.height -= this.object.padding.bottom + this.object.padding.bottom;
      }
    };


    /**
    * Updates the source- and destination-rectangle of the game object so that
    * the associated bitmap fits in. 
    *
    * @method updateRect
     */

    Component_TilingPlane.prototype.updateRect = function() {
      if (this.sprite.bitmap != null) {
        this.object.srcRect = new Rect(0, 0, this.sprite.bitmap.width, this.sprite.bitmap.height);
        this.object.dstRect.width = this.object.srcRect.width;
        return this.object.dstRect.height = this.object.srcRect.height;
      }
    };


    /**
    * Updates the sprite properties from the game object properties.
    *
    * @method updateProperties
     */

    Component_TilingPlane.prototype.updateProperties = function() {
      Component_TilingPlane.__super__.updateProperties.call(this);
      this.sprite.vertical = this.looping.vertical;
      this.sprite.horizontal = this.looping.horizontal;
      this.sprite.x = this.object.dstRect.x;
      return this.sprite.y = this.object.dstRect.y;
    };


    /**
    * Updates the optional sprite properties from the game object properties.
    * @method updateOptionalProperties
     */

    Component_TilingPlane.prototype.updateOptionalProperties = function() {
      Component_TilingPlane.__super__.updateOptionalProperties.call(this);
      this.sprite.zoomX = this.object.zoom.x;
      return this.sprite.zoomY = this.object.zoom.y;
    };


    /**
    * Updates the tiling-plane component by updating its visibility, image, padding and
    * properties. To save performance, a gs.TilingPlane is only used if looping is enabled. Otherwise
    * a regular sprite is used.
    * @method update
     */

    Component_TilingPlane.prototype.update = function() {
      if (this.tilingSprite && (this.looping.vertical || this.looping.horizontal)) {
        this.tilingSprite.dispose();
        this.tilingPlane = new gs.TilingPlane(null, this.tilingSprite.managed);
        this.tilingSprite = null;
        this.sprite = this.tilingPlane;
        this.image = null;
      }
      if (this.tilingPlane && !(this.looping.vertical || this.looping.horizontal)) {
        this.tilingPlane.dispose();
        this.tilingSprite = new gs.Sprite(null, this.tilingPlane.managed);
        this.tilingPlane = null;
        this.sprite = this.tilingSprite;
        this.image = null;
      }
      return Component_TilingPlane.__super__.update.apply(this, arguments);
    };

    return Component_TilingPlane;

  })(gs.Component_Sprite);

  gs.Component_TilingPlane = Component_TilingPlane;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Viewport,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Viewport = (function(superClass) {
    extend(Component_Viewport, superClass);


    /**
    * A viewport component can contain multiple graphic objects and will automatically 
    * clip them if they move out of the viewport-rectangle. The area of a viewport
    * can also be tinted or colored. So to tint the whole for example, it enough
    * to create a viewport taking the whole screen-space and then setting the
    * tone or color property.
    *
    * @module gs
    * @class Component_Viewport
    * @extends gs.Component_Visual
    * @memberof gs
    * @constructor
    * @param {Viewport} [viewport=null] - A native viewport object used by the component. If null, the component create a new one.
     */

    function Component_Viewport(viewport) {
      Component_Viewport.__super__.constructor.call(this);

      /**
      * The native viewport-object.
      * @property viewport
      * @type gs.Viewport
      * @protected
       */
      this.viewport = viewport;

      /**
      * The visibility. If <b>false</b> the viewport and associated graphic objects are not rendered.
      * @property viewport
      * @type gs.Viewport
      * @protected
       */
      this.visible = true;
      this.scroll = new gs.Point(0, 0);
    }


    /**
    * Sets up the viewport.
    * @method setup
     */

    Component_Viewport.prototype.setup = function() {
      if (!this.viewport) {
        this.viewport = new gs.Viewport(0, 0, Graphics.width, Graphics.height);
      }
      return this.isSetup = true;
    };


    /**
    * Disposes the viewport and all associated graphic objects.
    * @method dispose
     */

    Component_Viewport.prototype.dispose = function() {
      return this.viewport.dispose();
    };


    /**
    * Updates the origin-point of the game object.
    * @method updateOrigin
     */

    Component_Viewport.prototype.updateOrigin = function() {};


    /**
    * Updates the padding.
    * @method updatePadding
     */

    Component_Viewport.prototype.updatePadding = function() {
      if (this.object.padding != null) {
        this.viewport.rect.x += this.object.padding.left;
        this.viewport.rect.y += this.object.padding.top;
        this.viewport.rect.width -= this.object.padding.left + this.object.padding.right;
        return this.viewport.rect.height -= this.object.padding.bottom + this.object.padding.bottom;
      }
    };


    /**
    * Updates the sprite properties from the game object properties.
    * @method update
     */

    Component_Viewport.prototype.updateProperties = function() {
      this.viewport.rect.x = this.object.dstRect.x;
      this.viewport.rect.y = this.object.dstRect.y;
      this.viewport.rect.width = this.object.dstRect.width;
      this.viewport.rect.height = this.object.dstRect.height;
      this.viewport.ox = this.scroll.x + this.object.offset.x;
      this.viewport.oy = this.scroll.y + this.object.offset.y;
      this.viewport.anchor.x = this.object.anchor.x;
      this.viewport.anchor.y = this.object.anchor.y;
      this.viewport.zoomX = this.object.zoom.x;
      this.viewport.zoomY = this.object.zoom.y;
      this.viewport.angle = this.object.angle;
      return this.viewport.z = (this.object.zIndex || 0) + (!this.object.parent ? 0 : this.object.parent.zIndex || 0);
    };


    /**
    * Updates the optional sprite properties from the game object properties.
    * @method updateOptionalProperties
     */

    Component_Viewport.prototype.updateOptionalProperties = function() {
      var ref, ref1;
      if (this.object.tone != null) {
        this.viewport.tone = this.object.tone;
      }
      if (this.object.color != null) {
        this.viewport.color = this.object.color;
      }
      if (this.object.effects != null) {
        this.viewport.effects = this.object.effects;
      }
      if (((ref = this.object.parent) != null ? ref.visible_ : void 0) != null) {
        return this.viewport.visible = this.object.visible;
      } else if (((ref1 = this.object.parent) != null ? ref1.visible : void 0) != null) {
        return this.viewport.visible = this.object.visible;
      } else {
        return this.viewport.visible = this.object.visible;
      }
    };


    /**
    * Updates the viewport.
    * @method update
     */

    Component_Viewport.prototype.update = function() {
      Component_Viewport.__super__.update.apply(this, arguments);
      if (!this.isSetup) {
        this.setup();
      }
      this.viewport.update();
      this.updatePadding();
      this.updateProperties();
      return this.updateOptionalProperties();
    };

    return Component_Viewport;

  })(gs.Component_Visual);

  gs.Component_Viewport = Component_Viewport;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_ImageMap,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_ImageMap = (function(superClass) {
    extend(Component_ImageMap, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    *
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_ImageMap.prototype.onDataBundleRestore = function(data, context) {
      var bitmap, ground;
      this.setupEventHandlers();
      this.object.addObject(this.ground);
      bitmap = ResourceManager.getBitmap("Graphics/Pictures/" + this.object.images[0]);
      ground = new gs.Bitmap(bitmap.width, bitmap.height);
      ground.blt(0, 0, bitmap, new Rect(0, 0, bitmap.width, bitmap.height));
      this.ground.bitmap = ground;
      return this.setupHotspots(this.hotspots);
    };


    /**
    * A component which turns a game object into an interactive image-map.
    *
    * @module gs
    * @class Component_ImageMap
    * @extends gs.Component_Visual
    * @memberof gs
     */

    function Component_ImageMap() {
      Component_ImageMap.__super__.constructor.apply(this, arguments);

      /**
      * The ground/base image.
      * @property ground
      * @type gs.Object_Picture
      * @default null
       */
      this.ground = null;

      /**
      * An array of different hotspots.
      * @property hotspots
      * @type gs.Object_Picture[]
      * @default null
       */
      this.hotspots = null;

      /**
      * The variable context used if a hotspot needs to deal with local variables.
      * @property variableContext
      * @type Object
      * @default null
       */
      this.variableContext = null;

      /**
      * Indicates if the image-map is active. An in-active image-map doesn't respond
      * to any input-event. Hover effects are still working.
      * @property active
      * @type boolean
      * @default yes
       */
      this.active = true;
    }


    /**
    * Adds event-handler for mouse/touch events to update the component only if
    * a user-action happened.
    *
    * @method setupEventHandlers
     */

    Component_ImageMap.prototype.setupEventHandlers = function() {
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      return gs.GlobalEventManager.on("mouseUp", ((function(_this) {
        return function(e) {
          var contains, hotspot, j, len, ref, results;
          contains = Rect.contains(_this.object.dstRect.x, _this.object.dstRect.y, _this.object.dstRect.width, _this.object.dstRect.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y);
          if (contains && _this.active) {
            ref = _this.hotspots;
            results = [];
            for (j = 0, len = ref.length; j < len; j++) {
              hotspot = ref[j];
              if (_this.checkHotspotAction(hotspot)) {
                e.breakChain = true;
                if (hotspot.data.bindToSwitch) {
                  hotspot.selected = !hotspot.selected;
                }
                results.push(_this.executeHotspotAction(hotspot));
              } else {
                results.push(void 0);
              }
            }
            return results;
          }
        };
      })(this)), null, this.object);
    };


    /**
    * Initializes the image-map. Creates the background and hotspots.
    *
    * @method setup
     */

    Component_ImageMap.prototype.setup = function() {
      var bitmap, ground;
      this.setupEventHandlers();
      this.object.rIndex = 11000;
      if (this.object.images[0]) {
        bitmap = ResourceManager.getBitmap("Graphics/Pictures/" + this.object.images[0]);
        if (bitmap.loaded) {
          bitmap.makeMutable();
          ground = new gs.Bitmap(bitmap.width, bitmap.height);
          ground.blt(0, 0, bitmap, new Rect(0, 0, bitmap.width, bitmap.height));
        }
      }
      this.ground = new gs.Object_Picture();
      this.ground.bitmap = ground;
      this.ground.image = null;
      this.ground.zIndex = this.object.zIndex;
      this.ground.imageHandling = gs.ImageHandling.CUSTOM_SIZE;
      this.object.addObject(this.ground);
      this.setupHotspots();
      if (ground != null) {
        this.ground.srcRect.set(0, 0, ground.width, ground.height);
        this.ground.dstRect.width = ground.width;
        this.ground.dstRect.height = ground.height;
      }
      this.ground.update();
      this.object.dstRect.width = this.ground.dstRect.width;
      return this.object.dstRect.height = this.ground.dstRect.height;
    };


    /**
    * Sets up the hotspots on the image-map. Each hotspot is a gs.Object_ImageMapHotspot
    * object.
    *
    * @method setupHotspots
     */

    Component_ImageMap.prototype.setupHotspots = function(hotspots) {
      return this.hotspots = this.object.hotspots.select((function(_this) {
        return function(v, i) {
          var picture, ref, ref1, ref2, ref3, ref4;
          if ((ref = _this.ground.bitmap) != null) {
            ref.clearRect(v.x, v.y, v.size.width, v.size.height);
          }
          picture = new gs.Object_ImageMapHotspot();
          picture.fixedSize = true;
          picture.srcRect = new Rect(v.x, v.y, v.size.width, v.size.height);
          picture.dstRect = new Rect(v.x, v.y, v.size.width, v.size.height);
          picture.imageHandling = gs.ImageHandling.CUSTOM_SIZE;
          picture.zIndex = _this.object.zIndex + 1;
          picture.selected = (ref1 = hotspots != null ? (ref2 = hotspots[i]) != null ? ref2.selected : void 0 : void 0) != null ? ref1 : false;
          picture.hovered = false;
          picture.enabled = (ref3 = hotspots != null ? (ref4 = hotspots[i]) != null ? ref4.enabled : void 0 : void 0) != null ? ref3 : true;
          picture.actions = v.data.actions;
          picture.data = v.data;
          picture.commonEventId = v.commonEventId;
          picture.anchor.set(0.5, 0.5);
          _this.object.addObject(picture);
          return picture;
        };
      })(this));
    };


    /**
    * Initializes the image-map. Frees ground image.
    *
    * @method dispose
     */

    Component_ImageMap.prototype.dispose = function() {
      var ref;
      Component_ImageMap.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      return (ref = this.ground.bitmap) != null ? ref.dispose() : void 0;
    };


    /**
    * Executes a hotspot's associated action. Depending on the configuration a hotspot
    * can trigger a common-event or turn on a switch for example.
    *
    * @method executeHotspotAction
    * @param {gs.Object_Picture} hotspot - The hotspot where the image should be updated.
    * @protected
     */

    Component_ImageMap.prototype.executeHotspotAction = function(hotspot) {
      var domain, ref, ref1, ref2, ref3;
      GameManager.variableStore.setupTempVariables(this.variableContext);
      if (hotspot.data.bindToSwitch) {
        domain = GameManager.variableStore.domain;
        GameManager.variableStore.setBooleanValueTo(hotspot.data["switch"], hotspot.selected);
      }
      if (hotspot.data.bindValueTo) {
        domain = GameManager.variableStore.domain;
        GameManager.variableStore.setNumberValueTo(hotspot.data.bindValueVariable, hotspot.data.bindValue);
      }
      AudioManager.playSound(hotspot.data.onClickSound);
      switch (hotspot.data.action) {
        case 1:
          if ((ref = this.object.events) != null) {
            ref.emit("jumpTo", this.object, {
              label: hotspot.data.label
            });
          }
          break;
        case 2:
          if ((ref1 = this.object.events) != null) {
            ref1.emit("callCommonEvent", this.object, {
              commonEventId: hotspot.data.commonEventId,
              finish: hotspot.data.finish
            });
          }
          break;
        case 3:
          if ((ref2 = this.object.events) != null) {
            ref2.emit("action", this.object, {
              actions: hotspot.data.actions
            });
          }
      }
      if (hotspot.data.finish) {
        return (ref3 = this.object.events) != null ? ref3.emit("finish", this.object) : void 0;
      }
    };


    /**
    * Checks if a hotspot's associated action needs to be executed. Depending on the configuration a hotspot
    * can trigger a common-event or turn on a switch for example.
    *
    * @method updateHotspotAction
    * @param {gs.Object_Picture} hotspot - The hotspot where the image should be updated.
    * @return {boolean} If <b>true</b> the hotspot's action needs to be executed. Otherwise <b>false</b>.
    * @protected
     */

    Component_ImageMap.prototype.checkHotspotAction = function(hotspot) {
      var hovered, result;
      result = false;
      hovered = hotspot.dstRect.contains(Input.Mouse.x - hotspot.origin.x, Input.Mouse.y - hotspot.origin.y);
      if (hovered && hotspot.enabled && Input.Mouse.buttons[Input.Mouse.LEFT] === 2) {
        result = true;
      }
      return result;
    };


    /**
    * Updates a hotspot's image. Depending on the state the image of a hotspot can
    * change for example if the mouse hovers over a hotspot.
    *
    * @method updateHotspotImage
    * @param {gs.Object_Picture} hotspot - The hotspot where the image should be updated.
    * @param {boolean} hovered - Indicates if the hotspot is hovered by mouse/touch cursor.
    * @protected
     */

    Component_ImageMap.prototype.updateHotspotImage = function(hotspot, hovered) {
      var baseImage;
      baseImage = hotspot.enabled ? this.object.images[2] || this.object.images[0] : this.object.images[0];
      if (hovered && hotspot.enabled) {
        if (hotspot.selected) {
          return hotspot.image = this.object.images[4] || this.object.images[1] || baseImage;
        } else {
          return hotspot.image = this.object.images[1] || baseImage;
        }
      } else {
        if (hotspot.selected) {
          return hotspot.image = this.object.images[3] || baseImage;
        } else {
          return hotspot.image = baseImage;
        }
      }
    };


    /**
    * Updates a hotspot.
    *
    * @method updateHotspot
    * @param {gs.Object_Picture} hotspot - The hotspot to update.
    * @protected
     */

    Component_ImageMap.prototype.updateHotspot = function(hotspot) {
      var hovered;
      hotspot.visible = this.object.visible;
      hotspot.opacity = this.object.opacity;
      hotspot.tone.setFromObject(this.object.tone);
      hotspot.color.setFromObject(this.object.color);
      if (hotspot.data.bindEnabledState) {
        GameManager.variableStore.setupTempVariables(this.variableContext);
        hotspot.enabled = GameManager.variableStore.booleanValueOf(hotspot.data.enabledSwitch);
      }
      if (hotspot.data.bindToSwitch) {
        GameManager.variableStore.setupTempVariables(this.variableContext);
        hotspot.selected = GameManager.variableStore.booleanValueOf(hotspot.data["switch"]);
      }
      hovered = hotspot.dstRect.contains(Input.Mouse.x - hotspot.origin.x, Input.Mouse.y - hotspot.origin.y);
      if (hovered !== hotspot.hovered) {
        hotspot.hovered = hovered;
        if (hovered) {
          AudioManager.playSound(hotspot.data.onHoverSound);
        }
      }
      this.updateHotspotImage(hotspot, hovered);
      return hotspot.update();
    };


    /**
    * Updates the ground-image.
    *
    * @method updateGround
    * @protected
     */

    Component_ImageMap.prototype.updateGround = function() {
      this.ground.visible = this.object.visible;
      this.ground.opacity = this.object.opacity;
      this.ground.anchor.x = 0.5;
      this.ground.anchor.y = 0.5;
      this.ground.tone.setFromObject(this.object.tone);
      this.ground.color.setFromObject(this.object.color);
      return this.ground.update();
    };


    /**
    * Updates the image-map's ground and all hotspots.
    *
    * @method update
     */

    Component_ImageMap.prototype.update = function() {
      var hotspot, j, len, ref;
      Component_ImageMap.__super__.update.call(this);
      this.updateGround();
      ref = this.hotspots;
      for (j = 0, len = ref.length; j < len; j++) {
        hotspot = ref[j];
        this.updateHotspot(hotspot);
      }
      return null;
    };

    return Component_ImageMap;

  })(gs.Component_Visual);

  gs.Component_ImageMap = Component_ImageMap;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_TextRenderer, RendererTextLine, RendererToken,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  RendererTextLine = (function() {

    /**
    * Stores a text line.
    *
    * @module gs.RendererTextLine
    * @class RendererTextLine
    * @memberof gs.RendererTextLine
    * @constructor
     */
    function RendererTextLine() {

      /*
      * The width of the line in pixels.
      * @property width
      * @type number
      * @protected
       */
      this.width = 0;

      /*
      * The height of the line in pixels.
      * @property width
      * @type number
      * @protected
       */
      this.height = 0;

      /*
      * The descent of the line in pixels.
      * @property descent
      * @type number
      * @protected
       */
      this.descent = 0;

      /*
      * The content of the line as token objects.
      * @property content
      * @type Object[]
      * @protected
       */
      this.content = [];
    }

    return RendererTextLine;

  })();

  gs.RendererTextLine = RendererTextLine;

  RendererToken = (function() {

    /**
    * Stores a token.
    *
    * @module gs
    * @class RendererToken
    * @memberof gs
    * @constructor
     */
    function RendererToken(code, value, font) {

      /*
      * The value of the token. That value depends on the token type. For text-tokens, it stores
      * the actual text.
      * @property content
      * @type string
       */
      this.value = value;

      /*
      * The code describes what kind of token it is. For example, if the code is "Y" it means it is a
      * style-token. If the code is <b>null</b>, it means it is a text-token.
      * @property code
      * @type string
       */
      this.code = code;

      /*
      * The format stores the font-style properties of the token like if it is italic, bold, etc. It can be <b>null</b>.
      * @property format
      * @type Object
       */
      this.format = null;

      /*
      * A plain object to store custom data within the token.
      * @property customData
      * @type Object
       */
      this.customData = {};
      if (font != null) {
        this.takeFormat(font);
      }
    }


    /**
    * Takes the style from the specified font and stores it into the format-property. The token will
    * will be rendered with that style then.
    *
    * @method takeFormat
    * @param {gs.Font} font - The font to take the style from.
     */

    RendererToken.prototype.takeFormat = function(font) {
      return this.format = font.toDataBundle();
    };


    /**
    * Applies the format-style of the token on the specified font. The font will have the style from
    * then token then.
    *
    * @method applyFormat
    * @param {gs.Font} font - The font to apply the format-style on.
     */

    RendererToken.prototype.applyFormat = function(font) {
      return font.set(this.format);
    };

    return RendererToken;

  })();

  gs.RendererToken = RendererToken;

  Component_TextRenderer = (function(superClass) {
    extend(Component_TextRenderer, superClass);


    /**
    * A text-renderer component allow to draw plain or formatted text on a
    * game object's bitmap. For formatted text, different text-codes can be
    * used to add formatting or define a placeholder.<br><br>
    *
    * A text-code uses the following syntax:<br><br>
    *
    * {code:value} <- Single Value<br />
    * {code:value1,value2,...} <- Multiple Values<br><br>
    *
    * Example:<br><br>
    *
    * "This is {Y:I}a Text{Y:N}" <- "a Text" will be italic here.<br>
    * "The value is {GN:1}" <- "{GN:1}" will be replaced for the value of the global number variable 0001.<br><br>
    *
    * For a list of all available text-codes with examples, just take a look into the offical help-file.
    *
    * @module gs
    * @class Component_TextRenderer
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_TextRenderer() {
      Component_TextRenderer.__super__.constructor.apply(this, arguments);

      /**
      * @property currentX
      * @type number
      * @protected
       */
      this.currentX = 0;

      /**
      * @property currentY
      * @type number
      * @protected
       */
      this.currentY = 0;

      /**
      * @property currentLineHeight
      * @type number
      * @protected
       */
      this.currentLineHeight = 0;

      /**
      * @property font
      * @type gs.Font
      * @protected
       */
      this.font = new Font("Times New Roman", 22);

      /**
      * @property spaceSize
      * @type number
      * @protected
       */
      this.spaceSize = 0;

      /**
      * @property fontSize
      * @type number
      * @protected
       */
      this.fontSize = 0;

      /**
      * The left and right padding per line.
      * @property padding
      * @type number
       */
      this.padding = 0;

      /**
      * The spacing between text lines in pixels.
      * @property lineSpacing
      * @type number
       */
      this.lineSpacing = 0;
    }


    /**
    * Creates the token-object for a list-placeholder. A list-placeholder
    * allows to insert a value from a list-variable.
    *
    * @method createListToken
    * @param {Array} list - The list.
    * @param {Array} values - The values of the list-placeholder text-code.
    * @return {string} The token-object.
     */

    Component_TextRenderer.prototype.createListToken = function(list, values) {
      var index;
      index = 0;
      if (values[1] != null) {
        values = values[1].split(":");
        index = values[0];
        if (values[0] === "G") {
          index = GameManager.variableStore.numbers[parseInt(values[1]) - 1];
        } else if (values[0] === "P") {
          index = GameManager.variableStore.persistentNumbers[parseInt(values[1]) - 1];
        } else if (values[0] === "L") {
          index = GameManager.variableStore.numberValueOf({
            scope: 0,
            index: parseInt(values[1]) - 1
          });
        }
      }
      return "" + list[index];
    };


    /**
    * Parses and returns the variable identifier which is an array containing
    * the optional domain name and the variable index as: [domain, index].
    *
    * @method parseVariableIdentifier
    * @param {string} identifier - The variable identifier e.g. com.degica.vnm.default.1 or com.degica.vnm.default.VarName
    * @param {string} type - The variable type to parse: number, string, boolean or list
    * @param {string} type - The scope of the variable to parse: 0 = local, 1 = global, 2 = persistent.
    * @return {Array} An array containing two values as: [domain, index]. If the identifier doesn't contain a domain-string, the domain will be 0 (default).
     */

    Component_TextRenderer.prototype.parseVariableIdentifier = function(identifier, type, scope) {
      var index, result;
      result = [0, identifier];
      if (isNaN(identifier)) {
        index = identifier.lastIndexOf(".");
        if (index !== -1) {
          result[0] = identifier.substring(0, index);
          result[1] = identifier.substring(index + 1);
          if (isNaN(result[1])) {
            result[1] = GameManager.variableStore.indexOfVariable(result[1], type, scope, result[0]) + 1;
          } else {
            result[1] = parseInt(result[1]);
          }
        } else {
          result[1] = GameManager.variableStore.indexOfVariable(result[1], type, scope, result[0]) + 1;
        }
      } else {
        result[1] = parseInt(result[1]);
      }
      return result;
    };


    /**
    * Creates a token-object for a specified text-code.
    *
    * @method createToken
    * @param {string} code - The code/type of the text-code.
    * @param {string} value - The value of the text-code.
    * @return {Object} The token-object.
     */

    Component_TextRenderer.prototype.createToken = function(code, value) {
      var format, listIdentifier, macro, pair, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, tokenObject, values;
      tokenObject = null;
      value = isNaN(value) ? value : parseInt(value);
      switch (code) {
        case "SZ":
          tokenObject = new gs.RendererToken(code, value);
          this.font.size = tokenObject.value || this.fontSize;
          this.spaceSize = this.font.measureTextPlain(" ");
          break;
        case "Y":
          tokenObject = {
            code: code,
            value: value
          };
          switch (value) {
            case "U":
              this.font.underline = true;
              break;
            case "S":
              this.font.strikeThrough = true;
              break;
            case "I":
              this.font.italic = true;
              break;
            case "B":
              this.font.bold = true;
              break;
            case "C":
              this.font.smallCaps = true;
              break;
            case "NU":
              this.font.underline = false;
              break;
            case "NS":
              this.font.strikeThrough = false;
              break;
            case "NI":
              this.font.italic = false;
              break;
            case "NB":
              this.font.bold = false;
              break;
            case "NC":
              this.font.smallCaps = false;
              break;
            case "N":
              this.font.underline = false;
              this.font.strikeThrough = false;
              this.font.italic = false;
              this.font.bold = false;
              this.font.smallCaps = false;
          }
          this.spaceSize = this.font.measureTextPlain(" ");
          break;
        case "C":
          tokenObject = new gs.RendererToken(code, value);
          if (isNaN(value)) {
            this.font.color = gs.Color.fromHex(value);
          } else if (value <= 0) {
            this.font.color = Font.defaultColor;
          } else {
            this.font.color = gs.Color.fromObject(RecordManager.system.colors[value - 1] || Font.defaultColor);
          }
          break;
        case "GN":
          values = isNaN(value) ? value.split(",") : [value];
          if (values[1]) {
            format = values[1];
            values = this.parseVariableIdentifier(values[0], "number", 1);
            tokenObject = sprintf("%" + format + "d", GameManager.variableStore.numbersByDomain[values[0] || 0][values[1] - 1] || 0);
          } else {
            values = this.parseVariableIdentifier(values[0], "number", 1);
            tokenObject = (GameManager.variableStore.numbersByDomain[values[0] || 0][values[1] - 1] || 0).toString();
          }
          break;
        case "GT":
          values = this.parseVariableIdentifier(value, "string", 1);
          tokenObject = GameManager.variableStore.stringsByDomain[values[0] || 0][values[1] - 1] || "";
          tokenObject = tokenObject.split(/\{([A-z]+):([^\{\}]+)\}|(\n)/gm);
          if (tokenObject.length > 1) {
            tokenObject.pop();
          } else {
            tokenObject = (ref = tokenObject[0]) != null ? ref : "";
          }
          break;
        case "GS":
          values = this.parseVariableIdentifier(value, "boolean", 1);
          tokenObject = (GameManager.variableStore.booleansByDomain[values[0] || 0][values[1] - 1] || false).toString();
          break;
        case "GL":
          values = value.split(",");
          listIdentifier = this.parseVariableIdentifier(values[0], "list", 1);
          tokenObject = this.createListToken(GameManager.variableStore.listsByDomain[listIdentifier[0]][listIdentifier[1] - 1] || [], values);
          break;
        case "PN":
          values = isNaN(value) ? value.split(",") : [value];
          if (values[1]) {
            format = values[1];
            values = this.parseVariableIdentifier(values[0], "number", 2);
            tokenObject = sprintf("%" + format + "d", ((ref1 = GameManager.variableStore.persistentNumbers[values[0]]) != null ? ref1[values[1] - 1] : void 0) || 0);
          } else {
            values = this.parseVariableIdentifier(values[0], "number", 2);
            tokenObject = (((ref2 = GameManager.variableStore.persistentNumbersByDomain[values[0] || 0]) != null ? ref2[values[1] - 1] : void 0) || 0).toString();
          }
          break;
        case "PT":
          values = this.parseVariableIdentifier(value, "string", 2);
          tokenObject = ((ref3 = GameManager.variableStore.persistentStringsByDomain[values[0]]) != null ? ref3[values[1] - 1] : void 0) || "";
          tokenObject = tokenObject.split(/\{([A-z]+):([^\{\}]+)\}|(\n)/gm);
          if (tokenObject.length > 1) {
            tokenObject.pop();
          } else {
            tokenObject = (ref4 = tokenObject[0]) != null ? ref4 : "";
          }
          break;
        case "PS":
          values = this.parseVariableIdentifier(value, "boolean", 2);
          tokenObject = (((ref5 = GameManager.variableStore.persistentBooleansByDomain[values[0]]) != null ? ref5[values[1] - 1] : void 0) || false).toString();
          break;
        case "PL":
          values = value.split(",");
          listIdentifier = this.parseVariableIdentifier(values[0], "list", 2);
          tokenObject = this.createListToken(((ref6 = GameManager.variableStore.persistentListsByDomain[listIdentifier[0]]) != null ? ref6[listIdentifier[1] - 1] : void 0) || [], values);
          break;
        case "LN":
          values = isNaN(value) ? value.split(",") : [value];
          if (values[1]) {
            format = values[1];
            values = this.parseVariableIdentifier(values[0], "number", 0);
            tokenObject = sprintf("%" + format + "d", GameManager.variableStore.numberValueOf({
              scope: 0,
              index: values[1] - 1
            }) || 0);
          } else {
            values = this.parseVariableIdentifier(values[0], "number", 0);
            tokenObject = (GameManager.variableStore.numberValueOf({
              scope: 0,
              index: values[1] - 1
            }) || 0).toString();
          }
          break;
        case "LT":
          values = this.parseVariableIdentifier(value, "string", 0);
          tokenObject = (GameManager.variableStore.stringValueOf({
            scope: 0,
            index: values[1] - 1
          }) || "").toString();
          tokenObject = tokenObject.split(/\{([A-z]+):([^\{\}]+)\}|(\n)/gm);
          if (tokenObject.length > 1) {
            tokenObject.pop();
          } else {
            tokenObject = (ref7 = tokenObject[0]) != null ? ref7 : "";
          }
          break;
        case "LS":
          values = this.parseVariableIdentifier(value, "boolean", 0);
          tokenObject = (GameManager.variableStore.booleanValueOf({
            scope: 0,
            index: values[1] - 1
          }) || false).toString();
          break;
        case "LL":
          values = value.split(",");
          listIdentifier = this.parseVariableIdentifier(values[0], "list", 0);
          tokenObject = this.createListToken(GameManager.variableStore.listObjectOf({
            scope: 0,
            index: listIdentifier[1] - 1
          }) || [], values);
          break;
        case "N":
          tokenObject = (RecordManager.characters[value] != null ? lcs(RecordManager.characters[value].name) : "");
          break;
        case "RT":
          pair = value.split("/");
          tokenObject = {
            code: code,
            rtStyleId: (ref8 = pair[2]) != null ? ref8 : 0,
            rb: pair[0],
            rt: pair[1],
            rbSize: {
              width: 0,
              height: 0
            },
            rtSize: {
              width: 0,
              height: 0
            }
          };
          break;
        case "M":
          macro = RecordManager.system.textMacros.first(function(m) {
            return m.name === value;
          });
          if (macro) {
            if (macro.type === 0) {
              tokenObject = macro.content.split(/\{([A-z]+):([^\{\}]+)\}|(\n)/gm);
              tokenObject.pop();
            } else if (macro.type === 1) {
              if (!macro.contentFunc) {
                macro.contentFunc = eval("(function(object, value){ " + macro.content + " })");
              }
              tokenObject = macro.contentFunc(this.object, value);
              tokenObject = tokenObject.split(/\{([A-z]+):([^\{\}]+)\}|(\n)/gm);
              if (tokenObject.length > 1) {
                tokenObject.pop();
              }
            } else {
              if (!macro.contentFunc) {
                macro.contentFunc = eval("(function(object){ " + macro.content + " })");
              }
              tokenObject = new gs.RendererToken("X", macro.contentFunc);
            }
          } else {
            tokenObject = "";
          }
          break;
        default:
          tokenObject = new gs.RendererToken(code, value);
      }
      return tokenObject;
    };


    /**
    * <p>Gets the correct font for the specified ruby-text token.</p>
    *
    * @param {Object} token - A ruby-text token.
    * @return {gs.Font} The font for the ruby-text which is shown above the original text.
    * @method getRubyTextFont
     */

    Component_TextRenderer.prototype.getRubyTextFont = function(token) {
      var font, ref, style;
      style = null;
      font = null;
      if (token.rtStyleId) {
        style = ui.UIManager.styles["rubyText-" + token.rtStyleId];
      }
      if (!style) {
        style = ui.UIManager.styles["rubyText"];
      }
      font = (ref = style != null ? style.font : void 0) != null ? ref : this.font;
      font.size = font.size || this.font.size / 2;
      return font;
    };


    /**
    * <p>Measures a control-token. If a token produces a visual result like displaying an icon then it must return the size taken by
    * the visual result. If the token has no visual result, <b>null</b> must be returned. This method is called for every token when the message is initialized.</p>
    *
    * @param {Object} token - A control-token.
    * @return {gs.Size} The size of the area taken by the visual result of the token or <b>null</b> if the token has no visual result.
    * @method measureControlToken
    * @protected
     */

    Component_TextRenderer.prototype.measureControlToken = function(token) {
      var animation, font, fs, imageBitmap, size;
      size = null;
      switch (token.code) {
        case "A":
          animation = RecordManager.animations[Math.max(token.value - 1, 0)];
          if ((animation != null ? animation.graphic.name : void 0) != null) {
            imageBitmap = ResourceManager.getBitmap("Graphics/Pictures/" + animation.graphic.name);
            if (imageBitmap != null) {
              size = {
                width: Math.round(imageBitmap.width / animation.framesX),
                height: Math.round(imageBitmap.height / animation.framesY)
              };
            }
          }
          break;
        case "RT":
          font = this.getRubyTextFont(token);
          fs = font.size;
          font.size = font.size || this.font.size / 2;
          token.rbSize = this.font.measureTextPlain(token.rb);
          token.rtSize = font.measureTextPlain(token.rt);
          font.size = fs;
          size = {
            width: Math.max(token.rbSize.width, token.rtSize.width),
            height: token.rbSize.height + token.rtSize.height
          };
      }
      return size;
    };


    /**
    * <p>Draws the visual result of a token, like an icon for example, to the specified bitmap. This method is called for every token while the text is rendered.</p>
    *
    * @param {Object} token - A control-token.
    * @param {gs.Bitmap} bitmap - The bitmap used for the current text-line. Can be used to draw something on it like an icon, etc.
    * @param {number} offset - An x-offset for the draw-routine.
    * @method drawControlToken
    * @protected
     */

    Component_TextRenderer.prototype.drawControlToken = function(token, bitmap, offset) {
      var animation, font, fs, imageBitmap, rect, ref, ref1, style;
      switch (token.code) {
        case "A":
          animation = RecordManager.animations[Math.max(token.value - 1, 0)];
          if ((animation != null ? animation.graphic.name : void 0) != null) {
            imageBitmap = ResourceManager.getBitmap("Graphics/Pictures/" + animation.graphic.name);
            if (imageBitmap != null) {
              rect = new gs.Rect(0, 0, Math.round(imageBitmap.width / animation.framesX), Math.round(imageBitmap.height / animation.framesY));
              return bitmap.blt(offset, this.currentY, imageBitmap, rect);
            }
          }
          break;
        case "RT":
          style = null;
          if (token.rtStyleId) {
            style = ui.UIManager.styles["rubyText-" + token.rtStyleId];
          }
          if (!style) {
            style = ui.UIManager.styles["rubyText"];
          }
          font = (ref = style != null ? style.font : void 0) != null ? ref : this.object.font;
          fs = font.size;
          font.size = font.size || this.object.font.size / 2;
          if (style && !((ref1 = style.descriptor.font) != null ? ref1.color : void 0)) {
            font.color.set(this.object.font.color);
          }
          bitmap.font = font;
          bitmap.drawText(offset, bitmap.font.descent, Math.max(token.rbSize.width, token.rtSize.width), bitmap.height, token.rt, 1, 0);
          bitmap.font = this.object.font;
          font.size = fs;
          return bitmap.drawText(offset, token.rtSize.height, Math.max(token.rbSize.width, token.rtSize.width), bitmap.height, token.rb, 1, 0);
      }
    };


    /**
    * Splits up the specified token using a japanese word-wrap technique.
    *
    * @method wordWrapJapanese
    * @param {Object} token - The token to split up.
    * @param {gs.RendererTextLine} line - The current line.
    * @param {number} width - The width of the current line.
    * @param {number} height - The height of the current line.
    * @param {gs.RendererTextLine[]} - An array of lines. If the token is split up into multiple lines, all new
    * lines are added to this result array.
    * @return {gs.RendererTextLine} The current line, that may be the same as the <b>line</b> parameters but if new lines
    * are created it has to be the last new created line.
     */

    Component_TextRenderer.prototype.wordWrapJapanese = function(token, line, width, height, result) {
      var ch, depth, depthLevel, descent, endOfLine, i, j, lastCharacterIndex, moved, noSplit, size, startOfLine;
      startOfLine = '—…‥〳〴〵。.・、:;, ?!‼⁇⁈⁉‐゠–〜)]｝〕〉》」』】〙〗〟’"｠»ヽヾーァィゥェォッャュョヮヵヶぁぃぅぇぉっゃゅょゎゕゖㇰㇱㇲㇳㇴㇵㇶㇷㇸㇹㇺㇻㇼㇽㇾㇿ々〻';
      endOfLine = '([｛〔〈《「『【〘〖〝‘"｟«';
      noSplit = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789０１２３４５６７８９—…‥〳〴〵';
      descent = this.font.descent;
      size = this.font.measureTextPlain(token);
      depth = 8;
      depthLevel = 0;
      i = 0;
      j = 0;
      lastCharacterIndex = 0;
      if (size.width > this.object.dstRect.width - this.spaceSize.width * 3 - this.padding * 2) {
        while (i < token.length) {
          ch = token[i];
          size = this.font.measureTextPlain(ch);
          width += size.width;
          moved = false;
          if (width > this.object.dstRect.width - this.padding * 2) {
            depthLevel = 0;
            j = i;
            while (true) {
              moved = false;
              while (j > 0 && startOfLine.indexOf(token[j]) !== -1) {
                j--;
                moved = true;
              }
              while (j > 0 && endOfLine.indexOf(token[j - 1]) !== -1) {
                j--;
                moved = true;
              }
              while (j > 0 && noSplit.indexOf(token[j - 1]) !== -1) {
                j--;
                moved = true;
              }
              if (j === 0 && moved) {
                break;
              } else {
                i = j;
              }
              depthLevel++;
              if (depthLevel >= depth || !moved) {
                break;
              }
            }
            line.content.push(new gs.RendererToken(null, token.substring(lastCharacterIndex, i), this.font));
            lastCharacterIndex = i;
            line.height = Math.max(height, this.font.lineHeight);
            line.width = width - size.width;
            line.descent = descent;
            descent = this.font.descent;
            height = size.height;
            result.push(line);
            line = new gs.RendererTextLine();
            width = width - (width - size.width);
          }
          i++;
        }
      } else {
        line.content.push(new gs.RendererToken(null, token, this.font));
        line.height = Math.max(height, this.font.lineHeight);
        line.width = width + size.width;
        line.descent = descent;
      }
      height = Math.max(height, this.font.lineHeight);
      if (lastCharacterIndex !== i) {
        line.content.push(new gs.RendererToken(null, token.substring(lastCharacterIndex, i), this.font));
        line.width = width;
        line.height = Math.max(height, line.height);
        line.descent = descent;
      }
      return line;
    };


    /**
    * Does not word-wrapping at all. It just adds the text token to the line as is.
    *
    * @method wordWrapNone
    * @param {Object} token - The token to split up.
    * @param {gs.RendererTextLine} line - The current line.
    * @param {number} width - The width of the current line.
    * @param {number} height - The height of the current line.
    * @param {gs.RendererTextLine[]} - An array of lines. If the token is split up into multiple lines, all new
    * lines are added to this result array.
    * @return {gs.RendererTextLine} The current line, that may be the same as the <b>line</b> parameters but if new lines
    * are created it has to be the last new created line.
     */

    Component_TextRenderer.prototype.wordWrapNone = function(token, line, width, height, result) {
      var size;
      size = this.font.measureTextPlain(token);
      height = Math.max(size.height, height || this.font.lineHeight);
      if (token.length > 0) {
        width += size.width;
        line.width = width;
        line.height = Math.max(height, line.height);
        line.descent = this.font.descent;
        line.content.push(new gs.RendererToken(null, token));
      }
      return line;
    };


    /**
    * Splits up the specified token using a space-based word-wrap technique.
    *
    * @method wordWrapSpaceBased
    * @param {Object} token - The token to split up.
    * @param {gs.RendererTextLine} line - The current line.
    * @param {number} width - The width of the current line.
    * @param {number} height - The height of the current line.
    * @param {gs.RendererTextLine[]} - An array of lines. If the token is split up into multiple lines, all new
    * lines are added to this result array.
    * @return {gs.RendererTextLine} The current line, that may be the same as the <b>line</b> parameters but if new lines
    * are created it has to be the last new created line.
     */

    Component_TextRenderer.prototype.wordWrapSpaceBased = function(token, line, width, height, result) {
      var currentWords, descent, i, k, len, size, word, words;
      currentWords = [];
      words = token.split(" ");
      descent = this.font.descent;
      this.spaceSize = this.font.measureTextPlain(" ");
      for (i = k = 0, len = words.length; k < len; i = ++k) {
        word = words[i];
        size = this.font.measureTextPlain(word);
        width += size.width + this.spaceSize.width;
        if (width > this.object.dstRect.width - this.padding * 2) {
          token = new gs.RendererToken(null, currentWords.join(" "));
          token.takeFormat(this.font);
          line.content.push(token);
          line.height = Math.max(height, line.height);
          line.width = width - size.width;
          line.descent = Math.max(line.descent, descent);
          descent = Math.max(descent, this.font.descent);
          height = size.height;
          result.push(line);
          line = new gs.RendererTextLine();
          currentWords = [word];
          width = width - (width - size.width);
        } else {
          currentWords.push(word);
        }
        height = Math.max(height, this.font.lineHeight);
      }
      if (currentWords.length > 0) {
        token = new gs.RendererToken(null, currentWords.join(" "));
        token.takeFormat(this.font);
        line.content.push(token);
        line.width = width;
        line.height = Math.max(height, line.height);
        line.descent = Math.max(descent, line.descent);
      }
      return line;
    };


    /**
    * Splits up the specified token using a word-wrap technique. The kind of word-wrap technique
    * depends on the selected language. You can overwrite this method in derived classes to implement your
    * own custom word-wrap techniques.
    *
    * @method executeWordWrap
    * @param {Object} token - The token to split up.
    * @param {gs.RendererTextLine} line - The current line.
    * @param {number} width - The width of the current line.
    * @param {number} height - The height of the current line.
    * @param {gs.RendererTextLine[]} - An array of lines. If the token is split up into multiple lines, all new
    * lines are added to this result array.
    * @return {gs.RendererTextLine} The current line, that may be the same as the <b>line</b> parameters but if new lines
    * are created it has to be the last new created line.
     */

    Component_TextRenderer.prototype.executeWordWrap = function(token, line, width, height, result, wordWrap) {
      if (wordWrap) {
        switch (LanguageManager.language.wordWrap) {
          case "spaceBased":
            return this.wordWrapSpaceBased(token, line, width, height, result);
          case "japanese":
            return this.wordWrapJapanese(token, line, width, height, result);
        }
      } else {
        return this.wordWrapNone(token, line, width, height, result);
      }
    };


    /**
    * Creates an a of line-objects. Each line-object is a list of token-objects.
    * A token-object can be just a string or an object containing more information
    * about how to process the token at runtime.
    *
    * A line-object also contains additional information like the width and height
    * of the line(in pixels).
    *
    * If the wordWrap param is set, line-breaks are automatically created if a line
    * doesn't fit into the width of the game object's bitmap.
    *
    * @method calculateLines
    * @param {string} message - A message creating the line-objects for.
    * @param {boolean} wordWrap - If wordWrap is set to true, line-breaks are automatically created.
    * @param {number} [firstLineWidth=0] - The current width of the first line.
    * @return {Array} An array of line-objects.
     */

    Component_TextRenderer.prototype.calculateLines = function(message, wordWrap, firstLineWidth) {
      var bold, currentWords, descent, height, italic, line, result, size, smallCaps, strikeThrough, t, token, tokenObject, tokens, underline, width;
      result = [];
      line = new gs.RendererTextLine();
      width = firstLineWidth || 0;
      height = 0;
      descent = this.font.descent;
      currentWords = [];
      size = null;
      this.spaceSize = this.font.measureChar(" ");
      this.fontSize = this.font.size;
      tokens = message.split(/\{([A-z]+):([^\{\}]+)\}|(\n)/gm);
      token = null;
      t = 0;
      underline = this.font.underline;
      strikeThrough = this.font.strikeThrough;
      italic = this.font.italic;
      bold = this.font.bold;
      smallCaps = this.font.smallCaps;
      while (t < tokens.length) {
        token = tokens[t];
        if (t % 4 !== 0) {
          if (token != null) {
            tokenObject = this.createToken(token, tokens[t + 1]);
            if (tokenObject.push != null) {
              Array.prototype.splice.apply(tokens, [t + 3, 0].concat(tokenObject));
            } else if (tokenObject.code == null) {
              tokens[t + 3] = tokenObject + tokens[t + 3];
            } else {
              size = this.measureControlToken(tokenObject);
              if (size) {
                width += size.width;
                height = Math.max(height, size.height);
              }
              line.content.push(tokenObject);
            }
          } else {
            line.height = height || this.font.lineHeight;
            line.width = width;
            line.descent = descent;
            result.push(line);
            line = new gs.RendererTextLine();
            line.content.push(new gs.RendererToken(null, "\n", this.font));
            width = 0;
            height = 0;
            descent = this.font.descent;
          }
          t += 2;
        } else if (token.length > 0) {
          line = this.executeWordWrap(token, line, width, height, result, wordWrap);
          width = line.width;
          height = line.height;
          descent = line.descent;
        }
        t++;
      }
      if (line.content.length > 0 || result.length === 0) {
        line.height = height;
        line.width = width;
        line.descent = descent;
        result.push(line);
      }
      this.font.size = this.fontSize;
      this.font.underline = underline;
      this.font.strikeThrough = strikeThrough;
      this.font.italic = italic;
      this.font.bold = bold;
      this.font.smallCaps = smallCaps;
      return result;
    };


    /**
    * Measures the dimensions of formatted lines in pixels. The result is not
    * pixel-perfect.
    *
    * @method measureFormattedLines
    * @param {gs.RendererTextLine[]} lines - An array of text lines to measure.
    * @param {boolean} wordWrap - If wordWrap is set to true, automatically created line-breaks will be calculated.
    * @result {Object} An object containing the width and height of the text.
     */

    Component_TextRenderer.prototype.measureFormattedLines = function(lines, wordWrap) {
      var k, len, line, size;
      size = {
        width: 0,
        height: 0
      };
      for (k = 0, len = lines.length; k < len; k++) {
        line = lines[k];
        size.width = Math.max(line.width + 2, size.width);
        size.height += line.height + this.lineSpacing;
      }
      size.height -= this.lineSpacing;
      return size;
    };


    /**
    * Measures the dimensions of a formatted text in pixels. The result is not
    * pixel-perfect.
    *
    * @method measureFormattedText
    * @param {string} text - The text to measure.
    * @param {boolean} wordWrap - If wordWrap is set to true, automatically created line-breaks will be calculated.
    * @result {Object} An object containing the width and height of the text.
     */

    Component_TextRenderer.prototype.measureFormattedText = function(text, wordWrap) {
      var lines, size;
      this.font.set(this.object.font);
      size = null;
      lines = this.calculateLines(text, wordWrap);
      size = this.measureFormattedLines(lines, wordWrap);
      return size;
    };


    /**
    * Measures the dimensions of a plain text in pixels. Formatting and
    * word-wrapping are not supported.
    *
    * @method measureText
    * @param {string} text - The text to measure.
    * @result {Object} An object containing the width and height of the text.
     */

    Component_TextRenderer.prototype.measureText = function(text) {
      var k, len, line, lineSize, lines, size;
      size = {
        width: 0,
        height: 0
      };
      lines = text.toString().split("\n");
      for (k = 0, len = lines.length; k < len; k++) {
        line = lines[k];
        lineSize = this.object.font.measureText(text);
        size.width = Math.max(size.width, lineSize.width);
        size.height += this.object.font.lineHeight + this.lineSpacing;
      }
      size.height -= this.lineSpacing;
      return size;
    };


    /**
    * Searches for a token in a list of tokens and returns the first match.
    *
    * @method findToken
    * @param {number} startIndex - The index in the list of tokens where the search will start.
    * @param {string} code - The code of the token to search for.
    * @param {number} direction - The search direction, can be forward(1) or backward(-1).
    * @param {Object[]} tokens - The list of tokens to search.
    * @result {Object} The first token which matches the specified code or <b>null</b> if the token cannot be found.
     */

    Component_TextRenderer.prototype.findToken = function(startIndex, code, direction, tokens) {
      var i, t, token;
      token = null;
      i = startIndex;
      if (direction === -1) {
        while (i >= 0) {
          t = tokens[i];
          if (t.code === code) {
            token = t;
            break;
          }
          i--;
        }
      }
      return token;
    };


    /**
    * Searches for a specific kind of tokens between a start and an end token.
    *
    * @method findTokensBetween
    * @param {number} startIndex - The index where the search will start.
    * @param {number} endIndex - The index where the search will end.
    * @param {string} code - The code of the token-type to search for.
    * @param {Object[]} tokens - The list of tokens to search.
    * @result {Object[]} List of tokens matching the specified code. Its an empty list if no tokens were found.
     */

    Component_TextRenderer.prototype.findTokensBetween = function(startIndex, endIndex, code, tokens) {
      var e, result, s, token;
      result = [];
      s = startIndex;
      e = endIndex;
      while (s < e) {
        token = tokens[s];
        if (token.code == code) {
          result.push(token);
        }
        s++;
      }
      return result;
    };


    /**
    * Processes a control-token. A control-token is a token which influences
    * the text-rendering like changing the fonts color, size or style.
    *
    * Changes will be automatically applied to the game object's font.
    *
    * @method processControlToken
    * @param {Object} token - A control-token.
    * @return {Object} An object which can contain additional info needed for processing.
     */

    Component_TextRenderer.prototype.processControlToken = function(token) {
      var result;
      result = null;
      switch (token.code) {
        case "SZ":
          this.object.font.size = token.value || this.fontSize;
          break;
        case "C":
          if (isNaN(token.value)) {
            this.object.font.color = gs.Color.fromHex(token.value);
          } else if (token.value <= 0) {
            this.object.font.color = Font.defaultColor;
          } else {
            this.object.font.color = RecordManager.system.colors[token.value - 1] || Font.defaultColor;
          }
          break;
        case "Y":
          switch (token.value) {
            case "U":
              this.object.font.underline = true;
              break;
            case "S":
              this.object.font.strikeThrough = true;
              break;
            case "I":
              this.object.font.italic = true;
              break;
            case "B":
              this.object.font.bold = true;
              break;
            case "C":
              this.object.font.smallCaps = true;
              break;
            case "NU":
              this.object.font.underline = false;
              break;
            case "NS":
              this.object.font.strikeThrough = false;
              break;
            case "NI":
              this.object.font.underline = false;
              break;
            case "NB":
              this.object.font.bold = false;
              break;
            case "NC":
              this.object.font.smallCaps = false;
              break;
            case "N":
              this.object.font.underline = false;
              this.object.font.strikeThrough = false;
              this.object.font.italic = false;
              this.object.font.bold = false;
              this.object.font.smallCaps = false;
          }
      }
      return result;
    };


    /**
    * Draws a plain text. Formatting and word-wrapping are not supported.
    *
    * @method drawText
    * @param {number} x - The x-coordinate of the text's position.
    * @param {number} y - The y-coordinate of the text's position.
    * @param {number} width - Deprecated. Can be null.
    * @param {number} height - Deprecated. Can be null.
    * @param {string} text - The text to draw.
     */

    Component_TextRenderer.prototype.drawText = function(pl, pt, pr, pb, text) {
      var font, height, i, k, len, line, lines, size;
      lines = text.toString().split("\n");
      font = this.object.font;
      height = font.lineHeight;
      for (i = k = 0, len = lines.length; k < len; i = ++k) {
        line = lines[i];
        size = font.measureText(line);
        this.object.bitmap.drawText(pl, i * height + pt, size.width + pr + pl, height + pt + pb, line, 0, 0);
      }
      return null;
    };


    /**
    * Draws an array of formatted text lines.
    * If the wordWrap param is set, line-breaks are automatically created if a line
    * doesn't fit into the width of the game object's bitmap.
    *
    * @method drawFormattedLines
    * @param {number} pl - The left-padding of the text's position.
    * @param {number} pt - The top-padding of the text's position.
    * @param {number} pr - The right-padding of the text's position.
    * @param {number} pb - The bottom-padding of the text's position.
    * @param {gs.RendererTextLine[]} lines - An array of lines to draw.
    * @param {boolean} wordWrap - If wordWrap is set to true, line-breaks are automatically created.
     */

    Component_TextRenderer.prototype.drawFormattedLines = function(pl, pt, pr, pb, lines, wordWrap) {
      var font, height, k, l, len, len1, line, ref, size, token;
      this.currentX = pl;
      this.currentY = pt;
      this.currentLineHeight = 0;
      for (k = 0, len = lines.length; k < len; k++) {
        line = lines[k];
        ref = line.content;
        for (l = 0, len1 = ref.length; l < len1; l++) {
          token = ref[l];
          if (token.code != null) {
            this.processControlToken(token);
            size = this.measureControlToken(token);
            if (size) {
              this.drawControlToken(token, this.object.bitmap, this.currentX);
              this.currentX += size.width;
            }
          } else if (token.value.length > 0) {
            font = this.object.font;
            height = line.height;
            if (token.value !== "\n") {
              size = font.measureTextPlain(token.value);
              this.object.bitmap.drawText(this.currentX, this.currentY + height - size.height + font.descent - line.descent, size.width + pl + pr, height + pt + pb, token.value, 0, 0);
              this.currentX += size.width;
            }
            this.currentLineHeight = Math.max(this.currentLineHeight, height);
          }
        }
        this.currentY += (this.currentLineHeight || this.object.font.lineHeight) + this.lineSpacing;
        this.currentX = pl;
        this.currentLineHeight = 0;
      }
      return null;
    };


    /**
    * Draws a formatted text.
    * If the wordWrap param is set, line-breaks are automatically created if a line
    * doesn't fit into the width of the game object's bitmap.
    *
    * @method drawFormattedText
    * @param {number} x - The x-coordinate of the text's position.
    * @param {number} y - The y-coordinate of the text's position.
    * @param {number} width - Deprecated. Can be null.
    * @param {number} height - Deprecated. Can be null.
    * @param {string} text - The text to draw.
    * @param {boolean} wordWrap - If wordWrap is set to true, line-breaks are automatically created.
    * @return {gs.RendererTextLine[]} The drawn text lines.
     */

    Component_TextRenderer.prototype.drawFormattedText = function(pl, pt, pr, pb, text, wordWrap) {
      var lines;
      lines = this.calculateLines(text.toString(), wordWrap);
      this.drawFormattedLines(pl, pt, pr, pb, lines, wordWrap);
      return lines;
    };

    return Component_TextRenderer;

  })(gs.Component);

  gs.Component_TextRenderer = Component_TextRenderer;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_MessageTextRenderer,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_MessageTextRenderer = (function(superClass) {
    extend(Component_MessageTextRenderer, superClass);

    Component_MessageTextRenderer.objectCodecBlackList = ["onLinkClick", "onBatchDisappear"];


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    *
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_MessageTextRenderer.prototype.onDataBundleRestore = function(data, context) {
      var bitmap, customObject, j, l, lastLine, len, len1, len2, line, lineWidth, m, message, n, ref, ref1, ref2;
      this.setupEventHandlers();
      l = 0;
      lastLine = null;
      ref = this.object.messages;
      for (j = 0, len = ref.length; j < len; j++) {
        message = ref[j];
        if (this.object.settings.useCharacterColor) {
          this.object.font.color = new gs.Color(message.character.textColor);
        }
        lineWidth = this.isRunningInMultiPartMode() ? (lastLine != null ? lastLine.width : void 0) || 0 : 0;
        this.lines = this.calculateLines(lcsm(message.text), true, lineWidth);
        ref1 = this.lines;
        for (m = 0, len1 = ref1.length; m < len1; m++) {
          line = ref1[m];
          bitmap = this.createBitmap(line);
          if (line === this.line) {
            this.drawLineContent(line, bitmap, this.charIndex + 1);
          } else {
            this.drawLineContent(line, bitmap, -1);
          }
          this.allSprites[l].bitmap = bitmap;
          lastLine = line;
          l++;
        }
      }
      ref2 = this.customObjects;
      for (n = 0, len2 = ref2.length; n < len2; n++) {
        customObject = ref2[n];
        SceneManager.scene.addObject(customObject);
      }
      return null;
    };


    /**
    *  A text-renderer component to render an animated and interactive message text using
    *  dimensions of the game object's destination-rectangle. The message is displayed
    *  using a sprite for each line instead of drawing to the game object's bitmap object.
    *
    *  @module gs
    *  @class Component_MessageTextRenderer
    *  @extends gs.Component_TextRenderer
    *  @memberof gs
    *  @constructor
     */

    function Component_MessageTextRenderer() {
      Component_MessageTextRenderer.__super__.constructor.apply(this, arguments);

      /**
      * An array containing all sprites of the current message.
      * @property sprites
      * @type gs.Sprite[]
      * @protected
       */
      this.sprites = [];

      /**
      * An array containing all sprites of all messages. In NVL mode
      * a page can contain multiple messages.
      * @property allSprites
      * @type gs.Sprite[]
      * @protected
       */
      this.allSprites = [];

      /**
      * An array containing all line-objects of the current message.
      * @property lines
      * @type gs.TextRendererLine[]
      * @readOnly
       */
      this.lines = null;

      /**
      * The line currently rendered.
      * @property line
      * @type number
      * @readOnly
       */
      this.line = 0;

      /**
      * The left and right padding per line.
      * @property padding
      * @type number
       */
      this.padding = 6;

      /**
      * The minimum height of the line currently rendered. If 0, the measured
      * height of the line will be used.
      * @property minLineHeight
      * @type number
       */
      this.minLineHeight = 0;

      /**
      * The spacing between text lines in pixels.
      * @property lineSpacing
      * @type number
       */
      this.lineSpacing = 2;

      /**
      * The line currently rendered.
      * @property currentLine
      * @type number
      * @protected
       */
      this.currentLine = 0;

      /**
      * The height of the line currently rendered.
      * @property currentLineHeight
      * @type number
      * @protected
       */
      this.currentLineHeight = 0;

      /**
      * Index of the current character to draw.
      * @property charIndex
      * @type number
      * @readOnly
       */
      this.charIndex = 0;

      /**
      * Position of the message caret. The caret is like an invisible
      * cursor pointing to the x/y coordinates of the last rendered character of
      * the message. That position can be used to display a waiting- or processing-animation for example.
      * @property caretPosition
      * @type gs.Point
      * @readOnly
       */
      this.caretPosition = new gs.Point();

      /**
      * Indicates that the a message is currently in progress.
      * @property isRunning
      * @type boolean
      * @readOnly
       */
      this.isRunning = false;

      /**
      * The current x-coordinate of the caret/cursor.
      * @property currentX
      * @type number
      * @readOnly
       */
      this.currentX = 0;

      /**
      * The current y-coordinate of the caret/cursor.
      * @property currentY
      * @type number
      * @readOnly
       */
      this.currentY = 0;

      /**
      * The current sprites used to display the current text-line/part.
      * @property currentSprite
      * @type gs.Sprite
      * @readOnly
       */
      this.currentSprite = null;

      /**
      * Indicates if the message-renderer is currently waiting like for a user-action.
      * @property isWaiting
      * @type boolean
      * @readOnly
       */
      this.isWaiting = false;

      /**
      * Indicates if the message-renderer is currently waiting for a key-press or mouse/touch action.
      * @property waitForKey
      * @type boolean
      * @readOnly
       */
      this.waitForKey = false;

      /**
      * Number of frames the message-renderer should wait before continue.
      * @property waitCounter
      * @type number
       */
      this.waitCounter = 0;

      /**
      * Speed of the message-drawing. The smaller the value, the faster the message is displayed.
      * @property speed
      * @type number
       */
      this.speed = 1;

      /**
      * Indicates if the message should be rendered immedialtely without any animation or delay.
      * @property drawImmediately
      * @type boolean
       */
      this.drawImmediately = false;

      /**
      * Indicates if the message should wait for a user-action or a certain amount of time
      * before finishing.
      * @property waitAtEnd
      * @type boolean
       */
      this.waitAtEnd = true;

      /**
      * The number of frames to wait before finishing a message.
      * before finishing.
      * @property waitAtEndTime
      * @type number
       */
      this.waitAtEndTime = 0;

      /**
      * Indicates if auto word-wrap should be used. Default is <b>true</b>
      * @property wordWrap
      * @type boolean
       */
      this.wordWrap = true;

      /**
      * Custom game objects which are alive until the current message is erased. Can be used to display
      * animated icons, etc.
      * @property customObjects
      * @type gs.Object_Base[]
       */
      this.customObjects = [];

      /**
      * A hashtable/dictionary object to store custom-data useful like for token-processing. The data must be
      * serializable.
      * @property customObjects
      * @type Object
       */
      this.customData = {};

      /**
      * A callback function called if the player clicks on a non-stylable link (LK text-code) to trigger
      * the specified common event.
      * @property onLinkClick
      * @type Function
       */
      this.onLinkClick = function(e) {
        var event, eventId;
        eventId = e.data.linkData.commonEventId;
        event = RecordManager.commonEvents[eventId];
        if (!event) {
          event = RecordManager.commonEvents.first((function(_this) {
            return function(x) {
              return x.name === eventId;
            };
          })(this));
          if (event) {
            eventId = event.index;
          }
        }
        if (!event) {
          return SceneManager.scene.interpreter.jumpToLabel(eventId);
        } else {
          return SceneManager.scene.interpreter.callCommonEvent(eventId, null, true);
        }
      };

      /**
      * A callback function called if a batched messsage has been faded out. It triggers the execution of
      * the next message.
      * @property onBatchDisappear
      * @type Function
       */
      this.onBatchDisappear = (function(_this) {
        return function(e) {
          _this.drawImmediately = false;
          _this.isWaiting = false;
          _this.object.opacity = 255;
          return _this.executeBatch();
        };
      })(this);
    }


    /**
    * Serializes the message text-renderer into a data-bundle.
    * @method toDataBundle
    * @return {Object} A data-bundle.
     */

    Component_MessageTextRenderer.prototype.toDataBundle = function() {
      var bundle, ignore, k;
      ignore = ["object", "font", "sprites", "allSprites", "currentSprite", "currentX"];
      bundle = {
        currentSpriteIndex: this.sprites.indexOf(this.currentSprite)
      };
      for (k in this) {
        if (ignore.indexOf(k) === -1) {
          bundle[k] = this[k];
        }
      }
      return bundle;
    };


    /**
    * Disposes the message text-renderer and all sprites used to display
    * the message.
    * @method dispose
     */

    Component_MessageTextRenderer.prototype.dispose = function() {
      var j, len, ref, ref1, results, sprite;
      Component_MessageTextRenderer.__super__.dispose.apply(this, arguments);
      this.disposeEventHandlers();
      ref = this.allSprites;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        sprite = ref[j];
        if ((ref1 = sprite.bitmap) != null) {
          ref1.dispose();
        }
        results.push(sprite.dispose());
      }
      return results;
    };


    /**
    * Removes all attached event handlers
    * the message.
    * @method disposeEventHandlers
     */

    Component_MessageTextRenderer.prototype.disposeEventHandlers = function() {
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      return gs.GlobalEventManager.offByOwner("keyUp", this.object);
    };


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_MessageTextRenderer.prototype.setupEventHandlers = function() {
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      gs.GlobalEventManager.offByOwner("keyUp", this.object);
      gs.GlobalEventManager.on("mouseUp", ((function(_this) {
        return function(e) {
          if (_this.object.findComponentByName("animation") || (GameManager.settings.autoMessage.enabled && !GameManager.settings.autoMessage.stopOnAction)) {
            return;
          }
          if (_this.isWaiting && !(_this.waitCounter > 0 || _this.waitForKey)) {
            e.breakChain = true;
            _this["continue"]();
          } else {
            e.breakChain = _this.isRunning;
            _this.drawImmediately = !_this.waitForKey;
            _this.waitCounter = 0;
            _this.waitForKey = false;
            _this.isWaiting = false;
          }
          if (_this.waitForKey) {
            if (Input.Mouse.buttons[Input.Mouse.LEFT] === 2) {
              e.breakChain = true;
              Input.clear();
              _this.waitForKey = false;
              return _this.isWaiting = false;
            }
          }
        };
      })(this)), null, this.object);
      return gs.GlobalEventManager.on("keyUp", ((function(_this) {
        return function(e) {
          if (Input.keys[Input.C] && (!_this.isWaiting || (_this.waitCounter > 0 || _this.waitForKey))) {
            _this.drawImmediately = !_this.waitForKey;
            _this.waitCounter = 0;
            _this.waitForKey = false;
            _this.isWaiting = false;
          }
          if (_this.isWaiting && !_this.waitForKey && !_this.waitCounter && Input.keys[Input.C]) {
            _this["continue"]();
          }
          if (_this.waitForKey) {
            if (Input.keys[Input.C]) {
              Input.clear();
              _this.waitForKey = false;
              return _this.isWaiting = false;
            }
          }
        };
      })(this)), null, this.object);
    };


    /**
    * Sets up the renderer. Registers necessary event handlers.
    * @method setup
     */

    Component_MessageTextRenderer.prototype.setup = function() {
      return this.setupEventHandlers();
    };


    /**
    * Restores the message text-renderer's state from a data-bundle.
    * @method restore
    * @param {Object} bundle - A data-bundle containing message text-renderer state.
     */

    Component_MessageTextRenderer.prototype.restore = function(bundle) {
      var k;
      for (k in bundle) {
        if (k === "currentSpriteIndex") {
          this.currentSprite = this.sprites[bundle.currentSpriteIndex];
        } else {
          this[k] = bundle[k];
        }
      }
      if (this.sprites.length > 0) {
        this.currentY = this.sprites.last().y - this.object.origin.y - this.object.dstRect.y;
        this.line = this.maxLines;
        this.isWaiting = this.isWaiting || this.isRunning;
      }
      return null;
    };


    /**
    * Continues message-processing if currently waiting.
    * @method continue
     */

    Component_MessageTextRenderer.prototype["continue"] = function() {
      var duration, fading, ref, ref1;
      this.isWaiting = false;
      if (this.line >= this.lines.length) {
        this.isRunning = false;
        return (ref = this.object.events) != null ? ref.emit("messageFinish", this) : void 0;
      } else {
        if ((ref1 = this.object.events) != null) {
          ref1.emit("messageBatch", this);
        }
        fading = GameManager.tempSettings.messageFading;
        duration = GameManager.tempSettings.skip ? 0 : fading.duration;
        return this.object.animator.disappear(fading.animation, fading.easing, duration, gs.CallBack("onBatchDisappear", this));
      }
    };


    /**
    * Updates the text-renderer.
    * @method update
     */

    Component_MessageTextRenderer.prototype.update = function() {
      var j, len, len1, m, object, ref, ref1, ref2, sprite;
      ref = this.allSprites;
      for (j = 0, len = ref.length; j < len; j++) {
        sprite = ref[j];
        sprite.opacity = this.object.opacity;
        sprite.visible = this.object.visible;
        sprite.ox = -this.object.offset.x;
        sprite.oy = -this.object.offset.y;
        sprite.mask.value = this.object.mask.value;
        sprite.mask.vague = this.object.mask.vague;
        sprite.mask.source = this.object.mask.source;
        sprite.mask.type = this.object.mask.type;
      }
      ref1 = this.customObjects;
      for (m = 0, len1 = ref1.length; m < len1; m++) {
        object = ref1[m];
        object.opacity = this.object.opacity;
        object.visible = this.object.visible;
      }
      if (!this.isRunning && this.waitCounter > 0) {
        this.waitCounter--;
        if (this.waitCounter === 0) {
          this["continue"]();
        }
        return;
      }
      if (this.object.visible && ((ref2 = this.lines) != null ? ref2.length : void 0) > 0) {
        this.updateLineWriting();
        this.updateWaitForKey();
        this.updateWaitCounter();
        return this.updateCaretPosition();
      }
    };


    /**
    * Indicates if its a batched messages.
    *
    * @method isBatched
    * @return If <b>true</b> it is a batched message. Otherwise <b>false</b>.
     */

    Component_MessageTextRenderer.prototype.isBatched = function() {
      return this.lines.length > this.maxLines;
    };


    /**
    * Indicates if the batch is still in progress and not done.
    *
    * @method isBatchInProgress
    * @return If <b>true</b> the batched message is still not done. Otherwise <b>false</b>
     */

    Component_MessageTextRenderer.prototype.isBatchInProgress = function() {
      return this.lines.length - this.line > this.maxLines;
    };


    /**
    * Indicates if the renderer runs in multi-part message mode which
    * means that a single message might be constructed from multiple drawFormattedText
    * calls.
    *
    * @method isRunningInMultiPartMode
    * @return If <b>true</b> the renderer runs in multi-part mode. Otherwise <b>false</b>.
     */

    Component_MessageTextRenderer.prototype.isRunningInMultiPartMode = function() {
      return !this.object.settings.autoErase && this.object.settings.paragraphSpacing <= 0;
    };


    /**
    * Starts displaying the next page of text if a message is too long to fit
    * into one message box.
    *
    * @method executeBatch
     */

    Component_MessageTextRenderer.prototype.executeBatch = function() {
      this.clearAllSprites();
      this.lines = this.lines.slice(this.line);
      this.line = 0;
      this.currentX = 0;
      this.currentY = 0;
      this.currentLineHeight = 0;
      this.tokenIndex = 0;
      this.charIndex = 0;
      this.token = this.lines[this.line].content[this.tokenIndex] || new gs.RendererToken(null, "");
      this.maxLines = this.calculateMaxLines(this.lines);
      this.lineAnimationCount = this.speed;
      this.sprites = this.createSprites(this.lines);
      this.allSprites = this.allSprites.concat(this.sprites);
      this.currentSprite = this.sprites[this.line];
      this.currentSprite.x = this.currentX + this.object.origin.x + this.object.dstRect.x;
      return this.drawNext();
    };


    /**
    * Calculates the duration(in frames) the message-renderer needs to display
    * the message.
    *
    * @method calculateDuration
    * @return {number} The duration in frames.
     */

    Component_MessageTextRenderer.prototype.calculateDuration = function() {
      var duration, j, len, len1, line, m, ref, ref1, token;
      duration = 0;
      if (this.lines != null) {
        ref = this.lines;
        for (j = 0, len = ref.length; j < len; j++) {
          line = ref[j];
          ref1 = line.content;
          for (m = 0, len1 = ref1.length; m < len1; m++) {
            token = ref1[m];
            if (token != null) {
              duration += this.calculateDurationForToken(token);
            }
          }
        }
      }
      return duration;
    };


    /**
    * Calculates the duration(in frames) the message-renderer needs to display
    * the specified line.
    *
    * @method calculateDurationForLine
    * @param {gs.RendererTextLine} line The line to calculate the duration for.
    * @return {number} The duration in frames.
     */

    Component_MessageTextRenderer.prototype.calculateDurationForLine = function(line) {
      var duration, j, len, ref, token;
      duration = 0;
      if (line) {
        ref = line.content;
        for (j = 0, len = ref.length; j < len; j++) {
          token = ref[j];
          if (token != null) {
            duration += this.calculateDurationForToken(token);
          }
        }
      }
      return duration;
    };


    /**
    * Calculates the duration(in frames) the message-renderer needs to process
    * the specified token.
    *
    * @method calculateDurationForToken
    * @param {string|Object} token - The token.
    * @return {number} The duration in frames.
     */

    Component_MessageTextRenderer.prototype.calculateDurationForToken = function(token) {
      var duration;
      duration = 0;
      if (token.code != null) {
        switch (token.code) {
          case "W":
            if (token.value !== "A") {
              duration = token.value / 1000 * Graphics.frameRate;
            }
        }
      } else {
        duration = token.value.length * this.speed;
      }
      return duration;
    };


    /**
    * Calculates the maximum of lines which can be displayed in one message.
    *
    * @method calculateMaxLines
    * @param {Array} lines - An array of line-objects.
    * @return {number} The number of displayable lines.
     */

    Component_MessageTextRenderer.prototype.calculateMaxLines = function(lines) {
      var height, j, len, line, result;
      height = 0;
      result = 0;
      for (j = 0, len = lines.length; j < len; j++) {
        line = lines[j];
        height += line.height + this.lineSpacing;
        if (this.currentY + height > this.object.dstRect.height) {
          break;
        }
        result++;
      }
      return Math.min(lines.length, result || 1);
    };


    /**
    * Displays the character or processes the next control-token.
    *
    * @method drawNext
     */

    Component_MessageTextRenderer.prototype.drawNext = function() {
      var lineSpacing, size, token;
      token = this.processToken();
      if ((token != null ? token.value.length : void 0) > 0) {
        this.char = this.token.value.charAt(this.charIndex);
        size = this.font.measureTextPlain(this.char);
        lineSpacing = this.lineSpacing;
        if (this.currentLine !== this.line) {
          this.currentLine = this.line;
          this.currentLineHeight = 0;
        }
        this.currentSprite.y = this.object.origin.y + this.object.dstRect.y + this.currentY;
        this.currentSprite.visible = true;
        this.drawLineContent(this.lines[this.line], this.currentSprite.bitmap, this.charIndex + 1);
        this.currentSprite.srcRect.width = this.currentSprite.bitmap.width;
        this.currentLineHeight = this.lines[this.line].height;
        return this.currentX = Math.min(this.lines[this.line].width, this.currentX + size.width);
      }
    };


    /**
    * Processes the next character/token of the message.
    * @method nextChar
    * @private
     */

    Component_MessageTextRenderer.prototype.nextChar = function() {
      var base, base1, results;
      results = [];
      while (true) {
        this.charIndex++;
        this.lineAnimationCount = this.speed;
        if ((this.token.code != null) || this.charIndex >= this.token.value.length) {
          if (typeof (base = this.token).onEnd === "function") {
            base.onEnd();
          }
          this.tokenIndex++;
          if (this.tokenIndex >= this.lines[this.line].content.length) {
            this.tokenIndex = 0;
            this.line++;
            this.currentSprite.srcRect.width = this.currentSprite.bitmap.width;
            this.currentSprite = this.sprites[this.line];
            if (this.currentSprite != null) {
              this.currentSprite.x = this.object.origin.x + this.object.dstRect.x;
            }
            if (this.line < this.maxLines) {
              this.currentY += (this.currentLineHeight || this.font.lineHeight) + this.lineSpacing * Graphics.scale;
              this.charIndex = 0;
              this.currentX = 0;
              this.token = this.lines[this.line].content[this.tokenIndex] || new gs.RendererToken(null, "");
            }
          } else {
            this.charIndex = 0;
            this.token = this.lines[this.line].content[this.tokenIndex] || new gs.RendererToken(null, "");
          }
          if (typeof (base1 = this.token).onStart === "function") {
            base1.onStart();
          }
        }
        if (!this.token || this.token.value !== "\n" || !this.lines[this.line]) {
          break;
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Finishes the message. Depending on the message configuration, the
    * message text-renderer will now wait for a user-action or a certain amount
    * of time.
    *
    * @method finish
     */

    Component_MessageTextRenderer.prototype.finish = function() {
      var ref, ref1, ref2;
      if (this.waitAtEnd) {
        this.isWaiting = true;
        return (ref = this.object.events) != null ? ref.emit("messageWaiting", this) : void 0;
      } else if (this.waitAtEndTime > 0) {
        this.waitCounter = this.waitAtEndTime;
        this.isWaiting = false;
        return (ref1 = this.object.events) != null ? ref1.emit("messageWaiting", this) : void 0;
      } else {
        if ((ref2 = this.object.events) != null) {
          ref2.emit("messageWaiting", this);
        }
        return this["continue"]();
      }
    };


    /**
    * Returns the position of the caret in pixels. The caret is like an invisible
    * cursor pointing to the x/y coordinates of the last rendered character of
    * the message. That position can be used to display a waiting- or processing-animation for example.
    *
    * @method updateCaretPosition
     */

    Component_MessageTextRenderer.prototype.updateCaretPosition = function() {
      this.caretPosition.x = this.currentX + this.padding;
      return this.caretPosition.y = this.currentY + this.currentLineHeight / 2;
    };


    /**
    * Updates the line writing.
    *
    * @method updateLineWriting
    * @private
     */

    Component_MessageTextRenderer.prototype.updateLineWriting = function() {
      if (this.isRunning && !this.isWaiting && !this.waitForKey && this.waitCounter <= 0) {
        if (this.lineAnimationCount <= 0) {
          while (true) {
            if (this.line < this.maxLines) {
              this.nextChar();
            }
            if (this.line >= this.maxLines) {
              this.finish();
            } else {
              this.drawNext();
            }
            if (!((this.token.code || this.lineAnimationCount <= 0 || this.drawImmediately) && !this.waitForKey && this.waitCounter <= 0 && this.isRunning && this.line < this.maxLines)) {
              break;
            }
          }
        }
        if (GameManager.tempSettings.skip) {
          return this.lineAnimationCount = 0;
        } else {
          return this.lineAnimationCount--;
        }
      }
    };


    /**
    * Updates wait-for-key state. If skipping is enabled, the text renderer will
    * not wait for key press.
    *
    * @method updateWaitForKey
    * @private
     */

    Component_MessageTextRenderer.prototype.updateWaitForKey = function() {
      if (this.waitForKey) {
        this.isWaiting = !GameManager.tempSettings.skip;
        return this.waitForKey = this.isWaiting;
      }
    };


    /**
    * Updates wait counter if the text renderer is waiting for a certain amount of time to pass. If skipping is enabled, the text renderer will
    * not wait for the actual amount of time and sets the wait-counter to 1 frame instead.
    *
    * @method updateWaitForKey
    * @private
     */

    Component_MessageTextRenderer.prototype.updateWaitCounter = function() {
      if (this.waitCounter > 0) {
        if (GameManager.tempSettings.skip) {
          this.waitCounter = 1;
        }
        this.isWaiting = true;
        this.waitCounter--;
        if (this.waitCounter <= 0) {
          this.isWaiting = false;
          if (this.line >= this.maxLines) {
            return this["continue"]();
          }
        }
      }
    };


    /**
    * Creates a token-object for a specified text-code.
    *
    * @method createToken
    * @param {string} code - The code/type of the text-code.
    * @param {string} value - The value of the text-code.
    * @return {Object} The token-object.
     */

    Component_MessageTextRenderer.prototype.createToken = function(code, value) {
      var data, i, j, ref, tokenObject;
      tokenObject = null;
      switch (code) {
        case "CE":
          data = value.split("/");
          value = data.shift();
          value = isNaN(value) ? value : parseInt(value);
          for (i = j = 0, ref = data; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            if (data[i].startsWith('"') && data[i].endsWith('"')) {
              data[i] = data[i].substring(1, data[i].length - 1);
            } else {
              data[i] = isNaN(data[i]) ? data[i] : parseFloat(data[i]);
            }
          }
          tokenObject = {
            code: code,
            value: value,
            values: data
          };
          break;
        default:
          tokenObject = Component_MessageTextRenderer.__super__.createToken.call(this, code, value);
      }
      return tokenObject;
    };


    /**
    * <p>Measures a control-token. If a token produces a visual result like displaying an icon then it must return the size taken by
    * the visual result. If the token has no visual result, <b>null</b> must be returned. This method is called for every token when the message is initialized.</p>
    *
    * <p>This method is not called while the message is running. For that case, see <i>processControlToken</i> method which is called
    * for every token while the message is running.</p>
    *
    * @param {Object} token - A control-token.
    * @return {gs.Size} The size of the area taken by the visual result of the token or <b>null</b> if the token has no visual result.
    * @method analyzeControlToken
    * @protected
     */

    Component_MessageTextRenderer.prototype.measureControlToken = function(token) {
      return Component_MessageTextRenderer.__super__.measureControlToken.call(this, token);
    };


    /**
    * <p>Draws the visual result of a token, like an icon for example, to the specified bitmap. This method is called for every token when the message is initialized and the sprites for each
    * text-line are created.</p>
    *
    * <p>This method is not called while the message is running. For that case, see <i>processControlToken</i> method which is called
    * for every token while the message is running.</p>
    *
    * @param {Object} token - A control-token.
    * @param {gs.Bitmap} bitmap - The bitmap used for the current text-line. Can be used to draw something on it like an icon, etc.
    * @param {number} offset - An x-offset for the draw-routine.
    * @param {number} length - Determines how many characters of the token should be drawn. Can be ignored for tokens
    * not drawing any characters.
    * @method drawControlToken
    * @protected
     */

    Component_MessageTextRenderer.prototype.drawControlToken = function(token, bitmap, offset, length) {
      var data, j, len, linkData, results;
      switch (token.code) {
        case "RT":
          return Component_MessageTextRenderer.__super__.drawControlToken.call(this, token, bitmap, offset, length);
        case "SLK":
          if (token.customData.offsetX == null) {
            token.customData.offsetX = offset;
          }
          if (this.customData.linkData) {
            linkData = this.customData.linkData[this.line];
            if (linkData) {
              results = [];
              for (j = 0, len = linkData.length; j < len; j++) {
                data = linkData[j];
                results.push(this.sprites[this.line].bitmap.clearRect(data.cx, 0, data.width, data.height));
              }
              return results;
            }
          }
      }
    };


    /**
    * Processes a control-token. A control-token is a token which influences
    * the text-rendering like changing the fonts color, size or style. Changes
    * will be automatically applied to the game object's font.
    *
    * For message text-renderer, a few additional control-tokens like
    * speed-change, waiting, etc. needs to be processed here.
    *
    * This method is called for each token while the message is initialized and
    * also while the message is running. See <i>formattingOnly</i> parameter.
    *
    * @param {Object} token - A control-token.
    * @param {boolean} formattingOnly - If <b>true</b> the message is initializing right now and only
    * format-tokens should be processed which is necessary for the message to calculated sizes correctly.
    * @return {Object} A new token which is processed next or <b>null</b>.
    * @method processControlToken
    * @protected
     */

    Component_MessageTextRenderer.prototype.processControlToken = function(token, formattingOnly) {
      var animation, bitmap, character, duration, easing, expression, line, linkData, linkStart, object, params, ref, ref1, result, sound, textTokens, values;
      if (formattingOnly) {
        return Component_MessageTextRenderer.__super__.processControlToken.call(this, token);
      }
      result = null;
      switch (token.code) {
        case "CR":
          character = RecordManager.charactersArray.first(function(c) {
            var ref;
            return ((ref = c.name.defaultText) != null ? ref : c.name) === token.value;
          });
          if (character) {
            SceneManager.scene.currentCharacter = character;
          }
          break;
        case "CE":
          params = {
            "values": token.values
          };
          if ((ref = this.object.events) != null) {
            ref.emit("callCommonEvent", this.object, {
              commonEventId: token.value,
              params: params,
              finish: false,
              waiting: true
            });
          }
          break;
        case "X":
          if (typeof token.value === "function") {
            token.value(this.object);
          }
          break;
        case "A":
          animation = RecordManager.animationsArray.first(function(a) {
            return a.name === token.value;
          });
          if (!animation) {
            animation = RecordManager.animations[token.value];
          }
          if ((animation != null ? animation.graphic.name : void 0) != null) {
            bitmap = ResourceManager.getBitmap("Graphics/Pictures/" + animation.graphic.name);
            object = new gs.Object_Animation(animation);
            this.addCustomObject(object);
            this.currentX += Math.round(bitmap.width / animation.framesX);
            this.currentSprite.srcRect.width += Math.round(bitmap.width / animation.framesX);
          }
          break;
        case "RT":
          if (token.rtSize.width > token.rbSize.width) {
            this.currentX += token.rtSize.width;
            this.font.set(this.getRubyTextFont(token));
          } else {
            this.currentX += token.rbSize.width;
          }
          break;
        case "LK":
          if (token.value === 'E') {
            object = new ui.Object_Hotspot();
            object.enabled = true;
            object.setup();
            this.addCustomObject(object);
            object.dstRect.x = this.object.dstRect.x + this.object.origin.x + this.customData.linkData.cx;
            object.dstRect.y = this.object.dstRect.y + this.object.origin.y + this.customData.linkData.cy;
            object.dstRect.width = this.currentX - this.customData.linkData.cx;
            object.dstRect.height = this.currentLineHeight;
            object.events.on("click", gs.CallBack("onLinkClick", this), {
              linkData: this.customData.linkData
            }, this);
          } else {
            this.customData.linkData = {
              cx: this.currentX,
              cy: this.currentY,
              commonEventId: token.value,
              tokenIndex: this.tokenIndex
            };
          }
          break;
        case "SLK":
          if (token.value === 'E') {
            linkData = this.customData.linkData[this.line].last();
            line = this.lines[this.line].content;
            linkStart = this.findToken(this.tokenIndex - 1, "SLK", -1, line);
            textTokens = this.findTokensBetween(linkData.tokenIndex, this.tokenIndex, null, line);
            linkData.cx = linkStart.customData.offsetX;
            linkData.width = this.currentX - linkData.cx + this.padding;
            linkData.height = this.currentSprite.bitmap.height;
            object = new ui.Object_Text();
            object.text = textTokens.select((function(_this) {
              return function(x) {
                return x.value;
              };
            })(this)).join("");
            object.formatting = false;
            object.wordWrap = false;
            object.ui = new ui.Component_UIBehavior();
            object.enabled = true;
            object.addComponent(object.ui);
            object.addComponent(new gs.Component_HotspotBehavior());
            object.behavior.padding.left = 0;
            object.behavior.padding.right = 0;
            object.dstRect.width = linkData.width;
            object.dstRect.height = linkData.height;
            if (linkData.styleIndex === -1) {
              ui.UIManager.addControlStyles(object, ["hyperlink"]);
            } else {
              ui.UIManager.addControlStyles(object, ["hyperlink-" + linkData.styleIndex]);
            }
            object.setup();
            this.addCustomObject(object);
            object.dstRect.x = this.currentSprite.x + linkData.cx;
            object.dstRect.y = this.object.dstRect.y + this.object.origin.y + linkData.cy;
            object.events.on("click", gs.CallBack("onLinkClick", this), {
              linkData: linkData
            }, this);
          } else {
            if (!this.customData.linkData) {
              this.customData.linkData = [];
            }
            if (!this.customData.linkData[this.line]) {
              this.customData.linkData[this.line] = [];
            }
            if ((ref1 = token.value) != null ? ref1.contains(",") : void 0) {
              values = token.value.split(",");
              this.customData.linkData[this.line].push({
                cx: this.currentX,
                cy: this.currentY,
                commonEventId: values[0],
                styleIndex: parseInt(values[1]),
                tokenIndex: this.tokenIndex
              });
            } else {
              this.customData.linkData[this.line].push({
                cx: this.currentY,
                cy: this.currentY,
                commonEventId: token.value,
                tokenIndex: this.tokenIndex,
                styleIndex: -1
              });
            }
          }
          break;
        case "E":
          expression = RecordManager.characterExpressionsArray.first(function(c) {
            var ref2;
            return ((ref2 = c.name.defaultText) != null ? ref2 : c.name) === token.value;
          });
          if (!expression) {
            expression = RecordManager.characterExpressions[token.value];
          }
          character = SceneManager.scene.currentCharacter;
          if ((expression != null) && ((character != null ? character.index : void 0) != null)) {
            duration = GameManager.defaults.character.expressionDuration;
            easing = gs.Easings.fromObject(GameManager.defaults.character.changeEasing);
            animation = GameManager.defaults.character.changeAnimation;
            object = SceneManager.scene.characters.first(function(c) {
              return c.rid === character.index;
            });
            if (object != null) {
              object.behavior.changeExpression(expression, animation, easing, duration);
            }
          }
          break;
        case "SP":
          sound = RecordManager.system.sounds[token.value - 1];
          AudioManager.playSound(sound);
          break;
        case "S":
          GameManager.settings.messageSpeed = token.value;
          break;
        case "W":
          this.drawImmediately = false;
          if (!GameManager.tempSettings.skip) {
            if (token.value === "A") {
              this.waitForKey = true;
            } else {
              this.waitCounter = Math.round(token.value / 1000 * Graphics.frameRate);
            }
          }
          break;
        case "WE":
          this.waitAtEnd = token.value === "Y";
          break;
        case "DI":
          this.drawImmediately = token.value === 1 || token.value === "Y";
          break;
        default:
          result = Component_MessageTextRenderer.__super__.processControlToken.call(this, token);
      }
      return result;
    };


    /**
    * Clears/Resets the text-renderer.
    *
    * @method clear
     */

    Component_MessageTextRenderer.prototype.clear = function() {
      var j, len, ref, ref1, ref2, sprite;
      this.charIndex = 0;
      this.currentX = 0;
      this.currentY = 0;
      this.line = 0;
      this.lines = [];
      this.clearCustomObjects();
      if ((ref = this.object.bitmap) != null) {
        ref.clear();
      }
      ref1 = this.allSprites;
      for (j = 0, len = ref1.length; j < len; j++) {
        sprite = ref1[j];
        sprite.dispose();
        if ((ref2 = sprite.bitmap) != null) {
          ref2.dispose();
        }
      }
      this.allSprites = [];
      return null;
    };


    /**
    * Clears/Disposes all sprites used to display the text-lines/parts.
    *
    * @method clearAllSprites
     */

    Component_MessageTextRenderer.prototype.clearAllSprites = function() {
      var j, len, ref, ref1, sprite;
      ref = this.allSprites;
      for (j = 0, len = ref.length; j < len; j++) {
        sprite = ref[j];
        sprite.dispose();
        if ((ref1 = sprite.bitmap) != null) {
          ref1.dispose();
        }
      }
      return null;
    };


    /**
    * Clears/Disposes the sprites used to display the text-lines/parts of the current/last message.
    *
    * @method clearSprites
     */

    Component_MessageTextRenderer.prototype.clearSprites = function() {
      var j, len, ref, ref1, sprite;
      ref = this.sprites;
      for (j = 0, len = ref.length; j < len; j++) {
        sprite = ref[j];
        sprite.dispose();
        if ((ref1 = sprite.bitmap) != null) {
          ref1.dispose();
        }
      }
      return null;
    };


    /**
    * Removes a game object from the message.
    *
    * @method removeCustomObject
    * @param object {gs.Object_Base} The game object to remove.
     */

    Component_MessageTextRenderer.prototype.removeCustomObject = function(object) {
      SceneManager.scene.removeObject(object);
      object.dispose();
      return this.customObjects.remove(object);
    };


    /**
    * Adds a game object to the message which is alive until the message is
    * erased. Can be used to display animationed-icons, etc. in a message.
    *
    * @method addCustomObject
    * @param object {gs.Object_Base} The game object to add.
     */

    Component_MessageTextRenderer.prototype.addCustomObject = function(object) {
      object.dstRect.x = this.object.dstRect.x + this.object.origin.x + this.currentX;
      object.dstRect.y = this.object.dstRect.y + this.object.origin.y + this.currentY;
      object.zIndex = this.object.zIndex + 1;
      object.update();
      SceneManager.scene.addObject(object);
      return this.customObjects.push(object);
    };


    /**
    * Clears the list of custom game objects. All game objects are disposed and removed
    * from the scene.
    *
    * @method clearCustomObjects
    * @param object {Object} The game object to add.
     */

    Component_MessageTextRenderer.prototype.clearCustomObjects = function() {
      var j, len, object, ref;
      ref = this.customObjects;
      for (j = 0, len = ref.length; j < len; j++) {
        object = ref[j];
        object.dispose();
        SceneManager.scene.removeObject(object);
      }
      return this.customObjects = [];
    };


    /**
    * Creates the bitmap for a specified line-object.
    *
    * @method createBitmap
    * @private
    * @param {Object} line - A line-object.
    * @return {Bitmap} A newly created bitmap containing the line-text.
     */

    Component_MessageTextRenderer.prototype.createBitmap = function(line) {
      var bitmap;
      this.font = this.object.font;
      bitmap = new Bitmap(this.object.dstRect.width, Math.max(this.minLineHeight, line.height));
      bitmap.font = this.font;
      return bitmap;
    };


    /**
    * Draws the line's content on the specified bitmap.
    *
    * @method drawLineContent
    * @protected
    * @param {Object} line - A line-object which should be drawn on the bitmap.
    * @param {gs.Bitmap} bitmap - The bitmap to draw the line's content on.
    * @param {number} length - Determines how many characters of the specified line should be drawn. You can
    * specify -1 to draw all characters.
     */

    Component_MessageTextRenderer.prototype.drawLineContent = function(line, bitmap, length) {
      var currentX, drawAll, i, j, len, ref, size, token, value;
      bitmap.clear();
      currentX = this.padding;
      drawAll = length === -1;
      ref = line.content;
      for (i = j = 0, len = ref.length; j < len; i = ++j) {
        token = ref[i];
        if (i > this.tokenIndex && !drawAll) {
          break;
        }
        if (token.code != null) {
          size = this.measureControlToken(token, bitmap);
          this.drawControlToken(token, bitmap, currentX);
          if (size) {
            currentX += size.width;
          }
          this.processControlToken(token, true, line);
        } else if (token.value.length > 0) {
          token.applyFormat(this.font);
          value = token.value;
          if (!drawAll && this.tokenIndex === i && value.length > length) {
            value = value.substring(0, length);
          }
          if (value !== "\n") {
            size = this.font.measureTextPlain(value);
            bitmap.drawText(currentX, line.height - (size.height - this.font.descent) - line.descent, size.width, bitmap.height, value, 0, 0);
            currentX += size.width;
          }
        }
      }
      return line.contentWidth = currentX + this.font.measureTextPlain(" ").width;
    };


    /**
    * Creates the sprite for a specified line-object.
    *
    * @method createSprite
    * @private
    * @param {Object} line - A line-object.
    * @return {Sprite} A newly created sprite object containing the line-text as bitmap.
     */

    Component_MessageTextRenderer.prototype.createSprite = function(line) {
      var bitmap, sprite;
      bitmap = this.createBitmap(line);
      this.currentX = 0;
      this.waitCounter = 0;
      this.waitForKey = false;
      sprite = new Sprite(Graphics.viewport);
      sprite.bitmap = bitmap;
      sprite.visible = true;
      sprite.z = this.object.zIndex + 1;
      sprite.srcRect = new Rect(0, 0, 0, bitmap.height);
      return sprite;
    };


    /**
    * Creates the sprites for a specified array of line-objects.
    *
    * @method createSprites
    * @private
    * @see gs.Component_MessageTextRenderer.createSprite.
    * @param {Array} lines - An array of line-objects.
    * @return {Array} An array of sprites.
     */

    Component_MessageTextRenderer.prototype.createSprites = function(lines) {
      var i, j, len, line, result, sprite;
      this.fontSize = this.object.font.size;
      result = [];
      for (i = j = 0, len = lines.length; j < len; i = ++j) {
        line = lines[i];
        sprite = this.createSprite(line);
        result.push(sprite);
      }
      return result;
    };


    /**
    * Starts a new line.
    *
    * @method newLine
     */

    Component_MessageTextRenderer.prototype.newLine = function() {
      this.currentX = 0;
      return this.currentY += this.currentLineHeight + this.lineSpacing;
    };


    /**
    * Displays a formatted text immediately without any delays or animations. The
    * Component_TextRenderer.drawFormattedText method from the base-class cannot
    * be used here because it would render to the game object's bitmap object while
    * this method is rendering to the sprites.
    *
    * @method drawFormattedTextImmediately
    * @param {number} x - The x-coordinate of the text's position.
    * @param {number} y - The y-coordinate of the text's position.
    * @param {number} width - Deprecated. Can be null.
    * @param {number} height - Deprecated. Can be null.
    * @param {string} text - The text to draw.
    * @param {boolean} wordWrap - If wordWrap is set to true, line-breaks are automatically created.
     */

    Component_MessageTextRenderer.prototype.drawFormattedTextImmediately = function(x, y, width, height, text, wordWrap) {
      this.drawFormattedText(x, y, width, height, text, wordWrap);
      while (true) {
        this.nextChar();
        if (this.line >= this.maxLines) {
          this.isRunning = false;
        } else {
          this.drawNext();
        }
        if (!this.isRunning) {
          break;
        }
      }
      this.currentY += this.currentLineHeight + this.lineSpacing;
      return null;
    };


    /**
    * Starts the rendering-process for the message.
    *
    * @method drawFormattedText
    * @param {number} x - The x-coordinate of the text's position.
    * @param {number} y - The y-coordinate of the text's position.
    * @param {number} width - Deprecated. Can be null.
    * @param {number} height - Deprecated. Can be null.
    * @param {string} text - The text to draw.
    * @param {boolean} wordWrap - If wordWrap is set to true, line-breaks are automatically created.
     */

    Component_MessageTextRenderer.prototype.drawFormattedText = function(x, y, width, height, text, wordWrap) {
      var currentX, ref;
      text = text || " ";
      this.font.set(this.object.font);
      this.speed = 11 - Math.round(GameManager.settings.messageSpeed * 2.5);
      this.isRunning = true;
      this.drawImmediately = false;
      this.lineAnimationCount = this.speed;
      this.currentLineHeight = 0;
      this.isWaiting = false;
      this.waitForKey = false;
      this.charIndex = 0;
      this.token = null;
      this.tokenIndex = 0;
      this.message = text;
      this.line = 0;
      this.currentLine = this.line;
      currentX = this.currentX;
      this.lines = this.calculateLines(lcsm(this.message), wordWrap, this.currentX);
      this.sprites = this.createSprites(this.lines);
      this.allSprites = this.allSprites.concat(this.sprites);
      this.currentX = currentX;
      this.currentSprite = this.sprites[this.line];
      this.currentSprite.x = this.currentX + this.object.origin.x + this.object.dstRect.x;
      this.maxLines = this.calculateMaxLines(this.lines);
      this.token = ((ref = this.lines[this.line]) != null ? ref.content[this.tokenIndex] : void 0) || new gs.RendererToken(null, "");
      return this.start();
    };


    /**
    * Starts the message-rendering process.
    *
    * @method start
    * @protected
     */

    Component_MessageTextRenderer.prototype.start = function() {
      var ref;
      if (GameManager.tempSettings.skip && GameManager.tempSettings.skipTime === 0) {
        return this.instantSkip();
      } else if (this.maxLines === 0) {
        if (((ref = this.lines[0]) != null ? ref.content : void 0) === "") {
          return this.finish();
        } else {
          this.maxLines = 1;
          return this.drawNext();
        }
      } else {
        return this.drawNext();
      }
    };


    /**
    * Skips the current message and finishes the message-processing immediately. The message
    * tokens are processed but not rendered.
    *
    * @method instantSkip
     */

    Component_MessageTextRenderer.prototype.instantSkip = function() {
      var ref;
      while (true) {
        if (this.line < this.maxLines) {
          this.nextChar();
        }
        if (this.line >= this.maxLines) {
          break;
        } else {
          this.processToken();
        }
        if (!(this.isRunning && this.line < this.maxLines)) {
          break;
        }
      }
      if ((ref = this.object.events) != null) {
        ref.emit("messageWaiting", this);
      }
      return this["continue"]();
    };


    /**
    * Processes the current token.
    *
    * @method processToken
     */

    Component_MessageTextRenderer.prototype.processToken = function() {
      var base, token;
      token = null;
      if (this.token.code != null) {
        token = this.processControlToken(this.token, false);
        if (token != null) {
          this.token = token;
          if (typeof (base = this.token).onStart === "function") {
            base.onStart();
          }
        }
      } else {
        token = this.token;
      }
      return token;
    };

    return Component_MessageTextRenderer;

  })(gs.Component_TextRenderer);

  gs.Component_MessageTextRenderer = Component_MessageTextRenderer;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* An enumeration of game message modes.
*
* ADV - Adventure Mode
* NVL - Novel Mode
*
* @typedef MessageMode
* @memberof vn
 */

(function() {
  var Component_MessageBehavior, MessageMode,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  MessageMode = (function() {
    function MessageMode() {}

    MessageMode.ADV = 0;

    MessageMode.NVL = 1;

    return MessageMode;

  })();

  vn.MessageMode = MessageMode;

  Component_MessageBehavior = (function(superClass) {
    extend(Component_MessageBehavior, superClass);

    Component_MessageBehavior.objectCodecBlackList = ["onMessageWaiting", "onMessageFinish"];


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_MessageBehavior.prototype.onDataBundleRestore = function(data, context) {
      this.tempSettings = GameManager.tempSettings;
      return this.setupEventHandlers();
    };


    /**
    * A behavior-component to define the behavior of a game-message.
    *
    * @module vn
    * @class Component_MessageBehavior
    * @extends gs.Component
    * @memberof vn
    * @constructor
     */

    function Component_MessageBehavior() {

      /**
      * Reference to temporary game settings.
      * @property settings
      * @type Object
      * @protected
       */
      this.tempSettings = GameManager.tempSettings;

      /**
      * Indicates if the message is currently waiting.
      * @property isWaiting
      * @type boolean
      * @readOnly
       */
      this.isWaiting = false;

      /**
      * Indicates if the message is currently running.
      * @property isRunning
      * @type boolean
      * @readOnly
       */
      this.isRunning = false;

      /**
      * Indicates if a voice is currently playing together with the message.
      * @property isVoicePlaying
      * @type boolean
      * @readOnly
       */
      this.isVoicePlaying = false;

      /**
      * Current message caret/cursor position.
      * @property caretPosition
      * @type gs.Point
      * @readOnly
       */
      this.caretPosition = new gs.Point(0, 0);

      /**
      * Current raw message text.
      * @property message
      * @type string
      * @readOnly
       */
      this.message = "";

      /**
      * All currently displayed raw messages.
      * @property messages
      * @type string[]
      * @readOnly
       */
      this.messages = [];

      /**
      * Voice associated with the current message.
      * @property voice
      * @type gs.AudioBufferReference
       */
      this.voice = null;

      /**
      * Indicates if current message is partial. DEPRECATED. Please do not use.
      * @property partial
      * @deprecated
      * @type boolean
      * @readOnly
       */
      this.partial = false;

      /**
      * Indicates if the message is currently waiting in live-preview.
      * @property waitingPreview
      * @type boolean
      * @readOnly
       */
      this.waitingPreview = false;

      /**
      * Indicates if the auto-message is enabled.
      * @property autoMessageEnabled
      * @type boolean
      * @readOnly
       */
      this.autoMessageEnabled = false;
      this.onMessageFinish = (function(_this) {
        return function(sender) {
          _this.object.events.emit("finish", _this);
          if (_this.object.settings.autoErase || _this.object.settings.paragraphSpacing > 0) {
            return _this.message = "";
          }
        };
      })(this);
      this.onMessageWaiting = (function(_this) {
        return function(sender) {
          if (!_this.object.textRenderer.isBatched() || !_this.object.textRenderer.isBatchInProgress()) {
            _this.object.textRenderer.waitAtEnd = !_this.partial;
            return _this.object.events.emit("waiting", _this);
          }
        };
      })(this);
    }


    /**
    * Reference to game settings.
    * @property settings
    * @type Object
    * @protected
     */

    Component_MessageBehavior.accessors("settings", {
      get: function() {
        return GameManager.settings;
      }

      /**
      * Adds event-handlers
      *
      * @method setupEventHandlers
       */
    });

    Component_MessageBehavior.prototype.setupEventHandlers = function() {
      this.object.events.offByOwner("messageFinish", this);
      this.object.events.offByOwner("messageWaiting", this);
      this.object.events.on("messageFinish", gs.CallBack("onMessageFinish", this), null, this);
      this.object.events.on("messageWaiting", gs.CallBack("onMessageWaiting", this), null, this);
      gs.GlobalEventManager.offByOwner("previewWaiting", this);
      gs.GlobalEventManager.offByOwner("previewRestart", this);
      gs.GlobalEventManager.on("previewWaiting", ((function(_this) {
        return function(sender) {
          return _this.waitingPreview = true;
        };
      })(this)), null, this);
      return gs.GlobalEventManager.on("previewRestart", ((function(_this) {
        return function(sender) {
          return _this.waitingPreview = false;
        };
      })(this)), null, this);
    };


    /**
    * Setup the component. Adds event handlers.
    *
    * @method setup
     */

    Component_MessageBehavior.prototype.setup = function() {
      return this.setupEventHandlers();
    };


    /**
    * Disposes the component.
    *
    * @method toDataBundle
     */

    Component_MessageBehavior.prototype.dispose = function() {
      Component_MessageBehavior.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("previewWaiting", this);
      return gs.GlobalEventManager.offByOwner("previewRestart", this);
    };


    /**
    * Not implemented yet.
    *
    * @method toDataBundle
     */

    Component_MessageBehavior.prototype.toDataBundle = function() {};


    /**
    * Not implemented yet.
    *
    * @method restore
    * @param {Object} bundle - A data bundle.
     */

    Component_MessageBehavior.prototype.restore = function(bundle) {};


    /**
    * Action to show a game message.
    *
    * @method showMessage
    * @param {Object} sender - The sender of this action.
    * @param {Object} params - An object containing the necessary parameters.
     */

    Component_MessageBehavior.prototype.showMessage = function(sender, params) {
      gs.GameNotifier.postContextChange(lcsm(params.message));
      this.partial = params.partial;
      this.message += lcsm(params.message);
      this.addMessage(params.message, RecordManager.characters[params.characterId], this.object.messages.length > 0 && this.object.settings.paragraphSpacing > 0, !this.partial);
      if (this.object.textRenderer.isBatched()) {
        return this.object.textRenderer.waitAtEnd = true;
      } else {
        return this.object.textRenderer.waitAtEnd = !this.partial;
      }
    };


    /**
    * Deprecated. Not longer used.
    *
    * @method updateBitmap
     */

    Component_MessageBehavior.prototype.updateBitmap = function() {
      var ref;
      if (!this.object.bitmap || this.object.bitmap.width !== this.object.dstRect.width || this.object.bitmap.height !== this.object.dstRect.height) {
        if ((ref = this.object.bitmap) != null) {
          ref.dispose();
        }
        this.object.bitmap = new Bitmap(this.object.dstRect.width, this.object.dstRect.height);
        return this.object.bitmap.font = this.object.font;
      }
    };


    /**
    * Restores a NVL game message of an array of message-objects. That is
    * necessary to restore a NVL game message from a save-game.
    *
    * @method restoreMessages
    * @param {Array} messages - An array of messages to restore.
     */

    Component_MessageBehavior.prototype.restoreMessages = function(messages) {
      var i, len, message, ref, ref1;
      this.updateBitmap();
      this.clear();
      this.object.opacity = 255;
      this.object.srcRect = new Rect(0, 0, this.object.dstRect.width, this.object.dstRect.height);
      for (i = 0, len = messages.length; i < len; i++) {
        message = messages[i];
        this.object.font.color = new Color(((ref = message.character) != null ? ref.textColor : void 0) || Color.WHITE);
        this.object.textRenderer.drawFormattedTextImmediately(0, 0, this.object.dstRect.width, this.object.dstRect.height, lcsm((ref1 = message.text) != null ? ref1 : message), true);
      }
      return null;
    };


    /**
    * Adds a new message.
    * 
    * @method addMessage
    * @param {string} message - The message.
    * @param {Object} character - Database-Record of a character.
    * @param {boolean} newLine - Indicates if the message should make a line break.
     */

    Component_MessageBehavior.prototype.addMessage = function(message, character, newLine, waitAtEnd) {
      this.object.textRenderer.partialMessage = null;
      this.object.offset = {
        x: 0,
        y: 0
      };
      this.object.visible = true;
      this.object.messages.push({
        text: message,
        character: character
      });
      this.object.textRenderer.waitAtEnd = waitAtEnd;
      if (!this.object.settings.autoErase) {
        this.object.textRenderer.currentY += this.object.settings.paragraphSpacing;
      }
      if (newLine) {
        this.object.textRenderer.newLine();
      }
      this.updateBitmap();
      if ((character != null) && this.object.settings.useCharacterColor) {
        this.object.font.color = new Color((character != null ? character.textColor : void 0) || Color.WHITE);
      }
      this.object.opacity = 255;
      this.object.srcRect = new Rect(0, 0, this.object.dstRect.width, this.object.dstRect.height);
      this.update();
      return this.object.textRenderer.drawFormattedText(0, 0, this.object.dstRect.width, this.object.dstRect.height, message, true);
    };


    /**
    * Clears the game message by deleting/clearing all messages.
    *
    * @method clear
     */

    Component_MessageBehavior.prototype.clear = function() {
      this.object.textRenderer.clear();
      this.object.messages = [];
      return this.message = "";
    };


    /**
    * Closes the game message by making it invisible.
    *
    * @method close
     */

    Component_MessageBehavior.prototype.close = function() {
      return this.object.visible = false;
    };


    /**
    * Gets the duration of an associated voice or 0 if no voice is associated.
    *
    * @method voiceDuration
    * @return {number} The duration in frames.
     */

    Component_MessageBehavior.prototype.voiceDuration = function() {
      var duration;
      duration = 0;
      if ((this.voice != null) && (this.settings.autoMessage.waitForVoice || this.settings.timeMessageToVoice)) {
        duration = Math.round((this.voice.source.buffer.duration * (1.0 / this.voice.source.playbackRate.value)) * 1000 / 16.6);
      } else {
        duration = 0;
      }
      if (this.tempSettings.skip) {
        return 1;
      } else {
        return duration;
      }
    };


    /**
    * Gets the duration of rendering the game-message.
    *
    * @method messageDuration
    * @return {number} The duration in frames.
     */

    Component_MessageBehavior.prototype.messageDuration = function() {
      var duration;
      duration = this.object.textRenderer.calculateDuration();
      if (this.tempSettings.skip) {
        return 1;
      } else {
        return duration;
      }
    };


    /**
    * Gets the time between two messages in auto-read mode.
    *
    * @method autoMessageTime
    * @return {number} The time in frames.
     */

    Component_MessageBehavior.prototype.autoMessageTime = function() {
      if (this.tempSettings.skip) {
        return 1;
      } else {
        return Math.max(Math.round(this.settings.autoMessage.time * Graphics.frameRate), this.voiceDuration() - this.messageDuration());
      }
    };


    /**
    * Gets the current message speed.
    *
    * @method messageSpeed
    * @return {number} The message speed.
     */

    Component_MessageBehavior.prototype.messageSpeed = function() {
      return Math.max(11 - Math.round(GameManager.settings.messageSpeed * 2.5), 0);
    };


    /**
    * Checks if a mouse-button or key was pressed to continue with the message-rendering.
    *
    * @method actionTrigger
    * @return {boolean} If true, the an action-button or action-key is pressed.
     */

    Component_MessageBehavior.prototype.actionTrigger = function() {
      return (gs.ObjectManager.current.input && this.object.visible && this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y) && Input.Mouse.buttons[Input.Mouse.LEFT] === 2) || Input.trigger(Input.C);
    };

    Component_MessageBehavior.prototype.finish = function() {
      if ((this.object.voice != null) && GameManager.settings.skipVoiceOnAction) {
        return AudioManager.stopSound(this.object.voice.name);
      }
    };

    Component_MessageBehavior.prototype.erase = function() {
      var duration, fading;
      fading = GameManager.tempSettings.messageFading;
      duration = GameManager.tempSettings.skip ? 0 : fading.duration;
      return this.object.animator.disappear(fading.animation, fading.easing, duration, (function(_this) {
        return function() {
          SceneManager.scene.currentCharacter = {
            name: ""
          };
          _this.clear();
          return _this.object.visible = false;
        };
      })(this));
    };


    /**
    * FIXME: Deprecated? It is also a re-definition of gs.Component_Visual.updateOrigin.
    *
    * @method updateOrigin
     */

    Component_MessageBehavior.prototype.updateOrigin = function() {
      var ox, oy, p;
      ox = 0;
      oy = 0;
      if ((this.object.parent != null) && (this.object.parent.dstRect != null)) {
        p = this.object.parent;
        while ((p != null) && (p.dstRect != null)) {
          ox += p.dstRect.x;
          oy += p.dstRect.y;
          p = p.parent;
        }
      }
      this.object.origin.x = ox;
      return this.object.origin.y = oy;
    };


    /**
    * Updates the object. 
    *
    * @method updateObject
    * @private
     */

    Component_MessageBehavior.prototype.updateObject = function() {
      this.updateOrigin();
      if (this.tempSettings.skip && !this.waitingPreview) {
        return this.object.textRenderer.isWaiting = false;
      }
    };


    /**
    * Updates the message.
    *
    * @method updateMessage
    * @private
     */

    Component_MessageBehavior.prototype.updateMessage = function() {
      var ref;
      this.caretPosition = this.object.textRenderer.caretPosition;
      if (this.tempSettings.skip && (this.settings.allowSkipUnreadMessages || ((ref = GameManager.globalData.messages[this.message]) != null ? ref.read : void 0))) {
        this.object.textRenderer.drawImmediately = true;
        this.object.textRenderer.waitAtEnd = this.waitingPreview;
        return this.object.textRenderer.waitAtEndTime = 0;
      } else {
        this.updateSpeed();
        return this.updateAutoMessage();
      }
    };


    /**
    * Updates the speed of the message. That depends on game-settings if a message
    * is timed to its voice or not.
    *
    * @method updateSpeed
    * @private
     */

    Component_MessageBehavior.prototype.updateSpeed = function() {
      var voiceDuration;
      voiceDuration = this.voiceDuration();
      if (voiceDuration > 0 && this.settings.timeMessageToVoice) {
        return this.object.textRenderer.speed = voiceDuration / this.message.length;
      } else {
        return this.object.textRenderer.speed = this.messageSpeed();
      }
    };


    /**
    * Update auto-read mode.
    *
    * @method updateAutoMessage
    * @private
     */

    Component_MessageBehavior.prototype.updateAutoMessage = function() {
      if (this.settings.autoMessage.stopOnAction && this.actionTrigger()) {
        this.settings.autoMessage.enabled = false;
      }
      if (this.settings.autoMessage.enabled && !this.partial) {
        if (this.object.textRenderer.waitAtEnd) {
          this.object.textRenderer.isWaiting = false;
        }
        this.object.textRenderer.waitAtEndTime = this.autoMessageTime();
        this.object.textRenderer.waitAtEnd = false;
      } else if (this.autoMessageEnabled !== this.settings.autoMessage.enabled) {
        this.object.textRenderer.waitAtEnd = true;
        this.object.textRenderer.waitAtEndTime = 0;
      }
      return this.autoMessageEnabled = this.settings.autoMessage.enabled;
    };


    /*
    * Updates the game message behavior
    *
    * @method update
     */

    Component_MessageBehavior.prototype.update = function() {
      var ref, ref1, ref2, ref3, ref4, ref5;
      this.object.needsUpdate = true;
      this.updateObject();
      this.updateMessage();
      if (this.character !== this.object.character) {
        gs.GlobalEventManager.emit("talkingEnded", this, {
          character: this.character
        });
        this.character = this.object.character;
      }
      if (this.object.textRenderer.isWaiting !== this.isWaiting || this.object.textRenderer.isRunning !== this.isRunning || (((ref = this.voice) != null ? ref.playing : void 0) && (!((ref1 = this.object.character) != null ? ref1.timeTalkingToVoiceVolume : void 0) || this.voice.averageVolume > this.object.character.talkingVolume)) !== this.isVoicePlaying) {
        this.isWaiting = this.object.textRenderer.isWaiting;
        this.isRunning = this.object.textRenderer.isRunning;
        this.isVoicePlaying = ((ref2 = this.voice) != null ? ref2.playing : void 0) && (!((ref3 = this.object.character) != null ? ref3.timeTalkingToVoiceVolume : void 0) || this.voice.averageVolume > this.object.character.talkingVolume);
        if (!this.tempSettings.skip) {
          if ((ref4 = this.voice) != null ? ref4.playing : void 0) {
            if (!this.isVoicePlaying) {
              gs.GlobalEventManager.emit("talkingEnded", this, {
                character: this.object.character
              });
            } else {
              gs.GlobalEventManager.emit("talkingStarted", this, {
                character: this.object.character
              });
            }
          } else {
            if (this.isWaiting) {
              gs.GlobalEventManager.emit("talkingEnded", this, {
                character: this.object.character
              });
            } else if (this.isRunning) {
              gs.GlobalEventManager.emit("talkingStarted", this, {
                character: this.object.character
              });
            }
          }
        }
      }
      if ((this.object.layoutRect != null) && (((ref5 = this.object.parent) != null ? ref5.dstRect : void 0) != null)) {
        if (this.object.layoutRect.x) {
          this.object.dstRect.x = this.object.layoutRect.x(this.object.parent.dstRect.width);
        }
        if (this.object.layoutRect.y) {
          this.object.dstRect.y = this.object.layoutRect.y(this.object.parent.dstRect.height);
        }
        if (this.object.layoutRect.width) {
          this.object.dstRect.width = this.object.layoutRect.width(this.object.parent.dstRect.width);
        }
        if (this.object.layoutRect.height) {
          return this.object.dstRect.height = this.object.layoutRect.height(this.object.parent.dstRect.height);
        }
      }
    };

    return Component_MessageBehavior;

  })(gs.Component);

  vn.Component_MessageBehavior = Component_MessageBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Animator,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Animator = (function(superClass) {
    extend(Component_Animator, superClass);


    /**
    * An animator-component allows to execute different kind of animations 
    * on a game object. The animations are using the game object's 
    * dstRect & offset-property to execute.
    *
    * @module gs
    * @class Component_Animator
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_Animator() {
      Component_Animator.__super__.constructor.apply(this, arguments);
      this.moveAnimation = new gs.Component_MoveAnimation();
      this.pathAnimation = new gs.Component_PathAnimation();
      this.zoomAnimation = new gs.Component_ZoomAnimation();
      this.blendAnimation = new gs.Component_BlendAnimation();
      this.blurAnimation = new gs.Component_BlurAnimation();
      this.pixelateAnimation = new gs.Component_PixelateAnimation();
      this.wobbleAnimation = new gs.Component_WobbleAnimation();
      this.colorAnimation = new gs.Component_ColorAnimation();
      this.imageAnimation = new gs.Component_ImageAnimation();
      this.frameAnimation = new gs.Component_FrameAnimation();
      this.fieldAnimation = new gs.Component_FieldAnimation();
      this.shakeAnimation = new gs.Component_ShakeAnimation();
      this.tintAnimation = new gs.Component_TintAnimation();
      this.rotateAnimation = new gs.Component_RotateAnimation();
      this.maskAnimation = new gs.Component_MaskAnimation();
      this.l2dAnimation = new gs.Component_Live2DAnimation();

      /**
      * Standard Callback Routine
      * @property callback
      * @type function
      * @private
       */
      this.callback = function(object, animation) {
        return object.removeComponent(animation);
      };
      this.onBlendFinish = function(object, animation, callback) {
        object.removeComponent(animation);
        return typeof callback === "function" ? callback(object) : void 0;
      };
    }

    Component_Animator.accessors("isAnimating", {
      get: function() {
        return this.object;
      }

      /**
      * Updates the animator.
      *
      * @method update
       */
    });

    Component_Animator.prototype.update = function() {
      var ref, ref1;
      Component_Animator.__super__.update.apply(this, arguments);
      if (((ref = this.object.mask) != null ? (ref1 = ref.source) != null ? ref1.videoElement : void 0 : void 0) != null) {
        return this.object.mask.source.update();
      }
    };


    /**
    * Moves the game object with a specified speed.
    *
    * @method move
    * @param {number} speedX The speed on x-axis in pixels per frame.
    * @param {number} speedY The speed on y-axis in pixels per frame.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type used for the animation.
     */

    Component_Animator.prototype.move = function(speedX, speedY, duration, easingType) {
      this.object.addComponent(this.moveAnimation);
      this.moveAnimation.move(speedX, speedY, duration, easingType, this.callback);
      return this.moveAnimation;
    };


    /**
    * Moves the game object to a specified position.
    *
    * @method moveTo
    * @param {number} x The x-coordinate of the position.
    * @param {number} y The y-coordinate of the position.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.moveTo = function(x, y, duration, easingType) {
      this.object.addComponent(this.moveAnimation);
      this.moveAnimation.moveTo(x, y, duration, easingType, this.callback);
      return this.moveAnimation;
    };


    /**
    * Moves the game object along a path.
    *
    * @method movePath
    * @param {Object} path The path to follow.
    * @param {gs.AnimationLoopType} loopType The loop-Type.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {Object[]} effects Optional array of effects executed during the path-movement like playing a sound.
     */

    Component_Animator.prototype.movePath = function(path, loopType, duration, easingType, effects) {
      var c;
      c = this.object.findComponent("Component_PathAnimation");
      if (c != null) {
        c.loopType = loopType;
      } else {
        this.object.addComponent(this.pathAnimation);
        this.pathAnimation.start(path, loopType, duration, easingType, effects, this.callback);
      }
      return this.pathAnimation;
    };


    /**
    * Scrolls the game object with a specified speed.
    *
    * @method scroll
    * @param {number} speedX The speed on x-axis in pixels per frame.
    * @param {number} speedY The speed on y-axis in pixels per frame.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type used for the animation.
     */

    Component_Animator.prototype.scroll = function(speedX, speedY, duration, easingType) {
      this.object.addComponent(this.moveAnimation);
      this.moveAnimation.scroll(speedX, speedY, duration, easingType, this.callback);
      return this.moveAnimation;
    };


    /**
    * Scrolls the game object to a specified position.
    *
    * @method scrollTo
    * @param {number} x The x-coordinate of the position.
    * @param {number} y The y-coordinate of the position.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.scrollTo = function(x, y, duration, easingType) {
      this.object.addComponent(this.moveAnimation);
      this.moveAnimation.scrollTo(x, y, duration, easingType, this.callback);
      return this.moveAnimation;
    };


    /**
    * Scrolls the game object along a path.
    *
    * @method scrollPath
    * @param {Object} path The path to follow.
    * @param {gs.AnimationLoopType} loopType The loop-Type.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.scrollPath = function(path, loopType, duration, easingType) {
      this.object.addComponent(this.pathAnimation);
      this.pathAnimation.scroll(path, loopType, duration, easingType, this.callback);
      return this.pathAnimation;
    };


    /**
    * Zooms a game object to specified size.
    *
    * @method zoomTo
    * @param {number} x The x-axis zoom-factor.
    * @param {number} y The y-axis zoom-factor.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.zoomTo = function(x, y, duration, easingType) {
      this.object.addComponent(this.zoomAnimation);
      this.zoomAnimation.start(x, y, duration, easingType, this.callback);
      return this.zoomAnimation;
    };


    /**
    * Blends a game object to specified opacity.
    *
    * @method blendTo
    * @param {number} opacity The target opacity.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback called if blending is finished.
     */

    Component_Animator.prototype.blendTo = function(opacity, duration, easingType, callback) {
      this.blendAnimation.stop();
      this.object.addComponent(this.blendAnimation);
      this.blendAnimation.start(opacity, duration, easingType, gs.CallBack("onBlendFinish", this, callback));
      return this.blendAnimation;
    };


    /**
    * Animates a Live2D model parameter of a Live2D game object to a specified value.
    *
    * @method blendTo
    * @param {string} param The name of the parameter to animate.
    * @param {number} value The target value.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback called if blending is finished.
     */

    Component_Animator.prototype.l2dParameterTo = function(param, value, duration, easingType, callback) {
      this.object.addComponent(this.l2dAnimation);
      this.l2dAnimation.start(param, value, duration, easingType, gs.CallBack("onBlendFinish", this, callback));
      return this.l2dAnimation;
    };


    /**
    * Blurs a game object to specified blur-power.
    *
    * @method blurTo
    * @param {number} power The target blur-power.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.blurTo = function(power, duration, easingType) {
      this.object.addComponent(this.blurAnimation);
      this.blurAnimation.start(power, duration, easingType);
      return this.blurAnimation;
    };


    /**
    * Pixelates a game object to specified pixel-size/block-size
    *
    * @method pixelateTo
    * @param {number} width - The target block-width
    * @param {number} height - The target block-height
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.pixelateTo = function(width, height, duration, easingType) {
      this.object.addComponent(this.pixelateAnimation);
      this.pixelateAnimation.start(width, height, duration, easingType);
      return this.pixelateAnimation;
    };


    /**
    * Wobbles a game object to specified wobble-power and wobble-speed.
    *
    * @method wobbleTo
    * @param {number} power The target wobble-power.
    * @param {number} speed The target wobble-speed.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.wobbleTo = function(power, speed, duration, easingType) {
      this.object.addComponent(this.wobbleAnimation);
      this.wobbleAnimation.start(power, speed, duration, easingType);
      return this.wobbleAnimation;
    };


    /**
    * Colors a game object to a specified target color.
    *
    * @method colorTo
    * @param {Color} color The target color.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.colorTo = function(color, duration, easingType) {
      this.object.addComponent(this.colorAnimation);
      this.colorAnimation.start(color, duration, easingType, this.callback);
      return this.colorAnimation;
    };


    /**
    * An image animation runs from left to right using the game object's
    * image-property.
    *
    * @method changeImages
    * @param {Array} images An array of image names.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.changeImages = function(images, duration, easingType) {
      this.object.addComponent(this.imageAnimation);
      this.imageAnimation.start(images, duration, easingType, this.callback);
      return this.imageAnimation;
    };


    /**
    * A frame animation which modifies the game object's srcRect property
    * a play an animation.
    *
    * @method changeFrames
    * @param {gs.Rect[]} frames An array of source rectangles (frames).
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */


    /**
    * A frame animation which modifies the game object's srcRect property
    * a play an animation.
    *
    * @method playAnimation
    * @param {gs.Rect[]} frames An array of source rectangles (frames).
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.playAnimation = function(animationRecord) {
      this.frameAnimation.refresh(animationRecord);
      this.object.addComponent(this.frameAnimation);
      this.frameAnimation.start(this.callback);
      return this.frameAnimation;
    };


    /**
    * Changes a field of the game object to a specified value.
    *
    * @method change
    * @param {number} Value The target value.
    * @param {string} field The name of the field/property.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.change = function(value, field, duration, easingType) {
      this.object.addComponent(this.fieldAnimation);
      this.fieldAnimation.start(value, field, duration, easingType, this.callback);
      return this.fieldAnimation;
    };


    /**
    * Shakes the game object horizontally using the game object's offset-property.
    *
    * @method shake
    * @param {gs.Range} range The horizontal shake-range.
    * @param {number} speed The shake speed.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.shake = function(range, speed, duration, easing) {
      this.object.addComponent(this.shakeAnimation);
      this.shakeAnimation.start(range, speed, duration, easing, this.callback);
      return this.shakeAnimation;
    };


    /**
    * Tints the game object to a specified tone.
    *
    * @method tintTo
    * @param {Tone} tone The target tone.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.tintTo = function(tone, duration, easingType) {
      this.object.addComponent(this.tintAnimation);
      this.tintAnimation.start(tone, duration, easingType, this.callback);
      return this.tintAnimation;
    };


    /**
    * Rotates the game object around its anchor-point.
    *
    * @method rotate
    * @param {gs.RotationDirection} direction The rotation-direction.
    * @param {number} speed The rotation speed in degrees per frame.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.rotate = function(direction, speed, duration, easingType) {
      this.object.addComponent(this.rotateAnimation);
      this.rotateAnimation.rotate(direction, speed, duration, easingType, this.callback);
      return this.rotateAnimation;
    };


    /**
    * Rotates the game object around its anchor-point to a specified angle.
    *
    * @method rotateTo
    * @param {number} angle The target angle.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
     */

    Component_Animator.prototype.rotateTo = function(angle, duration, easingType) {
      this.object.addComponent(this.rotateAnimation);
      this.rotateAnimation.rotateTo(angle, duration, easingType, this.callback);
      return this.rotateAnimation;
    };


    /**
    * Lets a game object appear on screen using a masking-effect.
    *
    * @method maskIn
    * @param {gs.Mask} mask The mask used for the animation.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.maskIn = function(mask, duration, easing, callback) {
      this.object.addComponent(this.maskAnimation);
      this.maskAnimation.maskIn(mask, duration, easing, function(object, animation) {
        object.removeComponent(animation);
        return typeof callback === "function" ? callback(object) : void 0;
      });
      return this.maskAnimation;
    };


    /**
    * Description follows...
    *
    * @method maskTo
    * @param {gs.Mask} mask The mask used for the animation.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.maskTo = function(mask, duration, easing, callback) {
      this.object.addComponent(this.maskAnimation);
      this.maskAnimation.maskTo(mask, duration, easing, function(object, animation) {
        object.removeComponent(animation);
        return typeof callback === "function" ? callback(object) : void 0;
      });
      return this.maskAnimation;
    };


    /**
    * Lets a game object disappear from screen using a masking-effect.
    *
    * @method maskOut
    * @param {gs.Mask} mask The mask used for the animation.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.maskOut = function(mask, duration, easing, callback) {
      this.object.addComponent(this.maskAnimation);
      this.maskAnimation.maskOut(mask, duration, easing, function(object, animation) {
        object.removeComponent(animation);
        return typeof callback === "function" ? callback(object) : void 0;
      });
      return this.maskAnimation;
    };


    /**
    * Lets a game object appear on screen from left, top, right or bottom using 
    * a move-animation
    *
    * @method moveIn
    * @param {number} x The x-coordinate of the target-position.
    * @param {number} y The y-coordinate of the target-position.
    * @param {number} type The movement-direction from where the game object should move-in.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.moveIn = function(x, y, type, duration, easing, callback) {
      this.object.addComponent(this.moveAnimation);
      this.moveAnimation.moveIn(x, y, type, duration, easing, function(object, animation) {
        object.removeComponent(animation);
        return typeof callback === "function" ? callback(object) : void 0;
      });
      return this.moveAnimation;
    };


    /**
    * Lets a game object disappear from screen to the left, top, right or bottom using 
    * a move-animation
    *
    * @method moveOut
    * @param {number} type The movement-direction in which the game object should move-out.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.moveOut = function(type, duration, easing, callback) {
      this.object.addComponent(this.moveAnimation);
      this.moveAnimation.moveOut(type, duration, easing, function(object, animation) {
        object.removeComponent(animation);
        return typeof callback === "function" ? callback(object) : void 0;
      });
      return this.moveAnimation;
    };


    /**
    * Lets a game object appear on screen using blending.
    *
    * @method show
    * @param {number} duration The duration in frames.
    * @param {Object} easing The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.show = function(duration, easing, callback) {
      var ref;
      this.object.opacity = 0;
      if ((ref = this.object.visual) != null) {
        ref.update();
      }
      return this.blendTo(255, duration, easing, callback);
    };


    /**
    * Lets a game object disappear from screen using blending.
    *
    * @method hide
    * @param {number} duration The duration in frames.
    * @param {Object} easing The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.hide = function(duration, easing, callback) {
      return this.blendTo(0, duration, easing, callback);
    };


    /**
    * Changes visible-property to true. This method is deprecated.
    * 
    * @method open
    * @deprecated
     */

    Component_Animator.prototype.open = function() {
      return this.object.visible = true;
    };


    /**
    * Changes visible-property to false. This method is deprecated.
    * 
    * @method close
    * @deprecated
     */

    Component_Animator.prototype.close = function() {
      return this.object.visible = false;
    };


    /**
    * Flashes the game object.
    *
    * @method flash
    * @param {Color} color The flash-color.
    * @param {number} duration The duration in frames.
     */

    Component_Animator.prototype.flash = function(color, duration) {
      this.object.color = color;
      color = new Color(color);
      color.alpha = 0;
      return this.colorTo(color, duration, gs.Easings.EASE_LINEAR[gs.EasingTypes.EASE_IN]);
    };


    /**
    * Lets a game object appear on screen using a specified animation.
    *
    * @method appear
    * @param {number} x The x-coordinate of the target-position.
    * @param {number} y The y-coordinate of the target-position.
    * @param {gs.AppearAnimationInfo} animation The animation info-object.
    * @param {Object} easing The easing-type.
    * @param {number} duration The duration in frames.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.appear = function(x, y, animation, easing, duration, callback) {
      easing = easing || gs.Easings.EASE_LINEAR[gs.EasingTypes.EASE_IN];
      this.object.visible = true;
      if (animation.type === gs.AnimationTypes.MOVEMENT) {
        return this.moveIn(x, y, animation.movement, duration, easing, callback);
      } else if (animation.type === gs.AnimationTypes.MASKING) {
        return this.maskIn(animation.mask, duration, easing, callback);
      } else {
        return this.show(duration, easing, callback);
      }
    };


    /**
    * Lets a game object disappear from screen using a specified animation.
    *
    * @method disappear
    * @param {gs.AppearAnimationInfo} animation The animation info-object.
    * @param {Object} easing The easing-type.
    * @param {number} duration The duration in frames.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_Animator.prototype.disappear = function(animation, easing, duration, callback) {
      this.object.visible = true;
      if (animation.type === gs.AnimationTypes.MOVEMENT) {
        return this.moveOut(animation.movement, duration, easing, callback);
      } else if (animation.type === gs.AnimationTypes.MASKING) {
        return this.maskOut(animation.mask, duration, easing, callback);
      } else {
        return this.hide(duration, easing, callback);
      }
    };

    return Component_Animator;

  })(gs.Component);

  gs.Animator = Component_Animator;

  gs.Component_Animator = Component_Animator;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Live2D,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Live2D = (function(superClass) {
    extend(Component_Live2D, superClass);


    /**
    * A Live2D component which allows a game-object to become a animated
    * Live2D character.
    *
    * @module vn
    * @class Component_Live2D
    * @extends gs.Component
    * @memberof vn
    * @constructor
     */

    function Component_Live2D() {
      Component_Live2D.__super__.constructor.apply(this, arguments);

      /**
      * The Live2D graphics object.
      * @property l2dObject
      * @type gs.Live2DObject
      * @readOnly
       */
      this.l2dObject = null;

      /**
      * The character's Live2D motion. Set name-property to an empty string
      * to disable motion and use a generated default idle-motion.
      * @property motion
      * @type gs.Live2DMotion
      * @default { name: "", loop: yes }
       */
      this.motion = {
        name: "",
        loop: true

        /**
        * The character's Live2D motion-group. Can be null
        * @property motionGroup
        * @type gs.Live2DMotionGroup
        * @default null
         */
      };
      this.motionGroup = null;

      /**
      * The character's Live2D expression. Set name-property to an empty string
      * to use default expression.
      * @property expression
      * @type gs.Live2DExpression
      * @default { name: "" }
       */
      this.expression = {
        name: ""

        /**
        * @property talkingDuration
        * @type number
        * @protected
         */
      };
      this.talkingDuration = 1;

      /**
      * @property talkingStep
      * @type number
      * @protected
       */
      this.talkingStep = 0;

      /**
      * @property talkingStep
      * @type number[]
      * @protected
       */
      this.talkingSteps = [0, 0.5, 1];
    }


    /**
    * Disposes the component and Live2D object.
    *
    * @method dispose
     */

    Component_Live2D.prototype.dispose = function() {
      Component_Live2D.__super__.dispose.apply(this, arguments);
      return this.l2dObject.dispose();
    };


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_Live2D.prototype.onDataBundleRestore = function(data, context) {
      this.expression = {
        name: ""
      };
      this.motion = {
        name: "",
        loop: true
      };
      this.motionGroup = null;
      this.updateMotion();
      this.updateExpression();
      return this.updateMotionGroup();
    };


    /**
    * Setup the Live2D component. This method is automatically called by the
    * system.
    * @method setup
     */

    Component_Live2D.prototype.setup = function() {
      return this.l2dObject = new gs.Live2DObject();
    };


    /**
    * Updates the character's Live2D motion.
    *
    * @method updateMotion
     */

    Component_Live2D.prototype.updateMotion = function() {
      if (this.motion !== this.object.motion) {
        this.motion = this.object.motion;
        if (this.motion.name) {
          this.l2dObject.playMotion(this.motion.name, this.motion.fadeInTime);
          return this.l2dObject.loopMotion = this.motion.loop;
        }
      }
    };


    /**
    * Updates the character's Live2D motion-group.
    *
    * @method updateMotionGroup
     */

    Component_Live2D.prototype.updateMotionGroup = function() {
      var ref;
      if (this.motionGroup !== this.object.motionGroup) {
        this.motionGroup = this.object.motionGroup;
        if ((ref = this.motionGroup) != null ? ref.name : void 0) {
          this.l2dObject.playMotionGroup(this.motionGroup.name, this.motionGroup.playType);
          return this.l2dObject.loopMotion = this.motionGroup.loop;
        }
      }
    };


    /**
    * Updates the character's Live2D expression.
    *
    * @method updateExpression
     */

    Component_Live2D.prototype.updateExpression = function() {
      if (this.expression.name !== this.object.expression.name) {
        this.expression = this.object.expression;
        return this.l2dObject.setExpression(this.expression.name, this.expression.fadeInTime);
      }
    };


    /**
    * Updates the Live2D object properties from the game object properties.
    *
    * @method updateProperties
     */

    Component_Live2D.prototype.updateProperties = function() {
      this.l2dObject.model = this.object.model;
      this.object.dstRect.width = this.l2dObject.width;
      this.object.dstRect.height = this.l2dObject.height;
      this.l2dObject.x = this.object.dstRect.x + this.object.offset.x;
      this.l2dObject.y = this.object.dstRect.y + this.object.offset.y;
      this.l2dObject.z = this.object.zIndex;
      this.l2dObject.visible = this.object.visible;
      this.l2dObject.opacity = this.object.opacity;
      this.l2dObject.zoomX = this.object.zoom.x;
      this.l2dObject.zoomY = this.object.zoom.y;
      this.l2dObject.anchor.x = this.object.anchor.x;
      this.l2dObject.anchor.y = this.object.anchor.y;
      this.l2dObject.angle = this.object.angle;
      this.l2dObject.tone = this.object.tone;
      return this.l2dObject.color = this.object.color;
    };


    /**
    * Updates the optional Live2D object properties from the game object properties.
    *
    * @method updateOptionalProperties
     */

    Component_Live2D.prototype.updateOptionalProperties = function() {
      if (this.object.viewport != null) {
        this.l2dObject.viewport = this.object.viewport;
      }
      if (this.object.effects != null) {
        return this.l2dObject.effects = this.object.effects;
      }
    };


    /**
    * Updates the Live2D object and its talking-animation.
    *
    * @method update
     */

    Component_Live2D.prototype.update = function() {
      if ((this.object.model != null) && !this.object.model.initialized) {
        this.object.model.initialize();
      }
      this.updateProperties();
      this.updateMotion();
      this.updateMotionGroup();
      this.updateExpression();
      this.updateOptionalProperties();
      return this.updateTalking();
    };


    /**
    * Updates the Live2D character's talking-animation.
    *
    * @method update
     */

    Component_Live2D.prototype.updateTalking = function() {
      var step;
      step = 0;
      if (this.object.talking) {
        this.l2dObject.talking = true;
        if (AudioManager.voice != null) {
          return this.l2dObject.talkingVolume = (AudioManager.voice.averageVolume || 0) / 100;
        } else {
          this.talkingDuration--;
          if (this.talkingDuration <= 0) {
            while (this.talkingStep === step) {
              step = Math.round(Math.random() * 2);
            }
            this.talkingDuration = 5;
            this.talkingStep = step;
            return this.l2dObject.talkingVolume = this.talkingSteps[step];
          }
        }
      } else {
        return this.l2dObject.talking = false;
      }
    };

    return Component_Live2D;

  })(gs.Component);

  vn.Component_Live2D = Component_Live2D;

  gs.Component_Live2D = Component_Live2D;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_EventEmitter,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_EventEmitter = (function(superClass) {
    extend(Component_EventEmitter, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    *
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_EventEmitter.prototype.onDataBundleRestore = function(data, context) {
      var handler, handlers, i, j, k, l, list, ref;
      for (k in this.handlers) {
        list = this.handlers[k];
        for (i = l = 0, ref = list.length; 0 <= ref ? l < ref : l > ref; i = 0 <= ref ? ++l : --l) {
          handlers = list[i];
          j = 0;
          while (j < handlers.length) {
            handler = handlers[j];
            if (!handler.handler || !handler.handler.$vnm_cb) {
              handlers.splice(j, 1);
            } else {
              j++;
            }
          }
        }
      }
      return null;
    };


    /**
    * A component which allow a game object to fire events and manage a list
    * of observers.
    *
    * @module gs
    * @class Component_EventEmitter
    * @extends gs.Component
    * @memberof gs
     */

    function Component_EventEmitter() {
      Component_EventEmitter.__super__.constructor.apply(this, arguments);

      /**
      * List of registered observers.
      *
      * @property handlers
      * @type Object
      * @private
       */
      this.handlers = {};

      /**
      * @property defaultData
      * @type Object
      * @private
       */
      this.defaultData = {};

      /**
      * @property chainInfo
      * @type Object
      * @private
       */
      this.chainInfo = {};

      /**
      * @property needsSort
      * @type boolean
      * @private
       */
      this.needsSort = {};

      /**
      * @property markedForRemove
      * @type Object[]
      * @private
       */
      this.markedForRemove = [];

      /**
      * @property isEmitting
      * @type number
      * @private
       */
      this.isEmitting = 0;
    }


    /**
    * Clears the event emitter by removing all handlers/listeners.
    *
    * @method clear
     */

    Component_EventEmitter.prototype.clear = function() {
      this.needsSort = {};
      this.handlers = {};
      return this.defaultData = {};
    };


    /**
    * Clears the event emitter by removing all handlers/listeners except those
    * which are associated with an owner in the specified owners array.
    *
    * @method clearExcept
    * @param {Object[]} owners - An array of owner objects. Only handlers/listeners which are not
    * associated with that owners are removed.
     */

    Component_EventEmitter.prototype.clearExcept = function(owners) {
      var event, events, handlerList, handlers, i, l, len, results;
      this.needsSort = {};
      this.defaultData = {};
      events = Object.keys(this.handlers);
      results = [];
      for (l = 0, len = events.length; l < len; l++) {
        event = events[l];
        handlers = this.handlers[event];
        results.push((function() {
          var len1, m, results1;
          results1 = [];
          for (i = m = 0, len1 = handlers.length; m < len1; i = ++m) {
            handlerList = handlers[i];
            handlerList = handlerList.filter(function(h) {
              return owners.indexOf(h.owner) !== 1;
            });
            results1.push(handlers[i] = handlerList);
          }
          return results1;
        })());
      }
      return results;
    };


    /**
    * Adds a new observer/listener for a specified event.
    *
    * @method on
    * @param {string} eventName - The event name.
    * @param {function} handler - The handler-function called when the event is fired.
    * @param {Object} [data={}] - An optional info-object passed to the handler-function.
    * @param {Object} [owner=null] - An optional owner-object associated with the observer/listener.
    * @param {number} priority - An optional priority level. An observer/listener with a higher level will receive the event before observers/listeners with a lower level.
    * @return {gs.EventObserver} - The added observer-object.
     */

    Component_EventEmitter.prototype.on = function(eventName, handler, data, owner, priority) {
      var handlerObject;
      priority = priority || 0;
      this.needsSort[eventName] = true;
      if (this.handlers[eventName] == null) {
        this.handlers[eventName] = [];
      }
      if (!this.handlers[eventName][priority]) {
        this.handlers[eventName][priority] = [];
      }
      handlerObject = {
        handler: handler,
        once: false,
        data: data,
        owner: owner,
        eventName: eventName,
        priority: priority
      };
      this.handlers[eventName][priority].push(handlerObject);
      return handlerObject;
    };


    /**
    * Adds a new observer/listener for a specified event and removes it
    * after the even has been emitted once.
    *
    * @method once
    * @param {string} eventName - The event name.
    * @param {function} handler - The handler-function called when the event is fired.
    * @param {Object} [data={}] - An optional info-object passed to the handler-function.
    * @param {Object} [owner=null] - An optional owner-object associated with the observer/listener.
    * @param {number} priority - An optional priority level. An observer/listener with a higher level will receive the event before observers/listeners with a lower level.
    * @return {gs.EventObserver} - The added observer-object.
     */

    Component_EventEmitter.prototype.once = function(eventName, handler, data, owner, priority) {
      var handlerObject;
      handlerObject = this.on(eventName, handler, data, owner, priority);
      handlerObject.once = true;
      return handlerObject;
    };


    /**
    * Removes an observer/listener from a specified event. If handler parameter
    * is null, all observers for the specified event are removed.
    *
    * @method off
    * @param {string} eventName - The event name.
    * @param {gs.EventObserver} [handler=null] - The observer-object to remove.
    * If null, all observers for the specified event are removed.
     */

    Component_EventEmitter.prototype.off = function(eventName, handler) {
      var ref, ref1;
      if (this.isEmitting > 0 && handler) {
        return this.markedForRemove.push(handler);
      } else if (handler != null) {
        return (ref = this.handlers[eventName]) != null ? (ref1 = ref[handler.priority]) != null ? ref1.remove(handler) : void 0 : void 0;
      } else {
        return this.handlers[eventName] = [];
      }
    };


    /**
    * Removes all observers/listeners from an event which are belonging to the specified
    * owner.
    *
    * @method offByOwner
    * @param {string} eventName - The event name.
    * @param {Object} owner - The owner.
    * @return {number} Count of removed observers/listeners.
     */

    Component_EventEmitter.prototype.offByOwner = function(eventName, owner) {
      var handler, handlerList, handlers, l, len, len1, m, ref, ref1, results, results1;
      if (this.handlers[eventName]) {
        if (this.isEmitting > 0) {
          ref = this.handlers[eventName];
          results = [];
          for (l = 0, len = ref.length; l < len; l++) {
            handlerList = ref[l];
            handlers = handlerList != null ? handlerList.where(function(x) {
              return x.owner === owner;
            }) : void 0;
            results.push((function() {
              var len1, m, results1;
              results1 = [];
              for (m = 0, len1 = handlers.length; m < len1; m++) {
                handler = handlers[m];
                results1.push(this.markedForRemove.push(handler));
              }
              return results1;
            }).call(this));
          }
          return results;
        } else {
          ref1 = this.handlers[eventName];
          results1 = [];
          for (m = 0, len1 = ref1.length; m < len1; m++) {
            handlerList = ref1[m];
            results1.push(handlerList.removeAll(function(x) {
              return x.owner === owner;
            }));
          }
          return results1;
        }
      }
    };


    /**
    * Emits the specified event. All observers/listeners registered for the
    * specified event are informed.
    *
    * @method emit
    * @param {string} eventName - The name of the event to fire.
    * @param {Object} [sender=null] - The sender of the event.
    * @param {Object} [data={}] - An optional object passed to each handler-function.
     */

    Component_EventEmitter.prototype.emit = function(eventName, sender, data) {
      var breakOwner, count, handler, handlerList, handlerLists, i, l, len, len1, m, n, ref;
      handlerLists = this.handlers[eventName];
      data = data != null ? data : {};
      if (handlerLists && this.needsSort[eventName]) {
        this.needsSort[eventName] = false;
        for (l = 0, len = handlerLists.length; l < len; l++) {
          handlerList = handlerLists[l];
          handlerList.sort(function(a, b) {
            if (a.owner && b.owner) {
              if (a.owner.rIndex > b.owner.rIndex) {
                return -1;
              } else if (a.owner.rIndex < b.owner.rIndex) {
                return 1;
              } else {
                return 0;
              }
            } else {
              return -1;
            }
          });
        }
      }
      if (handlerLists != null) {
        breakOwner = null;
        for (m = handlerLists.length - 1; m >= 0; m += -1) {
          handlerList = handlerLists[m];
          if (!handlerList) {
            continue;
          }
          i = 0;
          count = handlerList.length;
          this.isEmitting++;
          while (i < count) {
            handler = handlerList[i];
            data.handler = handler;
            data.sender = sender;
            data.data = handler.data;
            if ((!breakOwner && (!handler.owner || (handler.owner.visible == null) || handler.owner.visible)) || breakOwner === handler.owner) {
              handler.handler(data);
            }
            if (handler.once) {
              this.markedForRemove.push(handler);
            }
            if (data.breakChain) {
              breakOwner = handler.owner;
            }
            i++;
          }
          this.isEmitting--;
          if (data.breakChain) {
            data.breakChain = false;
            break;
          }
        }
        if (!this.isEmitting && this.markedForRemove.length > 0) {
          ref = this.markedForRemove;
          for (n = 0, len1 = ref.length; n < len1; n++) {
            handler = ref[n];
            this.handlers[handler.eventName][handler.priority].remove(handler);
          }
          this.markedForRemove = [];
        }
      }
      return null;
    };


    /**
    * Checks if an event-handler with a specified owner exists for the
    * given event.
    *
    * @method checkForOwner
    * @param {string} eventName - The event name.
    * @param {function} owner - The owner to search for.
    * @return {boolean} If <b>true</b>, an event-handler with the specified owner
    * exists for the given event. Otherwise <b>false</b>.
     */

    Component_EventEmitter.prototype.checkForOwner = function(eventName, owner) {
      var handler, l, len, ref, result;
      result = false;
      ref = this.handlers[eventName];
      for (l = 0, len = ref.length; l < len; l++) {
        handler = ref[l];
        if (handler.owner === owner) {
          result = true;
          break;
        }
      }
      return result;
    };


    /**
    * Checks if an event-handler with a specified handler-function exists for the
    * given event.
    *
    * @method checkForHandlerFunction
    * @param {string} eventName - The event name.
    * @param {function} handlerFunction - The handler-function to search for.
    * @return {boolean} If true, an observer witht he specified handler-function
    * exists for the given event. Otherwise false.
     */

    Component_EventEmitter.prototype.checkForHandlerFunction = function(eventName, handlerFunction) {
      var handler, l, len, ref, result;
      result = false;
      if (handlerFunction != null) {
        ref = this.handlers[eventName];
        for (l = 0, len = ref.length; l < len; l++) {
          handler = ref[l];
          if (handler.handler === handlerFunction) {
            result = true;
            break;
          }
        }
      }
      return result;
    };


    /**
    * Not implemented yet.
    * @method update
     */

    Component_EventEmitter.prototype.update = function() {
      return this.object.active = this.object.active && (!this.object.parent || this.object.parent.active);
    };

    return Component_EventEmitter;

  })(gs.Component);

  gs.Component_EventEmitter = Component_EventEmitter;

  gs.EventEmitter = Component_EventEmitter;

  gs.GlobalEventManager = new Component_EventEmitter();

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_CharacterBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_CharacterBehavior = (function(superClass) {
    extend(Component_CharacterBehavior, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    *
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_CharacterBehavior.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * A behavior-component which handles the character-specific behavior like
    * talking and idle.
    *
    * @module vn
    * @class Component_CharacterBehavior
    * @extends gs.Component
    * @memberof vn
    * @constructor
     */

    function Component_CharacterBehavior() {
      Component_CharacterBehavior.__super__.constructor.apply(this, arguments);

      /**
      * @property imageIndex
      * @type number
      * @private
       */
      this.imageIndex = 0;

      /**
      * @property imageDuration
      * @type number
      * @private
       */
      this.imageDuration = 30;

      /**
      * @property idleTime
      * @type number
      * @private
       */
      this.idleTime = 120 + 120 * Math.random();

      /**
      * Indicates if the character is currently talking.
      * @property talking
      * @type boolean
       */
      this.talking = false;

      /**
      * @property initialized
      * @type boolean
      * @private
       */
      this.initialized = false;

      /**
      * Temporary game settings used by this character.
      * @property imageIndex
      * @type number
       */
      this.tempSettings = GameManager.tempSettings;
    }


    /**
    * Adds event-handlers
    *
    * @method setupEventHandlers
     */

    Component_CharacterBehavior.prototype.setupEventHandlers = function() {
      gs.GlobalEventManager.on("talkingStarted", (function(_this) {
        return function(e) {
          var ref;
          if (((ref = e.character) != null ? ref.index : void 0) === _this.object.rid) {
            _this.object.talking = true;
            return _this.imageIndex = 0;
          }
        };
      })(this));
      return gs.GlobalEventManager.on("talkingEnded", (function(_this) {
        return function(e) {
          var ref;
          if (((ref = e.character) != null ? ref.index : void 0) === _this.object.rid) {
            _this.object.talking = false;
            return _this.imageIndex = 0;
          }
        };
      })(this));
    };


    /**
    * Initializes the component. Adds event-handlers.
    *
    * @method setup
     */

    Component_CharacterBehavior.prototype.setup = function() {
      this.initialized = true;
      this.setupEventHandlers();
      return this.update();
    };


    /**
    * Changes the characters expression using blending. If the duration is set
    * to 0 the expression change is executed immediately without animation.
    *
    * @method changeExpression
    * @param {vn.CharacterExpression} expression - The character expression database-record.
    * @param {number} duration - The animation-duration in frames. Pass 0 to skip animation.
    * @param {function} [callback] An optional callback-function called when the change is finished.
     */

    Component_CharacterBehavior.prototype.changeExpression = function(expression, animation, easing, duration, callback) {
      var picture, prevExpression, ref;
      prevExpression = this.object.expression;
      this.object.expression = expression;
      if ((prevExpression != null ? (ref = prevExpression.idle) != null ? ref.length : void 0 : void 0) > 0 && (this.object.expression != null) && prevExpression !== this.object.expression) {
        this.imageIndex = 0;
        picture = new gs.Object_Picture();
        picture.imageFolder = "Graphics/Characters";
        picture.image = prevExpression.idle[0].resource.name;
        picture.update();
        picture.anchor.x = this.object.anchor.x;
        picture.anchor.y = this.object.anchor.y;
        picture.dstRect.x = this.object.dstRect.x + Math.round((this.object.dstRect.width - picture.dstRect.width) / 2);
        picture.dstRect.y = this.object.dstRect.y + Math.round((this.object.dstRect.height - picture.dstRect.height) / 2);
        picture.zIndex = this.object.zIndex - 1;
        picture.zoom.x = this.object.zoom.x;
        picture.zoom.y = this.object.zoom.y;
        picture.update();
        this.object.parent.addObject(picture);
        switch (animation.fading) {
          case 0:
            this.object.animator.appear(this.object.dstRect.x, this.object.dstRect.y, animation, easing, duration, function() {
              picture.dispose();
              return typeof callback === "function" ? callback() : void 0;
            });
            return this.object.update();
          case 1:
            picture.animator.disappear(animation, easing, duration, function(object) {
              return object.dispose();
            });
            picture.update();
            this.object.animator.appear(this.object.dstRect.x, this.object.dstRect.y, animation, easing, duration, function(object) {
              return typeof callback === "function" ? callback() : void 0;
            });
            return this.object.update();
        }
      } else {
        return typeof callback === "function" ? callback() : void 0;
      }
    };


    /**
    * Lets the character start talking.
    *
    * @method startTalking
     */

    Component_CharacterBehavior.prototype.startTalking = function() {
      return this.object.talking = true;
    };


    /**
    * Lets the character stop with talking.
    *
    * @method stopTalking
     */

    Component_CharacterBehavior.prototype.stopTalking = function() {
      return this.object.talking = false;
    };


    /**
    * Updates character's talking-animation.
    *
    * @method updateTalking
    * @protected
     */

    Component_CharacterBehavior.prototype.updateTalking = function() {
      var imageIndex, ref, ref1, speed;
      if (this.tempSettings.skip && ((ref = this.object.expression.talking) != null ? ref.length : void 0) > 0) {
        this.object.talking = false;
        this.imageIndex = 0;
        return this.object.image = this.object.expression.talking[this.imageIndex].resource.name;
      } else if (this.object.expression != null) {
        if (((ref1 = this.object.expression.talking) != null ? ref1.length : void 0) > 0) {
          this.imageDuration--;
          if (this.imageDuration <= 0) {
            imageIndex = this.imageIndex;
            while (imageIndex === this.imageIndex && this.object.expression.talking.length > 1) {
              this.imageIndex = Math.round(Math.random() * (this.object.expression.talking.length - 1));
            }
            speed = this.object.expression.talkingSpeed / 100 * 5;
            this.imageDuration = speed + Math.round(speed * Math.random());
          }
          return this.object.image = this.object.expression.talking[this.imageIndex].resource.name;
        } else {
          return this.updateIdle();
        }
      }
    };


    /**
    * Updates character's idle-animation.
    *
    * @method updateIdle
    * @protected
     */

    Component_CharacterBehavior.prototype.updateIdle = function() {
      var ref;
      if ((this.object.expression != null) && ((ref = this.object.expression.idle) != null ? ref.length : void 0) > 0) {
        if (this.imageDuration <= 0) {
          this.idleTime--;
          if (this.idleTime <= 0) {
            this.idleTime = this.object.expression.idleTime.start + (this.object.expression.idleTime.end - this.object.expression.idleTime.start) * Math.random();
            this.imageDuration = this.object.expression.idleSpeed / 100 * 5;
          }
        }
        if (this.imageDuration > 0) {
          this.imageDuration--;
          if (this.imageDuration <= 0) {
            this.imageIndex++;
            if (this.imageIndex >= this.object.expression.idle.length) {
              this.imageIndex = 0;
              this.imageDuration = 0;
            } else {
              this.imageDuration = this.object.expression.idleSpeed / 100 * 5;
            }
          }
        }
        return this.object.image = this.object.expression.idle[this.imageIndex].resource.name;
      }
    };


    /**
    * Updates character logic & animation-handling.
    *
    * @method update
     */

    Component_CharacterBehavior.prototype.update = function() {
      Component_CharacterBehavior.__super__.update.apply(this, arguments);
      if (!this.initialized) {
        this.setup();
      }
      if (this.object.talking) {
        return this.updateTalking();
      } else {
        return this.updateIdle();
      }
    };

    return Component_CharacterBehavior;

  })(gs.Component);

  vn.Component_CharacterBehavior = Component_CharacterBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_CommonEventBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_CommonEventBehavior = (function(superClass) {
    extend(Component_CommonEventBehavior, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_CommonEventBehavior.prototype.onDataBundleRestore = function(data, context) {
      var ref;
      if (this.object.rid != null) {
        this.object.record = RecordManager.commonEvents[this.object.rid];
        if ((ref = this.object.interpreter) != null) {
          ref.object = this;
        }
        this.object.commands = this.object.record.commands;
      }
      return this.setupEventHandlers();
    };


    /**
    * A component which allows a game object to execute common-events.
    *
    * @module gs
    * @class Component_CommonEventBehavior
    * @extends gs.Component
    * @memberof gs
     */

    function Component_CommonEventBehavior() {
      Component_CommonEventBehavior.__super__.constructor.call(this);

      /**
      * @property readyToStart
      * @type boolean
      * @private
       */
      this.readyToStart = false;

      /**
      * @property initialized
      * @type boolean
      * @private
       */
      this.initialized = false;
      this.callDepth = 0;
    }


    /**
    * Serializes the component into a data-bundle.
    *
    * @method toDataBundle
    * @return {Object} The data-bundle.
     */

    Component_CommonEventBehavior.prototype.toDataBundle = function() {
      return {
        initialized: this.initialized,
        readyToStart: this.readyToStart
      };
    };


    /**
    * Restores the component from a data-bundle
    *
    * @method restore
    * @param {Object} bundle- The data-bundle.
     */

    Component_CommonEventBehavior.prototype.restore = function(data) {
      this.setup();
      this.readyToStart = data.readyToStart;
      return this.initialized = data.initialized;
    };


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_CommonEventBehavior.prototype.setupEventHandlers = function() {
      if (!this.object.interpreter) {
        return;
      }
      if (this.object.record.startCondition === 1) {
        return this.object.interpreter.onFinish = (function(_this) {
          return function() {
            var ref;
            if (!_this.object.record.parallel) {
              return (ref = _this.object.events) != null ? ref.emit("finish", _this) : void 0;
            }
          };
        })(this);
      } else {
        if (this.object.record.parallel) {
          return this.object.interpreter.onFinish = (function(_this) {
            return function(sender) {
              return _this.object.removeComponent(sender);
            };
          })(this);
        } else {
          return this.object.interpreter.onFinish = (function(_this) {
            return function(sender) {
              return _this.object.events.emit("finish", _this);
            };
          })(this);
        }
      }
    };


    /**
    * Initializes the common-event.
    *
    * @method setup
     */

    Component_CommonEventBehavior.prototype.setup = function() {
      GameManager.variableStore.setupLocalVariables(this.object.record);
      this.object.record.parameters = this.object.record.parameters != null ? this.object.record.parameters : [];
      this.object.record.startCondition = this.object.record.startCondition != null ? this.object.record.startCondition : 0;
      this.object.record.parallel = this.object.record.parallel != null ? this.object.record.parallel : false;
      this.object.record.conditionSwitch = this.object.record.conditionSwitch != null ? this.object.record.conditionSwitch : null;
      this.object.record.conditionEnabled = this.object.record.conditionEnabled;
      if (this.object.record.startCondition === 1) {
        this.object.interpreter = new gs.Component_CommandInterpreter();
        this.object.interpreter.onFinish = (function(_this) {
          return function() {
            var ref;
            if (!_this.object.record.parallel) {
              return (ref = _this.object.events) != null ? ref.emit("finish", _this) : void 0;
            } else {
              return _this.restart();
            }
          };
        })(this);
        this.object.interpreter.context.set(this.object.record.index, this.object.record);
        this.object.addComponent(this.object.interpreter);
      }
      return this.initialized = true;
    };


    /**
    * Starts the common-event interpreter with the specified parameters.
    * 
    * @method start
    * @param {Object} parameters The common-event's parameters which can be configured in database.
     */

    Component_CommonEventBehavior.prototype.start = function(parameters) {
      var ref, ref1;
      this.startParameters = parameters;
      if ((this.object.interpreter != null) && !this.object.interpreter.isRunning) {
        this.object.commands = this.object.record.commands;
        this.readyToStart = true;
        if ((ref = this.object.events) != null) {
          ref.emit("start", this);
        }
      }
      if (this.object.record.startCondition === 0 && this.object.record.parallel) {
        return (ref1 = this.object.events) != null ? ref1.emit("finish", this) : void 0;
      }
    };


    /**
    * Initializes variable-store with the start-up parameters configured for the
    * common-event in Database.
    *
    * @method setupParameters
     */

    Component_CommonEventBehavior.prototype.setupParameters = function(parameters, parentContext) {
      var i, j, parameter, ref, results, value;
      if ((parameters != null) && (parameters.values != null)) {
        results = [];
        for (i = j = 0, ref = parameters.values.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
          value = parameters.values[i];
          parameter = this.object.record.parameters[i];
          if ((parameter != null) && (value != null)) {
            GameManager.variableStore.setupTempVariables(parentContext);
            switch (parameter.type) {
              case 1:
                value = GameManager.variableStore.numberValueOf(value);
                GameManager.variableStore.setupTempVariables(this.object.interpreter.context);
                results.push(GameManager.variableStore.setNumberValueTo(parameter.numberVariable, value));
                break;
              case 2:
                value = GameManager.variableStore.booleanValueOf(value);
                GameManager.variableStore.setupTempVariables(this.object.interpreter.context);
                results.push(GameManager.variableStore.setBooleanValueTo(parameter.booleanVariable, value));
                break;
              case 3:
                value = GameManager.variableStore.stringValueOf(value);
                GameManager.variableStore.setupTempVariables(this.object.interpreter.context);
                results.push(GameManager.variableStore.setStringValueTo(parameter.stringVariable, value));
                break;
              default:
                results.push(void 0);
            }
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };


    /**
    * Calls the common-event with the specified parameters.
    *
    * @method call
    * @param {Object} parameters The common-event's parameters which can be configured in database.
     */

    Component_CommonEventBehavior.prototype.call = function(parameters, settings, parentContext) {
      var interpreter;
      if (!this.object.record.singleInstance) {
        interpreter = new gs.Component_CommandInterpreter();
        interpreter.context.set(this.object.record.index + "_" + this.callDepth, this.object.record);
        GameManager.variableStore.clearTempVariables(interpreter.context);
        this.object.commands = this.object.record.commands;
        this.callDepth++;
      } else {
        interpreter = this.object.interpreter || new gs.Component_CommandInterpreter();
        interpreter.context.set(this.object.record.index, this.object.record);
        this.object.commands = this.object.record.commands;
      }
      interpreter.repeat = false;
      interpreter.object = this.object;
      if (settings) {
        interpreter.settings = settings;
      }
      this.object.interpreter = interpreter;
      GameManager.variableStore.setupTempVariables(interpreter.context);
      this.setupParameters(parameters, parentContext);
      if (this.object.record.parallel) {
        interpreter.onFinish = (function(_this) {
          return function(sender) {
            _this.object.removeComponent(sender);
            if (!_this.object.record.singleInstance) {
              return _this.callDepth--;
            }
          };
        })(this);
        interpreter.start();
        this.object.addComponent(interpreter);
        return null;
      } else {
        interpreter.onFinish = (function(_this) {
          return function(sender) {
            return _this.object.events.emit("finish", _this);
          };
        })(this);
        return interpreter;
      }
    };


    /**
    * Stops the common-event interpreter.
    *
    * @method stop
     */

    Component_CommonEventBehavior.prototype.stop = function() {
      var ref;
      if (this.object.interpreter != null) {
        this.object.interpreter.stop();
        return (ref = this.object.events) != null ? ref.emit("finish", this) : void 0;
      }
    };


    /**
    * Resumes a paused common-event interpreter.
    *
    * @method resume
     */

    Component_CommonEventBehavior.prototype.resume = function() {
      var ref, ref1;
      if (this.object.interpreter != null) {
        this.object.interpreter.resume();
        if ((ref = this.object.events) != null) {
          ref.emit("start", this);
        }
        return (ref1 = this.object.events) != null ? ref1.emit("resume", this) : void 0;
      }
    };


    /**
    * Restarts the common event. If the common event has a condition then the restart
    * will only happen if that condition is true.
    *
    * @method restart
     */

    Component_CommonEventBehavior.prototype.restart = function() {
      if (this.object.record.conditionEnabled) {
        if (GameManager.variableStore.booleanValueOf(this.object.record.conditionSwitch)) {
          return this.start();
        }
      } else {
        return this.start();
      }
    };


    /**
    * Restarts the common event if it is parallel and the conditions are met.
    *
    * @method restartIfNecessary
     */

    Component_CommonEventBehavior.prototype.restartIfNecessary = function() {
      if ((this.object.interpreter != null) && this.object.record.startCondition === 1 && !this.object.interpreter.isRunning) {
        return this.restart();
      }
    };


    /**
    * Updates the common-event interpreter.
    *
    * @method update
     */

    Component_CommonEventBehavior.prototype.update = function() {
      if (!this.initialized) {
        this.setup();
      }
      if ((this.object.interpreter != null) && this.readyToStart) {
        this.readyToStart = false;
        this.setupParameters(this.startParameters);
        this.object.interpreter.start();
      }
      return this.restartIfNecessary();
    };


    /**
    * Not implemented yet.
    *
    * @method erase
     */

    Component_CommonEventBehavior.prototype.erase = function() {};

    return Component_CommonEventBehavior;

  })(gs.Component);

  gs.Component_CommonEventBehavior = Component_CommonEventBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_CommandInterpreter, InterpreterContext, LivePreviewInfo,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  LivePreviewInfo = (function() {

    /**
    * Stores internal preview-info if the game runs currently in Live-Preview.
    *
    * @module gs
    * @class LivePreviewInfo
    * @memberof gs
     */
    function LivePreviewInfo() {

      /**
      * Timer ID if a timeout for live-preview was configured to exit the game loop after a certain amount of time.
      * @property timeout
      * @type number
       */
      this.timeout = null;

      /**
      * Indicates if Live-Preview is currently waiting for the next user-action. (Selecting another command, etc.)
      * @property waiting
      * @type boolean
       */
      this.waiting = false;

      /**
      * Counts the amount of executed commands since the last
      * interpreter-pause(waiting, etc.). If its more than 500, the interpreter will automatically pause for 1 frame to
      * avoid that Live-Preview freezes the Editor in case of endless loops.
      * @property executedCommands
      * @type number
       */
      this.executedCommands = 0;

      /**
      * Indicates that the command to skip to has not been found.
      * @property commandNotFound
      * @type boolean
       */
      this.commandNotFound = false;
    }

    return LivePreviewInfo;

  })();

  gs.LivePreviewInfo = LivePreviewInfo;

  InterpreterContext = (function() {
    InterpreterContext.objectCodecBlackList = ["owner"];


    /**
    * Describes an interpreter-context which holds information about
    * the interpreter's owner and also unique ID used for accessing correct
    * local variables.
    *
    * @module gs
    * @class InterpreterContext
    * @memberof gs
    * @param {number|string} id - A unique ID
    * @param {Object} owner - The owner of the interpreter
     */

    function InterpreterContext(id, owner) {

      /**
      * A unique numeric or textual ID used for accessing correct local variables.
      * @property id
      * @type number|string
       */
      this.id = id;

      /**
      * The owner of the interpreter (e.g. current scene, etc.).
      * @property owner
      * @type Object
       */
      this.owner = owner;
    }


    /**
    * Sets the context's data.
    * @param {number|string} id - A unique ID
    * @param {Object} owner - The owner of the interpreter
    * @method set
     */

    InterpreterContext.prototype.set = function(id, owner) {
      this.id = id;
      return this.owner = owner;
    };

    return InterpreterContext;

  })();

  gs.InterpreterContext = InterpreterContext;

  Component_CommandInterpreter = (function(superClass) {
    extend(Component_CommandInterpreter, superClass);

    Component_CommandInterpreter.objectCodecBlackList = ["object", "command", "onMessageADVWaiting", "onMessageADVDisappear", "onMessageADVFinish"];


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    *
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_CommandInterpreter.prototype.onDataBundleRestore = function(data, context) {};


    /**
    * A component which allows a game object to process commands like for
    * scene-objects. For each command a command-function exists. To add
    * own custom commands to the interpreter just create a sub-class and
    * override the gs.Component_CommandInterpreter.assignCommand method
    * and assign the command-function for your custom-command.
    *
    * @module gs
    * @class Component_CommandInterpreter
    * @extends gs.Component
    * @memberof gs
     */

    function Component_CommandInterpreter() {
      Component_CommandInterpreter.__super__.constructor.call(this);

      /**
      * Wait-Counter in frames. If greater than 0, the interpreter will for that amount of frames before continue.
      * @property waitCounter
      * @type number
       */
      this.waitCounter = 0;

      /**
      * Index to the next command to execute.
      * @property pointer
      * @type number
       */
      this.pointer = 0;

      /**
      * Stores states of conditions.
      * @property conditions
      * @type number
      * @protected
       */
      this.conditions = [];

      /**
      * Stores states of loops.
      * @property loops
      * @type number
      * @protected
       */
      this.loops = [];
      this.timers = [];

      /**
      * Indicates if the interpreter is currently running.
      * @property isRunning
      * @type boolean
      * @readOnly
       */
      this.isRunning = false;

      /**
      * Indicates if the interpreter is currently waiting.
      * @property isWaiting
      * @type boolean
       */
      this.isWaiting = false;

      /**
      * Indicates if the interpreter is currently waiting until a message processed by another context like a Common Event
      * is finished.
      * FIXME: Conflict handling can be removed maybe.
      * @property isWaitingForMessage
      * @type boolean
       */
      this.isWaitingForMessage = false;

      /**
      * Stores internal preview-info if the game runs currently in Live-Preview.
      * <ul>
      * <li>previewInfo.timeout - Timer ID if a timeout for live-preview was configured to exit the game loop after a certain amount of time.</li>
      * <li>previewInfo.waiting - Indicates if Live-Preview is currently waiting for the next user-action. (Selecting another command, etc.)</li>
      * <li>previewInfo.executedCommands - Counts the amount of executed commands since the last
      * interpreter-pause(waiting, etc.). If its more than 500, the interpreter will automatically pause for 1 frame to
      * avoid that Live-Preview freezes the Editor in case of endless loops.</li>
      * </ul>
      * @property previewInfo
      * @type boolean
      * @protected
       */
      this.previewInfo = new gs.LivePreviewInfo();

      /**
      * Stores Live-Preview related info passed from the VN Maker editor like the command-index the player clicked on, etc.
      * @property previewData
      * @type Object
      * @protected
       */
      this.previewData = null;

      /**
      * Indicates if the interpreter automatically repeats execution after the last command was executed.
      * @property repeat
      * @type boolean
       */
      this.repeat = false;

      /**
      * The execution context of the interpreter.
      * @property context
      * @type gs.InterpreterContext
      * @protected
       */
      this.context = new gs.InterpreterContext(0, null);

      /**
      * Sub-Interpreter from a Common Event Call. The interpreter will wait until the sub-interpreter is done and set back to
      * <b>null</b>.
      * @property subInterpreter
      * @type gs.Component_CommandInterpreter
      * @protected
       */
      this.subInterpreter = null;

      /**
      * Current indent-level of execution
      * @property indent
      * @type number
      * @protected
       */
      this.indent = 0;

      /**
      * Stores information about for what the interpreter is currently waiting for like for a ADV message, etc. to
      * restore probably when loaded from a save-game.
      * @property waitingFor
      * @type Object
      * @protected
       */
      this.waitingFor = {};

      /**
      * Stores interpreter related settings like how to handle messages, etc.
      * @property settings
      * @type Object
      * @protected
       */
      this.settings = {
        message: {
          byId: {},
          autoErase: true,
          waitAtEnd: true,
          backlog: true
        },
        screen: {
          pan: new gs.Point(0, 0)
        }
      };

      /**
      * Mapping table to quickly get the anchor point for the an inserted anchor-point constant such as
      * Top-Left(0), Top(1), Top-Right(2) and so on.
      * @property graphicAnchorPointsByConstant
      * @type gs.Point[]
      * @protected
       */
      this.graphicAnchorPointsByConstant = [new gs.Point(0.0, 0.0), new gs.Point(0.5, 0.0), new gs.Point(1.0, 0.0), new gs.Point(1.0, 0.5), new gs.Point(1.0, 1.0), new gs.Point(0.5, 1.0), new gs.Point(0.0, 1.0), new gs.Point(0.0, 0.5), new gs.Point(0.5, 0.5)];
    }

    Component_CommandInterpreter.prototype.onHotspotClick = function(e, data) {
      return this.executeAction(data.params.actions.onClick, false, data.bindValue);
    };

    Component_CommandInterpreter.prototype.onHotspotEnter = function(e, data) {
      return this.executeAction(data.params.actions.onEnter, true, data.bindValue);
    };

    Component_CommandInterpreter.prototype.onHotspotLeave = function(e, data) {
      return this.executeAction(data.params.actions.onLeave, false, data.bindValue);
    };

    Component_CommandInterpreter.prototype.onHotspotDragStart = function(e, data) {
      return this.executeAction(data.params.actions.onDrag, true, data.bindValue);
    };

    Component_CommandInterpreter.prototype.onHotspotDrag = function(e, data) {
      return this.executeAction(data.params.actions.onDrag, true, data.bindValue);
    };

    Component_CommandInterpreter.prototype.onHotspotDragEnd = function(e, data) {
      return this.executeAction(data.params.actions.onDrag, false, data.bindValue);
    };

    Component_CommandInterpreter.prototype.onHotspotDrop = function(e, data) {
      this.executeAction(data.params.actions.onDrop, false, data.bindValue);
      return gs.GlobalEventManager.emit("hotspotDrop", e.sender);
    };

    Component_CommandInterpreter.prototype.onHotspotDropReceived = function(e, data) {
      return this.executeAction(data.params.actions.onDropReceive, true, data.bindValue);
    };

    Component_CommandInterpreter.prototype.onHotspotStateChanged = function(e, params) {
      if (e.sender.behavior.selected) {
        return this.executeAction(params.actions.onSelect, true);
      } else {
        return this.executeAction(params.actions.onDeselect, false);
      }
    };


    /**
    * Called when a ADV message finished rendering and is now waiting
    * for the user/autom-message timer to proceed.
    *
    * @method onMessageADVWaiting
    * @return {Object} Event Object containing additional data.
    * @protected
     */

    Component_CommandInterpreter.prototype.onMessageADVWaiting = function(e) {
      var messageObject;
      messageObject = e.sender.object;
      if (!this.messageSettings().waitAtEnd) {
        if (e.data.params.waitForCompletion) {
          this.isWaiting = false;
        }
        messageObject.textRenderer.isWaiting = false;
        messageObject.textRenderer.isRunning = false;
      }
      messageObject.events.off("waiting", e.handler);
      if (this.messageSettings().backlog && (messageObject.settings.autoErase || messageObject.settings.paragraphSpacing > 0)) {
        return GameManager.backlog.push({
          character: messageObject.character,
          message: messageObject.behavior.message,
          choices: []
        });
      }
    };


    /**
    * Called when an ADV message finished fade-out.
    *
    * @method onMessageADVDisappear
    * @return {Object} Event Object containing additional data.
    * @protected
     */

    Component_CommandInterpreter.prototype.onMessageADVDisappear = function(messageObject, waitForCompletion) {
      SceneManager.scene.currentCharacter = {
        name: ""
      };
      messageObject.behavior.clear();
      messageObject.visible = false;
      if (messageObject.waitForCompletion) {
        this.isWaiting = false;
      }
      return this.waitingFor.messageADV = null;
    };


    /**
    * Called when an ADV message finished clear.
    *
    * @method onMessageADVClear
    * @return {Object} Event Object containing additional data.
    * @protected
     */

    Component_CommandInterpreter.prototype.onMessageADVClear = function(messageObject, waitForCompletion) {
      messageObject = this.targetMessage();
      if (this.messageSettings().backlog) {
        GameManager.backlog.push({
          character: messageObject.character,
          message: messageObject.behavior.message,
          choices: []
        });
      }
      return this.onMessageADVDisappear(messageObject, waitForCompletion);
    };


    /**
    * Called when a hotspot/image-map sends a "jumpTo" event to let the
    * interpreter jump to the position defined in the event object.
    *
    * @method onJumpTo
    * @return {Object} Event Object containing additional data.
    * @protected
     */

    Component_CommandInterpreter.prototype.onJumpTo = function(e) {
      this.jumpToLabel(e.label);
      return this.isWaiting = false;
    };


    /**
    * Called when a hotspot/image-map sends a "callCommonEvent" event to let the
    * interpreter call the common event defined in the event object.
    *
    * @method onJumpTo
    * @return {Object} Event Object containing additional data.
    * @protected
     */

    Component_CommandInterpreter.prototype.onCallCommonEvent = function(e) {
      var event, eventId, ref;
      eventId = e.commonEventId;
      event = RecordManager.commonEvents[eventId];
      if (!event) {
        event = RecordManager.commonEvents.first((function(_this) {
          return function(x) {
            return x.name === eventId;
          };
        })(this));
        if (event) {
          eventId = event.index;
        }
      }
      this.callCommonEvent(eventId, e.params || [], !e.finish);
      return this.isWaiting = (ref = e.waiting) != null ? ref : false;
    };


    /**
    * Called when a ADV message finishes.
    *
    * @method onMessageADVFinish
    * @return {Object} Event Object containing additional data.
    * @protected
     */

    Component_CommandInterpreter.prototype.onMessageADVFinish = function(e) {
      var commands, duration, fading, messageObject, pointer;
      messageObject = e.sender.object;
      if (!this.messageSettings().waitAtEnd) {
        return;
      }
      GameManager.globalData.messages[lcsm(e.data.params.message)] = {
        read: true
      };
      GameManager.saveGlobalData();
      if (e.data.params.waitForCompletion) {
        this.isWaiting = false;
      }
      this.waitingFor.messageADV = null;
      pointer = this.pointer;
      commands = this.object.commands;
      messageObject.events.off("finish", e.handler);
      if ((messageObject.voice != null) && GameManager.settings.skipVoiceOnAction) {
        AudioManager.stopSound(messageObject.voice.name);
      }
      if (!this.isMessageCommand(pointer, commands) && this.messageSettings().autoErase) {
        this.isWaiting = true;
        this.waitingFor.messageADV = e.data.params;
        fading = GameManager.tempSettings.messageFading;
        duration = GameManager.tempSettings.skip ? 0 : fading.duration;
        messageObject.waitForCompletion = e.data.params.waitForCompletion;
        return messageObject.animator.disappear(fading.animation, fading.easing, duration, gs.CallBack("onMessageADVDisappear", this, e.data.params.waitForCompletion));
      }
    };


    /**
    * Called when a common event finished execution. In most cases, the interpreter
    * will stop waiting and continue processing after this. But h
    *
    * @method onCommonEventFinish
    * @return {Object} Event Object containing additional data.
    * @protected
     */

    Component_CommandInterpreter.prototype.onCommonEventFinish = function(e) {
      var ref;
      SceneManager.scene.commonEventContainer.removeObject(e.sender.object);
      e.sender.object.events.off("finish");
      this.subInterpreter = null;
      return this.isWaiting = (ref = e.data.waiting) != null ? ref : false;
    };


    /**
    * Called when a scene call finished execution.
    *
    * @method onCallSceneFinish
    * @param {Object} sender - The sender of this event.
    * @protected
     */

    Component_CommandInterpreter.prototype.onCallSceneFinish = function(sender) {
      this.isWaiting = false;
      return this.subInterpreter = null;
    };


    /**
    * Serializes the interpreter into a data-bundle.
    *
    * @method toDataBundle
    * @return {Object} The data-bundle.
     */

    Component_CommandInterpreter.prototype.toDataBundle = function() {
      if (this.isInputDataCommand(Math.max(this.pointer - 1, 0), this.object.commands)) {
        return {
          pointer: Math.max(this.pointer - 1, 0),
          choice: this.choice,
          conditions: this.conditions,
          loops: this.loops,
          labels: this.labels,
          isWaiting: false,
          isRunning: this.isRunning,
          waitCounter: this.waitCounter,
          waitingFor: this.waitingFor,
          indent: this.indent,
          settings: this.settings
        };
      } else {
        return {
          pointer: this.pointer,
          choice: this.choice,
          conditions: this.conditions,
          loops: this.loops,
          labels: this.labels,
          isWaiting: this.isWaiting,
          isRunning: this.isRunning,
          waitCounter: this.waitCounter,
          waitingFor: this.waitingFor,
          indent: this.indent,
          settings: this.settings
        };
      }
    };


    /**
     * Previews the current scene at the specified pointer. This method is called from the
     * VN Maker Scene-Editor if live-preview is enabled and the user clicked on a command.
     *
     * @method preview
     */

    Component_CommandInterpreter.prototype.preview = function() {
      var ex, scene;
      try {
        if (!$PARAMS.preview || !$PARAMS.preview.scene) {
          return;
        }
        AudioManager.stopAllSounds();
        AudioManager.stopAllMusic();
        AudioManager.stopAllVoices();
        SceneManager.scene.choices = [];
        GameManager.setupCursor();
        this.previewData = $PARAMS.preview;
        gs.GlobalEventManager.emit("previewRestart");
        if (this.previewInfo.timeout) {
          clearTimeout(this.previewInfo.timeout);
        }
        if (Graphics.stopped) {
          Graphics.stopped = false;
          Graphics.onEachFrame(gs.Main.frameCallback);
        }
        scene = new vn.Object_Scene();
        scene.sceneData.uid = this.previewData.scene.uid;
        return SceneManager.switchTo(scene);
      } catch (error) {
        ex = error;
        return console.warn(ex);
      }
    };


    /**
     * Sets up the interpreter.
     *
     * @method setup
     */

    Component_CommandInterpreter.prototype.setup = function() {
      Component_CommandInterpreter.__super__.setup.apply(this, arguments);
      this.previewData = $PARAMS.preview;
      if (this.previewData) {
        return gs.GlobalEventManager.on("mouseDown", ((function(_this) {
          return function() {
            if (_this.previewInfo.waiting) {
              if (_this.previewInfo.timeout) {
                clearTimeout(_this.previewInfo.timeout);
              }
              _this.previewInfo.waiting = false;
              GameManager.tempSettings.skip = false;
              _this.previewData = null;
              return gs.GlobalEventManager.emit("previewRestart");
            }
          };
        })(this)), null, this.object);
      }
    };


    /**
     * Disposes the interpreter.
     *
     * @method dispose
     */

    Component_CommandInterpreter.prototype.dispose = function() {
      if (this.previewData) {
        gs.GlobalEventManager.offByOwner("mouseDown", this.object);
      }
      return Component_CommandInterpreter.__super__.dispose.apply(this, arguments);
    };

    Component_CommandInterpreter.prototype.isInstantSkip = function() {
      return GameManager.tempSettings.skip && GameManager.tempSettings.skipTime === 0;
    };


    /**
    * Restores the interpreter from a data-bundle
    *
    * @method restore
    * @param {Object} bundle- The data-bundle.
     */

    Component_CommandInterpreter.prototype.restore = function() {};


    /**
    * Gets the default game message for novel-mode.
    *
    * @method messageObjectNVL
    * @return {ui.Object_Message} The NVL game message object.
     */

    Component_CommandInterpreter.prototype.messageObjectNVL = function() {
      return gs.ObjectManager.current.objectById("nvlGameMessage_message");
    };


    /**
    * Gets the default game message for adventure-mode.
    *
    * @method messageObjectADV
    * @return {ui.Object_Message} The ADV game message object.
     */

    Component_CommandInterpreter.prototype.messageObjectADV = function() {
      return gs.ObjectManager.current.objectById("gameMessage_message");
    };


    /**
    * Starts the interpreter
    *
    * @method start
     */

    Component_CommandInterpreter.prototype.start = function() {
      this.conditions = [];
      this.loops = [];
      this.indent = 0;
      this.pointer = 0;
      this.isRunning = true;
      this.isWaiting = false;
      this.subInterpreter = null;
      return this.waitCounter = 0;
    };


    /**
    * Stops the interpreter
    *
    * @method stop
     */

    Component_CommandInterpreter.prototype.stop = function() {
      return this.isRunning = false;
    };


    /**
    * Resumes the interpreter
    *
    * @method resume
     */

    Component_CommandInterpreter.prototype.resume = function() {
      return this.isRunning = true;
    };


    /**
    * Updates the interpreter and executes all commands until the next wait is
    * triggered by a command. So in the case of an endless-loop the method will
    * never return.
    *
    * @method update
     */

    Component_CommandInterpreter.prototype.update = function() {
      if (this.subInterpreter != null) {
        this.subInterpreter.update();
        return;
      }
      GameManager.variableStore.setupTempVariables(this.context);
      if (((this.object.commands == null) || this.pointer >= this.object.commands.length) && !this.isWaiting) {
        if (this.repeat) {
          this.start();
        } else if (this.isRunning) {
          this.isRunning = false;
          if (this.onFinish != null) {
            this.onFinish(this);
          }
          return;
        }
      }
      if (!this.isRunning) {
        return;
      }
      if (!this.object.commands.optimized) {
        DataOptimizer.optimizeEventCommands(this.object.commands);
      }
      if (this.waitCounter > 0) {
        this.waitCounter--;
        this.isWaiting = this.waitCounter > 0;
        return;
      }
      if (this.isWaitingForMessage) {
        this.isWaiting = true;
        if (!this.isProcessingMessageInOtherContext()) {
          this.isWaiting = false;
          this.isWaitingForMessage = false;
        } else {
          return;
        }
      }
      if (GameManager.inLivePreview) {
        while (!(this.isWaiting || this.previewInfo.waiting) && this.pointer < this.object.commands.length && this.isRunning) {
          this.executeCommand(this.pointer);
          this.previewInfo.executedCommands++;
          if (this.previewInfo.executedCommands > 500) {
            this.previewInfo.executedCommands = 0;
            this.isWaiting = true;
            this.waitCounter = 1;
          }
        }
      } else {
        while (!(this.isWaiting || this.previewInfo.waiting) && this.pointer < this.object.commands.length && this.isRunning) {
          this.executeCommand(this.pointer);
        }
      }
      if (this.pointer >= this.object.commands.length && !this.isWaiting) {
        if (this.repeat) {
          return this.start();
        } else if (this.isRunning) {
          this.isRunning = false;
          if (this.onFinish != null) {
            return this.onFinish(this);
          }
        }
      }
    };


    /**
    * Assigns the correct command-function to the specified command-object if
    * necessary.
    *
    * @method assignCommand
     */

    Component_CommandInterpreter.prototype.assignCommand = function(command) {
      switch (command.id) {
        case "gs.Idle":
          return command.execute = this.commandIdle;
        case "gs.StartTimer":
          return command.execute = this.commandStartTimer;
        case "gs.PauseTimer":
          return command.execute = this.commandPauseTimer;
        case "gs.ResumeTimer":
          return command.execute = this.commandResumeTimer;
        case "gs.StopTimer":
          return command.execute = this.commandStopTimer;
        case "gs.WaitCommand":
          return command.execute = this.commandWait;
        case "gs.LoopCommand":
          return command.execute = this.commandLoop;
        case "gs.BreakLoopCommand":
          return command.execute = this.commandBreakLoop;
        case "gs.Comment":
          return command.execute = function() {
            return 0;
          };
        case "gs.EmptyCommand":
          return command.execute = function() {
            return 0;
          };
        case "gs.ListAdd":
          return command.execute = this.commandListAdd;
        case "gs.ListPop":
          return command.execute = this.commandListPop;
        case "gs.ListShift":
          return command.execute = this.commandListShift;
        case "gs.ListRemoveAt":
          return command.execute = this.commandListRemoveAt;
        case "gs.ListInsertAt":
          return command.execute = this.commandListInsertAt;
        case "gs.ListValueAt":
          return command.execute = this.commandListValueAt;
        case "gs.ListClear":
          return command.execute = this.commandListClear;
        case "gs.ListShuffle":
          return command.execute = this.commandListShuffle;
        case "gs.ListSort":
          return command.execute = this.commandListSort;
        case "gs.ListIndexOf":
          return command.execute = this.commandListIndexOf;
        case "gs.ListSet":
          return command.execute = this.commandListSet;
        case "gs.ListCopy":
          return command.execute = this.commandListCopy;
        case "gs.ListLength":
          return command.execute = this.commandListLength;
        case "gs.ListJoin":
          return command.execute = this.commandListJoin;
        case "gs.ListFromText":
          return command.execute = this.commandListFromText;
        case "gs.ResetVariables":
          return command.execute = this.commandResetVariables;
        case "gs.ChangeVariableDomain":
          return command.execute = this.commandChangeVariableDomain;
        case "gs.ChangeNumberVariables":
          return command.execute = this.commandChangeNumberVariables;
        case "gs.ChangeDecimalVariables":
          return command.execute = this.commandChangeDecimalVariables;
        case "gs.ChangeBooleanVariables":
          return command.execute = this.commandChangeBooleanVariables;
        case "gs.ChangeStringVariables":
          return command.execute = this.commandChangeStringVariables;
        case "gs.CheckSwitch":
          return command.execute = this.commandCheckSwitch;
        case "gs.CheckNumberVariable":
          return command.execute = this.commandCheckNumberVariable;
        case "gs.CheckTextVariable":
          return command.execute = this.commandCheckTextVariable;
        case "gs.Condition":
          return command.execute = this.commandCondition;
        case "gs.ConditionElse":
          return command.execute = this.commandConditionElse;
        case "gs.ConditionElseIf":
          return command.execute = this.commandConditionElseIf;
        case "gs.Label":
          return command.execute = this.commandLabel;
        case "gs.JumpToLabel":
          return command.execute = this.commandJumpToLabel;
        case "gs.SetMessageArea":
          return command.execute = this.commandSetMessageArea;
        case "gs.ShowMessage":
          return command.execute = this.commandShowMessage;
        case "gs.ShowPartialMessage":
          return command.execute = this.commandShowPartialMessage;
        case "gs.MessageFading":
          return command.execute = this.commandMessageFading;
        case "gs.MessageSettings":
          return command.execute = this.commandMessageSettings;
        case "gs.CreateMessageArea":
          return command.execute = this.commandCreateMessageArea;
        case "gs.EraseMessageArea":
          return command.execute = this.commandEraseMessageArea;
        case "gs.SetTargetMessage":
          return command.execute = this.commandSetTargetMessage;
        case "vn.MessageBoxDefaults":
          return command.execute = this.commandMessageBoxDefaults;
        case "vn.MessageBoxVisibility":
          return command.execute = this.commandMessageBoxVisibility;
        case "vn.MessageVisibility":
          return command.execute = this.commandMessageVisibility;
        case "vn.BacklogVisibility":
          return command.execute = this.commandBacklogVisibility;
        case "gs.ClearMessage":
          return command.execute = this.commandClearMessage;
        case "gs.ChangeWeather":
          return command.execute = this.commandChangeWeather;
        case "gs.FreezeScreen":
          return command.execute = this.commandFreezeScreen;
        case "gs.ScreenTransition":
          return command.execute = this.commandScreenTransition;
        case "gs.ShakeScreen":
          return command.execute = this.commandShakeScreen;
        case "gs.TintScreen":
          return command.execute = this.commandTintScreen;
        case "gs.FlashScreen":
          return command.execute = this.commandFlashScreen;
        case "gs.ZoomScreen":
          return command.execute = this.commandZoomScreen;
        case "gs.RotateScreen":
          return command.execute = this.commandRotateScreen;
        case "gs.PanScreen":
          return command.execute = this.commandPanScreen;
        case "gs.ScreenEffect":
          return command.execute = this.commandScreenEffect;
        case "gs.ShowVideo":
          return command.execute = this.commandShowVideo;
        case "gs.MoveVideo":
          return command.execute = this.commandMoveVideo;
        case "gs.MoveVideoPath":
          return command.execute = this.commandMoveVideoPath;
        case "gs.TintVideo":
          return command.execute = this.commandTintVideo;
        case "gs.FlashVideo":
          return command.execute = this.commandFlashVideo;
        case "gs.CropVideo":
          return command.execute = this.commandCropVideo;
        case "gs.RotateVideo":
          return command.execute = this.commandRotateVideo;
        case "gs.ZoomVideo":
          return command.execute = this.commandZoomVideo;
        case "gs.BlendVideo":
          return command.execute = this.commandBlendVideo;
        case "gs.MaskVideo":
          return command.execute = this.commandMaskVideo;
        case "gs.VideoEffect":
          return command.execute = this.commandVideoEffect;
        case "gs.VideoMotionBlur":
          return command.execute = this.commandVideoMotionBlur;
        case "gs.VideoDefaults":
          return command.execute = this.commandVideoDefaults;
        case "gs.EraseVideo":
          return command.execute = this.commandEraseVideo;
        case "gs.ShowImageMap":
          return command.execute = this.commandShowImageMap;
        case "gs.EraseImageMap":
          return command.execute = this.commandEraseImageMap;
        case "gs.AddHotspot":
          return command.execute = this.commandAddHotspot;
        case "gs.EraseHotspot":
          return command.execute = this.commandEraseHotspot;
        case "gs.ChangeHotspotState":
          return command.execute = this.commandChangeHotspotState;
        case "gs.ShowPicture":
          return command.execute = this.commandShowPicture;
        case "gs.MovePicture":
          return command.execute = this.commandMovePicture;
        case "gs.MovePicturePath":
          return command.execute = this.commandMovePicturePath;
        case "gs.TintPicture":
          return command.execute = this.commandTintPicture;
        case "gs.FlashPicture":
          return command.execute = this.commandFlashPicture;
        case "gs.CropPicture":
          return command.execute = this.commandCropPicture;
        case "gs.RotatePicture":
          return command.execute = this.commandRotatePicture;
        case "gs.ZoomPicture":
          return command.execute = this.commandZoomPicture;
        case "gs.BlendPicture":
          return command.execute = this.commandBlendPicture;
        case "gs.ShakePicture":
          return command.execute = this.commandShakePicture;
        case "gs.MaskPicture":
          return command.execute = this.commandMaskPicture;
        case "gs.PictureEffect":
          return command.execute = this.commandPictureEffect;
        case "gs.PictureMotionBlur":
          return command.execute = this.commandPictureMotionBlur;
        case "gs.PictureDefaults":
          return command.execute = this.commandPictureDefaults;
        case "gs.PlayPictureAnimation":
          return command.execute = this.commandPlayPictureAnimation;
        case "gs.ErasePicture":
          return command.execute = this.commandErasePicture;
        case "gs.InputNumber":
          return command.execute = this.commandInputNumber;
        case "vn.Choice":
          return command.execute = this.commandShowChoice;
        case "vn.ChoiceTimer":
          return command.execute = this.commandChoiceTimer;
        case "vn.ShowChoices":
          return command.execute = this.commandShowChoices;
        case "vn.UnlockCG":
          return command.execute = this.commandUnlockCG;
        case "vn.L2DJoinScene":
          return command.execute = this.commandL2DJoinScene;
        case "vn.L2DExitScene":
          return command.execute = this.commandL2DExitScene;
        case "vn.L2DMotion":
          return command.execute = this.commandL2DMotion;
        case "vn.L2DMotionGroup":
          return command.execute = this.commandL2DMotionGroup;
        case "vn.L2DExpression":
          return command.execute = this.commandL2DExpression;
        case "vn.L2DMove":
          return command.execute = this.commandL2DMove;
        case "vn.L2DParameter":
          return command.execute = this.commandL2DParameter;
        case "vn.L2DSettings":
          return command.execute = this.commandL2DSettings;
        case "vn.L2DDefaults":
          return command.execute = this.commandL2DDefaults;
        case "vn.CharacterJoinScene":
          return command.execute = this.commandCharacterJoinScene;
        case "vn.CharacterExitScene":
          return command.execute = this.commandCharacterExitScene;
        case "vn.CharacterChangeExpression":
          return command.execute = this.commandCharacterChangeExpression;
        case "vn.CharacterSetParameter":
          return command.execute = this.commandCharacterSetParameter;
        case "vn.CharacterGetParameter":
          return command.execute = this.commandCharacterGetParameter;
        case "vn.CharacterDefaults":
          return command.execute = this.commandCharacterDefaults;
        case "vn.CharacterEffect":
          return command.execute = this.commandCharacterEffect;
        case "vn.ZoomCharacter":
          return command.execute = this.commandZoomCharacter;
        case "vn.RotateCharacter":
          return command.execute = this.commandRotateCharacter;
        case "vn.BlendCharacter":
          return command.execute = this.commandBlendCharacter;
        case "vn.ShakeCharacter":
          return command.execute = this.commandShakeCharacter;
        case "vn.MaskCharacter":
          return command.execute = this.commandMaskCharacter;
        case "vn.MoveCharacter":
          return command.execute = this.commandMoveCharacter;
        case "vn.MoveCharacterPath":
          return command.execute = this.commandMoveCharacterPath;
        case "vn.FlashCharacter":
          return command.execute = this.commandFlashCharacter;
        case "vn.TintCharacter":
          return command.execute = this.commandTintCharacter;
        case "vn.CharacterMotionBlur":
          return command.execute = this.commandCharacterMotionBlur;
        case "vn.ChangeBackground":
          return command.execute = this.commandChangeBackground;
        case "vn.ShakeBackground":
          return command.execute = this.commandShakeBackground;
        case "vn.ScrollBackground":
          return command.execute = this.commandScrollBackground;
        case "vn.ScrollBackgroundTo":
          return command.execute = this.commandScrollBackgroundTo;
        case "vn.ScrollBackgroundPath":
          return command.execute = this.commandScrollBackgroundPath;
        case "vn.ZoomBackground":
          return command.execute = this.commandZoomBackground;
        case "vn.RotateBackground":
          return command.execute = this.commandRotateBackground;
        case "vn.TintBackground":
          return command.execute = this.commandTintBackground;
        case "vn.BlendBackground":
          return command.execute = this.commandBlendBackground;
        case "vn.MaskBackground":
          return command.execute = this.commandMaskBackground;
        case "vn.BackgroundMotionBlur":
          return command.execute = this.commandBackgroundMotionBlur;
        case "vn.BackgroundEffect":
          return command.execute = this.commandBackgroundEffect;
        case "vn.BackgroundDefaults":
          return command.execute = this.commandBackgroundDefaults;
        case "vn.ChangeScene":
          return command.execute = this.commandChangeScene;
        case "vn.ReturnToPreviousScene":
          return command.execute = this.commandReturnToPreviousScene;
        case "vn.CallScene":
          return command.execute = this.commandCallScene;
        case "vn.SwitchToLayout":
          return command.execute = this.commandSwitchToLayout;
        case "gs.ChangeTransition":
          return command.execute = this.commandChangeTransition;
        case "gs.ChangeWindowSkin":
          return command.execute = this.commandChangeWindowSkin;
        case "gs.ChangeScreenTransitions":
          return command.execute = this.commandChangeScreenTransitions;
        case "vn.UIAccess":
          return command.execute = this.commandUIAccess;
        case "gs.PlayVideo":
          return command.execute = this.commandPlayVideo;
        case "gs.PlayMusic":
          return command.execute = this.commandPlayMusic;
        case "gs.StopMusic":
          return command.execute = this.commandStopMusic;
        case "gs.PlaySound":
          return command.execute = this.commandPlaySound;
        case "gs.StopSound":
          return command.execute = this.commandStopSound;
        case "gs.PauseMusic":
          return command.execute = this.commandPauseMusic;
        case "gs.ResumeMusic":
          return command.execute = this.commandResumeMusic;
        case "gs.AudioDefaults":
          return command.execute = this.commandAudioDefaults;
        case "gs.EndCommonEvent":
          return command.execute = this.commandEndCommonEvent;
        case "gs.ResumeCommonEvent":
          return command.execute = this.commandResumeCommonEvent;
        case "gs.CallCommonEvent":
          return command.execute = this.commandCallCommonEvent;
        case "gs.ChangeTimer":
          return command.execute = this.commandChangeTimer;
        case "gs.ShowText":
          return command.execute = this.commandShowText;
        case "gs.RefreshText":
          return command.execute = this.commandRefreshText;
        case "gs.TextMotionBlur":
          return command.execute = this.commandTextMotionBlur;
        case "gs.MoveText":
          return command.execute = this.commandMoveText;
        case "gs.MoveTextPath":
          return command.execute = this.commandMoveTextPath;
        case "gs.RotateText":
          return command.execute = this.commandRotateText;
        case "gs.ZoomText":
          return command.execute = this.commandZoomText;
        case "gs.BlendText":
          return command.execute = this.commandBlendText;
        case "gs.ColorText":
          return command.execute = this.commandColorText;
        case "gs.EraseText":
          return command.execute = this.commandEraseText;
        case "gs.TextEffect":
          return command.execute = this.commandTextEffect;
        case "gs.TextDefaults":
          return command.execute = this.commandTextDefaults;
        case "gs.ChangeTextSettings":
          return command.execute = this.commandChangeTextSettings;
        case "gs.InputText":
          return command.execute = this.commandInputText;
        case "gs.InputName":
          return command.execute = this.commandInputName;
        case "gs.SavePersistentData":
          return command.execute = this.commandSavePersistentData;
        case "gs.SaveSettings":
          return command.execute = this.commandSaveSettings;
        case "gs.PrepareSaveGame":
          return command.execute = this.commandPrepareSaveGame;
        case "gs.SaveGame":
          return command.execute = this.commandSaveGame;
        case "gs.LoadGame":
          return command.execute = this.commandLoadGame;
        case "gs.GetInputData":
          return command.execute = this.commandGetInputData;
        case "gs.WaitForInput":
          return command.execute = this.commandWaitForInput;
        case "gs.ChangeObjectDomain":
          return command.execute = this.commandChangeObjectDomain;
        case "vn.GetGameData":
          return command.execute = this.commandGetGameData;
        case "vn.SetGameData":
          return command.execute = this.commandSetGameData;
        case "vn.GetObjectData":
          return command.execute = this.commandGetObjectData;
        case "vn.SetObjectData":
          return command.execute = this.commandSetObjectData;
        case "vn.ChangeSounds":
          return command.execute = this.commandChangeSounds;
        case "vn.ChangeColors":
          return command.execute = this.commandChangeColors;
        case "gs.ChangeScreenCursor":
          return command.execute = this.commandChangeScreenCursor;
        case "gs.ResetGlobalData":
          return command.execute = this.commandResetGlobalData;
        case "gs.Script":
          return command.execute = this.commandScript;
      }
    };


    /**
    * Executes the command at the specified index and increases the command-pointer.
    *
    * @method executeCommand
     */

    Component_CommandInterpreter.prototype.executeCommand = function(index) {
      var indent;
      this.command = this.object.commands[index];
      if (this.previewData) {
        if (this.previewData.uid && this.previewData.uid !== this.command.uid) {
          GameManager.tempSettings.skip = true;
          GameManager.tempSettings.skipTime = 0;
        } else if (this.pointer < this.previewData.pointer) {
          GameManager.tempSettings.skip = true;
          GameManager.tempSettings.skipTime = 0;
        } else {
          GameManager.tempSettings.skip = this.previewData.settings.animationDisabled;
          GameManager.tempSettings.skipTime = 0;
          this.previewInfo.waiting = true;
          gs.GlobalEventManager.emit("previewWaiting");
          if (this.previewData.settings.animationDisabled || this.previewData.settings.animationTime > 0) {
            this.previewInfo.timeout = setTimeout((function() {
              return Graphics.stopped = true;
            }), this.previewData.settings.animationTime * 1000);
          }
        }
      }
      if (this.command.execute != null) {
        this.command.interpreter = this;
        if (this.command.indent === this.indent) {
          this.command.execute();
        }
        this.pointer++;
        this.command = this.object.commands[this.pointer];
        if (this.command != null) {
          indent = this.command.indent;
        } else {
          indent = this.indent;
          while (indent > 0 && (this.loops[indent] == null)) {
            indent--;
          }
        }
        if (indent < this.indent) {
          this.indent = indent;
          if (this.loops[this.indent] != null) {
            this.pointer = this.loops[this.indent];
            this.command = this.object.commands[this.pointer];
            return this.command.interpreter = this;
          }
        }
      } else {
        this.assignCommand(this.command);
        if (this.command.execute != null) {
          this.command.interpreter = this;
          if (this.command.indent === this.indent) {
            this.command.execute();
          }
          this.pointer++;
          this.command = this.object.commands[this.pointer];
          if (this.command != null) {
            indent = this.command.indent;
          } else {
            indent = this.indent;
            while (indent > 0 && (this.loops[indent] == null)) {
              indent--;
            }
          }
          if (indent < this.indent) {
            this.indent = indent;
            if (this.loops[this.indent] != null) {
              this.pointer = this.loops[this.indent];
              this.command = this.object.commands[this.pointer];
              return this.command.interpreter = this;
            }
          }
        } else {
          return this.pointer++;
        }
      }
    };


    /**
    * Skips all commands until a command with the specified indent-level is
    * found. So for example: To jump from a Condition-Command to the next
    * Else-Command just pass the indent-level of the Condition/Else command.
    *
    * @method skip
    * @param {number} indent - The indent-level.
    * @param {boolean} backward - If true the skip runs backward.
     */

    Component_CommandInterpreter.prototype.skip = function(indent, backward) {
      var results, results1;
      if (backward) {
        this.pointer--;
        results = [];
        while (this.pointer > 0 && this.object.commands[this.pointer].indent !== indent) {
          results.push(this.pointer--);
        }
        return results;
      } else {
        this.pointer++;
        results1 = [];
        while (this.pointer < this.object.commands.length && this.object.commands[this.pointer].indent !== indent) {
          results1.push(this.pointer++);
        }
        return results1;
      }
    };


    /**
    * Halts the interpreter for the specified amount of time. An optionally
    * callback function can be passed which is called when the time is up.
    *
    * @method wait
    * @param {number} time - The time to wait
    * @param {gs.Callback} callback - Called if the wait time is up.
     */

    Component_CommandInterpreter.prototype.wait = function(time, callback) {
      this.isWaiting = true;
      this.waitCounter = time;
      return this.waitCallback = callback;
    };


    /**
    * Checks if the command at the specified pointer-index is a game message
    * related command.
    *
    * @method isMessageCommand
    * @param {number} pointer - The pointer/index.
    * @param {Object[]} commands - The list of commands to check.
    * @return {boolean} <b>true</b> if its a game message related command. Otherwise <b>false</b>.
     */

    Component_CommandInterpreter.prototype.isMessageCommand = function(pointer, commands) {
      var result;
      result = true;
      if (pointer >= commands.length || (commands[pointer].id !== "gs.InputNumber" && commands[pointer].id !== "vn.Choice" && commands[pointer].id !== "gs.InputText" && commands[pointer].id !== "gs.InputName")) {
        result = false;
      }
      return result;
    };


    /**
    * Checks if the command at the specified pointer-index asks for user-input like
    * the Input Number or Input Text command.
    *
    * @method isInputDataCommand
    * @param {number} pointer - The pointer/index.
    * @param {Object[]} commands - The list of commands to check.
    * @return {boolean} <b>true</b> if its an input-data command. Otherwise <b>false</b>
     */

    Component_CommandInterpreter.prototype.isInputDataCommand = function(pointer, commands) {
      return pointer < commands.length && (commands[pointer].id === "gs.InputNumber" || commands[pointer].id === "gs.InputText" || commands[pointer].id === "vn.Choice" || commands[pointer].id === "vn.ShowChoices");
    };


    /**
    * Checks if a game message is currently running by another interpreter like a
    * common-event interpreter.
    *
    * @method isProcessingMessageInOtherContext
    * @return {boolean} <b>true</b> a game message is running in another context. Otherwise <b>false</b>
     */

    Component_CommandInterpreter.prototype.isProcessingMessageInOtherContext = function() {
      var gm, result, s;
      result = false;
      gm = GameManager;
      s = SceneManager.scene;
      result = ((s.inputNumberWindow != null) && s.inputNumberWindow.visible && s.inputNumberWindow.executionContext !== this.context) || ((s.inputTextWindow != null) && s.inputTextWindow.active && s.inputTextWindow.executionContext !== this.context);
      return result;
    };


    /**
    * If a game message is currently running by an other interpreter like a common-event
    * interpreter, this method trigger a wait until the other interpreter is finished
    * with the game message.
    *
    * @method waitForMessage
    * @return {boolean} <b>true</b> a game message is running in another context. Otherwise <b>false</b>
     */

    Component_CommandInterpreter.prototype.waitForMessage = function() {
      this.isWaitingForMessage = true;
      this.isWaiting = true;
      return this.pointer--;
    };


    /**
    * Gets the value the number variable at the specified index.
    *
    * @method numberValueAtIndex
    * @param {number} scope - The variable's scope.
    * @param {number} index - The index of the variable to get the value from.
    * @return {Number} The value of the variable.
     */

    Component_CommandInterpreter.prototype.numberValueAtIndex = function(scope, index, domain) {
      return GameManager.variableStore.numberValueAtIndex(scope, index, domain);
    };


    /**
    * Gets the value of a (possible) number variable. If a constant number value is specified, this method
    * does nothing an just returns that constant value. That's to make it more comfortable to just pass a value which
    * can be calculated by variable but also be just a constant value.
    *
    * @method numberValueOf
    * @param {number|Object} object - A number variable or constant number value.
    * @return {Number} The value of the variable.
     */

    Component_CommandInterpreter.prototype.numberValueOf = function(object) {
      return GameManager.variableStore.numberValueOf(object);
    };


    /**
    * It does the same like <b>numberValueOf</b> with one difference: If the specified object
    * is a variable, it's value is considered as a duration-value in milliseconds and automatically converted
    * into frames.
    *
    * @method durationValueOf
    * @param {number|Object} object - A number variable or constant number value.
    * @return {Number} The value of the variable.
     */

    Component_CommandInterpreter.prototype.durationValueOf = function(object) {
      if (object && (object.index != null)) {
        return Math.round(GameManager.variableStore.numberValueOf(object) / 1000 * Graphics.frameRate);
      } else {
        return Math.round(GameManager.variableStore.numberValueOf(object));
      }
    };


    /**
    * Gets a position ({x, y}) for the specified predefined object position configured in
    * Database - System.
    *
    * @method predefinedObjectPosition
    * @param {number} position - The index/ID of the predefined object position to set.
    * @param {gs.Object_Base} object - The game object to set the position for.
    * @param {Object} params - The params object of the scene command.
    * @return {Object} The position {x, y}.
     */

    Component_CommandInterpreter.prototype.predefinedObjectPosition = function(position, object, params) {
      var objectPosition;
      objectPosition = RecordManager.system.objectPositions[position];
      if (!objectPosition) {
        return {
          x: 0,
          y: 0
        };
      }
      return objectPosition.func.call(null, object, params) || {
        x: 0,
        y: 0
      };
    };


    /**
    * Sets the value of a number variable at the specified index.
    *
    * @method setNumberValueAtIndex
    * @param {number} scope - The variable's scope.
    * @param {number} index - The index of the variable to set.
    * @param {number} value - The number value to set the variable to.
     */

    Component_CommandInterpreter.prototype.setNumberValueAtIndex = function(scope, index, value, domain) {
      return GameManager.variableStore.setNumberValueAtIndex(scope, index, value, domain);
    };


    /**
    * Sets the value of a number variable.
    *
    * @method setNumberValueTo
    * @param {number} variable - The variable to set.
    * @param {number} value - The number value to set the variable to.
     */

    Component_CommandInterpreter.prototype.setNumberValueTo = function(variable, value) {
      return GameManager.variableStore.setNumberValueTo(variable, value);
    };


    /**
    * Sets the value of a list variable.
    *
    * @method setListObjectTo
    * @param {Object} variable - The variable to set.
    * @param {Object} value - The list object to set the variable to.
     */

    Component_CommandInterpreter.prototype.setListObjectTo = function(variable, value) {
      return GameManager.variableStore.setListObjectTo(variable, value);
    };


    /**
    * Sets the value of a boolean/switch variable.
    *
    * @method setBooleanValueTo
    * @param {Object} variable - The variable to set.
    * @param {boolean} value - The boolean value to set the variable to.
     */

    Component_CommandInterpreter.prototype.setBooleanValueTo = function(variable, value) {
      return GameManager.variableStore.setBooleanValueTo(variable, value);
    };


    /**
    * Sets the value of a number variable at the specified index.
    *
    * @method setBooleanValueAtIndex
    * @param {number} scope - The variable's scope.
    * @param {number} index - The index of the variable to set.
    * @param {boolean} value - The boolean value to set the variable to.
     */

    Component_CommandInterpreter.prototype.setBooleanValueAtIndex = function(scope, index, value, domain) {
      return GameManager.variableStore.setBooleanValueAtIndex(scope, index, value, domain);
    };


    /**
    * Sets the value of a string/text variable.
    *
    * @method setStringValueTo
    * @param {Object} variable - The variable to set.
    * @param {string} value - The string/text value to set the variable to.
     */

    Component_CommandInterpreter.prototype.setStringValueTo = function(variable, value) {
      return GameManager.variableStore.setStringValueTo(variable, value);
    };


    /**
    * Sets the value of the string variable at the specified index.
    *
    * @method setStringValueAtIndex
    * @param {number} scope - The variable scope.
    * @param {number} index - The variable's index.
    * @param {string} value - The value to set.
     */

    Component_CommandInterpreter.prototype.setStringValueAtIndex = function(scope, index, value, domain) {
      return GameManager.variableStore.setStringValueAtIndex(scope, index, value, domain);
    };


    /**
    * Gets the value of a (possible) string variable. If a constant string value is specified, this method
    * does nothing an just returns that constant value. That's to make it more comfortable to just pass a value which
    * can be calculated by variable but also be just a constant value.
    *
    * @method stringValueOf
    * @param {string|Object} object - A string variable or constant string value.
    * @return {string} The value of the variable.
     */

    Component_CommandInterpreter.prototype.stringValueOf = function(object) {
      return GameManager.variableStore.stringValueOf(object);
    };


    /**
    * Gets the value of the string variable at the specified index.
    *
    * @method stringValueAtIndex
    * @param {number} scope - The variable's scope.
    * @param {number} index - The index of the variable to get the value from.
    * @return {string} The value of the variable.
     */

    Component_CommandInterpreter.prototype.stringValueAtIndex = function(scope, index, domain) {
      return GameManager.variableStore.stringValueAtIndex(scope, index, domain);
    };


    /**
    * Gets the value of a (possible) boolean variable. If a constant boolean value is specified, this method
    * does nothing an just returns that constant value. That's to make it more comfortable to just pass a value which
    * can be calculated by variable but also be just a constant value.
    *
    * @method booleanValueOf
    * @param {boolean|Object} object - A boolean variable or constant boolean value.
    * @return {boolean} The value of the variable.
     */

    Component_CommandInterpreter.prototype.booleanValueOf = function(object) {
      return GameManager.variableStore.booleanValueOf(object);
    };


    /**
    * Gets the value of the boolean variable at the specified index.
    *
    * @method booleanValueAtIndex
    * @param {number} scope - The variable's scope.
    * @param {number} index - The index of the variable to get the value from.
    * @return {string} The value of the variable.
     */

    Component_CommandInterpreter.prototype.booleanValueAtIndex = function(scope, index, domain) {
      return GameManager.variableStore.booleanValueAtIndex(scope, index, domain);
    };


    /**
    * Gets the value of a (possible) list variable.
    *
    * @method listObjectOf
    * @param {Object} object - A list variable.
    * @return {Object} The value of the list variable.
     */

    Component_CommandInterpreter.prototype.listObjectOf = function(object) {
      return GameManager.variableStore.listObjectOf(object);
    };


    /**
    * Compares two object using the specified operation and returns the result.
    *
    * @method compare
    * @param {Object} a - Object A.
    * @param {Object} b - Object B.
    * @param {number} operation - The compare-operation to compare Object A with Object B.
    * <ul>
    * <li>0 = Equal To</li>
    * <li>1 = Not Equal To</li>
    * <li>2 = Greater Than</li>
    * <li>3 = Greater or Equal To</li>
    * <li>4 = Less Than</li>
    * <li>5 = Less or Equal To</li>
    * </ul>
    * @return {boolean} The comparison result.
     */

    Component_CommandInterpreter.prototype.compare = function(a, b, operation) {
      switch (operation) {
        case 0:
          return a == b;
        case 1:
          return a != b;
        case 2:
          return a > b;
        case 3:
          return a >= b;
        case 4:
          return a < b;
        case 5:
          return a <= b;
      }
    };


    /**
    * Changes number variables and allows decimal values such as 0.5 too.
    *
    * @method changeDecimalVariables
    * @param {Object} params - Input params from the command
    * @param {Object} roundMethod - The result of the operation will be rounded using the specified method.
    * <ul>
    * <li>0 = None. The result will not be rounded.</li>
    * <li>1 = Commercially</li>
    * <li>2 = Round Up</li>
    * <li>3 = Round Down</li>
    * </ul>
     */

    Component_CommandInterpreter.prototype.changeDecimalVariables = function(params, roundMethod) {
      var diff, end, i, index, k, ref, ref1, roundFunc, scope, source, start;
      source = 0;
      roundFunc = null;
      switch (roundMethod) {
        case 0:
          roundFunc = function(value) {
            return value;
          };
          break;
        case 1:
          roundFunc = function(value) {
            return Math.round(value);
          };
          break;
        case 2:
          roundFunc = function(value) {
            return Math.ceil(value);
          };
          break;
        case 3:
          roundFunc = function(value) {
            return Math.floor(value);
          };
      }
      switch (params.source) {
        case 0:
          source = this.numberValueOf(params.sourceValue);
          break;
        case 1:
          start = this.numberValueOf(params.sourceRandom.start);
          end = this.numberValueOf(params.sourceRandom.end);
          diff = end - start;
          source = Math.floor(start + Math.random() * (diff + 1));
          break;
        case 2:
          source = this.numberValueAtIndex(params.sourceScope, this.numberValueOf(params.sourceReference) - 1, params.sourceReferenceDomain);
          break;
        case 3:
          source = this.numberValueOfGameData(params.sourceValue1);
          break;
        case 4:
          source = this.numberValueOfDatabaseData(params.sourceValue1);
      }
      switch (params.target) {
        case 0:
          switch (params.operation) {
            case 0:
              this.setNumberValueTo(params.targetVariable, roundFunc(source));
              break;
            case 1:
              this.setNumberValueTo(params.targetVariable, roundFunc(this.numberValueOf(params.targetVariable) + source));
              break;
            case 2:
              this.setNumberValueTo(params.targetVariable, roundFunc(this.numberValueOf(params.targetVariable) - source));
              break;
            case 3:
              this.setNumberValueTo(params.targetVariable, roundFunc(this.numberValueOf(params.targetVariable) * source));
              break;
            case 4:
              this.setNumberValueTo(params.targetVariable, roundFunc(this.numberValueOf(params.targetVariable) / source));
              break;
            case 5:
              this.setNumberValueTo(params.targetVariable, this.numberValueOf(params.targetVariable) % source);
          }
          break;
        case 1:
          scope = params.targetScope;
          start = params.targetRange.start - 1;
          end = params.targetRange.end - 1;
          for (i = k = ref = start, ref1 = end; ref <= ref1 ? k <= ref1 : k >= ref1; i = ref <= ref1 ? ++k : --k) {
            switch (params.operation) {
              case 0:
                this.setNumberValueAtIndex(scope, i, roundFunc(source));
                break;
              case 1:
                this.setNumberValueAtIndex(scope, i, roundFunc(this.numberValueAtIndex(scope, i) + source));
                break;
              case 2:
                this.setNumberValueAtIndex(scope, i, roundFunc(this.numberValueAtIndex(scope, i) - source));
                break;
              case 3:
                this.setNumberValueAtIndex(scope, i, roundFunc(this.numberValueAtIndex(scope, i) * source));
                break;
              case 4:
                this.setNumberValueAtIndex(scope, i, roundFunc(this.numberValueAtIndex(scope, i) / source));
                break;
              case 5:
                this.setNumberValueAtIndex(scope, i, this.numberValueAtIndex(scope, i) % source);
            }
          }
          break;
        case 2:
          index = this.numberValueOf(params.targetReference) - 1;
          switch (params.operation) {
            case 0:
              this.setNumberValueAtIndex(params.targetScope, index, roundFunc(source), params.targetReferenceDomain);
              break;
            case 1:
              this.setNumberValueAtIndex(params.targetScope, index, roundFunc(this.numberValueAtIndex(params.targetScope, index, params.targetReferenceDomain) + source), params.targetReferenceDomain);
              break;
            case 2:
              this.setNumberValueAtIndex(params.targetScope, index, roundFunc(this.numberValueAtIndex(params.targetScope, index, params.targetReferenceDomain) - source), params.targetReferenceDomain);
              break;
            case 3:
              this.setNumberValueAtIndex(params.targetScope, index, roundFunc(this.numberValueAtIndex(params.targetScope, index, params.targetReferenceDomain) * source), params.targetReferenceDomain);
              break;
            case 4:
              this.setNumberValueAtIndex(params.targetScope, index, roundFunc(this.numberValueAtIndex(params.targetScope, index, params.targetReferenceDomain) / source), params.targetReferenceDomain);
              break;
            case 5:
              this.setNumberValueAtIndex(params.targetScope, index, this.numberValueAtIndex(params.targetScope, index, params.targetReferenceDomain) % source, params.targetReferenceDomain);
          }
      }
      return null;
    };


    /**
    * Shakes a game object.
    *
    * @method shakeObject
    * @param {gs.Object_Base} object - The game object to shake.
    * @return {Object} A params object containing additional info about the shake-animation.
     */

    Component_CommandInterpreter.prototype.shakeObject = function(object, params) {
      var duration, easing;
      duration = Math.max(Math.round(this.durationValueOf(params.duration)), 2);
      easing = gs.Easings.fromObject(params.easing);
      object.animator.shake({
        x: this.numberValueOf(params.range.x),
        y: this.numberValueOf(params.range.y)
      }, this.numberValueOf(params.speed) / 100, duration, easing);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Lets the interpreter wait for the completion of a running operation like an animation, etc.
    *
    * @method waitForCompletion
    * @param {gs.Object_Base} object - The game object the operation is executed on. Can be <b>null</b>.
    * @return {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.waitForCompletion = function(object, params) {
      var duration;
      duration = this.durationValueOf(params.duration);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Erases a game object.
    *
    * @method eraseObject
    * @param {gs.Object_Base} object - The game object to erase.
    * @return {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.eraseObject = function(object, params, callback) {
      var duration, easing;
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      object.animator.disappear(params.animation, easing, duration, (function(_this) {
        return function(sender) {
          sender.dispose();
          return typeof callback === "function" ? callback(sender) : void 0;
        };
      })(this));
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Shows a game object on screen.
    *
    * @method showObject
    * @param {gs.Object_Base} object - The game object to show.
    * @param {gs.Point} position - The position where the game object should be shown.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.showObject = function(object, position, params) {
      var duration, easing, x, y;
      x = this.numberValueOf(position.x);
      y = this.numberValueOf(position.y);
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      object.animator.appear(x, y, params.animation, easing, duration);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Moves a game object.
    *
    * @method moveObject
    * @param {gs.Object_Base} object - The game object to move.
    * @param {gs.Point} position - The position to move the game object to.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.moveObject = function(object, position, params) {
      var bitmap, duration, easing, p, x, y, zoom;
      if (params.positionType === 0) {
        p = this.predefinedObjectPosition(params.predefinedPositionId, object, params);
        x = p.x;
        y = p.y;
      } else {
        x = this.numberValueOf(position.x);
        y = this.numberValueOf(position.y);
      }
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      zoom = object.zoom;
      if (object.anchor.x !== 0 && object.anchor.y !== 0) {
        bitmap = object.bitmap;
        if (bitmap != null) {
          x += (bitmap.width * zoom.x - bitmap.width) * object.anchor.x;
          y += (bitmap.height * zoom.y - bitmap.height) * object.anchor.y;
        }
      }
      object.animator.moveTo(x, y, duration, easing);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Moves a game object along a path.
    *
    * @method moveObjectPath
    * @param {gs.Object_Base} object - The game object to move.
    * @param {Object} path - The path to move the game object along.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.moveObjectPath = function(object, path, params) {
      var duration, easing, ref;
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      object.animator.movePath(path.data, params.loopType, duration, easing, (ref = path.effects) != null ? ref.data : void 0);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Scrolls a scrollable game object along a path.
    *
    * @method scrollObjectPath
    * @param {gs.Object_Base} object - The game object to scroll.
    * @param {Object} path - The path to scroll the game object along.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.scrollObjectPath = function(object, path, params) {
      var duration, easing;
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      object.animator.scrollPath(path, params.loopType, duration, easing);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Zooms/Scales a game object.
    *
    * @method zoomObject
    * @param {gs.Object_Base} object - The game object to zoom.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.zoomObject = function(object, params) {
      var duration, easing;
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      object.animator.zoomTo(this.numberValueOf(params.zooming.x) / 100, this.numberValueOf(params.zooming.y) / 100, duration, easing);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Rotates a game object.
    *
    * @method rotateObject
    * @param {gs.Object_Base} object - The game object to rotate.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.rotateObject = function(object, params) {
      var duration, easing;
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      easing = gs.Easings.fromObject(params.easing);
      object.animator.rotate(params.direction, this.numberValueOf(params.speed) / 100, duration, easing);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Blends a game object.
    *
    * @method blendObject
    * @param {gs.Object_Base} object - The game object to blend.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.blendObject = function(object, params) {
      var duration, easing;
      easing = gs.Easings.fromObject(params.easing);
      duration = this.durationValueOf(params.duration);
      object.animator.blendTo(this.numberValueOf(params.opacity), duration, easing);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Executes a masking-effect on a game object..
    *
    * @method maskObject
    * @param {gs.Object_Base} object - The game object to execute a masking-effect on.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.maskObject = function(object, params) {
      var duration, easing, mask, ref, ref1, ref2;
      easing = gs.Easings.fromObject(params.easing);
      if (params.mask.type === 0) {
        object.mask.type = 0;
        object.mask.ox = this.numberValueOf(params.mask.ox);
        object.mask.oy = this.numberValueOf(params.mask.oy);
        if (((ref = object.mask.source) != null ? ref.videoElement : void 0) != null) {
          object.mask.source.pause();
        }
        if (params.mask.sourceType === 0) {
          object.mask.source = ResourceManager.getBitmap("Graphics/Masks/" + ((ref1 = params.mask.graphic) != null ? ref1.name : void 0));
        } else {
          object.mask.source = ResourceManager.getVideo("Movies/" + ((ref2 = params.mask.video) != null ? ref2.name : void 0));
          if (object.mask.source) {
            object.mask.source.play();
            object.mask.source.loop = true;
          }
        }
      } else {
        duration = this.durationValueOf(params.duration);
        mask = Object.flatCopy(params.mask);
        mask.value = this.numberValueOf(mask.value);
        object.animator.maskTo(mask, duration, easing);
      }
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Tints a game object.
    *
    * @method tintObject
    * @param {gs.Object_Base} object - The game object to tint.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.tintObject = function(object, params) {
      var duration, easing;
      duration = this.durationValueOf(params.duration);
      easing = gs.Easings.fromObject(params.easing);
      object.animator.tintTo(params.tone, duration, easing);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Flashes a game object.
    *
    * @method flashObject
    * @param {gs.Object_Base} object - The game object to flash.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.flashObject = function(object, params) {
      var duration;
      duration = this.durationValueOf(params.duration);
      object.animator.flash(new Color(params.color), duration);
      if (params.waitForCompletion && !(duration === 0 || this.isInstantSkip())) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Cropes a game object.
    *
    * @method cropObject
    * @param {gs.Object_Base} object - The game object to crop.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.cropObject = function(object, params) {
      object.srcRect.x = this.numberValueOf(params.x);
      object.srcRect.y = this.numberValueOf(params.y);
      object.srcRect.width = this.numberValueOf(params.width);
      object.srcRect.height = this.numberValueOf(params.height);
      object.dstRect.width = this.numberValueOf(params.width);
      return object.dstRect.height = this.numberValueOf(params.height);
    };


    /**
    * Sets the motion blur settings of a game object.
    *
    * @method objectMotionBlur
    * @param {gs.Object_Base} object - The game object to set the motion blur settings for.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.objectMotionBlur = function(object, params) {
      return object.motionBlur.set(params.motionBlur);
    };


    /**
    * Enables an effect on a game object.
    *
    * @method objectEffect
    * @param {gs.Object_Base} object - The game object to execute a masking-effect on.
    * @param {Object} A params object containing additional info.
     */

    Component_CommandInterpreter.prototype.objectEffect = function(object, params) {
      var duration, easing, wobble;
      duration = this.durationValueOf(params.duration);
      easing = gs.Easings.fromObject(params.easing);
      switch (params.type) {
        case 0:
          object.animator.wobbleTo(params.wobble.power / 10000, params.wobble.speed / 100, duration, easing);
          wobble = object.effects.wobble;
          wobble.enabled = params.wobble.power > 0;
          wobble.vertical = params.wobble.orientation === 0 || params.wobble.orientation === 2;
          wobble.horizontal = params.wobble.orientation === 1 || params.wobble.orientation === 2;
          break;
        case 1:
          object.animator.blurTo(params.blur.power / 100, duration, easing);
          object.effects.blur.enabled = true;
          break;
        case 2:
          object.animator.pixelateTo(params.pixelate.size.width, params.pixelate.size.height, duration, easing);
          object.effects.pixelate.enabled = true;
      }
      if (params.waitForCompletion && duration !== 0) {
        this.isWaiting = true;
        return this.waitCounter = duration;
      }
    };


    /**
    * Executes an action like for a hotspot.
    *
    * @method executeAction
    * @param {Object} action - Action-Data.
    * @param {boolean} stateValue - In case of switch-binding, the switch is set to this value.
    * @param {number} bindValue - A number value which be put into the action's bind-value variable.
     */

    Component_CommandInterpreter.prototype.executeAction = function(action, stateValue, bindValue) {
      var domain, ref;
      switch (action.type) {
        case 0:
          if (action.labelIndex) {
            return this.pointer = action.labelIndex;
          } else {
            return this.jumpToLabel(action.label);
          }
          break;
        case 1:
          return this.callCommonEvent(action.commonEventId, null, this.isWaiting);
        case 2:
          domain = GameManager.variableStore.domain;
          return this.setBooleanValueTo(action["switch"], stateValue);
        case 3:
          return this.callScene((ref = action.scene) != null ? ref.uid : void 0);
        case 4:
          domain = GameManager.variableStore.domain;
          this.setNumberValueTo(action.bindValueVariable, bindValue);
          if (action.labelIndex) {
            return this.pointer = action.labelIndex;
          } else {
            return this.jumpToLabel(action.label);
          }
      }
    };


    /**
    * Calls a common event and returns the sub-interpreter for it.
    *
    * @method callCommonEvent
    * @param {number} id - The ID of the common event to call.
    * @param {Object} parameters - Optional common event parameters.
    * @param {boolean} wait - Indicates if the interpreter should be stay in waiting-mode even if the sub-interpreter is finished.
     */

    Component_CommandInterpreter.prototype.callCommonEvent = function(id, parameters, wait) {
      var commonEvent, ref;
      commonEvent = GameManager.commonEvents[id];
      if (commonEvent != null) {
        if (SceneManager.scene.commonEventContainer.subObjects.indexOf(commonEvent) === -1) {
          SceneManager.scene.commonEventContainer.addObject(commonEvent);
        }
        if ((ref = commonEvent.events) != null) {
          ref.on("finish", gs.CallBack("onCommonEventFinish", this), {
            waiting: wait
          });
        }
        this.subInterpreter = commonEvent.behavior.call(parameters || [], this.settings, this.context);
        commonEvent.behavior.update();
        if (this.subInterpreter != null) {
          this.isWaiting = true;
          this.subInterpreter.settings = this.settings;
          this.subInterpreter.start();
          return this.subInterpreter.update();
        }
      }
    };


    /**
    * Calls a scene and returns the sub-interpreter for it.
    *
    * @method callScene
    * @param {String} uid - The UID of the scene to call.
     */

    Component_CommandInterpreter.prototype.callScene = function(uid) {
      var object, sceneDocument;
      sceneDocument = DataManager.getDocument(uid);
      if (sceneDocument != null) {
        this.isWaiting = true;
        this.subInterpreter = new vn.Component_CallSceneInterpreter();
        object = {
          commands: sceneDocument.items.commands
        };
        this.subInterpreter.repeat = false;
        this.subInterpreter.context.set(sceneDocument.uid, sceneDocument);
        this.subInterpreter.object = object;
        this.subInterpreter.onFinish = gs.CallBack("onCallSceneFinish", this);
        this.subInterpreter.start();
        this.subInterpreter.settings = this.settings;
        return this.subInterpreter.update();
      }
    };


    /**
    * Calls a common event and returns the sub-interpreter for it.
    *
    * @method storeListValue
    * @param {number} id - The ID of the common event to call.
    * @param {Object} parameters - Optional common event parameters.
    * @param {boolean} wait - Indicates if the interpreter should be stay in waiting-mode even if the sub-interpreter is finished.
     */

    Component_CommandInterpreter.prototype.storeListValue = function(variable, list, value, valueType) {
      switch (valueType) {
        case 0:
          return this.setNumberValueTo(variable, (!isNaN(value) ? value : 0));
        case 1:
          return this.setBooleanValueTo(variable, (value ? 1 : 0));
        case 2:
          return this.setStringValueTo(variable, value.toString());
        case 3:
          return this.setListObjectTo(variable, (value.length != null ? value : []));
      }
    };


    /**
    * @method jumpToLabel
     */

    Component_CommandInterpreter.prototype.jumpToLabel = function(label) {
      var found, i, k, ref;
      if (!label) {
        return;
      }
      found = false;
      for (i = k = 0, ref = this.object.commands.length; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
        if (this.object.commands[i].id === "gs.Label" && this.object.commands[i].params.name === label) {
          this.pointer = i;
          this.indent = this.object.commands[i].indent;
          found = true;
          break;
        }
      }
      if (found) {
        this.waitCounter = 0;
        return this.isWaiting = false;
      }
    };


    /**
    * Gets the current message box object depending on game mode (ADV or NVL).
    *
    * @method messageBoxObject
    * @return {gs.Object_Base} The message box object.
    * @protected
     */

    Component_CommandInterpreter.prototype.messageBoxObject = function(id) {
      if (SceneManager.scene.layout.visible) {
        return gs.ObjectManager.current.objectById(id || "messageBox");
      } else {
        return gs.ObjectManager.current.objectById(id || "nvlMessageBox");
      }
    };


    /**
    * Gets the current message object depending on game mode (ADV or NVL).
    *
    * @method messageObject
    * @return {ui.Object_Message} The message object.
    * @protected
     */

    Component_CommandInterpreter.prototype.messageObject = function() {
      if (SceneManager.scene.layout.visible) {
        return gs.ObjectManager.current.objectById("gameMessage_message");
      } else {
        return gs.ObjectManager.current.objectById("nvlGameMessage_message");
      }
    };


    /**
    * Gets the current message ID depending on game mode (ADV or NVL).
    *
    * @method messageObjectId
    * @return {string} The message object ID.
    * @protected
     */

    Component_CommandInterpreter.prototype.messageObjectId = function() {
      if (SceneManager.scene.layout.visible) {
        return "gameMessage_message";
      } else {
        return "nvlGameMessage_message";
      }
    };


    /**
    * Gets the current message settings.
    *
    * @method messageSettings
    * @return {Object} The message settings
    * @protected
     */

    Component_CommandInterpreter.prototype.messageSettings = function() {
      var message;
      message = this.targetMessage();
      return message.settings;
    };


    /**
    * Gets the current target message object where all message commands are executed on.
    *
    * @method targetMessage
    * @return {ui.Object_Message} The target message object.
    * @protected
     */

    Component_CommandInterpreter.prototype.targetMessage = function() {
      var message, ref, ref1, ref2, target;
      message = this.messageObject();
      target = this.settings.message.target;
      if (target != null) {
        switch (target.type) {
          case 0:
            message = (ref = gs.ObjectManager.current.objectById(target.id)) != null ? ref : this.messageObject();
            break;
          case 1:
            message = (ref1 = (ref2 = SceneManager.scene.messageAreas[target.id]) != null ? ref2.message : void 0) != null ? ref1 : this.messageObject();
        }
      }
      return message;
    };


    /**
    * Gets the current target message box containing the current target message.
    *
    * @method targetMessageBox
    * @return {ui.Object_UIElement} The target message box.
    * @protected
     */

    Component_CommandInterpreter.prototype.targetMessageBox = function() {
      var messageBox, ref, ref1, target;
      messageBox = this.messageObject();
      target = this.settings.message.target;
      if (target != null) {
        switch (target.type) {
          case 0:
            messageBox = (ref = gs.ObjectManager.current.objectById(target.id)) != null ? ref : this.messageObject();
            break;
          case 1:
            messageBox = (ref1 = gs.ObjectManager.current.objectById("customGameMessage_" + target.id)) != null ? ref1 : this.messageObject();
        }
      }
      return messageBox;
    };


    /**
    * Called after an input number dialog was accepted by the user. It takes the user's input and puts
    * it in the configured number variable.
    *
    * @method onInputNumberFinish
    * @return {Object} Event Object containing additional data like the number, etc.
    * @protected
     */

    Component_CommandInterpreter.prototype.onInputNumberFinish = function(e) {
      this.messageObject().behavior.clear();
      this.setNumberValueTo(this.waitingFor.inputNumber.variable, parseInt(ui.Component_FormulaHandler.fieldValue(e.sender, e.number)));
      this.isWaiting = false;
      this.waitingFor.inputNumber = null;
      return SceneManager.scene.inputNumberBox.dispose();
    };


    /**
    * Called after an input text dialog was accepted by the user. It takes the user's text input and puts
    * it in the configured string variable.
    *
    * @method onInputTextFinish
    * @return {Object} Event Object containing additional data like the text, etc.
    * @protected
     */

    Component_CommandInterpreter.prototype.onInputTextFinish = function(e) {
      this.messageObject().behavior.clear();
      this.setStringValueTo(this.waitingFor.inputText.variable, ui.Component_FormulaHandler.fieldValue(e.sender, e.text).replace(/_/g, ""));
      this.isWaiting = false;
      this.waitingFor.inputText = null;
      return SceneManager.scene.inputTextBox.dispose();
    };


    /**
    * Called after a choice was selected by the user. It jumps to the corresponding label
    * and also puts the choice into backlog.
    *
    * @method onChoiceAccept
    * @return {Object} Event Object containing additional data like the label, etc.
    * @protected
     */

    Component_CommandInterpreter.prototype.onChoiceAccept = function(e) {
      var duration, fading, messageObject, scene;
      scene = SceneManager.scene;
      scene.choiceTimer.behavior.stop();
      e.isSelected = true;
      delete e.sender;
      GameManager.backlog.push({
        character: {
          name: ""
        },
        message: "",
        choice: e,
        choices: scene.choices,
        isChoice: true
      });
      scene.choices = [];
      messageObject = this.messageObject();
      if (messageObject != null ? messageObject.visible : void 0) {
        this.isWaiting = true;
        fading = GameManager.tempSettings.messageFading;
        duration = GameManager.tempSettings.skip ? 0 : fading.duration;
        messageObject.animator.disappear(fading.animation, fading.easing, duration, (function(_this) {
          return function() {
            messageObject.behavior.clear();
            messageObject.visible = false;
            _this.isWaiting = false;
            _this.waitingFor.choice = null;
            return _this.executeAction(e.action, true);
          };
        })(this));
      } else {
        this.isWaiting = false;
        this.executeAction(e.action, true);
      }
      return scene.choiceWindow.dispose();
    };


    /**
    * Idle
    * @method commandIdle
    * @protected
     */

    Component_CommandInterpreter.prototype.commandIdle = function() {
      return this.interpreter.isWaiting = !this.interpreter.isInstantSkip();
    };


    /**
    * Start Timer
    * @method commandStartTimer
    * @protected
     */

    Component_CommandInterpreter.prototype.commandStartTimer = function() {
      var number, scene, timer, timers;
      scene = SceneManager.scene;
      timers = scene.timers;
      number = this.interpreter.numberValueOf(this.params.number);
      timer = timers[number];
      if (timer == null) {
        timer = new gs.Object_IntervalTimer();
        timers[number] = timer;
      }
      timer.events.offByOwner("elapsed", this.object);
      timer.events.on("elapsed", (function(_this) {
        return function(e) {
          var params;
          params = e.data.params;
          switch (params.action.type) {
            case 0:
              if (params.labelIndex != null) {
                return SceneManager.scene.interpreter.pointer = params.labelIndex;
              } else {
                return SceneManager.scene.interpreter.jumpToLabel(params.action.data.label);
              }
              break;
            case 1:
              return SceneManager.scene.interpreter.callCommonEvent(params.action.data.commonEventId, null, _this.interpreter.isWaiting);
          }
        };
      })(this), {
        params: this.params
      }, this.object);
      timer.behavior.interval = this.interpreter.durationValueOf(this.params.interval);
      return timer.behavior.start();
    };


    /**
    * Resume Timer
    * @method commandResumeTimer
    * @protected
     */

    Component_CommandInterpreter.prototype.commandResumeTimer = function() {
      var number, ref, timers;
      timers = SceneManager.scene.timers;
      number = this.interpreter.numberValueOf(this.params.number);
      return (ref = timers[number]) != null ? ref.behavior.resume() : void 0;
    };


    /**
    * Pauses Timer
    * @method commandPauseTimer
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPauseTimer = function() {
      var number, ref, timers;
      timers = SceneManager.scene.timers;
      number = this.interpreter.numberValueOf(this.params.number);
      return (ref = timers[number]) != null ? ref.behavior.pause() : void 0;
    };


    /**
    * Stop Timer
    * @method commandStopTimer
    * @protected
     */

    Component_CommandInterpreter.prototype.commandStopTimer = function() {
      var number, ref, timers;
      timers = SceneManager.scene.timers;
      number = this.interpreter.numberValueOf(this.params.number);
      return (ref = timers[number]) != null ? ref.behavior.stop() : void 0;
    };


    /**
    * Wait
    * @method commandWait
    * @protected
     */

    Component_CommandInterpreter.prototype.commandWait = function() {
      var time;
      time = this.interpreter.durationValueOf(this.params.time);
      if ((time != null) && time > 0 && !this.interpreter.previewData) {
        this.interpreter.waitCounter = time;
        return this.interpreter.isWaiting = true;
      }
    };


    /**
    * Loop
    * @method commandLoop
    * @protected
     */

    Component_CommandInterpreter.prototype.commandLoop = function() {
      this.interpreter.loops[this.interpreter.indent] = this.interpreter.pointer;
      return this.interpreter.indent++;
    };


    /**
    * Break Loop
    * @method commandBreakLoop
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBreakLoop = function() {
      var indent;
      indent = this.indent;
      while ((this.interpreter.loops[indent] == null) && indent > 0) {
        indent--;
      }
      this.interpreter.loops[indent] = null;
      return this.interpreter.indent = indent;
    };


    /**
    * @method commandListAdd
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListAdd = function() {
      var list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      switch (this.params.valueType) {
        case 0:
          list.push(this.interpreter.numberValueOf(this.params.numberValue));
          break;
        case 1:
          list.push(this.interpreter.booleanValueOf(this.params.switchValue));
          break;
        case 2:
          list.push(this.interpreter.stringValueOf(this.params.stringValue));
          break;
        case 3:
          list.push(this.interpreter.listObjectOf(this.params.listValue));
      }
      return this.interpreter.setListObjectTo(this.params.listVariable, list);
    };


    /**
    * @method commandListPop
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListPop = function() {
      var list, ref, value;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      value = (ref = list.pop()) != null ? ref : 0;
      return this.interpreter.storeListValue(this.params.targetVariable, list, value, this.params.valueType);
    };


    /**
    * @method commandListShift
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListShift = function() {
      var list, ref, value;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      value = (ref = list.shift()) != null ? ref : 0;
      return this.interpreter.storeListValue(this.params.targetVariable, list, value, this.params.valueType);
    };


    /**
    * @method commandListIndexOf
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListIndexOf = function() {
      var list, value;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      value = -1;
      switch (this.params.valueType) {
        case 0:
          value = list.indexOf(this.interpreter.numberValueOf(this.params.numberValue));
          break;
        case 1:
          value = list.indexOf(this.interpreter.booleanValueOf(this.params.switchValue));
          break;
        case 2:
          value = list.indexOf(this.interpreter.stringValueOf(this.params.stringValue));
          break;
        case 3:
          value = list.indexOf(this.interpreter.listObjectOf(this.params.listValue));
      }
      return this.interpreter.setNumberValueTo(this.params.targetVariable, value);
    };


    /**
    * @method commandListClear
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListClear = function() {
      var list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      return list.length = 0;
    };


    /**
    * @method commandListValueAt
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListValueAt = function() {
      var index, list, ref, value;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      index = this.interpreter.numberValueOf(this.params.index);
      if (index >= 0 && index < list.length) {
        value = (ref = list[index]) != null ? ref : 0;
        return this.interpreter.storeListValue(this.params.targetVariable, list, value, this.params.valueType);
      }
    };


    /**
    * @method commandListRemoveAt
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListRemoveAt = function() {
      var index, list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      index = this.interpreter.numberValueOf(this.params.index);
      if (index >= 0 && index < list.length) {
        return list.splice(index, 1);
      }
    };


    /**
    * @method commandListInsertAt
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListInsertAt = function() {
      var index, list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      index = this.interpreter.numberValueOf(this.params.index);
      if (index >= 0 && index < list.length) {
        switch (this.params.valueType) {
          case 0:
            list.splice(index, 0, this.interpreter.numberValueOf(this.params.numberValue));
            break;
          case 1:
            list.splice(index, 0, this.interpreter.booleanValueOf(this.params.switchValue));
            break;
          case 2:
            list.splice(index, 0, this.interpreter.stringValueOf(this.params.stringValue));
            break;
          case 3:
            list.splice(index, 0, this.interpreter.listObjectOf(this.params.listValue));
        }
        return this.interpreter.setListObjectTo(this.params.listVariable, list);
      }
    };


    /**
    * @method commandListSet
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListSet = function() {
      var index, list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      index = this.interpreter.numberValueOf(this.params.index);
      if (index >= 0) {
        switch (this.params.valueType) {
          case 0:
            list[index] = this.interpreter.numberValueOf(this.params.numberValue);
            break;
          case 1:
            list[index] = this.interpreter.booleanValueOf(this.params.switchValue);
            break;
          case 2:
            list[index] = this.interpreter.stringValueOf(this.params.stringValue);
            break;
          case 3:
            list[index] = this.interpreter.listObjectOf(this.params.listValue);
        }
        return this.interpreter.setListObjectTo(this.params.listVariable, list);
      }
    };


    /**
    * @method commandListCopy
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListCopy = function() {
      var copy, list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      copy = Object.deepCopy(list);
      return this.interpreter.setListObjectTo(this.params.targetVariable, copy);
    };


    /**
    * @method commandListLength
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListLength = function() {
      var list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      return this.interpreter.setNumberValueTo(this.params.targetVariable, list.length);
    };


    /**
    * @method commandListJoin
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListJoin = function() {
      var list, value;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      value = this.params.order === 0 ? list.join(this.params.separator || "") : list.reverse().join(this.params.separator || "");
      return this.interpreter.setStringValueTo(this.params.targetVariable, value);
    };


    /**
    * @method commandListFromText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListFromText = function() {
      var list, separator, text;
      text = this.interpreter.stringValueOf(this.params.textVariable);
      separator = this.interpreter.stringValueOf(this.params.separator);
      list = text.split(separator);
      return this.interpreter.setListObjectTo(this.params.targetVariable, list);
    };


    /**
    * @method commandListShuffle
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListShuffle = function() {
      var i, j, k, list, ref, results, tempi, tempj;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      if (list.length === 0) {
        return;
      }
      results = [];
      for (i = k = ref = list.length - 1; ref <= 1 ? k <= 1 : k >= 1; i = ref <= 1 ? ++k : --k) {
        j = Math.floor(Math.random() * (i + 1));
        tempi = list[i];
        tempj = list[j];
        list[i] = tempj;
        results.push(list[j] = tempi);
      }
      return results;
    };


    /**
    * @method commandListSort
    * @protected
     */

    Component_CommandInterpreter.prototype.commandListSort = function() {
      var list;
      list = this.interpreter.listObjectOf(this.params.listVariable);
      if (list.length === 0) {
        return;
      }
      switch (this.params.sortOrder) {
        case 0:
          return list.sort(function(a, b) {
            if (a < b) {
              return -1;
            }
            if (a > b) {
              return 1;
            }
            return 0;
          });
        case 1:
          return list.sort(function(a, b) {
            if (a > b) {
              return -1;
            }
            if (a < b) {
              return 1;
            }
            return 0;
          });
      }
    };


    /**
    * @method commandResetVariables
    * @protected
     */

    Component_CommandInterpreter.prototype.commandResetVariables = function() {
      var range;
      switch (this.params.target) {
        case 0:
          range = null;
          break;
        case 1:
          range = this.params.range;
      }
      switch (this.params.scope) {
        case 0:
          if (this.params.scene) {
            return GameManager.variableStore.clearLocalVariables({
              id: this.params.scene.uid
            }, this.params.type, range);
          }
          break;
        case 1:
          return GameManager.variableStore.clearLocalVariables(null, this.params.type, range);
        case 2:
          return GameManager.variableStore.clearGlobalVariables(this.params.type, range);
        case 3:
          GameManager.variableStore.clearPersistentVariables(this.params.type, range);
          return GameManager.saveGlobalData();
      }
    };


    /**
    * @method commandChangeVariableDomain
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeVariableDomain = function() {
      return GameManager.variableStore.changeDomain(this.interpreter.stringValueOf(this.params.domain));
    };


    /**
    * @method commandChangeDecimalVariables
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeDecimalVariables = function() {
      return this.interpreter.changeDecimalVariables(this.params, this.params.roundMethod);
    };


    /**
    * @method commandChangeNumberVariables
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeNumberVariables = function() {
      var diff, end, i, index, k, ref, ref1, scope, source, start;
      source = 0;
      switch (this.params.source) {
        case 0:
          source = this.interpreter.numberValueOf(this.params.sourceValue);
          break;
        case 1:
          start = this.interpreter.numberValueOf(this.params.sourceRandom.start);
          end = this.interpreter.numberValueOf(this.params.sourceRandom.end);
          diff = end - start;
          source = Math.floor(start + Math.random() * (diff + 1));
          break;
        case 2:
          source = this.interpreter.numberValueAtIndex(this.params.sourceScope, this.interpreter.numberValueOf(this.params.sourceReference) - 1, this.params.sourceReferenceDomain);
          break;
        case 3:
          source = this.interpreter.numberValueOfGameData(this.params.sourceValue1);
          break;
        case 4:
          source = this.interpreter.numberValueOfDatabaseData(this.params.sourceValue1);
      }
      switch (this.params.target) {
        case 0:
          switch (this.params.operation) {
            case 0:
              this.interpreter.setNumberValueTo(this.params.targetVariable, source);
              break;
            case 1:
              this.interpreter.setNumberValueTo(this.params.targetVariable, this.interpreter.numberValueOf(this.params.targetVariable) + source);
              break;
            case 2:
              this.interpreter.setNumberValueTo(this.params.targetVariable, this.interpreter.numberValueOf(this.params.targetVariable) - source);
              break;
            case 3:
              this.interpreter.setNumberValueTo(this.params.targetVariable, this.interpreter.numberValueOf(this.params.targetVariable) * source);
              break;
            case 4:
              this.interpreter.setNumberValueTo(this.params.targetVariable, Math.floor(this.interpreter.numberValueOf(this.params.targetVariable) / source));
              break;
            case 5:
              this.interpreter.setNumberValueTo(this.params.targetVariable, this.interpreter.numberValueOf(this.params.targetVariable) % source);
          }
          break;
        case 1:
          scope = this.params.targetScope;
          start = this.params.targetRange.start - 1;
          end = this.params.targetRange.end - 1;
          for (i = k = ref = start, ref1 = end; ref <= ref1 ? k <= ref1 : k >= ref1; i = ref <= ref1 ? ++k : --k) {
            switch (this.params.operation) {
              case 0:
                this.interpreter.setNumberValueAtIndex(scope, i, source);
                break;
              case 1:
                this.interpreter.setNumberValueAtIndex(scope, i, this.interpreter.numberValueAtIndex(scope, i) + source);
                break;
              case 2:
                this.interpreter.setNumberValueAtIndex(scope, i, this.interpreter.numberValueAtIndex(scope, i) - source);
                break;
              case 3:
                this.interpreter.setNumberValueAtIndex(scope, i, this.interpreter.numberValueAtIndex(scope, i) * source);
                break;
              case 4:
                this.interpreter.setNumberValueAtIndex(scope, i, Math.floor(this.interpreter.numberValueAtIndex(scope, i) / source));
                break;
              case 5:
                this.interpreter.setNumberValueAtIndex(scope, i, this.interpreter.numberValueAtIndex(scope, i) % source);
            }
          }
          break;
        case 2:
          index = this.interpreter.numberValueOf(this.params.targetReference) - 1;
          switch (this.params.operation) {
            case 0:
              this.interpreter.setNumberValueAtIndex(this.params.targetScope, index, source, this.params.targetReferenceDomain);
              break;
            case 1:
              this.interpreter.setNumberValueAtIndex(this.params.targetScope, index, this.interpreter.numberValueAtIndex(this.params.targetScope, index, this.params.targetReferenceDomain) + source, this.params.targetReferenceDomain);
              break;
            case 2:
              this.interpreter.setNumberValueAtIndex(this.params.targetScope, index, this.interpreter.numberValueAtIndex(this.params.targetScope, index, this.params.targetReferenceDomain) - source, this.params.targetReferenceDomain);
              break;
            case 3:
              this.interpreter.setNumberValueAtIndex(this.params.targetScope, index, this.interpreter.numberValueAtIndex(this.params.targetScope, index, this.params.targetReferenceDomain) * source, this.params.targetReferenceDomain);
              break;
            case 4:
              this.interpreter.setNumberValueAtIndex(this.params.targetScope, index, Math.floor(this.interpreter.numberValueAtIndex(this.params.targetScope, index, this.params.targetReferenceDomain) / source), this.params.targetReferenceDomain);
              break;
            case 5:
              this.interpreter.setNumberValueAtIndex(this.params.targetScope, index, this.interpreter.numberValueAtIndex(this.params.targetScope, index, this.params.targetReferenceDomain) % source, this.params.targetReferenceDomain);
          }
      }
      return null;
    };


    /**
    * @method commandChangeBooleanVariables
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeBooleanVariables = function() {
      var i, index, k, ref, ref1, source, targetValue, variable;
      source = this.interpreter.booleanValueOf(this.params.value);
      switch (this.params.target) {
        case 0:
          if (this.params.value === 2) {
            targetValue = this.interpreter.booleanValueOf(this.params.targetVariable);
            this.interpreter.setBooleanValueTo(this.params.targetVariable, targetValue ? false : true);
          } else {
            this.interpreter.setBooleanValueTo(this.params.targetVariable, source);
          }
          break;
        case 1:
          variable = {
            index: 0,
            scope: this.params.targetRangeScope
          };
          for (i = k = ref = this.params.rangeStart - 1, ref1 = this.params.rangeEnd - 1; ref <= ref1 ? k <= ref1 : k >= ref1; i = ref <= ref1 ? ++k : --k) {
            variable.index = i;
            if (this.params.value === 2) {
              targetValue = this.interpreter.booleanValueOf(variable);
              this.interpreter.setBooleanValueTo(variable, targetValue ? false : true);
            } else {
              this.interpreter.setBooleanValueTo(variable, source);
            }
          }
          break;
        case 2:
          index = this.interpreter.numberValueOf(this.params.targetReference) - 1;
          this.interpreter.setBooleanValueAtIndex(this.params.targetRangeScope, index, source, this.params.targetReferenceDomain);
      }
      return null;
    };


    /**
    * @method commandChangeStringVariables
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeStringVariables = function() {
      var ex, i, index, k, ref, ref1, source, targetValue, variable;
      source = "";
      switch (this.params.source) {
        case 0:
          source = lcs(this.params.textValue);
          break;
        case 1:
          source = this.interpreter.stringValueOf(this.params.sourceVariable);
          break;
        case 2:
          source = this.interpreter.stringValueOfDatabaseData(this.params.databaseData);
          break;
        case 2:
          try {
            source = eval(this.params.script);
          } catch (error) {
            ex = error;
            source = "ERR: " + ex.message;
          }
          break;
        default:
          source = lcs(this.params.textValue);
      }
      switch (this.params.target) {
        case 0:
          switch (this.params.operation) {
            case 0:
              this.interpreter.setStringValueTo(this.params.targetVariable, source);
              break;
            case 1:
              this.interpreter.setStringValueTo(this.params.targetVariable, this.interpreter.stringValueOf(this.params.targetVariable) + source);
              break;
            case 2:
              this.interpreter.setStringValueTo(this.params.targetVariable, this.interpreter.stringValueOf(this.params.targetVariable).toUpperCase());
              break;
            case 3:
              this.interpreter.setStringValueTo(this.params.targetVariable, this.interpreter.stringValueOf(this.params.targetVariable).toLowerCase());
          }
          break;
        case 1:
          variable = {
            index: 0,
            scope: this.params.targetRangeScope
          };
          for (i = k = ref = this.params.rangeStart - 1, ref1 = this.params.rangeEnd - 1; ref <= ref1 ? k <= ref1 : k >= ref1; i = ref <= ref1 ? ++k : --k) {
            variable.index = i;
            switch (this.params.operation) {
              case 0:
                this.interpreter.setStringValueTo(variable, source);
                break;
              case 1:
                this.interpreter.setStringValueTo(variable, this.interpreter.stringValueOf(variable) + source);
                break;
              case 2:
                this.interpreter.setStringValueTo(variable, this.interpreter.stringValueOf(variable).toUpperCase());
                break;
              case 3:
                this.interpreter.setStringValueTo(variable, this.interpreter.stringValueOf(variable).toLowerCase());
            }
          }
          break;
        case 2:
          index = this.interpreter.numberValueOf(this.params.targetReference) - 1;
          switch (this.params.operation) {
            case 0:
              this.interpreter.setStringValueAtIndex(this.params.targetRangeScope, index, source, this.params.targetReferenceDomain);
              break;
            case 1:
              targetValue = this.interpreter.stringValueAtIndex(this.params.targetRangeScope, index, this.params.targetReferenceDomain);
              this.interpreter.setStringValueAtIndex(this.params.targetRangeScope, index, targetValue + source, this.params.targetReferenceDomain);
              break;
            case 2:
              targetValue = this.interpreter.stringValueAtIndex(this.params.targetRangeScope, index, this.params.targetReferenceDomain);
              this.interpreter.setStringValueAtIndex(this.params.targetRangeScope, index, targetValue.toUpperCase(), this.params.targetReferenceDomain);
              break;
            case 3:
              targetValue = this.interpreter.stringValueAtIndex(this.params.targetRangeScope, index, this.params.targetReferenceDomain);
              this.interpreter.setStringValueTo(this.params.targetRangeScope, index, targetValue.toLowerCase(), this.params.targetReferenceDomain);
          }
      }
      return null;
    };


    /**
    * @method commandCheckSwitch
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCheckSwitch = function() {
      var result;
      result = this.interpreter.booleanValueOf(this.params.targetVariable) && this.params.value;
      if (result) {
        return this.interpreter.pointer = this.params.labelIndex;
      }
    };


    /**
    * @method commandNumberCondition
    * @protected
     */

    Component_CommandInterpreter.prototype.commandNumberCondition = function() {
      var result;
      result = this.interpreter.compare(this.interpreter.numberValueOf(this.params.targetVariable), this.interpreter.numberValueOf(this.params.value), this.params.operation);
      this.interpreter.conditions[this.interpreter.indent] = result;
      if (result) {
        return this.interpreter.indent++;
      }
    };


    /**
    * @method commandCondition
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCondition = function() {
      var result;
      switch (this.params.valueType) {
        case 0:
          result = this.interpreter.compare(this.interpreter.numberValueOf(this.params.variable), this.interpreter.numberValueOf(this.params.numberValue), this.params.operation);
          break;
        case 1:
          result = this.interpreter.compare(this.interpreter.booleanValueOf(this.params.variable), this.interpreter.booleanValueOf(this.params.switchValue), this.params.operation);
          break;
        case 2:
          result = this.interpreter.compare(lcs(this.interpreter.stringValueOf(this.params.variable)), lcs(this.interpreter.stringValueOf(this.params.textValue)), this.params.operation);
      }
      this.interpreter.conditions[this.interpreter.indent] = result;
      if (result) {
        return this.interpreter.indent++;
      }
    };


    /**
    * @method commandConditionElse
    * @protected
     */

    Component_CommandInterpreter.prototype.commandConditionElse = function() {
      if (!this.interpreter.conditions[this.interpreter.indent]) {
        return this.interpreter.indent++;
      }
    };


    /**
    * @method commandConditionElseIf
    * @protected
     */

    Component_CommandInterpreter.prototype.commandConditionElseIf = function() {
      if (!this.interpreter.conditions[this.interpreter.indent]) {
        return this.interpreter.commandCondition.call(this);
      }
    };


    /**
    * @method commandCheckNumberVariable
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCheckNumberVariable = function() {
      var result;
      result = this.interpreter.compare(this.interpreter.numberValueOf(this.params.targetVariable), this.interpreter.numberValueOf(this.params.value), this.params.operation);
      if (result) {
        return this.interpreter.pointer = this.params.labelIndex;
      }
    };


    /**
    * @method commandCheckTextVariable
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCheckTextVariable = function() {
      var result, text1, text2;
      result = false;
      text1 = this.interpreter.stringValueOf(this.params.targetVariable);
      text2 = this.interpreter.stringValueOf(this.params.value);
      switch (this.params.operation) {
        case 0:
          result = text1 === text2;
          break;
        case 1:
          result = text1 !== text2;
          break;
        case 2:
          result = text1.length > text2.length;
          break;
        case 3:
          result = text1.length >= text2.length;
          break;
        case 4:
          result = text1.length < text2.length;
          break;
        case 5:
          result = text1.length <= text2.length;
      }
      if (result) {
        return this.interpreter.pointer = this.params.labelIndex;
      }
    };


    /**
    * @method commandLabel
    * @protected
     */

    Component_CommandInterpreter.prototype.commandLabel = function() {};


    /**
    * @method commandJumpToLabel
    * @protected
     */

    Component_CommandInterpreter.prototype.commandJumpToLabel = function() {
      var label;
      label = this.params.labelIndex;
      if (label != null) {
        this.interpreter.pointer = label;
        return this.interpreter.indent = this.interpreter.object.commands[label].indent;
      } else {
        switch (this.params.target) {
          case "activeContext":
            return this.interpreter.jumpToLabel(this.interpreter.stringValueOf(this.params.name));
          case "activeScene":
            return SceneManager.scene.interpreter.jumpToLabel(this.interpreter.stringValueOf(this.params.name));
          default:
            return this.interpreter.jumpToLabel(this.interpreter.stringValueOf(this.params.name));
        }
      }
    };


    /**
    * @method commandClearMessage
    * @protected
     */

    Component_CommandInterpreter.prototype.commandClearMessage = function() {
      var duration, fading, flags, isLocked, messageObject, scene;
      scene = SceneManager.scene;
      messageObject = this.interpreter.targetMessage();
      if (messageObject == null) {
        return;
      }
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      duration = 0;
      fading = GameManager.tempSettings.messageFading;
      if (!GameManager.tempSettings.skip) {
        duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : fading.duration;
      }
      messageObject.animator.disappear(fading.animation, fading.easing, duration, gs.CallBack("onMessageADVClear", this.interpreter));
      this.interpreter.waitForCompletion(messageObject, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMessageBoxDefaults
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMessageBoxDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.messageBox;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.appearDuration)) {
        defaults.appearDuration = this.interpreter.durationValueOf(this.params.appearDuration);
      }
      if (!isLocked(flags.disappearDuration)) {
        defaults.disappearDuration = this.interpreter.durationValueOf(this.params.disappearDuration);
      }
      if (!isLocked(flags.zOrder)) {
        defaults.zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      }
      if (!isLocked(flags["appearEasing.type"])) {
        defaults.appearEasing = this.params.appearEasing;
      }
      if (!isLocked(flags["appearAnimation.type"])) {
        defaults.appearAnimation = this.params.appearAnimation;
      }
      if (!isLocked(flags["disappearEasing.type"])) {
        defaults.disappearEasing = this.params.disappearEasing;
      }
      if (!isLocked(flags["disappearAnimation.type"])) {
        return defaults.disappearAnimation = this.params.disappearAnimation;
      }
    };


    /**
    * @method commandShowMessage
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShowMessage = function() {
      var animation, character, defaults, duration, easing, expression, ref, scene, showMessage;
      scene = SceneManager.scene;
      scene.messageMode = vn.MessageMode.ADV;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === _this.params.characterId;
        };
      })(this));
      showMessage = (function(_this) {
        return function() {
          var messageObject, ref, settings, voiceSettings;
          character = RecordManager.characters[_this.params.characterId];
          scene.layout.visible = true;
          messageObject = _this.interpreter.targetMessage();
          if (messageObject == null) {
            return;
          }
          scene.currentCharacter = character;
          messageObject.character = character;
          messageObject.opacity = 255;
          messageObject.events.offByOwner("callCommonEvent", _this.interpreter);
          messageObject.events.on("callCommonEvent", gs.CallBack("onCallCommonEvent", _this.interpreter), {
            params: _this.params
          }, _this.interpreter);
          messageObject.events.once("finish", gs.CallBack("onMessageADVFinish", _this.interpreter), {
            params: _this.params
          }, _this.interpreter);
          messageObject.events.once("waiting", gs.CallBack("onMessageADVWaiting", _this.interpreter), {
            params: _this.params
          }, _this.interpreter);
          if (messageObject.settings.useCharacterColor) {
            messageObject.message.showMessage(_this.interpreter, _this.params, character);
          } else {
            messageObject.message.showMessage(_this.interpreter, _this.params);
          }
          settings = GameManager.settings;
          voiceSettings = settings.voicesByCharacter[character.index];
          if ((_this.params.voice != null) && GameManager.settings.voiceEnabled && (!voiceSettings || voiceSettings > 0)) {
            if ((GameManager.settings.skipVoiceOnAction || !((ref = AudioManager.voice) != null ? ref.playing : void 0)) && !GameManager.tempSettings.skip) {
              messageObject.voice = _this.params.voice;
              return messageObject.behavior.voice = AudioManager.playVoice(_this.params.voice);
            }
          } else {
            return messageObject.behavior.voice = null;
          }
        };
      })(this);
      if ((this.params.expressionId != null) && (character != null)) {
        expression = RecordManager.characterExpressions[this.params.expressionId || 0];
        defaults = GameManager.defaults.character;
        duration = !gs.CommandFieldFlags.isLocked(this.params.fieldFlags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.expressionDuration;
        easing = gs.Easings.fromObject(defaults.changeEasing);
        animation = defaults.changeAnimation;
        character.behavior.changeExpression(expression, animation, easing, duration, (function(_this) {
          return function() {
            return showMessage();
          };
        })(this));
      } else {
        showMessage();
      }
      this.interpreter.isWaiting = ((ref = this.params.waitForCompletion) != null ? ref : true) && !(GameManager.tempSettings.skip && GameManager.tempSettings.skipTime === 0);
      return this.interpreter.waitingFor.messageADV = this.params;
    };


    /**
    * @method commandSetMessageArea
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSetMessageArea = function() {
      var messageLayout, number, scene;
      scene = SceneManager.scene;
      number = this.interpreter.numberValueOf(this.params.number);
      if (scene.messageAreas[number]) {
        messageLayout = scene.messageAreas[number].layout;
        messageLayout.dstRect.x = this.params.box.x;
        messageLayout.dstRect.y = this.params.box.y;
        messageLayout.dstRect.width = this.params.box.size.width;
        messageLayout.dstRect.height = this.params.box.size.height;
        return messageLayout.needsUpdate = true;
      }
    };


    /**
    * @method commandMessageFading
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMessageFading = function() {
      return GameManager.tempSettings.messageFading = {
        duration: this.interpreter.durationValueOf(this.params.duration),
        animation: this.params.animation,
        easing: gs.Easings.fromObject(this.params.easing)
      };
    };


    /**
    * @method commandMessageSettings
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMessageSettings = function() {
      var flags, font, fontName, fontSize, isLocked, messageObject, messageSettings, ref, ref1, ref2, ref3, ref4, ref5;
      messageObject = this.interpreter.targetMessage();
      if (!messageObject) {
        return;
      }
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      messageSettings = this.interpreter.messageSettings();
      if (!isLocked(flags.autoErase)) {
        messageSettings.autoErase = this.params.autoErase;
      }
      if (!isLocked(flags.waitAtEnd)) {
        messageSettings.waitAtEnd = this.params.waitAtEnd;
      }
      if (!isLocked(flags.backlog)) {
        messageSettings.backlog = this.params.backlog;
      }
      if (!isLocked(flags.lineHeight)) {
        messageSettings.lineHeight = this.params.lineHeight;
      }
      if (!isLocked(flags.lineSpacing)) {
        messageSettings.lineSpacing = this.params.lineSpacing;
      }
      if (!isLocked(flags.linePadding)) {
        messageSettings.linePadding = this.params.linePadding;
      }
      if (!isLocked(flags.paragraphSpacing)) {
        messageSettings.paragraphSpacing = this.params.paragraphSpacing;
      }
      if (!isLocked(flags.useCharacterColor)) {
        messageSettings.useCharacterColor = this.params.useCharacterColor;
      }
      messageObject.textRenderer.minLineHeight = (ref = messageSettings.lineHeight) != null ? ref : 0;
      messageObject.textRenderer.lineSpacing = (ref1 = messageSettings.lineSpacing) != null ? ref1 : messageObject.textRenderer.lineSpacing;
      messageObject.textRenderer.padding = (ref2 = messageSettings.linePadding) != null ? ref2 : messageObject.textRenderer.padding;
      fontName = !isLocked(flags.font) ? this.params.font : messageObject.font.name;
      fontSize = !isLocked(flags.size) ? this.params.size : messageObject.font.size;
      font = messageObject.font;
      if (!isLocked(flags.font) || !isLocked(flags.size)) {
        messageObject.font = new Font(fontName, fontSize);
      }
      if (!isLocked(flags.bold)) {
        messageObject.font.bold = this.params.bold;
      }
      if (!isLocked(flags.italic)) {
        messageObject.font.italic = this.params.italic;
      }
      if (!isLocked(flags.smallCaps)) {
        messageObject.font.smallCaps = this.params.smallCaps;
      }
      if (!isLocked(flags.underline)) {
        messageObject.font.underline = this.params.underline;
      }
      if (!isLocked(flags.strikeThrough)) {
        messageObject.font.strikeThrough = this.params.strikeThrough;
      }
      if (!isLocked(flags.color)) {
        messageObject.font.color = new Color(this.params.color);
      }
      messageObject.font.color = (flags.color != null) && !isLocked(flags.color) ? new Color(this.params.color) : font.color;
      messageObject.font.border = (flags.outline != null) && !isLocked(flags.outline) ? this.params.outline : font.border;
      messageObject.font.borderColor = (flags.outlineColor != null) && !isLocked(flags.outlineColor) ? new Color(this.params.outlineColor) : new Color(font.borderColor);
      messageObject.font.borderSize = (flags.outlineSize != null) && !isLocked(flags.outlineSize) ? (ref3 = this.params.outlineSize) != null ? ref3 : 4 : font.borderSize;
      messageObject.font.shadow = (flags.shadow != null) && !isLocked(flags.shadow) ? this.params.shadow : font.shadow;
      messageObject.font.shadowColor = (flags.shadowColor != null) && !isLocked(flags.shadowColor) ? new Color(this.params.shadowColor) : new Color(font.shadowColor);
      messageObject.font.shadowOffsetX = (flags.shadowOffsetX != null) && !isLocked(flags.shadowOffsetX) ? (ref4 = this.params.shadowOffsetX) != null ? ref4 : 1 : font.shadowOffsetX;
      messageObject.font.shadowOffsetY = (flags.shadowOffsetY != null) && !isLocked(flags.shadowOffsetY) ? (ref5 = this.params.shadowOffsetY) != null ? ref5 : 1 : font.shadowOffsetY;
      if (isLocked(flags.bold)) {
        messageObject.font.bold = font.bold;
      }
      if (isLocked(flags.italic)) {
        messageObject.font.italic = font.italic;
      }
      if (isLocked(flags.smallCaps)) {
        return messageObject.font.smallCaps = font.smallCaps;
      }
    };


    /**
    * @method commandCreateMessageArea
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCreateMessageArea = function() {
      var messageArea, number, scene;
      number = this.interpreter.numberValueOf(this.params.number);
      scene = SceneManager.scene;
      scene.behavior.changeMessageAreaDomain(this.params.numberDomain);
      if (!scene.messageAreas[number]) {
        messageArea = new gs.Object_MessageArea();
        messageArea.layout = ui.UIManager.createControlFromDescriptor({
          type: "ui.CustomGameMessage",
          id: "customGameMessage_" + number,
          params: {
            id: "customGameMessage_" + number
          }
        }, messageArea);
        messageArea.message = gs.ObjectManager.current.objectById("customGameMessage_" + number + "_message");
        messageArea.message.domain = this.params.numberDomain;
        messageArea.addObject(messageArea.layout);
        messageArea.layout.dstRect.x = this.params.box.x;
        messageArea.layout.dstRect.y = this.params.box.y;
        messageArea.layout.dstRect.width = this.params.box.size.width;
        messageArea.layout.dstRect.height = this.params.box.size.height;
        messageArea.layout.needsUpdate = true;
        return scene.messageAreas[number] = messageArea;
      }
    };


    /**
    * @method commandEraseMessageArea
    * @protected
     */

    Component_CommandInterpreter.prototype.commandEraseMessageArea = function() {
      var area, number, scene;
      number = this.interpreter.numberValueOf(this.params.number);
      scene = SceneManager.scene;
      scene.behavior.changeMessageAreaDomain(this.params.numberDomain);
      area = scene.messageAreas[number];
      if (area != null) {
        area.layout.dispose();
      }
      return scene.messageAreas[number] = null;
    };


    /**
    * @method commandSetTargetMessage
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSetTargetMessage = function() {
      var message, ref, ref1, scene, target;
      message = this.interpreter.targetMessage();
      if (message != null) {
        message.textRenderer.isWaiting = false;
      }
      if (message != null) {
        message.behavior.isWaiting = false;
      }
      scene = SceneManager.scene;
      scene.behavior.changeMessageAreaDomain(this.params.numberDomain);
      target = {
        type: this.params.type,
        id: null
      };
      switch (this.params.type) {
        case 0:
          target.id = this.params.id;
          break;
        case 1:
          target.id = this.interpreter.numberValueOf(this.params.number);
      }
      this.interpreter.settings.message.target = target;
      if (this.params.clear) {
        if ((ref = this.interpreter.targetMessage()) != null) {
          ref.behavior.clear();
        }
      }
      return (ref1 = this.interpreter.targetMessage()) != null ? ref1.visible = true : void 0;
    };


    /**
    * @method commandBacklogVisibility
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBacklogVisibility = function() {
      var control;
      if (this.params.visible) {
        control = gs.ObjectManager.current.objectById("backlogBox");
        if (control == null) {
          control = gs.ObjectManager.current.objectById("backlog");
        }
        if (control != null) {
          control.dispose();
        }
        if (this.params.backgroundVisible) {
          return control = SceneManager.scene.behavior.createControl(this, {
            descriptor: "ui.MessageBacklogBox"
          });
        } else {
          return control = SceneManager.scene.behavior.createControl(this, {
            descriptor: "ui.MessageBacklog"
          });
        }
      } else {
        control = gs.ObjectManager.current.objectById("backlogBox");
        if (control == null) {
          control = gs.ObjectManager.current.objectById("backlog");
        }
        if (control == null) {
          control = gs.ObjectManager.current.objectById("backlogScrollView");
        }
        return control != null ? control.dispose() : void 0;
      }
    };


    /**
    * @method commandMessageVisibility
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMessageVisibility = function() {
      var animation, defaults, duration, easing, flags, isLocked, message;
      defaults = GameManager.defaults.messageBox;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      message = this.interpreter.targetMessage();
      if ((message == null) || this.params.visible === message.visible) {
        return;
      }
      if (this.params.visible) {
        duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
        easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromObject(this.params.easing) : gs.Easings.fromObject(defaults.appearEasing);
        animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
        message.animator.appear(message.dstRect.x, message.dstRect.y, this.params.animation, easing, duration);
      } else {
        duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.disappearDuration;
        easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromObject(this.params.easing) : gs.Easings.fromObject(defaults.disappearEasing);
        animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.disappearAnimation;
        message.animator.disappear(animation, easing, duration, function() {
          return message.visible = false;
        });
      }
      message.update();
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMessageBoxVisibility
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMessageBoxVisibility = function() {
      var animation, defaults, duration, easing, flags, isLocked, messageBox, visible;
      defaults = GameManager.defaults.messageBox;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      messageBox = this.interpreter.messageBoxObject(this.interpreter.stringValueOf(this.params.id));
      visible = this.params.visible === 1;
      if ((messageBox == null) || visible === messageBox.visible) {
        return;
      }
      if (this.params.visible) {
        duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
        easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromObject(this.params.easing) : gs.Easings.fromObject(defaults.appearEasing);
        animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
        messageBox.animator.appear(messageBox.dstRect.x, messageBox.dstRect.y, animation, easing, duration);
      } else {
        duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.disappearDuration;
        easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromObject(this.params.easing) : gs.Easings.fromObject(defaults.disappearEasing);
        animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.disappearAnimation;
        messageBox.animator.disappear(animation, easing, duration, function() {
          return messageBox.visible = false;
        });
      }
      messageBox.update();
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandUIAccess
    * @protected
     */

    Component_CommandInterpreter.prototype.commandUIAccess = function() {
      var flags, isLocked;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.generalMenu)) {
        GameManager.tempSettings.menuAccess = this.interpreter.booleanValueOf(this.params.generalMenu);
      }
      if (!isLocked(flags.saveMenu)) {
        GameManager.tempSettings.saveMenuAccess = this.interpreter.booleanValueOf(this.params.saveMenu);
      }
      if (!isLocked(flags.loadMenu)) {
        GameManager.tempSettings.loadMenuAccess = this.interpreter.booleanValueOf(this.params.loadMenu);
      }
      if (!isLocked(flags.backlog)) {
        return GameManager.tempSettings.backlogAccess = this.interpreter.booleanValueOf(this.params.backlog);
      }
    };


    /**
    * @method commandUnlockCG
    * @protected
     */

    Component_CommandInterpreter.prototype.commandUnlockCG = function() {
      var cg;
      cg = RecordManager.cgGallery[this.interpreter.stringValueOf(this.params.cgId)];
      if (cg != null) {
        GameManager.globalData.cgGallery[cg.index] = {
          unlocked: true
        };
        return GameManager.saveGlobalData();
      }
    };


    /**
    * @method commandL2DMove
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DMove = function() {
      var character, scene;
      scene = SceneManager.scene;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === _this.params.characterId;
        };
      })(this));
      if (!character instanceof vn.Object_Live2DCharacter) {
        return;
      }
      this.interpreter.moveObject(character, this.params.position, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DMotionGroup
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DMotionGroup = function() {
      var character, motions, scene;
      scene = SceneManager.scene;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === _this.params.characterId;
        };
      })(this));
      if (!character instanceof vn.Object_Live2DCharacter) {
        return;
      }
      character.motionGroup = {
        name: this.params.data.motionGroup,
        loop: this.params.loop,
        playType: this.params.playType
      };
      if (this.params.waitForCompletion && !this.params.loop) {
        motions = character.model.motionsByGroup[character.motionGroup.name];
        if (motions != null) {
          this.interpreter.isWaiting = true;
          this.interpreter.waitCounter = motions.sum(function(m) {
            return m.getDurationMSec() / 16.6;
          });
        }
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DMotion
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DMotion = function() {
      var character, defaults, fadeInTime, flags, isLocked, motion, scene;
      defaults = GameManager.defaults.live2d;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === _this.params.characterId;
        };
      })(this));
      if (!character instanceof vn.Object_Live2DCharacter) {
        return;
      }
      fadeInTime = !isLocked(flags.fadeInTime) ? this.params.fadeInTime : defaults.motionFadeInTime;
      character.motion = {
        name: this.params.data.motion,
        fadeInTime: fadeInTime,
        loop: this.params.loop
      };
      character.motionGroup = null;
      if (this.params.waitForCompletion && !this.params.loop) {
        motion = character.model.motions[character.motion.name];
        if (motion != null) {
          this.interpreter.isWaiting = true;
          this.interpreter.waitCounter = motion.getDurationMSec() / 16.6;
        }
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DExpression
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DExpression = function() {
      var character, defaults, fadeInTime, flags, isLocked, scene;
      defaults = GameManager.defaults.live2d;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === _this.params.characterId;
        };
      })(this));
      if (!character instanceof vn.Object_Live2DCharacter) {
        return;
      }
      fadeInTime = !isLocked(flags.fadeInTime) ? this.params.fadeInTime : defaults.expressionFadeInTime;
      character.expression = {
        name: this.params.data.expression,
        fadeInTime: fadeInTime
      };
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DExitScene
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DExitScene = function() {
      var defaults;
      defaults = GameManager.defaults.live2d;
      this.interpreter.commandCharacterExitScene.call(this, defaults);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DSettings
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DSettings = function() {
      var character, flags, isLocked, scene;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === _this.params.characterId;
        };
      })(this));
      if (!(character != null ? character.visual.l2dObject : void 0)) {
        return;
      }
      if (!isLocked(flags.lipSyncSensitivity)) {
        character.visual.l2dObject.lipSyncSensitivity = this.interpreter.numberValueOf(this.params.lipSyncSensitivity);
      }
      if (!isLocked(flags.idleIntensity)) {
        character.visual.l2dObject.idleIntensity = this.interpreter.numberValueOf(this.params.idleIntensity);
      }
      if (!isLocked(flags.breathIntensity)) {
        character.visual.l2dObject.breathIntensity = this.interpreter.numberValueOf(this.params.breathIntensity);
      }
      if (!isLocked(flags["eyeBlink.enabled"])) {
        character.visual.l2dObject.eyeBlink.enabled = this.params.eyeBlink.enabled;
      }
      if (!isLocked(flags["eyeBlink.interval"])) {
        character.visual.l2dObject.eyeBlink.blinkIntervalMsec = this.interpreter.numberValueOf(this.params.eyeBlink.interval);
      }
      if (!isLocked(flags["eyeBlink.closedMotionTime"])) {
        character.visual.l2dObject.eyeBlink.closedMotionMsec = this.interpreter.numberValueOf(this.params.eyeBlink.closedMotionTime);
      }
      if (!isLocked(flags["eyeBlink.closingMotionTime"])) {
        character.visual.l2dObject.eyeBlink.closingMotionMsec = this.interpreter.numberValueOf(this.params.eyeBlink.closingMotionTime);
      }
      if (!isLocked(flags["eyeBlink.openingMotionTime"])) {
        character.visual.l2dObject.eyeBlink.openingMotionMsec = this.interpreter.numberValueOf(this.params.eyeBlink.openingMotionTime);
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DParameter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DParameter = function() {
      var character, duration, easing, scene;
      scene = SceneManager.scene;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === _this.params.characterId;
        };
      })(this));
      if (!character instanceof vn.Object_Live2DCharacter) {
        return;
      }
      easing = gs.Easings.fromObject(this.params.easing);
      duration = this.interpreter.durationValueOf(this.params.duration);
      character.animator.l2dParameterTo(this.params.param.name, this.interpreter.numberValueOf(this.params.param.value), duration, easing);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DDefaults
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.live2d;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.appearDuration)) {
        defaults.appearDuration = this.interpreter.durationValueOf(this.params.appearDuration);
      }
      if (!isLocked(flags.disappearDuration)) {
        defaults.disappearDuration = this.interpreter.durationValueOf(this.params.disappearDuration);
      }
      if (!isLocked(flags.zOrder)) {
        defaults.zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      }
      if (!isLocked(flags.motionFadeInTime)) {
        defaults.motionFadeInTime = this.interpreter.numberValueOf(this.params.motionFadeInTime);
      }
      if (!isLocked(flags["appearEasing.type"])) {
        defaults.appearEasing = this.params.appearEasing;
      }
      if (!isLocked(flags["appearAnimation.type"])) {
        defaults.appearAnimation = this.params.appearAnimation;
      }
      if (!isLocked(flags["disappearEasing.type"])) {
        defaults.disappearEasing = this.params.disappearEasing;
      }
      if (!isLocked(flags["disappearAnimation.type"])) {
        defaults.disappearAnimation = this.params.disappearAnimation;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandL2DJoinScene
    * @protected
     */

    Component_CommandInterpreter.prototype.commandL2DJoinScene = function() {
      var animation, character, defaults, duration, easing, flags, instant, isLocked, motionBlur, noAnim, origin, p, record, ref, ref1, ref2, ref3, ref4, ref5, scene, x, y, zIndex;
      defaults = GameManager.defaults.live2d;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      record = RecordManager.characters[this.interpreter.stringValueOf(this.params.characterId)];
      if (!record || scene.characters.first(function(v) {
        return !v.disposed && v.rid === record.index;
      })) {
        return;
      }
      if (this.params.positionType === 1) {
        x = this.params.position.x;
        y = this.params.position.y;
      } else if (this.params.positionType === 2) {
        x = this.interpreter.numberValueOf(this.params.position.x);
        y = this.interpreter.numberValueOf(this.params.position.y);
      }
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.appearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
      zIndex = !isLocked(flags.zOrder) ? this.interpreter.numberValueOf(this.params.zOrder) : defaults.zOrder;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
      motionBlur = !isLocked(flags["motionBlur.enabled"]) ? this.params.motionBlur : defaults.motionBlur;
      origin = !isLocked(flags.origin) ? this.params.origin : defaults.origin;
      instant = duration === 0 || this.interpreter.isInstantSkip();
      noAnim = duration === 0 || GameManager.tempSettings.skip;
      if (this.params.waitForCompletion && !instant) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      character = new vn.Object_Live2DCharacter(record);
      character.modelName = ((ref = this.params.model) != null ? ref.name : void 0) || "";
      character.model = ResourceManager.getLive2DModel("Live2D/" + character.modelName);
      if (character.model.motions) {
        character.motion = {
          name: "",
          fadeInTime: 0,
          loop: true
        };
      }
      character.dstRect.x = x;
      character.dstRect.y = y;
      character.anchor.x = !origin ? 0 : 0.5;
      character.anchor.y = !origin ? 0 : 0.5;
      character.blendMode = this.interpreter.numberValueOf(this.params.blendMode);
      character.zoom.x = this.params.position.zoom.d;
      character.zoom.y = this.params.position.zoom.d;
      character.zIndex = zIndex || 200;
      if ((ref1 = character.model) != null) {
        ref1.reset();
      }
      character.setup();
      character.visual.l2dObject.idleIntensity = (ref2 = record.idleIntensity) != null ? ref2 : 1.0;
      character.visual.l2dObject.breathIntensity = (ref3 = record.breathIntensity) != null ? ref3 : 1.0;
      character.visual.l2dObject.lipSyncSensitivity = (ref4 = record.lipSyncSensitivity) != null ? ref4 : 1.0;
      character.update();
      if (this.params.positionType === 0) {
        p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, character, this.params);
        character.dstRect.x = p.x;
        character.dstRect.y = p.y;
      }
      scene.behavior.addCharacter(character, noAnim, {
        animation: animation,
        duration: duration,
        easing: easing,
        motionBlur: motionBlur
      });
      if (((ref5 = this.params.viewport) != null ? ref5.type : void 0) === "ui") {
        character.viewport = Graphics.viewport;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandCharacterJoinScene
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterJoinScene = function() {
      var angle, animation, bitmap, character, characterId, defaults, duration, easing, expressionId, flags, instant, isLocked, mirror, motionBlur, noAnim, origin, p, record, ref, ref1, ref2, ref3, ref4, ref5, scene, x, y, zIndex, zoom;
      defaults = GameManager.defaults.character;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      expressionId = this.interpreter.stringValueOf(this.params.expressionId) || this.params.expressionId;
      record = RecordManager.characters[characterId];
      if (!record || scene.characters.first(function(v) {
        return !v.disposed && v.rid === record.index && !v.disposed;
      })) {
        return;
      }
      character = new vn.Object_Character(record, null, scene);
      character.expression = RecordManager.characterExpressions[expressionId != null ? expressionId : record.defaultExpressionId || 0];
      if ((ref = character.expression) != null ? (ref1 = ref.idle[0]) != null ? ref1.resource.name : void 0 : void 0) {
        bitmap = ResourceManager.getBitmap("Graphics/Characters/" + character.expression.idle[0].resource.name);
      }
      mirror = false;
      angle = 0;
      zoom = 1;
      if (this.params.positionType === 1) {
        x = this.interpreter.numberValueOf(this.params.position.x);
        y = this.interpreter.numberValueOf(this.params.position.y);
        mirror = this.params.position.horizontalFlip;
        angle = this.params.position.angle || 0;
        zoom = ((ref2 = this.params.position.data) != null ? ref2.zoom : void 0) || 1;
      } else if (this.params.positionType === 2) {
        x = this.interpreter.numberValueOf(this.params.position.x);
        y = this.interpreter.numberValueOf(this.params.position.y);
        mirror = false;
        angle = 0;
        zoom = 1;
      }
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.appearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
      origin = !isLocked(flags.origin) ? this.params.origin : defaults.origin;
      zIndex = !isLocked(flags.zOrder) ? this.interpreter.numberValueOf(this.params.zOrder) : defaults.zOrder;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
      motionBlur = !isLocked(flags["motionBlur.enabled"]) ? this.params.motionBlur : defaults.motionBlur;
      instant = duration === 0 || this.interpreter.isInstantSkip();
      noAnim = duration === 0 || GameManager.tempSettings.skip;
      if (this.params.waitForCompletion && !instant) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      if ((ref3 = character.expression) != null ? (ref4 = ref3.idle[0]) != null ? ref4.resource.name : void 0 : void 0) {
        bitmap = ResourceManager.getBitmap("Graphics/Characters/" + character.expression.idle[0].resource.name);
        if (origin === 1 && (bitmap != null)) {
          x += (bitmap.width * zoom - bitmap.width) / 2;
          y += (bitmap.height * zoom - bitmap.height) / 2;
        }
      }
      character.mirror = mirror;
      character.anchor.x = !origin ? 0 : 0.5;
      character.anchor.y = !origin ? 0 : 0.5;
      character.zoom.x = zoom;
      character.zoom.y = zoom;
      character.dstRect.x = x;
      character.dstRect.y = y;
      character.zIndex = zIndex || 200;
      character.blendMode = this.interpreter.numberValueOf(this.params.blendMode);
      character.angle = angle;
      character.setup();
      character.update();
      if (this.params.positionType === 0) {
        p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, character, this.params);
        character.dstRect.x = p.x;
        character.dstRect.y = p.y;
      }
      scene.behavior.addCharacter(character, noAnim, {
        animation: animation,
        duration: duration,
        easing: easing,
        motionBlur: motionBlur
      });
      if (((ref5 = this.params.viewport) != null ? ref5.type : void 0) === "ui") {
        character.viewport = Graphics.viewport;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandCharacterExitScene
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterExitScene = function(defaults) {
      var animation, character, characterId, duration, easing, flags, instant, isLocked, noAnim, scene;
      defaults = defaults || GameManager.defaults.character;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      scene = SceneManager.scene;
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.disappearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.disappearDuration;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.disappearAnimation;
      instant = duration === 0 || this.interpreter.isInstantSkip();
      noAnim = duration === 0 || GameManager.tempSettings.skip;
      if (this.params.waitForCompletion && !instant) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      scene.behavior.removeCharacter(character, noAnim, {
        animation: animation,
        duration: duration,
        easing: easing
      });
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandCharacterChangeExpression
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterChangeExpression = function() {
      var animation, character, characterId, defaults, duration, easing, expression, flags, isLocked, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      defaults = GameManager.defaults.character;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.expressionDuration;
      expression = RecordManager.characterExpressions[this.params.expressionId || 0];
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromObject(this.params.easing) : gs.Easings.fromObject(defaults.changeEasing);
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.changeAnimation;
      character.behavior.changeExpression(expression, this.params.animation, easing, duration);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandCharacterSetParameter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterSetParameter = function() {
      var params, value;
      params = GameManager.characterParams[this.interpreter.stringValueOf(this.params.characterId)];
      if ((params == null) || (this.params.param == null)) {
        return;
      }
      switch (this.params.valueType) {
        case 0:
          switch (this.params.param.type) {
            case 0:
              return params[this.params.param.name] = this.interpreter.numberValueOf(this.params.numberValue);
            case 1:
              return params[this.params.param.name] = this.interpreter.numberValueOf(this.params.numberValue) > 0;
            case 2:
              return params[this.params.param.name] = this.interpreter.numberValueOf(this.params.numberValue).toString();
          }
          break;
        case 1:
          switch (this.params.param.type) {
            case 0:
              value = this.interpreter.booleanValueOf(this.params.switchValue);
              return params[this.params.param.name] = value ? 1 : 0;
            case 1:
              return params[this.params.param.name] = this.interpreter.booleanValueOf(this.params.switchValue);
            case 2:
              value = this.interpreter.booleanValueOf(this.params.switchValue);
              return params[this.params.param.name] = value ? "ON" : "OFF";
          }
          break;
        case 2:
          switch (this.params.param.type) {
            case 0:
              value = this.interpreter.stringValueOf(this.params.textValue);
              return params[this.params.param.name] = value.length;
            case 1:
              return params[this.params.param.name] = this.interpreter.stringValueOf(this.params.textValue) === "ON";
            case 2:
              return params[this.params.param.name] = this.interpreter.stringValueOf(this.params.textValue);
          }
      }
    };


    /**
    * @method commandCharacterGetParameter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterGetParameter = function() {
      var params, value;
      params = GameManager.characterParams[this.interpreter.stringValueOf(this.params.characterId)];
      if ((params == null) || (this.params.param == null)) {
        return;
      }
      value = params[this.params.param.name];
      switch (this.params.valueType) {
        case 0:
          switch (this.params.param.type) {
            case 0:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, value);
            case 1:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, value ? 1 : 0);
            case 2:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, value != null ? value.length : 0);
          }
          break;
        case 1:
          switch (this.params.param.type) {
            case 0:
              return this.interpreter.setBooleanValueTo(this.params.targetVariable, value > 0);
            case 1:
              return this.interpreter.setBooleanValueTo(this.params.targetVariable, value);
            case 2:
              return this.interpreter.setBooleanValueTo(this.params.targetVariable, value === "ON");
          }
          break;
        case 2:
          switch (this.params.param.type) {
            case 0:
              return this.interpreter.setStringValueTo(this.params.targetVariable, value != null ? value.toString() : "");
            case 1:
              return this.interpreter.setStringValueTo(this.params.targetVariable, value ? "ON" : "OFF");
            case 2:
              return this.interpreter.setStringValueTo(this.params.targetVariable, value);
          }
      }
    };


    /**
    * @method commandCharacterMotionBlur
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterMotionBlur = function() {
      var character, characterId, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      return character.motionBlur.set(this.params.motionBlur);
    };


    /**
    * @method commandCharacterDefaults
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.character;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.appearDuration)) {
        defaults.appearDuration = this.interpreter.durationValueOf(this.params.appearDuration);
      }
      if (!isLocked(flags.disappearDuration)) {
        defaults.disappearDuration = this.interpreter.durationValueOf(this.params.disappearDuration);
      }
      if (!isLocked(flags.expressionDuration)) {
        defaults.expressionDuration = this.interpreter.durationValueOf(this.params.expressionDuration);
      }
      if (!isLocked(flags.zOrder)) {
        defaults.zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      }
      if (!isLocked(flags["appearEasing.type"])) {
        defaults.appearEasing = this.params.appearEasing;
      }
      if (!isLocked(flags["appearAnimation.type"])) {
        defaults.appearAnimation = this.params.appearAnimation;
      }
      if (!isLocked(flags["disappearEasing.type"])) {
        defaults.disappearEasing = this.params.disappearEasing;
      }
      if (!isLocked(flags["disappearAnimation.type"])) {
        defaults.disappearAnimation = this.params.disappearAnimation;
      }
      if (!isLocked(flags["motionBlur.enabled"])) {
        defaults.motionBlur = this.params.motionBlur;
      }
      if (!isLocked(flags.origin)) {
        return defaults.origin = this.params.origin;
      }
    };


    /**
    * @method commandCharacterEffect
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCharacterEffect = function() {
      var character, characterId, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first(function(c) {
        return !c.disposed && c.rid === characterId;
      });
      if (character == null) {
        return;
      }
      this.interpreter.objectEffect(character, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandFlashCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandFlashCharacter = function() {
      var character, characterId, duration, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (!character) {
        return;
      }
      duration = this.interpreter.durationValueOf(this.params.duration);
      character.animator.flash(new Color(this.params.color), duration);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandTintCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTintCharacter = function() {
      var character, characterId, duration, easing, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      easing = gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut);
      if (!character) {
        return;
      }
      duration = this.interpreter.durationValueOf(this.params.duration);
      character.animator.tintTo(this.params.tone, duration, easing);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandZoomCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandZoomCharacter = function() {
      var character, characterId, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      this.interpreter.zoomObject(character, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandRotateCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandRotateCharacter = function() {
      var character, characterId, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      this.interpreter.rotateObject(character, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandBlendCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBlendCharacter = function() {
      var character, characterId;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = SceneManager.scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      this.interpreter.blendObject(character, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandShakeCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShakeCharacter = function() {
      var character, characterId;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = SceneManager.scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      this.interpreter.shakeObject(character, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMaskCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMaskCharacter = function() {
      var character, characterId, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      this.interpreter.maskObject(character, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMoveCharacter
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMoveCharacter = function() {
      var character, characterId, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      this.interpreter.moveObject(character, this.params.position, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMoveCharacterPath
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMoveCharacterPath = function() {
      var character, characterId, scene;
      scene = SceneManager.scene;
      characterId = this.interpreter.stringValueOf(this.params.characterId);
      character = scene.characters.first((function(_this) {
        return function(v) {
          return !v.disposed && v.rid === characterId;
        };
      })(this));
      if (character == null) {
        return;
      }
      this.interpreter.moveObjectPath(character, this.params.path, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandShakeBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShakeBackground = function() {
      var background;
      background = SceneManager.scene.backgrounds[this.interpreter.numberValueOf(this.params.layer)];
      if (background == null) {
        return;
      }
      this.interpreter.shakeObject(background, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandScrollBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandScrollBackground = function() {
      var duration, easing, horizontalSpeed, layer, ref, scene, verticalSpeed;
      scene = SceneManager.scene;
      duration = this.interpreter.durationValueOf(this.params.duration);
      horizontalSpeed = this.interpreter.numberValueOf(this.params.horizontalSpeed);
      verticalSpeed = this.interpreter.numberValueOf(this.params.verticalSpeed);
      easing = gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut);
      layer = this.interpreter.numberValueOf(this.params.layer);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      if ((ref = scene.backgrounds[layer]) != null) {
        ref.animator.move(horizontalSpeed, verticalSpeed, duration, easing);
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandScrollBackgroundTo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandScrollBackgroundTo = function() {
      var background, duration, easing, layer, p, scene, x, y;
      scene = SceneManager.scene;
      duration = this.interpreter.durationValueOf(this.params.duration);
      x = this.interpreter.numberValueOf(this.params.background.location.x);
      y = this.interpreter.numberValueOf(this.params.background.location.y);
      easing = gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut);
      layer = this.interpreter.numberValueOf(this.params.layer);
      background = scene.backgrounds[layer];
      if (!background) {
        return;
      }
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      if (this.params.positionType === 0) {
        p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, background, this.params);
        x = p.x;
        y = p.y;
      }
      background.animator.moveTo(x, y, duration, easing);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandScrollBackgroundPath
    * @protected
     */

    Component_CommandInterpreter.prototype.commandScrollBackgroundPath = function() {
      var background, scene;
      scene = SceneManager.scene;
      background = scene.backgrounds[this.interpreter.numberValueOf(this.params.layer)];
      if (background == null) {
        return;
      }
      this.interpreter.moveObjectPath(background, this.params.path, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMaskBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMaskBackground = function() {
      var background, scene;
      scene = SceneManager.scene;
      background = scene.backgrounds[this.interpreter.numberValueOf(this.params.layer)];
      if (background == null) {
        return;
      }
      this.interpreter.maskObject(background, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandZoomBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandZoomBackground = function() {
      var duration, easing, layer, ref, scene, x, y;
      scene = SceneManager.scene;
      duration = this.interpreter.durationValueOf(this.params.duration);
      x = this.interpreter.numberValueOf(this.params.zooming.x);
      y = this.interpreter.numberValueOf(this.params.zooming.y);
      easing = gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut);
      layer = this.interpreter.numberValueOf(this.params.layer);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      if ((ref = scene.backgrounds[layer]) != null) {
        ref.animator.zoomTo(x / 100, y / 100, duration, easing);
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandRotateBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandRotateBackground = function() {
      var background, scene;
      scene = SceneManager.scene;
      background = scene.backgrounds[this.interpreter.numberValueOf(this.params.layer)];
      if (background) {
        this.interpreter.rotateObject(background, this.params);
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandTintBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTintBackground = function() {
      var background, duration, easing, layer, scene;
      scene = SceneManager.scene;
      layer = this.interpreter.numberValueOf(this.params.layer);
      background = scene.backgrounds[layer];
      if (background == null) {
        return;
      }
      duration = this.interpreter.durationValueOf(this.params.duration);
      easing = gs.Easings.fromObject(this.params.easing);
      background.animator.tintTo(this.params.tone, duration, easing);
      this.interpreter.waitForCompletion(background, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandBlendBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBlendBackground = function() {
      var background, layer;
      layer = this.interpreter.numberValueOf(this.params.layer);
      background = SceneManager.scene.backgrounds[layer];
      if (background == null) {
        return;
      }
      this.interpreter.blendObject(background, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandBackgroundEffect
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBackgroundEffect = function() {
      var background, layer;
      layer = this.interpreter.numberValueOf(this.params.layer);
      background = SceneManager.scene.backgrounds[layer];
      if (background == null) {
        return;
      }
      this.interpreter.objectEffect(background, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandBackgroundDefaults
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBackgroundDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.background;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.duration)) {
        defaults.duration = this.interpreter.durationValueOf(this.params.duration);
      }
      if (!isLocked(flags.zOrder)) {
        defaults.zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      }
      if (!isLocked(flags["easing.type"])) {
        defaults.easing = this.params.easing;
      }
      if (!isLocked(flags["animation.type"])) {
        defaults.animation = this.params.animation;
      }
      if (!isLocked(flags.origin)) {
        defaults.origin = this.params.origin;
      }
      if (!isLocked(flags.loopHorizontal)) {
        defaults.loopHorizontal = this.params.loopHorizontal;
      }
      if (!isLocked(flags.loopVertical)) {
        return defaults.loopVertical = this.params.loopVertical;
      }
    };


    /**
    * @method commandBackgroundMotionBlur
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBackgroundMotionBlur = function() {
      var background, layer;
      layer = this.interpreter.numberValueOf(this.params.layer);
      background = SceneManager.scene.backgrounds[layer];
      if (background == null) {
        return;
      }
      return background.motionBlur.set(this.params.motionBlur);
    };


    /**
    * @method commandChangeBackground
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeBackground = function() {
      var animation, defaults, duration, easing, flags, isLocked, layer, loopH, loopV, origin, ref, scene, zIndex;
      defaults = GameManager.defaults.background;
      scene = SceneManager.scene;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.duration;
      loopH = !isLocked(flags.loopHorizontal) ? this.params.loopHorizontal : defaults.loopHorizontal;
      loopV = !isLocked(flags.loopVertical) ? this.params.loopVertical : defaults.loopVertical;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.animation;
      origin = !isLocked(flags.origin) ? this.params.origin : defaults.origin;
      zIndex = !isLocked(flags.zOrder) ? this.interpreter.numberValueOf(this.params.zOrder) : defaults.zOrder;
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromObject(this.params.easing) : gs.Easings.fromObject(defaults.easing);
      layer = this.interpreter.numberValueOf(this.params.layer);
      scene.behavior.changeBackground(this.params.graphic, false, animation, easing, duration, 0, 0, layer, loopH, loopV);
      if (scene.backgrounds[layer]) {
        if (((ref = this.params.viewport) != null ? ref.type : void 0) === "ui") {
          scene.backgrounds[layer].viewport = Graphics.viewport;
        }
        scene.backgrounds[layer].anchor.x = origin === 0 ? 0 : 0.5;
        scene.backgrounds[layer].anchor.y = origin === 0 ? 0 : 0.5;
        scene.backgrounds[layer].blendMode = this.interpreter.numberValueOf(this.params.blendMode);
        scene.backgrounds[layer].zIndex = zIndex + layer;
        if (origin === 1) {
          scene.backgrounds[layer].dstRect.x = scene.backgrounds[layer].dstRect.x;
          scene.backgrounds[layer].dstRect.y = scene.backgrounds[layer].dstRect.y;
        }
        scene.backgrounds[layer].setup();
        scene.backgrounds[layer].update();
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandCallScene
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCallScene = function() {
      return this.interpreter.callScene(this.interpreter.stringValueOf(this.params.scene.uid || this.params.scene));
    };


    /**
    * @method commandChangeScene
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeScene = function() {
      var flags, isLocked, k, len, len1, n, newScene, picture, ref, ref1, scene, uid, video;
      if (GameManager.inLivePreview) {
        return;
      }
      GameManager.tempSettings.skip = false;
      if (!this.params.savePrevious) {
        SceneManager.clear();
      }
      scene = SceneManager.scene;
      if (!this.params.erasePictures && !this.params.savePrevious) {
        scene.removeObject(scene.pictureContainer);
        ref = scene.pictures;
        for (k = 0, len = ref.length; k < len; k++) {
          picture = ref[k];
          if (picture) {
            ResourceManager.context.remove("Graphics/Pictures/" + picture.image);
          }
        }
      }
      if (!this.params.eraseTexts && !this.params.savePrevious) {
        scene.removeObject(scene.textContainer);
      }
      if (!this.params.eraseVideos && !this.params.savePrevious) {
        scene.removeObject(scene.videoContainer);
        ref1 = scene.videos;
        for (n = 0, len1 = ref1.length; n < len1; n++) {
          video = ref1[n];
          if (video) {
            ResourceManager.context.remove("Movies/" + video.video);
          }
        }
      }
      if (this.params.scene) {
        if (this.params.savePrevious) {
          GameManager.sceneData = {
            uid: uid = this.params.scene.uid,
            pictures: [],
            texts: [],
            videos: []
          };
        } else {
          GameManager.sceneData = {
            uid: uid = this.params.scene.uid,
            pictures: scene.pictureContainer.subObjectsByDomain,
            texts: scene.textContainer.subObjectsByDomain,
            videos: scene.videoContainer.subObjectsByDomain
          };
        }
        flags = this.params.fieldFlags || {};
        isLocked = gs.CommandFieldFlags.isLocked;
        newScene = new vn.Object_Scene();
        if (this.params.savePrevious) {
          newScene.sceneData = {
            uid: uid = this.params.scene.uid,
            pictures: [],
            texts: [],
            videos: [],
            backlog: GameManager.backlog
          };
        } else {
          newScene.sceneData = {
            uid: uid = this.params.scene.uid,
            pictures: scene.pictureContainer.subObjectsByDomain,
            texts: scene.textContainer.subObjectsByDomain,
            videos: scene.videoContainer.subObjectsByDomain
          };
        }
        SceneManager.switchTo(newScene, this.params.savePrevious, (function(_this) {
          return function() {
            return _this.interpreter.isWaiting = false;
          };
        })(this));
      } else {
        SceneManager.switchTo(null);
      }
      return this.interpreter.isWaiting = true;
    };


    /**
    * @method commandReturnToPreviousScene
    * @protected
     */

    Component_CommandInterpreter.prototype.commandReturnToPreviousScene = function() {
      if (GameManager.inLivePreview) {
        return;
      }
      SceneManager.returnToPrevious((function(_this) {
        return function() {
          return _this.interpreter.isWaiting = false;
        };
      })(this));
      return this.interpreter.isWaiting = true;
    };


    /**
    * @method commandSwitchToLayout
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSwitchToLayout = function() {
      var scene;
      if (GameManager.inLivePreview) {
        return;
      }
      if (ui.UIManager.layouts[this.params.layout.name] != null) {
        scene = new gs.Object_Layout(this.params.layout.name);
        SceneManager.switchTo(scene, this.params.savePrevious, (function(_this) {
          return function() {
            return _this.interpreter.isWaiting = false;
          };
        })(this));
        return this.interpreter.isWaiting = true;
      }
    };


    /**
    * @method commandChangeTransition
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeTransition = function() {
      var flags, isLocked;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.duration)) {
        SceneManager.transitionData.duration = this.interpreter.durationValueOf(this.params.duration);
      }
      if (!isLocked(flags.graphic)) {
        SceneManager.transitionData.graphic = this.params.graphic;
      }
      if (!isLocked(flags.vague)) {
        return SceneManager.transitionData.vague = this.params.vague;
      }
    };


    /**
    * @method commandFreezeScreen
    * @protected
     */

    Component_CommandInterpreter.prototype.commandFreezeScreen = function() {
      return Graphics.freeze();
    };


    /**
    * @method commandScreenTransition
    * @protected
     */

    Component_CommandInterpreter.prototype.commandScreenTransition = function() {
      var bitmap, defaults, duration, flags, graphicName, isLocked, ref, ref1, vague;
      defaults = GameManager.defaults.scene;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      graphicName = !isLocked(flags.graphic) ? (ref = this.params.graphic) != null ? ref.name : void 0 : (ref1 = SceneManager.transitionData.graphic) != null ? ref1.name : void 0;
      if (graphicName) {
        bitmap = !isLocked(flags.graphic) ? ResourceManager.getBitmap("Graphics/Masks/" + graphicName) : ResourceManager.getBitmap("Graphics/Masks/" + graphicName);
      }
      vague = !isLocked(flags.vague) ? this.interpreter.numberValueOf(this.params.vague) : SceneManager.transitionData.vague;
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : SceneManager.transitionData.duration;
      this.interpreter.isWaiting = !GameManager.inLivePreview;
      this.interpreter.waitCounter = duration;
      return Graphics.transition(duration, bitmap, vague);
    };


    /**
    * @method commandShakeScreen
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShakeScreen = function() {
      if (SceneManager.scene.viewport == null) {
        return;
      }
      this.interpreter.shakeObject(SceneManager.scene.viewport, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandTintScreen
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTintScreen = function() {
      var duration;
      duration = this.interpreter.durationValueOf(this.params.duration);
      SceneManager.scene.viewport.animator.tintTo(new Tone(this.params.tone), duration, gs.Easings.EASE_LINEAR[0]);
      if (this.params.waitForCompletion && duration > 0) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandZoomScreen
    * @protected
     */

    Component_CommandInterpreter.prototype.commandZoomScreen = function() {
      var duration, easing, scene;
      easing = gs.Easings.fromObject(this.params.easing);
      duration = this.interpreter.durationValueOf(this.params.duration);
      scene = SceneManager.scene;
      SceneManager.scene.viewport.anchor.x = 0.5;
      SceneManager.scene.viewport.anchor.y = 0.5;
      SceneManager.scene.viewport.animator.zoomTo(this.interpreter.numberValueOf(this.params.zooming.x) / 100, this.interpreter.numberValueOf(this.params.zooming.y) / 100, duration, easing);
      this.interpreter.waitForCompletion(null, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandPanScreen
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPanScreen = function() {
      var duration, easing, scene, viewport;
      scene = SceneManager.scene;
      duration = this.interpreter.durationValueOf(this.params.duration);
      easing = gs.Easings.fromObject(this.params.easing);
      this.interpreter.settings.screen.pan.x -= this.params.position.x;
      this.interpreter.settings.screen.pan.y -= this.params.position.y;
      viewport = SceneManager.scene.viewport;
      viewport.animator.scrollTo(-this.params.position.x + viewport.dstRect.x, -this.params.position.y + viewport.dstRect.y, duration, easing);
      this.interpreter.waitForCompletion(null, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandRotateScreen
    * @protected
     */

    Component_CommandInterpreter.prototype.commandRotateScreen = function() {
      var duration, easing, pan, scene;
      scene = SceneManager.scene;
      easing = gs.Easings.fromObject(this.params.easing);
      duration = this.interpreter.durationValueOf(this.params.duration);
      pan = this.interpreter.settings.screen.pan;
      SceneManager.scene.viewport.anchor.x = 0.5;
      SceneManager.scene.viewport.anchor.y = 0.5;
      SceneManager.scene.viewport.animator.rotate(this.params.direction, this.interpreter.numberValueOf(this.params.speed) / 100, duration, easing);
      this.interpreter.waitForCompletion(null, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandFlashScreen
    * @protected
     */

    Component_CommandInterpreter.prototype.commandFlashScreen = function() {
      var duration;
      duration = this.interpreter.durationValueOf(this.params.duration);
      SceneManager.scene.viewport.animator.flash(new Color(this.params.color), duration, gs.Easings.EASE_LINEAR[0]);
      if (this.params.waitForCompletion && duration !== 0) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandScreenEffect
    * @protected
     */

    Component_CommandInterpreter.prototype.commandScreenEffect = function() {
      var duration, easing, flags, isLocked, scene, viewport, wobble, zOrder;
      scene = SceneManager.scene;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      duration = this.interpreter.durationValueOf(this.params.duration);
      easing = gs.Easings.fromObject(this.params.easing);
      if (!gs.CommandFieldFlags.isLocked(flags.zOrder)) {
        zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      } else {
        zOrder = SceneManager.scene.viewport.zIndex;
      }
      viewport = scene.viewportContainer.subObjects.first(function(v) {
        return v.zIndex === zOrder;
      });
      if (!viewport) {
        viewport = new gs.Object_Viewport();
        viewport.zIndex = zOrder;
        scene.viewportContainer.addObject(viewport);
      }
      switch (this.params.type) {
        case 0:
          viewport.animator.wobbleTo(this.params.wobble.power / 10000, this.params.wobble.speed / 100, duration, easing);
          wobble = viewport.effects.wobble;
          wobble.enabled = this.params.wobble.power > 0;
          wobble.vertical = this.params.wobble.orientation === 0 || this.params.wobble.orientation === 2;
          wobble.horizontal = this.params.wobble.orientation === 1 || this.params.wobble.orientation === 2;
          break;
        case 1:
          viewport.animator.blurTo(this.params.blur.power / 100, duration, easing);
          viewport.effects.blur.enabled = true;
          break;
        case 2:
          viewport.animator.pixelateTo(this.params.pixelate.size.width, this.params.pixelate.size.height, duration, easing);
          viewport.effects.pixelate.enabled = true;
      }
      if (this.params.waitForCompletion && duration !== 0) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandVideoDefaults
    * @protected
     */

    Component_CommandInterpreter.prototype.commandVideoDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.video;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.appearDuration)) {
        defaults.appearDuration = this.interpreter.durationValueOf(this.params.appearDuration);
      }
      if (!isLocked(flags.disappearDuration)) {
        defaults.disappearDuration = this.interpreter.durationValueOf(this.params.disappearDuration);
      }
      if (!isLocked(flags.zOrder)) {
        defaults.zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      }
      if (!isLocked(flags["appearEasing.type"])) {
        defaults.appearEasing = this.params.appearEasing;
      }
      if (!isLocked(flags["appearAnimation.type"])) {
        defaults.appearAnimation = this.params.appearAnimation;
      }
      if (!isLocked(flags["disappearEasing.type"])) {
        defaults.disappearEasing = this.params.disappearEasing;
      }
      if (!isLocked(flags["disappearAnimation.type"])) {
        defaults.disappearAnimation = this.params.disappearAnimation;
      }
      if (!isLocked(flags["motionBlur.enabled"])) {
        defaults.motionBlur = this.params.motionBlur;
      }
      if (!isLocked(flags.origin)) {
        return defaults.origin = this.params.origin;
      }
    };


    /**
    * @method commandShowVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShowVideo = function() {
      var animation, defaults, duration, easing, flags, isLocked, number, origin, p, ref, ref1, ref2, scene, video, videos, x, y, zIndex;
      defaults = GameManager.defaults.video;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      videos = scene.videos;
      if (videos[number] == null) {
        videos[number] = new gs.Object_Video();
      }
      x = this.interpreter.numberValueOf(this.params.position.x);
      y = this.interpreter.numberValueOf(this.params.position.y);
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.appearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
      origin = !isLocked(flags.origin) ? this.params.origin : defaults.origin;
      zIndex = !isLocked(flags.zOrder) ? this.interpreter.numberValueOf(this.params.zOrder) : defaults.zOrder;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
      video = videos[number];
      video.domain = this.params.numberDomain;
      video.video = (ref = this.params.video) != null ? ref.name : void 0;
      video.loop = (ref1 = this.params.loop) != null ? ref1 : true;
      video.dstRect.x = x;
      video.dstRect.y = y;
      video.blendMode = this.interpreter.numberValueOf(this.params.blendMode);
      video.anchor.x = origin === 0 ? 0 : 0.5;
      video.anchor.y = origin === 0 ? 0 : 0.5;
      video.zIndex = zIndex || (1000 + number);
      if (((ref2 = this.params.viewport) != null ? ref2.type : void 0) === "scene") {
        video.viewport = SceneManager.scene.behavior.viewport;
      }
      video.update();
      if (this.params.positionType === 0) {
        p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, video, this.params);
        video.dstRect.x = p.x;
        video.dstRect.y = p.y;
      }
      video.animator.appear(x, y, animation, easing, duration);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMoveVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMoveVideo = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.moveObject(video, this.params.picture.position, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMoveVideoPath
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMoveVideoPath = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.moveObjectPath(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandRotateVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandRotateVideo = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.rotateObject(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandZoomVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandZoomVideo = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.zoomObject(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandBlendVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBlendVideo = function() {
      var video;
      SceneManager.scene.behavior.changeVideoDomain(this.params.numberDomain);
      video = SceneManager.scene.videos[this.interpreter.numberValueOf(this.params.number)];
      if (video == null) {
        return;
      }
      this.interpreter.blendObject(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandTintVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTintVideo = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.tintObject(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandFlashVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandFlashVideo = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.flashObject(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandCropVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCropVideo = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      return this.interpreter.cropObject(video, this.params);
    };


    /**
    * @method commandVideoMotionBlur
    * @protected
     */

    Component_CommandInterpreter.prototype.commandVideoMotionBlur = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      return this.interpreter.objectMotionBlur(video, this.params);
    };


    /**
    * @method commandMaskVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMaskVideo = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.maskObject(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandVideoEffect
    * @protected
     */

    Component_CommandInterpreter.prototype.commandVideoEffect = function() {
      var number, scene, video;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      this.interpreter.objectEffect(video, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandEraseVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandEraseVideo = function() {
      var animation, defaults, duration, easing, flags, isLocked, number, scene, video;
      defaults = GameManager.defaults.video;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      scene.behavior.changeVideoDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      video = scene.videos[number];
      if (video == null) {
        return;
      }
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.disappearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.disappearDuration;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.disappearAnimation;
      video.animator.disappear(animation, easing, duration, (function(_this) {
        return function(sender) {
          sender.dispose();
          scene.behavior.changeTextDomain(sender.domain);
          return scene.videos[number] = null;
        };
      })(this));
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandShowImageMap
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShowImageMap = function() {
      var bitmap, flags, imageMap, isLocked, number, p, ref, ref1, ref2, ref3, ref4, ref5;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      SceneManager.scene.behavior.changePictureDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      imageMap = SceneManager.scene.pictures[number];
      if (imageMap != null) {
        imageMap.dispose();
      }
      imageMap = new gs.Object_ImageMap();
      imageMap.visual.variableContext = this.interpreter.context;
      SceneManager.scene.pictures[number] = imageMap;
      bitmap = ResourceManager.getBitmap("Graphics/Pictures/" + ((ref = this.params.ground) != null ? ref.name : void 0));
      imageMap.dstRect.width = bitmap.width;
      imageMap.dstRect.height = bitmap.height;
      if (this.params.positionType === 0) {
        p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, imageMap, this.params);
        imageMap.dstRect.x = p.x;
        imageMap.dstRect.y = p.y;
      } else {
        imageMap.dstRect.x = this.interpreter.numberValueOf(this.params.position.x);
        imageMap.dstRect.y = this.interpreter.numberValueOf(this.params.position.y);
      }
      imageMap.anchor.x = this.params.origin === 1 ? 0.5 : 0;
      imageMap.anchor.y = this.params.origin === 1 ? 0.5 : 0;
      imageMap.zIndex = !isLocked(flags.zOrder) ? this.interpreter.numberValueOf(this.params.zOrder) : 700 + number;
      imageMap.blendMode = !isLocked(flags.blendMode) ? this.params.blendMode : 0;
      imageMap.hotspots = this.params.hotspots;
      imageMap.images = [(ref1 = this.params.ground) != null ? ref1.name : void 0, (ref2 = this.params.hover) != null ? ref2.name : void 0, (ref3 = this.params.unselected) != null ? ref3.name : void 0, (ref4 = this.params.selected) != null ? ref4.name : void 0, (ref5 = this.params.selectedHover) != null ? ref5.name : void 0];
      imageMap.events.on("jumpTo", gs.CallBack("onJumpTo", this.interpreter));
      imageMap.events.on("callCommonEvent", gs.CallBack("onCallCommonEvent", this.interpreter));
      imageMap.setup();
      imageMap.update();
      this.interpreter.showObject(imageMap, {
        x: 0,
        y: 0
      }, this.params);
      if (this.params.waitForCompletion) {
        this.interpreter.waitCounter = 0;
        this.interpreter.isWaiting = true;
      }
      imageMap.events.on("finish", (function(_this) {
        return function(sender) {
          return _this.interpreter.isWaiting = false;
        };
      })(this));
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandEraseImageMap
    * @protected
     */

    Component_CommandInterpreter.prototype.commandEraseImageMap = function() {
      var imageMap, number, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      imageMap = scene.pictures[number];
      if (imageMap == null) {
        return;
      }
      imageMap.events.emit("finish", imageMap);
      imageMap.visual.active = false;
      this.interpreter.eraseObject(imageMap, this.params, (function(_this) {
        return function(sender) {
          scene.behavior.changePictureDomain(sender.domain);
          return scene.pictures[number] = null;
        };
      })(this));
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandAddHotspot
    * @protected
     */

    Component_CommandInterpreter.prototype.commandAddHotspot = function() {
      var dragging, hotspot, hotspots, number, picture, ref, ref1, ref2, ref3, ref4, ref5, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeHotspotDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      hotspots = scene.hotspots;
      if (hotspots[number] == null) {
        hotspots[number] = new gs.Object_Hotspot();
      }
      hotspot = hotspots[number];
      hotspot.domain = this.params.numberDomain;
      hotspot.data = {
        params: this.params,
        bindValue: this.interpreter.numberValueOf(this.params.actions.onDrag.bindValue)
      };
      switch (this.params.positionType) {
        case 0:
          hotspot.dstRect.x = this.params.box.x;
          hotspot.dstRect.y = this.params.box.y;
          hotspot.dstRect.width = this.params.box.size.width;
          hotspot.dstRect.height = this.params.box.size.height;
          break;
        case 1:
          hotspot.dstRect.x = this.interpreter.numberValueOf(this.params.box.x);
          hotspot.dstRect.y = this.interpreter.numberValueOf(this.params.box.y);
          hotspot.dstRect.width = this.interpreter.numberValueOf(this.params.box.size.width);
          hotspot.dstRect.height = this.interpreter.numberValueOf(this.params.box.size.height);
          break;
        case 2:
          picture = scene.pictures[this.interpreter.numberValueOf(this.params.pictureNumber)];
          if (picture != null) {
            hotspot.target = picture;
          }
          break;
        case 3:
          text = scene.texts[this.interpreter.numberValueOf(this.params.textNumber)];
          if (text != null) {
            hotspot.target = text;
          }
      }
      hotspot.behavior.shape = (ref = this.params.shape) != null ? ref : gs.HotspotShape.RECTANGLE;
      if (text != null) {
        hotspot.images = null;
      } else {
        hotspot.images = [((ref1 = this.params.baseGraphic) != null ? ref1.name : void 0) || this.interpreter.stringValueOf(this.params.baseGraphic) || (picture != null ? picture.image : void 0), ((ref2 = this.params.hoverGraphic) != null ? ref2.name : void 0) || this.interpreter.stringValueOf(this.params.hoverGraphic), ((ref3 = this.params.selectedGraphic) != null ? ref3.name : void 0) || this.interpreter.stringValueOf(this.params.selectedGraphic), ((ref4 = this.params.selectedHoverGraphic) != null ? ref4.name : void 0) || this.interpreter.stringValueOf(this.params.selectedHoverGraphic), ((ref5 = this.params.unselectedGraphic) != null ? ref5.name : void 0) || this.interpreter.stringValueOf(this.params.unselectedGraphic)];
      }
      if (this.params.actions.onClick.type !== 0 || this.params.actions.onClick.label) {
        hotspot.events.on("click", gs.CallBack("onHotspotClick", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onClick.bindValue)
        }));
      }
      if (this.params.actions.onEnter.type !== 0 || this.params.actions.onEnter.label) {
        hotspot.events.on("enter", gs.CallBack("onHotspotEnter", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onEnter.bindValue)
        }));
      }
      if (this.params.actions.onLeave.type !== 0 || this.params.actions.onLeave.label) {
        hotspot.events.on("leave", gs.CallBack("onHotspotLeave", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onLeave.bindValue)
        }));
      }
      if (this.params.actions.onDrag.type !== 0 || this.params.actions.onDrag.label) {
        hotspot.events.on("dragStart", gs.CallBack("onHotspotDragStart", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onDrag.bindValue)
        }));
        hotspot.events.on("drag", gs.CallBack("onHotspotDrag", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onDrag.bindValue)
        }));
        hotspot.events.on("dragEnd", gs.CallBack("onHotspotDragEnd", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onDrag.bindValue)
        }));
      }
      if (this.params.actions.onSelect.type !== 0 || this.params.actions.onSelect.label || this.params.actions.onDeselect.type !== 0 || this.params.actions.onDeselect.label) {
        hotspot.events.on("stateChanged", gs.CallBack("onHotspotStateChanged", this.interpreter, this.params));
      }
      if (this.params.dragging.enabled) {
        hotspot.events.on("dragEnd", gs.CallBack("onHotspotDrop", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onDrag.bindValue)
        }));
      }
      if (this.params.actions.onDropReceive.type !== 0 || this.params.actions.onDropReceive.label) {
        hotspot.events.on("dropReceived", gs.CallBack("onHotspotDropReceived", this.interpreter, {
          params: this.params,
          bindValue: this.interpreter.numberValueOf(this.params.actions.onDrag.bindValue)
        }));
      }
      hotspot.selectable = true;
      if (this.params.dragging.enabled) {
        dragging = this.params.dragging;
        hotspot.draggable = {
          rect: new Rect(dragging.rect.x, dragging.rect.y, dragging.rect.size.width, dragging.rect.size.height),
          axisX: dragging.horizontal,
          axisY: dragging.vertical
        };
        hotspot.addComponent(new ui.Component_Draggable());
        hotspot.events.on("drag", (function(_this) {
          return function(e) {
            var drag;
            drag = e.sender.draggable;
            GameManager.variableStore.setupTempVariables(_this.interpreter.context);
            if (_this.params.dragging.horizontal) {
              return _this.interpreter.setNumberValueTo(_this.params.dragging.variable, Math.round((e.sender.dstRect.x - drag.rect.x) / (drag.rect.width - e.sender.dstRect.width) * 100));
            } else {
              return _this.interpreter.setNumberValueTo(_this.params.dragging.variable, Math.round((e.sender.dstRect.y - drag.rect.y) / (drag.rect.height - e.sender.dstRect.height) * 100));
            }
          };
        })(this));
      }
      return hotspot.setup();
    };


    /**
    * @method commandChangeHotspotState
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeHotspotState = function() {
      var flags, hotspot, isLocked, number, scene;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      scene.behavior.changeHotspotDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      hotspot = scene.hotspots[number];
      if (!hotspot) {
        return;
      }
      if (!isLocked(flags.selected)) {
        hotspot.behavior.selected = this.interpreter.booleanValueOf(this.params.selected);
      }
      if (!isLocked(flags.enabled)) {
        hotspot.behavior.enabled = this.interpreter.booleanValueOf(this.params.enabled);
      }
      hotspot.behavior.updateInput();
      return hotspot.behavior.updateImage();
    };


    /**
    * @method commandEraseHotspot
    * @protected
     */

    Component_CommandInterpreter.prototype.commandEraseHotspot = function() {
      var number, scene;
      scene = SceneManager.scene;
      scene.behavior.changeHotspotDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      if (scene.hotspots[number] != null) {
        scene.hotspots[number].dispose();
        return scene.hotspotContainer.eraseObject(number);
      }
    };


    /**
    * @method commandChangeObjectDomain
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeObjectDomain = function() {
      return SceneManager.scene.behavior.changeObjectDomain(this.interpreter.stringValueOf(this.params.domain));
    };


    /**
    * @method commandPictureDefaults
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPictureDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.picture;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.appearDuration)) {
        defaults.appearDuration = this.interpreter.durationValueOf(this.params.appearDuration);
      }
      if (!isLocked(flags.disappearDuration)) {
        defaults.disappearDuration = this.interpreter.durationValueOf(this.params.disappearDuration);
      }
      if (!isLocked(flags.zOrder)) {
        defaults.zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      }
      if (!isLocked(flags["appearEasing.type"])) {
        defaults.appearEasing = this.params.appearEasing;
      }
      if (!isLocked(flags["appearAnimation.type"])) {
        defaults.appearAnimation = this.params.appearAnimation;
      }
      if (!isLocked(flags["disappearEasing.type"])) {
        defaults.disappearEasing = this.params.disappearEasing;
      }
      if (!isLocked(flags["disappearAnimation.type"])) {
        defaults.disappearAnimation = this.params.disappearAnimation;
      }
      if (!isLocked(flags["motionBlur.enabled"])) {
        defaults.motionBlur = this.params.motionBlur;
      }
      if (!isLocked(flags.origin)) {
        return defaults.origin = this.params.origin;
      }
    };

    Component_CommandInterpreter.prototype.createPicture = function(graphic, params) {
      var animation, bitmap, defaults, duration, easing, flags, graphicName, isLocked, number, origin, picture, pictures, ref, ref1, ref2, ref3, ref4, ref5, ref6, scene, snapshot, x, y, zIndex;
      graphic = this.stringValueOf(graphic);
      graphicName = (graphic != null ? graphic.name : void 0) != null ? graphic.name : graphic;
      bitmap = ResourceManager.getBitmap("Graphics/Pictures/" + graphicName);
      if (bitmap && !bitmap.loaded) {
        return null;
      }
      defaults = GameManager.defaults.picture;
      flags = params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      number = this.numberValueOf(params.number);
      pictures = scene.pictures;
      picture = pictures[number];
      if (picture == null) {
        picture = new gs.Object_Picture(null, null, (ref = params.visual) != null ? ref.type : void 0);
        picture.domain = params.numberDomain;
        pictures[number] = picture;
        switch ((ref1 = params.visual) != null ? ref1.type : void 0) {
          case 1:
            picture.visual.looping.vertical = true;
            picture.visual.looping.horizontal = true;
            break;
          case 2:
            picture.frameThickness = params.visual.frame.thickness;
            picture.frameCornerSize = params.visual.frame.cornerSize;
            break;
          case 3:
            picture.visual.orientation = params.visual.threePartImage.orientation;
            break;
          case 4:
            picture.color = gs.Color.fromObject(params.visual.quad.color);
            break;
          case 5:
            snapshot = Graphics.snapshot();
            picture.bitmap = snapshot;
            picture.dstRect.width = snapshot.width;
            picture.dstRect.height = snapshot.height;
            picture.srcRect.set(0, 0, snapshot.width, snapshot.height);
        }
      } else {
        picture.bitmap = null;
      }
      x = this.numberValueOf(params.position.x);
      y = this.numberValueOf(params.position.y);
      picture = pictures[number];
      if (!picture.bitmap) {
        picture.image = graphicName;
      } else {
        picture.image = null;
      }
      bitmap = (ref2 = picture.bitmap) != null ? ref2 : ResourceManager.getBitmap("Graphics/Pictures/" + graphicName);
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.numberValueOf(params.easing.type), params.easing.inOut) : gs.Easings.fromObject(defaults.appearEasing);
      duration = !isLocked(flags.duration) ? this.durationValueOf(params.duration) : defaults.appearDuration;
      origin = !isLocked(flags.origin) ? params.origin : defaults.origin;
      zIndex = !isLocked(flags.zOrder) ? this.numberValueOf(params.zOrder) : defaults.zOrder;
      animation = !isLocked(flags["animation.type"]) ? params.animation : defaults.appearAnimation;
      picture.mirror = params.position.horizontalFlip;
      picture.angle = params.position.angle || 0;
      picture.zoom.x = ((ref3 = params.position.data) != null ? ref3.zoom : void 0) || 1;
      picture.zoom.y = ((ref4 = params.position.data) != null ? ref4.zoom : void 0) || 1;
      picture.blendMode = this.numberValueOf(params.blendMode);
      if (params.origin === 1 && (bitmap != null)) {
        x += (bitmap.width * picture.zoom.x - bitmap.width) / 2;
        y += (bitmap.height * picture.zoom.y - bitmap.height) / 2;
      }
      picture.dstRect.x = x;
      picture.dstRect.y = y;
      picture.anchor.x = origin === 1 ? 0.5 : 0;
      picture.anchor.y = origin === 1 ? 0.5 : 0;
      picture.zIndex = zIndex || (700 + number);
      if (((ref5 = params.viewport) != null ? ref5.type : void 0) === "scene") {
        picture.viewport = SceneManager.scene.behavior.viewport;
      }
      if (((ref6 = params.size) != null ? ref6.type : void 0) === 1) {
        picture.dstRect.width = this.numberValueOf(params.size.width);
        picture.dstRect.height = this.numberValueOf(params.size.height);
      }
      picture.update();
      return picture;
    };


    /**
    * @method commandShowPicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShowPicture = function() {
      var animation, defaults, duration, easing, flags, isLocked, p, picture;
      SceneManager.scene.behavior.changePictureDomain(this.params.numberDomain || "");
      defaults = GameManager.defaults.picture;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      picture = this.interpreter.createPicture(this.params.graphic, this.params);
      if (!picture) {
        this.interpreter.pointer--;
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = 1;
        return;
      }
      if (this.params.positionType === 0) {
        p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, picture, this.params);
        picture.dstRect.x = p.x;
        picture.dstRect.y = p.y;
      }
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.appearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
      picture.animator.appear(picture.dstRect.x, picture.dstRect.y, animation, easing, duration);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandPlayPictureAnimation
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPlayPictureAnimation = function() {
      var animation, bitmap, component, defaults, duration, easing, flags, isLocked, p, picture, record;
      SceneManager.scene.behavior.changePictureDomain(this.params.numberDomain || "");
      defaults = GameManager.defaults.picture;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      picture = null;
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.appearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
      if (this.params.animationId != null) {
        record = RecordManager.animations[this.params.animationId];
        if (record != null) {
          picture = this.interpreter.createPicture(record.graphic, this.params);
          component = picture.findComponent("Component_FrameAnimation");
          if (component != null) {
            component.refresh(record);
            component.start();
          } else {
            component = new gs.Component_FrameAnimation(record);
            picture.addComponent(component);
          }
          component.update();
          if (this.params.positionType === 0) {
            p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, picture, this.params);
            picture.dstRect.x = p.x;
            picture.dstRect.y = p.y;
          }
          picture.animator.appear(picture.dstRect.x, picture.dstRect.y, animation, easing, duration);
        }
      } else {
        picture = SceneManager.scene.pictures[this.interpreter.numberValueOf(this.params.number)];
        animation = picture != null ? picture.findComponent("Component_FrameAnimation") : void 0;
        if (animation != null) {
          picture.removeComponent(animation);
          bitmap = ResourceManager.getBitmap("Graphics/Animations/" + picture.image);
          if (bitmap != null) {
            picture.srcRect.set(0, 0, bitmap.width, bitmap.height);
            picture.dstRect.width = picture.srcRect.width;
            picture.dstRect.height = picture.srcRect.height;
          }
        }
      }
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMovePicturePath
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMovePicturePath = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.moveObjectPath(picture, this.params.path, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMovePicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMovePicture = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.moveObject(picture, this.params.picture.position, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandTintPicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTintPicture = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.tintObject(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandFlashPicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandFlashPicture = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.flashObject(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandCropPicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCropPicture = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      return this.interpreter.cropObject(picture, this.params);
    };


    /**
    * @method commandRotatePicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandRotatePicture = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.rotateObject(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandZoomPicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandZoomPicture = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.zoomObject(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandBlendPicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBlendPicture = function() {
      var picture;
      SceneManager.scene.behavior.changePictureDomain(this.params.numberDomain || "");
      picture = SceneManager.scene.pictures[this.interpreter.numberValueOf(this.params.number)];
      if (picture == null) {
        return;
      }
      this.interpreter.blendObject(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandShakePicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShakePicture = function() {
      var picture;
      picture = SceneManager.scene.pictures[this.interpreter.numberValueOf(this.params.number)];
      if (picture == null) {
        return;
      }
      this.interpreter.shakeObject(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMaskPicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMaskPicture = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.maskObject(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandPictureMotionBlur
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPictureMotionBlur = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.objectMotionBlur(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandPictureEffect
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPictureEffect = function() {
      var number, picture, scene;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      this.interpreter.objectEffect(picture, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandErasePicture
    * @protected
     */

    Component_CommandInterpreter.prototype.commandErasePicture = function() {
      var animation, defaults, duration, easing, flags, isLocked, number, picture, scene;
      defaults = GameManager.defaults.picture;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      scene.behavior.changePictureDomain(this.params.numberDomain || "");
      number = this.interpreter.numberValueOf(this.params.number);
      picture = scene.pictures[number];
      if (picture == null) {
        return;
      }
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.disappearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.disappearDuration;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.disappearAnimation;
      picture.animator.disappear(animation, easing, duration, (function(_this) {
        return function(sender) {
          sender.dispose();
          scene.behavior.changePictureDomain(sender.domain);
          return scene.pictures[number] = null;
        };
      })(this));
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandInputNumber
    * @protected
     */

    Component_CommandInterpreter.prototype.commandInputNumber = function() {
      var scene;
      scene = SceneManager.scene;
      this.interpreter.isWaiting = true;
      if (this.interpreter.isProcessingMessageInOtherContext()) {
        this.interpreter.waitForMessage();
        return;
      }
      if ((GameManager.settings.allowChoiceSkip || this.interpreter.preview) && GameManager.tempSettings.skip) {
        this.interpreter.isWaiting = false;
        this.interpreter.messageObject().behavior.clear();
        this.interpreter.setNumberValueTo(this.params.variable, 0);
        return;
      }
      $tempFields.digits = this.params.digits;
      scene.behavior.showInputNumber(this.params.digits, gs.CallBack("onInputNumberFinish", this.interpreter, this.params));
      this.interpreter.waitingFor.inputNumber = this.params;
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandChoiceTimer
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChoiceTimer = function() {
      var scene;
      scene = SceneManager.scene;
      GameManager.tempFields.choiceTimer = scene.choiceTimer;
      GameManager.tempFields.choiceTimerVisible = this.params.visible;
      if (this.params.enabled) {
        scene.choiceTimer.behavior.seconds = this.interpreter.numberValueOf(this.params.seconds);
        scene.choiceTimer.behavior.minutes = this.interpreter.numberValueOf(this.params.minutes);
        scene.choiceTimer.behavior.start();
        return scene.choiceTimer.events.on("finish", (function(_this) {
          return function(sender) {
            var defaultChoice, ref;
            if (scene.choiceWindow && ((ref = scene.choices) != null ? ref.length : void 0) > 0) {
              defaultChoice = (scene.choices.first(function(c) {
                return c.isDefault;
              })) || scene.choices[0];
              return scene.choiceWindow.events.emit("selectionAccept", scene.choiceWindow, defaultChoice);
            }
          };
        })(this));
      } else {
        return scene.choiceTimer.stop();
      }
    };


    /**
    * @method commandShowChoices
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShowChoices = function() {
      var choices, defaultChoice, messageObject, pointer, scene;
      scene = SceneManager.scene;
      pointer = this.interpreter.pointer;
      choices = scene.choices || [];
      if ((GameManager.settings.allowChoiceSkip || this.interpreter.previewData) && GameManager.tempSettings.skip) {
        messageObject = this.interpreter.messageObject();
        if (messageObject != null ? messageObject.visible : void 0) {
          messageObject.behavior.clear();
        }
        defaultChoice = (choices.first(function(c) {
          return c.isDefault;
        })) || choices[0];
        if (defaultChoice.action.labelIndex != null) {
          this.interpreter.pointer = defaultChoice.action.labelIndex;
        } else {
          this.interpreter.jumpToLabel(defaultChoice.action.label);
        }
        scene.choices = [];
      } else {
        if (choices.length > 0) {
          this.interpreter.isWaiting = true;
          scene.behavior.showChoices(gs.CallBack("onChoiceAccept", this.interpreter, {
            pointer: pointer,
            params: this.params
          }));
        }
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandShowChoice
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShowChoice = function() {
      var choices, command, commands, dstRect, index, pointer, scene;
      scene = SceneManager.scene;
      commands = this.interpreter.object.commands;
      command = null;
      index = 0;
      pointer = this.interpreter.pointer;
      choices = null;
      dstRect = null;
      switch (this.params.positionType) {
        case 0:
          dstRect = null;
          break;
        case 1:
          dstRect = new Rect(this.params.box.x, this.params.box.y, this.params.box.size.width, this.params.box.size.height);
      }
      if (!scene.choices) {
        scene.choices = [];
      }
      choices = scene.choices;
      return choices.push({
        dstRect: dstRect,
        text: this.params.text,
        index: index,
        action: this.params.action,
        isSelected: false,
        isDefault: this.params.defaultChoice,
        isEnabled: this.interpreter.booleanValueOf(this.params.enabled)
      });
    };


    /**
    * @method commandOpenMenu
    * @protected
     */

    Component_CommandInterpreter.prototype.commandOpenMenu = function() {
      SceneManager.switchTo(new gs.Object_Layout("menuLayout"), true);
      this.interpreter.waitCounter = 1;
      return this.interpreter.isWaiting = true;
    };


    /**
    * @method commandOpenLoadMenu
    * @protected
     */

    Component_CommandInterpreter.prototype.commandOpenLoadMenu = function() {
      SceneManager.switchTo(new gs.Object_Layout("loadMenuLayout"), true);
      this.interpreter.waitCounter = 1;
      return this.interpreter.isWaiting = true;
    };


    /**
    * @method commandOpenSaveMenu
    * @protected
     */

    Component_CommandInterpreter.prototype.commandOpenSaveMenu = function() {
      SceneManager.switchTo(new gs.Object_Layout("saveMenuLayout"), true);
      this.interpreter.waitCounter = 1;
      return this.interpreter.isWaiting = true;
    };


    /**
    * @method commandReturnToTitle
    * @protected
     */

    Component_CommandInterpreter.prototype.commandReturnToTitle = function() {
      SceneManager.clear();
      SceneManager.switchTo(new gs.Object_Layout("titleLayout"));
      this.interpreter.waitCounter = 1;
      return this.interpreter.isWaiting = true;
    };


    /**
    * @method commandPlayVideo
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPlayVideo = function() {
      var ref, scene;
      if ((GameManager.inLivePreview || GameManager.settings.allowVideoSkip) && GameManager.tempSettings.skip) {
        return;
      }
      GameManager.tempSettings.skip = false;
      scene = SceneManager.scene;
      if (((ref = this.params.video) != null ? ref.name : void 0) != null) {
        scene.video = ResourceManager.getVideo("Movies/" + this.params.video.name);
        this.videoSprite = new Sprite(Graphics.viewport);
        this.videoSprite.srcRect = new Rect(0, 0, scene.video.width, scene.video.height);
        this.videoSprite.video = scene.video;
        this.videoSprite.zoomX = Graphics.width / scene.video.width;
        this.videoSprite.zoomY = Graphics.height / scene.video.height;
        this.videoSprite.z = 99999999;
        scene.video.onEnded = (function(_this) {
          return function() {
            _this.interpreter.isWaiting = false;
            _this.videoSprite.dispose();
            return scene.video = null;
          };
        })(this);
        scene.video.volume = this.params.volume / 100;
        scene.video.playbackRate = this.params.playbackRate / 100;
        this.interpreter.isWaiting = true;
        scene.video.play();
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandAudioDefaults
    * @protected
     */

    Component_CommandInterpreter.prototype.commandAudioDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.audio;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.musicFadeInDuration)) {
        defaults.musicFadeInDuration = this.params.musicFadeInDuration;
      }
      if (!isLocked(flags.musicFadeOutDuration)) {
        defaults.musicFadeOutDuration = this.params.musicFadeOutDuration;
      }
      if (!isLocked(flags.musicVolume)) {
        defaults.musicVolume = this.params.musicVolume;
      }
      if (!isLocked(flags.musicPlaybackRate)) {
        defaults.musicPlaybackRate = this.params.musicPlaybackRate;
      }
      if (!isLocked(flags.soundVolume)) {
        defaults.soundVolume = this.params.soundVolume;
      }
      if (!isLocked(flags.soundPlaybackRate)) {
        defaults.soundPlaybackRate = this.params.soundPlaybackRate;
      }
      if (!isLocked(flags.voiceVolume)) {
        defaults.voiceVolume = this.params.voiceVolume;
      }
      if (!isLocked(flags.voicePlaybackRate)) {
        return defaults.voicePlaybackRate = this.params.voicePlaybackRate;
      }
    };


    /**
    * @method commandPlayMusic
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPlayMusic = function() {
      var defaults, fadeDuration, flags, isLocked, music, playRange, playTime, playbackRate, volume;
      if (this.params.music == null) {
        return;
      }
      defaults = GameManager.defaults.audio;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      music = null;
      if (GameManager.settings.bgmEnabled) {
        fadeDuration = !isLocked(flags.fadeInDuration) ? this.params.fadeInDuration : defaults.musicFadeInDuration;
        volume = !isLocked(flags["music.volume"]) ? this.params.music.volume : defaults.musicVolume;
        playbackRate = !isLocked(flags["music.playbackRate"]) ? this.params.music.playbackRate : defaults.musicPlaybackRate;
        music = {
          name: this.params.music.name,
          volume: volume,
          playbackRate: playbackRate
        };
        if (this.params.playType === 1) {
          playTime = {
            min: this.params.playTime.min * 60,
            max: this.params.playTime.max * 60
          };
          playRange = {
            start: this.params.playRange.start * 60,
            end: this.params.playRange.end * 60
          };
          AudioManager.playMusicRandom(music, fadeDuration, this.params.layer || 0, playTime, playRange);
        } else {
          music = AudioManager.playMusic(this.params.music.name, volume, playbackRate, fadeDuration, this.params.layer || 0, this.params.loop);
        }
      }
      if (music && this.params.waitForCompletion && !this.params.loop) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = Math.round(music.duration * Graphics.frameRate);
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandStopMusic
    * @protected
     */

    Component_CommandInterpreter.prototype.commandStopMusic = function() {
      var defaults, fadeDuration, flags, isLocked;
      defaults = GameManager.defaults.audio;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      fadeDuration = !isLocked(flags.fadeOutDuration) ? this.params.fadeOutDuration : defaults.musicFadeOutDuration;
      AudioManager.stopMusic(fadeDuration, this.interpreter.numberValueOf(this.params.layer));
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandPauseMusic
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPauseMusic = function() {
      var defaults, fadeDuration, flags, isLocked;
      defaults = GameManager.defaults.audio;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      fadeDuration = !isLocked(flags.fadeOutDuration) ? this.params.fadeOutDuration : defaults.musicFadeOutDuration;
      return AudioManager.stopMusic(fadeDuration, this.interpreter.numberValueOf(this.params.layer));
    };


    /**
    * @method commandResumeMusic
    * @protected
     */

    Component_CommandInterpreter.prototype.commandResumeMusic = function() {
      var defaults, fadeDuration, flags, isLocked;
      defaults = GameManager.defaults.audio;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      fadeDuration = !isLocked(flags.fadeInDuration) ? this.params.fadeInDuration : defaults.musicFadeInDuration;
      AudioManager.resumeMusic(fadeDuration, this.interpreter.numberValueOf(this.params.layer));
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandPlaySound
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPlaySound = function() {
      var defaults, flags, isLocked, playbackRate, sound, volume;
      defaults = GameManager.defaults.audio;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      sound = null;
      if (GameManager.settings.soundEnabled && !GameManager.tempSettings.skip) {
        volume = !isLocked(flags["sound.volume"]) ? this.params.sound.volume : defaults.soundVolume;
        playbackRate = !isLocked(flags["sound.playbackRate"]) ? this.params.sound.playbackRate : defaults.soundPlaybackRate;
        sound = AudioManager.playSound(this.params.sound.name, volume, playbackRate, this.params.musicEffect, null, this.params.loop);
      }
      gs.GameNotifier.postMinorChange();
      if (sound && this.params.waitForCompletion && !this.params.loop) {
        this.interpreter.isWaiting = true;
        return this.interpreter.waitCounter = Math.round(sound.duration * Graphics.frameRate);
      }
    };


    /**
    * @method commandStopSound
    * @protected
     */

    Component_CommandInterpreter.prototype.commandStopSound = function() {
      AudioManager.stopSound(this.params.sound.name);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandEndCommonEvent
    * @protected
     */

    Component_CommandInterpreter.prototype.commandEndCommonEvent = function() {
      var event, eventId;
      eventId = this.interpreter.stringValueOf(this.params.commonEventId);
      event = GameManager.commonEvents[eventId];
      return event != null ? event.behavior.stop() : void 0;
    };


    /**
    * @method commandResumeCommonEvent
    * @protected
     */

    Component_CommandInterpreter.prototype.commandResumeCommonEvent = function() {
      var event, eventId;
      eventId = this.interpreter.stringValueOf(this.params.commonEventId);
      event = GameManager.commonEvents[eventId];
      return event != null ? event.behavior.resume() : void 0;
    };


    /**
    * @method commandCallCommonEvent
    * @protected
     */

    Component_CommandInterpreter.prototype.commandCallCommonEvent = function() {
      var eventId, list, params, scene;
      scene = SceneManager.scene;
      eventId = null;
      if (this.params.commonEventId.index != null) {
        eventId = this.interpreter.stringValueOf(this.params.commonEventId);
        list = this.interpreter.listObjectOf(this.params.parameters.values[0]);
        params = {
          values: list
        };
      } else {
        params = this.params.parameters;
        eventId = this.params.commonEventId;
      }
      return this.interpreter.callCommonEvent(eventId, params);
    };


    /**
    * @method commandChangeTextSettings
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeTextSettings = function() {
      var flags, font, fontName, fontSize, isLocked, number, padding, ref, ref1, ref2, ref3, ref4, scene, textSprite, texts;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      texts = scene.texts;
      if (texts[number] == null) {
        texts[number] = new gs.Object_Text();
        texts[number].visible = false;
      }
      textSprite = texts[number];
      padding = textSprite.behavior.padding;
      font = textSprite.font;
      fontName = textSprite.font.name;
      fontSize = textSprite.font.size;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.lineSpacing)) {
        textSprite.textRenderer.lineSpacing = (ref = this.params.lineSpacing) != null ? ref : textSprite.textRenderer.lineSpacing;
      }
      if (!isLocked(flags.font)) {
        fontName = this.interpreter.stringValueOf(this.params.font);
      }
      if (!isLocked(flags.size)) {
        fontSize = this.interpreter.numberValueOf(this.params.size);
      }
      if (!isLocked(flags.font) || !isLocked(flags.size)) {
        textSprite.font = new Font(fontName, fontSize);
      }
      padding.left = !isLocked(flags["padding.0"]) ? (ref1 = this.params.padding) != null ? ref1[0] : void 0 : padding.left;
      padding.top = !isLocked(flags["padding.1"]) ? (ref2 = this.params.padding) != null ? ref2[1] : void 0 : padding.top;
      padding.right = !isLocked(flags["padding.2"]) ? (ref3 = this.params.padding) != null ? ref3[2] : void 0 : padding.right;
      padding.bottom = !isLocked(flags["padding.3"]) ? (ref4 = this.params.padding) != null ? ref4[3] : void 0 : padding.bottom;
      if (!isLocked(flags.bold)) {
        textSprite.font.bold = this.params.bold;
      }
      if (!isLocked(flags.italic)) {
        textSprite.font.italic = this.params.italic;
      }
      if (!isLocked(flags.smallCaps)) {
        textSprite.font.smallCaps = this.params.smallCaps;
      }
      if (!isLocked(flags.underline)) {
        textSprite.font.underline = this.params.underline;
      }
      if (!isLocked(flags.strikeThrough)) {
        textSprite.font.strikeThrough = this.params.strikeThrough;
      }
      textSprite.font.color = !isLocked(flags.color) ? new Color(this.params.color) : font.color;
      textSprite.font.border = !isLocked(flags.outline) ? this.params.outline : font.border;
      textSprite.font.borderColor = !isLocked(flags.outlineColor) ? new Color(this.params.outlineColor) : new Color(font.borderColor);
      textSprite.font.borderSize = !isLocked(flags.outlineSize) ? this.params.outlineSize : font.borderSize;
      textSprite.font.shadow = !isLocked(flags.shadow) ? this.params.shadow : font.shadow;
      textSprite.font.shadowColor = !isLocked(flags.shadowColor) ? new Color(this.params.shadowColor) : new Color(font.shadowColor);
      textSprite.font.shadowOffsetX = !isLocked(flags.shadowOffsetX) ? this.params.shadowOffsetX : font.shadowOffsetX;
      textSprite.font.shadowOffsetY = !isLocked(flags.shadowOffsetY) ? this.params.shadowOffsetY : font.shadowOffsetY;
      textSprite.behavior.refresh();
      return textSprite.update();
    };


    /**
    * @method commandChangeTextSettings
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTextDefaults = function() {
      var defaults, flags, isLocked;
      defaults = GameManager.defaults.text;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      if (!isLocked(flags.appearDuration)) {
        defaults.appearDuration = this.interpreter.durationValueOf(this.params.appearDuration);
      }
      if (!isLocked(flags.disappearDuration)) {
        defaults.disappearDuration = this.interpreter.durationValueOf(this.params.disappearDuration);
      }
      if (!isLocked(flags.zOrder)) {
        defaults.zOrder = this.interpreter.numberValueOf(this.params.zOrder);
      }
      if (!isLocked(flags["appearEasing.type"])) {
        defaults.appearEasing = this.params.appearEasing;
      }
      if (!isLocked(flags["appearAnimation.type"])) {
        defaults.appearAnimation = this.params.appearAnimation;
      }
      if (!isLocked(flags["disappearEasing.type"])) {
        defaults.disappearEasing = this.params.disappearEasing;
      }
      if (!isLocked(flags["disappearAnimation.type"])) {
        defaults.disappearAnimation = this.params.disappearAnimation;
      }
      if (!isLocked(flags["motionBlur.enabled"])) {
        defaults.motionBlur = this.params.motionBlur;
      }
      if (!isLocked(flags.origin)) {
        return defaults.origin = this.params.origin;
      }
    };


    /**
    * @method commandShowText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandShowText = function() {
      var animation, defaults, duration, easing, flags, isLocked, number, origin, p, positionAnchor, ref, scene, text, textObject, texts, x, y, zIndex;
      defaults = GameManager.defaults.text;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = this.params.text;
      texts = scene.texts;
      if (texts[number] == null) {
        texts[number] = new gs.Object_Text();
      }
      x = this.interpreter.numberValueOf(this.params.position.x);
      y = this.interpreter.numberValueOf(this.params.position.y);
      textObject = texts[number];
      textObject.domain = this.params.numberDomain;
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.appearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.appearDuration;
      origin = !isLocked(flags.origin) ? this.params.origin : defaults.origin;
      zIndex = !isLocked(flags.zOrder) ? this.interpreter.numberValueOf(this.params.zOrder) : defaults.zOrder;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.appearAnimation;
      positionAnchor = !isLocked(flags.positionOrigin) ? this.interpreter.graphicAnchorPointsByConstant[this.params.positionOrigin] || new gs.Point(0, 0) : this.interpreter.graphicAnchorPointsByConstant[defaults.positionOrigin];
      textObject.text = text;
      textObject.dstRect.x = x;
      textObject.dstRect.y = y;
      textObject.blendMode = this.interpreter.numberValueOf(this.params.blendMode);
      textObject.anchor.x = origin === 0 ? 0 : 0.5;
      textObject.anchor.y = origin === 0 ? 0 : 0.5;
      textObject.positionAnchor.x = positionAnchor.x;
      textObject.positionAnchor.y = positionAnchor.y;
      textObject.zIndex = zIndex || (700 + number);
      textObject.sizeToFit = true;
      textObject.formatting = true;
      if (((ref = this.params.viewport) != null ? ref.type : void 0) === "scene") {
        textObject.viewport = SceneManager.scene.behavior.viewport;
      }
      textObject.update();
      if (this.params.positionType === 0) {
        p = this.interpreter.predefinedObjectPosition(this.params.predefinedPositionId, textObject, this.params);
        textObject.dstRect.x = p.x;
        textObject.dstRect.y = p.y;
      }
      textObject.animator.appear(x, y, animation, easing, duration);
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandTextMotionBlur
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTextMotionBlur = function() {
      var number, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      if (text == null) {
        return;
      }
      return text.motionBlur.set(this.params.motionBlur);
    };


    /**
    * @method commandRefreshText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandRefreshText = function() {
      var number, scene, texts;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      texts = scene.texts;
      if (texts[number] == null) {
        return;
      }
      return texts[number].behavior.refresh(true);
    };


    /**
    * @method commandMoveText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMoveText = function() {
      var number, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      if (text == null) {
        return;
      }
      this.interpreter.moveObject(text, this.params.picture.position, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandMoveTextPath
    * @protected
     */

    Component_CommandInterpreter.prototype.commandMoveTextPath = function() {
      var number, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      if (text == null) {
        return;
      }
      this.interpreter.moveObjectPath(text, this.params.path, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandRotateText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandRotateText = function() {
      var number, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      if (text == null) {
        return;
      }
      this.interpreter.rotateObject(text, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandZoomText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandZoomText = function() {
      var number, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      if (text == null) {
        return;
      }
      this.interpreter.zoomObject(text, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandBlendText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandBlendText = function() {
      var text;
      SceneManager.scene.behavior.changeTextDomain(this.params.numberDomain);
      text = SceneManager.scene.texts[this.interpreter.numberValueOf(this.params.number)];
      if (text == null) {
        return;
      }
      this.interpreter.blendObject(text, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandColorText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandColorText = function() {
      var duration, easing, number, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      duration = this.interpreter.durationValueOf(this.params.duration);
      easing = gs.Easings.fromObject(this.params.easing);
      if (text != null) {
        text.animator.colorTo(new Color(this.params.color), duration, easing);
        if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
          this.interpreter.isWaiting = true;
          this.interpreter.waitCounter = duration;
        }
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandEraseText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandEraseText = function() {
      var animation, defaults, duration, easing, flags, isLocked, number, scene, text;
      defaults = GameManager.defaults.text;
      flags = this.params.fieldFlags || {};
      isLocked = gs.CommandFieldFlags.isLocked;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      if (text == null) {
        return;
      }
      easing = !isLocked(flags["easing.type"]) ? gs.Easings.fromValues(this.interpreter.numberValueOf(this.params.easing.type), this.params.easing.inOut) : gs.Easings.fromObject(defaults.disappearEasing);
      duration = !isLocked(flags.duration) ? this.interpreter.durationValueOf(this.params.duration) : defaults.disappearDuration;
      animation = !isLocked(flags["animation.type"]) ? this.params.animation : defaults.disappearAnimation;
      text.animator.disappear(animation, easing, duration, (function(_this) {
        return function(sender) {
          sender.dispose();
          scene.behavior.changeTextDomain(sender.domain);
          return scene.texts[number] = null;
        };
      })(this));
      if (this.params.waitForCompletion && !(duration === 0 || this.interpreter.isInstantSkip())) {
        this.interpreter.isWaiting = true;
        this.interpreter.waitCounter = duration;
      }
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandTextEffect
    * @protected
     */

    Component_CommandInterpreter.prototype.commandTextEffect = function() {
      var number, scene, text;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      number = this.interpreter.numberValueOf(this.params.number);
      text = scene.texts[number];
      if (text == null) {
        return;
      }
      this.interpreter.objectEffect(text, this.params);
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandInputText
    * @protected
     */

    Component_CommandInterpreter.prototype.commandInputText = function() {
      var scene;
      scene = SceneManager.scene;
      scene.behavior.changeTextDomain(this.params.numberDomain);
      if ((GameManager.settings.allowChoiceSkip || this.interpreter.preview) && GameManager.tempSettings.skip) {
        this.interpreter.messageObject().behavior.clear();
        this.interpreter.setStringValueTo(this.params.variable, "");
        return;
      }
      this.interpreter.isWaiting = true;
      if (this.interpreter.isProcessingMessageInOtherContext()) {
        this.interpreter.waitForMessage();
        return;
      }
      $tempFields.letters = this.params.letters;
      scene.behavior.showInputText(this.params.letters, gs.CallBack("onInputTextFinish", this.interpreter, this.interpreter));
      this.interpreter.waitingFor.inputText = this.params;
      return gs.GameNotifier.postMinorChange();
    };


    /**
    * @method commandSavePersistentData
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSavePersistentData = function() {
      return GameManager.saveGlobalData();
    };


    /**
    * @method commandSaveSettings
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSaveSettings = function() {
      return GameManager.saveSettings();
    };


    /**
    * @method commandPrepareSaveGame
    * @protected
     */

    Component_CommandInterpreter.prototype.commandPrepareSaveGame = function() {
      if (this.interpreter.previewData != null) {
        return;
      }
      this.interpreter.pointer++;
      GameManager.prepareSaveGame(this.params.snapshot);
      return this.interpreter.pointer--;
    };


    /**
    * @method commandSaveGame
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSaveGame = function() {
      var thumbHeight, thumbWidth;
      if (this.interpreter.previewData != null) {
        return;
      }
      thumbWidth = this.interpreter.numberValueOf(this.params.thumbWidth);
      thumbHeight = this.interpreter.numberValueOf(this.params.thumbHeight);
      return GameManager.save(this.interpreter.numberValueOf(this.params.slot) - 1, thumbWidth, thumbHeight);
    };


    /**
    * @method commandLoadGame
    * @protected
     */

    Component_CommandInterpreter.prototype.commandLoadGame = function() {
      if (this.interpreter.previewData != null) {
        return;
      }
      return GameManager.load(this.interpreter.numberValueOf(this.params.slot) - 1);
    };


    /**
    * @method commandWaitForInput
    * @protected
     */

    Component_CommandInterpreter.prototype.commandWaitForInput = function() {
      var f;
      if (this.interpreter.isInstantSkip()) {
        return;
      }
      gs.GlobalEventManager.offByOwner("mouseDown", this.interpreter.object);
      gs.GlobalEventManager.offByOwner("mouseUp", this.interpreter.object);
      gs.GlobalEventManager.offByOwner("keyDown", this.interpreter.object);
      gs.GlobalEventManager.offByOwner("keyUp", this.interpreter.object);
      f = (function(_this) {
        return function() {
          var executeAction, key;
          key = _this.interpreter.numberValueOf(_this.params.key);
          executeAction = false;
          if (Input.Mouse.isButton(_this.params.key)) {
            executeAction = Input.Mouse.buttons[_this.params.key] === _this.params.state;
          } else if (_this.params.key === 100) {
            if (Input.keyDown && _this.params.state === 1) {
              executeAction = true;
            }
            if (Input.keyUp && _this.params.state === 2) {
              executeAction = true;
            }
          } else if (_this.params.key === 101) {
            if (Input.Mouse.buttonDown && _this.params.state === 1) {
              executeAction = true;
            }
            if (Input.Mouse.buttonUp && _this.params.state === 2) {
              executeAction = true;
            }
          } else if (_this.params.key === 102) {
            if ((Input.keyDown || Input.Mouse.buttonDown) && _this.params.state === 1) {
              executeAction = true;
            }
            if ((Input.keyUp || Input.Mouse.buttonUp) && _this.params.state === 2) {
              executeAction = true;
            }
          } else {
            key = key > 100 ? key - 100 : key;
            executeAction = Input.keys[key] === _this.params.state;
          }
          if (executeAction) {
            _this.interpreter.isWaiting = false;
            gs.GlobalEventManager.offByOwner("mouseDown", _this.interpreter.object);
            gs.GlobalEventManager.offByOwner("mouseUp", _this.interpreter.object);
            gs.GlobalEventManager.offByOwner("keyDown", _this.interpreter.object);
            return gs.GlobalEventManager.offByOwner("keyUp", _this.interpreter.object);
          }
        };
      })(this);
      gs.GlobalEventManager.on("mouseDown", f, null, this.interpreter.object);
      gs.GlobalEventManager.on("mouseUp", f, null, this.interpreter.object);
      gs.GlobalEventManager.on("keyDown", f, null, this.interpreter.object);
      gs.GlobalEventManager.on("keyUp", f, null, this.interpreter.object);
      return this.interpreter.isWaiting = true;
    };


    /**
    * @method commandGetInputData
    * @protected
     */

    Component_CommandInterpreter.prototype.commandGetInputData = function() {
      var anyButton, anyInput, anyKey, code;
      switch (this.params.field) {
        case 0:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.A]);
        case 1:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.B]);
        case 2:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.X]);
        case 3:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.Y]);
        case 4:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.L]);
        case 5:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.R]);
        case 6:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.START]);
        case 7:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[Input.SELECT]);
        case 8:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.Mouse.x);
        case 9:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.Mouse.y);
        case 10:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.Mouse.wheel);
        case 11:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.Mouse.buttons[Input.Mouse.LEFT]);
        case 12:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.Mouse.buttons[Input.Mouse.RIGHT]);
        case 13:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.Mouse.buttons[Input.Mouse.MIDDLE]);
        case 100:
          anyKey = 0;
          if (Input.keyDown) {
            anyKey = 1;
          }
          if (Input.keyUp) {
            anyKey = 2;
          }
          return this.interpreter.setNumberValueTo(this.params.targetVariable, anyKey);
        case 101:
          anyButton = 0;
          if (Input.Mouse.buttonDown) {
            anyButton = 1;
          }
          if (Input.Mouse.buttonUp) {
            anyButton = 2;
          }
          return this.interpreter.setNumberValueTo(this.params.targetVariable, anyButton);
        case 102:
          anyInput = 0;
          if (Input.Mouse.buttonDown || Input.keyDown) {
            anyInput = 1;
          }
          if (Input.Mouse.buttonUp || Input.keyUp) {
            anyInput = 2;
          }
          return this.interpreter.setNumberValueTo(this.params.targetVariable, anyInput);
        default:
          code = this.params.field - 100;
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Input.keys[code]);
      }
    };


    /**
    * @method commandGetGameData
    * @protected
     */

    Component_CommandInterpreter.prototype.commandGetGameData = function() {
      var ref, ref1, settings, tempSettings;
      tempSettings = GameManager.tempSettings;
      settings = GameManager.settings;
      switch (this.params.field) {
        case 0:
          return this.interpreter.setStringValueTo(this.params.targetVariable, SceneManager.scene.sceneDocument.uid);
        case 1:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Math.round(Graphics.frameCount / 60));
        case 2:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Math.round(Graphics.frameCount / 60 / 60));
        case 3:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, Math.round(Graphics.frameCount / 60 / 60 / 60));
        case 4:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, new Date().getDate());
        case 5:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, new Date().getDay());
        case 6:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, new Date().getMonth());
        case 7:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, new Date().getFullYear());
        case 8:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.allowSkip);
        case 9:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.allowSkipUnreadMessages);
        case 10:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, settings.messageSpeed);
        case 11:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.autoMessage.enabled);
        case 12:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, settings.autoMessage.time);
        case 13:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.autoMessage.waitForVoice);
        case 14:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.autoMessage.stopOnAction);
        case 15:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.timeMessageToVoice);
        case 16:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.allowVideoSkip);
        case 17:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.allowChoiceSkip);
        case 18:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.skipVoiceOnAction);
        case 19:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.fullScreen);
        case 20:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.adjustAspectRatio);
        case 21:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.confirmation);
        case 22:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, settings.bgmVolume);
        case 23:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, settings.voiceVolume);
        case 24:
          return this.interpreter.setNumberValueTo(this.params.targetVariable, settings.seVolume);
        case 25:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.bgmEnabled);
        case 26:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.voiceEnabled);
        case 27:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, settings.seEnabled);
        case 28:
          return this.interpreter.setStringValueTo(this.params.targetVariable, ((ref = LanguageManager.language) != null ? ref.code : void 0) || "");
        case 29:
          return this.interpreter.setStringValueTo(this.params.targetVariable, ((ref1 = LanguageManager.language) != null ? ref1.name : void 0) || "");
        case 30:
          return this.interpreter.setBooleanValueTo(this.params.targetVariable, GameManager.tempSettings.skip);
      }
    };


    /**
    * @method commandSetGameData
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSetGameData = function() {
      var code, language, settings, tempSettings;
      tempSettings = GameManager.tempSettings;
      settings = GameManager.settings;
      switch (this.params.field) {
        case 0:
          return settings.allowSkip = this.interpreter.booleanValueOf(this.params.switchValue);
        case 1:
          return settings.allowSkipUnreadMessages = this.interpreter.booleanValueOf(this.params.switchValue);
        case 2:
          return settings.messageSpeed = this.interpreter.numberValueOf(this.params.decimalValue);
        case 3:
          return settings.autoMessage.enabled = this.interpreter.booleanValueOf(this.params.switchValue);
        case 4:
          return settings.autoMessage.time = this.interpreter.numberValueOf(this.params.numberValue);
        case 5:
          return settings.autoMessage.waitForVoice = this.interpreter.booleanValueOf(this.params.switchValue);
        case 6:
          return settings.autoMessage.stopOnAction = this.interpreter.booleanValueOf(this.params.switchValue);
        case 7:
          return settings.timeMessageToVoice = this.interpreter.booleanValueOf(this.params.switchValue);
        case 8:
          return settings.allowVideoSkip = this.interpreter.booleanValueOf(this.params.switchValue);
        case 9:
          return settings.allowChoiceSkip = this.interpreter.booleanValueOf(this.params.switchValue);
        case 10:
          return settings.skipVoiceOnAction = this.interpreter.booleanValueOf(this.params.switchValue);
        case 11:
          settings.fullScreen = this.interpreter.booleanValueOf(this.params.switchValue);
          if (settings.fullScreen) {
            return SceneManager.scene.behavior.enterFullScreen();
          } else {
            return SceneManager.scene.behavior.leaveFullScreen();
          }
          break;
        case 12:
          settings.adjustAspectRatio = this.interpreter.booleanValueOf(this.params.switchValue);
          Graphics.keepRatio = settings.adjustAspectRatio;
          return Graphics.onResize();
        case 13:
          return settings.confirmation = this.interpreter.booleanValueOf(this.params.switchValue);
        case 14:
          return settings.bgmVolume = this.interpreter.numberValueOf(this.params.numberValue);
        case 15:
          return settings.voiceVolume = this.interpreter.numberValueOf(this.params.numberValue);
        case 16:
          return settings.seVolume = this.interpreter.numberValueOf(this.params.numberValue);
        case 17:
          return settings.bgmEnabled = this.interpreter.booleanValueOf(this.params.switchValue);
        case 18:
          return settings.voiceEnabled = this.interpreter.booleanValueOf(this.params.switchValue);
        case 19:
          return settings.seEnabled = this.interpreter.booleanValueOf(this.params.switchValue);
        case 20:
          code = this.interpreter.stringValueOf(this.params.textValue);
          language = LanguageManager.languages.first((function(_this) {
            return function(l) {
              return l.code === code;
            };
          })(this));
          if (language) {
            return LanguageManager.selectLanguage(language);
          }
          break;
        case 21:
          return GameManager.tempSettings.skip = this.interpreter.booleanValueOf(this.params.switchValue);
      }
    };


    /**
    * @method commandGetObjectData
    * @protected
     */

    Component_CommandInterpreter.prototype.commandGetObjectData = function() {
      var area, characterId, field, object, ref, ref1, scene;
      scene = SceneManager.scene;
      switch (this.params.objectType) {
        case 0:
          scene.behavior.changePictureDomain(this.params.numberDomain);
          object = SceneManager.scene.pictures[this.interpreter.numberValueOf(this.params.number)];
          break;
        case 1:
          object = SceneManager.scene.backgrounds[this.interpreter.numberValueOf(this.params.layer)];
          break;
        case 2:
          scene.behavior.changeTextDomain(this.params.numberDomain);
          object = SceneManager.scene.texts[this.interpreter.numberValueOf(this.params.number)];
          break;
        case 3:
          scene.behavior.changeVideoDomain(this.params.numberDomain);
          object = SceneManager.scene.videos[this.interpreter.numberValueOf(this.params.number)];
          break;
        case 4:
          characterId = this.interpreter.stringValueOf(this.params.characterId);
          object = SceneManager.scene.characters.first((function(_this) {
            return function(v) {
              return !v.disposed && v.rid === characterId;
            };
          })(this));
          break;
        case 5:
          object = gs.ObjectManager.current.objectById("messageBox");
          break;
        case 6:
          scene.behavior.changeMessageAreaDomain(this.params.numberDomain);
          area = SceneManager.scene.messageAreas[this.interpreter.numberValueOf(this.params.number)];
          object = area != null ? area.layout : void 0;
          break;
        case 7:
          scene.behavior.changeHotspotDomain(this.params.numberDomain);
          object = SceneManager.scene.hotspots[this.interpreter.numberValueOf(this.params.number)];
      }
      field = this.params.field;
      if (this.params.objectType === 4) {
        switch (this.params.field) {
          case 0:
            this.interpreter.setStringValueTo(this.params.targetVariable, ((ref = RecordManager.characters[characterId]) != null ? ref.index : void 0) || "");
            break;
          case 1:
            this.interpreter.setStringValueTo(this.params.targetVariable, lcs((ref1 = RecordManager.characters[characterId]) != null ? ref1.name : void 0) || "");
        }
        field -= 2;
      }
      if (this.params.objectType === 6) {
        switch (field) {
          case 0:
            return this.interpreter.setNumberValueTo(this.params.targetVariable, object.dstRect.x);
          case 1:
            return this.interpreter.setNumberValueTo(this.params.targetVariable, object.dstRect.y);
          case 2:
            return this.interpreter.setNumberValueTo(this.params.targetVariable, object.zIndex);
          case 3:
            return this.interpreter.setNumberValueTo(this.params.targetVariable, object.opacity);
          case 4:
            return this.interpreter.setBooleanValueTo(this.params.targetVariable, object.visible);
        }
      } else if (object != null) {
        if (field >= 0) {
          switch (field) {
            case 0:
              switch (this.params.objectType) {
                case 2:
                  return this.interpreter.setStringValueTo(this.params.targetVariable, object.text || "");
                case 3:
                  return this.interpreter.setStringValueTo(this.params.targetVariable, object.video || "");
                default:
                  return this.interpreter.setStringValueTo(this.params.targetVariable, object.image || "");
              }
              break;
            case 1:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.dstRect.x);
            case 2:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.dstRect.y);
            case 3:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, Math.round(object.anchor.x * 100));
            case 4:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, Math.round(object.anchor.y * 100));
            case 5:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, Math.round(object.zoom.x * 100));
            case 6:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, Math.round(object.zoom.y * 100));
            case 7:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.dstRect.width);
            case 8:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.dstRect.height);
            case 9:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.zIndex);
            case 10:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.opacity);
            case 11:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.angle);
            case 12:
              return this.interpreter.setBooleanValueTo(this.params.targetVariable, object.visible);
            case 13:
              return this.interpreter.setNumberValueTo(this.params.targetVariable, object.blendMode);
            case 14:
              return this.interpreter.setBooleanValueTo(this.params.targetVariable, object.mirror);
          }
        }
      }
    };


    /**
    * @method commandSetObjectData
    * @protected
     */

    Component_CommandInterpreter.prototype.commandSetObjectData = function() {
      var area, characterId, field, name, object, ref, scene;
      scene = SceneManager.scene;
      switch (this.params.objectType) {
        case 0:
          scene.behavior.changePictureDomain(this.params.numberDomain);
          object = SceneManager.scene.pictures[this.interpreter.numberValueOf(this.params.number)];
          break;
        case 1:
          object = SceneManager.scene.backgrounds[this.interpreter.numberValueOf(this.params.layer)];
          break;
        case 2:
          scene.behavior.changeTextDomain(this.params.numberDomain);
          object = SceneManager.scene.texts[this.interpreter.numberValueOf(this.params.number)];
          break;
        case 3:
          scene.behavior.changeVideoDomain(this.params.numberDomain);
          object = SceneManager.scene.videos[this.interpreter.numberValueOf(this.params.number)];
          break;
        case 4:
          characterId = this.interpreter.stringValueOf(this.params.characterId);
          object = SceneManager.scene.characters.first((function(_this) {
            return function(v) {
              return !v.disposed && v.rid === characterId;
            };
          })(this));
          break;
        case 5:
          object = gs.ObjectManager.current.objectById("messageBox");
          break;
        case 6:
          scene.behavior.changeMessageAreaDomain(this.params.numberDomain);
          area = SceneManager.scene.messageAreas[this.interpreter.numberValueOf(this.params.number)];
          object = area != null ? area.layout : void 0;
          break;
        case 7:
          scene.behavior.changeHotspotDomain(this.params.numberDomain);
          object = SceneManager.scene.hotspots[this.interpreter.numberValueOf(this.params.number)];
      }
      field = this.params.field;
      if (this.params.objectType === 4) {
        switch (field) {
          case 0:
            name = this.interpreter.stringValueOf(this.params.textValue);
            if (object != null) {
              object.name = name;
            }
            if ((ref = RecordManager.characters[characterId]) != null) {
              ref.name = name;
            }
        }
        field--;
      }
      if (this.params.objectType === 6) {
        switch (field) {
          case 0:
            return object.dstRect.x = this.interpreter.numberValueOf(this.params.numberValue);
          case 1:
            return object.dstRect.y = this.interpreter.numberValueOf(this.params.numberValue);
          case 2:
            return object.zIndex = this.interpreter.numberValueOf(this.params.numberValue);
          case 3:
            return object.opacity = this.interpreter.numberValueOf(this.params.numberValue);
          case 4:
            return object.visible = this.interpreter.booleanValueOf(this.params.switchValue);
        }
      } else if (object != null) {
        if (field >= 0) {
          switch (field) {
            case 0:
              switch (this.params.objectType) {
                case 2:
                  return object.text = this.interpreter.stringValueOf(this.params.textValue);
                case 3:
                  return object.video = this.interpreter.stringValueOf(this.params.textValue);
                default:
                  return object.image = this.interpreter.stringValueOf(this.params.textValue);
              }
              break;
            case 1:
              return object.dstRect.x = this.interpreter.numberValueOf(this.params.numberValue);
            case 2:
              return object.dstRect.y = this.interpreter.numberValueOf(this.params.numberValue);
            case 3:
              return object.anchor.x = this.interpreter.numberValueOf(this.params.numberValue) / 100;
            case 4:
              return object.anchor.y = this.interpreter.numberValueOf(this.params.numberValue) / 100;
            case 5:
              return object.zoom.x = this.interpreter.numberValueOf(this.params.numberValue) / 100;
            case 6:
              return object.zoom.y = this.interpreter.numberValueOf(this.params.numberValue) / 100;
            case 7:
              return object.zIndex = this.interpreter.numberValueOf(this.params.numberValue);
            case 8:
              return object.opacity = this.interpreter.numberValueOf(this.params.numberValue);
            case 9:
              return object.angle = this.interpreter.numberValueOf(this.params.numberValue);
            case 10:
              return object.visible = this.interpreter.booleanValueOf(this.params.switchValue);
            case 11:
              return object.blendMode = this.interpreter.numberValueOf(this.params.numberValue);
            case 12:
              return object.mirror = this.interpreter.booleanValueOf(this.params.switchValue);
          }
        }
      }
    };


    /**
    * @method commandChangeSounds
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeSounds = function() {
      var fieldFlags, i, k, len, ref, results, sound, sounds;
      sounds = RecordManager.system.sounds;
      fieldFlags = this.params.fieldFlags || {};
      ref = this.params.sounds;
      results = [];
      for (i = k = 0, len = ref.length; k < len; i = ++k) {
        sound = ref[i];
        if (!gs.CommandFieldFlags.isLocked(fieldFlags["sounds." + i])) {
          results.push(sounds[i] = this.params.sounds[i]);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * @method commandChangeColors
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeColors = function() {
      var color, colors, fieldFlags, i, k, len, ref, results;
      colors = RecordManager.system.colors;
      fieldFlags = this.params.fieldFlags || {};
      ref = this.params.colors;
      results = [];
      for (i = k = 0, len = ref.length; k < len; i = ++k) {
        color = ref[i];
        if (!gs.CommandFieldFlags.isLocked(fieldFlags["colors." + i])) {
          results.push(colors[i] = new gs.Color(this.params.colors[i]));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * @method commandChangeScreenCursor
    * @protected
     */

    Component_CommandInterpreter.prototype.commandChangeScreenCursor = function() {
      var bitmap, ref;
      if (((ref = this.params.graphic) != null ? ref.name : void 0) != null) {
        bitmap = ResourceManager.getBitmap("Graphics/Pictures/" + this.params.graphic.name);
        return Graphics.setCursorBitmap(bitmap, this.params.hx, this.params.hy);
      } else {
        return Graphics.setCursorBitmap(null, 0, 0);
      }
    };


    /**
    * @method commandResetGlobalData
    * @protected
     */

    Component_CommandInterpreter.prototype.commandResetGlobalData = function() {
      return GameManager.resetGlobalData();
    };


    /**
    * @method commandScript
    * @protected
     */

    Component_CommandInterpreter.prototype.commandScript = function() {
      var ex;
      try {
        if (!this.params.scriptFunc) {
          this.params.scriptFunc = eval("(function(){" + this.params.script + "})");
        }
        return this.params.scriptFunc();
      } catch (error) {
        ex = error;
        return console.log(ex);
      }
    };

    return Component_CommandInterpreter;

  })(gs.Component);

  window.CommandInterpreter = Component_CommandInterpreter;

  gs.Component_CommandInterpreter = Component_CommandInterpreter;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_CallSceneInterpreter,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_CallSceneInterpreter = (function(superClass) {
    extend(Component_CallSceneInterpreter, superClass);

    Component_CallSceneInterpreter.objectCodecBlackList = gs.Component_CommandInterpreter.objectCodecBlackList;


    /**
    * A command interpreter used as a sub-interpreter to execute CallScene commands. See
    * gs.Component_CommandInterpreter for more information.
    *
    * @module gs
    * @class Component_CallSceneInterpreter
    * @extends gs.Component_CommandInterpreter
    * @memberof gs
     */

    function Component_CallSceneInterpreter() {
      Component_CallSceneInterpreter.__super__.constructor.apply(this, arguments);
    }


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_CallSceneInterpreter.prototype.onDataBundleRestore = function(data, context) {
      var sceneDocument;
      sceneDocument = DataManager.getDocument(this.context.id);
      this.context.set(sceneDocument.uid, sceneDocument);
      return this.object = {
        commands: sceneDocument.items.commands
      };
    };

    return Component_CallSceneInterpreter;

  })(gs.Component_CommandInterpreter);

  vn.Component_CallSceneInterpreter = Component_CallSceneInterpreter;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Timer,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Timer = (function(superClass) {
    extend(Component_Timer, superClass);


    /**
    * A component which adds timing-features to a game object. A timer-component
    * can be used as a regular timer or as a stop-watch.
    *
    * @module gs
    * @class Component_Timer
    * @extends gs.Component
    * @memberof gs
     */

    function Component_Timer() {
      Component_Timer.__super__.constructor.call(this);

      /**
      * Indicates if the timer is running. 
      *
      * @property isRunning
      * @type boolean
      * @readOnly
       */
      this.isRunning = false;

      /**
      * @property frameCount
      * @type number
      * @private
       */
      this.frameCount = 0;
    }


    /**
    * Starts the timer. 
    *
    * @method start
     */

    Component_Timer.prototype.start = function() {
      this.isRunning = true;
      if (this.object.stopWatch) {
        return this.frameCount = 0;
      } else {
        return this.frameCount = this.minutes * 60 * 60 + this.seconds * 60;
      }
    };


    /**
    * Stops the timer. 
    *
    * @method stop
     */

    Component_Timer.prototype.stop = function() {
      return this.isRunning = false;
    };


    /**
    * Resumes the timer. 
    *
    * @method resume
     */

    Component_Timer.prototype.resume = function() {
      return this.isRunning = true;
    };


    /**
    * Pauses the timer. 
    *
    * @method pause
     */

    Component_Timer.prototype.pause = function() {
      return this.isRunning = false;
    };


    /**
    * Updates the timer.
    *
    * @method update
     */

    Component_Timer.prototype.update = function() {
      if (this.object.stopWatch) {
        return this.updateStopWatch();
      } else {
        return this.updateTimer();
      }
    };


    /**
    * Updates the regular timer behavior
    *
    * @method updateTimer
     */

    Component_Timer.prototype.updateTimer = function() {
      var ref, seconds;
      if (this.isRunning && this.frameCount === 0) {
        this.isRunning = false;
        if ((ref = this.object.events) != null) {
          ref.emit("finish", this);
        }
      }
      if (!this.isRunning) {
        return;
      }
      seconds = Math.round(this.frameCount / 60);
      this.seconds = seconds % 60;
      this.minutes = Math.floor(seconds / 60);
      return this.frameCount--;
    };


    /**
    * Updates the stop-watch behavior
    *
    * @method updateStopWatch
     */

    Component_Timer.prototype.updateStopWatch = function() {
      var seconds;
      if (!this.isRunning) {
        return;
      }
      seconds = Math.round(this.frameCount / 60);
      this.seconds = seconds % 60;
      this.minutes = Math.floor(seconds / 60);
      return this.frameCount++;
    };

    return Component_Timer;

  })(gs.Component);

  gs.Component_Timer = Component_Timer;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_IntervalTimer,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_IntervalTimer = (function(superClass) {
    extend(Component_IntervalTimer, superClass);


    /**
    * A component which adds timing-features to a game object. The game object
    * will send an "elapsed" event everytime the time interval has been elapsed.
    *
    * @module gs
    * @class Component_IntervalTimer
    * @extends gs.Component
    * @memberof gs
     */

    function Component_IntervalTimer() {
      Component_IntervalTimer.__super__.constructor.call(this);

      /**
      * Indicates if the timer is running. 
      *
      * @property isRunning
      * @type boolean
      * @readOnly
       */
      this.isRunning = false;

      /**
      * @property frameCount
      * @type number
      * @private
       */
      this.frameCount = 0;

      /**
      * The interval at which the associated action will be executed.
      * @property interval
      * @type number
       */
      this.interval = 0;
    }


    /**
    * Starts the timer. 
    *
    * @method start
     */

    Component_IntervalTimer.prototype.start = function() {
      this.isRunning = true;
      return this.frameCount = 0;
    };


    /**
    * Stops the timer. 
    *
    * @method stop
     */

    Component_IntervalTimer.prototype.stop = function() {
      return this.isRunning = false;
    };


    /**
    * Resumes the timer. 
    *
    * @method resume
     */

    Component_IntervalTimer.prototype.resume = function() {
      return this.isRunning = true;
    };


    /**
    * Pauses the timer. 
    *
    * @method pause
     */

    Component_IntervalTimer.prototype.pause = function() {
      return this.isRunning = false;
    };


    /**
    * Updates the timer.
    *
    * @method update
     */

    Component_IntervalTimer.prototype.update = function() {
      if (this.isRunning) {
        this.frameCount++;
        if (this.frameCount >= this.interval) {
          this.object.events.emit("elapsed", this.object);
          return this.frameCount = 0;
        }
      }
    };

    return Component_IntervalTimer;

  })(gs.Component);

  gs.Component_IntervalTimer = Component_IntervalTimer;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_InputHandler,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_InputHandler = (function(superClass) {
    extend(Component_InputHandler, superClass);


    /**
    * The input-handler component is an interface between the input-system
    * of the basic-engine and the game's event-system. In regular this
    * component is used only by game scene to allow its game objects to
    * receive input-events.
    *
    * Those input-events are necessary to solve the problem which game-object
    * responds to a user-action first by building a responder-chain.
    *
    * @module gs
    * @class Component_InputHandler
    * @extends gs.Component
    * @memberof gs
     */

    function Component_InputHandler() {

      /**
      * Indicates if all input events, such as mouse and keyboard event, should be blocked.
      *
      * @property blockInput
      * @type boolean
      * @default false
       */
      this.blockInput = false;
    }


    /**
    * Sets up event handlers.
    *
    * @method setup
     */

    Component_InputHandler.prototype.setup = function() {
      Component_InputHandler.__super__.setup.apply(this, arguments);
      gs.GlobalEventManager.on("uiAnimationStart", ((function(_this) {
        return function(e) {
          return _this.blockInput = true;
        };
      })(this)), null, this.object);
      return gs.GlobalEventManager.on("uiAnimationFinish", ((function(_this) {
        return function(e) {
          return _this.blockInput = false;
        };
      })(this)), null, this.object);
    };


    /**
    * Disposes the component and removes event handlers.
    *
    * @method dispose
     */

    Component_InputHandler.prototype.dispose = function() {
      Component_InputHandler.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("uiAnimationStart", this.object);
      return gs.GlobalEventManager.offByOwner("uiAnimationFinish", this.object);
    };


    /**
    * Updates the component by checking the input-system and firing
    * an input-event if necessary.
    *
    * @method update
     */

    Component_InputHandler.prototype.update = function() {
      if (this.blockInput) {
        return;
      }
      if (Input.Mouse.moved) {
        gs.GlobalEventManager.emit("mouseMoved");
      }
      if (Input.Mouse.buttonDown) {
        gs.GlobalEventManager.emit("mouseDown");
      }
      if (Input.Mouse.buttonUp) {
        gs.GlobalEventManager.emit("mouseUp");
      }
      if (Input.keyDown) {
        gs.GlobalEventManager.emit("keyDown");
      }
      if (Input.keyUp) {
        gs.GlobalEventManager.emit("keyUp");
      }
      if (Input.Mouse.wheelChanged) {
        return gs.GlobalEventManager.emit("mouseWheel");
      }
    };

    return Component_InputHandler;

  })(gs.Component);

  gs.Component_InputHandler = Component_InputHandler;

}).call(this);



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=UI_165.js
// Generated by CoffeeScript 1.12.7
(function() {
  var Component_TextBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_TextBehavior = (function(superClass) {
    extend(Component_TextBehavior, superClass);

    Component_TextBehavior.memoryUsage = 0;


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_TextBehavior.prototype.onDataBundleRestore = function(data, context) {
      var ref, ref1, size;
      if (this.renderedLines) {
        size = this.object.textRenderer.measureFormattedLines(this.renderedLines, (ref = this.object.wordWrap) != null ? ref : true);
        this.refreshWithSize(size);
        this.refreshBitmap();
        return this.object.textRenderer.drawFormattedLines(this.padding.left, this.padding.top, this.padding.right, this.padding.bottom, this.renderedLines, (ref1 = this.object.wordWrap) != null ? ref1 : true);
      } else {
        return this.refresh(true);
      }
    };


    /**
    * 
    *
    * @module gs
    * @class Component_TextBehavior
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_TextBehavior() {
      Component_TextBehavior.__super__.constructor.call(this);

      /**
      * The current text displayed.
      * @property text
      * @type string
      * @protected
       */
      this.text = "";
      this.renderedLines = null;

      /**
      * The space around the text.
      * @property padding
      * @type string
      * @protected
       */
      this.padding = new ui.Space(6, 0, 6, 0);

      /**
      * The font used for text-rendering.
      * @property font
      * @type string
      * @protected
       */
      this.font = new Font(gs.Fonts.TEXT);

      /**
      * Standard Format String which can be used if the text represents a number value.
      * Example: If the text is "3" and format is "%0d3" then 003 is the displayed text.
      * @property format
      * @type string
      * @protected
       */
      this.format = null;
    }


    /**
    * Disposes the component and bitmap.
    *
    * @method dispose
     */

    Component_TextBehavior.prototype.dispose = function() {
      if (this.object.bitmap != null) {
        this.object.bitmap.dispose();
        return this.object.bitmap = null;
      }
    };


    /**
    * Redraws the texts on game object's bitmap.
    *
    * @method redraw
     */

    Component_TextBehavior.prototype.redraw = function() {
      var ref, text;
      if (this.text != null) {
        this.object.bitmap.clear();
        this.object.bitmap.font = this.object.font;
        text = lcs(this.text);
        if (this.format != null) {
          text = sprintf(this.format, text);
        }
        if (this.object.formatting) {
          return this.renderedLines = this.object.textRenderer.drawFormattedText(this.padding.left, this.padding.top, this.padding.right, this.padding.bottom, text, (ref = this.object.wordWrap) != null ? ref : true);
        } else {
          return this.object.textRenderer.drawText(this.padding.left, this.padding.top, this.padding.right, this.padding.bottom, text);
        }
      }
    };


    /**
    * Updates the game object's <b>dstRect</b> so that the text fits in. That only works
    * if the game object's <b>sizeToFit</b> property is set.
    *
    * @method refreshSize
     */

    Component_TextBehavior.prototype.refreshSize = function() {
      var ref, size, text;
      if (this.object.text == null) {
        return;
      }
      this.text = this.object.text;
      text = lcs(this.object.text).toString();
      if (this.format != null) {
        text = sprintf(this.format, text);
      }
      if (this.object.sizeToFit) {
        this.object.font = this.object.font || this.font;
        if (this.object.formatting) {
          size = this.object.textRenderer.measureFormattedText(text, (ref = this.object.wordWrap) != null ? ref : true);
        } else {
          size = this.object.textRenderer.measureText(text);
        }
        return this.refreshWithSize(size);
      }
    };


    /**
    * Updates the game object's <b>dstRect</b> with the specified text size.
    *
    * @param {gs.Size} size - The text size to resize the game object for.
    * @method refreshWithSize
     */

    Component_TextBehavior.prototype.refreshWithSize = function(size) {
      if (!(this.object.sizeToFit.horizontal != null) || this.object.sizeToFit.horizontal) {
        this.object.dstRect.width = size.width + this.padding.right + this.padding.left;
      }
      if (!(this.object.sizeToFit.vertical != null) || this.object.sizeToFit.vertical) {
        return this.object.dstRect.height = size.height + this.padding.bottom + this.padding.top;
      }
    };


    /**
    * Recreates and clears the game object's bitmap if necessary.
    *
    * @method refreshBitmap
     */

    Component_TextBehavior.prototype.refreshBitmap = function() {
      var height, ref, ref1, ref2, width;
      width = ((ref = this.object.bitmap) != null ? ref.width : void 0) || 0;
      height = ((ref1 = this.object.bitmap) != null ? ref1.height : void 0) || 0;
      if (!this.object.bitmap || width !== this.object.dstRect.width || height !== this.object.dstRect.height) {
        if ((ref2 = this.object.bitmap) != null) {
          ref2.dispose();
        }
        this.object.bitmap = new Bitmap(this.object.dstRect.width, this.object.dstRect.height);
      } else {
        this.object.bitmap.clear();
      }
      return this.object.bitmap.font = this.object.font;
    };


    /**
    * Refreshes the texts on game object's bitmap. If the text or font has not been
    * changed, no refresh will happen.
    *
    * @method refresh
    * @param {boolean} force - If set to <b>true</b> it will force redrawing the text even if the
    * text and font has not been changed.
     */

    Component_TextBehavior.prototype.refresh = function(force) {
      var fontChange;
      fontChange = !this.font.compare(this.object.font);
      if ((this.object.text == null) || (!force && this.object.text === this.text && !fontChange)) {
        return;
      }
      if (fontChange) {
        this.font.set(this.object.font);
      }
      this.refreshSize();
      this.refreshBitmap();
      this.srcRect = new Rect(0, 0, this.object.dstRect.width, this.object.dstRect.height);
      this.object.srcRect = this.srcRect;
      return this.redraw();
    };


    /**
    * Action to append a specified text.
    *
    * @method addText
    * @param {Object} sender - The sender of the action.
    * @param {Object} params - The action's parameters.
     */

    Component_TextBehavior.prototype.addText = function(sender, params) {
      return this.object.text += ui.Component_FormulaHandler.fieldValue(sender, params.text);
    };


    /**
    * Updates the component. Checks if the game object's bitmap needs a refresh
    * and maybe disposes the bitmap if the game object's is out of the
    * screen and memory usage is too high.
    *
    * @method update
     */

    Component_TextBehavior.prototype.update = function() {
      var ref, visible;
      Component_TextBehavior.__super__.update.apply(this, arguments);
      visible = this.object.visual.visible;
      if (!this.object.bitmap || this.object.bitmap.width !== this.object.dstRect.width || this.object.bitmap.height !== this.object.dstRect.height || ((ref = lcs(this.object.text)) != null ? ref.toString() : void 0) !== lcs(this.text)) {
        return this.refresh();
      }
    };

    return Component_TextBehavior;

  })(gs.Component);

  gs.Component_TextBehavior = Component_TextBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_HotspotBehavior, HotspotShape,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  HotspotShape = (function() {
    function HotspotShape() {}

    HotspotShape.RECTANGLE = "rect";

    HotspotShape.PIXEL = "pixel";

    return HotspotShape;

  })();

  gs.HotspotShape = HotspotShape;

  Component_HotspotBehavior = (function(superClass) {
    extend(Component_HotspotBehavior, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    *
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_HotspotBehavior.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * Adds a hotspot-behavior to a game object. That allows a game object
    * to respond to mouse/touch actions by firing an action-event or changing
    * the game object's image.
    *
    * @module gs
    * @class Component_HotspotBehavior
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_HotspotBehavior(params) {

      /**
      * The shape used to detect if a hotspot is clicked, hovered, etc.
      * @property shape
      * @type boolean
       */
      var ref;
      this.shape = gs.HotspotShape.RECTANGLE;

      /**
      * Indicates if the hotspot is selected.
      * @property selected
      * @type boolean
       */
      this.selected = false;

      /**
      * Indicates if the hotspot is enabled.
      * @property enabled
      * @type boolean
       */
      this.enabled = true;

      /**
      * @property imageHandling
      * @type number
      * @protected
       */
      this.imageHandling = 0;

      /**
      * Indicates if the mouse/touch pointer is inside the hotspot bounds.
      * @property contains
      * @type boolean
      * @protected
       */
      this.containsPointer = false;

      /**
      * Indicates if the action-button was pressed before.
      * @property buttonUp
      * @type boolean
      * @protected
       */
      this.buttonUp = false;

      /**
      * Indicates if the action-button is pressed.
      * @property buttonDown
      * @type boolean
      * @protected
       */
      this.buttonDown = false;

      /**
      * @property actionButtons
      * @type Object
      * @protected
       */
      this.actionButtons = {
        "left": Input.Mouse.BUTTON_LEFT,
        "right": Input.Mouse.BUTTON_RIGHT,
        "middle": Input.Mouse.BUTTON_MIDDLE
      };

      /**
      * The default action-button. By default the left-button is used.
      *
      * @property actionButton
      * @type number
       */
      this.actionButton = this.actionButtons[(ref = params != null ? params.actionButton : void 0) != null ? ref : "left"];

      /**
      * The sound played if the hotspot action is executed.
      * @property sound
      * @type Object
       */
      this.sound = params != null ? params.sound : void 0;

      /**
      * <p>The sounds played depending on the hotspot state.</p>
      * <ul>
      * <li>0 = Select Sound</li>
      * <li>1 = Unselect Sound</li>
      * </ul>
      * @property sounds
      * @type Object[]
       */
      this.sounds = (params != null ? params.sounds : void 0) || [];
    }


    /**
    * Gets the render-index of the object associated with the hotspot component. This
    * implementation is necessary to be able to act as an owner for gs.EventEmitter.on
    * event registration.
    *
    * @property rIndex
    * @type number
     */

    Component_HotspotBehavior.accessors("rIndex", {
      get: function() {
        return this.object.rIndex;
      }
    });


    /**
    * Sets up event handlers.
    *
    * @method setupEventHandlers
     */

    Component_HotspotBehavior.prototype.setupEventHandlers = function() {
      gs.GlobalEventManager.offByOwner("mouseUp", this);
      gs.GlobalEventManager.offByOwner("mouseMoved", this);
      gs.GlobalEventManager.on("hotspotDrop", ((function(_this) {
        return function(e) {
          var hotspot, j, len, rect, ref, results, scene;
          scene = SceneManager.scene;
          ref = scene.hotspots;
          results = [];
          for (j = 0, len = ref.length; j < len; j++) {
            hotspot = ref[j];
            rect = e.sender.dstRect;
            if ((hotspot != null) && hotspot !== e.sender && hotspot.dstRect.intersect(rect.x, rect.y, rect.width, rect.height)) {
              results.push(hotspot.events.emit("dropReceived", hotspot));
            } else {
              results.push(void 0);
            }
          }
          return results;
        };
      })(this)), null, this);
      gs.GlobalEventManager.on("mouseUp", ((function(_this) {
        return function(e) {
          var contains, mx, my;
          if (!_this.object.visible) {
            return;
          }
          mx = Input.Mouse.x - _this.object.origin.x;
          my = Input.Mouse.y - _this.object.origin.y;
          contains = Rect.contains(_this.object.dstRect.x, _this.object.dstRect.y, _this.object.dstRect.width, _this.object.dstRect.height, mx, my);
          if (contains) {
            contains = _this.checkShape(mx - _this.object.dstRect.x, my - _this.object.dstRect.y);
            if (contains) {
              _this.containsPointer = contains;
              _this.updateInput();
              _this.updateEvents();
              _this.object.needsUpdate = true;
              return e.breakChain = true;
            }
          }
        };
      })(this)), null, this);
      if (this.object.images || true) {
        return gs.GlobalEventManager.on("mouseMoved", ((function(_this) {
          return function(e) {
            var contains, mx, my;
            if (!_this.object.visible) {
              return;
            }
            contains = Rect.contains(_this.object.dstRect.x, _this.object.dstRect.y, _this.object.dstRect.width, _this.object.dstRect.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y);
            if (contains) {
              mx = Input.Mouse.x - _this.object.origin.x;
              my = Input.Mouse.y - _this.object.origin.y;
              contains = _this.checkShape(mx - _this.object.dstRect.x, my - _this.object.dstRect.y);
            }
            if (_this.containsPointer !== contains) {
              _this.containsPointer = contains;
              _this.object.needsUpdate = true;
              if (contains) {
                _this.object.events.emit("enter", _this);
              } else {
                _this.object.events.emit("leave", _this);
              }
            }
            return _this.updateInput();
          };
        })(this)), null, this);
      }
    };


    /**
    * Initializes the hotspot component.
    *
    * @method setup
     */

    Component_HotspotBehavior.prototype.setup = function() {
      var i, j, len, ref, sound;
      Component_HotspotBehavior.__super__.setup.apply(this, arguments);
      this.sound = ui.Component_FormulaHandler.fieldValue(this.object, this.sound);
      if (this.sounds != null) {
        ref = this.sounds;
        for (i = j = 0, len = ref.length; j < len; i = ++j) {
          sound = ref[i];
          this.sounds[i] = ui.Component_FormulaHandler.fieldValue(this.object, sound);
        }
      } else {
        this.sounds = [];
      }
      return this.setupEventHandlers();
    };


    /**
    * Disposes the component.
    *
    * @method dispose
     */

    Component_HotspotBehavior.prototype.dispose = function() {
      Component_HotspotBehavior.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("mouseUp", this);
      return gs.GlobalEventManager.offByOwner("mouseMoved", this);
    };


    /**
    * Checks if the specified point is inside of the hotspot's shape.
    *
    * @method checkShape
    * @param x - The x-coordinate of the point.
    * @param y - The y-coordinate of the point.
    * @return If <b>true</b> the point is inside of the hotspot's shape. Otherwise <b>false</b>.
     */

    Component_HotspotBehavior.prototype.checkShape = function(x, y) {
      var ref, result;
      result = true;
      switch (this.shape) {
        case gs.HotspotShape.PIXEL:
          if (this.object.bitmap) {
            result = this.object.bitmap.isPixelSet(x, y);
          } else {
            result = (ref = this.object.target) != null ? ref.bitmap.isPixelSet(x, y) : void 0;
          }
      }
      return result;
    };


    /**
    * Updates the image depending on the hotspot state.
    *
    * @method updateImage
    * @protected
     */

    Component_HotspotBehavior.prototype.updateImage = function() {
      var baseImage, object;
      object = this.object.target || this.object;
      if (this.object.images != null) {
        baseImage = this.enabled ? this.object.images[4] || this.object.images[0] : this.object.images[0];
        if (this.containsPointer) {
          if (this.object.selected || this.selected) {
            object.image = this.object.images[3] || this.object.images[2] || baseImage;
          } else {
            object.image = this.object.images[1] || baseImage;
          }
        } else {
          if (this.object.selected || this.selected) {
            object.image = this.object.images[2] || this.object.images[4] || baseImage;
          } else {
            object.image = baseImage;
          }
        }
        if (!object.image) {
          return object.bitmap = null;
        }
      }
    };


    /**
    * Updates the hotspot position and size from an other target game object. For example,
    * that is useful for adding a hotspot to an other moving game object.
    *
    * @method updateFromTarget
    * @protected
     */

    Component_HotspotBehavior.prototype.updateFromTarget = function() {
      if (this.object.target != null) {
        this.object.dstRect.x = this.object.target.dstRect.x;
        this.object.dstRect.y = this.object.target.dstRect.y;
        this.object.dstRect.width = this.object.target.dstRect.width;
        this.object.dstRect.height = this.object.target.dstRect.height;
        this.object.offset.x = this.object.target.offset.x;
        this.object.offset.y = this.object.target.offset.y;
        this.object.origin.x = this.object.target.origin.x;
        return this.object.origin.y = this.object.target.origin.y;
      }
    };


    /**
    * Updates the event-handling and fires necessary events.
    *
    * @method updateEvents
    * @protected
     */

    Component_HotspotBehavior.prototype.updateEvents = function() {
      var group, j, len, object;
      if (this.buttonUp && this.object.enabled && this.enabled && this.object.visible) {
        if (this.object.selectable) {
          group = gs.ObjectManager.current.objectsByGroup(this.object.group);
          for (j = 0, len = group.length; j < len; j++) {
            object = group[j];
            if (object !== this.object) {
              object.selected = false;
            }
          }
          if (this.object.group) {
            this.selected = true;
          } else {
            this.selected = !this.selected;
          }
          if (this.selected) {
            AudioManager.playSound(this.sounds[0] || this.sound);
          } else {
            AudioManager.playSound(this.sounds[1] || this.sound);
          }
          this.object.events.emit("click", this);
          return this.object.events.emit("stateChanged", this.object);
        } else {
          AudioManager.playSound(this.sounds[0] || this.sound);
          this.object.events.emit("click", this);
          return this.object.events.emit("action", this);
        }
      }
    };


    /**
    * Updates the game object's color depending on the state of the hotspot.
    *
    * @method updateColor
    * @protected
     */

    Component_HotspotBehavior.prototype.updateColor = function() {
      if (!this.object.enabled) {
        return this.object.color.set(0, 0, 0, 100);
      } else {
        return this.object.color.set(0, 0, 0, 0);
      }
    };


    /**
    * Stores current states of mouse/touch pointer and buttons.
    *
    * @method updateInput
    * @protected
     */

    Component_HotspotBehavior.prototype.updateInput = function() {
      this.buttonUp = Input.Mouse.buttons[this.actionButton] === 2 && this.containsPointer;
      return this.buttonDown = Input.Mouse.buttons[this.actionButton] === 1 && this.containsPointer;
    };


    /**
    * Updates the hotspot component.
    *
    * @method update
     */

    Component_HotspotBehavior.prototype.update = function() {
      if (!this.object.visible) {
        return;
      }
      this.updateColor();
      this.updateFromTarget();
      return this.updateImage();
    };

    return Component_HotspotBehavior;

  })(gs.Component);

  gs.Component_HotspotBehavior = Component_HotspotBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Draggable,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Draggable = (function(superClass) {
    extend(Component_Draggable, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    *
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_Draggable.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * Makes a game object draggable using mouse/touch. The dragging can be
    * vertical, horizontal or both. It can be configured as pixel-wise or
    * step-wise dragging. For example: To create a slider for UI with
    * fixed steps, step-wise is useful while a pixel-wise dragging could
    * be used for a volume-slider.
    *
    * @module gs
    * @class Component_Draggable
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_Draggable() {

      /**
      * Mouse/Pointer x coordinate
      * @property mx
      * @type number
       */
      this.mx = 0;

      /**
      * Mouse/Pointer y coordinate
      * @property my
      * @type number
       */
      this.my = 0;

      /**
      * Stepping in pixels.
      * @property stepSize
      * @type gs.Point
       */
      this.stepSize = {
        x: 0,
        y: 0
      };

      /**
      * Drag Area
      * @property rect
      * @type gs.Rect
       */
      this.rect = null;
    }


    /**
    * Adds event-handler for mouse/touch events to update the component only if
    * a user-action happened.
    *
    * @method setupEventHandlers
     */

    Component_Draggable.prototype.setupEventHandlers = function() {
      gs.GlobalEventManager.on("mouseMoved", ((function(_this) {
        return function(e) {
          var rect, ref, x, y;
          rect = (ref = _this.object.draggable) != null ? ref.rect : void 0;
          x = Input.Mouse.x - _this.object.origin.x;
          y = Input.Mouse.y - _this.object.origin.y;
          if (_this.object.dragging || rect.contains(x, y)) {
            _this.object.needsUpdate = true;
            return e.breakChain = true;
          }
        };
      })(this)), null, this.object);
      gs.GlobalEventManager.on("mouseDown", ((function(_this) {
        return function(e) {
          var rect, ref, x, y;
          rect = _this.object.dstRect;
          x = Input.Mouse.x - _this.object.origin.x;
          y = Input.Mouse.y - _this.object.origin.y;
          if (rect.contains(x, y)) {
            _this.object.dragging = true;
            _this.object.needsUpdate = true;
            if ((ref = _this.object.events) != null) {
              ref.emit("dragStart", _this.object);
            }
            return e.breakChain = true;
          }
        };
      })(this)), null, this.object);
      return gs.GlobalEventManager.on("mouseUp", ((function(_this) {
        return function(e) {
          if (_this.object.dragging) {
            _this.object.needsUpdate = true;
            return e.breakChain = true;
          }
        };
      })(this)), null, this.object);
    };


    /**
    * Initializes the component. Adds event-handler for mouse/touch events to
    * update the component only if a user-action happened.
    *
    * @method setup
     */

    Component_Draggable.prototype.setup = function() {
      return this.setupEventHandlers();
    };


    /**
    * Disposes the component.
    *
    * @method dispose
     */

    Component_Draggable.prototype.dispose = function() {
      Component_Draggable.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("mouseDown", this.object);
      return gs.GlobalEventManager.offByOwner("mouseMoved", this.object);
    };


    /**
    * Updates the dragging-process on x-axis if configured.
    *
    * @method updateAxisX
    * @protected
     */

    Component_Draggable.prototype.updateAxisX = function() {
      var ref;
      if ((ref = this.object.draggable.axisX) != null ? ref : true) {
        if (this.object.dragging) {
          this.object.draggable.step = Math.round(Math.max(this.rect.x, Math.min(this.mx - this.object.dstRect.width / 2, this.rect.x + this.rect.width - this.object.dstRect.width)) / this.stepSize.x);
          return this.object.dstRect.x = this.object.draggable.step * this.stepSize.x;
        } else if (this.object.draggable.steps != null) {
          return this.object.dstRect.x = this.object.draggable.step * this.stepSize.x;
        }
      }
    };


    /**
    * Updates the dragging-process on y-axis if configured.
    *
    * @method updateAxisY
    * @protected
     */

    Component_Draggable.prototype.updateAxisY = function() {
      var ref;
      if ((ref = this.object.draggable.axisY) != null ? ref : true) {
        if (this.object.dragging) {
          this.object.draggable.step = Math.round(Math.max(this.rect.y, Math.min(this.my - this.object.dstRect.height / 2, this.rect.y + this.rect.height - this.object.dstRect.height)) / this.stepSize.y);
          return this.object.dstRect.y = this.object.draggable.step * this.stepSize.y;
        } else if (this.object.draggable.steps != null) {
          return this.object.dstRect.y = this.object.draggable.step * this.stepSize.y;
        }
      }
    };


    /**
    * Calculates the size of a single step if steps are configured for this
    * component. Otherwise the step-size 1-pixel.
    *
    * @method updateDragging
    * @protected
     */

    Component_Draggable.prototype.updateStepSize = function() {
      if (this.object.draggable.steps != null) {
        this.stepSize.x = (this.rect.width - this.object.dstRect.width) / (this.object.draggable.steps - 1);
        return this.stepSize.y = (this.rect.height - this.object.dstRect.height) / (this.object.draggable.steps - 1);
      } else {
        this.stepSize.x = 1;
        return this.stepSize.y = 1;
      }
    };


    /**
    * Updates the game object's dragging-state and fires a dragged-event
    * if necessary.
    *
    * @method updateDragging
    * @protected
     */

    Component_Draggable.prototype.updateDragging = function() {
      var ref, x, y;
      if (this.object.focusable && !this.object.ui.focused) {
        return;
      }
      x = Input.Mouse.x - this.object.origin.x;
      y = Input.Mouse.y - this.object.origin.y;
      if (this.object.dragging) {
        if (this.mx !== x || this.my !== y) {
          this.object.events.emit("drag", this.object);
        }
        if (Input.Mouse.buttons[Input.Mouse.LEFT] === 2 || Input.Mouse.buttons[Input.Mouse.LEFT] === 0) {
          this.object.dragging = false;
          if ((ref = this.object.events) != null) {
            ref.emit("dragEnd", this.object);
          }
        }
      }
      this.mx = x;
      return this.my = y;
    };


    /**
    * Updates the dragging-logic.
    *
    * @method update
     */

    Component_Draggable.prototype.update = function() {
      var ref;
      this.rect = ((ref = this.object.draggable) != null ? ref.rect : void 0) || this.object.dstRect;
      this.updateStepSize();
      this.updateDragging();
      this.updateAxisX();
      return this.updateAxisY();
    };

    return Component_Draggable;

  })(gs.Component);

  ui.Draggable = Component_Draggable;

  ui.Component_Draggable = Component_Draggable;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_LayoutBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_LayoutBehavior = (function(superClass) {
    extend(Component_LayoutBehavior, superClass);


    /**
    * The base class of all layout-components. A layout-component is used
    * to layout assigned sub-objects in a specific way depending on the layout-type.
    * For example: A grid-layout layouts its sub-objects like a grid using rows
    * and columns. The game object needs a container-component.<br><br>
    *
    * A layout can also be configured as scrollable. In that case, layout's content
    * can be larger than the layout-bounds and is automatically clipped. The content
    * can be scrolled using mouse-wheel or touch-gesture.
    *
    * @module gs
    * @class Component_LayoutBehavior
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_LayoutBehavior() {

      /**
      * Content size of the layout.
      * @property contentSize
      * @type gs.Size
      * @readOnly
       */
      this.contentSize = {
        width: 0,
        height: 0
      };
    }


    /**
    * Disposes the layout and all its sub-objects.
    *
    * @method dispose
     */

    Component_LayoutBehavior.prototype.dispose = function() {
      var control, i, len, ref, results;
      ref = this.object.controls;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        control = ref[i];
        results.push(control != null ? control.dispose() : void 0);
      }
      return results;
    };


    /**
    * Initializes the layout.
    *
    * @method setup
     */

    Component_LayoutBehavior.prototype.setup = function() {};


    /**
    * Sizes the layout to fit its content.
    *
    * @method sizeToFit
    * @abstract
     */

    Component_LayoutBehavior.prototype.sizeToFit = function() {};


    /**
    * Sort-Function to sort sub-objects by order-index.
    *
    * @method sort_
    * @protected
    * @param {gs.Object_Base} a Object A
    * @param {gs.Object_Base} b Object B
     */

    Component_LayoutBehavior.prototype.sort_ = function(a, b) {
      if (a.order > b.order) {
        return -1;
      } else if (a.order < b.order) {
        return 1;
      } else {
        return 0;
      }
    };


    /**
    * Updates a specified control.
    *
    * @method updateControl
    * @protected
    * @param {gs.Object_Base} control The control to update
     */

    Component_LayoutBehavior.prototype.updateControl = function(control) {
      this.object.rIndex = Math.max(this.object.rIndex, control.rIndex);
      if (control.updateBehavior === ui.UpdateBehavior.CONTINUOUS) {
        control.needsUpdate = true;
      }
      if (control.inheritProperties) {
        control.ui.enabled = this.object.ui.enabled;
        control.opacity = this.object.opacity;
        control.zoom = this.object.zoom;
        control.color = this.object.color;
        control.tone = this.object.tone;
        control.angle = this.object.angle;
        control.anchor.x = this.object.anchor.x;
        control.anchor.y = this.object.anchor.y;
      }
      if (control.needsUpdate) {
        control.needsUpdate = false;
        control.update();
        control.parent = this.object;
      }
      if (this.object.clipRect != null) {
        return control.clipRect = this.object.clipRect;
      }
    };


    /**
    * Updates the content size of the layout. Only works if scrolling is
    * enabled.
    *
    * @method updateContentSize
    * @protected
     */

    Component_LayoutBehavior.prototype.updateContentSize = function() {
      var control, i, len, ref;
      if (this.object.scrollable) {
        this.contentSize.width = 0;
        this.contentSize.height = 0;
        ref = this.object.controls;
        for (i = 0, len = ref.length; i < len; i++) {
          control = ref[i];
          if (control) {
            this.contentSize.width += control.margin.left + control.dstRect.width + control.margin.right;
            this.contentSize.height += control.margin.top + control.dstRect.height + control.margin.bottom;
          }
        }
        this.object.contentHeight = this.contentSize.height;
        return this.object.contentWidth = this.contentSize.width;
      }
    };


    /**
    * Updates scrolling.
    *
    * @method updateScroll
     */

    Component_LayoutBehavior.prototype.updateScroll = function() {
      if (this.object.scrollable) {
        this.object.scrollableHeight = Math.max(0, this.contentSize.height - this.object.dstRect.height);
        if (Input.Mouse.wheel <= -1) {
          this.object.scrollOffsetY = Math.max(this.object.scrollOffsetY - Input.Mouse.wheelSpeed * 0.1, 0);
        }
        if (Input.Mouse.wheel >= 1) {
          this.object.scrollOffsetY = Math.min(this.object.scrollOffsetY - Input.Mouse.wheelSpeed * 0.1, this.object.scrollableHeight);
        }
        return this.object.scrollOffsetY = Math.max(Math.min(this.object.scrollOffsetY, this.object.scrollableHeight), 0);
      }
    };


    /**
    * Updates the layout's content.
    *
    * @method updateContent
     */

    Component_LayoutBehavior.prototype.updateContent = function() {};


    /**
    * Updates the layout.
    *
    * @method update
     */

    Component_LayoutBehavior.prototype.update = function() {
      Component_LayoutBehavior.__super__.update.apply(this, arguments);
      this.updateContentSize();
      return this.updateScroll();
    };

    return Component_LayoutBehavior;

  })(gs.Component_Visual);

  gs.Component_LayoutBehavior = Component_LayoutBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_FreeLayoutBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_FreeLayoutBehavior = (function(superClass) {
    extend(Component_FreeLayoutBehavior, superClass);


    /**
    * Turns a game object into a free-layout and layouts all sub-objects
    * at their specified positions. So that kind of layout allows each sub-object
    * to be freely positioned.
    * <br>
    * In addition, each sub-object can have different alignment options.
    *
    * @module gs
    * @class Component_FreeLayoutBehavior
    * @extends gs.Component_LayoutBehavior
    * @memberof gs
    * @constructor
     */

    function Component_FreeLayoutBehavior() {
      Component_FreeLayoutBehavior.__super__.constructor.apply(this, arguments);
    }


    /**
    * Sizes the layout to fit its content.
    *
    * @method sizeToFit
     */

    Component_FreeLayoutBehavior.prototype.sizeToFit = function() {
      var control, j, len, rect, ref, results;
      rect = this.object.dstRect;
      if (this.object.sizeToFit) {
        ref = this.object.subObjects;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          control = ref[j];
          if (!control.alignmentX) {
            rect.width = Math.max(control.margin.left + control.dstRect.width + control.margin.right, rect.width || 1);
          }
          if (!control.alignmentY) {
            results.push(rect.height = Math.max(control.margin.top + control.dstRect.height + control.margin.bottom, rect.height || 1));
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };


    /**
    * Updates a specified control.
    *
    * @method updateControl
    * @protected
    * @param {gs.Object_Base} control The control to update
     */

    Component_FreeLayoutBehavior.prototype.updateControl = function(control) {
      var margin, rect;
      Component_FreeLayoutBehavior.__super__.updateControl.apply(this, arguments);
      rect = this.object.dstRect;
      margin = control.margin;
      if (control.alignmentX === 1) {
        control.dstRect.x = (rect.width - (control.dstRect.width + margin.right + margin.left)) / 2;
      } else if (control.alignmentX === 2) {
        control.dstRect.x = rect.width * this.object.zoom.x - (control.dstRect.width + control.margin.right) * control.zoom.x;
      }
      if (control.alignmentY === 1) {
        return control.dstRect.y = (rect.height * this.object.zoom.y - (control.dstRect.height + margin.bottom + margin.top) * control.zoom.y) / 2;
      } else if (control.alignmentY === 2) {
        return control.dstRect.y = rect.height - (control.dstRect.height + control.margin.bottom);
      }
    };


    /**
    * Layouts the sub-objects.
    *
    * @method update
     */

    Component_FreeLayoutBehavior.prototype.update = function() {
      var control, i, j, len, ref;
      Component_FreeLayoutBehavior.__super__.update.apply(this, arguments);
      ref = this.object.subObjects;
      for (i = j = 0, len = ref.length; j < len; i = ++j) {
        control = ref[i];
        this.updateControl(control);
      }
      this.sizeToFit();
      return null;
    };

    return Component_FreeLayoutBehavior;

  })(gs.Component_LayoutBehavior);

  gs.Component_FreeLayoutBehavior = Component_FreeLayoutBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_SpreadLayoutBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_SpreadLayoutBehavior = (function(superClass) {
    extend(Component_SpreadLayoutBehavior, superClass);


    /**
    * Turns a game object into a spread-layout and spreads all sub-objects
    * evenly over the layout-space vertically or horizontally. The game object needs a 
    * container-component.
    *
    * @module gs
    * @class Component_SpreadLayoutBehavior
    * @extends gs.Component_LayoutBehavior
    * @memberof gs
    * @constructor
     */

    function Component_SpreadLayoutBehavior(orientation) {
      Component_SpreadLayoutBehavior.__super__.constructor.apply(this, arguments);

      /**
      * The orientation of the spread-layout.
      * @property orientation
      * @type gs.Orientation.
       */
      this.orientation = orientation || 0;
    }


    /**
    * Updates the spread-layout.
    *
    * @method update
     */

    Component_SpreadLayoutBehavior.prototype.update = function() {
      Component_SpreadLayoutBehavior.__super__.update.apply(this, arguments);
      this.object.visible_ = this.object.visible && (!this.object.parent || this.object.parent.visible);
      if (this.orientation === 0) {
        return this.layoutHorizontal();
      } else {
        return this.layoutVertical();
      }
    };


    /**
    * Spreads all sub-objects evenly over the layout-space horizontally.
    *
    * @method layoutHorizontal
     */

    Component_SpreadLayoutBehavior.prototype.layoutHorizontal = function() {
      var control, count, i, j, rect, ref, y;
      count = this.object.controls.length;
      this.object.visible_ = this.object.visible && (!this.object.parent || this.object.parent.visible);
      y = 0;
      rect = this.object.dstRect;
      for (i = j = 0, ref = count; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        control = this.object.controls[i];
        control.parent = this.object;
        control.update();
        control.dstRect.x = Math.floor((rect.width - control.dstRect.width) / (count - 1)) * i;
        if (!control.clipRect) {
          control.clipRect = this.object.clipRect;
        }
        if (control.alignmentY === 1) {
          control.dstRect.y = y + Math.round((rect.height - (control.dstRect.height + control.margin.top + control.margin.bottom)) / 2);
        }
      }
      if (this.object.clipRect != null) {
        return this.object.clipRect.set(rect.x, rect.y, rect.width, rect.height);
      }
    };


    /**
    * Spreads all sub-objects evenly over the layout-space vertically.
    *
    * @method layoutHorizontal
     */

    Component_SpreadLayoutBehavior.prototype.layoutVertical = function() {
      var control, count, i, j, rect, ref, x;
      count = this.object.controls.length;
      this.object.visible_ = this.object.visible && (!this.object.parent || this.object.parent.visible);
      x = 0;
      rect = this.object.dstRect;
      for (i = j = 0, ref = count; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        control = this.object.controls[i];
        control.parent = this.object;
        control.update();
        control.dstRect.y = Math.floor(rect.height / count) * i;
        if (!control.clipRect) {
          control.clipRect = this.object.clipRect;
        }
        if (control.alignmentX === 1) {
          control.dstRect.x = x + Math.round((rect.width - (control.dstRect.width + control.margin.left + control.margin.right)) / 2);
        }
      }
      if (this.object.clipRect != null) {
        return this.object.clipRect.set(rect.x, rect.y, rect.width, rect.height);
      }
    };

    return Component_SpreadLayoutBehavior;

  })(gs.Component_LayoutBehavior);

  gs.Component_SpreadLayoutBehavior = Component_SpreadLayoutBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_StackLayoutBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_StackLayoutBehavior = (function(superClass) {
    extend(Component_StackLayoutBehavior, superClass);


    /**
    * Turns a game object into a stack-layout and layouts all sub-objects
    * like stack vertically or horizontally. The game object needs a 
    * container-component.
    * <br>
    * The sub-objects in a stack-layout can be configured as resizable or
    * non-resizable(fixed-size). For example:<br>
    * <br>
    * Lets say we have a layout-size of 500px in width with three controls.<br>
    * <br>
    * | 80px | dynamic | 80px | <br>
    * <br>
    * Two controls have a fixed size of 80px and the middle-control has a
    * dynamic-size because it is configured to be resizable. In that case, 
    * the size of the resizable control would be 340px because that is the
    * free space left after subtracting the size(160px) of the fixed-size controls.<br>
    * <br>
    * In addition, each sub-object can have different alignment options.
    *
    * @module gs
    * @class Component_StackLayoutBehavior
    * @extends gs.Component_LayoutBehavior
    * @memberof gs
    * @constructor
     */

    function Component_StackLayoutBehavior(orientation) {
      Component_StackLayoutBehavior.__super__.constructor.apply(this, arguments);

      /**
      * The orientation of the stack-layout. Can be vertical or horizontal.
      * @property orientation
      * @type gs.Orientation
       */
      this.orientation = orientation || 0;

      /**
      * @property scrollOffsetX
      * @type number
      * @protected
       */
      this.scrollOffsetX = 0;

      /**
      * @property scrollOffsetY
      * @type number
      * @protected
       */
      this.scrollOffsetY = 0;

      /**
      * @property contentHeight
      * @type number
      * @protected
       */
      this.contentHeight = 0;

      /**
      * Control list-offset.
      * @property offset
      * @type number
      * @protected
       */
      this.offset = 0;

      /**
      * Count of controls to process.
      * @property contentHeight
      * @type number
      * @protected
       */
      this.count = 0;

      /**
      * Current x-coordinate. 
      * @property cx
      * @type number
      * @protected
       */
      this.cx = 0;

      /**
      * Current y-coordinate. 
      * @property cy
      * @type number
      * @protected
       */
      this.cy = 0;

      /**
      * Total size of all centered controls. 
      * @property centerSize
      * @type number
      * @protected
       */
      this.centerSize = 0;

      /**
      * Current x/y-coordinate for a centered control.
      * @property center
      * @type number
      * @protected
       */
      this.center = 0;

      /**
      * Current x/y-coordinate for a bottom/right aligned control.
      * @property bottom
      * @type number
      * @protected
       */
      this.bottom = 0;
      this.managementMode = 0;
    }


    /**
    * Initializes the layout.
    *
    * @method setup
     */

    Component_StackLayoutBehavior.prototype.setup = function() {
      this.update();
      if (this.object.scrollable) {
        return gs.GlobalEventManager.on("mouseWheel", (function(_this) {
          return function() {
            var r;
            r = _this.object.dstRect;
            if (Rect.contains(r.x, r.y, r.width, r.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y)) {
              return _this.object.update();
            }
          };
        })(this));
      }
    };


    /**
    * Updates the layout depending on its orientation.
    *
    * @method update
     */

    Component_StackLayoutBehavior.prototype.update = function() {
      Component_StackLayoutBehavior.__super__.update.apply(this, arguments);
      if (this.orientation === 0) {
        return this.layoutHorizontal();
      } else {
        return this.layoutVertical();
      }
    };


    /**
    * Sizes the layout to fit its content
    *
    * @method sizeToFit
    * @return number The content size.
     */

    Component_StackLayoutBehavior.prototype.sizeToFit = function() {
      if (this.orientation === 0) {
        return this.sizeToFitHorizontal();
      } else {
        return this.sizeToFitVertical();
      }
    };


    /**
    * Sizes the horizontal-layout to fit its content
    *
    * @method sizeToFitHorizontal
     */

    Component_StackLayoutBehavior.prototype.sizeToFitHorizontal = function() {
      var control, i, j, rect, ref, ref1, results, x, y;
      x = 0;
      y = 0;
      rect = this.object.dstRect;
      if (this.object.sizeToFit) {
        results = [];
        for (i = j = ref = this.offset, ref1 = this.count; ref <= ref1 ? j < ref1 : j > ref1; i = ref <= ref1 ? ++j : --j) {
          control = this.object.subObjects[i];
          if (!control.alignment) {
            rect.width = Math.max(x + control.margin.left + control.dstRect.width + control.margin.right, rect.width || 0);
            x += control.margin.left + control.dstRect.width + control.margin.right;
          }
          if (!control.alignmentY) {
            results.push(rect.height = Math.max(y + control.margin.top + control.dstRect.height + control.margin.bottom, rect.height || 0));
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };


    /**
    * Sizes the vertical-layout to fit its content
    *
    * @method sizeToFitVertical
     */

    Component_StackLayoutBehavior.prototype.sizeToFitVertical = function() {
      var control, j, len, rect, ref, results;
      rect = this.object.dstRect;
      if (this.object.sizeToFit) {
        ref = this.object.subObjects;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          control = ref[j];
          rect.width = Math.max(control.dstRect.x + control.dstRect.width + control.margin.right, rect.width || 1);
          results.push(rect.height = Math.max(control.dstRect.y + control.dstRect.height + control.margin.bottom, rect.height || 1));
        }
        return results;
      }
    };


    /**
    * Calculates the dynamic-size of a horizontal stack-layout. That size is used for
    * resizable-controls to let them fill all free space. It is calculated in the
    * following way:<br>
    * <br>
    * dynamic-size = sum-of-all-fixed-control-sizes / count-of-resizable-controls
    * <br>
    *
    * @method calculateDynamicSizeHorizontal
    * @return {number} The dynamic size.
    * @protected
     */

    Component_StackLayoutBehavior.prototype.calculateDynamicSizeHorizontal = function() {
      var control, dynamicCount, fixedSize, i, j, len, rect, ref;
      fixedSize = 0;
      dynamicCount = 0;
      rect = this.object.dstRect;
      ref = this.object.subObjects;
      for (i = j = 0, len = ref.length; j < len; i = ++j) {
        control = ref[i];
        if (control.resizable && !control.sizeToFit) {
          dynamicCount++;
        } else {
          fixedSize += control.margin.left + control.dstRect.width + control.margin.right;
          if (control.alignmentX === 1) {
            this.centerSize += control.dstRect.width + control.margin.right;
          }
        }
      }
      return Math.round((rect.width - fixedSize) / dynamicCount);
    };


    /**
    * Calculates the dynamic-size of a vertical stack-layout. That size is used for
    * resizable-controls to let them fill all free space. It is calculated in the
    * following way:<br>
    * <br>
    * dynamic-size = sum-of-all-fixed-control-sizes / count-of-resizable-controls
    * <br>
    *
    * @method calculateDynamicSizeVertical
    * @return {number} The dynamic size.
    * @protected
     */

    Component_StackLayoutBehavior.prototype.calculateDynamicSizeVertical = function() {
      var control, dynamicCount, fixedSize, j, len, ref;
      fixedSize = 0;
      dynamicCount = 0;
      ref = this.object.subObjects;
      for (j = 0, len = ref.length; j < len; j++) {
        control = ref[j];
        if (control.resizable && !control.sizeToFit) {
          dynamicCount++;
        } else {
          fixedSize += control.dstRect.height;
          if (control.alignmentY === 1) {
            this.centerSize += control.dstRect.height + control.margin.bottom;
          }
        }
      }
      return Math.round((this.object.dstRect.height - fixedSize) / dynamicCount);
    };


    /**
    * Layouts the specified control as fixed-size control for a horizontal stack-layout. 
    *
    * @method updateControlRectFixedH
    * @param {gs.Object_Base} control The control to update.
    * @protected
     */

    Component_StackLayoutBehavior.prototype.updateControlRectFixedH = function(control) {
      var rect;
      rect = this.object.dstRect;
      if (control.alignmentX === 0) {
        this.cx += control.margin.left;
        control.dstRect.x = this.cx;
        this.cx += control.dstRect.width + control.margin.right;
      } else if (control.alignmentX === 2) {
        this.bottom += control.margin.right;
        control.dstRect.x = (rect.x + rect.width) - control.dstRect.width - this.bottom;
        this.bottom += control.dstRect.width + control.margin.left;
      } else if (control.alignmentX === 1) {
        control.dstRect.x = this.center + (rect.width - this.centerSize) / 2;
        this.center += control.dstRect.width + control.margin.right;
      }
      if (control.alignmentY === 1) {
        return control.dstRect.y = this.cy + Math.round((rect.height - (control.dstRect.height + control.margin.top + control.margin.bottom)) / 2);
      } else {
        return control.dstRect.y = this.cy + control.margin.top;
      }
    };


    /**
    * Layouts the specified control as fixed-size control for a vertical stack-layout. 
    *
    * @method updateControlRectFixedV
    * @param {gs.Object_Base} control The control to update.
    * @protected
     */

    Component_StackLayoutBehavior.prototype.updateControlRectFixedV = function(control) {
      var rect;
      rect = this.object.dstRect;
      if (control.alignmentY === 0) {
        this.cy += control.margin.top;
        control.dstRect.y = this.cy;
        this.cy += control.dstRect.height + control.margin.bottom;
        control.dstRect.x = this.cx + control.margin.left;
      } else if (control.alignmentY === 2) {
        this.bottom += control.margin.bottom;
        control.dstRect.y = rect.height - control.dstRect.height - this.bottom;
        this.bottom += control.dstRect.height + control.margin.top;
        control.dstRect.x = this.cx + control.margin.left;
      } else if (control.alignmentY === 1) {
        control.dstRect.y = this.center + (rect.height - this.centerSize) / 2;
        control.dstRect.x = this.cx + control.margin.left;
        this.center += control.dstRect.height + control.margin.bottom;
      }
      if (control.alignmentX === 1) {
        return control.dstRect.x = this.cx + Math.round((rect.width - control.dstRect.width) / 2);
      }
    };


    /**
    * Layouts the specified control as resizable-control for a horizontal stack-layout. 
    * That means the control will take up all free space after subtracting all 
    * fixed-size controls.
    *
    * @method updateControlRectResizableH
    * @param {gs.Object_Base} control The control to update.
    * @protected
     */

    Component_StackLayoutBehavior.prototype.updateControlRectResizableH = function(control) {
      var dynamicSize;
      dynamicSize = this.calculateDynamicSizeHorizontal();
      control.dstRect.y = control.margin.top;
      control.dstRect.height = this.object.dstRect.height - control.margin.bottom - control.margin.top;
      control.dstRect.x = this.cx + control.margin.left;
      control.dstRect.width = dynamicSize - control.margin.right - control.margin.left;
      return this.cx += dynamicSize;
    };


    /**
    * Layouts the specified control as resizable-control for a vertical stack-layout. 
    * That means the control will take up all free space after subtracting all 
    * fixed-size controls.
    *
    * @method updateControlRectResizableV
    * @param {gs.Object_Base} control The control to update.
    * @protected
     */

    Component_StackLayoutBehavior.prototype.updateControlRectResizableV = function(control) {
      var dynamicSize;
      dynamicSize = this.calculateDynamicSizeVertical();
      control.dstRect.x = control.margin.left;
      control.dstRect.width = this.object.dstRect.width - control.margin.right - control.margin.left;
      control.dstRect.y = this.cy + control.margin.top;
      control.dstRect.height = dynamicSize - control.margin.bottom - control.margin.top;
      return this.cy += dynamicSize;
    };


    /**
    * Updates a control.
    *
    * @method updateControl
    * @param {gs.Object_Base} control The control to update.
    * @protected
     */

    Component_StackLayoutBehavior.prototype.updateControl = function(control) {
      if (this.orientation === 1) {
        if (control.clipRect == null) {
          control.clipRect = this.object.clipRect;
        }
        if (true) {
          if (control.needsUpdate) {
            control.needsUpdate = false;
            control.update();
          }
          control.updated = true;
          return control.visible = true;
        } else {
          if (control.visible) {
            control.visible = false;
            return control.update();
          }
        }
      } else {
        return Component_StackLayoutBehavior.__super__.updateControl.call(this, control);
      }
    };


    /**
    * Layouts the sub-objects horizontally.
    *
    * @method layoutHorizontal
     */

    Component_StackLayoutBehavior.prototype.layoutHorizontal = function() {
      var control, i, ref;
      this.bottom = 0;
      this.center = 0;
      this.centerSize = 0;
      this.offset = this.object.listOffset || 0;
      this.count = this.object.subObjects.length;
      this.cx = 0;
      this.cy = 0;
      this.sizeToFitHorizontal();
      i = this.offset;
      while (i < this.object.subObjects.length) {
        control = this.object.subObjects[i];
        this.updateControl(control);
        if (control.disposed) {
          this.object.removeObject(control);
          i--;
        } else {
          if (control.resizable && !control.sizeToFit) {
            this.updateControlRectResizableH(control);
          } else {
            this.updateControlRectFixedH(control);
          }
        }
        i++;
      }
      if ((ref = this.object.clipRect) != null) {
        ref.set(this.object.dstRect.x + this.object.origin.x, this.object.dstRect.y + this.object.origin.y, this.object.dstRect.width, this.object.dstRect.height);
      }
      return null;
    };


    /**
    * Layouts the sub-objects vertically.
    *
    * @method layoutVertical
     */

    Component_StackLayoutBehavior.prototype.layoutVertical = function() {
      var control, currentY, i, ref;
      this.bottom = 0;
      this.center = 0;
      this.centerSize = 0;
      this.offset = this.object.listOffset || 0;
      this.count = this.object.subObjects.length;
      this.cx = 0;
      this.cy = 0;
      this.cy -= this.object.scrollOffsetY;
      i = this.offset;
      currentY = 0;
      while (i < this.object.subObjects.length) {
        control = this.object.subObjects[i];
        i++;
        if (!control) {
          continue;
        }
        this.updateControl(control);
        if (control.disposed) {
          this.object.removeObject(control);
          i--;
        } else {
          if (control.resizable && !control.sizeToFit) {
            this.updateControlRectResizableV(control);
          } else {
            this.updateControlRectFixedV(control);
          }
        }
      }
      this.sizeToFitVertical();
      if ((ref = this.object.clipRect) != null) {
        ref.set(this.object.dstRect.x + this.object.origin.x, this.object.dstRect.y + this.object.origin.y, this.object.dstRect.width, this.object.dstRect.height);
      }
      return null;
    };

    return Component_StackLayoutBehavior;

  })(gs.Component_LayoutBehavior);

  gs.Component_StackLayoutBehavior = Component_StackLayoutBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_GridLayoutBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_GridLayoutBehavior = (function(superClass) {
    extend(Component_GridLayoutBehavior, superClass);


    /**
    * Turns a game object into a free-layout and layouts all sub-objects
    * in a grid of rows and columns.
    
    * @module gs
    * @class Component_GridLayoutBehavior
    * @extends gs.Component_LayoutBehavior
    * @memberof gs
    * @constructor
     */

    function Component_GridLayoutBehavior() {
      Component_GridLayoutBehavior.__super__.constructor.apply(this, arguments);
      this.column = 0;
      this.row = 0;
    }

    Component_GridLayoutBehavior.prototype.sizeToFit = function() {};


    /**
    * Updates a specified control.
    *
    * @method updateControl
    * @protected
    * @param {gs.Object_Base} control The control to update
     */

    Component_GridLayoutBehavior.prototype.updateControl = function(control) {
      var cellSpacing, rect;
      Component_GridLayoutBehavior.__super__.updateControl.apply(this, arguments);
      cellSpacing = this.object.cellSpacing;
      rect = this.object.dstRect;
      control.parent = this.object;
      control.dstRect.x = cellSpacing[0] + this.column * (control.dstRect.width + cellSpacing[2]);
      control.dstRect.y = cellSpacing[1] + this.row * (control.dstRect.height + cellSpacing[3]);
      if (control.needsUpdate) {
        control.needsUpdate = false;
        control.update();
      }
      if (this.object.sizeToFit) {
        rect.width = Math.max(control.dstRect.x + control.dstRect.width + cellSpacing[2], rect.width || 0);
        return rect.height = Math.max(control.dstRect.y + control.dstRect.height + cellSpacing[3], rect.height || 0);
      }
    };


    /**
    * Updates the grid-layout.
    *
    * @method update
     */

    Component_GridLayoutBehavior.prototype.update = function() {
      var cellSpacing, columns, control, count, i, j, offset, rect, ref, ref1, rows;
      this.updateOrigin();
      cellSpacing = this.object.cellSpacing;
      rows = this.object.rows;
      columns = this.object.columns;
      this.row = 0;
      this.column = 0;
      offset = (this.object.listOffset || 0) * (rows * columns);
      count = Math.min(this.object.subObjects.length, rows * columns + offset);
      rect = this.object.dstRect;
      for (i = j = ref = offset, ref1 = count; ref <= ref1 ? j < ref1 : j > ref1; i = ref <= ref1 ? ++j : --j) {
        control = this.object.subObjects[i];
        control.index = i;
        this.updateControl(control);
        this.column++;
        if (this.column >= columns) {
          this.column = 0;
          this.row++;
        }
        if (this.row >= rows) {
          break;
        }
      }
      if (this.object.clipRect != null) {
        return this.object.clipRect.set(rect.x, rect.y, rect.width, rect.height);
      }
    };

    return Component_GridLayoutBehavior;

  })(gs.Component_LayoutBehavior);

  gs.Component_GridLayoutBehavior = Component_GridLayoutBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Handler,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Handler = (function(superClass) {
    extend(Component_Handler, superClass);


    /**
    * The base class for all handler-components. A handler-component is
    * used to handle condition- or event-based processes of a In-Game UI
    * object like executing bindings or triggering actions.
    *
    * A handler is only executed if all assigned conditions and events are
    * true.
    *
    * @module ui
    * @class Component_Handler
    * @extends gs.Component
    * @memberof ui
    * @constructor
     */

    function Component_Handler() {

      /**
      * @property mouseEntered
      * @type boolean
      * @protected
       */
      this.mouseEntered = false;

      /**
      * @property mouseLeaved
      * @type boolean
      * @protected
       */
      this.mouseLeaved = true;
    }


    /**
    * Checks if the condition is <b>true</b> for the specified game object.
    *
    * @method checkCondition
    * @param {gs.Object_Base} object The game object.
    * @param {Object} condition The condition-object.
    * @return {boolean} If <b>true</b> the condition is true. Otherwise <b>false</b>.
    * @static
     */

    Component_Handler.checkCondition = function(object, condition) {
      var result;
      result = false;
      if (condition.equalTo != null) {
        result = ui.Component_FormulaHandler.fieldValue(object, condition.field) === ui.Component_FormulaHandler.fieldValue(object, condition.equalTo);
      } else if (condition.greaterThan != null) {
        result = ui.Component_FormulaHandler.fieldValue(object, condition.field) > ui.Component_FormulaHandler.fieldValue(object, condition.greaterThan);
      } else if (condition.lessThan != null) {
        result = ui.Component_FormulaHandler.fieldValue(object, condition.field) < ui.Component_FormulaHandler.fieldValue(object, condition.lessThan);
      } else if (condition.notEqualTo != null) {
        result = ui.Component_FormulaHandler.fieldValue(object, condition.field) !== ui.Component_FormulaHandler.fieldValue(object, condition.notEqualTo);
      }
      return result;
    };


    /**
    * Checks if the specified condition is <b>true</b>.
    *
    * @method checkCondition
    * @param {Object} condition The condition-object.
    * @return {boolean} If <b>true</b> the condition is true. Otherwise <b>false</b>.
     */

    Component_Handler.prototype.checkCondition = function(condition) {
      return ui.Component_Handler.checkCondition(this.object, condition);
    };


    /**
    * Checks if the specified conditions are <b>true</b>.
    *
    * @method checkConditions
    * @param {Object[]} conditions An array of condition-objects.
    * @return {boolean} If <b>true</b> all conditions are true. Otherwise <b>false</b>.
     */

    Component_Handler.prototype.checkConditions = function(conditions) {
      var condition, i, len, result;
      result = true;
      for (i = 0, len = conditions.length; i < len; i++) {
        condition = conditions[i];
        if (!this.checkCondition(condition)) {
          result = false;
          break;
        }
      }
      return result;
    };


    /**
    * Checks if the specified event is true.
    *
    * @method checkEvent
    * @param {Object} event The event to check for.
    * @param {Object} [binding=null] binding An optional binding-object necessary for some event-types.
    * @return {boolean} If <b>true</b> the event is true. Otherwise <b>false</b>.
     */

    Component_Handler.prototype.checkEvent = function(event, binding) {
      var entered, leaved, ref, ref1, result, value;
      result = false;
      if (event === "onAlways") {
        result = true;
      } else if (event === "onAction") {
        result = Input.Mouse.buttons[Input.Mouse.LEFT] === 2 && this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
      } else if (event === "onCancel") {
        result = Input.Mouse.buttons[Input.Mouse.RIGHT] === 2 && this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
      } else if (event === "onAccept") {
        result = Input.release(Input.KEY_RETURN) || (Input.Mouse.buttons[Input.Mouse.LEFT] === 2 && this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y));
      } else if (event === "onDragEnter") {
        entered = ((ref = this.object.dragDrop) != null ? ref.isDragging : void 0) && this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
        result = !this.mouseEntered && entered;
        this.mouseEntered = entered;
      } else if (event === "onDragLeave") {
        leaved = ((ref1 = this.object.dragDrop) != null ? ref1.isDragging : void 0) && !this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
        result = !this.mouseLeaved && leaved;
        this.mouseLeaved = leaved;
      } else if (event === "onMouseEnter") {
        entered = this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
        result = !this.mouseEntered && entered;
        this.mouseEntered = entered;
      } else if (event === "onMouseLeave") {
        leaved = !this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
        result = !this.mouseLeaved && leaved;
        this.mouseLeaved = leaved;
      } else if (event === "onMouseHover") {
        result = this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
      } else if (event === "onMouseClick") {
        result = Input.Mouse.buttons[Input.Mouse.LEFT] === 2 && this.object.dstRect.contains(Input.Mouse.x - this.object.origin.x, Input.Mouse.y - this.object.origin.y);
      } else if (event.onChange != null) {
        value = this.resolveFieldPath(event.onChange);
        if (value != null) {
          value = value.get(this.object);
          if (binding[event.onChange] !== value) {
            binding[event.onChange] = value;
            result = true;
          }
        } else {
          result = true;
        }
      }
      return result;
    };


    /**
    * Checks if all events and conditions defined for the handler
    * are true. If that check returns <b>true</b> the handler must be
    * executed.
    *
    * @method checkObject
    * @param {Object} object The game object to check.
    * @return {boolean} If <b>true</b> the handler must be executed. Otherwise <b>false</b>.
     */

    Component_Handler.prototype.checkObject = function(object) {
      var event, execute, i, len, ref;
      execute = true;
      if (object.event != null) {
        object.events = [object.event];
        delete object.event;
      }
      if (object.condition != null) {
        object.conditions = [object.condition];
        delete object.condition;
      }
      if (object.events != null) {
        ref = object.events;
        for (i = 0, len = ref.length; i < len; i++) {
          event = ref[i];
          execute = this.checkEvent(event, object);
          if (execute) {
            break;
          }
        }
      }
      if ((object.conditions != null) && execute) {
        execute = this.checkConditions(object.conditions);
      }
      return execute;
    };

    return Component_Handler;

  })(gs.Component);

  ui.Component_Handler = Component_Handler;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_BindingHandler,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_BindingHandler = (function(superClass) {
    extend(Component_BindingHandler, superClass);


    /**
    * Caches already compiled binding-paths.
    * @property compiledPaths
    * @type Object
    * @static
     */

    Component_BindingHandler.compiledPaths = {};


    /**
    * A binding-handler component allows a UI game object to execute
    * property-bindings.<br><br>
    *
    * For example: A text-label can bind its text-property to a backend-field 
    * like the current music-volume to always display correct music-volume. 
    * If the volume changes, the text-property will be updated
    * automatically.
    *
    * To define a binding, a special property-path syntax is used. For example:<br>
    * <br>
    * $myTextField.text<br>
    * <br>
    * is a property-path to access the text-property of a text-field object
    * with the identifier "myTextField". For more information, take a look
    * into the "In Game UI System" section of the help-file.
    * 
    * @module ui
    * @class Component_BindingHandler
    * @extends ui.Component_Handler
    * @memberof ui
    * @constructor
     */

    function Component_BindingHandler() {}


    /**
    * Initializes the binding-handler.
    * 
    * @method setup
     */

    Component_BindingHandler.prototype.setup = function() {};


    /**
    * Updates the binding-handler.
    * 
    * @method update
     */

    Component_BindingHandler.prototype.update = function() {
      var binding, i, len, ref;
      ref = this.object.bindings;
      for (i = 0, len = ref.length; i < len; i++) {
        binding = ref[i];
        this.executeBinding(binding);
      }
      this.object.initialized = true;
      return null;
    };


    /**
    * Executes a specified binding. The binding is only executed if all assigned
    * events and conditions are true.
    * 
    * @method executeBinding
    * @param {Object} binding - The binding to execute.
     */

    Component_BindingHandler.prototype.executeBinding = function(binding) {
      var offset, ref, ref1, source, target, value;
      if (!this.checkObject(binding)) {
        return;
      }
      source = (ref = binding.sourceFunc) != null ? ref : (binding.sourceFunc = this.resolveFieldPath(binding.sourceField));
      target = (ref1 = binding.targetFunc) != null ? ref1 : (binding.targetFunc = this.resolveFieldPath(binding.targetField));
      if (!target) {
        return;
      }
      if (!source) {
        return target.set(this.object, null);
      }
      value = source.get(this.object);
      offset = 0;
      if (binding.offset != null) {
        value += binding.offset;
      }
      if (binding.max != null) {
        value = Math.min(binding.max, value);
      }
      if (binding.min != null) {
        value = Math.max(binding.min, value);
      }
      return target.set(this.object, value);
    };


    /**
    * Evaluates a specified property-path and returns the result.
    * 
    * @method fieldValue
    * @param {string} path - A property-path.
    * @return {Object} The value of the property-path.
     */

    Component_BindingHandler.prototype.fieldValue = function(path) {
      return ui.Component_BindingHandler.fieldValue(this.object, path);
    };


    /**
    * Executes a specified binding. The binding is only executed if all assigned
    * events and conditions are true.
    * 
    * @method executeBinding
    * @param {Object} binding - The binding to execute.
    * @static
     */

    Component_BindingHandler.executeBinding = function(sender, binding) {
      var binder;
      binder = new ui.BindingHandler();
      binder.object = sender;
      return binder.executeBinding(binding);
    };


    /**
    * Evaluates a property-path on a specified object and returns the result.
    * 
    * @method fieldValue
    * @static
    * @param {Object} object - An object to evaluate the property-path on.
    * @param {string} path - A property-path.
    * @return {Object} The value of the property-path.
     */

    Component_BindingHandler.fieldValue = function(object, path) {
      var field;
      if (typeof path === "string") {
        field = ui.Component_BindingHandler.resolveFieldPath(object, path);
        if (field == null) {
          return 0;
        }
        return field.get(object);
      } else {
        return path;
      }
    };


    /**
    * Resolves a property-path of a specified object and returns the result. The
    * result-object has a get- and an optional set-function to get or set the
    * value for the property-path. The set-function is only present for property-paths
    * which can be written.
    * 
    * @method resolveFieldPath
    * @static
    * @param {Object} object - An object to evaluate the property-path on.
    * @param {string} path - A property-path.
    * @return {Object} The result-object containing a get- and set-function to manipulate the property-value.
     */

    Component_BindingHandler.resolveFieldPath = function(object, path) {
      var result;
      result = ui.Component_BindingHandler.compiledPaths[path];
      if (result != null) {
        return result;
      }
      if (path != null) {
        result = {
          set: null,
          get: null
        };
        result.get = eval("(function(o) { return " + path + " })");
        result.set = eval("(function(o, v) { " + path + " = v; })");
        ui.Component_BindingHandler.compiledPaths[path] = result;
      }
      return result;
    };


    /**
    * Resolves a property-path and returns the result. The
    * result-object has a get- and an optional set-function to get or set the
    * value for the property-path. The set-function is only present for property-paths
    * which can be written.
    * 
    * @method resolveFieldPath
    * @param {Object} object - An object to evaluate the property-path on.
    * @param {string} path - A property-path.
    * @return {Object} The result-object containing a get- and set-function to manipulate the property-value.
     */

    Component_BindingHandler.prototype.resolveFieldPath = function(path) {
      return ui.Component_BindingHandler.resolveFieldPath(this.object, path);
    };

    return Component_BindingHandler;

  })(ui.Component_Handler);

  ui.Component_BindingHandler = Component_BindingHandler;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_FormulaHandler,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_FormulaHandler = (function(superClass) {
    extend(Component_FormulaHandler, superClass);


    /**
    * A formula-handler component allows a UI game object to execute
    * formulas.<br><br>
    *
    * For more information, take a look
    * into the "In Game UI System" section of the help-file.
    *
    * @module ui
    * @class Component_BindingHandler
    * @extends ui.Component_Handler
    * @memberof ui
    * @constructor
     */

    function Component_FormulaHandler() {
      this.breakChainAt = null;
    }


    /**
    * Initializes the binding-handler.
    *
    * @method setup
     */

    Component_FormulaHandler.prototype.setup = function() {
      return this.object.events.on("uiPrepareFinish", ((function(_this) {
        return function(e) {
          var formula, i, len, ref, results;
          ref = _this.object.formulas;
          results = [];
          for (i = 0, len = ref.length; i < len; i++) {
            formula = ref[i];
            if (formula.events.contains("uiPrepareFinish")) {
              window.o = _this.object;
              window.d = _this.object.data[0];
              results.push(formula.exec());
            } else {
              results.push(void 0);
            }
          }
          return results;
        };
      })(this)));
    };


    /**
    * Updates the binding-handler.
    *
    * @method update
     */

    Component_FormulaHandler.prototype.update = function() {
      var formula, i, len, ref;
      ref = this.object.formulas;
      for (i = 0, len = ref.length; i < len; i++) {
        formula = ref[i];
        this.executeFormula(formula);
      }
      this.object.initialized = true;
      return null;
    };

    Component_FormulaHandler.prototype.executeFormula = function(formula) {
      if (this.checkObject(formula)) {
        window.o = this.object;
        window.d = this.object.data[0];
        return formula.exec();
      }
    };

    Component_FormulaHandler.executeFormula = function(object, formula) {
      window.o = object;
      window.d = object.data[0];
      return formula.exec();
    };


    /**
    * Evaluates a specified property-path and returns the result.
    *
    * @method fieldValue
    * @param {string} path - A property-path.
    * @return {Object} The value of the property-path.
     */

    Component_FormulaHandler.prototype.fieldValue = function(path) {
      return ui.FormulaHandler.fieldValue(this.object, path);
    };


    /**
    * Evaluates a property-path on a specified object and returns the result.
    *
    * @method fieldValue
    * @static
    * @param {Object} object - An object to evaluate the property-path on.
    * @param {string} path - A property-path.
    * @return {Object} The value of the property-path.
     */

    Component_FormulaHandler.fieldValue = function(object, path, readOnly) {
      var ref, value;
      if (typeof (path != null ? path.exec : void 0) === "function") {
        window.o = object;
        window.d = object != null ? (ref = object.data) != null ? ref[0] : void 0 : void 0;
        value = path.exec();
        return value != null ? value : 0;
      } else if (typeof path === "function") {
        return this.fieldValue(object, path(), readOnly);
      }
      return path;
    };

    return Component_FormulaHandler;

  })(ui.Component_Handler);

  ui.Component_FormulaHandler = Component_FormulaHandler;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_ActionHandler,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_ActionHandler = (function(superClass) {
    extend(Component_ActionHandler, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_ActionHandler.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * An action-handler component allows a UI game object to execute
    * actions. An action can be a method-call of a component or of the scene which
    * always takes two parameters: Sender and Params. For more info about
    * UI actions, see help-file.
    * 
    * @module ui
    * @class Component_ActionHandler
    * @extends ui.Component_Handler
    * @memberof ui
    * @constructor
     */

    function Component_ActionHandler() {

      /**
      * @property initialized
      * @type boolean
      * @protected
       */
      this.initialized = false;

      /**
      * Counter for delayed/timed actions.
      * @property waitCounter
      * @type number
      * @protected
       */
      this.waitCounter = 0;

      /**
      * Indicates if the mouse/touch pointer is inside the UI object's bounds.
      * @property contains
      * @type boolean
      * @protected
       */
      this.containsPointer = false;
    }


    /**
    * Disposes the component.
    *
    * @method dispose
     */

    Component_ActionHandler.prototype.dispose = function() {
      Component_ActionHandler.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("keyUp", this.object);
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      return gs.GlobalEventManager.offByOwner("mouseMoved", this.object);
    };


    /**
    * Adds event-handler for mouse/touch events to update the component only if 
    * a user-action happened.
    *
    * @method setupEventHandlers
     */

    Component_ActionHandler.prototype.setupEventHandlers = function() {
      var ref;
      gs.GlobalEventManager.offByOwner("keyUp", this.object);
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      gs.GlobalEventManager.offByOwner("mouseMoved", this.object);
      if (this.object.focusable) {
        gs.GlobalEventManager.on("keyUp", ((function(_this) {
          return function(e) {
            if (Input.release(Input.KEY_RETURN) && _this.object.ui.focused) {
              _this.object.needsUpdate = true;
              return _this.executeActions();
            }
          };
        })(this)), null, this.object);
      }
      gs.GlobalEventManager.on("mouseUp", ((function(_this) {
        return function(e) {
          var action, actions, contains, exec, i, len;
          contains = Rect.contains(_this.object.dstRect.x, _this.object.dstRect.y, _this.object.dstRect.width, _this.object.dstRect.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y);
          if (contains) {
            exec = false;
            actions = actions || _this.object.actions;
            if (actions != null) {
              for (i = 0, len = actions.length; i < len; i++) {
                action = actions[i];
                exec = _this.checkAction(action) && !_this.checkActionWait(action);
                if (exec) {
                  break;
                }
              }
            }
            if (exec) {
              e.breakChain = true;
              _this.executeActions();
            }
            return _this.object.needsUpdate = true;
          }
        };
      })(this)), null, this.object);
      if ((ref = this.object.actions) != null ? ref.first(function(a) {
        return a && (a.event === "onMouseEnter" || a.event === "onMouseLeave" || a.event === "onMouseHover");
      }) : void 0) {
        gs.GlobalEventManager.on("mouseMoved", ((function(_this) {
          return function(e) {
            var contains;
            contains = Rect.contains(_this.object.dstRect.x, _this.object.dstRect.y, _this.object.dstRect.width, _this.object.dstRect.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y);
            if (_this.containsPointer !== contains) {
              _this.containsPointer = contains;
              return _this.object.needsUpdate = true;
            }
          };
        })(this)), null, this.object);
      }
      return this.object.events.on("action", (function(_this) {
        return function(e) {
          if (e.actions || e.action) {
            return _this.executeAction(e.actions != null ? e.actions[0] : e.action);
          }
        };
      })(this));
    };


    /**
    * Sets up associated actions. Each action is validated and specific default values for the action-target
    * and other options are set if not specified.
    *
    * @method setupActions
     */

    Component_ActionHandler.prototype.setupActions = function() {
      var action, component, i, len, ref, results, target, targets;
      if (this.object.actions != null) {
        ref = this.object.actions;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          action = ref[i];
          if (!action) {
            continue;
          }
          if (!action.event) {
            action.event = "onAction";
          }
          if (action.wait != null) {
            continue;
          }
          if (action.target == null) {
            action.target = this.object.controller;
          }
          if (typeof action.target === "string") {
            if (action.target.contains(".")) {
              action.target = ui.Component_FormulaHandler.fieldValue(this.object, action.target);
            }
            targets = action.target.split(".");
            target = gs.ObjectManager.current.objectById(targets[0]);
            if (target != null) {
              component = target.findComponentById(targets[1]);
              if (component == null) {
                target = target.components.where(function(v) {
                  return typeof v[action.name] === "function";
                }).first();
              } else {
                target = component;
              }
            } else {
              target = this.object;
            }
            action.target = target;
          }
          if (action.condition != null) {
            action.conditions = [action.condition];
            results.push(delete action.condition);
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };


    /**
    * Initializes the action-handler.
    * 
    * @method setup
     */

    Component_ActionHandler.prototype.setup = function() {
      this.initialized = true;
      this.setupEventHandlers();
      return this.setupActions();
    };


    /**
    * Updates the action-handler.
    * 
    * @method update
     */

    Component_ActionHandler.prototype.update = function() {};

    Component_ActionHandler.prototype.checkAction = function(action) {
      return ((action != null ? action.event : void 0) || (action != null ? action.events : void 0)) && this.checkObject(action);
    };

    Component_ActionHandler.prototype.checkActionWait = function(action) {
      var result;
      result = false;
      if ((action.wait != null) && action.wait > 0) {
        this.waitCounter = action.wait;
        action.wait = 0;
        result = true;
      }
      return result;
    };

    Component_ActionHandler.prototype.updateActionTarget = function(action) {
      var component, target, targets;
      if (action.target == null) {
        action.target = this.object.controller;
      }
      if (action.target.exec || typeof action.target === "string") {
        if (action.target.exec) {
          action.target = ui.Component_FormulaHandler.fieldValue(this.object, action.target);
        }
        targets = action.target.split(".");
        target = gs.ObjectManager.current.objectById(targets[0]);
        if (target != null) {
          component = target.findComponentById(targets[1]);
          if (component == null) {
            target = target.components.where(function(v) {
              return typeof v[action.name] === "function";
            }).first();
          } else {
            target = component;
          }
        } else {
          target = this.object;
        }
        return action.target = target;
      }
    };

    Component_ActionHandler.prototype.canExecuteActions = function() {
      return this.waitCounter <= 0 && this.object.ui.enabled && this.object.visible;
    };


    /**
    * Executes the specified actions. A single action is only executed if
    * all assigned events and conditions are true.
    * 
    * @method executeActions
    * @return If <b>true</b> there was at least one action executed. Otherwise <b>false</b>
     */

    Component_ActionHandler.prototype.executeActions = function(actions) {
      var action, i, len, result;
      if (!this.canExecuteActions()) {
        return;
      }
      result = false;
      actions = actions || this.object.actions;
      if (actions != null) {
        for (i = 0, len = actions.length; i < len; i++) {
          action = actions[i];
          if (!this.checkAction(action)) {
            continue;
          }
          if (this.checkActionWait(action)) {
            break;
          }
          this.updateActionTarget(action);
          this.executeAction(action);
          result = true;
        }
      }
      return result;
    };


    /**
    * Executes the specified action if all assigned events and conditions
    * are true.
    * 
    * @method executeAction
    * @param {Object} action The action to execute.
     */

    Component_ActionHandler.prototype.executeAction = function(action) {
      var name, target;
      target = action.target || this.object.target;
      if (target != null) {
        if (action.sound) {
          AudioManager.playSound(action.sound);
        }
        return typeof target[name = action.name] === "function" ? target[name](this.object, action.params) : void 0;
      }
    };

    return Component_ActionHandler;

  })(ui.Component_Handler);

  ui.Component_ActionHandler = Component_ActionHandler;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_AnimationHandler,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_AnimationHandler = (function(superClass) {
    extend(Component_AnimationHandler, superClass);


    /**
    * An animation-handler component allows a UI game object to execute
    * a flow of animations. For more information about UI animations, see help-file.
    * 
    * @module ui
    * @class Component_AnimationHandler
    * @extends ui.Component_Handler
    * @memberof ui
    * @constructor
     */

    function Component_AnimationHandler() {
      Component_AnimationHandler.__super__.constructor.apply(this, arguments);

      /**
      * @property initialized
      * @type boolean
      * @protected
       */
      this.initialized = false;

      /**
      * @property waitCounter
      * @type number
      * @protected
       */
      this.waitCounter = 0;

      /**
      * @property pointer
      * @type number
      * @protected
       */
      this.pointer = 0;
    }


    /**
    * Initializes the animation-handler.
    * 
    * @method setup
     */

    Component_AnimationHandler.prototype.setup = function() {
      this.initialized = true;
      return null;
    };


    /**
    * Processes the animation targets and starts the animation on each
    * target object if possible.
    * 
    * @method processTargets
    * @param {Object} animation - The animation to start.
    * @param {gs.Object_Base[]} targets - An array of target objects.
    * @protected
     */

    Component_AnimationHandler.prototype.processTargets = function(animation, targets) {
      var j, len, ref, ref1, target;
      for (j = 0, len = targets.length; j < len; j++) {
        target = targets[j];
        if (animation.type != null) {
          target.visible = true;
          if (animation.components == null) {
            animation.components = [];
          }
          if (!this.object.animator) {
            this.object.animator = new gs.Component_Animator();
            this.object.addComponent(this.object.animator);
          }
          animation.components.push(this.object.animationExecutor.startAnimation(animation, animation.duration, target, this.object.animator));
          target.visible = true;
          animation.executed = !((ref = animation.repeat) != null ? ref : true);
        } else {
          animation.executed = !((ref1 = animation.repeat) != null ? ref1 : true);
        }
      }
      return null;
    };


    /**
    * Clears/Resets the specified animation if necessary.
    * 
    * @method clear
    * @param {Object} descriptor - The animation descriptor
    * @protected
     */

    Component_AnimationHandler.prototype.clear = function(descriptor) {
      var animation, component, j, k, len, len1, ref, ref1, target;
      descriptor.cleared = true;
      descriptor.pointer = 0;
      descriptor.waitCounter = 0;
      ref = descriptor.flow;
      for (j = 0, len = ref.length; j < len; j++) {
        animation = ref[j];
        if (animation.components) {
          ref1 = animation.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            target = this.object;
            target.visible = true;
            animation.executed = false;
            if ((animation.field != null) && (animation.reset != null)) {
              ui.BindingHandler.resolveFieldPath(target, animation.field).set(target, ui.BindingHandler.fieldValue(target, animation.reset || 0));
            }
          }
          animation.components = [];
        }
      }
      this.object.needsFullUpdate = true;
      return null;
    };


    /**
    * Processes the animation flow.
    * 
    * @method processAnimations
    * @param {Object} descriptor - The animation-descriptor containing the animation-flow.
    * @protected
     */

    Component_AnimationHandler.prototype.processAnimations = function(descriptor) {
      var animation, targets;
      while (descriptor.pointer < descriptor.flow.length) {
        animation = descriptor.flow[descriptor.pointer];
        descriptor.pointer++;
        if (!animation.wait && animation.executed) {
          continue;
        }
        targets = animation.target != null ? ui.Component_FormulaHandler.fieldValue(this.object, animation.target) : this.object;
        targets = targets.length != null ? targets : [targets];
        descriptor.cleared = false;
        this.processTargets(animation, targets);
        if (animation.wait) {
          if (animation.type != null) {
            descriptor.waitCounter = animation.duration;
          } else {
            descriptor.waitCounter = animation.wait;
          }
          break;
        }
      }
      return null;
    };


    /**
    * Updates the animations.
    * 
    * @method updateAnimations
     */

    Component_AnimationHandler.prototype.updateAnimations = function() {
      var descriptor, i, j, len, ref, ref1;
      ref = this.object.animations;
      for (i = j = 0, len = ref.length; j < len; i = ++j) {
        descriptor = ref[i];
        if (this.checkObject(descriptor)) {
          if (descriptor.waitCounter > 0) {
            descriptor.waitCounter--;
            continue;
          }
          if ((descriptor.pointer == null) || descriptor.pointer >= descriptor.flow.length) {
            descriptor.pointer = 0;
          }
          this.processAnimations(descriptor);
        } else if (!descriptor.cleared && ((ref1 = descriptor.clear) != null ? ref1 : true)) {
          this.clear(descriptor);
        }
      }
      return null;
    };


    /**
    * Updates the animation-handler.
    * 
    * @method update
     */

    Component_AnimationHandler.prototype.update = function() {
      this.object.needsUpdate = true;
      return this.updateAnimations();
    };

    return Component_AnimationHandler;

  })(ui.Component_Handler);

  ui.Component_AnimationHandler = Component_AnimationHandler;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_AnimationExecutor,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_AnimationExecutor = (function(superClass) {
    extend(Component_AnimationExecutor, superClass);


    /**
    * An animation-handler component allows a UI game object to execute
    * a flow of animations. For more information about UI animations, see help-file.
    * 
    * @module ui
    * @class Component_AnimationExecutor
    * @extends gs.Component
    * @memberof ui
    * @constructor
     */

    function Component_AnimationExecutor() {
      Component_AnimationExecutor.__super__.constructor.apply(this, arguments);

      /**
      * @property initialized
      * @type boolean
      * @protected
       */
      this.initialized = false;

      /**
      * @property waitCounter
      * @type number
      * @protected
       */
      this.waitCounter = 0;

      /**
      * @property pointer
      * @type number
      * @protected
       */
      this.pointer = 0;
      this.repeat = false;
    }


    /**
    * Initializes the animation-handler.
    * 
    * @method setup
     */

    Component_AnimationExecutor.prototype.setup = function() {
      this.initialized = true;
      return null;
    };

    Component_AnimationExecutor.prototype.execute = function(animation, callback) {
      this.animation = animation;
      this.callback = callback;
      this.pointer = 0;
      return this.waitCounter = 0;
    };

    Component_AnimationExecutor.prototype.stop = function() {
      return this.animation = null;
    };


    /**
    * Starts the specified animation.
    * 
    * @method startAnimation
    * @param {Object} animation - The animation to start.
    * @param {gs.Object_Base} target - The target object of the animation.
    * @protected
     */

    Component_AnimationExecutor.prototype.startAnimation = function(animation, duration, target, animator) {
      var easing, mask, record, value;
      switch (animation.type) {
        case "sound":
          AudioManager.playSound(animation.sound);
          break;
        case "maskTo":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          mask = {
            value: animation.value,
            graphic: {
              name: animation.mask
            },
            vague: animation.vague,
            sourceType: 0
          };
          animator.maskTo(mask, duration, easing);
          break;
        case "changeImages":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.changeImages(animation.images, duration, easing);
          break;
        case "playAnimation":
          record = RecordManager.animations[animation.animationId];
          if (record != null) {
            animator.playAnimation(record);
          }
          break;
        case "changeTo":
          value = ui.Component_BindingHandler.fieldValue(target, animation.value);
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.change(value, animation.field, duration, easing);
          break;
        case "blendTo":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.blendTo(animation.opacity, duration, easing);
          break;
        case "colorTo":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.colorTo(Color.fromArray(animation.color), duration, easing);
          break;
        case "tintTo":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.tintTo(Tone.fromArray(animation.tone), duration, easing);
          break;
        case "moveTo":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.moveTo(animation.position[0], animation.position[1], duration, easing);
          break;
        case "rotate":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.rotate(0, animation.speed, duration, easing);
          break;
        case "rotateTo":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.rotateTo(animation.angle, duration, easing);
          break;
        case "moveBy":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.moveBy(this.object.dstRect.x + animation.position[0], this.object.dstRect.y + animation.position[1], duration, easing);
          break;
        case "zoomTo":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.zoomTo(animation.zoom[0] / 100, animation.zoom[1] / 100, duration, easing);
          break;
        case "scroll":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.scroll(animation.speed[0], animation.speed[1], 0, easing);
          break;
        case "move":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.move(animation.speed[0], animation.speed[1], duration, easing);
          break;
        case "shake":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          return animator.shake({
            x: animation.range[0],
            y: animation.range[1]
          }, animation.speed, duration, easing);
        case "appear":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.appear(target.dstRect.x, target.dstRect.y, animation.animation, easing, duration);
          break;
        case "disappear":
          easing = animation.easing ? gs.Easings.fromString(animation.easing) : null;
          animator.disappear(animation.animation, easing, duration);
      }
      if (this.object.visual) {
        if (duration === 0) {
          return this.object.visual.update();
        }
      } else if (this.object.behavior) {
        if (duration === 0) {
          return this.object.behavior.update();
        }
      }
    };


    /**
    * Processes the animation flow.
    * 
    * @method processAnimation
    * @param {Object} descriptor - The animation-descriptor containing the animation-flow.
    * @protected
     */

    Component_AnimationExecutor.prototype.processAnimation = function() {
      var animation, duration;
      while (this.animation && this.pointer < this.animation.flow.length) {
        animation = this.animation.flow[this.pointer];
        this.pointer++;
        if (animation.executed) {
          continue;
        }
        if (!this.object.animator) {
          this.object.animator = new gs.Component_Animator();
          this.object.addComponent(this.object.animator);
        }
        duration = ui.Component_FormulaHandler.fieldValue(this.object, animation.duration || 0, true);
        this.startAnimation(animation, duration, this.object, this.object.animator);
        animation.executed = true;
        if (animation.wait) {
          if (animation.type != null) {
            this.waitCounter = duration;
          } else {
            this.waitCounter = animation.wait;
          }
          break;
        }
      }
      return null;
    };


    /**
    * Updates the animations.
    * 
    * @method updateAnimations
     */

    Component_AnimationExecutor.prototype.updateAnimation = function() {
      if (this.waitCounter > 0) {
        this.waitCounter--;
        return;
      }
      if (this.pointer >= this.animation.flow.length) {
        this.pointer = 0;
        if (typeof this.callback === "function") {
          this.callback(this.object);
        }
        if (!this.repeat) {
          this.animation = null;
        }
      }
      if (this.animation) {
        this.processAnimation(this.animation);
      }
      return null;
    };


    /**
    * Updates the animation-handler.
    * 
    * @method update
     */

    Component_AnimationExecutor.prototype.update = function() {
      this.object.needsUpdate = true;
      if (this.animation) {
        return this.updateAnimation();
      }
    };

    return Component_AnimationExecutor;

  })(gs.Component);

  ui.Component_AnimationExecutor = Component_AnimationExecutor;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_UIBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_UIBehavior = (function(superClass) {
    extend(Component_UIBehavior, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_UIBehavior.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * @module ui
    * @class Component_UIBehavior
    * @extends gs.Component
    * @memberof ui
    * @constructor
     */

    function Component_UIBehavior() {
      this.breakChainAt = null;
      this.containsPointer = false;
      this.isAnimating = false;
      this.viewData_ = [true, false, false, true, false];
      this.nextKeyObjectId = "";
      this.nextKeyObject_ = null;
      this.prevKeyObject_ = null;
    }

    Component_UIBehavior.accessors("nextKeyObject", {
      set: function(v) {
        this.nextKeyObject_ = v;
        if (v) {
          return v.ui.prevKeyObject_ = this.object;
        }
      },
      get: function() {
        return this.nextKeyObject_;
      }
    });

    Component_UIBehavior.accessors("prevKeyObject", {
      set: function(v) {
        this.prevKeyObject_ = v;
        if (v) {
          return v.ui.nextKeyObject_ = this.object;
        }
      },
      get: function() {
        return this.prevKeyObject_;
      }
    });

    Component_UIBehavior.accessors("selected", {
      set: function(v) {
        if (v !== this.viewData_[2]) {
          this.viewData_[2] = v;
          return this.updateStyle();
        }
      },
      get: function() {
        return this.viewData_[2];
      }
    });

    Component_UIBehavior.accessors("hover", {
      set: function(v) {
        if (v !== this.viewData_[1]) {
          this.viewData_[1] = v;
          return this.updateStyle();
        }
      },
      get: function() {
        return this.viewData_[1];
      }
    });

    Component_UIBehavior.accessors("enabled", {
      set: function(v) {
        if (v !== this.viewData_[3]) {
          this.viewData_[3] = v;
          return this.updateStyle();
        }
      },
      get: function() {
        return this.viewData_[3];
      }
    });

    Component_UIBehavior.accessors("focused", {
      set: function(v) {
        if (v !== this.viewData_[4]) {
          this.viewData_[4] = v;
          return this.updateStyle();
        }
      },
      get: function() {
        return this.viewData_[4];
      }
    });

    Component_UIBehavior.accessors("viewData", {
      set: function(v) {
        if (v !== this.viewData_) {
          this.viewData_ = v;
          return this.updateStyle();
        }
      },
      get: function() {
        return this.viewData_;
      }
    });


    /**
    * Prepares the UI-Object for display. This method should be called
    * before a new created UI-Object will be displayed to position all
    * sub-elements correctly.
    *
    * @method prepare
     */

    Component_UIBehavior.prototype.prepare = function() {
      var scene;
      scene = SceneManager.scene;
      scene.preparing = true;
      this.object.update();
      this.object.update();
      scene.preparing = false;
      return this.object.events.emit("uiPrepareFinish");
    };


    /**
    * Executes an animation defined for the specified event. Each UI-Object
    * can have animations for certain events defined in JSON.
    *
    * @param {string} event - The event to execute the animation for such as "onTerminate" or "onInitialize". If
    * no animation has been defined for the specified event, nothing will happen and the callback will be called 
    * immediately.
    * @param {Function} callback - An optional callback function called when the animation ends.
    * @method executeAnimation
     */

    Component_UIBehavior.prototype.executeAnimation = function(event, callback) {
      var animation, i, len, object, ref, ref1;
      this.isAnimating = true;
      this.disappearCounter = this.object.subObjects.length + 1;
      this.disappearCallback = callback;
      ref = this.object.subObjects;
      for (i = 0, len = ref.length; i < len; i++) {
        object = ref[i];
        if (object.ui) {
          object.ui.executeAnimation(event, (function(_this) {
            return function(sender) {
              _this.disappearCounter--;
              if (_this.disappearCounter === 0) {
                _this.isAnimating = false;
                return typeof _this.disappearCallback === "function" ? _this.disappearCallback(_this.object) : void 0;
              }
            };
          })(this));
        } else {
          this.disappearCounter--;
        }
      }
      animation = (ref1 = this.object.animations) != null ? ref1.first(function(a) {
        return a.events.indexOf(event) !== -1;
      }) : void 0;
      if (animation) {
        return this.object.animationExecutor.execute(animation, (function(_this) {
          return function(sender) {
            _this.disappearCounter--;
            if (_this.disappearCounter === 0) {
              _this.isAnimating = false;
              return typeof _this.disappearCallback === "function" ? _this.disappearCallback(_this.object) : void 0;
            }
          };
        })(this));
      } else {
        this.disappearCounter--;
        if (this.disappearCounter === 0) {
          this.isAnimating = false;
          return typeof this.disappearCallback === "function" ? this.disappearCallback(this.object) : void 0;
        }
      }
    };


    /**
    * Executes the animation defined for the "onInitialize" event. Each UI-Object
    * can have animations for certain events defined in JSON.
    *
    * @param {Function} callback - An optional callback function called when the animation ends.
    * @method appear
     */

    Component_UIBehavior.prototype.appear = function(callback) {
      var cb;
      gs.GlobalEventManager.emit("uiAnimationStart");
      cb = (function(_this) {
        return function(sender) {
          gs.GlobalEventManager.emit("uiAnimationFinish");
          return typeof callback === "function" ? callback(sender) : void 0;
        };
      })(this);
      return this.executeAnimation("onInitialize", cb);
    };


    /**
    * Executes the animation defined for the "onTerminate" event. Each UI-Object
    * can have animations for certain events defined in JSON.
    *
    * @param {Function} callback - An optional callback function called when the animation ends.
    * @method disappear
     */

    Component_UIBehavior.prototype.disappear = function(callback) {
      var cb;
      gs.GlobalEventManager.emit("uiAnimationStart");
      cb = (function(_this) {
        return function(sender) {
          gs.GlobalEventManager.emit("uiAnimationFinish");
          return typeof callback === "function" ? callback(sender) : void 0;
        };
      })(this);
      return this.executeAnimation("onTerminate", cb);
    };


    /**
    * Disposes the component.
    *
    * @method dispose
     */

    Component_UIBehavior.prototype.dispose = function() {
      Component_UIBehavior.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      gs.GlobalEventManager.offByOwner("objectGotFocus", this.object);
      gs.GlobalEventManager.offByOwner("keyUp", this.object);
      gs.GlobalEventManager.offByOwner("mouseDown", this.object);
      return gs.GlobalEventManager.offByOwner("mouseMoved", this.object);
    };


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_UIBehavior.prototype.setupEventHandlers = function() {
      if (this.object.focusable) {
        gs.GlobalEventManager.on("objectGotFocus", ((function(_this) {
          return function(e) {
            if (e.sender !== _this.object) {
              return _this.blur();
            }
          };
        })(this)), null, this.object);
        gs.GlobalEventManager.on("keyUp", ((function(_this) {
          return function(e) {
            if (_this.focused) {
              if (_this.nextKeyObject && (Input.release(Input.KEY_DOWN) || Input.release(Input.KEY_RIGHT))) {
                _this.nextKeyObject.ui.focus();
                return e.breakChain = true;
              } else if (_this.prevKeyObject && (Input.release(Input.KEY_UP) || Input.release(Input.KEY_LEFT))) {
                _this.prevKeyObject.ui.focus();
                return e.breakChain = true;
              }
            }
          };
        })(this)), null, this.object);
      }
      if (this.object.styles.first((function(s) {
        return s.selector === 1;
      }))) {
        gs.GlobalEventManager.on("mouseMoved", ((function(_this) {
          return function(e) {
            var contains;
            if (!_this.enabled) {
              return;
            }
            contains = Rect.contains(_this.object.dstRect.x, _this.object.dstRect.y, _this.object.dstRect.width, _this.object.dstRect.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y);
            if (_this.containsPointer !== contains || (_this.hover && !contains)) {
              _this.containsPointer = contains;
              _this.object.needsUpdate = true;
              _this.hover = contains;
              _this.updateParentStyle();
              _this.updateChildrenStyle();
            }
            return null;
          };
        })(this)), null, this.object);
      }
      if (this.object.focusable || this.object.styles.first((function(s) {
        return s.selector === 2 || s.selector === 4;
      }))) {
        return gs.GlobalEventManager.on("mouseDown", ((function(_this) {
          return function(e) {
            var contains, group, i, len, object;
            if (!_this.enabled || Input.Mouse.buttons[Input.Mouse.LEFT] !== 1) {
              return;
            }
            contains = Rect.contains(_this.object.dstRect.x, _this.object.dstRect.y, _this.object.dstRect.width, _this.object.dstRect.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y);
            if (contains) {
              _this.object.needsUpdate = true;
              _this.focus();
              if (_this.object.selectable) {
                if (_this.object.group) {
                  _this.selected = true;
                  group = gs.ObjectManager.current.objectsByGroup(_this.object.group);
                  for (i = 0, len = group.length; i < len; i++) {
                    object = group[i];
                    if (object !== _this.object) {
                      object.ui.selected = false;
                    }
                  }
                } else {
                  _this.selected = !_this.selected;
                }
              } else {
                _this.updateStyle();
              }
              _this.updateParentStyle();
            }
            return null;
          };
        })(this)), null, this.object, 0);
      }
    };


    /**
    * Initializes the binding-handler.
    * 
    * @method setup
     */

    Component_UIBehavior.prototype.setup = function() {
      return this.setupEventHandlers();
    };


    /**
    * Gives the input focus to this UI object. If the UI object is not focusable, nothing will happen.
    * 
    * @method focus
     */

    Component_UIBehavior.prototype.focus = function() {
      if (this.object.focusable && !this.focused) {
        this.focused = true;
        this.updateChildrenStyle();
        return gs.GlobalEventManager.emit("objectGotFocus", this.object);
      }
    };


    /**
    * Removes the input focus from this UI object. If the UI object is not focusable, nothing will happen.
    * 
    * @method blur
     */

    Component_UIBehavior.prototype.blur = function() {
      if (this.object.focusable && this.focused) {
        this.focused = false;
        this.updateChildrenStyle();
        return gs.GlobalEventManager.emit("objectLostFocus", this.object);
      }
    };

    Component_UIBehavior.prototype.updateParentStyle = function() {
      var parent, ref;
      parent = this.object.parent;
      while (parent) {
        if ((ref = parent.ui) != null) {
          ref.updateStyle();
        }
        parent = parent.parent;
      }
      return null;
    };

    Component_UIBehavior.prototype.updateChildrenStyle = function() {
      var control, i, len, ref;
      if (this.object.controls) {
        ref = this.object.controls;
        for (i = 0, len = ref.length; i < len; i++) {
          control = ref[i];
          if (control && control.ui) {
            control.ui.updateStyle();
            control.ui.updateChildrenStyle();
          }
        }
      }
      return null;
    };

    Component_UIBehavior.prototype.updateStyle = function() {
      var base, i, j, len, len1, object, objects, ref, ref1, style;
      if (this.object.styles) {
        ref = this.object.styles;
        for (i = 0, len = ref.length; i < len; i++) {
          style = ref[i];
          if (!this.viewData_[style.selector]) {
            style.revert(this.object);
          }
        }
        ref1 = this.object.styles;
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          style = ref1[j];
          if (style.target === -1) {
            if (this.viewData_[style.selector]) {
              style.apply(this.object);
            }
          } else {
            objects = this.object.parentsByStyle[style.target];
            if (objects) {
              object = objects[0];
              if (object && object.ui.viewData_[style.selector]) {
                style.apply(this.object);
              }
            }
          }
        }
        if (this.object.font) {
          if (typeof (base = this.object.behavior).refresh === "function") {
            base.refresh();
          }
        }
      }
      return null;
    };


    /**
    * Updates the binding-handler.
    * 
    * @method update
     */

    Component_UIBehavior.prototype.update = function() {
      if (this.nextKeyObjectId && !this.nextKeyObject) {
        return this.nextKeyObject = gs.ObjectManager.current.objectById(this.nextKeyObjectId);
      }
    };

    return Component_UIBehavior;

  })(gs.Component);

  ui.Component_UIBehavior = Component_UIBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Frame,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Frame = (function(superClass) {
    extend(Component_Frame, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_Frame.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * A frame constructs a graphical frame from its skin-image. The frame can
    * rendered by tiling or strechting the four sides of the frame. A frame
    * is useful for creating In-Game UI windows and boxes. For more info about 
    * the skin-image format, see help-file.
    * 
    * @module gs
    * @class Component_Frame
    * @extends gs.Component_Visual
    * @memberof gs
    * @constructor
    * @param {gs.Viewport} viewport An optional native viewport object.
     */

    function Component_Frame(viewport) {
      Component_Frame.__super__.constructor.call(this);

      /**
      * The native frame-object.
      * @property frame
      * @type gs.Frame
       */
      this.frame = new gs.Frame(viewport != null ? viewport : Graphics.viewport);

      /**
      * The name of the skin-image used to construct the frame.
      * @property image
      * @type string
      * @protected
       */
      this.image = null;
    }


    /**
    * Disposes the frame.
    * 
    * @method dispose
     */

    Component_Frame.prototype.dispose = function() {
      Component_Frame.__super__.dispose.apply(this, arguments);
      return this.frame.dispose();
    };


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_Frame.prototype.setupEventHandlers = function() {
      return this.frame.onIndexChange = (function(_this) {
        return function() {
          return _this.object.rIndex = _this.frame.index;
        };
      })(this);
    };


    /**
    * Setup the frame component. This method is automatically called by the
    * system.
    * @method setup
     */

    Component_Frame.prototype.setup = function() {
      return this.setupEventHandlers();
    };


    /**
    * Updates the padding.
    * 
    * @method updatePadding
     */

    Component_Frame.prototype.updatePadding = function() {
      if (this.object.padding != null) {
        this.frame.x += this.object.padding.left;
        this.frame.y += this.object.padding.top;
        this.frame.width -= this.object.padding.left + this.object.padding.right;
        return this.frame.height -= this.object.padding.top + this.object.padding.bottom;
      }
    };


    /**
    * Updates the frame properties from the game object properties.
    *
    * @method updateProperties
     */

    Component_Frame.prototype.updateProperties = function() {
      this.frame.x = this.object.dstRect.x;
      this.frame.y = this.object.dstRect.y;
      this.frame.width = this.object.dstRect.width;
      this.frame.height = this.object.dstRect.height;
      this.frame.thickness = this.object.frameThickness || 16;
      this.frame.cornerSize = this.object.frameCornerSize || 16;
      this.frame.clipRect = this.object.clipRect;
      this.frame.visible = this.object.visible;
      this.frame.ox = -this.object.origin.x;
      this.frame.oy = -this.object.origin.y;
      this.frame.zoomX = this.object.zoom.x;
      this.frame.zoomY = this.object.zoom.y;
      this.frame.angle = this.object.angle || 0;
      this.frame.opacity = this.object.opacity;
      return this.frame.z = (this.object.zIndex || 0) + (!this.object.parent ? 0 : this.object.parent.zIndex || 0);
    };


    /**
    * Updates the optional sprite properties from the game object properties.
    * @method updateOptionalProperties
     */

    Component_Frame.prototype.updateOptionalProperties = function() {
      if (this.object.tone != null) {
        this.frame.tone = this.object.tone;
      }
      if (this.object.color != null) {
        this.frame.color = this.object.color;
      }
      if (this.object.viewport != null) {
        this.frame.viewport = this.object.viewport;
      }
      if (this.object.effects != null) {
        this.frame.wobble = this.object.effects.wobble;
      }
      if (this.object.anchor != null) {
        this.frame.anchor.x = this.object.anchor.x;
        return this.frame.anchor.y = this.object.anchor.y;
      }
    };


    /**
    * Updates the frame's skin-image used to construct the frame.
    *
    * @method updateImage
     */

    Component_Frame.prototype.updateImage = function() {
      var bitmap;
      if ((this.object.image != null) && this.image !== this.object.image) {
        this.image = this.object.image;
        bitmap = ResourceManager.getBitmap((this.object.imageFolder || "Graphics/Pictures") + "/" + this.object.image);
        return this.frame.skin = bitmap;
      }
    };


    /**
    * Updates the frame's padding, properties and skin-image.
    * 
    * @method update
     */

    Component_Frame.prototype.update = function() {
      Component_Frame.__super__.update.apply(this, arguments);
      this.object.rIndex = this.frame.index;
      this.updateProperties();
      this.updateOptionalProperties();
      this.updatePadding();
      return this.updateImage();
    };

    return Component_Frame;

  })(gs.Component_Visual);

  gs.Component_Frame = Component_Frame;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_ThreePartImage,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_ThreePartImage = (function(superClass) {
    extend(Component_ThreePartImage, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_ThreePartImage.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * A three-part image component displays an object on screen using three
    * sub-images: start, middle and end. The start and end will be rendered
    * with fixed size while the middle-part will be stretched in a way like this:<br>
    * <br>
    * |Start-Part Fixed|<-----------Middle-Part Stretched----------->|End-Part Fixed<br>
    * <br>
    * A three-part image is automatically added to the graphics-system
    * and rendered every frame until it gets disposed. It can be horizontal or
    * vertical.
    *
    * @module gs
    * @class Component_ThreePartImage
    * @extends gs.Component_Visual
    * @memberof gs
    * @constructor
     */

    function Component_ThreePartImage(viewport) {
      Component_ThreePartImage.__super__.constructor.call(this);

      /**
      * The native three-part image graphic object.
      * @property threePartImage
      * @type gs.ThreePartImage
       */
      this.threePartImage = new gs.ThreePartImage(viewport != null ? viewport : Graphics.viewport);

      /**
      * The name of the image used to construct the three-part image.
      * @property image
      * @type string
      * @protected
       */
      this.image = null;
    }


    /**
    * Disposes the three-part image.
    * 
    * @method dispose
     */

    Component_ThreePartImage.prototype.dispose = function() {
      Component_ThreePartImage.__super__.dispose.apply(this, arguments);
      return this.threePartImage.dispose();
    };


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_ThreePartImage.prototype.setupEventHandlers = function() {
      return this.threePartImage.onIndexChange = (function(_this) {
        return function() {
          return _this.object.rIndex = _this.threePartImage.index;
        };
      })(this);
    };


    /**
    * Setup the three-part image component. This method is automatically called by the
    * system.
    * @method setup
     */

    Component_ThreePartImage.prototype.setup = function() {
      return this.setupEventHandlers();
    };


    /**
    * Updates the three-part image properties from the game object properties.
    *
    * @method updateProperties
     */

    Component_ThreePartImage.prototype.updateProperties = function() {
      this.threePartImage.x = this.object.dstRect.x - this.object.dstRect.width * (this.object.zoom.x - 1.0) * this.object.anchor.x;
      this.threePartImage.y = this.object.dstRect.y - this.object.dstRect.height * (this.object.zoom.y - 1.0) * this.object.anchor.y;
      this.threePartImage.width = this.object.dstRect.width;
      this.threePartImage.height = this.object.dstRect.height;
      this.threePartImage.firstPartSize = this.object.firstPartSize || 16;
      this.threePartImage.middlePartSize = this.object.middlePartSize || 1;
      this.threePartImage.lastPartSize = this.object.lastPartSize || 16;
      this.threePartImage.visible = this.object.visible;
      this.threePartImage.ox = -this.object.origin.x;
      this.threePartImage.oy = -this.object.origin.y;
      this.threePartImage.z = (this.object.zIndex || 0) + (!this.object.parent ? 0 : this.object.parent.zIndex || 0);
      this.threePartImage.angle = this.object.angle || 0;
      this.threePartImage.anchor.x = this.object.anchor.x;
      return this.threePartImage.anchor.y = this.object.anchor.y;
    };


    /**
    * Updates the padding.
    * 
    * @method updatePadding
     */

    Component_ThreePartImage.prototype.updatePadding = function() {
      if (this.object.padding != null) {
        this.threePartImage.x += this.object.padding.left;
        this.threePartImage.y += this.object.padding.top;
        this.threePartImage.width -= this.object.padding.left + this.object.padding.right;
        return this.threePartImage.height -= this.object.padding.top + this.object.padding.bottom;
      }
    };


    /**
    * Updates the skin-image used to construct the three-part image.
    *
    * @method updateImage
     */

    Component_ThreePartImage.prototype.updateImage = function() {
      var bitmap;
      if ((this.object.image != null) && this.image !== this.object.image) {
        this.image = this.object.image;
        bitmap = ResourceManager.getBitmap((this.object.imageFolder || "Graphics/Pictures") + "/" + this.object.image);
        return this.threePartImage.skin = bitmap;
      }
    };


    /**
    * Updates the three-part image.
    * 
    * @method update
     */

    Component_ThreePartImage.prototype.update = function() {
      Component_ThreePartImage.__super__.update.apply(this, arguments);
      this.object.rIndex = this.threePartImage.index;
      this.updateProperties();
      this.updatePadding();
      return this.updateImage();
    };

    return Component_ThreePartImage;

  })(gs.Component_Visual);

  gs.Component_ThreePartImage = Component_ThreePartImage;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_PanelBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_PanelBehavior = (function(superClass) {
    extend(Component_PanelBehavior, superClass);


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_PanelBehavior.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * A panel-component gives a game-object the same capabilities like
    * a visual object but has no graphical representation. So a panel has
    * a position and a size.<br>
    * <br>
    * It can be used to make invisible hotspot-areas or modal-blocking areas for
    * example.
    *
    * @module gs
    * @class Component_PanelBehavior
    * @extends gs.Component_Visual
    * @memberof gs
    * @constructor
     */

    function Component_PanelBehavior() {}


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_PanelBehavior.prototype.setupEventHandlers = function() {
      if (this.object.modal) {
        gs.GlobalEventManager.on("mouseUp", ((function(_this) {
          return function(e) {
            if (_this.object.modal) {
              return e.breakChain = true;
            }
          };
        })(this)), null, this.object);
        gs.GlobalEventManager.on("mouseDown", ((function(_this) {
          return function(e) {
            if (_this.object.modal) {
              return e.breakChain = true;
            }
          };
        })(this)), null, this.object);
        return gs.GlobalEventManager.on("mouseMoved", ((function(_this) {
          return function(e) {
            if (_this.object.modal) {
              return e.breakChain = true;
            }
          };
        })(this)), null, this.object);
      }
    };


    /**
    * Initializes the panel component.
    *
    * @method setup
     */

    Component_PanelBehavior.prototype.setup = function() {
      return this.setupEventHandlers();
    };


    /**
    * Disposes the component.
    *
    * @method dispose
     */

    Component_PanelBehavior.prototype.dispose = function() {
      Component_PanelBehavior.__super__.dispose.apply(this, arguments);
      gs.GlobalEventManager.offByOwner("mouseUp", this.object);
      gs.GlobalEventManager.offByOwner("mouseDown", this.object);
      return gs.GlobalEventManager.offByOwner("mouseMoved", this.object);
    };

    return Component_PanelBehavior;

  })(gs.Component_Visual);

  gs.Component_PanelBehavior = Component_PanelBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_NumberInput,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_NumberInput = (function(superClass) {
    extend(Component_NumberInput, superClass);


    /**
    * The number-input component defines the logic for the number-input window
    * of the default In-Game UI. 
    *
    * @module gs
    * @class Component_NumberInput
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_NumberInput(params) {

      /**
      * The max. number of digits of the number.
      * @property digits
      * @type number
       */
      this.digits = ui.Component_FormulaHandler.fieldValue(this, params.digits);

      /**
      * The number-cursor position.
      * @property digits
      * @type number
      * @protected
       */
      this.cursor = 0;

      /**
      * The current number as text.
      * @property number
      * @type string
       */
      this.number = "";
    }


    /**
    * Initializes the number-input component.
    *
    * @method setup
     */

    Component_NumberInput.prototype.setup = function() {
      var text;
      text = "".fill("0", this.digits);
      return null;
    };


    /**
    * An action-method to add a single number/digit.
    *
    * @method action_addNumber
    * @param {gs.Object_Base} sender The sender of the action.
    * @param {Object} params The params-object which need a number-property containing the digit/number to add.
     */

    Component_NumberInput.prototype.action_addNumber = function(sender, params) {
      var number;
      number = ui.Component_FormulaHandler.fieldValue(sender, params.number);
      if (this.number.length === 0 && number === 0) {
        return;
      }
      if (this.number.length < this.digits) {
        this.number += number.toString();
      } else {
        this.number = this.number.replaceAt(this.number.length - 1, number.toString());
      }
      return this.setNumber(this.number);
    };


    /**
    * An action-method to clear the number at the current cursor position.
    *
    * @method action_removeNumber
    * @param {gs.Object_Base} sender The sender of the action.
    * @param {Object} [params=null] The params-object. Can be <b>null</b>.
     */

    Component_NumberInput.prototype.action_removeNumber = function(sender, params) {
      if (this.number.length > 0) {
        this.number = this.number.substring(0, this.number.length - 1);
      }
      this.setNumber(this.number);
      return this.setNumber(this.number);
    };


    /**
    * Puts the specified number into the UI label-objects to make it visible
    * on screen.
    *
    * @method setNumber
    * @param {string} number The number to set.
     */

    Component_NumberInput.prototype.setNumber = function(number) {
      var c, i, j, len, text;
      text = number.lfill("0", this.digits);
      for (i = j = 0, len = text.length; j < len; i = ++j) {
        c = text[i];
        this.object.controls[i].controls[1].text = c;
        this.object.controls[i].controls[1].update();
      }
      return null;
    };

    return Component_NumberInput;

  })(gs.Component);

  gs.Component_NumberInput = Component_NumberInput;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_TextInput,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_TextInput = (function(superClass) {
    extend(Component_TextInput, superClass);


    /**
    * The text-input component defines the logic for the text-input window
    * of the default In-Game UI. 
    *
    * @module gs
    * @class Component_TextInput
    * @extends gs.Component
    * @memberof gs
    * @constructor
    * @params {Object} params - The params-object needs at least a letters-property to define 
    * the number of letters for the text. The letters-property can also be a property-path.
     */

    function Component_TextInput(params) {

      /**
      * The max. number of letters.
      * @property letters
      * @type number
       */
      this.letters = ui.Component_FormulaHandler.fieldValue(this, params.letters);

      /**
      * The cursor position. Points to the current letter.
      * @property cursor
      * @type number
      * @protected
       */
      this.cursor = 0;

      /**
      * The current text.
      * @property text
      * @type string
       */
      this.text = "";
    }


    /**
    * Puts the specified text into the UI label-objects to make it visible
    * on screen.
    *
    * @method setText
    * @param {string} text The text to set.
     */

    Component_TextInput.prototype.setText = function(text) {
      var c, i, j, len;
      for (i = j = 0, len = text.length; j < len; i = ++j) {
        c = text[i];
        this.object.controls[i].controls[1].text = c;
      }
      return null;
    };


    /**
    * An action-method to add a single letter to the text.
    *
    * @method action_addLetter
    * @param {gs.Object_Base} sender The sender of the action.
    * @param {Object} params The params-object which needs a letter-property containing the letter to add.
     */

    Component_TextInput.prototype.action_addLetter = function(sender, params) {
      var letter;
      letter = params.letter;
      if (this.text.length < this.letters) {
        this.text += letter;
      } else {
        this.text = this.text.replaceAt(this.text.length - 1, letter.toString());
      }
      return this.setText(this.text.rfill(" ", this.letters));
    };


    /**
    * An action-method to clear the letter at the current cursor position.
    *
    * @method action_removeLetter
    * @param {gs.Object_Base} sender The sender of the action.
    * @param {Object} [params=null] The params-object. Can be <b>null</b>.
     */

    Component_TextInput.prototype.action_removeLetter = function() {
      if (this.text.length > 0) {
        this.text = this.text.substring(0, this.text.length - 1);
      }
      return this.setText(this.text.rfill(" ", this.letters));
    };

    return Component_TextInput;

  })(gs.Component);

  gs.Component_TextInput = Component_TextInput;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_DataGridBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_DataGridBehavior = (function(superClass) {
    var DataSource, DataWrapper;

    extend(Component_DataGridBehavior, superClass);

    DataWrapper = (function() {
      function DataWrapper(data) {
        this.data = data;
        this.viewData = [true, false, false, true, false];
      }

      return DataWrapper;

    })();

    DataSource = (function() {
      function DataSource(source) {
        var i, k, ref;
        this.source = source || [];
        this.length = this.source.length;
        this.wrappedSource = new Array(this.source.length);
        for (i = k = 0, ref = this.wrappedSource.length; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
          this.wrappedSource[i] = null;
        }
      }

      DataSource.prototype.set = function(source) {
        var i, k, ref, results;
        this.source = source || [];
        this.length = this.source.length;
        this.wrappedSource = new Array(this.source.length);
        results = [];
        for (i = k = 0, ref = this.wrappedSource.length; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
          results.push(this.wrappedSource[i] = null);
        }
        return results;
      };

      DataSource.prototype.itemAt = function(index) {
        var item;
        item = this.wrappedSource[index];
        if (!item) {
          item = new DataWrapper(this.source[index]);
          this.wrappedSource[index] = item;
        }
        return item;
      };

      DataSource.prototype.setItemAt = function(index, data) {
        if (this.wrappedSource[index]) {
          this.wrappedSource[index].data = data;
        }
        return this.source[index] = data;
      };

      return DataSource;

    })();

    Component_DataGridBehavior.accessors("dataSource", {
      set: function(v) {
        if (v !== this.dataSource_.source) {
          this.dataSource_.set(v);
          return this.resize();
        }
      },
      get: function() {
        return this.dataSource_;
      }
    });


    /**
    * Called if this object instance is restored from a data-bundle. It can be used
    * re-assign event-handler, anonymous functions, etc.
    * 
    * @method onDataBundleRestore.
    * @param Object data - The data-bundle
    * @param gs.ObjectCodecContext context - The codec-context.
     */

    Component_DataGridBehavior.prototype.onDataBundleRestore = function(data, context) {
      return this.setupEventHandlers();
    };


    /**
    * The data-grid behavior component defines the logic for a data-grid. A data-grid
    * allows to display items from a associated data-source using a specified
    * item-template. Unlike a stack-layout, a data-grid is optimized to display even high amounts of items but they all
    * need to use the same item-template with same size.
    *
    * @module ui
    * @class Component_DataGridBehavior
    * @extends gs.Component_Visual
    * @memberof ui
    * @constructor
    * @params {Object} params - The params-object containing the data-grid settings.
     */

    function Component_DataGridBehavior(params) {
      Component_DataGridBehavior.__super__.constructor.call(this);
      this.params = params || {};

      /**
      * The item-template descriptor used for each item of the data-grid.
      * @property template
      * @type Object
       */
      this.template = this.params.template;

      /**
      * The data-source used for the data-grid. Can be an array or a formula.
      * @property dataSource
      * @type Object[]|string
       */
      this.dataSource_ = null;

      /**
      * Stores the item-objects needed for rendering. They are created from the item-template.
      * @property items
      * @protected
      * @type gs.Object_Base[]
       */
      this.items = this.params.items || [];

      /**
      * Numbers of columns.
      * @property columns
      * @type number
       */
      this.columns = this.params.columns || 1;

      /**
      * Indicates if the data-grid is initialized and ready for rendering.
      * @property initialized
      * @protected
      * @type boolean
       */
      this.initialized = false;

      /**
      * Defines a horizontal and vertical spacing between items.
      * @property spacing
      * @default [0, 10]        
      * @type number[]
       */
      this.spacing = this.params.spacing || [0, 0];
    }


    /**
    * Adds event-handlers for mouse/touch events
    *
    * @method setupEventHandlers
     */

    Component_DataGridBehavior.prototype.setupEventHandlers = function() {
      return gs.GlobalEventManager.on("mouseWheel", (function(_this) {
        return function() {
          var r;
          r = _this.object.dstRect;
          if (Rect.contains(r.x, r.y, r.width, r.height, Input.Mouse.x - _this.object.origin.x, Input.Mouse.y - _this.object.origin.y)) {
            return _this.updateScroll();
          }
        };
      })(this));
    };


    /**
    * Sets up the data-grid.
    *
    * @method setup
     */

    Component_DataGridBehavior.prototype.setup = function() {
      var item;
      if (this.object.dstRect.width === 1) {
        return;
      }
      this.initialized = true;
      if (!this.template.size) {
        item = ui.UIManager.createControlFromDescriptor(this.template.descriptor, this.object);
        item.index = 0;
        item.update();
        this.template.size = [item.dstRect.width, item.dstRect.height];
        item.dispose();
      }
      if (this.params.dataSource.exec) {
        this.dataSource_ = new DataSource(ui.Component_FormulaHandler.fieldValue(this.object, this.params.dataSource) || []);
      } else {
        this.dataSource_ = new DataSource(this.params.dataSource || []);
      }
      this.resize();
      this.setupEventHandlers();
      Component_DataGridBehavior.__super__.setup.call(this);
      return this.object.scrollableHeight = Math.max(0, this.object.contentHeight - this.object.dstRect.height);
    };


    /**
    * Scrolls to the end.
    *
    * @method scrollToEnd
     */

    Component_DataGridBehavior.prototype.scrollToEnd = function() {
      return this.object.scrollOffsetY = this.object.scrollableHeight;
    };


    /**
    * Updates scrolling.
    *
    * @method updateScroll
     */

    Component_DataGridBehavior.prototype.updateScroll = function() {
      this.object.scrollableHeight = Math.max(0, this.object.contentHeight - this.object.dstRect.height);
      if (Input.Mouse.wheel <= -1) {
        this.object.scrollOffsetY = Math.max(this.object.scrollOffsetY - Input.Mouse.wheelSpeed * 0.1, 0);
      }
      if (Input.Mouse.wheel >= 1) {
        this.object.scrollOffsetY = Math.min(this.object.scrollOffsetY - Input.Mouse.wheelSpeed * 0.1, this.object.scrollableHeight);
      }
      return this.object.scrollOffsetY = Math.max(Math.min(this.object.scrollOffsetY, this.object.scrollableHeight), 0);
    };


    /**
    * Resizes the data-grid and creates the necessary display objects from the data-grid template.
    *
    * @method resize
     */

    Component_DataGridBehavior.prototype.resize = function() {
      var height, index, item, itemsX, itemsY, k, l, len, m, ref, ref1, ref2, totalItemsY, width, x, y;
      width = this.object.dstRect.width;
      height = this.object.dstRect.height;
      itemsX = this.columns || 1;
      itemsY = Math.ceil((height - this.spacing[1]) / (this.template.size[1] + this.spacing[1])) + this.columns + 1;
      totalItemsY = Math.ceil(this.dataSource.length / this.columns);
      ref = this.items;
      for (k = 0, len = ref.length; k < len; k++) {
        item = ref[k];
        if (item != null) {
          item.dispose();
        }
      }
      this.items = [];
      for (y = l = 0, ref1 = itemsY; 0 <= ref1 ? l < ref1 : l > ref1; y = 0 <= ref1 ? ++l : --l) {
        for (x = m = 0, ref2 = itemsX; 0 <= ref2 ? m < ref2 : m > ref2; x = 0 <= ref2 ? ++m : --m) {
          index = y * itemsX + x;
          if (index < this.dataSource.length) {
            item = ui.UIManager.createControlFromDescriptor(this.template.descriptor, this.object);
            item.data[0] = this.dataSource.itemAt(index).data;
            item.dstRect.x = this.spacing[0] + x * (this.template.size[0] + this.spacing[0]);
            item.dstRect.y = this.spacing[1] + y * (this.template.size[1] + this.spacing[1]);
            item.dstRect.width = this.template.size[0];
            item.dstRect.height = this.template.size[1];
            item.index = index;
            item.ui.viewData = this.dataSource.itemAt(index).viewData;
            this.items[item.index] = item;
            this.object.addObject(item);
          }
        }
      }
      this.object.scrollableHeight = this.spacing[1] + totalItemsY * (this.template.size[1] + this.spacing[1]) - height;
      this.object.scrollOffsetY = 0;
      return this.object.contentHeight = this.spacing[1] + totalItemsY * (this.template.size[1] + this.spacing[1]);
    };

    Component_DataGridBehavior.prototype.itemAtIndex = function(index) {
      return this.items.first(function(item) {
        return item.index === index;
      });
    };

    Component_DataGridBehavior.prototype.indexForItem = function(item) {
      return item.index;
    };


    /**
    * Updates the data-grid.
    *
    * @method update
     */

    Component_DataGridBehavior.prototype.update = function() {
      var column, i, item, itemIndex, itemsY, j, k, offset, ref, ref1, results, row, scrollOffset;
      Component_DataGridBehavior.__super__.update.call(this);
      if (!this.initialized) {
        this.setup();
      }
      scrollOffset = this.object.scrollOffsetY;
      offset = Math.floor(scrollOffset / (this.template.size[1] + this.spacing[1])) * this.columns;
      i = offset;
      itemIndex = 0;
      itemsY = Math.ceil((this.object.dstRect.height - this.spacing[1]) / (this.template.size[1] + this.spacing[1])) * this.columns + this.columns + 1;
      while (i < Math.min(offset + itemsY, this.dataSource.length)) {
        row = Math.floor(i / this.columns);
        column = i % this.columns;
        item = this.items[itemIndex];
        if (item) {
          item.data[0] = this.dataSource.itemAt(i).data;
          if (this.object.clipRect) {
            item.clipRect = this.object.clipRect;
          }
          item.index = i;
          item.ui.viewData = this.dataSource.itemAt(i).viewData;
          item.dstRect.x = this.spacing[0] + column * (this.template.size[0] + this.spacing[0]);
          item.dstRect.y = this.spacing[1] + (row - (offset / this.columns)) * (this.template.size[1] + this.spacing[1]) + (-scrollOffset % (this.template.size[1] + this.spacing[1]));
          item.visible = true;
          item.update();
          item.update();
          itemIndex++;
        }
        i++;
      }
      results = [];
      for (j = k = ref = itemIndex, ref1 = this.items.length; ref <= ref1 ? k < ref1 : k > ref1; j = ref <= ref1 ? ++k : --k) {
        if (this.items[j]) {
          this.items[j].visible = false;
          results.push(this.items[j].update());
        } else {
          results.push(void 0);
        }
      }
      return results;
    };

    return Component_DataGridBehavior;

  })(gs.Component_Visual);

  ui.Component_DataGridBehavior = Component_DataGridBehavior;

}).call(this);



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=Scene_167.js
// Generated by CoffeeScript 1.12.7
(function() {
  var Component_SceneBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_SceneBehavior = (function(superClass) {
    extend(Component_SceneBehavior, superClass);


    /**
    * The base class of all scene-behavior components. A scene-behavior component
    * define the logic of a single game scene. 
    *
    * @module gs
    * @class Component_SceneBehavior
    * @extends gs.Component_Container
    * @memberof gs
     */

    function Component_SceneBehavior() {
      Component_SceneBehavior.__super__.constructor.call(this);
      this.loadingScreenVisible = false;
    }


    /**
    * Initializes the scene. 
    *
    * @method initialize
    * @abstract
     */

    Component_SceneBehavior.prototype.initialize = function() {};


    /**
    * Disposes the scene.
    *
    * @method dispose
     */

    Component_SceneBehavior.prototype.dispose = function() {
      var ref;
      if (!GameManager.inLivePreview) {
        ResourceManager.dispose();
      }
      return (ref = this.object.events) != null ? ref.emit("dispose", this.object) : void 0;
    };


    /**
    * Called if the preparation and transition
    * is done and the is ready to start.
    *
    * @method start
     */

    Component_SceneBehavior.prototype.start = function() {};


    /**
    * Prepares all visual game object for the scene.
    *
    * @method prepareVisual
    * @abstract
     */

    Component_SceneBehavior.prototype.prepareVisual = function() {};


    /**
    * Prepares all data for the scene and loads the necessary graphic and audio resources.
    *
    * @method prepareData
    * @abstract
     */

    Component_SceneBehavior.prototype.prepareData = function() {};


    /**
    * Prepares for a screen-transition.
    *
    * @method prepareTransition
    * @param {Object} transitionData - Object containing additional data for the transition 
    * like graphic, duration and vague.
     */

    Component_SceneBehavior.prototype.prepareTransition = function(transitionData) {
      var ref;
      if ((transitionData != null ? (ref = transitionData.graphic) != null ? ref.name.length : void 0 : void 0) > 0) {
        return ResourceManager.getBitmap("Graphics/Masks/" + transitionData.graphic.name);
      }
    };


    /**
    * Executes a screen-transition.
    *
    * @method transition
    * @param {Object} transitionData - Object containing additional data for the transition 
    * like graphic, duration and vague.
     */

    Component_SceneBehavior.prototype.transition = function(transitionData) {
      var ref;
      if ($PARAMS.preview) {
        return Graphics.transition(0);
      } else {
        transitionData = transitionData || SceneManager.transitionData;
        if ((transitionData != null ? (ref = transitionData.graphic) != null ? ref.name.length : void 0 : void 0) > 0) {
          return Graphics.transition(transitionData.duration, ResourceManager.getBitmap("Graphics/Masks/" + transitionData.graphic.name), transitionData.vague || 30);
        } else {
          return Graphics.transition(transitionData.duration);
        }
      }
    };


    /**
    * Update the scene's content.
    *
    * @method updateContent
    * @abstract
     */

    Component_SceneBehavior.prototype.updateContent = function() {};


    /**
    * Sets up the loading screen.
    *
    * @method prepareLoadingScreen
     */

    Component_SceneBehavior.prototype.prepareLoadingScreen = function() {
      var bitmap;
      this.loadingBackgroundSprite = new gs.Sprite();
      if (gs.Platform.isWeb && !GameManager.inLivePreview) {
        bitmap = new gs.Bitmap(300, 100);
        bitmap.font.name = "Times New Roman";
        bitmap.drawText(0, 0, 300, 100, "NOW LOADING", 1, 1);
        this.loadingBackgroundSprite.x = (Graphics.width - bitmap.width) / 2;
        this.loadingBackgroundSprite.y = (Graphics.height - bitmap.height) / 2;
        this.loadingBackgroundSprite.bitmap = bitmap;
        return this.loadingBackgroundSprite.srcRect = new gs.Rect(0, 0, bitmap.width, bitmap.height);
      }
    };


    /**
    * Disposes the loading screen.
    *
    * @method clearLoadingScreen
     */

    Component_SceneBehavior.prototype.clearLoadingScreen = function() {
      if (this.loadingBackgroundSprite) {
        if (gs.Platform.isWeb && !GameManager.inLivePreview) {
          this.loadingBackgroundSprite.bitmap.dispose();
        }
        this.loadingBackgroundSprite.dispose();
        return this.loadingBackgroundSprite = null;
      }
    };


    /**
    * Called once per frame while a scene is loading. Can be used to display
    * loading-message/animation.
    *
    * @method loading
     */

    Component_SceneBehavior.prototype.loading = function() {
      if (this.loadingBackgroundSprite2 == null) {
        this.loadingBackgroundSprite2 = {};

        /*
        bitmap = new gs.Bitmap(300, 100)
        bitmap.drawText(0, 0, 300, 100, "NOW LOADING", 1, 1)
        @loadingBackgroundSprite = new gs.Sprite()
        @loadingBackgroundSprite.x = (Graphics.width - bitmap.width) / 2
        @loadingBackgroundSprite.y = (Graphics.height - bitmap.height) / 2
        @loadingBackgroundSprite.bitmap = bitmap
        @loadingBackgroundSprite.srcRect = new gs.Rect(0, 0, bitmap.width, bitmap.height)
         */
        if (Graphics.frozen) {
          return this.transition({
            duration: 0
          });
        }
      }
    };


    /**
    * Update the scene.
    *
    * @method update
     */

    Component_SceneBehavior.prototype.update = function() {
      Component_SceneBehavior.__super__.update.call(this);
      if (DataManager.documentsLoaded) {
        if (this.object.loadingData && !this.object.initialized) {
          this.prepareData();
        }
        this.object.loadingData = !DataManager.documentsLoaded;
      }
      if (!this.object.loadingData && ResourceManager.resourcesLoaded) {
        if (this.object.loadingResources && !this.object.initialized) {
          if (!this.loadingScreenVisible) {
            this.prepareVisual();
          }
          this.object.initialized = true;
        }
        this.object.loadingResources = false;
      }
      if (ResourceManager.resourcesLoaded && DataManager.documentsLoaded) {
        this.object.loading = false;
        if (Graphics.frozen && this.object.preparing) {
          return Graphics.update();
        } else {
          if (this.loadingScreenVisible) {
            if (this.object.loaded) {
              this.loadingScreenVisible = false;
              this.object.loaded = true;
              return this.updateContent();
            } else {
              if (!Graphics.frozen) {
                Graphics.freeze();
              }
              this.clearLoadingScreen();
              this.object.loaded = true;
              this.object.setup();
              this.prepareVisual();
              this.loadingScreenVisible = false;
              Graphics.update();
              return Input.update();
            }
          } else {
            this.clearLoadingScreen();
            if (this.object.preparing) {
              this.object.preparing = false;
              this.start();
            }
            Graphics.update();
            if (!Graphics.frozen) {
              this.updateContent();
            }
            return Input.update();
          }
        }
      } else {
        this.loadingScreenVisible = true;
        Graphics.update();
        Input.update();
        return this.loading();
      }
    };

    return Component_SceneBehavior;

  })(gs.Component_Container);

  gs.Component_SceneBehavior = Component_SceneBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_LayoutSceneBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_LayoutSceneBehavior = (function(superClass) {
    extend(Component_LayoutSceneBehavior, superClass);


    /**
    * The base class of all scene-behavior components. A scene-behavior component
    * define the logic of a single game scene.
    *
    * @module gs
    * @class Component_LayoutSceneBehavior
    * @extends gs.Component_SceneBehavior
    * @memberof gs
     */

    function Component_LayoutSceneBehavior() {
      Component_LayoutSceneBehavior.__super__.constructor.call(this);
      this.objectManager = SceneManager;
      this.layout = null;
      this.resourceContext = null;
    }


    /**
    * Initializes the scene.
    *
    * @method initialize
     */

    Component_LayoutSceneBehavior.prototype.initialize = function() {
      Component_LayoutSceneBehavior.__super__.initialize.apply(this, arguments);
      this.resourceContext = ResourceManager.createContext();
      ResourceManager.context = this.resourceContext;
      if (this.object.layoutData == null) {
        this.object.layoutData = {
          "type": "ui.FreeLayout",
          "controls": [],
          "frame": [0, 0, 1, 1]
        };
      }
      return LanguageManager.loadBundles();
    };


    /**
    * Disposes the scene.
    *
    * @method dispose
     */

    Component_LayoutSceneBehavior.prototype.dispose = function() {
      return Component_LayoutSceneBehavior.__super__.dispose.apply(this, arguments);
    };


    /**
    * Prepares all data for the scene and loads the necessary graphic and audio resources.
    *
    * @method prepareData
    * @abstract
     */

    Component_LayoutSceneBehavior.prototype.prepareData = function() {
      gs.ObjectManager.current = this.objectManager;
      if (!GameManager.initialized) {
        GameManager.initialize();
      }
      this.dataFields = ui.UiFactory.dataSources[this.object.layoutData.dataSource || "default"]();
      window.$dataFields = this.dataFields;
      this.music = ui.Component_FormulaHandler.fieldValue(this.object, this.object.layoutData.music);
      AudioManager.loadMusic(this.music);
      this.prepareTransition(RecordManager.system.menuTransition);
      ResourceLoader.loadUiTypesGraphics(ui.UiFactory.customTypes);
      ResourceLoader.loadUiLayoutGraphics(this.object.layoutData);
      if (this.dataFields != null) {
        return ResourceLoader.loadUiDataFieldsGraphics(this.dataFields);
      }
    };


    /**
    * Prepares all visual game object for the scene.
    *
    * @method prepareVisual
     */

    Component_LayoutSceneBehavior.prototype.prepareVisual = function() {
      var scale, vocab;
      scale = Graphics.scale;
      vocab = RecordManager.vocabulary;
      if (this.layout == null) {
        this.dataObject = {};
        this.layout = ui.UiFactory.createFromDescriptor(this.object.layoutData, this.object);
        if (this.music != null) {
          AudioManager.changeMusic(this.music, 30);
        }
      }
      this.layout.ui.prepare();
      this.layout.ui.appear();
      this.layout.update();
      this.transition();
      if (SceneManager.previousScenes.length === 0) {
        if (GameManager.tempFields.isExitingGame) {
          GameManager.tempFields.isExitingGame = false;
          return gs.GameNotifier.postResetSceneChange(this.object.layoutName);
        } else {
          return gs.GameNotifier.postSceneChange(this.object.layoutName);
        }
      }
    };


    /**
    * Updates the scene's content.
    *
    * @method updateContent
     */

    Component_LayoutSceneBehavior.prototype.updateContent = function() {
      GameManager.update();
      return Graphics.viewport.update();
    };


    /**
    * Shows/Hides the current scene. A hidden scene is no longer shown and executed
    * but all objects and data is still there and be shown again anytime.
    *
    * @method show
    * @param {boolean} visible - Indicates if the scene should be shown or hidden.
     */

    Component_LayoutSceneBehavior.prototype.show = function(visible) {
      if (visible) {
        ResourceManager.context = this.resourceContext;
      }
      this.layout.visible = visible;
      this.layout.update();
      this.objectManager.active = visible;
      if (visible) {
        return gs.ObjectManager.current = SceneManager;
      }
    };


    /**
    * Action method which triggers a full refresh on the object returned by the specified binding-expression.
    * The params must be a direct binding-expression string.
    *
    * @method fullRefreshObject
    * @param {gs.Object_Base} sender - The sender object.
    * @param {string} params -  The binding expression.
     */

    Component_LayoutSceneBehavior.prototype.fullRefreshObject = function(sender, object) {
      object = ui.Component_FormulaHandler.fieldValue(sender, object);
      return object != null ? object.fullRefresh() : void 0;
    };


    /**
    * Action method which triggers a refresh on the object returned by the specified binding-expression.
    * The params must be a direct binding-expression string.
    *
    * @method refreshObject
    * @param {gs.Object_Base} sender - The sender object.
    * @param {string} params -  The binding expression.
     */

    Component_LayoutSceneBehavior.prototype.refreshObject = function(sender, object) {
      object = ui.Component_FormulaHandler.fieldValue(sender, object);
      return object != null ? object.needsUpdate = true : void 0;
    };

    Component_LayoutSceneBehavior.prototype.addStyle = function(sender, style) {
      var styleObject;
      styleObject = ui.UIManager.styles[style];
      if (styleObject != null) {
        styleObject.apply(sender);
      }
      sender.needsUpdate = true;
      if (styleObject != null ? styleObject.font : void 0) {
        return sender.behavior.refresh();
      }
    };

    Component_LayoutSceneBehavior.prototype.removeStyle = function(sender, style) {
      var i, len, ref, ref1, s, styleObject;
      styleObject = ui.UIManager.styles[style];
      if (styleObject != null) {
        styleObject.revert(sender);
      }
      sender.descriptor.styles.remove(style);
      ref = sender.descriptor.styles;
      for (i = 0, len = ref.length; i < len; i++) {
        s = ref[i];
        if ((ref1 = ui.UIManager.styles[s]) != null) {
          ref1.apply(sender);
        }
      }
      sender.needsUpdate = true;
      if (styleObject != null ? styleObject.font : void 0) {
        return sender.behavior.refresh();
      }
    };


    /**
    * Action method which executes the specified bindings.
    *
    * @method executeBindings
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object[]} params -  An array of binding-definitions.
     */

    Component_LayoutSceneBehavior.prototype.executeBindings = function(sender, bindings) {
      var binding, i, len;
      for (i = 0, len = bindings.length; i < len; i++) {
        binding = bindings[i];
        ui.Component_FormulaHandler.executeBinding(sender, binding);
      }
      return null;
    };


    /**
    * Action method which executes the specified formulas.
    *
    * @method executeFormulas
    * @param {gs.Object_Base} sender - The sender object.
    * @param {ui.Formula[]} params -  An array of formula-definitions.
     */

    Component_LayoutSceneBehavior.prototype.executeFormulas = function(sender, formulas) {
      var formula, i, len, results;
      results = [];
      for (i = 0, len = formulas.length; i < len; i++) {
        formula = formulas[i];
        results.push(ui.Component_FormulaHandler.executeFormula(sender, formula));
      }
      return results;
    };


    /**
    * Action method which executes an animation on a specified target game object.
    *
    * @method executeAnimation
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params -  Contains target-id and animations: { target, animations }
     */

    Component_LayoutSceneBehavior.prototype.executeAnimation = function(sender, params) {
      var animation, object;
      object = ui.Component_FormulaHandler.fieldValue(sender, params.target);
      animation = object != null ? object.animations.first(function(a) {
        return a.event === params.event;
      }) : void 0;
      if (animation && object) {
        return object.animationExecutor.execute(animation);
      }
    };


    /**
    * Action method which emits the specified event.
    *
    * @method emitEvent
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Contains event name, source and data.
    * <ul>
    * <li>params.name - The name of the event to emit</li>
    * <li>params.source - A binding-expression to define the game object which should emit the event.</li>
    * <li>params.data - An object containing additional event specific data.</li>
    * </ul>
     */

    Component_LayoutSceneBehavior.prototype.emitEvent = function(sender, params) {
      var object;
      object = ui.Component_FormulaHandler.fieldValue(sender, params.source);
      return object != null ? object.events.emit(params.name, object, ui.Component_FormulaHandler.fieldValue(sender, params.data)) : void 0;
    };


    /**
    * Action method which changes the game's aspect ratio.
    *
    * @method executeBindings
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean} params -  If <b>true</b> the game screen will stretched so that it fills the entire screen
    * of the player without any black borders. Otherwise the game screen stretches but keeps its ratio
    * so black borders are possible if the game resolution's ratio and the target display's ratio are not match. It can also
    * be a binding-expression.
     */

    Component_LayoutSceneBehavior.prototype.adjustAspectRatio = function(sender, adjust) {
      adjust = ui.Component_FormulaHandler.fieldValue(sender, adjust);
      GameManager.settings.adjustAspectRatio = adjust;
      Graphics.keepRatio = !adjust;
      return Graphics.onResize();
    };


    /**
    * Action method which enters fullscreen mode.
    *
    * @method enterFullScreen
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean} params - Can be <b>null</b>
     */

    Component_LayoutSceneBehavior.prototype.enterFullScreen = function(sender, params) {
      gs.Graphics.enterFullscreen();
      return GameManager.settings.fullScreen = Graphics.isFullscreen();
    };


    /**
    * Action method which leaves fullscreen mode.
    *
    * @method leaveFullScreen
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean} params - Can be <b>null</b>
     */

    Component_LayoutSceneBehavior.prototype.leaveFullScreen = function() {
      gs.Graphics.leaveFullscreen();
      return GameManager.settings.fullScreen = Graphics.isFullscreen();
    };


    /**
    * Action method which toggles between window and fullscreen mode.
    *
    * @method toggleFullScreen
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - Can be <b>null</b>
     */

    Component_LayoutSceneBehavior.prototype.toggleFullScreen = function(sender, params) {
      if (gs.Graphics.isFullscreen()) {
        gs.Graphics.leaveFullscreen();
      } else {
        gs.Graphics.enterFullscreen();
      }
      return GameManager.settings.fullScreen = gs.Graphics.isFullscreen();
    };


    /**
    * Action method which plays the specified sound.
    *
    * @method playSound
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - The sound to play.
     */

    Component_LayoutSceneBehavior.prototype.playSound = function(sender, params) {
      AudioManager.loadSound(params);
      return AudioManager.playSound(params);
    };


    /**
    * Action method which plays the specified voice.
    *
    * @method playVoice
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - The voice to play.
     */

    Component_LayoutSceneBehavior.prototype.playVoice = function(sender, params) {
      AudioManager.loadSound(params);
      return AudioManager.playVoice(params);
    };


    /**
    * Action method which turns voice on or off.
    *
    * @method turnOnOffVoice
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - If <b>true</b> voice will be turned on. Otherwise it will be turned off. Can also be a binding-expression.
     */

    Component_LayoutSceneBehavior.prototype.turnOnOffVoice = function(sender, state) {
      if (ui.Component_FormulaHandler.fieldValue(sender, state)) {
        return this.turnOnVoice();
      } else {
        return this.turnOffVoice();
      }
    };


    /**
    * Action method which turns music on or off.
    *
    * @method turnOnOffMusic
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - If <b>true</b> music will be turned on. Otherwise it will be turned off. Can also be a binding-expression.
     */

    Component_LayoutSceneBehavior.prototype.turnOnOffMusic = function(sender, state) {
      if (ui.Component_FormulaHandler.fieldValue(sender, state)) {
        return this.turnOnMusic();
      } else {
        return this.turnOffMusic();
      }
    };


    /**
    * Action method which turns sound on or off.
    *
    * @method turnOnOffSound
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - If <b>true</b> sound will be turned on. Otherwise it will be turned off. Can also be a binding-expression.
     */

    Component_LayoutSceneBehavior.prototype.turnOnOffSound = function(sender, state) {
      if (ui.Component_FormulaHandler.fieldValue(sender, state)) {
        return this.turnOnSound();
      } else {
        return this.turnOffSound();
      }
    };


    /**
    * Action method which turns off voice.
    *
    * @method turnOffVoice
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.turnOffVoice = function() {
      return AudioManager.stopAllVoices();
    };


    /**
    * Action method which turns off music.
    *
    * @method turnOffMusic
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.turnOffMusic = function() {
      return AudioManager.stopMusic();
    };


    /**
    * Action method which turns off sound.
    *
    * @method turnOffSound
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.turnOffSound = function() {
      return AudioManager.stopAllSounds();
    };


    /**
    * Action method which turns on voice.
    *
    * @method turnOnVoice
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.turnOnVoice = function() {};


    /**
    * Action method which turns on sound.
    *
    * @method turnOnSound
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.turnOnSound = function() {};


    /**
    * Action method which turns on music.
    *
    * @method turnOnMusic
    * @param {gs.Object_Base} sender - The sender object.
    * @param {boolean|string} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.turnOnMusic = function() {
      return AudioManager.resumeMusic();
    };


    /**
    * Action method which selects the specified language.
    *
    * @method selectLanguage
    * @param {gs.Object_Base} sender - The sender object.
    * @param {number|string} params - Index of the language to set. Can be a binding-expression.
     */

    Component_LayoutSceneBehavior.prototype.selectLanguage = function(sender, params) {
      var language;
      language = LanguageManager.languages[ui.Component_FormulaHandler.fieldValue(sender, params)];
      return LanguageManager.selectLanguage(language);
    };


    /**
    * Action method which resets global data storage.
    *
    * @method resetGlobalData
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.resetGlobalData = function(sender) {
      return GameManager.resetGlobalData();
    };


    /**
    * Action method which saves game settings.
    *
    * @method saveSettings
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.saveSettings = function(sender) {
      return GameManager.saveSettings();
    };


    /**
    * Action method which prepares the game for saving by taking a snapshot of the current game state
    * and storing it in GameManager.saveGame.
    *
    * @method prepareSaveGame
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.prepareSaveGame = function(sender, params) {
      return GameManager.prepareSaveGame(params != null ? params.snapshot : void 0);
    };


    /**
    * Action method which saves the current game at the specified save slot.
    *
    * @method saveGame
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Contains the slot-index where the game should be saved.
    * <ul>
    * <li>params.slot - The slot-index where the game should be saved. Can be a binding-expression.</li>
    * </ul>
     */

    Component_LayoutSceneBehavior.prototype.saveGame = function(sender, params) {
      return GameManager.save(ui.Component_FormulaHandler.fieldValue(sender, params.slot));
    };


    /**
    * Action method which loads the game from the specified save slot.
    *
    * @method loadGame
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Contains the slot-index where the game should be loaded from.
    * <ul>
    * <li>params.slot - The slot-index where the game should be loaded from. Can be a binding-expression.</li>
    * </ul>
     */

    Component_LayoutSceneBehavior.prototype.loadGame = function(sender, params) {
      GameManager.tempSettings.skip = false;
      return GameManager.load(ui.Component_FormulaHandler.fieldValue(sender, params.slot));
    };


    /**
    * Action method which starts a new game.
    *
    * @method newGame
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Can be <b>null</b>
     */

    Component_LayoutSceneBehavior.prototype.newGame = function(sender, params) {
      var scene;
      AudioManager.stopAllMusic(30);
      GameManager.newGame();
      scene = new vn.Object_Scene();
      SceneManager.clear();
      return SceneManager.switchTo(scene);
    };


    /**
    * Action method which exists the current game. It doesn't change the scene and
    * should be called before switching back to the title screen or main menu.
    *
    * @method exitGame
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Can be <b>null</b>
     */

    Component_LayoutSceneBehavior.prototype.exitGame = function(sender, params) {
      return GameManager.exitGame();
    };


    /**
    * Action method which switches to another scene.
    *
    * @method switchScene
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Contains the class name of the scene to switch to.
    * <ul>
    * <li>params.name - The class-name of the scene to switch to. The class must be defined in vn-namespace.</li>
    * </ul>
     */

    Component_LayoutSceneBehavior.prototype.switchScene = function(sender, params) {
      var f;
      f = (function(_this) {
        return function() {
          var scene;
          if (params.clear) {
            SceneManager.clear();
          }
          scene = new vn[params.name]();
          return SceneManager.switchTo(scene, params.savePrevious);
        };
      })(this);
      if (!params.savePrevious) {
        return this.layout.ui.disappear((function(_this) {
          return function(e) {
            return f();
          };
        })(this));
      } else {
        return f();
      }
    };


    /**
    * Action method which switches to another game scene.
    *
    * @method switchGameScene
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Contains the UID of the scene to switch to.
    * <ul>
    * <li>params.uid - The UID of the scene to switch to.</li>
    * </ul>
     */

    Component_LayoutSceneBehavior.prototype.switchGameScene = function(sender, params) {
      var f;
      f = (function(_this) {
        return function() {
          var newScene, sceneData, sceneDocument, sceneDocuments, uid;
          if (params.clear) {
            SceneManager.clear();
          }
          uid = params.uid;
          if (params.name) {
            sceneDocuments = DataManager.getDocumentsByType("vn.scene");
            sceneDocument = sceneDocuments.first(function(d) {
              return d.items.name === params.name;
            });
            if (sceneDocument) {
              uid = sceneDocument.uid;
            }
          }
          sceneData = {
            uid: uid,
            pictures: [],
            texts: []
          };
          GameManager.sceneData = sceneData;
          newScene = new vn.Object_Scene();
          newScene.sceneData = sceneData;
          return SceneManager.switchTo(newScene, params.savePrevious);
        };
      })(this);
      if (!params.savePrevious) {
        return (this.layout || this.object.layout).ui.disappear((function(_this) {
          return function(e) {
            return f();
          };
        })(this));
      } else {
        return f();
      }
    };


    /**
    * Action method which switches to another layout.
    *
    * @method switchLayout
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Contains the name of the layout to switch to.
    * <ul>
    * <li>params.name - The name of the layout to switch to.</li>
    * <li>params.savePrevious - Indicates if the current layout should not be erased but paused and hidden instead so
    * that it can be restored using <i>returnToPrevious</i> action.</li>
    * <li>params.dataFields - Defines the data of "$dataFields" binding-expression variable. Can be a binding-expression
    * or a direct object. Optional.</li>
    * </ul>
     */

    Component_LayoutSceneBehavior.prototype.switchLayout = function(sender, layout) {
      var f;
      f = (function(_this) {
        return function() {
          var dataFields, i, len, ref, scene, senderField;
          Graphics.freeze();
          if (layout.clear) {
            SceneManager.clear();
          }
          scene = new gs.Object_Layout(layout.name);
          dataFields = sender.dataFields;
          if (typeof layout.dataFields === "string") {
            dataFields = ui.Component_FormulaHandler.fieldValue(sender, layout.dataFields);
          } else if (layout.dataFields != null) {
            dataFields = layout.dataFields;
          }
          scene.dataFields = dataFields;
          scene.controllers = layout.controllers;
          if (layout.senderData != null) {
            ref = layout.senderData;
            for (i = 0, len = ref.length; i < len; i++) {
              senderField = ref[i];
              scene[senderField] = sender[senderField];
            }
          }
          return SceneManager.switchTo(scene, layout.savePrevious, layout.stack);
        };
      })(this);
      if (!layout.savePrevious) {
        return (this.layout || this.object.layout).ui.disappear((function(_this) {
          return function(e) {
            return f();
          };
        })(this));
      } else {
        return f();
      }
    };


    /**
    * Action method which returns to previous layout. (If savePrevious was set to <b>true</b> on switchLayout.).
    *
    * @method previousLayout
    * @param {gs.Object_Base} sender - The sender object.
    * @param {Object} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.previousLayout = function(sender) {
      return SceneManager.returnToPrevious();
    };


    /**
    * Action method which disposes the specified control.
    *
    * @method disposeControl
    * @param {gs.Object_Base} sender - The sender object.
    * @param {string} params - The ID of the control to dispose. Can be a binding-expression.
     */

    Component_LayoutSceneBehavior.prototype.disposeControl = function(sender, id) {
      var control;
      control = this.objectManager.objectById(ui.Component_FormulaHandler.fieldValue(sender, id));
      return control != null ? control.ui.disappear(function(sender) {
        return sender.dispose();
      }) : void 0;
    };


    /**
    * Action method which creates a new control from the specified descriptor.
    *
    * @method createControl
    * @param {gs.Object_Base} sender - The sender object.
    * @param {string} params - Contains the descriptor and other data needed to construct the control.
    * <ul>
    * <li>params.descriptor - The control' descriptor. Can be a direct descriptor definition or a template name</li>
    * <li>params.parent - A binding-expression which returns the control's parent.</li>
    * <li>params.senderData - An object containing additional data merged into the control object.</li>
    * </ul>
     */

    Component_LayoutSceneBehavior.prototype.createControl = function(sender, data) {
      var control, descriptor, fieldName, i, len, parent, ref;
      if (typeof data.descriptor === "string") {
        descriptor = ui.UIManager.customTypes[data.descriptor];
      } else {
        descriptor = data.descriptor;
      }
      parent = ui.Component_FormulaHandler.fieldValue(sender, data.parent);
      control = ui.UiFactory._createFromDescriptor(descriptor, parent != null ? parent : this.object.layout || this.object);
      if (data.senderData != null) {
        ref = data.senderData;
        for (i = 0, len = ref.length; i < len; i++) {
          fieldName = ref[i];
          control[fieldName] = sender[fieldName];
        }
      }
      control.ui.prepare();
      control.ui.appear();
      return control;
    };


    /**
    * Action method which quits the game.
    *
    * @method quitGame
    * @param {gs.Object_Base} sender - The sender object.
    * @param {string} params - Can be <b>null</b>.
     */

    Component_LayoutSceneBehavior.prototype.quitGame = function(sender, data) {
      return SceneManager.switchTo(null);
    };

    return Component_LayoutSceneBehavior;

  })(gs.Component_SceneBehavior);

  gs.Component_LayoutSceneBehavior = Component_LayoutSceneBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_GameSceneBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_GameSceneBehavior = (function(superClass) {
    extend(Component_GameSceneBehavior, superClass);


    /**
    * Defines the behavior of visual novel game scene.
    *
    * @module vn
    * @class Component_GameSceneBehavior
    * @extends gs.Component_LayoutSceneBehavior
    * @memberof vn
     */

    function Component_GameSceneBehavior() {
      Component_GameSceneBehavior.__super__.constructor.call(this);
      this.onAutoCommonEventStart = (function(_this) {
        return function() {
          _this.object.removeComponent(_this.object.interpreter);
          return _this.object.interpreter.stop();
        };
      })(this);
      this.onAutoCommonEventFinish = (function(_this) {
        return function() {
          if (!_this.object.components.contains(_this.object.interpreter)) {
            _this.object.addComponent(_this.object.interpreter);
          }
          return _this.object.interpreter.resume();
        };
      })(this);
      this.resourceContext = null;
      this.objectDomain = "";
    }


    /**
    * Initializes the scene.
    *
    * @method initialize
     */

    Component_GameSceneBehavior.prototype.initialize = function() {
      var ref, saveGame, sceneUid, sprite;
      if (SceneManager.previousScenes.length === 0) {
        gs.GlobalEventManager.clearExcept(this.object.commonEventContainer.subObjects);
      }
      this.resourceContext = ResourceManager.createContext();
      ResourceManager.context = this.resourceContext;
      Graphics.freeze();
      saveGame = GameManager.loadedSaveGame;
      sceneUid = null;
      if (saveGame) {
        sceneUid = saveGame.sceneUid;
        this.object.sceneData = saveGame.data;
      } else {
        sceneUid = ((ref = $PARAMS.preview) != null ? ref.scene.uid : void 0) || this.object.sceneData.uid || RecordManager.system.startInfo.scene.uid;
      }
      this.object.sceneDocument = DataManager.getDocument(sceneUid);
      if (this.object.sceneDocument && this.object.sceneDocument.items.type === "vn.scene") {
        this.object.chapter = DataManager.getDocument(this.object.sceneDocument.items.chapterUid);
        this.object.currentCharacter = {
          "name": ""
        };
        if (!GameManager.initialized) {
          GameManager.initialize();
        }
        GameManager.preloadCommonEvents();
        LanguageManager.loadBundles();
      } else {
        sprite = new gs.Sprite();
        sprite.bitmap = new gs.Bitmap(Graphics.width, 50);
        sprite.bitmap.drawText(0, 0, Graphics.width, 50, "No Start Scene selected", 1, 0);
        sprite.srcRect = new gs.Rect(0, 0, Graphics.width, 50);
        sprite.y = (Graphics.height - 50) / 2;
        sprite.z = 10000;
      }
      return this.setupScreen();
    };


    /**
    * Disposes the scene.
    *
    * @method dispose
     */

    Component_GameSceneBehavior.prototype.dispose = function() {
      var event, j, len, ref;
      ResourceManager.context = this.resourceContext;
      this.object.removeObject(this.object.commonEventContainer);
      this.show(false);
      ref = GameManager.commonEvents;
      for (j = 0, len = ref.length; j < len; j++) {
        event = ref[j];
        if (event) {
          event.events.offByOwner("start", this.object);
          event.events.offByOwner("finish", this.object);
        }
      }
      if (this.object.video) {
        this.object.video.dispose();
        this.object.video.onEnded();
      }
      return Component_GameSceneBehavior.__super__.dispose.call(this);
    };

    Component_GameSceneBehavior.prototype.changePictureDomain = function(domain) {
      this.object.pictureContainer.behavior.changeDomain(domain);
      return this.object.pictures = this.object.pictureContainer.subObjects;
    };

    Component_GameSceneBehavior.prototype.changeTextDomain = function(domain) {
      this.object.textContainer.behavior.changeDomain(domain);
      return this.object.texts = this.object.textContainer.subObjects;
    };

    Component_GameSceneBehavior.prototype.changeVideoDomain = function(domain) {
      this.object.videoContainer.behavior.changeDomain(domain);
      return this.object.videos = this.object.videoContainer.subObjects;
    };

    Component_GameSceneBehavior.prototype.changeHotspotDomain = function(domain) {
      this.object.hotspotContainer.behavior.changeDomain(domain);
      return this.object.hotspots = this.object.hotspotContainer.subObjects;
    };

    Component_GameSceneBehavior.prototype.changeMessageAreaDomain = function(domain) {
      this.object.messageAreaContainer.behavior.changeDomain(domain);
      return this.object.messageAreas = this.object.messageAreaContainer.subObjects;
    };


    /**
    * Shows/Hides the current scene. A hidden scene is no longer shown and executed
    * but all objects and data is still there and be shown again anytime.
    *
    * @method show
    * @param {boolean} visible - Indicates if the scene should be shown or hidden.
     */

    Component_GameSceneBehavior.prototype.show = function(visible) {
      var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7;
      if (visible) {
        this.object.viewport = GameManager.sceneViewport;
      }
      window.$dataFields = this.dataFields;
      this.object.visible = visible;
      if ((ref = this.object.layout) != null) {
        ref.update();
      }
      this.object.pictureContainer.behavior.setVisible(visible);
      this.object.hotspotContainer.behavior.setVisible(visible);
      this.object.textContainer.behavior.setVisible(visible);
      this.object.videoContainer.behavior.setVisible(visible);
      this.object.messageAreaContainer.behavior.setVisible(visible);
      this.object.viewportContainer.behavior.setVisible(visible);
      this.object.characterContainer.behavior.setVisible(visible);
      this.object.backgroundContainer.behavior.setVisible(visible);
      if ((ref1 = this.viewport) != null) {
        ref1.visible = visible;
      }
      if ((ref2 = this.object.choiceWindow) != null) {
        ref2.visible = visible;
      }
      if ((ref3 = this.object.inputNumberBox) != null) {
        ref3.visible = visible;
      }
      if ((ref4 = this.object.inputTextBox) != null) {
        ref4.visible = visible;
      }
      if ((ref5 = this.object.inputTextBox) != null) {
        ref5.update();
      }
      if ((ref6 = this.object.inputNumberBox) != null) {
        ref6.update();
      }
      if ((ref7 = this.object.choiceWindow) != null) {
        ref7.update();
      }
      GameManager.tempSettings.skip = false;
      return this.setupCommonEvents();
    };


    /**
    * Sets up common event handling.
    *
    * @method setupCommonEvents
     */

    Component_GameSceneBehavior.prototype.setupCommonEvents = function() {
      var commonEvents, event, i, j, k, len, len1, ref, ref1, ref2, ref3;
      commonEvents = (ref = this.object.sceneData) != null ? ref.commonEvents : void 0;
      if (commonEvents) {
        for (i = j = 0, len = commonEvents.length; j < len; i = ++j) {
          event = commonEvents[i];
          if (event && this.object.commonEventContainer.subObjects.indexOf(event) === -1) {
            this.object.commonEventContainer.setObject(event, i);
            event.behavior.setupEventHandlers();
            if ((ref1 = event.interpreter) != null ? ref1.isRunning : void 0) {
              event.events.emit("start", event);
            }
          }
        }
      } else {
        ref2 = GameManager.commonEvents;
        for (i = k = 0, len1 = ref2.length; k < len1; i = ++k) {
          event = ref2[i];
          if (event && (event.record.startCondition === 1 || event.record.parallel) && this.object.commonEventContainer.subObjects.indexOf(event) === -1) {
            this.object.commonEventContainer.setObject(event, i);
            event.events.offByOwner("start", this.object);
            event.events.offByOwner("finish", this.object);
            if (!event.record.parallel) {
              event.events.on("start", gs.CallBack("onAutoCommonEventStart", this), null, this.object);
              event.events.on("finish", gs.CallBack("onAutoCommonEventFinish", this), null, this.object);
            }
            if ((ref3 = event.interpreter) != null ? ref3.isRunning : void 0) {
              event.events.emit("start", event);
            }
          }
        }
      }
      return null;
    };


    /**
    * Sets up main interpreter.
    *
    * @method setupInterpreter
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupInterpreter = function() {
      this.object.commands = this.object.sceneDocument.items.commands;
      if (this.object.sceneData.interpreter) {
        this.object.removeComponent(this.object.interpreter);
        this.object.interpreter = this.object.sceneData.interpreter;
        this.object.addComponent(this.object.interpreter);
        this.object.interpreter.context.set(this.object.sceneDocument.uid, this.object);
        return this.object.interpreter.object = this.object;
      } else {
        this.object.interpreter.setup();
        this.object.interpreter.context.set(this.object.sceneDocument.uid, this.object);
        return this.object.interpreter.start();
      }
    };


    /**
    * Sets up characters and restores them from loaded save game if necessary.
    *
    * @method setupCharacters
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupCharacters = function() {
      var c, i, j, len, ref;
      if (this.object.sceneData.characters != null) {
        ref = this.object.sceneData.characters;
        for (i = j = 0, len = ref.length; j < len; i = ++j) {
          c = ref[i];
          this.object.characterContainer.setObject(c, i);
        }
      }
      return this.object.currentCharacter = this.object.sceneData.currentCharacter || {
        name: ""
      };
    };


    /**
    * Sets up viewports and restores them from loaded save game if necessary.
    *
    * @method setupViewports
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupViewports = function() {
      var i, j, len, ref, ref1, results, viewport, viewports;
      viewports = (ref = (ref1 = this.object.sceneData) != null ? ref1.viewports : void 0) != null ? ref : [];
      results = [];
      for (i = j = 0, len = viewports.length; j < len; i = ++j) {
        viewport = viewports[i];
        if (viewport) {
          results.push(this.object.viewportContainer.setObject(viewport, i));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Sets up backgrounds and restores them from loaded save game if necessary.
    *
    * @method setupBackgrounds
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupBackgrounds = function() {
      var b, backgrounds, i, j, len, ref, ref1, results;
      backgrounds = (ref = (ref1 = this.object.sceneData) != null ? ref1.backgrounds : void 0) != null ? ref : [];
      results = [];
      for (i = j = 0, len = backgrounds.length; j < len; i = ++j) {
        b = backgrounds[i];
        results.push(this.object.backgroundContainer.setObject(b, i));
      }
      return results;
    };


    /**
    * Sets up pictures and restores them from loaded save game if necessary.
    *
    * @method setupPictures
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupPictures = function() {
      var domain, i, path, picture, pictures, ref, ref1, results;
      pictures = (ref = (ref1 = this.object.sceneData) != null ? ref1.pictures : void 0) != null ? ref : {};
      results = [];
      for (domain in pictures) {
        this.object.pictureContainer.behavior.changeDomain(domain);
        if (pictures[domain]) {
          results.push((function() {
            var j, len, ref2, results1;
            ref2 = pictures[domain];
            results1 = [];
            for (i = j = 0, len = ref2.length; j < len; i = ++j) {
              picture = ref2[i];
              this.object.pictureContainer.setObject(picture, i);
              if (picture != null ? picture.image : void 0) {
                path = "Graphics/Pictures/" + picture.image;
                results1.push(this.resourceContext.add(path, ResourceManager.resourcesByPath[path]));
              } else {
                results1.push(void 0);
              }
            }
            return results1;
          }).call(this));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Sets up texts and restores them from loaded save game if necessary.
    *
    * @method setupTexts
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupTexts = function() {
      var domain, i, ref, ref1, results, text, texts;
      texts = (ref = (ref1 = this.object.sceneData) != null ? ref1.texts : void 0) != null ? ref : {};
      results = [];
      for (domain in texts) {
        this.object.textContainer.behavior.changeDomain(domain);
        if (texts[domain]) {
          results.push((function() {
            var j, len, ref2, results1;
            ref2 = texts[domain];
            results1 = [];
            for (i = j = 0, len = ref2.length; j < len; i = ++j) {
              text = ref2[i];
              results1.push(this.object.textContainer.setObject(text, i));
            }
            return results1;
          }).call(this));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Sets up videos and restores them from loaded save game if necessary.
    *
    * @method setupVideos
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupVideos = function() {
      var domain, i, path, ref, ref1, results, video, videos;
      videos = (ref = (ref1 = this.object.sceneData) != null ? ref1.videos : void 0) != null ? ref : {};
      results = [];
      for (domain in videos) {
        this.object.videoContainer.behavior.changeDomain(domain);
        if (videos[domain]) {
          results.push((function() {
            var j, len, ref2, results1;
            ref2 = videos[domain];
            results1 = [];
            for (i = j = 0, len = ref2.length; j < len; i = ++j) {
              video = ref2[i];
              if (video) {
                path = "Movies/" + video.video;
                this.resourceContext.add(path, ResourceManager.resourcesByPath[path]);
                video.visible = true;
                video.update();
              }
              results1.push(this.object.videoContainer.setObject(video, i));
            }
            return results1;
          }).call(this));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Sets up hotspots and restores them from loaded save game if necessary.
    *
    * @method setupHotspots
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupHotspots = function() {
      var domain, hotspot, hotspots, i, ref, ref1, results;
      hotspots = (ref = (ref1 = this.object.sceneData) != null ? ref1.hotspots : void 0) != null ? ref : {};
      results = [];
      for (domain in hotspots) {
        this.object.hotspotContainer.behavior.changeDomain(domain);
        if (hotspots[domain]) {
          results.push((function() {
            var j, len, ref2, results1;
            ref2 = hotspots[domain];
            results1 = [];
            for (i = j = 0, len = ref2.length; j < len; i = ++j) {
              hotspot = ref2[i];
              results1.push(this.object.hotspotContainer.setObject(hotspot, i));
            }
            return results1;
          }).call(this));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Sets up layout.
    *
    * @method setupLayout
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupLayout = function() {
      var advVisible, ref, ref1;
      this.dataFields = ui.UIManager.dataSources[ui.UiFactory.layouts.gameLayout.dataSource || "default"]();
      this.dataFields.scene = this.object;
      window.$dataFields = this.dataFields;
      advVisible = this.object.messageMode === vn.MessageMode.ADV;
      this.object.layout = ui.UiFactory.createFromDescriptor(ui.UiFactory.layouts.gameLayout, this.object);
      this.object.layout.visible = advVisible;
      $gameMessage_message.visible = advVisible;
      this.object.layout.ui.prepare();
      this.object.choices = ((ref = this.object.sceneData) != null ? ref.choices : void 0) || this.object.choices;
      if (((ref1 = this.object.choices) != null ? ref1.length : void 0) > 0) {
        this.showChoices(gs.CallBack("onChoiceAccept", this.object.interpreter, {
          pointer: this.object.interpreter.pointer,
          params: this.params
        }));
      }
      if (this.object.interpreter.waitingFor.inputNumber) {
        this.showInputNumber(GameManager.tempFields.digits, gs.CallBack("onInputNumberFinish", this.object.interpreter, this.object.interpreter));
      }
      if (this.object.interpreter.waitingFor.inputText) {
        return this.showInputText(GameManager.tempFields.letters, gs.CallBack("onInputTextFinish", this.object.interpreter, this.object.interpreter));
      }
    };


    /**
    * Sets up the main viewport / screen viewport.
    *
    * @method setupMainViewport
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupMainViewport = function() {
      if (!this.object.sceneData.viewport) {
        GameManager.sceneViewport.removeComponent(GameManager.sceneViewport.visual);
        GameManager.sceneViewport.dispose();
        GameManager.sceneViewport = new gs.Object_Viewport(GameManager.sceneViewport.visual.viewport);
        this.viewport = GameManager.sceneViewport.visual.viewport;
        return this.object.viewport = GameManager.sceneViewport;
      } else {
        GameManager.sceneViewport.dispose();
        GameManager.sceneViewport = this.object.sceneData.viewport;
        this.object.viewport = this.object.sceneData.viewport;
        this.viewport = this.object.viewport.visual.viewport;
        return this.viewport.viewport = Graphics.viewport;
      }
    };


    /**
    * Sets up screen.
    *
    * @method setupScreen
    * @protected
     */

    Component_GameSceneBehavior.prototype.setupScreen = function() {
      if (this.object.sceneData.screen) {
        return this.object.viewport.restore(this.object.sceneData.screen);
      }
    };


    /**
    * Restores main interpreter from loaded save game.
    *
    * @method restoreInterpreter
    * @protected
     */

    Component_GameSceneBehavior.prototype.restoreInterpreter = function() {
      if (this.object.sceneData.interpreter) {
        return this.object.interpreter.restore();
      }
    };


    /**
    * Restores message box from loaded save game.
    *
    * @method restoreMessageBox
    * @protected
     */

    Component_GameSceneBehavior.prototype.restoreMessageBox = function() {
      var c, j, k, len, len1, message, messageBox, messageBoxes, messageObject, ref, ref1, results;
      messageBoxes = (ref = this.object.sceneData) != null ? ref.messageBoxes : void 0;
      if (messageBoxes) {
        results = [];
        for (j = 0, len = messageBoxes.length; j < len; j++) {
          messageBox = messageBoxes[j];
          messageObject = gs.ObjectManager.current.objectById(messageBox.id);
          messageObject.visible = messageBox.visible;
          if (messageBox.message) {
            messageBox.message.textRenderer.disposeEventHandlers();
            message = gs.ObjectManager.current.objectById(messageBox.message.id);
            message.textRenderer.dispose();
            Object.mixin(message, messageBox.message, ui.Object_Message.objectCodecBlackList.concat(["origin"]));
            ref1 = message.components;
            for (k = 0, len1 = ref1.length; k < len1; k++) {
              c = ref1[k];
              c.object = message;
            }
            results.push(message.textRenderer.setupEventHandlers());
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };


    /**
    * Restores message from loaded save game.
    *
    * @method restoreMessages
    * @protected
     */

    Component_GameSceneBehavior.prototype.restoreMessages = function() {
      var area, c, domain, i, message, messageArea, messageAreas, messageLayout, ref, results;
      if ((ref = this.object.sceneData) != null ? ref.messageAreas : void 0) {
        results = [];
        for (domain in this.object.sceneData.messageAreas) {
          this.object.messageAreaContainer.behavior.changeDomain(domain);
          messageAreas = this.object.sceneData.messageAreas;
          if (messageAreas[domain]) {
            results.push((function() {
              var j, k, len, len1, ref1, ref2, results1;
              ref1 = messageAreas[domain];
              results1 = [];
              for (i = j = 0, len = ref1.length; j < len; i = ++j) {
                area = ref1[i];
                if (area) {
                  messageArea = new gs.Object_MessageArea();
                  messageLayout = ui.UIManager.createControlFromDescriptor({
                    type: "ui.CustomGameMessage",
                    id: "customGameMessage_" + i,
                    params: {
                      id: "customGameMessage_" + i
                    }
                  }, messageArea);
                  message = gs.ObjectManager.current.objectById("customGameMessage_" + i + "_message");
                  area.message.textRenderer.disposeEventHandlers();
                  message.textRenderer.dispose();
                  Object.mixin(message, area.message);
                  ref2 = message.components;
                  for (k = 0, len1 = ref2.length; k < len1; k++) {
                    c = ref2[k];
                    c.object = message;
                  }
                  messageLayout.dstRect.x = area.layout.dstRect.x;
                  messageLayout.dstRect.y = area.layout.dstRect.y;
                  messageLayout.dstRect.width = area.layout.dstRect.width;
                  messageLayout.dstRect.height = area.layout.dstRect.height;
                  messageLayout.needsUpdate = true;
                  message.textRenderer.setupEventHandlers();
                  messageLayout.update();
                  messageArea.message = message;
                  messageArea.layout = messageLayout;
                  messageArea.addObject(messageLayout);
                  results1.push(this.object.messageAreaContainer.setObject(messageArea, i));
                } else {
                  results1.push(void 0);
                }
              }
              return results1;
            }).call(this));
          } else {
            results.push(void 0);
          }
        }
        return results;
      }
    };


    /**
    * Restores audio-playback from loaded save game.
    *
    * @method restoreAudioPlayback
    * @protected
     */

    Component_GameSceneBehavior.prototype.restoreAudioPlayback = function() {
      var b, j, len, ref;
      if (this.object.sceneData.audio) {
        ref = this.object.sceneData.audio.audioBuffers;
        for (j = 0, len = ref.length; j < len; j++) {
          b = ref[j];
          AudioManager.audioBuffers.push(b);
        }
        AudioManager.audioBuffersByLayer = this.object.sceneData.audio.audioBuffersByLayer;
        AudioManager.audioLayers = this.object.sceneData.audio.audioLayers;
        return AudioManager.soundReferences = this.object.sceneData.audio.soundReferences;
      }
    };


    /**
    * Restores the scene objects from the current loaded save-game. If no save-game is
    * present in GameManager.loadedSaveGame, nothing will happen.
    *
    * @method restoreScene
    * @protected
     */

    Component_GameSceneBehavior.prototype.restoreScene = function() {
      var c, context, j, len, ref, ref1, saveGame;
      saveGame = GameManager.loadedSaveGame;
      if (saveGame) {
        context = new gs.ObjectCodecContext([Graphics.viewport, this.object, this], saveGame.encodedObjectStore, null);
        saveGame.data = gs.ObjectCodec.decode(saveGame.data, context);
        ref = saveGame.data.characterNames;
        for (j = 0, len = ref.length; j < len; j++) {
          c = ref[j];
          if (c) {
            if ((ref1 = RecordManager.characters[c.index]) != null) {
              ref1.name = c.name;
            }
          }
        }
        GameManager.restore(saveGame);
        gs.ObjectCodec.onRestore(saveGame.data, context);
        this.resourceContext.fromDataBundle(saveGame.data.resourceContext, ResourceManager.resourcesByPath);
        this.object.sceneData = saveGame.data;
        return Graphics.frameCount = saveGame.data.frameCount;
      }
    };


    /**
    * Prepares all data for the scene and loads the necessary graphic and audio resources.
    *
    * @method prepareData
    * @abstract
     */

    Component_GameSceneBehavior.prototype.prepareData = function() {
      GameManager.scene = this.object;
      gs.ObjectManager.current = this.objectManager;
      this.object.sceneData.uid = this.object.sceneDocument.uid;
      if (!ResourceLoader.loadEventCommandsData(this.object.sceneDocument.items.commands)) {
        ResourceLoader.loadEventCommandsGraphics(this.object.sceneDocument.items.commands);
        GameManager.backlog = this.object.sceneData.backlog || GameManager.sceneData.backlog || [];
        ResourceLoader.loadSystemSounds();
        ResourceLoader.loadSystemGraphics();
        ResourceLoader.loadUiTypesGraphics(ui.UiFactory.customTypes);
        ResourceLoader.loadUiLayoutGraphics(ui.UiFactory.layouts.gameLayout);
        if (this.dataFields != null) {
          ResourceLoader.loadUiDataFieldsGraphics(this.dataFields);
        }
        $tempFields.choiceTimer = this.object.choiceTimer;
        return GameManager.variableStore.setup({
          id: this.object.sceneDocument.uid
        });
      }
    };


    /**
    * Prepares all visual game object for the scene.
    *
    * @method prepareVisual
     */

    Component_GameSceneBehavior.prototype.prepareVisual = function() {
      var ref;
      if (this.object.layout) {
        return;
      }
      if (GameManager.tempFields.isExitingGame) {
        GameManager.tempFields.isExitingGame = false;
        gs.GameNotifier.postResetSceneChange(this.object.sceneDocument.items.name);
      } else {
        gs.GameNotifier.postSceneChange(this.object.sceneDocument.items.name);
      }
      this.restoreScene();
      this.object.messageMode = (ref = this.object.sceneData.messageMode) != null ? ref : vn.MessageMode.ADV;
      this.setupMainViewport();
      this.setupViewports();
      this.setupCharacters();
      this.setupBackgrounds();
      this.setupPictures();
      this.setupTexts();
      this.setupVideos();
      this.setupHotspots();
      this.setupInterpreter();
      this.setupLayout();
      this.setupCommonEvents();
      this.restoreMessageBox();
      this.restoreInterpreter();
      this.restoreMessages();
      this.restoreAudioPlayback();
      this.show(true);
      this.object.sceneData = {};
      GameManager.sceneData = {};
      Graphics.update();
      return this.transition({
        duration: 0
      });
    };


    /**
    * Adds a new character to the scene.
    *
    * @method addCharacter
    * @param {vn.Object_Character} character - The character to add.
    * @param {boolean} noAnimation - Indicates if the character should be added immediately witout any appear-animation.
    * @param {Object} animationData - Contains the appear-animation data -> { animation, easing, duration }.
     */

    Component_GameSceneBehavior.prototype.addCharacter = function(character, noAnimation, animationData) {
      if (!noAnimation) {
        character.motionBlur.set(animationData.motionBlur);
        if (animationData.duration > 0) {
          if (!noAnimation) {
            character.animator.appear(character.dstRect.x, character.dstRect.y, animationData.animation, animationData.easing, animationData.duration);
          }
        }
      }
      character.viewport = this.viewport;
      character.visible = true;
      return this.object.characterContainer.addObject(character);
    };


    /**
    * Removes a character from the scene.
    *
    * @method removeCharacter
    * @param {vn.Object_Character} character - The character to remove.
    * @param {boolean} noAnimation - Indicates if the character should be disposed immediately witout any disapear-animation.
    * @param {Object} animationData - Contains the disappear-animation data -> { animation, easing, duration }.
     */

    Component_GameSceneBehavior.prototype.removeCharacter = function(character, noAnimation, animationData) {
      if (!noAnimation) {
        return character != null ? character.animator.disappear(animationData.animation, animationData.easing, animationData.duration, function(sender) {
          return sender.dispose();
        }) : void 0;
      } else {
        return character != null ? character.dispose() : void 0;
      }
    };


    /**
    * Resumes the current scene if it has been paused.
    *
    * @method resumeScene
     */

    Component_GameSceneBehavior.prototype.resumeScene = function() {
      var message;
      this.object.pictureContainer.active = true;
      this.object.characterContainer.active = true;
      this.object.backgroundContainer.active = true;
      this.object.textContainer.active = true;
      this.object.hotspotContainer.active = true;
      this.object.videoContainer.active = true;
      message = gs.ObjectManager.current.objectById("gameMessage_message");
      return message.active = true;
    };


    /**
    * Pauses the current scene. A paused scene will not continue, messages, pictures, etc. will
    * stop until the scene resumes.
    *
    * @method pauseScene
     */

    Component_GameSceneBehavior.prototype.pauseScene = function() {
      var message;
      this.object.pictureContainer.active = false;
      this.object.characterContainer.active = false;
      this.object.backgroundContainer.active = false;
      this.object.textContainer.active = false;
      this.object.hotspotContainer.active = false;
      this.object.videoContainer.active = false;
      message = gs.ObjectManager.current.objectById("gameMessage_message");
      return message.active = false;
    };


    /**
    * Changes the visibility of the entire game UI like the message boxes, etc. to allows
    * the player to see the entire scene. Useful for CGs, etc.
    *
    * @param {boolean} visible - If <b>true</b>, the game UI will be visible. Otherwise it will be hidden.
    * @method changeUIVisibility
     */

    Component_GameSceneBehavior.prototype.changeUIVisibility = function(visible) {
      this.uiVisible = visible;
      return this.object.layout.visible = visible;
    };


    /**
    * Shows input-text box to let the user enter a text.
    *
    * @param {number} letters - The max. number of letters the user can enter.
    * @param {gs.Callback} callback - A callback function called if the input-text box has been accepted by the user.
    * @method showInputText
     */

    Component_GameSceneBehavior.prototype.showInputText = function(letters, callback) {
      var ref;
      if ((ref = this.object.inputTextBox) != null) {
        ref.dispose();
      }
      this.object.inputTextBox = ui.UiFactory.createControlFromDescriptor(ui.UiFactory.customTypes["ui.InputTextBox"], this.object.layout);
      this.object.inputTextBox.ui.prepare();
      return this.object.inputTextBox.events.on("accept", callback);
    };


    /**
    * Shows input-number box to let the user enter a number.
    *
    * @param {number} digits - The max. number of digits the user can enter.
    * @param {gs.Callback} callback - A callback function called if the input-number box has been accepted by the user.
    * @method showInputNumber
     */

    Component_GameSceneBehavior.prototype.showInputNumber = function(digits, callback) {
      var ref;
      if ((ref = this.object.inputNumberBox) != null) {
        ref.dispose();
      }
      this.object.inputNumberBox = ui.UiFactory.createControlFromDescriptor(ui.UiFactory.customTypes["ui.InputNumberBox"], this.object.layout);
      this.object.inputNumberBox.ui.prepare();
      return this.object.inputNumberBox.events.on("accept", callback);
    };


    /**
    * Shows choices to let the user pick a choice.
    *
    * @param {Object[]} choices - An array of choices
    * @param {gs.Callback} callback - A callback function called if a choice has been picked by the user.
    * @method showChoices
     */

    Component_GameSceneBehavior.prototype.showChoices = function(callback) {
      var ref, useFreeLayout;
      useFreeLayout = this.object.choices.where(function(x) {
        return x.dstRect != null;
      }).length > 0;
      if ((ref = this.object.choiceWindow) != null) {
        ref.dispose();
      }
      if (useFreeLayout) {
        this.object.choiceWindow = ui.UiFactory.createControlFromDescriptor(ui.UiFactory.customTypes["ui.FreeChoiceBox"], this.object.layout);
      } else {
        this.object.choiceWindow = ui.UiFactory.createControlFromDescriptor(ui.UiFactory.customTypes["ui.ChoiceBox"], this.object.layout);
      }
      this.object.choiceWindow.events.on("selectionAccept", callback);
      return this.object.choiceWindow.ui.prepare();
    };


    /**
    * Changes the background of the scene.
    *
    * @method changeBackground
    * @param {Object} background - The background graphic object -> { name }
    * @param {boolean} noAnimation - Indicates if the background should be changed immediately witout any change-animation.
    * @param {Object} animation - The appear/disappear animation to use.
    * @param {Object} easing - The easing of the change animation.
    * @param {number} duration - The duration of the change in frames.
    * @param {number} ox - The x-origin of the background.
    * @param {number} oy - The y-origin of the background.
    * @param {number} layer - The background-layer to change.
    * @param {boolean} loopHorizontal - Indicates if the background should be looped horizontally.
    * @param {boolean} loopVertical - Indicates if the background should be looped vertically.
     */

    Component_GameSceneBehavior.prototype.changeBackground = function(background, noAnimation, animation, easing, duration, ox, oy, layer, loopHorizontal, loopVertical) {
      var object, otherObject, ref, ref1;
      if (background != null) {
        otherObject = this.object.backgrounds[layer];
        object = new vn.Object_Background();
        object.image = background.name;
        object.origin.x = ox;
        object.origin.y = oy;
        object.viewport = this.viewport;
        object.visual.looping.vertical = false;
        object.visual.looping.horizontal = false;
        object.update();
        this.object.backgroundContainer.setObject(object, layer);
        duration = duration != null ? duration : 30;
        if (otherObject != null) {
          otherObject.zIndex = layer;
        }
        if (otherObject != null) {
          if ((ref = otherObject.animator.otherObject) != null) {
            ref.dispose();
          }
        }
        if (duration === 0) {
          if (otherObject != null) {
            otherObject.dispose();
          }
          object.visual.looping.vertical = loopVertical;
          return object.visual.looping.horizontal = loopHorizontal;
        } else {
          if (noAnimation) {
            object.visual.looping.vertical = loopVertical;
            return object.visual.looping.horizontal = loopHorizontal;
          } else {
            object.animator.otherObject = otherObject;
            return object.animator.appear(0, 0, animation, easing, duration, (function(_this) {
              return function(sender) {
                var ref1;
                sender.update();
                if ((ref1 = sender.animator.otherObject) != null) {
                  ref1.dispose();
                }
                sender.animator.otherObject = null;
                sender.visual.looping.vertical = loopVertical;
                return sender.visual.looping.horizontal = loopHorizontal;
              };
            })(this));
          }
        }
      } else {
        return (ref1 = this.object.backgrounds[layer]) != null ? ref1.animator.hide(duration, easing, (function(_this) {
          return function() {
            _this.object.backgrounds[layer].dispose();
            return _this.object.backgrounds[layer] = null;
          };
        })(this)) : void 0;
      }
    };


    /**
    * Skips all viewport animations except the main viewport animation.
    *
    * @method skipViewports
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipViewports = function() {
      var component, j, k, len, len1, ref, viewport, viewports;
      viewports = this.object.viewportContainer.subObjects;
      for (j = 0, len = viewports.length; j < len; j++) {
        viewport = viewports[j];
        if (viewport) {
          ref = viewport.components;
          for (k = 0, len1 = ref.length; k < len1; k++) {
            component = ref[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      return null;
    };


    /**
    * Skips all picture animations.
    *
    * @method skipPictures
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipPictures = function() {
      var component, j, k, len, len1, picture, ref, ref1;
      ref = this.object.pictures;
      for (j = 0, len = ref.length; j < len; j++) {
        picture = ref[j];
        if (picture) {
          ref1 = picture.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      return null;
    };


    /**
    * Skips all text animations.
    *
    * @method skipTexts
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipTexts = function() {
      var component, j, k, len, len1, ref, ref1, text;
      ref = this.object.texts;
      for (j = 0, len = ref.length; j < len; j++) {
        text = ref[j];
        if (text) {
          ref1 = text.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      return null;
    };


    /**
    * Skips all video animations but not the video-playback itself.
    *
    * @method skipVideos
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipVideos = function() {
      var component, j, k, len, len1, ref, ref1, video;
      ref = this.object.videos;
      for (j = 0, len = ref.length; j < len; j++) {
        video = ref[j];
        if (video) {
          ref1 = video.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      return null;
    };


    /**
    * Skips all background animations.
    *
    * @method skipBackgrounds
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipBackgrounds = function() {
      var background, component, j, k, len, len1, ref, ref1;
      ref = this.object.backgrounds;
      for (j = 0, len = ref.length; j < len; j++) {
        background = ref[j];
        if (background) {
          ref1 = background.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      return null;
    };


    /**
    * Skips all character animations
    *
    * @method skipCharacters
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipCharacters = function() {
      var character, component, j, k, len, len1, ref, ref1;
      ref = this.object.characters;
      for (j = 0, len = ref.length; j < len; j++) {
        character = ref[j];
        if (character) {
          ref1 = character.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      return null;
    };


    /**
    * Skips the main viewport animation.
    *
    * @method skipMainViewport
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipMainViewport = function() {
      var component, j, len, ref;
      ref = this.object.viewport.components;
      for (j = 0, len = ref.length; j < len; j++) {
        component = ref[j];
        if (typeof component.skip === "function") {
          component.skip();
        }
      }
      return null;
    };


    /**
    * Skips all animations of all message boxes defined in MESSAGE_BOX_IDS ui constant.
    *
    * @method skipMessageBoxes
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipMessageBoxes = function() {
      var component, j, k, len, len1, messageBox, messageBoxId, ref, ref1;
      ref = gs.UIConstants.MESSAGE_BOX_IDS || ["messageBox", "nvlMessageBox"];
      for (j = 0, len = ref.length; j < len; j++) {
        messageBoxId = ref[j];
        messageBox = gs.ObjectManager.current.objectById(messageBoxId);
        if (messageBox.components) {
          ref1 = messageBox.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      return null;
    };


    /**
    * Skips all animations of all message areas.
    *
    * @method skipMessageAreas
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipMessageAreas = function() {
      var component, j, k, l, len, len1, len2, len3, m, messageArea, msg, ref, ref1, ref2, ref3;
      ref = this.object.messageAreas;
      for (j = 0, len = ref.length; j < len; j++) {
        messageArea = ref[j];
        if (messageArea != null ? messageArea.message : void 0) {
          ref1 = messageArea.message.components;
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            component = ref1[k];
            if (typeof component.skip === "function") {
              component.skip();
            }
          }
        }
      }
      msg = gs.ObjectManager.current.objectById("gameMessage_message");
      if (msg) {
        ref2 = msg.components;
        for (l = 0, len2 = ref2.length; l < len2; l++) {
          component = ref2[l];
          if (typeof component.skip === "function") {
            component.skip();
          }
        }
      }
      msg = gs.ObjectManager.current.objectById("nvlGameMessage_message");
      if (msg) {
        ref3 = msg.components;
        for (m = 0, len3 = ref3.length; m < len3; m++) {
          component = ref3[m];
          if (typeof component.skip === "function") {
            component.skip();
          }
        }
      }
      return null;
    };


    /**
    * Skips the scene interpreter timer.
    *
    * @method skipInterpreter
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipInterpreter = function() {
      if (this.object.interpreter.waitCounter > GameManager.tempSettings.skipTime) {
        this.object.interpreter.waitCounter = GameManager.tempSettings.skipTime;
        if (this.object.interpreter.waitCounter === 0) {
          return this.object.interpreter.isWaiting = false;
        }
      }
    };


    /**
    * Skips the interpreter timer of all common events.
    *
    * @method skipCommonEvents
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipCommonEvents = function() {
      var event, events, j, len, results;
      events = this.object.commonEventContainer.subObjects;
      results = [];
      for (j = 0, len = events.length; j < len; j++) {
        event = events[j];
        if ((event != null ? event.interpreter : void 0) && event.interpreter.waitCounter > GameManager.tempSettings.skipTime) {
          event.interpreter.waitCounter = GameManager.tempSettings.skipTime;
          if (event.interpreter.waitCounter === 0) {
            results.push(event.interpreter.isWaiting = false);
          } else {
            results.push(void 0);
          }
        } else {
          results.push(void 0);
        }
      }
      return results;
    };


    /**
    * Skips the scene's content.
    *
    * @method skipContent
    * @protected
     */

    Component_GameSceneBehavior.prototype.skipContent = function() {
      this.skipPictures();
      this.skipTexts();
      this.skipVideos();
      this.skipBackgrounds();
      this.skipCharacters();
      this.skipMainViewport();
      this.skipViewports();
      this.skipMessageBoxes();
      this.skipMessageAreas();
      this.skipInterpreter();
      return this.skipCommonEvents();
    };


    /**
    * Checks for the shortcut to hide/show the game UI. By default, this is the space-key. You
    * can override this method to change the shortcut.
    *
    * @method updateUIVisibilityShortcut
    * @protected
     */

    Component_GameSceneBehavior.prototype.updateUIVisibilityShortcut = function() {
      if (!this.uiVisible && (Input.trigger(Input.C) || Input.Mouse.buttonDown)) {
        this.changeUIVisibility(!this.uiVisible);
      }
      if (Input.trigger(Input.KEY_SPACE)) {
        return this.changeUIVisibility(!this.uiVisible);
      }
    };


    /**
    * Checks for the shortcut to exit the game. By default, this is the escape-key. You
    * can override this method to change the shortcut.
    *
    * @method updateQuitShortcut
    * @protected
     */

    Component_GameSceneBehavior.prototype.updateQuitShortcut = function() {
      if (Input.trigger(Input.KEY_ESCAPE)) {
        return gs.Application.exit();
      }
    };


    /**
    * Checks for the shortcut to open the settings menu. By default, this is the s-key. You
    * can override this method to change the shortcut.
    *
    * @method updateSettingsShortcut
    * @protected
     */

    Component_GameSceneBehavior.prototype.updateSettingsShortcut = function() {
      if (GameManager.tempSettings.menuAccess && Input.trigger(Input.X)) {
        return SceneManager.switchTo(new gs.Object_Layout("settingsMenuLayout"), true);
      }
    };


    /**
    * Checks for the shortcut to open the settings menu. By default, this is the control-key. You
    * can override this method to change the shortcut.
    *
    * @method updateSkipShortcut
    * @protected
     */

    Component_GameSceneBehavior.prototype.updateSkipShortcut = function() {
      if (this.object.settings.allowSkip) {
        if (Input.keys[Input.KEY_CONTROL] === 1) {
          return GameManager.tempSettings.skip = true;
        } else if (Input.keys[Input.KEY_CONTROL] === 2) {
          return GameManager.tempSettings.skip = false;
        }
      }
    };


    /**
    * Checks for default keyboard shortcuts e.g space-key to hide the UI, etc.
    *
    * @method updateShortcuts
    * @protected
     */

    Component_GameSceneBehavior.prototype.updateShortcuts = function() {
      this.updateSettingsShortcut();
      this.updateQuitShortcut();
      this.updateUIVisibilityShortcut();
      return this.updateSkipShortcut();
    };


    /**
    * Updates the full screen video played via Play Movie command.
    *
    * @method updateVideo
     */

    Component_GameSceneBehavior.prototype.updateVideo = function() {
      if (this.object.video != null) {
        this.object.video.update();
        if (this.object.settings.allowVideoSkip && (Input.trigger(Input.C) || Input.Mouse.buttons[Input.Mouse.LEFT] === 2)) {
          this.object.video.stop();
        }
        return Input.clear();
      }
    };


    /**
    * Updates skipping if enabled.
    *
    * @method updateSkipping
     */

    Component_GameSceneBehavior.prototype.updateSkipping = function() {
      if (!this.object.settings.allowSkip) {
        this.object.tempSettings.skip = false;
      }
      if (GameManager.tempSettings.skip) {
        return this.skipContent();
      }
    };


    /**
    * Updates the scene's content.
    *
    * @method updateContent
     */

    Component_GameSceneBehavior.prototype.updateContent = function() {
      GameManager.scene = this.object;
      Graphics.viewport.update();
      this.object.viewport.update();
      this.updateSkipping();
      this.updateVideo();
      this.updateShortcuts();
      return Component_GameSceneBehavior.__super__.updateContent.call(this);
    };

    return Component_GameSceneBehavior;

  })(gs.Component_LayoutSceneBehavior);

  vn.Component_GameSceneBehavior = Component_GameSceneBehavior;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_WebStartBehavior,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_WebStartBehavior = (function(superClass) {
    extend(Component_WebStartBehavior, superClass);


    /**
    * The web-start scene is used if the game has been loaded via mobile webbrowser. That web-start
    * scene lets the player tap on the screen to start the actual game which is necessary to make
    * audio-playback working because of browser-security.
    *
    * @module gs
    * @class Component_WebStartBehavior 
    * @extends gs.Component_LayoutSceneBehavior
    * @memberof gs
     */

    function Component_WebStartBehavior() {
      Component_WebStartBehavior.__super__.constructor.apply(this, arguments);
    }


    /**
    * Initializes the web-start scene. It just creates a full-screen
    * DIV layer with a touch event-handler to play a sound if tapped and then switch
    * to the language-menu / intro-scene to start the actual game.
    *
    * @method initialize
     */

    Component_WebStartBehavior.prototype.initialize = function() {
      Component_WebStartBehavior.__super__.initialize.apply(this, arguments);
      window.music = new Audio();
      window.music.src = gs.Application.getPlatformSpecificAudioFilePath("Audio/Sounds/choice_confirm_01");
      this.sound = ResourceManager.getAudioBuffer("Audio/Sounds/choice_confirm_01");
      this.button = jQuery("<div></div>");
      this.button.css("position", "absolute");
      this.button.css("left", "0px");
      this.button.css("top", "0px");
      this.button.width(Graphics.width);
      this.button.height(Graphics.height);
      this.button.css("background-color", "transparent");
      this.button.css("z-order", 999999);
      this.button.click((function(_this) {
        return function(e) {
          _this.sound.play();
          window.music.play();
          _this.button.remove();
          _this.button = null;
          return setTimeout(function() {
            return SceneManager.switchTo(new gs.Object_Layout("languageMenuLayout"));
          }, 450);
        };
      })(this));
      this.button[0].addEventListener("touchstart", (function(_this) {
        return function(e) {
          _this.sound.play();
          window.music.play();
          _this.button.remove();
          _this.button = null;
          SceneManager.switchTo(new gs.Object_Layout("languageMenuLayout"));
          return setTimeout(function() {
            window.music.pause();
            window.music = null;
            return SceneManager.switchTo(new gs.Object_Layout("languageMenuLayout"));
          }, 450);
        };
      })(this));
      return jQuery(document.body).append(this.button);
    };


    /**
    * Prepares all visual game objects for the scene.
    *
    * @method prepareVisual
     */

    Component_WebStartBehavior.prototype.prepareVisual = function() {
      return Component_WebStartBehavior.__super__.prepareVisual.apply(this, arguments);
    };


    /**
    * Prepares all data for the scene and loads the necessary graphic and audio resources.
    *
    * @method prepareData
     */

    Component_WebStartBehavior.prototype.prepareData = function() {
      return Component_WebStartBehavior.__super__.prepareData.apply(this, arguments);
    };


    /**
    * Update the scene's content. Here you can implement any kind of additional logic
    * you want.
    *
    * @method updateContent
     */

    Component_WebStartBehavior.prototype.updateContent = function() {
      return Component_WebStartBehavior.__super__.updateContent.apply(this, arguments);
    };

    return Component_WebStartBehavior;

  })(gs.Component_LayoutSceneBehavior);

  gs.Component_WebStartBehavior = Component_WebStartBehavior;

}).call(this);



//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIiXX0=
//# sourceURL=Animation_169.js
// Generated by CoffeeScript 1.12.7
(function() {
  var Component_Animation,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_Animation = (function(superClass) {
    extend(Component_Animation, superClass);


    /**
    * The base-class of all animation components. An animation-component
    * executes a certain animation on a game object. The type of the animation depends
    * on the component. <br>
    * <br>
    * In regular, animation components a used together with the gs.Component_Animator
    * component.
    *
    * @module gs
    * @class Component_Animation
    * @extends gs.Component
    * @memberof gs
    * @constructor
     */

    function Component_Animation() {
      Component_Animation.__super__.constructor.apply(this, arguments);
      this.name = "animation";
    }


    /**
    * Updates the animation. 
    *
    * @method update
     */

    Component_Animation.prototype.update = function() {
      return this.object.needsFullUpdate = true;
    };


    /**
    * Skips the animation. That is used to skip an animation if the user
    * wants to skip very fast through a visual novel scene.
    *
    * @method skip
     */

    Component_Animation.prototype.skip = function() {
      var ref;
      if (((ref = this.easing) != null ? ref.duration : void 0) > GameManager.tempSettings.skipTime) {
        if (GameManager.tempSettings.skipTime === 0) {
          return this.easing.time = this.easing.duration;
        } else {
          this.easing.duration = GameManager.tempSettings.skipTime;
          return this.easing.time = 0;
        }
      }
    };


    /**
    * Indicates if instant-skipping is enabled. In that case, there shouldn't be any delay and animation
    * must finish immediately and call its callback. It is mostly used for live-preview purposes.
    *
    * @method isInstantSkip
    * @return {boolean} If <b>true</b>, instant-skipping is enabled. Otherwise <b>false</b>.
     */

    Component_Animation.prototype.isInstantSkip = function() {
      return GameManager.tempSettings.skip && GameManager.tempSettings.skipTime === 0;
    };

    return Component_Animation;

  })(gs.Component);

  gs.Component_Animation = Component_Animation;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_BlendAnimation,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_BlendAnimation = (function(superClass) {
    extend(Component_BlendAnimation, superClass);


    /**
    * Executes a blend-animation on a game-object.
    *
    * @module gs
    * @class Component_BlendAnimation
    * @extends gs.Component_Animation
    * @memberof gs
    * @constructor
     */

    function Component_BlendAnimation(data) {
      Component_BlendAnimation.__super__.constructor.apply(this, arguments);

      /**
      * The easing-object used for the animation.
      * @property easing
      * @type gs.Easing
       */
      this.easing = new gs.Easing(null, data != null ? data.easing : void 0);
    }


    /**
    * Serializes the blend-animation into a data-bundle.
    *
    * @method toDataBundle
     */

    Component_BlendAnimation.prototype.toDataBundle = function() {
      return {
        easing: this.easing
      };
    };


    /**
    * Updates the blend-animation.
    *
    * @method update
     */

    Component_BlendAnimation.prototype.update = function() {
      Component_BlendAnimation.__super__.update.apply(this, arguments);
      if (!this.easing.isRunning) {
        return;
      }
      this.easing.updateValue();
      this.object.opacity = this.easing.value;
      if (!this.easing.isRunning) {
        this.object.opacity = Math.round(this.object.opacity);
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      }
    };


    /**
    * Stops the blend-animation.
    *
    * @method stop
     */

    Component_BlendAnimation.prototype.stop = function() {
      if (this.easing.isRunning) {
        this.easing.isRunning = false;
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      }
    };


    /**
    * Starts the blend-animation.
    *
    * @method start
    * @param {number} opacity The target opacity.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback called if blending is finished.
     */

    Component_BlendAnimation.prototype.start = function(opacity, duration, easingType, callback) {
      if (this.easing.isRunning) {
        if (typeof this.callback === "function") {
          this.callback(this.object, this);
        }
      }
      this.callback = callback;
      this.easing.type = easingType || gs.Easings.EASE_LINEAR[gs.EasingTypes.EASE_IN];
      if (this.object.opacity === opacity) {
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      }
      if (duration === 0 || this.isInstantSkip()) {
        this.object.opacity = opacity;
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      } else {
        return this.easing.startValue(this.object.opacity, opacity - this.object.opacity, duration);
      }
    };

    return Component_BlendAnimation;

  })(gs.Component_Animation);

  gs.Component_BlendAnimation = Component_BlendAnimation;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_MaskAnimation,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_MaskAnimation = (function(superClass) {
    extend(Component_MaskAnimation, superClass);


    /**
    * Executes a mask-animation on a game-object.
    *
    * @module gs
    * @class Component_MaskAnimation
    * @extends gs.Component_Animation
    * @memberof gs
    * @constructor
     */

    function Component_MaskAnimation(data) {
      Component_MaskAnimation.__super__.constructor.apply(this, arguments);
      this.easing = new gs.Easing(null, data != null ? data.easing : void 0);
      this.callback = null;
      this.animationType = (data != null ? data.animationType : void 0) || 0;
    }


    /**
    * Serializes the mask-animation into a data-bundle.
    *
    * @method toDataBundle
     */

    Component_MaskAnimation.prototype.toDataBundle = function() {
      return {
        easing: this.easing,
        animationType: this.animationType
      };
    };


    /**
    * Updates the mask-animation.
    *
    * @method update
     */

    Component_MaskAnimation.prototype.update = function() {
      Component_MaskAnimation.__super__.update.call(this);
      if (!this.easing.isRunning) {
        return;
      }
      this.easing.updateValue();
      this.object.mask.value = this.easing.value;
      if (!this.easing.isRunning) {
        if (this.animationType < 1) {
          this.object.mask.source = null;
          this.object.mask.vague = 0;
        }
        this.animationType = 0;
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      }
    };


    /**
    * Lets the game object appear on screen using a masking-effect.
    *
    * @method maskIn
    * @param {gs.Mask} mask The mask used for the animation.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_MaskAnimation.prototype.maskIn = function(mask, duration, easing, callback) {
      var ref;
      this.easing.type = easing;
      this.animationType = 0;
      this.callback = callback;
      if (duration === 0 || this.isInstantSkip()) {
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      } else {
        this.object.mask.type = 1;
        this.object.mask.source = ResourceManager.getBitmap("Graphics/Masks/" + ((ref = mask.graphic) != null ? ref.name : void 0));
        this.object.mask.vague = mask.vague;
        this.object.mask.value = 255;
        return this.easing.startValue(255, -255 - mask.vague, duration);
      }
    };


    /**
    * Lets the game object disappear from screen using a masking-effect.
    *
    * @method maskIn
    * @param {gs.Mask} mask The mask used for the animation.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_MaskAnimation.prototype.maskOut = function(mask, duration, easing, callback) {
      var ref;
      this.easing.type = easing;
      this.animationType = 0;
      this.callback = callback;
      if (duration === 0 || this.isInstantSkip()) {
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      } else {
        this.object.mask.type = 1;
        this.object.mask.source = ResourceManager.getBitmap("Graphics/Masks/" + ((ref = mask.graphic) != null ? ref.name : void 0));
        this.object.mask.vague = mask.vague;
        this.object.mask.value = 0;
        return this.easing.startValue(-mask.vague, 255 + mask.vague, duration);
      }
    };


    /**
    * Description follows...
    *
    * @method maskTo
    * @param {gs.Mask} mask The mask used for the animation.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback-function called when the animation is finished.
     */

    Component_MaskAnimation.prototype.maskTo = function(mask, duration, easing, callback) {
      var ref, ref1, ref2, ref3;
      this.easing.type = easing;
      this.animationType = 1;
      this.callback = callback;
      this.object.mask.type = 1;
      if (mask.sourceType === 0) {
        this.object.mask.source = ResourceManager.getBitmap("Graphics/Masks/" + ((ref = mask.graphic) != null ? ref.name : void 0));
      } else {
        if (((ref1 = this.object.mask.source) != null ? ref1.videoElement : void 0) != null) {
          this.object.mask.source.pause();
        }
        this.object.mask.source = ResourceManager.getVideo("Movies/" + mask.video.name);
        if ((ref2 = this.object.mask.source) != null) {
          ref2.play();
        }
        if ((ref3 = this.object.mask.source) != null) {
          ref3.loop = true;
        }
      }
      this.object.mask.vague = mask.vague;
      if (duration === 0 || this.isInstantSkip()) {
        this.animationType = 0;
        this.object.mask.value = mask.value;
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      } else {
        return this.easing.startValue(this.object.mask.value, mask.value - this.object.mask.value, duration);
      }
    };

    return Component_MaskAnimation;

  })(gs.Component_Animation);

  gs.Component_MaskAnimation = Component_MaskAnimation;

}).call(this);

// Generated by CoffeeScript 1.12.7
(function() {
  var Component_TintAnimation,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Component_TintAnimation = (function(superClass) {
    extend(Component_TintAnimation, superClass);


    /**
    * Executes a tint-animation on a game-object. The tint is executed on
    * the game object's tone-property.
    *
    * @module gs
    * @class Component_TintAnimation
    * @extends gs.Component_Animation
    * @memberof gs
    * @constructor
     */

    function Component_TintAnimation(data) {
      Component_TintAnimation.__super__.constructor.apply(this, arguments);
      this.sourceTone = data != null ? data.sourceTone : void 0;
      this.targetTone = data != null ? data.targetTone : void 0;
      this.easing = new gs.Easing(null, data != null ? data.easing : void 0);
      this.callback = null;
    }


    /**
    * Serializes the tint-animation into a data-bundle.
    *
    * @method toDataBundle
     */

    Component_TintAnimation.prototype.toDataBundle = function() {
      return {
        easing: this.easing,
        sourceTone: this.sourceTone,
        targetTone: this.targetTone
      };
    };


    /**
    * Updates the tint-animation.
    *
    * @method update
     */

    Component_TintAnimation.prototype.update = function() {
      var a;
      Component_TintAnimation.__super__.update.apply(this, arguments);
      if (!this.easing.isRunning) {
        return;
      }
      this.easing.updateValue();
      a = this.easing.value;
      this.object.tone.red = Math.floor((this.sourceTone.red * a + this.targetTone.red * (255 - a)) / 255);
      this.object.tone.green = Math.floor((this.sourceTone.green * a + this.targetTone.green * (255 - a)) / 255);
      this.object.tone.blue = Math.floor((this.sourceTone.blue * a + this.targetTone.blue * (255 - a)) / 255);
      this.object.tone.grey = Math.floor((this.sourceTone.grey * a + this.targetTone.grey * (255 - a)) / 255);
      if (!this.easing.isRunning) {
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      }
    };


    /**
    * Starts the tint-animation.
    *
    * @method start
    * @param {gs.Tone} tone The target-tone.
    * @param {number} duration The duration in frames.
    * @param {Object} easingType The easing-type.
    * @param {function} [callback] An optional callback called if the animation is finished.
     */

    Component_TintAnimation.prototype.start = function(tone, duration, easing, callback) {
      this.callback = callback;
      if (this.object.tone.red === tone.red && this.object.tone.green === tone.green && this.object.tone.blue === tone.blue && this.object.tone.grey === tone.grey) {
        if (typeof this.callback === "function") {
          this.callback(this.object, this);
        }
      }
      if (duration === 0 || this.isInstantSkip()) {
        this.object.tone = tone;
        return typeof this.callback === "function" ? this.callback(this.object, this) : void 0;
      } else {
        this.sourceTone = new Tone(this.object.tone);
        this.targetTone = tone;
        this.callback = callback;
        this.easing.type = easing;
        return this.easing.startValue(255, -255, duration);
      }
    };

    return Component_TintAnimation;

  })(gs.Component_Animation);

  gs.Component_TintAnimation = Component_TintAnimation;

}).call(this);

// Generated by CoffeeScript 1.12.7

/**
* Different types of animation looping.
*
* @module gs
* @class AnimationLoopType
* @memberof gs
* @static
* @final
 */

(function() {
  var AnimationLoopType, Component_PathAnimation,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  AnimationLoopType = (function() {
    function AnimationLoopType() {}

    AnimationLoopType.initialize = function() {

      /**
      * No looping.
      * @property NONE
      * @static
      * @final
       */
      this.NONE = 0;

      /**
      * Regular looping. If the end of an animation is reached it will start
      * from the beginning.
      * @property NORMAL
      * @static
      * @final
       */
      this.NORMAL = 1;

      /**
      * Reverse looping. If the end of an animation is reached it will be
      * reversed an goes now from end to start.
      * @property REVERSE
      * @static
      * @final
       */
      return this.REVERSE = 2;
    };

    return AnimationLoopType;

  })();

  AnimationLoopType.initialize();

  gs.AnimationLoopType = AnimationLoopType;

  Component_PathAnimation = (function(superClass) {
    extend(Component_PathAnimation, superClass);


    /**
    * Executes a path-animation on a game-object. A path-animation moves the
    * game-object along a path of quadratic bezier-curves.
    *
    * @module gs
    * @class Component_PathAnimation
    * @extends gs.Component_Animation
    * @memberof gs
    * @constructor
     */

    function Component_PathAnimation(data) {
      Component_PathAnimation.__super__.constructor.apply(this, arguments);
      this.path = (data != null ? data.path : void 0) || null;
      this.easing = new gs.Easing(null, data != null ? data.easing : void 0);
      this.startPosition = (data != null ? data.startPosition : void 0) || null;
      this.loopType = (data != null ? data.loopType : void 0) || 0;
      this.animationType = 0;
      this.effects = (data != null ? data.effects : void 0) || [];
      this.effect = null;
    }


    /**
    * Serializes the path-animation into a data-bundle.
    *
    * @method toDataBundle
     */

    Component_PathAnimation.prototype.toDataBundle = function() {
      return {
        path: this.path,
        easing: this.easing,
        startPosition: this.startPosition,
        loopType: this.loopType
      };
    };


    /**
    * Skips the animation. That is used to skip an animation if the user
    * wants to skip very fast through a visual novel scene.
    *
    * @method skip
     */

    Component_PathAnimation.pr