﻿
## initialization
init offset = -2
init python:
    gui.init(1280, 720)

## colors
define gui.accent_color = "#245080"
define gui.accent_color_dark = "#4470A0"
define gui.idle_color = "#FFFFFF"
define gui.idle_small_color = "#BFB6B0"
define gui.hover_color = "#D2322E"
define gui.hover_color_dark = "#860000"
define gui.selected_color = "#BFB6B0"
define gui.insensitive_color = "#BFB6B0"
define gui.muted_color = "#BFB6B0"
define gui.hover_muted_color = "#BFB6B0"
define gui.text_color = "#404040"
define gui.interface_text_color = "#404040"

## fonts
define gui.default_font = "DejaVuSans.ttf"
define gui.name_font = "DejaVuSans.ttf"
define gui.interface_font = "DejaVuSans.ttf"
define gui.character_size = 21
define gui.text_size = 22
define gui.name_text_size = 22
define gui.interface_text_size = 22
define gui.label_text_size = 22
define gui.big_label_text_size = 28
define gui.title_text_size = 50

## menus
define gui.background_game = "gui/screen_game.png"
define gui.background_main = "gui/screen_main.png"
define gui.background_menu = "gui/screen_menu.png"

## buttons
define gui.button_width = None
define gui.button_height = 48
define gui.button_borders = Borders(0, 0, 0, 0)
define gui.button_tile = True
define gui.button_text_font = gui.interface_font
define gui.button_text_size = 22
define gui.button_text_idle_color = gui.idle_color
define gui.button_text_hover_color = gui.hover_color
define gui.button_text_selected_color = gui.selected_color
define gui.button_text_insensitive_color = gui.insensitive_color
define gui.button_text_xalign = 0.5
define gui.radio_button_borders = Borders(25, 4, 4, 4)
define gui.check_button_borders = Borders(25, 4, 4, 4)
define gui.confirm_button_text_xalign = 0.5
define gui.page_button_borders = Borders(10, 4, 10, 4)
define gui.quick_button_borders = Borders(10, 4, 10, 0)
define gui.quick_button_text_size = 14
define gui.quick_button_text_idle_color = gui.idle_small_color
define gui.quick_button_text_selected_color = gui.accent_color

## choice buttons
define gui.choice_button_width = 790
define gui.choice_button_height = None
define gui.choice_button_tile = False
define gui.choice_button_borders = Borders(100, 5, 100, 5)
define gui.choice_button_text_font = gui.default_font
define gui.choice_button_text_size = gui.text_size
define gui.choice_button_text_xalign = 0.5
define gui.choice_button_text_idle_color = gui.idle_color
define gui.choice_button_text_hover_color = gui.idle_color

## file slot buttons
define gui.slot_button_width = 352
define gui.slot_button_height = 198
define gui.slot_button_borders = Borders(0, 0, 0, 0)
define gui.slot_button_text_size = 14
define gui.slot_button_text_idle_color = gui.idle_small_color
define config.thumbnail_width = 352
define config.thumbnail_height = 198
define gui.file_slot_cols = 3
define gui.file_slot_rows = 2

## positioning and spacing
define gui.navigation_xpos = 120
define gui.skip_ypos = 10
define gui.notify_ypos = 45
define gui.choice_spacing = 22
define gui.navigation_spacing = 10
define gui.pref_spacing = 10
define gui.pref_button_spacing = 0
define gui.page_spacing = 0
define gui.slot_spacing = 10

## frames
define gui.frame_borders = Borders(4, 4, 4, 4)
define gui.confirm_frame_borders = Borders(40, 40, 40, 40)
define gui.skip_frame_borders = Borders(16, 5, 50, 5)
define gui.notify_frame_borders = Borders(16, 5, 40, 5)
define gui.frame_tile = False

## sliders
define gui.slider_size = 30
define gui.slider_tile = False
define gui.slider_borders = Borders(4, 4, 4, 4)
define gui.vslider_borders = Borders(4, 4, 4, 4)
define gui.unscrollable = "hide"
