﻿
## initialization
init offset = -1

## styles
style default:
    font gui.default_font
    size gui.text_size
    color gui.text_color
style hyperlink_text:
    color gui.accent_color
    hover_color gui.hover_color
    hover_underline True
style gui_text:
    font gui.interface_font
    color gui.interface_text_color
    size gui.interface_text_size
style button:
    properties gui.button_properties("button")
style button_text is gui_text:
    properties gui.button_text_properties("button")
    yalign 0.5
style label_text is gui_text:
    color gui.accent_color
    size gui.label_text_size
style prompt_text is gui_text:
    color gui.text_color
    size gui.interface_text_size
style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"
style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"
style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)
style submenu_text is gui_label
style submenu_label_text is gui_label_text
style submenu_label_text:
    color gui.muted_color
    ypos 11
    size gui.character_size
style submenu_button is gui_button
style submenu_button_text is gui_button_text
style submenu_button:
    left_margin 30
    right_margin 23
style submenu_button_text:
    color gui.idle_color
    hover_color gui.hover_color_dark
    insensitive_color gui.insensitive_color
    xalign 0.5
    
## say
screen say(who, what):
    style_prefix "say"
    window:
        id "window"
        text what id "what"
        if who is not None:
            window:
                style "namebox"
                text who id "who"
    add SideImage() xalign 0.0 yalign 1.0
style window:
    xalign 0.5
    xfill True
    yalign 1.0
    ysize 185
    color gui.idle_color
    background Image(gui.background_game, xalign=0.5, yalign=1.0)
style namebox:
    xpos 80
    xanchor 0.0
    xsize None
    ypos -32
    ysize None
style say_label:
    color gui.idle_color
    size gui.text_size
    xalign 0.0
    yalign 0.5
style say_dialogue:
    color gui.idle_color
    xpos 80
    xanchor 0.0
    xsize 1125
    ypos 20
style say_thought:
    color gui.idle_color
    xpos 80
    xanchor 0.0
    xsize 1125
    ypos 20
    
## choice
screen choice(items):
    add gui.background_game
    style_prefix "choice"
    vbox:
        for i in items:
            textbutton i.caption action i.action
define config.narrator_menu = True
style choice_vbox:
    xalign 0.5
    ypos 270
    yanchor 0.5
    spacing gui.choice_spacing
style choice_button is default:
    properties gui.button_properties("choice_button")
style choice_button_text is default:
    properties gui.button_text_properties("choice_button")

## quick menu
screen quick_menu():
    zorder 100
    style_prefix "tooltip"
    default tt = Tooltip(" ")
    vbox:
        xpos 970
        ypos 503
        xalign 1.0
        text tt.value
    hbox:
        style_prefix "quick"
        xalign 1.0
        yalign 1.0
        hbox:
            xpos 6
            ypos -159
            spacing gui.pref_spacing
            style_prefix "quick_save"
            textbutton _("") action ShowMenu('save') hovered tt.Action("Save Game")
        hbox:
            xpos -7
            ypos -159
            spacing gui.pref_spacing
            style_prefix "quick_load"
            textbutton _("") action ShowMenu('load') hovered tt.Action("Load Game")
        hbox:
            xpos -18
            ypos -159
            spacing gui.pref_spacing
            style_prefix "quick_auto"
            textbutton _("") action Preference("auto-forward", "toggle") hovered tt.Action("Auto")
        hbox:
            xpos -33
            ypos -159
            spacing gui.pref_spacing
            style_prefix "quick_skip"
            textbutton _("") action Skip() alternate Skip(fast=True, confirm=True) hovered tt.Action("Skip")
        hbox:
            xpos -50
            ypos -159
            spacing gui.pref_spacing
            style_prefix "quick_settings"
            textbutton _("") action ShowMenu('settings') hovered tt.Action("Settings")
init python:
    config.overlay_screens.append("quick_menu")
style tooltip_text:
    color gui.idle_color
style quick_save_button:
    xsize 60
    ysize 60
    background Image("gui/menu/save.png")
    hover_background Image("gui/menu/save_hover.png")
style quick_load_button:
    xsize 60
    ysize 60
    background Image("gui/menu/load.png")
    hover_background Image("gui/menu/load_hover.png")
style quick_auto_button:
    xsize 60
    ysize 60
    background Image("gui/menu/auto.png")
    hover_background Image("gui/menu/auto_hover.png")
style quick_skip_button:
    xsize 60
    ysize 60
    background Image("gui/menu/skip.png")
    hover_background Image("gui/menu/skip_hover.png")
style quick_settings_button:
    xsize 60
    ysize 60
    background Image("gui/menu/settings.png")
    hover_background Image("gui/menu/settings_hover.png")
 
## main menu
screen main_menu():
    add gui.background_main
    vbox:
        style_prefix "navigation"
        xpos 55
        ypos 235
        spacing 11
        textbutton _("New Game") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), Start()]
        textbutton _("Load Game") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("load")]
        textbutton _("Accolades") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("art")]
        textbutton _("Settings") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("settings")]
        textbutton _("Credits") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("credits")]
        textbutton _("Exit Game") action Quit(confirm=not main_menu)
    hbox:
        xpos 41
        ypos 637
        spacing 18
        style_prefix "kickstarter"
        textbutton _("") action OpenURL(link.kickstarter)
    hbox:
        xpos 115
        ypos 637
        spacing 18
        style_prefix "facebook"
        textbutton _("") action OpenURL(link.facebook)
    hbox:
        xpos 188
        ypos 637
        spacing 18
        style_prefix "twitter"
        textbutton _("") action OpenURL(link.twitter)
    hbox:
        xpos 261
        ypos 637
        spacing 18
        style_prefix "tumblr"
        textbutton _("") action OpenURL(link.tumblr)
style navigation_button is gui_button
style navigation_button_text is gui_button_text
style navigation_button:
    xsize 250
    left_padding 60
style navigation_button_text:
    xalign 0.0
style kickstarter_button:
    xsize 55
    ysize 55
    left_padding 60
    background Image("gui/icon_kickstarter.png")
    hover_background Image("gui/icon_kickstarter_hover.png")
style facebook_button:
    xsize 55
    ysize 55
    left_padding 60
    background Image("gui/icon_facebook.png")
    hover_background Image("gui/icon_facebook_hover.png")
style twitter_button:
    xsize 55
    ysize 55
    left_padding 60
    background Image("gui/icon_twitter.png")
    hover_background Image("gui/icon_twitter_hover.png")
style tumblr_button:
    xsize 55
    ysize 55
    left_padding 60
    background Image("gui/icon_tumblr.png")
    hover_background Image("gui/icon_tumblr_hover.png")
style main_menu_frame is empty

## menu
screen menu(mode):
    add gui.background_menu
    hbox:
        style_prefix "menu"
        xpos 22
        ypos 25
        spacing 18
        if mode != "start":
            textbutton _("New Game") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), Start()]
        else:
            textbutton _("New Game")
        if mode != "load":
            textbutton _("Load Game") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("load")]
        else:
            textbutton _("Load Game")
        if mode != "accolades":
            textbutton _("Accolades") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("art")]
        else:
            textbutton _("Accolades")
        if mode != "settings":
            textbutton _("Settings") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("settings")]
        else:
            textbutton _("Settings")
        if mode != "credits":
            textbutton _("Credits") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), ShowMenu("credits")]
        else:
            textbutton _("Credits")
        if mode != "return":
            textbutton _("Return") action [Hide("main_menu"), Hide("load"), Hide("save"), Hide("art"), Hide("characters"), Hide("music"), Hide("trophies"), Hide("settings"), Hide("credits"), Return()]
        else:
            textbutton _("Return")
style menu_button is gui_button
style menu_button_text is gui_button_text
style menu_button:
    xsize 190
    left_padding 60
style menu_button_text:
    size gui.character_size
    xalign 0.0
    
## accolades
screen accolades(mode):
    hbox:
        style_prefix "submenu"
        xpos 52
        ypos 140
        spacing 15
        if (mode == "art"):
            textbutton _("Art")
        else:
            textbutton _("Art") action [Hide("music"), Hide("characters"), Hide("trophies"), ShowMenu("art")]
        imagebutton auto "gui/divider_%s.png"
        if (mode == "characters"):
            textbutton _("Characters")
        else:
            textbutton _("Characters") action [Hide("music"), Hide("art"), Hide("trophies"), ShowMenu("characters", 0)]
        imagebutton auto "gui/divider_%s.png"
        if (mode == "music"):
            textbutton _("Music")
        else:
            textbutton _("Music") action [Hide("characters"), Hide("art"), Hide("trophies"), ShowMenu("music", 0)]
        imagebutton auto "gui/divider_%s.png"
        if (mode == "trophies"):
            textbutton _("Trophies")
        else:
            textbutton _("Trophies") action [Hide("music"), Hide("characters"), Hide("art"), ShowMenu("trophies")]
        imagebutton auto "gui/divider_%s.png"
 
screen grid_three_button:
    $ action = art.Action(name)
    button:
        style "default"
        action action
        xmaximum (352)
        xminimum (352)
        ymaximum (198)
        yminimum (198)
        xmargin 0
        ymargin 0
        xpadding 0
        ypadding 0
        if not action:
            background "gui/grid_three_unknown_idle.png"
        else:
            add thumb xalign 0.5 yalign 0.5
            
screen grid_four_button:
    $ action = t.Action(name)
    button:
        style "default"
        action action
        xmaximum (256)
        xminimum (256)
        ymaximum (198)
        yminimum (198)
        xmargin 0
        ymargin 0
        xpadding 0
        ypadding 0
        if not action:
            background "gui/grid_four_unknown_idle.png"
        else:
            add thumb xalign 0.5 yalign 0.5
    
## art
screen art:
    use menu("accolades")
    use accolades("art")
    hbox:
        xpos 80
        ypos 238
        xsize 1135
        ysize 434
        grid 3 2:
            xfill True
            yfill True
            use grid_three_button(name="landscape", thumb=im.Scale("images/art/landscape.jpg", 352, 198))
            use grid_three_button(name="aquarium", thumb=im.Scale("images/art/aquarium.jpg", 352, 198))
            use grid_three_button(name="introduction", thumb=im.Scale("images/art/introduction.jpg", 352, 198))
            null
            null
            null

## characters
screen characters(character):
    use menu("accolades")
    use accolades("characters")
    add "gui/submenu_characters.png"
    style_prefix "character"
    vbox:
        xpos 50
        ypos 218
        spacing -2.2
        for char in range(len(c)):
            if eval("persistent.unlock_character_" + c[char]["name"]) is not None:
                if char != character:
                    textbutton _(c[char]["name"]) action [ShowMenu("characters", char)]
                else:
                    textbutton _(c[char]["name"])
            else:
                textbutton _("???")
    if character != "":
        vbox:
            xpos 325
            ypos 238
            xsize 530
            label "{b}" + c[character]["name"] + "{/b}"
            vbox:
                ypos 10
                hbox:
                    spacing 30
                    text "{i}height{/i}: " + c[character]["height"]
                    text "{i}weight{/i}: " + c[character]["weight"]
                hbox:
                    spacing 30
                    text "{i}eyes{/i}: " + c[character]["eyes"]
                    text "{i}age{/i}: " + c[character]["age"]
            vbox:
                ypos 15
                text c[character]["bio"]
        vbox:
            add c[character]["image"]
style character_button is gui_button
style character_button_text is gui_button_text
style character_button:
    xsize 250
style character_button_text:
    color gui.idle_color
    hover_color gui.hover_color_dark
    insensitive_color gui.insensitive_color
style character_label is gui_label
style character_label_text is gui_label_text
style character_text is gui_text
style character_label_text:
    size gui.big_label_text_size
    color gui.hover_color
style character_text:
    size gui.character_size
    color gui.text_color
    line_spacing 9
    
## music
screen music:
    use menu("accolades")
    use accolades("music")
    style_prefix "music"
    hbox:
        xpos 80
        ypos 238
        xsize 1135
        ysize 434
        grid 3 2:
            xfill True
            yfill True
            hbox:
                if persistent.unlock_music_commander:
                    imagebutton auto "gui/grid_three_music_%s.png" action m.Play("music/Commander-Intro.mp3")
                    hbox:
                        xpos -354
                        xsize 352
                        textbutton _("Commander-In-Chief Leitmotif") action m.Play("music/Commander-Intro.mp3")
                else:
                    imagebutton auto "gui/grid_three_unknown_%s.png"
            hbox:
                if persistent.unlock_music_committee:
                    imagebutton auto "gui/grid_three_music_%s.png" action m.Play("music/Committee-Classroom.mp3")
                    hbox:
                        xpos -354
                        xsize 352
                        textbutton _("Committee Ditty") action m.Play("music/Committee-Classroom.mp3")
                else:
                    imagebutton auto "gui/grid_three_unknown_%s.png"
            hbox:
                if persistent.unlock_music_convention:
                    imagebutton auto "gui/grid_three_music_%s.png" action m.Play("music/Convention-Tense.mp3")
                    hbox:
                        xpos -354
                        xsize 352
                        textbutton _("Convention Tension") action m.Play("music/Convention-Tense.mp3")
                else:
                    imagebutton auto "gui/grid_three_unknown_%s.png"
            hbox:
                if persistent.unlock_music_election:
                    imagebutton auto "gui/grid_three_music_%s.png" action m.Play("music/Election-Emotional.mp3")
                    hbox:
                        xpos -354
                        xsize 352
                        textbutton _("Election Introspection") action m.Play("music/Election-Emotional.mp3")
                else:
                    imagebutton auto "gui/grid_three_unknown_%s.png"
            hbox:
                if persistent.unlock_music_merry:
                    imagebutton auto "gui/grid_three_music_%s.png" action m.Play("music/Merry-Happy.mp3")
                    hbox:
                        xpos -354
                        xsize 352
                        textbutton _("Merry Primary") action m.Play("music/Merry-Happy.mp3")
                else:
                    imagebutton auto "gui/grid_three_unknown_%s.png"
            hbox:
                if persistent.unlock_music_presidential:
                    imagebutton auto "gui/grid_three_music_%s.png" action m.Play("music/Presidential-Menu.mp3")
                    hbox:
                        xpos -354
                        xsize 352
                        textbutton _("Presidential Instrumental") action m.Play("music/Presidential-Menu.mp3")
                else:
                    imagebutton auto "gui/grid_three_unknown_%s.png"
style music_button is gui_button
style music_button_text is gui_button_text
style music_button:
    xalign 0.5
    xsize 352
    ypos 147
style music_button_text:
    color gui.idle_color
    
## trophies
screen trophies:
    use menu("accolades")
    use accolades("trophies")
    hbox:
        xpos 80
        ypos 238
        xsize 1135
        ysize 434
        grid 4 2:
            xfill True
            yfill True
            use grid_four_button(name="textbook", thumb=im.Scale("images/trophies/textbook_thumb.png", 256, 198))
            use grid_four_button(name="card", thumb=im.Scale("images/trophies/card_thumb.png", 256, 198))
            use grid_four_button(name="turtle", thumb=im.Scale("images/trophies/turtle_thumb.png", 256, 198))
            use grid_four_button(name="map", thumb=im.Scale("images/trophies/map_thumb.png", 256, 198))
            use grid_four_button(name="bottle", thumb=im.Scale("images/trophies/bottle_thumb.png", 256, 198))
            use grid_four_button(name="constitution", thumb=im.Scale("images/trophies/constitution_thumb.png", 256, 198))
            use grid_four_button(name="notebook", thumb=im.Scale("images/trophies/notebook_thumb.png", 256, 198))
            use grid_four_button(name="id", thumb=im.Scale("images/trophies/id_thumb.png", 256, 198))

## load and save
screen save():
    use file_slots(_("Save"))
screen load():
    use file_slots(_("Load Game"))
screen file_slots(title):
    use menu("load")
    fixed:
        grid 3 2:
            xalign 0.5
            ypos 240
            style_prefix "slot"
            spacing 20
            for i in range(6):
                $ slot = i + 1
                button:
                    action FileAction(slot)
                    has vbox
                    add FileScreenshot(slot)
                    key "save_delete" action FileDelete(slot)
        hbox:
            style_prefix "page"
            xpos 40
            ypos 140
            textbutton _("<") action FilePagePrevious()
            imagebutton auto "gui/divider_%s.png"
            textbutton _("{#auto_page}Auto") action FilePage("auto")
            imagebutton auto "gui/divider_%s.png"
            textbutton _("{#quick_page}Quick") action FilePage("quick")
            imagebutton auto "gui/divider_%s.png"
            for page in range(1, 6):
                textbutton "[page]" action FilePage(page)
                imagebutton auto "gui/divider_%s.png"
            textbutton _(">") action FilePageNext()
            imagebutton auto "gui/divider_%s.png"
style page_button is gui_button
style page_button_text is gui_button_text
style slot_button is gui_button
style slot_button_text is gui_button_text
style page_button:
    properties gui.button_properties("page_button")
    left_margin 18
    right_margin 15
style page_button_text:
    properties gui.button_text_properties("page_button")
    color gui.idle_color
    hover_color gui.hover_color_dark
    selected_color gui.selected_color
    insensitive_color gui.insensitive_color
style slot_button:
    properties gui.button_properties("slot_button")
style slot_button_text:
    properties gui.button_text_properties("slot_button")
 
## settings
screen settings():
    default device = "preferences"
    use menu("settings")
    style_prefix "submenu"
    hbox:
        xpos 52
        ypos 140
        spacing 15
        if device == "preferences":
            textbutton _("Preferences")
        else:
            textbutton _("Preferences") action SetScreenVariable("device", "preferences")
        imagebutton auto "gui/divider_%s.png"
        if device == "keyboard":
            textbutton _("Keyboard")
        else:
            textbutton _("Keyboard") action SetScreenVariable("device", "keyboard")
        imagebutton auto "gui/divider_%s.png"
        if device == "mouse":
            textbutton _("Mouse")
        else:
            textbutton _("Mouse") action SetScreenVariable("device", "mouse")
        imagebutton auto "gui/divider_%s.png"
    vbox:
        xpos 80
        ypos 235
        spacing 18
        if device == "preferences":
            use preferences_settings
        elif device == "keyboard":
            use keyboard_settings
        elif device == "mouse":
            use mouse_settings
screen preferences_settings():
    style_prefix "settings"
    hbox:
        box_wrap True
        vbox:
            style_prefix "radio"
            label _("Display")
            textbutton _("Window") action Preference("display", "window")
            textbutton _("Fullscreen") action Preference("display", "fullscreen")
        vbox:
            style_prefix "radio"
            label _("Transitions")
            textbutton _("All") action Preference("transitions", "all")
            textbutton _("None") action Preference("transitions", "none")
        vbox:
            style_prefix "radio"
            label _("Skip Text")
            textbutton _("Seen Text") action Preference("skip", "seen")
            textbutton _("All Text") action Preference("skip", "all")
        vbox:
            style_prefix "radio"
            xsize 300
            default minigame = "easy"
            label _("Eagle-Breeding Difficulty")
            textbutton _("Dwight D. Easy-hower") action SetScreenVariable("minigame", "easy")
            textbutton _("William MediumKinley") action SetScreenVariable("minigame", "medium")
            textbutton _("Warren G. Harding") action SetScreenVariable("minigame", "hard")
    null height (2 * gui.pref_spacing)
    hbox:
        style_prefix "slider"
        box_wrap True
        vbox:
            if config.has_music:
                label _("Music Volume")
                hbox:
                    bar value Preference("music volume")
            if config.has_sound:
                label _("Sound Effects Volume")
                hbox:
                    bar value Preference("sound volume")
                    if config.sample_sound:
                        textbutton _("Test") action Play("sound", config.sample_sound)
            if config.has_voice:
                label _("Voice Volume")
                hbox:
                    bar value Preference("voice volume")
                    if config.sample_voice:
                        textbutton _("Test") action Play("voice", config.sample_voice)
        vbox:
            label _("Text Speed")
            bar value Preference("text speed")
            label _("Auto-Forward Time")
            bar value Preference("auto-forward time")
screen keyboard_settings():
    style_prefix "settings"
    hbox:
        label _("Enter")
        text _("Advances dialogue and activates the interface.")
    hbox:
        label _("Space")
        text _("Advances dialogue without selecting choices.")
    hbox:
        label _("Arrow Keys")
        text _("Navigate the interface.")
    hbox:
        label _("Escape")
        text _("Accesses the game menu.")
    hbox:
        label _("Ctrl")
        text _("Skips dialogue while held down.")
    hbox:
        label _("Tab")
        text _("Toggles dialogue skipping.")
    hbox:
        label _("Page Up")
        text _("Rolls back to earlier dialogue.")
    hbox:
        label _("Page Down")
        text _("Rolls forward to later dialogue.")
    hbox:
        label "H"
        text _("Hides the user interface.")
    hbox:
        label "S"
        text _("Takes a screenshot.")
screen mouse_settings():
    style_prefix "settings"
    hbox:
        label _("Left Click")
        text _("Advances dialogue and activates the interface.")
    hbox:
        label _("Middle Click")
        text _("Hides the user interface.")
    hbox:
        label _("Right Click")
        text _("Accesses the game menu.")
    hbox:
        label _("Mouse Wheel Up")
        text _("Rolls back to earlier dialogue.")
    hbox:
        label _("Mouse Wheel Down")
        text _("Rolls forward to later dialogue.")
style settings_button is gui_button
style settings_button_text is gui_button_text
style settings_label is gui_label
style settings_label_text is gui_label_text
style settings_text is gui_text
style settings_label:
    xsize 250
    right_padding 20
style settings_label_text:
    size gui.text_size
    xalign 0
    text_align 1.0
style pref_label is gui_label
style pref_label_text is gui_label_text
style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox
style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 2
style pref_label_text:
    yalign 1.0
style pref_vbox:
    xsize 260
style radio_vbox:
    spacing gui.pref_button_spacing
style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/check_[prefix_]foreground.png"
style radio_button_text:
    properties gui.button_text_properties("radio_button")
    color gui.text_color
    hover_color gui.accent_color_dark
    insensitive_color gui.idle_small_color
    selected_color gui.accent_color_dark
style slider_slider:
    xsize 330
style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 10
style slider_button_text:
    properties gui.button_text_properties("slider_button")
style slider_vbox:
    xsize 400
    
## credits
screen credits():
    default page = "credits_development"
    use menu("credits")
    style_prefix "submenu"
    hbox:
        xpos 52
        ypos 140
        spacing 15
        if page == "credits_development":
            textbutton _("Development")
        else:
            textbutton _("Development") action SetScreenVariable("page", "credits_development")
        imagebutton auto "gui/divider_%s.png"
        if page == "credits_graphics":
            textbutton _("Graphics")
        else:
            textbutton _("Graphics") action SetScreenVariable("page", "credits_graphics")
        imagebutton auto "gui/divider_%s.png"
        if page == "credits_sound":
            textbutton _("Sound")
        else:
            textbutton _("Sound") action SetScreenVariable("page", "credits_sound")
        imagebutton auto "gui/divider_%s.png"
    vbox:
        xpos 80
        xsize 1100
        ypos 235
        spacing 17
        if page == "credits_development":
            use credits_development
        elif page == "credits_graphics":
            use credits_graphics
        elif page == "credits_sound":
            use credits_sound
screen credits_development():
    text _("{b}Writer & Creator:{/b} {a=https://www.kickstarter.com/projects/1313881651/1947682742?token=f3e256af}Robbie Amster{/a}")
    text _("Robbie is a writer, improv comedian, and actor. He is currently a writer/actor for the web sketch comedy group {a=https://www.youtube.com/channel/UCqt51vDWG11w8tDQAoTGvPg/videos/}Bacon Bits{/a}. He has a degree in English from Williams college, where he wrote for the sketch groups TEED and PARTS, and led the improv troupe Combo Za.")
    text _("{b}Programmer & UX Design:{/b} {a=http://justinhanks.com/}Justin Hanks{/a}")
    text _("Justin is a web developer, programmer, and actor with degrees in computer science and mathematics from Xavier University. He has helped develop web applications for clients such as General Electric, NBCUniversal, Comcast, Nike, and Amazon.")
screen credits_graphics():
    text _("{b}Sprites:{/b} {a=http://adyrn.weebly.com/}Adryn{/a}")
    text _("Adyrn is a character artist who specializes in visual novels. Previous works include A Wild Catgirl Appears, This World Unknown, and Undead Lily.")
    text _("{b}Backgrounds:{/b} {a=http://badriel.deviantart.com/}Badriel{/a}")
    text _("Badriel is a background artist for visual novels. Previous projects include Knifepoint Horror, Coming Out on Top, Asagao Academy, Sakura Spirit, and many more.")
    text _("{b}CGs:{/b} {a=http://reddart.tumblr.com/}Redd Art{/a}")
    text _("Redd is a CG, sprite, and background artist. They have worked on several visual novels, including titles by Michaela Law and HentaiWriter.")
    text _("{b}Trophy Art:{/b} {a=http://jeremysimmonsdesign.com/}Jeremy Simmons{/a}")
    text _("Jeremy is a freelance writer, artist, and graphic designer based in Cincinnati. He has worked for Wizards of the Coast, Rivertown Brewery, Goodman Games, and many others.")
screen credits_sound():   
    text _("{b}Music:{/b} {a=https://soundcloud.com/calypsogames/}Calypso Games{/a}")
    text _("Calypso is a musician with 4 years of experience in composing music, and has written well over 100 songs for visual novels. Previous titles worked on include Reflections: Dreams and Reality, Starlight, and Candlelight.")
    text _("{b}Music:{/b} {a=https://soundcloud.com/tyberalyx/}TyberAlyx{/a}")
    text _("Alyx is a self-taught pianist with 7 years of experience who specializes in visual novels. He has previously worked on projects including Empty Horizons, Caramel Mokaccino, and The Sad Story of Emmeline Burns.")
    text _("{b}Sound Effects:{/b} {a=http://film-forward.com/author/tallis-moore/}Tallis Moore{/a}")
    text _("Tallis has previously worked on the sound design for multiple shows at Williams College, where he graduated with a degree in English. He currently write a film review blog.")
    
## confirm
screen confirm(message, yes_action, no_action):
    modal True
    zorder 200
    style_prefix "confirm"
    add "gui/overlay/confirm.png"
    frame:
        vbox:
            xalign .5
            yalign .5
            spacing 30
            label _(message):
                style "confirm_prompt"
                xalign 0.5
            hbox:
                xalign 0.5
                spacing 100
                textbutton _("Yes") action yes_action
                textbutton _("No") action no_action
    ## Right-click and escape answer "no".
    key "game_menu" action no_action
style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text
style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5
style confirm_prompt_text:
    color gui.idle_color
    text_align 0.5
    layout "subtitle"
style confirm_button:
    properties gui.button_properties("confirm_button")
style confirm_button_text:
    properties gui.button_text_properties("confirm_button")

## skip
screen skip_indicator():
    zorder 100
