﻿
## basics
define config.name = _("Grand Old Academy")
define gui.show_name = False
define config.version = "1.0"
define gui.about = _("")
define build.name = "GrandOldAcademy"
define config.has_sound = True
define config.has_music = True
define config.has_voice = False
define config.main_menu_music = "music/Presidential-Menu.mp3"
define config.layers = [ "master", "transient", "screens", "overlay" ]

## transitions
define config.enter_transition = dissolve
define config.exit_transition = dissolve
define config.after_load_transition = None
define config.end_game_transition = None

## window management
define config.window = "auto"
define config.window_show_transition = Dissolve(.2)
define config.window_hide_transition = Dissolve(.2)

## preference defaults
default preferences.text_cps = 0
default preferences.afm_time = 15

## save directory
define config.save_directory = "GrandOldAcademy-1473225539"

## icon
define config.window_icon = "gui/window_icon.png"

## build configuration
init python:
    build.classify('**~', None)
    build.classify('**.bak', None)
    build.classify('**/.**', None)
    build.classify('**/#**', None)
    build.classify('**/thumbs.db', None)
    build.documentation('*.html')
    build.documentation('*.txt')
    
## links
define link.facebook = "https://www.facebook.com/GrandOldAcademy/"
define link.kickstarter = "https://www.kickstarter.com/projects/1313881651/1947682742?token=f3e256af"
define link.twitter = "https://twitter.com/intent/tweet?text=I%27m%20playing%20the%20%23GrandOldAcademy%20demo.%20Dating%20politicians%20has%20never%20been%20so%20fun!%20" + link.kickstarter
define link.tumblr = "http://grandoldacademy.tumblr.com/"

## characters
define c = [
    {
        "name": "America"
        , "bio": "It's you! Mori America is a new transfer student from Japan, trying to fit in at Grand Old Academy. She starts out shy and self-conscious, but soon discovers how strong-willed and compassionate she is. Coincidentally, her first day at the school coincides with the first round of the debate championships. Depending on the choices she makes, she might even engage one lucky debate club member in the greatest debate of all: love."
        , "image": "characters/america.png"
        , "height": "5'2''"
        , "weight": "110 lbs"
        , "eyes": "brown"
        , "age": "18"
    }
    , {
        "name": "Ben"
        , "bio": "Ben is a pre-med student who is warm and gentle above all else. He speaks slowly and softly, and always seems like he might fall asleep. Ben is deeply religious, and sees almost everything through the prism of his faith, which gives him strength, but also leaves him with blind spots. His mild-mannered nature makes him seem out of place on the debate stage, especially in this year of extreme personalities."
        , "image": "characters/ben.png"
        , "height": "5'11''"
        , "weight": "145 lbs"
        , "eyes": "brown"
        , "age": "18"
    }
    , {
        "name": "Donald"
        , "bio": "Donald is a mystery. Nobody can figure out whether he's a fool, or a mastermind disguising himself as a fool. Many of the students seem drawn to him, but just as many are repulsed by him. He's almost a force of nature more than a person. How much of Donald's debate persona is an act, and how much is genuine? Does he really want to win, or is this all just a game to him? Is he brilliant? A fraud? Or a brilliant fraud?"
        , "image": "characters/donald.png"
        , "height": "6'3''"
        , "weight": "210 lbs"
        , "eyes": "blue"
        , "age": "18"
    }
    , {
        "name": "Jeb"
        , "bio": "Jeb is quick to open himself up to others, but he's also quick to be hurt, making him an easy target for bullies. He comes from a prominent family with a long history at the Academy, and the pressure to live up to their reputation weighs on him. Jeb has many acquaintances, but few close friends other than Marco, his protégée and closest confidant. While he may be a bit oblivious and bumbling, he has a kind heart."
        , "image": "characters/jeb.png"
        , "height": "6'3''"
        , "weight": "190 lbs"
        , "eyes": "brown"
        , "age": "18"
    }
    , {
        "name": "John"
        , "bio": "John is blandness incarnate. He's average in the worst way. The very definition of \"literally who?\". His persona is folksy and congenial: lots of dad jokes, and phrases like \"golly,\" \"shucks,\" and \"gee whiz.\" But rumor has it that this might just be an act that he's putting on to charm the debate audience. The only reason people vote for him in the debates is if they can't stand anyone else on the stage."
        , "image": "characters/john.png"
        , "height": "5'9''"
        , "weight": "155 lbs"
        , "eyes": "blue"
        , "age": "18"
    }
    , {
        "name": "Marco"
        , "bio": "Marco is the heartthrob of the Academy. He has a dazzling smile, perfect hair, and a witty quip prepared for every situation. If anything, Marco is too perfect. If you dig underneath the memorized soundbites and smiles, there's not much substance. Dig even further, though, and you'll find an earnest person who wants to make a difference, and who thinks that the only way to do that is by faking this glittery personality."
        , "image": "characters/marco.png"
        , "height": "5'10''"
        , "weight": "160 lbs"
        , "eyes": "brown"
        , "age": "unknown"
    }
    , {
        "name": "Megyn"
        , "bio": "Megyn is your bubbly and mercurial roommate. She's almost always cheerful and optimistic, but she can flash to anger or indignation at the drop of a hat. Megyn is one of the moderators of the school debates, and she takes her role seriously. The way she sees it, Donald made a mockery of the debates, and she has a bone to pick with him."
        , "image": "characters/megyn.png"
        , "height": "5'6''"
        , "weight": "125 lbs"
        , "eyes": "blue"
        , "age": "18"
    }
    , {
        "name": "Newt"
        , "bio": "Newt is a former debater who decided to sit out this year. But he misses the stage, and is wistful for the past. He hitches his star to Donald's wagon early on, and he faithfully defends him against all criticism, often in the face of logic. In return, he hopes that Trump will make him his debate coach, so he can relive that debate glory. He knows the Academy inside and out, and is happy to give advice to new students."
        , "image": "characters/newt.png"
        , "height": "6'0''"
        , "weight": "225 lbs"
        , "eyes": "brown"
        , "age": "18"
    }
    , {
        "name": "Rand"
        , "bio": "Rand is quiet and serious, bordering on dour. He's a nerd who takes his studies seriously, and he doesn't have many friends. He's a very private person. Those who look through old yearbooks may find that his father was also a debate club member back in the day. Despite Rand's usually reserved nature, he's passionate about politics, and this intensity shines through when he has an attentive audience."
        , "image": "characters/rand.png"
        , "height": "4'10''"
        , "weight": "105 lbs"
        , "eyes": "beautiful"
        , "age": "18"
    }
    , {
        "name": "Ted"
        , "bio": "There’s something innately offputting about Ted. Nobody else at the Academy seems to like him, probably for good reason. Ted comes across as slimy and deceitful; he’ll try to win your sympathy by acting pathetic, and then double cross you if it’ll benefit him. When he tries to smile, it looks more like he’s grimacing in pain. He’s hiding something, deep, deep inside himself. Is it a heart of gold, or a terrible secret?"
        , "image": "characters/ted.png"
        , "height": "5'10''"
        , "weight": "170 lbs"
        , "eyes": "soulless"
        , "age": "18"
    }
]

## art
init python:
    art = Gallery()
    art.locked_button = "gui/grid_three_unknown.png"
    art.button("landscape")
    art.image("landscape")
    art.condition("persistent.unlock_art_landscape")
    art.button("aquarium")
    art.image("aquarium")
    art.condition("persistent.unlock_art_aquarium")
    art.button("introduction")
    art.image("introduction")
    art.condition("persistent.unlock_art_introduction")

## music
init python:
    m = MusicRoom(single_track=True)
    m.add("music/Commander-Intro.mp3", always_unlocked=True)
    m.add("music/Committee-Classroom.mp3", always_unlocked=True)
    m.add("music/Convention-Tense.mp3", always_unlocked=True)
    m.add("music/Election-Emotional.mp3", always_unlocked=True)
    m.add("music/Merry-Happy.mp3", always_unlocked=True)
    m.add("music/Presidential-Menu.mp3", always_unlocked=True)

## trophies
    t = Gallery()
    t.locked_button = "gui/grid_three_unknown.png"
    t.button("textbook")
    t.image("textbook")
    t.condition("persistent.unlock_trophies_textbook")
    t.button("card")
    t.image("card")
    t.condition("persistent.unlock_trophies_card")
    t.button("turtle")
    t.image("turtle")
    t.condition("persistent.unlock_trophies_turtle")
    t.button("map")
    t.image("map")
    t.condition("persistent.unlock_trophies_map")
    t.button("bottle")
    t.image("bottle")
    t.condition("persistent.unlock_trophies_bottle")
    t.button("constitution")
    t.image("constitution")
    t.condition("persistent.unlock_trophies_constitution")
    t.button("notebook")
    t.image("notebook")
    t.condition("persistent.unlock_trophies_notebook")
    t.button("id")
    t.image("id")
    t.condition("persistent.unlock_trophies_textbook and persistent.unlock_trophies_card and persistent.unlock_trophies_turtle and persistent.unlock_trophies_map and persistent.unlock_trophies_bottle and persistent.unlock_trophies_constitution and persistent.unlock_trophies_notebook")

     
# default unlockables     

define persistent.unlock_character_America = True
define persistent.unlock_art_landscape = True
define persistent.unlock_music_commander = True
define persistent.unlock_music_presidential = True

# unlock examples
# define persistent.unlock_trophies_constitution = True
